/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.listeners.JobListenerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrailsServiceInjectorJobListener
extends JobListenerSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(GrailsServiceInjectorJobListener.class);
    private String name;
    private Map services;
    private Scheduler quartzScheduler;

    public GrailsServiceInjectorJobListener() {
    }

    public GrailsServiceInjectorJobListener(String name, Map services, Scheduler quartzScheduler) throws SchedulerException {
        this.name = name;
        this.services = services;
        this.setQuartzScheduler(quartzScheduler);
        LOG.info("GrailsServiceInjectorJobListener initialized, added to quartzScheduler");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        context.getJobDetail().getJobDataMap().putAll(this.services);
        LOG.info("services injected for job");
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
    }

    public Map getServices() {
        return this.services;
    }

    public void setServices(Map services) {
        this.services = services;
    }

    public Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    public void setQuartzScheduler(Scheduler quartzScheduler) throws SchedulerException {
        this.quartzScheduler = quartzScheduler;
        quartzScheduler.getListenerManager().addJobListener((JobListener)this);
    }
}

