/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util.imagery;

import org.openstreetmap.josm.tools.Utils;

public final class Vector3D {
    public static final Vector3D DEFAULT_VECTOR_3D = new Vector3D(0.0, 0.0, 1.0);
    private final double x;
    private final double y;
    private final double z;
    private volatile double radialDistance = Double.NaN;
    private volatile double polarAngle = Double.NaN;
    private volatile double polarAngleCos = Double.NaN;
    private volatile double polarAngleSin = Double.NaN;
    private volatile double azimuthalAngle = Double.NaN;
    private volatile double azimuthalAngleCos = Double.NaN;
    private volatile double azimuthalAngleSin = Double.NaN;

    public Vector3D(double x, double y, double z) {
        this(VectorType.XYZ, x, y, z);
    }

    public Vector3D(VectorType vectorType, double first, double second, double third) {
        if (vectorType == VectorType.XYZ) {
            this.x = first;
            this.y = second;
            this.z = third;
        } else {
            this.radialDistance = first;
            if (vectorType == VectorType.RPA) {
                this.azimuthalAngle = third;
                this.polarAngle = second;
            } else {
                this.azimuthalAngle = second;
                this.polarAngle = third;
            }
            this.x = this.radialDistance * this.getAzimuthalAngleCos() * this.getPolarAngleSin();
            this.y = this.radialDistance * this.getAzimuthalAngleSin() * this.getPolarAngleSin();
            this.z = this.radialDistance * this.getPolarAngleCos();
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getRadialDistance() {
        if (Double.isNaN(this.radialDistance)) {
            this.radialDistance = Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
        }
        return this.radialDistance;
    }

    public double getPolarAngle() {
        if (Double.isNaN(this.polarAngle)) {
            this.polarAngle = Math.atan2(this.x, this.z);
        }
        return this.polarAngle;
    }

    public double getPolarAngleCos() {
        if (Double.isNaN(this.polarAngleCos)) {
            this.polarAngleCos = Math.cos(this.getPolarAngle());
        }
        return this.polarAngleCos;
    }

    public double getPolarAngleSin() {
        if (Double.isNaN(this.polarAngleSin)) {
            this.polarAngleSin = Math.sin(this.getPolarAngle());
        }
        return this.polarAngleSin;
    }

    public double getAzimuthalAngle() {
        if (Double.isNaN(this.azimuthalAngle)) {
            if (Double.isNaN(this.radialDistance)) {
                this.getRadialDistance();
            }
            this.azimuthalAngle = this.radialDistance == 0.0 ? 0.0 : Math.acos(this.y / this.radialDistance);
        }
        return this.azimuthalAngle;
    }

    public double getAzimuthalAngleCos() {
        if (Double.isNaN(this.azimuthalAngleCos)) {
            this.azimuthalAngleCos = Math.cos(this.getAzimuthalAngle());
        }
        return this.azimuthalAngleCos;
    }

    public double getAzimuthalAngleSin() {
        if (Double.isNaN(this.azimuthalAngleSin)) {
            this.azimuthalAngleSin = Math.sin(this.getAzimuthalAngle());
        }
        return this.azimuthalAngleSin;
    }

    public Vector3D normalize() {
        double newZ;
        double newY;
        double newX;
        double length = Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
        if (length == 0.0 || Double.isNaN(length)) {
            newX = 0.0;
            newY = 0.0;
            newZ = 0.0;
        } else {
            newX = this.x / length;
            newY = this.y / length;
            newZ = this.z / length;
        }
        return new Vector3D(newX, newY, newZ);
    }

    public int hashCode() {
        return Double.hashCode(this.x) + 31 * Double.hashCode(this.y) + 961 * Double.hashCode(this.z);
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3D) {
            Vector3D other = (Vector3D)o;
            return Utils.equalsEpsilon(this.x, other.x) && Utils.equalsEpsilon(this.y, other.y) && Utils.equalsEpsilon(this.z, other.z);
        }
        return false;
    }

    public String toString() {
        return "[x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", r=" + this.radialDistance + ", inclination=" + this.polarAngle + ", azimuthal=" + this.azimuthalAngle + "]";
    }

    public static enum VectorType {
        XYZ,
        RPA,
        RAP;

    }
}

