/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

@FunctionalInterface
public interface LabelCompositionStrategy {
    public String compose(IPrimitive var1);

    public static class DeriveLabelFromNameTagsCompositionStrategy
    implements LabelCompositionStrategy,
    PreferenceChangedListener {
        private static final String[] DEFAULT_NAME_TAGS = DeriveLabelFromNameTagsCompositionStrategy.getDefaultNameTags();
        private static final String[] DEFAULT_NAME_COMPLEMENT_TAGS = new String[]{"capacity"};
        private List<String> nameTags = new ArrayList<String>();
        private List<String> nameComplementTags = new ArrayList<String>();

        public DeriveLabelFromNameTagsCompositionStrategy() {
            Config.getPref().addPreferenceChangeListener(this);
            this.initNameTagsFromPreferences();
        }

        private static String[] getDefaultNameTags() {
            ArrayList<String> tags = new ArrayList<String>(Arrays.asList(LanguageInfo.getOSMLocaleCodes("name:")));
            tags.addAll(Arrays.asList("name", "int_name", "distance", "railway:position", "ref", "operator", "brand", "addr:unit", "addr:flats", "addr:housenumber"));
            return (String[])tags.toArray(String[]::new);
        }

        private static List<String> buildNameTags(List<String> nameTags) {
            if (nameTags == null) {
                return new ArrayList<String>();
            }
            return nameTags.stream().filter(Predicate.not(Utils::isStripEmpty)).collect(Collectors.toList());
        }

        public void setNameTags(List<String> nameTags) {
            this.nameTags = DeriveLabelFromNameTagsCompositionStrategy.buildNameTags(nameTags);
        }

        public void setNameComplementTags(List<String> nameComplementTags) {
            this.nameComplementTags = DeriveLabelFromNameTagsCompositionStrategy.buildNameTags(nameComplementTags);
        }

        public List<String> getNameTags() {
            return Collections.unmodifiableList(this.nameTags);
        }

        public List<String> getNameComplementTags() {
            return Collections.unmodifiableList(this.nameComplementTags);
        }

        public final void initNameTagsFromPreferences() {
            if (Config.getPref() == null) {
                this.nameTags = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_TAGS));
                this.nameComplementTags = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_COMPLEMENT_TAGS));
            } else {
                this.nameTags = new ArrayList<String>(Config.getPref().getList("mappaint.nameOrder", Arrays.asList(DEFAULT_NAME_TAGS)));
                this.nameComplementTags = new ArrayList<String>(Config.getPref().getList("mappaint.nameComplementOrder", Arrays.asList(DEFAULT_NAME_COMPLEMENT_TAGS)));
            }
        }

        private String getPrimitiveName(IPrimitive n) {
            StringBuilder name = new StringBuilder();
            if (!n.hasKeys()) {
                return null;
            }
            this.nameTags.stream().map(n::get).filter(Objects::nonNull).findFirst().ifPresent(name::append);
            for (String rn : this.nameComplementTags) {
                String comp = n.get(rn);
                if (comp == null) continue;
                if (name.length() == 0) {
                    name.append(comp);
                    break;
                }
                name.append(" (").append(comp).append(')');
                break;
            }
            return name.toString();
        }

        @Override
        public String compose(IPrimitive primitive) {
            if (primitive == null) {
                return null;
            }
            return this.getPrimitiveName(primitive);
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + "}";
        }

        @Override
        public void preferenceChanged(PreferenceChangeEvent e) {
            if (e.getKey() != null && e.getKey().startsWith("mappaint.name")) {
                this.initNameTagsFromPreferences();
            }
        }
    }

    public static class TagLookupCompositionStrategy
    implements LabelCompositionStrategy {
        private final String defaultLabelTag;

        public TagLookupCompositionStrategy(String defaultLabelTag) {
            if (defaultLabelTag != null && (defaultLabelTag = defaultLabelTag.trim()).isEmpty()) {
                defaultLabelTag = null;
            }
            this.defaultLabelTag = defaultLabelTag;
        }

        @Override
        public String compose(IPrimitive primitive) {
            if (this.defaultLabelTag == null) {
                return null;
            }
            if (primitive == null) {
                return null;
            }
            return primitive.get(this.defaultLabelTag);
        }

        public String getDefaultLabelTag() {
            return this.defaultLabelTag;
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + " defaultLabelTag=" + this.defaultLabelTag + "}";
        }

        public int hashCode() {
            return Objects.hash(this.defaultLabelTag);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TagLookupCompositionStrategy that = (TagLookupCompositionStrategy)obj;
            return Objects.equals(this.defaultLabelTag, that.defaultLabelTag);
        }
    }

    public static class StaticLabelCompositionStrategy
    implements LabelCompositionStrategy {
        private final String defaultLabel;

        public StaticLabelCompositionStrategy(String defaultLabel) {
            this.defaultLabel = defaultLabel;
        }

        @Override
        public String compose(IPrimitive primitive) {
            return this.defaultLabel;
        }

        public String getDefaultLabel() {
            return this.defaultLabel;
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + " defaultLabel=" + this.defaultLabel + "}";
        }

        public int hashCode() {
            return Objects.hash(this.defaultLabel);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StaticLabelCompositionStrategy that = (StaticLabelCompositionStrategy)obj;
            return Objects.equals(this.defaultLabel, that.defaultLabel);
        }
    }
}

