/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.Highways;
import org.openstreetmap.josm.tools.I18n;

public class DirectionNodes
extends Test {
    private static final int MULTIPLE_WAYS_CODE = 4000;
    private static final int END_NODE_CODE = 4001;
    private static final int NO_WAY_CODE = 4002;
    private static final int NO_SUITABLE_WAY = 4003;
    private static final String INVALID_USE_MSG = I18n.tr("Invalid usage of direction on node", new Object[0]);
    private static final String DISPUTED_USE_MSG = I18n.tr("Disputed usage of direction on node", new Object[0]);

    public DirectionNodes() {
        super(I18n.tr("Direction nodes", new Object[0]), I18n.tr("Check for nodes which have a ''forward'' or ''backward'' direction", new Object[0]));
    }

    @Override
    public void visit(Node n) {
        if (!n.isUsable() || !n.isTagged()) {
            return;
        }
        for (Map.Entry<String, String> tag : n.getKeys().entrySet()) {
            if (!"forward".equals(tag.getValue()) && !"backward".equals(tag.getValue()) || !"direction".equals(tag.getKey()) && !tag.getKey().endsWith(":direction")) continue;
            this.checkParents(n, tag.getKey() + "=forward|backward");
        }
    }

    private static boolean isSuitableParentWay(Way w) {
        return w.hasKey("highway", "railway", "waterway") || w.hasTag("man_made", "pipeline");
    }

    private void checkParents(Node n, String tag) {
        List minor;
        ArrayList<Way> ways = new ArrayList<Way>();
        int count = 0;
        int countHighWays = 0;
        for (Way w2 : n.getParentWays()) {
            if (DirectionNodes.isSuitableParentWay(w2)) {
                ways.add(w2);
                if (w2.hasKey("highway")) {
                    ++countHighWays;
                }
            }
            ++count;
        }
        if (countHighWays > 1 && (n.hasKey("highway") || n.hasTag("traffic_sign", "city_limit")) && (minor = ways.stream().filter(w -> !w.hasTag("highway", Highways.CLASSIFIED_HIGHWAYS)).collect(Collectors.toList())).size() != countHighWays) {
            ways.removeAll(minor);
        }
        boolean needsParentWays = n.isNew() || !n.isOutsideDownloadArea() && n.getDataSet().getDataSourceArea() != null;
        TestError.Builder builder = null;
        if (ways.isEmpty() && needsParentWays) {
            builder = count == 0 ? TestError.builder(this, Severity.ERROR, 4002).message(INVALID_USE_MSG, I18n.marktr("Unconnected node with {0}. Use angle or cardinal direction"), tag) : TestError.builder(this, Severity.WARNING, 4003).message(INVALID_USE_MSG, I18n.marktr("Node with {0} should be connected to a linear way"), tag);
        } else if (ways.size() == 1) {
            Way w3 = (Way)ways.get(0);
            if (w3.firstNode() == n || w3.lastNode() == n) {
                builder = TestError.builder(this, Severity.OTHER, 4001).message(DISPUTED_USE_MSG, I18n.marktr("Node with {0} on end of way"), tag);
            }
        } else if (ways.size() > 1) {
            builder = TestError.builder(this, Severity.OTHER, 4000).message(DISPUTED_USE_MSG, I18n.marktr("Node with {0} on a connection of multiple ways"), tag);
        }
        if (builder != null) {
            ArrayList<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>();
            primitives.add(n);
            primitives.addAll(ways);
            this.errors.add(builder.primitives(primitives).highlight(n).build());
        }
    }
}

