/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.radutil;

import com.axlradius.radclient4.radutil.SnoopRecord;
import com.axlradius.radclient4.radutil.Util;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SnoopReader {
    private static final byte[] ae = new byte[]{115, 110, 111, 111, 112, 0, 0, 0};
    public static final int ETHERNET = 4;
    private DataInputStream in;

    public static void main(String[] object) {
        try {
            SnoopRecord snoopRecord;
            object = new BufferedInputStream(new FileInputStream(object[0]));
            object = new SnoopReader((InputStream)object);
            int n2 = 0;
            while ((snoopRecord = ((SnoopReader)object).next()) != null) {
                System.out.println("#" + n2 + " " + snoopRecord);
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public SnoopReader(InputStream object) throws IOException {
        this.in = new DataInputStream((InputStream)object);
        object = this;
        byte[] byArray = new byte[8];
        ((SnoopReader)object).in.read(byArray);
        if (!Util.cmp(byArray, ae)) {
            throw new IOException("Not a Snoop file");
        }
        int n2 = ((SnoopReader)object).in.readInt();
        if (n2 != 2) {
            throw new IOException("Incorrect Snoop file version - " + n2 + " expecting 2");
        }
        if (((SnoopReader)object).in.readInt() != 4) {
            throw new IOException("Can't decode anything but Ethernet packets.");
        }
    }

    public SnoopRecord next() throws IOException {
        SnoopRecord snoopRecord;
        try {
            int n2 = this.in.readInt();
            int n3 = this.in.readInt();
            int n4 = this.in.readInt();
            int n5 = this.in.readInt();
            int n6 = this.in.readInt();
            int n7 = this.in.readInt();
            snoopRecord = new SnoopRecord(n2, n3, n4, n5, n6, n7);
            byte[] byArray = new byte[n4 - 24];
            this.in.read(byArray);
            snoopRecord.setData(byArray);
        }
        catch (EOFException eOFException) {
            return null;
        }
        return snoopRecord;
    }
}

