/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.internal.util.Lazy;
import io.jenetics.internal.util.reflect;
import io.jenetics.util.Verifiable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

public final class Phenotype<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Comparable<Phenotype<G, C>>,
Verifiable,
Serializable,
Runnable {
    private static final long serialVersionUID = 5L;
    private final transient Function<? super Genotype<G>, ? extends C> _function;
    private final transient Function<? super C, ? extends C> _scaler;
    private final Genotype<G> _genotype;
    private final long _generation;
    private final Lazy<C> _rawFitness;
    private final Lazy<C> _fitness;

    private Phenotype(Genotype<G> genotype, long generation, Function<? super Genotype<G>, ? extends C> function, Function<? super C, ? extends C> scaler, C rawFitness) {
        this._genotype = Objects.requireNonNull(genotype, "Genotype");
        this._function = Objects.requireNonNull(function, "Fitness function");
        this._scaler = Objects.requireNonNull(scaler, "Fitness scaler");
        if (generation < 0L) {
            throw new IllegalArgumentException(String.format("Generation must not < 0 and was %s.", generation));
        }
        this._generation = generation;
        if (rawFitness != null) {
            this._rawFitness = Lazy.ofValue(rawFitness);
            this._fitness = Lazy.ofValue(scaler.apply(rawFitness));
        } else {
            this._rawFitness = Lazy.of(() -> (Comparable)this._function.apply(this._genotype));
            this._fitness = Lazy.of(() -> (Comparable)this._scaler.apply(this._rawFitness.get()));
        }
    }

    public Genotype<G> getGenotype() {
        return this._genotype;
    }

    public Phenotype<G, C> evaluate() {
        this.getFitness();
        return this;
    }

    public boolean isEvaluated() {
        return this._fitness.isEvaluated();
    }

    @Override
    public void run() {
        this.evaluate();
    }

    public Function<? super Genotype<G>, ? extends C> getFitnessFunction() {
        return this._function;
    }

    public Function<? super C, ? extends C> getFitnessScaler() {
        return this._scaler;
    }

    public C getFitness() {
        return (C)((Comparable)this._fitness.get());
    }

    public C getRawFitness() {
        return (C)((Comparable)this._rawFitness.get());
    }

    public long getGeneration() {
        return this._generation;
    }

    public long getAge(long currentGeneration) {
        return currentGeneration - this._generation;
    }

    @Override
    public boolean isValid() {
        return this._genotype.isValid();
    }

    @Override
    public int compareTo(Phenotype<G, C> pt) {
        return this.getFitness().compareTo(pt.getFitness());
    }

    public int hashCode() {
        int hash = 17;
        hash = (int)((long)hash + (31L * this._generation + 37L));
        hash += 31 * Objects.hashCode(this.getFitness()) + 37;
        hash += 31 * Objects.hashCode(this.getRawFitness()) + 37;
        return hash += 31 * this._genotype.hashCode() + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Phenotype && Objects.equals(this.getFitness(), ((Phenotype)obj).getFitness()) && Objects.equals(this.getRawFitness(), ((Phenotype)obj).getRawFitness()) && Objects.equals(this._genotype, ((Phenotype)obj)._genotype) && this._generation == ((Phenotype)obj)._generation;
    }

    public String toString() {
        return this._genotype + " --> " + this.getFitness();
    }

    public Phenotype<G, C> withFitness(C fitness) {
        return Phenotype.of(this._genotype, this._generation, this._function, this._scaler, fitness);
    }

    public Phenotype<G, C> newInstance(Genotype<G> genotype) {
        return Phenotype.of(genotype, this._generation, this._function, this._scaler);
    }

    public Phenotype<G, C> newInstance(Genotype<G> genotype, long generation) {
        return Phenotype.of(genotype, generation, this._function, this._scaler);
    }

    public Phenotype<G, C> newInstance(long generation, Function<? super Genotype<G>, ? extends C> function, Function<? super C, ? extends C> scaler) {
        return Phenotype.of(this._genotype, generation, function, scaler);
    }

    public Phenotype<G, C> newInstance(long generation, Function<? super Genotype<G>, ? extends C> function) {
        return Phenotype.of(this._genotype, generation, function, a -> a);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Phenotype<G, C> of(Genotype<G> genotype, long generation, Function<? super Genotype<G>, C> function) {
        return Phenotype.of(genotype, generation, function, function instanceof Serializable ? (Function<Comparable, Comparable> & Serializable & Function)a -> a : a -> a);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Phenotype<G, C> of(Genotype<G> genotype, long generation, Function<? super Genotype<G>, ? extends C> function, Function<? super C, ? extends C> scaler) {
        return new Phenotype<G, Object>(genotype, generation, function, scaler, null);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Phenotype<G, C> of(Genotype<G> genotype, long generation, Function<? super Genotype<G>, ? extends C> function, Function<? super C, ? extends C> scaler, C rawFitness) {
        return new Phenotype<G, C>(genotype, generation, function, scaler, Objects.requireNonNull(rawFitness));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeLong(this.getGeneration());
        out.writeObject(this.getGenotype());
        out.writeObject(this.getFitness());
        out.writeObject(this.getRawFitness());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        reflect.setField(this, "_generation", in.readLong());
        reflect.setField(this, "_genotype", in.readObject());
        reflect.setField(this, "_fitness", Lazy.ofValue(in.readObject()));
        reflect.setField(this, "_rawFitness", Lazy.ofValue(in.readObject()));
        reflect.setField(this, "_function", Function.identity());
        reflect.setField(this, "_scaler", Function.identity());
    }
}

