/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session.cache;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.broadcast.BroadcastInterface;
import org.traccar.broadcast.BroadcastService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Attribute;
import org.traccar.model.BaseModel;
import org.traccar.model.Calendar;
import org.traccar.model.Device;
import org.traccar.model.Driver;
import org.traccar.model.Geofence;
import org.traccar.model.Group;
import org.traccar.model.GroupedModel;
import org.traccar.model.Maintenance;
import org.traccar.model.Notification;
import org.traccar.model.ObjectOperation;
import org.traccar.model.Permission;
import org.traccar.model.Position;
import org.traccar.model.Schedulable;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.session.cache.CacheGraph;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class CacheManager
implements BroadcastInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheManager.class);
    private static final Set<Class<? extends BaseModel>> GROUPED_CLASSES = Set.of(Attribute.class, Driver.class, Geofence.class, Maintenance.class, Notification.class);
    private final Config config;
    private final Storage storage;
    private final BroadcastService broadcastService;
    private final CacheGraph graph = new CacheGraph();
    private volatile Server server;
    private final Map<Long, ConcurrentLinkedDeque<Position>> devicePositions = new ConcurrentHashMap<Long, ConcurrentLinkedDeque<Position>>();
    private final Map<Long, HashSet<Object>> deviceReferences = new ConcurrentHashMap<Long, HashSet<Object>>();

    @Inject
    public CacheManager(Config config, Storage storage, BroadcastService broadcastService) throws StorageException {
        this.config = config;
        this.storage = storage;
        this.broadcastService = broadcastService;
        this.server = storage.getObject(Server.class, new Request(new Columns.All()));
        broadcastService.registerListener(this);
    }

    public String toString() {
        return this.graph.toString();
    }

    public Config getConfig() {
        return this.config;
    }

    public <T extends BaseModel> T getObject(Class<T> clazz, long id) {
        return this.graph.getObject(clazz, id);
    }

    public <T extends BaseModel> Set<T> getDeviceObjects(long deviceId, Class<T> clazz) {
        return this.graph.getObjects(Device.class, deviceId, clazz, Set.of(Group.class), true).collect(Collectors.toUnmodifiableSet());
    }

    public Position getPosition(long deviceId) {
        ConcurrentLinkedDeque<Position> positions = this.devicePositions.get(deviceId);
        return positions != null ? positions.peekLast() : null;
    }

    public Deque<Position> getPositions(long deviceId) {
        return this.devicePositions.computeIfAbsent(deviceId, k -> new ConcurrentLinkedDeque());
    }

    public Server getServer() {
        return this.server;
    }

    public Set<User> getNotificationUsers(long notificationId, long deviceId) {
        Set<User> deviceUsers = this.getDeviceObjects(deviceId, User.class);
        return this.graph.getObjects(Notification.class, notificationId, User.class, Set.of(), false).filter(deviceUsers::contains).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Notification> getDeviceNotifications(long deviceId) {
        Set direct = this.graph.getObjects(Device.class, deviceId, Notification.class, Set.of(Group.class), true).map(BaseModel::getId).collect(Collectors.toUnmodifiableSet());
        return this.graph.getObjects(Device.class, deviceId, Notification.class, Set.of(Group.class, User.class), true).filter(notification -> notification.getAlways() || direct.contains(notification.getId())).collect(Collectors.toUnmodifiableSet());
    }

    public synchronized void addDevice(long deviceId, Object key) throws Exception {
        HashSet references = this.deviceReferences.computeIfAbsent(deviceId, k -> new HashSet());
        if (references.isEmpty()) {
            Position position;
            Device device = this.storage.getObject(Device.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", deviceId)));
            this.graph.addObject(device);
            this.initializeCache(device);
            if (device.getPositionId() > 0L && (position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", device.getPositionId())))) != null) {
                ConcurrentLinkedDeque positions = this.devicePositions.computeIfAbsent(deviceId, k -> new ConcurrentLinkedDeque());
                if (this.config.getBoolean(Keys.REPORT_TRIP_NEW_LOGIC)) {
                    long minDuration = AttributeUtil.lookup(this, Keys.REPORT_TRIP_MIN_DURATION, deviceId) * 1000L;
                    Date from = new Date(position.getFixTime().getTime() - minDuration);
                    Date to = position.getFixTime();
                    try (Stream<Position> positionsStream = PositionUtil.getPositionsStreamWithExtra(this.storage, deviceId, from, to);){
                        positionsStream.forEach(positions::add);
                    }
                } else {
                    positions.add(position);
                }
            }
        }
        references.add(key);
        LOGGER.debug("Cache add device {} references {} key {}", new Object[]{deviceId, references.size(), key});
    }

    public synchronized void removeDevice(long deviceId, Object key) {
        HashSet references = this.deviceReferences.computeIfAbsent(deviceId, k -> new HashSet());
        references.remove(key);
        if (references.isEmpty()) {
            this.graph.removeObject(Device.class, deviceId);
            this.devicePositions.remove(deviceId);
            this.deviceReferences.remove(deviceId);
        }
        LOGGER.debug("Cache remove device {} references {} key {}", new Object[]{deviceId, references.size(), key});
    }

    public void updatePosition(Position position) {
        this.deviceReferences.computeIfPresent(position.getDeviceId(), (key, oldValue) -> {
            ConcurrentLinkedDeque positions = this.devicePositions.computeIfAbsent((Long)key, k -> new ConcurrentLinkedDeque());
            positions.add(position);
            if (this.config.getBoolean(Keys.REPORT_TRIP_NEW_LOGIC)) {
                long minDuration = AttributeUtil.lookup(this, Keys.REPORT_TRIP_MIN_DURATION, key) * 1000L;
                while (positions.size() > 1) {
                    Iterator iterator = positions.iterator();
                    iterator.next();
                    Position second = (Position)iterator.next();
                    Position last = (Position)positions.peekLast();
                    if (last.getFixTime().getTime() - second.getFixTime().getTime() >= minDuration) {
                        positions.poll();
                        continue;
                    }
                    break;
                }
            } else {
                while (positions.size() > 1) {
                    positions.poll();
                }
            }
            return oldValue;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends BaseModel> void invalidateObject(boolean local, Class<T> clazz, long id, ObjectOperation operation) throws Exception {
        if (local) {
            this.broadcastService.invalidateObject(true, clazz, id, operation);
        }
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            long afterCalendarId;
            long beforeCalendarId;
            if (operation == ObjectOperation.DELETE) {
                this.graph.removeObject(clazz, id);
            }
            if (operation != ObjectOperation.UPDATE) {
                return;
            }
            if (clazz.equals(Server.class)) {
                this.server = this.storage.getObject(Server.class, new Request(new Columns.All()));
                return;
            }
            BaseModel after = (BaseModel)this.storage.getObject(clazz, new Request((Columns)new Columns.All(), new Condition.Equals("id", id)));
            if (after == null) {
                return;
            }
            Object before = this.getObject(after.getClass(), after.getId());
            if (before == null) {
                return;
            }
            if (after instanceof GroupedModel) {
                long afterGroupId;
                long beforeGroupId = ((GroupedModel)before).getGroupId();
                if (beforeGroupId != (afterGroupId = ((GroupedModel)after).getGroupId())) {
                    if (beforeGroupId > 0L) {
                        this.invalidatePermission(clazz, id, Group.class, beforeGroupId, false);
                    }
                    if (afterGroupId > 0L) {
                        this.invalidatePermission(clazz, id, Group.class, afterGroupId, true);
                    }
                }
            } else if (after instanceof Schedulable && (beforeCalendarId = ((Schedulable)before).getCalendarId()) != (afterCalendarId = ((Schedulable)((Object)after)).getCalendarId())) {
                if (beforeCalendarId > 0L) {
                    this.invalidatePermission(clazz, id, Calendar.class, beforeCalendarId, false);
                }
                if (afterCalendarId > 0L) {
                    this.invalidatePermission(clazz, id, Calendar.class, afterCalendarId, true);
                }
            }
            this.graph.updateObject(after);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T1 extends BaseModel, T2 extends BaseModel> void invalidatePermission(boolean local, Class<T1> clazz1, long id1, Class<T2> clazz2, long id2, boolean link) throws Exception {
        if (local) {
            this.broadcastService.invalidatePermission(true, clazz1, id1, clazz2, id2, link);
        }
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            if (clazz1.equals(User.class) && GroupedModel.class.isAssignableFrom(clazz2)) {
                this.invalidatePermission(clazz2, id2, clazz1, id1, link);
            } else {
                this.invalidatePermission(clazz1, id1, clazz2, id2, link);
            }
        }
    }

    private <T1 extends BaseModel, T2 extends BaseModel> void invalidatePermission(Class<T1> fromClass, long fromId, Class<T2> toClass, long toId, boolean link) throws Exception {
        boolean groupedLinks;
        boolean groupLink = GroupedModel.class.isAssignableFrom(fromClass) && toClass.equals(Group.class);
        boolean calendarLink = Schedulable.class.isAssignableFrom(fromClass) && toClass.equals(Calendar.class);
        boolean userLink = fromClass.equals(User.class) && toClass.equals(Notification.class);
        boolean bl = groupedLinks = GroupedModel.class.isAssignableFrom(fromClass) && (GROUPED_CLASSES.contains(toClass) || toClass.equals(User.class));
        if (!(groupLink || calendarLink || userLink || groupedLinks)) {
            return;
        }
        if (link) {
            if (!this.graph.addLink(fromClass, fromId, toClass, toId, this.createObjectSupplier(toClass, toId))) {
                this.initializeCache((BaseModel)this.graph.getObject(toClass, toId));
            }
        } else {
            this.graph.removeLink(fromClass, fromId, toClass, toId);
        }
    }

    private void initializeCache(BaseModel object) throws Exception {
        if (object instanceof User) {
            for (Permission permission : this.storage.getPermissions(User.class, Notification.class)) {
                if (permission.getOwnerId() != object.getId()) continue;
                this.invalidatePermission(permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId(), true);
            }
        } else {
            Schedulable schedulable;
            long calendarId;
            if (object instanceof GroupedModel) {
                GroupedModel groupedModel = (GroupedModel)object;
                long groupId = groupedModel.getGroupId();
                if (groupId > 0L) {
                    this.invalidatePermission(object.getClass(), object.getId(), Group.class, groupId, true);
                }
                for (Permission permission : this.storage.getPermissions(User.class, object.getClass())) {
                    if (permission.getPropertyId() != object.getId()) continue;
                    this.invalidatePermission(object.getClass(), object.getId(), User.class, permission.getOwnerId(), true);
                }
                for (Class clazz : GROUPED_CLASSES) {
                    for (Permission permission : this.storage.getPermissions(object.getClass(), clazz)) {
                        if (permission.getOwnerId() != object.getId()) continue;
                        this.invalidatePermission(object.getClass(), object.getId(), clazz, permission.getPropertyId(), true);
                    }
                }
            }
            if (object instanceof Schedulable && (calendarId = (schedulable = (Schedulable)((Object)object)).getCalendarId()) > 0L) {
                this.invalidatePermission(object.getClass(), object.getId(), Calendar.class, calendarId, true);
            }
        }
    }

    private <T> Supplier<T> createObjectSupplier(Class<T> clazz, long id) {
        return () -> {
            try {
                return this.storage.getObject(clazz, new Request((Columns)new Columns.All(), new Condition.Equals("id", id)));
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

