/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TelemaxProtocolDecoder
extends BaseProtocolDecoder {
    public TelemaxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String readValue(String sentence, int[] index, int length) {
        String value = sentence.substring(index[0], index[0] + length);
        index[0] = index[0] + length;
        return value;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("%")) {
            int length = Integer.parseInt(sentence.substring(1, 3));
            this.getDeviceSession(channel, remoteAddress, sentence.substring(3, 3 + length));
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        int[] index = new int[]{0};
        if (!this.readValue(sentence, index, 1).equals("Y")) {
            return null;
        }
        this.readValue(sentence, index, 8);
        this.readValue(sentence, index, 6);
        this.readValue(sentence, index, Integer.parseInt(this.readValue(sentence, index, 2), 16));
        this.readValue(sentence, index, 2);
        this.readValue(sentence, index, 2);
        int interval = Integer.parseInt(this.readValue(sentence, index, 4), 16);
        this.readValue(sentence, index, 2);
        this.readValue(sentence, index, 2);
        int count = Integer.parseInt(this.readValue(sentence, index, 2), 16);
        Date time = null;
        LinkedList<Position> positions = new LinkedList<Position>();
        for (int i = 0; i < count; ++i) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            int speed = Integer.parseInt(this.readValue(sentence, index, 2), 16);
            position.setValid(BitUtil.check(speed, 7));
            position.setSpeed(BitUtil.to(speed, 7));
            position.setLongitude((double)(Integer.parseInt(this.readValue(sentence, index, 6), 16) - 5400000) / 30000.0);
            position.setLatitude((double)(Integer.parseInt(this.readValue(sentence, index, 6), 16) - 5400000) / 30000.0);
            if (i == 0 | i == count - 1) {
                time = new SimpleDateFormat("yyMMddHHmmss").parse(this.readValue(sentence, index, 12));
                position.set("status", this.readValue(sentence, index, 8));
            } else {
                time = new Date(time.getTime() + (long)(interval * 1000));
            }
            position.setTime(time);
            positions.add(position);
        }
        return positions;
    }
}

