/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.traccar.database.LocaleManager;
import org.traccar.helper.model.UserUtil;
import org.traccar.model.Device;
import org.traccar.model.Driver;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Maintenance;
import org.traccar.model.Notification;
import org.traccar.model.Position;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.notification.NotificationMessage;
import org.traccar.notification.TextTemplateFormatter;
import org.traccar.session.cache.CacheManager;

@Singleton
public class NotificationFormatter {
    private final LocaleManager localeManager;
    private final CacheManager cacheManager;
    private final TextTemplateFormatter textTemplateFormatter;

    @Inject
    public NotificationFormatter(LocaleManager localeManager, CacheManager cacheManager, TextTemplateFormatter textTemplateFormatter) {
        this.localeManager = localeManager;
        this.cacheManager = cacheManager;
        this.textTemplateFormatter = textTemplateFormatter;
    }

    public NotificationMessage formatMessage(Notification notification, User user, Event event, Position position) {
        String driverUniqueId;
        Server server = this.cacheManager.getServer();
        Device device = this.cacheManager.getObject(Device.class, event.getDeviceId());
        VelocityContext velocityContext = this.textTemplateFormatter.prepareContext(server, user);
        velocityContext.put("notification", (Object)notification);
        velocityContext.put("device", (Object)device);
        velocityContext.put("event", (Object)event);
        velocityContext.put("translations", this.localeManager.getBundle(UserUtil.getLanguage(server, user)));
        if (position != null) {
            velocityContext.put("position", (Object)position);
            velocityContext.put("speedUnit", (Object)UserUtil.getSpeedUnit(server, user));
            velocityContext.put("distanceUnit", (Object)UserUtil.getDistanceUnit(server, user));
            velocityContext.put("volumeUnit", (Object)UserUtil.getVolumeUnit(server, user));
        }
        if (event.getGeofenceId() != 0L) {
            velocityContext.put("geofence", (Object)this.cacheManager.getObject(Geofence.class, event.getGeofenceId()));
        }
        if (event.getMaintenanceId() != 0L) {
            velocityContext.put("maintenance", (Object)this.cacheManager.getObject(Maintenance.class, event.getMaintenanceId()));
        }
        if ((driverUniqueId = event.getString("driverUniqueId")) != null) {
            velocityContext.put("driver", this.cacheManager.getDeviceObjects(device.getId(), Driver.class).stream().filter(driver -> driver.getUniqueId().equals(driverUniqueId)).findFirst().orElse(null));
        }
        boolean priority = notification != null && notification.getBoolean("priority");
        return this.textTemplateFormatter.formatMessage(velocityContext, event.getType(), priority);
    }
}

