/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.AbstractTransaction;
import redis.clients.jedis.BinaryJedisShardedPubSub;
import redis.clients.jedis.ClusterCommandObjects;
import redis.clients.jedis.ClusterPipeline;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisShardedPubSub;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.builders.ClusterClientBuilder;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.executors.ClusterCommandExecutor;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.providers.ClusterConnectionProvider;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.util.JedisClusterCRC16;

public class RedisClusterClient
extends UnifiedJedis {
    public static final String INIT_NO_ERROR_PROPERTY = "jedis.cluster.initNoError";
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_MAX_ATTEMPTS = 5;

    private RedisClusterClient(CommandExecutor commandExecutor, ConnectionProvider connectionProvider, CommandObjects commandObjects, RedisProtocol redisProtocol, Cache cache) {
        super(commandExecutor, connectionProvider, commandObjects, redisProtocol, cache);
    }

    public static RedisClusterClient create(HostAndPort node) {
        return (RedisClusterClient)((ClusterClientBuilder)RedisClusterClient.builder().nodes(Collections.singleton(node)).clientConfig(DefaultJedisClientConfig.builder().timeoutMillis(2000).build())).maxAttempts(5).maxTotalRetriesDuration(Duration.ofMillis(10000L)).build();
    }

    public static RedisClusterClient create(Set<HostAndPort> nodes) {
        return (RedisClusterClient)((ClusterClientBuilder)RedisClusterClient.builder().nodes(nodes).clientConfig(DefaultJedisClientConfig.builder().timeoutMillis(2000).build())).maxAttempts(5).maxTotalRetriesDuration(Duration.ofMillis(10000L)).build();
    }

    public static RedisClusterClient create(Set<HostAndPort> nodes, String user, String password) {
        return (RedisClusterClient)((ClusterClientBuilder)RedisClusterClient.builder().nodes(nodes).clientConfig(DefaultJedisClientConfig.builder().user(user).password(password).build())).maxAttempts(5).maxTotalRetriesDuration(Duration.ofMillis(10000L)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, ConnectionPool> getClusterNodes() {
        return ((ClusterConnectionProvider)this.provider).getNodes();
    }

    public Connection getConnectionFromSlot(int slot) {
        return ((ClusterConnectionProvider)this.provider).getConnectionFromSlot(slot);
    }

    public long spublish(String channel, String message) {
        return this.executeCommand(this.commandObjects.spublish(channel, message));
    }

    public long spublish(byte[] channel, byte[] message) {
        return this.executeCommand(this.commandObjects.spublish(channel, message));
    }

    public void ssubscribe(JedisShardedPubSub jedisPubSub, String ... channels) {
        try (Connection connection = this.getConnectionFromSlot(JedisClusterCRC16.getSlot(channels[0]));){
            jedisPubSub.proceed(connection, channels);
        }
    }

    public void ssubscribe(BinaryJedisShardedPubSub jedisPubSub, byte[] ... channels) {
        try (Connection connection = this.getConnectionFromSlot(JedisClusterCRC16.getSlot(channels[0]));){
            jedisPubSub.proceed(connection, (T[])channels);
        }
    }

    @Override
    public ClusterPipeline pipelined() {
        return new ClusterPipeline((ClusterConnectionProvider)this.provider, (ClusterCommandObjects)this.commandObjects);
    }

    @Override
    public AbstractTransaction transaction(boolean doMulti) {
        throw new UnsupportedOperationException();
    }

    public final <T> T executeCommandToReplica(CommandObject<T> commandObject) {
        if (!(this.executor instanceof ClusterCommandExecutor)) {
            throw new UnsupportedOperationException("Support only execute to replica in ClusterCommandExecutor");
        }
        return ((ClusterCommandExecutor)this.executor).executeCommandToReplica(commandObject);
    }

    public static class Builder
    extends ClusterClientBuilder<RedisClusterClient> {
        @Override
        protected RedisClusterClient createClient() {
            return new RedisClusterClient(this.commandExecutor, this.connectionProvider, this.commandObjects, this.clientConfig.getRedisProtocol(), this.cache);
        }
    }
}

