/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.authorization;

import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.common.IFrameworkNodes;
import com.dtolabs.rundeck.core.common.INodeSet;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.rundeck.app.authorization.AppAuthContextEvaluator;
import org.rundeck.app.authorization.AuthCache;
import org.rundeck.app.authorization.BaseAuthContextEvaluator;
import org.rundeck.core.auth.AuthConstants;
import rundeck.Execution;
import rundeck.ScheduledExecution;

public class BaseAuthContextEvaluator
implements AppAuthContextEvaluator,
GroovyObject {
    private AuthCache authContextEvaluatorCacheManager;
    private IFrameworkNodes nodeSupport;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public BaseAuthContextEvaluator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public boolean authorizeApplicationResourceTypeAll(AuthContext authContext, String resourceType, Collection<String> actions) {
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        Set decisions = this.authContextEvaluatorCacheManager.evaluate(authContext, (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthorizationUtil.resourceType((String)resourceType)}), Set.class), (Set)ScriptBytecodeAdapter.asType(actions, Set.class), null);
        return !DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find((Collection)decisions, (Closure)new _authorizeApplicationResourceTypeAll_closure1((Object)this, (Object)this)));
    }

    public boolean authorizeApplicationResource(AuthContext authContext, Map<String, String> resource, String action) {
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        Decision decision = this.authContextEvaluatorCacheManager.evaluate(authContext, resource, action, null);
        return decision.isAuthorized();
    }

    public Set<Map<String, String>> authorizeApplicationResourceSet(AuthContext authContext, Set<Map<String, String>> resources, Set<String> actions) {
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        if (resources.size() < 1) {
            return new HashSet<Map<String, String>>();
        }
        HashSet<Map<String, String>> authed = new HashSet<Map<String, String>>();
        Set<Map<String, String>> set = resources;
        Iterator<Map<String, String>> iterator = set != null ? set.iterator() : null;
        Map<String, String> res = null;
        Iterator<Map<String, String>> iterator2 = iterator;
        if (iterator2 != null) {
            block0: while (iterator2.hasNext()) {
                res = iterator2.next();
                String act = null;
                Set<String> set2 = actions;
                Iterator<String> iterator3 = set2 != null ? set2.iterator() : null;
                if (iterator3 == null) continue;
                while (iterator3.hasNext()) {
                    act = iterator3.next();
                    if (!this.authContextEvaluatorCacheManager.evaluate(authContext, (Map)ScriptBytecodeAdapter.castToType(res, Map.class), ShortTypeHandling.castToString((Object)act), null).isAuthorized()) continue;
                    DefaultGroovyMethods.leftShift(authed, res);
                    continue block0;
                }
            }
        }
        return authed;
    }

    public boolean authorizeApplicationResourceAll(AuthContext authContext, Map<String, String> resource, Collection<String> actions) {
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        Set decisions = this.authContextEvaluatorCacheManager.evaluate(authContext, (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{resource}), Set.class), (Set)ScriptBytecodeAdapter.asType(actions, Set.class), null);
        return !DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find((Collection)decisions, (Closure)new _authorizeApplicationResourceAll_closure2((Object)this, (Object)this)));
    }

    /*
     * WARNING - void declaration
     */
    public boolean authorizeApplicationResourceAny(AuthContext authContext, Map<String, String> resource, List<String> actions) {
        void var2_2;
        Reference authContext2 = new Reference((Object)authContext);
        Reference resource2 = new Reference((Object)var2_2);
        return DefaultGroovyMethods.any(actions, (Closure)new _authorizeApplicationResourceAny_closure3((Object)this, (Object)this, authContext2, resource2));
    }

    public boolean authorizeApplicationResourceType(AuthContext authContext, String resourceType, String action) {
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        Decision decision = this.authContextEvaluatorCacheManager.evaluate(authContext, AuthorizationUtil.resourceType((String)resourceType), action, null);
        return decision.isAuthorized();
    }

    public Set<Decision> authorizeProjectResources(AuthContext authContext, Set<Map<String, String>> resources, Set<String> actions, String project) {
        if (project == null) {
            throw (Throwable)new IllegalArgumentException("null project");
        }
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        return resources.size() > 0 ? this.authContextEvaluatorCacheManager.evaluate(authContext, resources, actions, project) : new HashSet<Decision>();
    }

    public boolean authorizeProjectResource(AuthContext authContext, Map<String, String> resource, String action, String project) {
        if (project == null) {
            throw (Throwable)new IllegalArgumentException("null project");
        }
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        Decision decision = this.authContextEvaluatorCacheManager.evaluate(authContext, resource, action, project);
        return decision.isAuthorized();
    }

    public boolean authorizeProjectResourceAll(AuthContext authContext, Map<String, String> resource, Collection<String> actions, String project) {
        if (project == null) {
            throw (Throwable)new IllegalArgumentException("null project");
        }
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        Set decisions = this.authContextEvaluatorCacheManager.evaluate(authContext, (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{resource}), Set.class), (Set)ScriptBytecodeAdapter.asType(actions, Set.class), project);
        return !DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find((Collection)decisions, (Closure)new _authorizeProjectResourceAll_closure4((Object)this, (Object)this)));
    }

    public boolean authorizeProjectResourceAny(AuthContext authContext, Map<String, String> resource, Collection<String> actions, String project) {
        if (project == null) {
            throw (Throwable)new IllegalArgumentException("null project");
        }
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        Set decisions = this.authContextEvaluatorCacheManager.evaluate(authContext, (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{resource}), Set.class), (Set)ScriptBytecodeAdapter.asType(actions, Set.class), project);
        return DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find((Collection)decisions, (Closure)new _authorizeProjectResourceAny_closure5((Object)this, (Object)this)));
    }

    public Map<String, String> authResourceForProject(String name) {
        return AuthorizationUtil.resource((String)AuthConstants.TYPE_PROJECT, (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name}));
    }

    public Map<String, String> authResourceForProjectAcl(String name) {
        return AuthorizationUtil.resource((String)AuthConstants.TYPE_PROJECT_ACL, (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name}));
    }

    public Map<String, String> authResourceForJob(ScheduledExecution se) {
        return this.authResourceForJob(se.getJobName(), se.getGroupPath(), se.getExtid());
    }

    public Map<String, String> authResourceForJob(String name, String groupPath, String uuid) {
        String string = groupPath;
        return AuthorizationUtil.resource((String)AuthConstants.TYPE_JOB, (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name, "group", DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "", "uuid", uuid}));
    }

    public boolean authorizeProjectExecutionAll(AuthContext authContext, Execution exec, Collection<String> actions) {
        ScheduledExecution se = exec.getScheduledExecution();
        return DefaultTypeTransformation.booleanUnbox((Object)se) ? this.authorizeProjectJobAll(authContext, se, actions, se.getProject()) : this.authorizeProjectResourceAll(authContext, AuthConstants.RESOURCE_ADHOC, actions, exec.getProject());
    }

    public boolean authorizeProjectExecutionAny(AuthContext authContext, Execution exec, Collection<String> actions) {
        ScheduledExecution se = exec.getScheduledExecution();
        return DefaultTypeTransformation.booleanUnbox((Object)se) ? this.authorizeProjectJobAny(authContext, se, actions, se.getProject()) : this.authorizeProjectResourceAny(authContext, AuthConstants.RESOURCE_ADHOC, actions, exec.getProject());
    }

    /*
     * WARNING - void declaration
     */
    public List<Execution> filterAuthorizedProjectExecutionsAll(AuthContext authContext, List<Execution> execs, Collection<String> actions) {
        void var3_3;
        Reference authContext2 = new Reference((Object)authContext);
        Reference actions2 = new Reference((Object)var3_3);
        Reference semap = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        Reference adhocauth = new Reference(null);
        Reference results = new Reference((Object)((ArrayList)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), ArrayList.class)));
        DefaultGroovyMethods.each(execs, (Closure)new _filterAuthorizedProjectExecutionsAll_closure6((Object)this, (Object)this, semap, authContext2, actions2, adhocauth, results));
        return (ArrayList)results.get();
    }

    /*
     * WARNING - void declaration
     */
    public boolean authorizeProjectJobAny(AuthContext authContext, ScheduledExecution job, Collection<String> actions, String project) {
        void var2_2;
        Reference authContext2 = new Reference((Object)authContext);
        Reference job2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)project);
        return DefaultGroovyMethods.any(actions, (Closure)new _authorizeProjectJobAny_closure7((Object)this, (Object)this, authContext2, job2, project2));
    }

    public boolean authorizeProjectJobAll(AuthContext authContext, ScheduledExecution job, Collection<String> actions, String project) {
        return this.authorizeResourceAll(authContext, project, new HashSet<String>(actions), (Object)job, (Function)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"authResourceForJob"), Function.class));
    }

    public <T> boolean authorizeResourceAll(AuthContext authContext, String project, Set<String> actions, T resource, Function<T, Map<String, String>> convert) {
        if (project == null) {
            throw (Throwable)new IllegalArgumentException("null project");
        }
        if (authContext == null) {
            throw (Throwable)new IllegalArgumentException("null authContext");
        }
        Set decisions = this.authContextEvaluatorCacheManager.evaluate(authContext, (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{convert.apply(resource)}), Set.class), actions, project);
        return !DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find((Collection)decisions, (Closure)new _authorizeResourceAll_closure8((Object)this, (Object)this)));
    }

    public <T> Set<T> filterAuthorizedResourcesAll(AuthContext authContext, String project, Set<String> actions, Set<T> resources, Function<T, Map<String, String>> convert, String key) {
        Set set;
        if (actions == null || actions.size() <= 0) {
            return resources;
        }
        HashMap inputMap = new HashMap();
        HashSet<Map> authResources = new HashSet<Map>();
        Set<T> set2 = resources;
        Iterator<T> iterator = set2 != null ? set2.iterator() : null;
        Object item = null;
        Iterator<T> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                item = iterator2.next();
                Map map = (Map)ScriptBytecodeAdapter.castToType(convert.apply(item), Map.class);
                authResources.add(map);
                inputMap.put(map.get(key), item);
            }
        }
        Set decisions = this.authContextEvaluatorCacheManager.evaluate(authContext, authResources, actions, project);
        HashSet authorized = new HashSet();
        HashMap authorizations = new HashMap();
        Set set3 = decisions;
        Iterator iterator3 = set3 != null ? set3.iterator() : null;
        Decision decision = null;
        Iterator iterator4 = iterator3;
        if (iterator4 != null) {
            while (iterator4.hasNext()) {
                decision = (Decision)ScriptBytecodeAdapter.castToType(iterator4.next(), Decision.class);
                if (!(decision.isAuthorized() && actions.contains(decision.getAction()))) continue;
                String keyVal = ShortTypeHandling.castToString(decision.getResource().get(key));
                authorizations.computeIfAbsent(keyVal, (Function)ScriptBytecodeAdapter.castToType((Object)new _filterAuthorizedResourcesAll_closure9((Object)this, (Object)this), Function.class));
                ((Set)authorizations.get(keyVal)).add(decision.getAction());
            }
        }
        Iterator iterator5 = (set = authorizations.entrySet()) != null ? set.iterator() : null;
        Map.Entry entry = null;
        Iterator iterator6 = iterator5;
        if (iterator6 != null) {
            while (iterator6.hasNext()) {
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator6.next(), Map.Entry.class);
                if (!(((Set)entry.getValue()).size() == actions.size())) continue;
                authorized.add(inputMap.get(entry.getKey()));
            }
        }
        return authorized;
    }

    public INodeSet filterAuthorizedNodes(String project, Set<String> actions, INodeSet unfiltered, AuthContext authContext) {
        return this.nodeSupport.filterAuthorizedNodes(project, actions, unfiltered, authContext);
    }

    public boolean authorizeProjectConfigure(AuthContext authContext, String project) {
        return this.authorizeApplicationResourceAny(authContext, this.authResourceForProject(project), ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthConstants.ACTION_CONFIGURE, AuthConstants.ACTION_ADMIN, AuthConstants.ACTION_APP_ADMIN}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BaseAuthContextEvaluator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ AuthCache pfaccess$0(BaseAuthContextEvaluator $that) {
        return $that.authContextEvaluatorCacheManager;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public AuthCache getAuthContextEvaluatorCacheManager() {
        return this.authContextEvaluatorCacheManager;
    }

    @Generated
    public void setAuthContextEvaluatorCacheManager(AuthCache authCache) {
        this.authContextEvaluatorCacheManager = authCache;
    }

    @Generated
    public IFrameworkNodes getNodeSupport() {
        return this.nodeSupport;
    }

    @Generated
    public void setNodeSupport(IFrameworkNodes iFrameworkNodes) {
        this.nodeSupport = iFrameworkNodes;
    }
}

