/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class FloatField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private static final FieldType FIELD_TYPE_STORED;
    private final StoredValue storedValue;

    @Deprecated
    public FloatField(String name, float value) {
        this(name, value, Field.Store.NO);
    }

    public FloatField(String name, float value, Field.Store stored) {
        super(name, stored == Field.Store.YES ? FIELD_TYPE_STORED : FIELD_TYPE);
        this.fieldsData = (long)NumericUtils.floatToSortableInt(value);
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    @Override
    public BytesRef binaryValue() {
        byte[] encodedPoint = new byte[4];
        float value = this.getValueAsFloat();
        FloatPoint.encodeDimension(value, encodedPoint, 0);
        return new BytesRef(encodedPoint);
    }

    private float getValueAsFloat() {
        return NumericUtils.sortableIntToFloat(this.numericValue().intValue());
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " <" + this.name + ":" + this.getValueAsFloat() + ">";
    }

    @Override
    public void setFloatValue(float value) {
        super.setLongValue(NumericUtils.floatToSortableInt(value));
        if (this.storedValue != null) {
            this.storedValue.setFloatValue(value);
        }
    }

    @Override
    public void setLongValue(long value) {
        throw new IllegalArgumentException("cannot change value type from Float to Long");
    }

    public static Query newExactQuery(String field, float value) {
        return FloatField.newRangeQuery(field, value, value);
    }

    public static Query newRangeQuery(String field, float lowerValue, float upperValue) {
        PointRangeQuery.checkArgs(field, Float.valueOf(lowerValue), Float.valueOf(upperValue));
        return new IndexOrDocValuesQuery(FloatPoint.newRangeQuery(field, lowerValue, upperValue), SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.floatToSortableInt(lowerValue), NumericUtils.floatToSortableInt(upperValue)));
    }

    public static Query newSetQuery(String field, float ... values) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        long[] points = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            points[i] = NumericUtils.floatToSortableInt(values[i]);
        }
        return new IndexOrDocValuesQuery(FloatPoint.newSetQuery(field, (float[])values.clone()), SortedNumericDocValuesField.newSlowSetQuery(field, points));
    }

    public static SortField newSortField(String field, boolean reverse, SortedNumericSelector.Type selector) {
        return new SortedNumericSortField(field, SortField.Type.FLOAT, reverse, selector);
    }

    static {
        FIELD_TYPE.setDimensions(1, 4);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        FIELD_TYPE.freeze();
        FIELD_TYPE_STORED = new FieldType(FIELD_TYPE);
        FIELD_TYPE_STORED.setStored(true);
        FIELD_TYPE_STORED.freeze();
    }
}

