/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.views;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class VariablesViewButtons {
    public static final String PREFERENCES_NAME = "variables_view";
    public static final String SHOW_VALUE_PROPERTY_EDITORS = "show_value_property_editors";
    private static final String SHOW_FORMATTERS_PROP_NAME = "org.netbeans.modules.debugger.jpda.ui.options.SHOW_FORMATTERS";
    private static final String OPTIONS_JAVA_DEBUGGER_ID = "org-netbeans-modules-debugger-jpda-ui-options-JavaDebuggerOptionsPanelController";
    private static JToggleButton showValuePropertyEditorsToggle = null;

    public static JButton createOpenOptionsButton() {
        JButton button = VariablesViewButtons.createButton("org/netbeans/modules/debugger/jpda/resources/formatters_options_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Open_Formatters"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty(VariablesViewButtons.SHOW_FORMATTERS_PROP_NAME, "true");
                OptionsDisplayer.getDefault().open("Java/org-netbeans-modules-debugger-jpda-ui-options-JavaDebuggerOptionsPanelController");
            }
        });
        return button;
    }

    public static synchronized JToggleButton createShowValuePropertyEditorsButton() {
        if (showValuePropertyEditorsToggle != null) {
            return showValuePropertyEditorsToggle;
        }
        showValuePropertyEditorsToggle = VariablesViewButtons.createToggleButton(SHOW_VALUE_PROPERTY_EDITORS, "org/netbeans/modules/debugger/jpda/resources/show_property_editors_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Show_Value_Property_Editors"));
        showValuePropertyEditorsToggle.addActionListener(new ShowValuePropertyEditorsActionListener(showValuePropertyEditorsToggle));
        return showValuePropertyEditorsToggle;
    }

    private static JButton createButton(String iconPath, String tooltip) {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
        JButton button = new JButton(icon);
        Dimension size = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        button.setPreferredSize(size);
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setBorder(new EmptyBorder(button.getBorder().getBorderInsets(button)));
        button.setToolTipText(tooltip);
        button.setFocusable(false);
        return button;
    }

    private static JToggleButton createToggleButton(String id, String iconPath, String tooltip) {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
        boolean isSelected = VariablesViewButtons.isButtonSelected(id);
        JToggleButton toggleButton = new JToggleButton(icon, isSelected);
        Dimension size = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        toggleButton.setPreferredSize(size);
        toggleButton.setMargin(new Insets(1, 1, 1, 1));
        if (!"Aqua".equals(UIManager.getLookAndFeel().getID())) {
            toggleButton.setBorder(new EmptyBorder(toggleButton.getBorder().getBorderInsets(toggleButton)));
        }
        toggleButton.setToolTipText(tooltip);
        toggleButton.setFocusable(false);
        return toggleButton;
    }

    public static boolean isShowValuePropertyEditors() {
        return VariablesViewButtons.isButtonSelected(SHOW_VALUE_PROPERTY_EDITORS);
    }

    private static boolean isButtonSelected(String name) {
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        return preferences.getBoolean(name, VariablesViewButtons.getDefaultSelected(name));
    }

    private static void setButtonSelected(String name, boolean selected) {
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        preferences.putBoolean(name, selected);
    }

    private static boolean getDefaultSelected(String name) {
        return SHOW_VALUE_PROPERTY_EDITORS.equals(name);
    }

    private static class ShowValuePropertyEditorsActionListener
    implements ActionListener {
        private JToggleButton button;

        ShowValuePropertyEditorsActionListener(JToggleButton toggleButton) {
            this.button = toggleButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isSelected = this.button.isSelected();
            VariablesViewButtons.setButtonSelected(VariablesViewButtons.SHOW_VALUE_PROPERTY_EDITORS, isSelected);
        }
    }
}

