/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.values;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;

public class ComputeInlineValues {
    public static Collection<InlineVariable> computeVariables(final CompilationInfo info, int stackLine, int stackCol, AtomicBoolean cancel) {
        TreePath relevantPoint;
        final int donePos = (int)info.getCompilationUnit().getLineMap().getPosition(stackLine, stackCol);
        final int upcomingPos = (int)info.getCompilationUnit().getLineMap().getStartPosition(stackLine + 1);
        block4: for (relevantPoint = info.getTreeUtilities().pathFor(donePos + 1); relevantPoint != null; relevantPoint = relevantPoint.getParentPath()) {
            Tree leaf = relevantPoint.getLeaf();
            switch (leaf.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case RECORD: 
                case METHOD: 
                case LAMBDA_EXPRESSION: {
                    break block4;
                }
                case BLOCK: {
                    if (relevantPoint.getParentPath() != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)relevantPoint.getParentPath().getLeaf().getKind())) break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (relevantPoint == null) {
            return List.of();
        }
        final ArrayList<InlineVariable> result = new ArrayList<InlineVariable>();
        final LineMap lm = info.getCompilationUnit().getLineMap();
        new CancellableTreePathScanner<Void, Tree>(cancel){

            public Void visitVariable(VariableTree node, Tree relevantPointTree) {
                int[] span;
                int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), node);
                if (end < donePos && (span = info.getTreeUtilities().findNameSpan(node)) != null) {
                    int lineEnd = (int)(lm.getStartPosition(lm.getLineNumber(span[1]) + 1L) - 1L);
                    result.add(new InlineVariable(span[0], span[1], lineEnd, node.getName().toString()));
                }
                return (Void)super.visitVariable(node, (Object)relevantPointTree);
            }

            public Void visitIdentifier(IdentifierTree node, Tree relevantPointTree) {
                Element el = info.getTrees().getElement(this.getCurrentPath());
                if (el != null && el.getKind().isVariable() && el.getKind() != ElementKind.ENUM_CONSTANT) {
                    int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), node);
                    int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), node);
                    if (start != -1 && end != -1) {
                        int lineEnd = (int)(lm.getStartPosition(lm.getLineNumber(end) + 1L) - 1L);
                        result.add(new InlineVariable(start, end, lineEnd, node.getName().toString()));
                    }
                }
                return (Void)super.visitIdentifier(node, (Object)relevantPointTree);
            }

            public Void visitClass(ClassTree node, Tree relevantPointTree) {
                if (node == relevantPointTree) {
                    return (Void)super.visitClass(node, (Object)relevantPointTree);
                }
                return null;
            }

            public Void visitLambdaExpression(LambdaExpressionTree node, Tree relevantPointTree) {
                return null;
            }

            public Void scan(Tree tree, Tree relevantPointTree) {
                int start;
                if (tree != null && (start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree)) > upcomingPos) {
                    return null;
                }
                return (Void)super.scan(tree, (Object)relevantPointTree);
            }
        }.scan(relevantPoint, (Object)relevantPoint.getLeaf());
        return result;
    }

    public record InlineVariable(int start, int end, int lineEnd, String expression) {
    }
}

