/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.export;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.export.Exporter;

final class XMLExporter
extends Exporter {
    private float step = 1.0f;
    private int lastStep = 0;

    XMLExporter() {
    }

    @Override
    protected int getSteps(TableModel model) {
        int steps = model.getRowCount();
        if (steps > 300) {
            this.step = 300.0f / (float)steps;
            steps = 300;
        }
        return steps;
    }

    @Override
    protected void writeHeader(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
        XMLExporter.writeLine(writer, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XMLExporter.writeLine(writer, "<ExportedView Name=\"" + title + "\">");
    }

    @Override
    protected void writeData(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
        int columnsCount = model.getColumnCount();
        int rowsCount = model.getRowCount();
        XMLExporter.writeLine(writer, "  <TableData NumRows=\"" + rowsCount + "\" NumColumns=\"" + columnsCount + "\">");
        XMLExporter.writeLine(writer, "    <TableHeader>");
        for (int c = 0; c < columnsCount; ++c) {
            XMLExporter.writeLine(writer, "      <TableColumn>" + model.getColumnName(c) + "</TableColumn>");
        }
        XMLExporter.writeLine(writer, "    </TableHeader>");
        XMLExporter.writeLine(writer, "    <TableBody>");
        for (int r = 0; r < rowsCount; ++r) {
            XMLExporter.writeLine(writer, "      <TableRow>");
            for (int c = 0; c < columnsCount; ++c) {
                XMLExporter.writeLine(writer, "        <TableColumn>" + model.getValueAt(r, c) + "</TableColumn>");
            }
            XMLExporter.writeLine(writer, "      </TableRow>");
            if (progress.isFinished()) break;
            if (this.step == 1.0f) {
                progress.addStep();
                continue;
            }
            int currentStep = (int)((float)r * this.step);
            if (currentStep <= this.lastStep) continue;
            progress.addStep();
            this.lastStep = currentStep;
        }
        XMLExporter.writeLine(writer, "    </TableBody>");
        XMLExporter.writeLine(writer, "  </TableData>");
    }

    @Override
    protected void writeFooter(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
        XMLExporter.writeLine(writer, "</ExportedView>");
    }
}

