/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.status.StatusAction;
import org.netbeans.modules.subversion.ui.status.SvnVersioningTopComponent;
import org.netbeans.modules.subversion.ui.status.SyncFileNode;
import org.netbeans.modules.subversion.ui.status.SyncTable;
import org.netbeans.modules.subversion.ui.update.UpdateAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.LifecycleManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class VersioningPanel
extends JPanel
implements ExplorerManager.Provider,
PreferenceChangeListener,
PropertyChangeListener,
VersioningListener,
ActionListener {
    private ExplorerManager explorerManager;
    private final SvnVersioningTopComponent parentTopComponent;
    private final Subversion subversion;
    private Context context;
    private int displayStatuses;
    private SyncTable syncTable;
    private RequestProcessor.Task refreshViewTask;
    private VersioningPanelProgressSupport svnProgressSupport;
    private static final RequestProcessor rp = new RequestProcessor("SubversionView", 1, true);
    private final NoContentPanel noContentComponent = new NoContentPanel();
    private final ModeKeeper modeKeeper;
    private boolean remoteStatusCalled;
    private boolean focused;
    private JButton btnCommit;
    private JButton btnDiff;
    private JButton btnRefresh;
    private JButton btnUpdate;
    private JToolBar jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JToggleButton tgbAll;
    private JToggleButton tgbLocal;
    private JToggleButton tgbRemote;

    public VersioningPanel(SvnVersioningTopComponent parent) {
        this.parentTopComponent = parent;
        this.subversion = Subversion.getInstance();
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.explorerManager = new ExplorerManager();
        this.displayStatuses = VersioningPanel.getDefaultDisplayStatus();
        this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanel.class, (String)"MSG_No_Changes_All"));
        this.modeKeeper = new ModeKeeper(SvnModuleConfig.getDefault().getLastUsedModificationContext());
        this.syncTable = new SyncTable(this.modeKeeper);
        this.initComponents();
        this.setComponentsState();
        this.setVersioningComponent(this.syncTable.getComponent());
        this.jPanel2.setFloatable(false);
        this.jPanel2.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jPanel2.setLayout(new ToolbarLayout());
        parent.getInputMap(1).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        parent.getInputMap(0).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        parent.getInputMap(1).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        parent.getInputMap(0).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        this.getActionMap().put("prevInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersioningPanel.this.onNextInnerView();
            }
        });
        this.getActionMap().put("nextInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersioningPanel.this.onPrevInnerView();
            }
        });
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color);
            this.jPanel2.setBackground(color);
        }
    }

    private void onPrevInnerView() {
        if (this.tgbLocal.isSelected()) {
            this.tgbRemote.setSelected(true);
        } else if (this.tgbRemote.isSelected()) {
            this.tgbAll.setSelected(true);
        } else {
            this.tgbLocal.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onNextInnerView() {
        if (this.tgbLocal.isSelected()) {
            this.tgbAll.setSelected(true);
        } else if (this.tgbRemote.isSelected()) {
            this.tgbLocal.setSelected(true);
        } else {
            this.tgbRemote.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc == null) {
                return;
            }
            tc.setActivatedNodes((Node[])evt.getNewValue());
        } else if ("subversion.cache.ready".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
            this.reScheduleRefresh(0);
        }
    }

    void setContext(Context ctx) {
        this.context = ctx;
        if (EventQueue.isDispatchThread()) {
            this.syncTable.setTableModel(new SyncFileNode[0]);
        }
        this.reScheduleRefresh(0);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.subversion.getStatusCache().addVersioningListener(this);
        this.subversion.getStatusCache().addPropertyChangeListener(this);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.subversion.addPropertyChangeListener(this.syncTable);
        this.reScheduleRefresh(0);
    }

    @Override
    public void removeNotify() {
        SvnModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        this.subversion.getStatusCache().removeVersioningListener(this);
        this.subversion.getStatusCache().removePropertyChangeListener(this);
        this.subversion.removePropertyChangeListener(this.syncTable);
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    private void setVersioningComponent(JComponent component) {
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (child == this.jPanel2) continue;
            if (child == component) {
                return;
            }
            this.remove(child);
            break;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.anchor = 23;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)component, gbc);
        this.revalidate();
        this.repaint();
    }

    private void setComponentsState() {
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.tgbLocal);
        grp.add(this.tgbRemote);
        grp.add(this.tgbAll);
        if (this.displayStatuses == 88532) {
            this.tgbLocal.setSelected(true);
        } else if (this.displayStatuses == 1696) {
            this.tgbRemote.setSelected(true);
        } else {
            this.tgbAll.setSelected(true);
        }
    }

    private void setupModels() {
        if (this.context == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VersioningPanel.this.syncTable.setTableModel(new SyncFileNode[0]);
                }
            });
            return;
        }
        SvnUtils.runWithInfoCache(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[FORLOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    private SyncFileNode[] getNodes(Context context, int includeStatus) {
        File[] files = Subversion.getInstance().getStatusCache().listFiles(context.getRootFiles(), includeStatus);
        SvnFileNode[] fnodes = new SvnFileNode[files.length];
        for (int i = 0; i < files.length; ++i) {
            fnodes[i] = new SvnFileNode(files[i]);
        }
        SyncFileNode[] nodes = new SyncFileNode[fnodes.length];
        for (int i = 0; i < fnodes.length; ++i) {
            if (Thread.interrupted()) {
                return null;
            }
            SvnFileNode fnode = fnodes[i];
            nodes[i] = new SyncFileNode(fnode, this);
        }
        return nodes;
    }

    public int getDisplayStatuses() {
        return this.displayStatuses;
    }

    private void onCommitAction() {
        LifecycleManager.getDefault().saveAll();
        CommitAction.commit(this.parentTopComponent.getContentTitle(), this.context, false);
    }

    private void onUpdateAction() {
        UpdateAction.performUpdate(this.context, this.parentTopComponent.getContentTitle());
        this.parentTopComponent.contentRefreshed();
    }

    private void onRefreshAction() {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        LifecycleManager.getDefault().saveAll();
        if (this.context == null || this.context.getRootFiles().length < 1) {
            return;
        }
        if (!SvnUtils.isManaged(this.context.getRootFiles()[0])) {
            Subversion.LOG.warning("VersioningPanel.onRefreshAction: context contains unmanaged file " + this.context.getRootFiles()[0].getAbsolutePath());
        }
        this.refreshStatuses();
    }

    void performRefreshAction() {
        this.refreshStatuses();
    }

    private void refreshStatuses() {
        SVNUrl repository;
        if (this.svnProgressSupport != null) {
            this.svnProgressSupport.cancel();
            this.svnProgressSupport = null;
        }
        try {
            repository = CommitAction.getSvnUrl(this.context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        if (repository == null) {
            if (this.context.getRoots().isEmpty()) {
                return;
            }
            Subversion.LOG.info("VersioningPanel.refreshStatuses: null repositoryUrl for " + this.context.getRootFiles()[0].getAbsolutePath());
            boolean allUnmanaged = true;
            for (File root : this.context.getRootFiles()) {
                if (!SvnUtils.isManaged(root)) continue;
                allUnmanaged = false;
                break;
            }
            if (allUnmanaged) {
                Exception e = new Exception("VersioningPanel.refreshStatuses: null repositoryUrl for " + this.context.getRootFiles()[0].getAbsolutePath());
                Subversion.LOG.log(Level.INFO, null, e);
            }
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        this.remoteStatusCalled = 88532 != this.displayStatuses;
        final boolean contactServer = this.remoteStatusCalled;
        this.svnProgressSupport = new VersioningPanelProgressSupport(){

            @Override
            public void perform() {
                try {
                    StatusAction.executeStatus(VersioningPanel.this.context, this, contactServer);
                }
                finally {
                    this.setFinished(true);
                }
                VersioningPanel.this.reScheduleRefresh(0);
            }
        };
        this.parentTopComponent.contentRefreshed();
        this.svnProgressSupport.start(rp, repository, NbBundle.getMessage(VersioningPanel.class, (String)"LBL_Refresh_Progress"));
    }

    private void onDiffAction() {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        String title = this.parentTopComponent.getContentTitle();
        if (this.displayStatuses == 88532) {
            LifecycleManager.getDefault().saveAll();
            DiffAction.diff(this.context, 0, title, true);
        } else if (this.displayStatuses == 1696) {
            DiffAction.diff(this.context, 1, title, true);
        } else {
            LifecycleManager.getDefault().saveAll();
            DiffAction.diff(this.context, 2, title, true);
        }
    }

    private void onDisplayedStatusChanged() {
        if (this.tgbLocal.isSelected()) {
            this.modeKeeper.setMode(0);
            this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanel.class, (String)"MSG_No_Changes_Local"));
            this.setDisplayStatuses(88532);
        } else if (this.tgbRemote.isSelected()) {
            this.modeKeeper.setMode(1);
            this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanel.class, (String)"MSG_No_Changes_Remote"));
            this.setDisplayStatuses(1696);
        } else if (this.tgbAll.isSelected()) {
            this.modeKeeper.setMode(2);
            this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanel.class, (String)"MSG_No_Changes_All"));
            this.setDisplayStatuses(90100);
        }
    }

    private void setDisplayStatuses(int displayStatuses) {
        this.displayStatuses = displayStatuses;
        if (this.remoteStatusCalled || displayStatuses == 88532) {
            this.reScheduleRefresh(0);
        } else {
            this.refreshStatuses();
        }
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            if (!this.affectsView(event)) {
                return;
            }
            this.reScheduleRefresh(1000);
        }
    }

    private boolean affectsView(VersioningEvent event) {
        if (this.context == null) {
            return false;
        }
        VersioningPanelProgressSupport supp = this.svnProgressSupport;
        if (supp != null && !supp.isFinished()) {
            return false;
        }
        File file = (File)event.getParams()[0];
        FileInformation oldInfo = (FileInformation)event.getParams()[1];
        FileInformation newInfo = (FileInformation)event.getParams()[2];
        if (oldInfo == null ? (newInfo.getStatus() & this.displayStatuses) == 0 : (oldInfo.getStatus() & this.displayStatuses) + (newInfo.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.context.contains(file);
    }

    private void reScheduleRefresh(int delayMillis) {
        this.cancelRefresh();
        this.refreshViewTask.schedule(delayMillis);
    }

    void deserialize() {
        if (this.syncTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VersioningPanel.this.syncTable.setDefaultColumnSizes();
                }
            });
        }
    }

    void focus(boolean focused) {
        this.focused = focused;
        if (focused) {
            this.requestFocusInWindow();
            this.syncTable.focus();
        }
    }

    public void cancelRefresh() {
        this.refreshViewTask.cancel();
    }

    private static int getDefaultDisplayStatus() {
        int selectedMode = SvnModuleConfig.getDefault().getLastUsedModificationContext();
        int displayStatus = selectedMode == 2 ? 90100 : (selectedMode == 1 ? 1696 : 88532);
        return displayStatus;
    }

    private void initComponents() {
        this.jPanel2 = new JToolBar();
        this.tgbAll = new JToggleButton();
        this.tgbLocal = new JToggleButton();
        this.tgbRemote = new JToggleButton();
        this.jSeparator1 = new JSeparator();
        this.btnRefresh = new JButton();
        this.btnDiff = new JButton();
        this.jPanel3 = new JPanel();
        this.btnUpdate = new JButton();
        this.btnCommit = new JButton();
        this.setLayout(new GridBagLayout());
        this.tgbAll.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/remote_vs_local.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/status/Bundle");
        this.tgbAll.setToolTipText(bundle.getString("CTL_Synchronize_Action_All_Tooltip"));
        this.tgbAll.setFocusable(false);
        this.tgbAll.addActionListener(this);
        this.jPanel2.add(this.tgbAll);
        this.tgbLocal.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/local_vs_local.png")));
        this.tgbLocal.setToolTipText(bundle.getString("CTL_Synchronize_Action_Local_Tooltip"));
        this.tgbLocal.setFocusable(false);
        this.tgbLocal.addActionListener(this);
        this.jPanel2.add(this.tgbLocal);
        this.tgbRemote.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/remote_vs_remote.png")));
        this.tgbRemote.setToolTipText(bundle.getString("CTL_Synchronize_Action_Remote_Tooltip"));
        this.tgbRemote.setFocusable(false);
        this.tgbRemote.addActionListener(this);
        this.jPanel2.add(this.tgbRemote);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setPreferredSize(new Dimension(2, 20));
        this.jPanel2.add(this.jSeparator1);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/refresh.png")));
        this.btnRefresh.setToolTipText(bundle.getString("CTL_Synchronize_Action_Refresh_Tooltip"));
        this.btnRefresh.setActionCommand("null");
        this.btnRefresh.setFocusable(false);
        this.btnRefresh.setPreferredSize(new Dimension(22, 23));
        this.btnRefresh.addActionListener(this);
        this.jPanel2.add(this.btnRefresh);
        this.btnRefresh.getAccessibleContext().setAccessibleName("Refresh Status");
        this.btnDiff.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff.png")));
        this.btnDiff.setToolTipText(bundle.getString("CTL_Synchronize_Action_Diff_Tooltip"));
        this.btnDiff.setFocusable(false);
        this.btnDiff.setPreferredSize(new Dimension(22, 25));
        this.btnDiff.addActionListener(this);
        this.jPanel2.add(this.btnDiff);
        this.btnDiff.getAccessibleContext().setAccessibleName("Diff All");
        this.jPanel3.setOpaque(false);
        this.jPanel2.add(this.jPanel3);
        this.btnUpdate.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/update.png")));
        this.btnUpdate.setToolTipText(bundle.getString("CTL_Synchronize_Action_Update_Tooltip"));
        this.btnUpdate.setFocusable(false);
        this.btnUpdate.setPreferredSize(new Dimension(22, 25));
        this.btnUpdate.addActionListener(this);
        this.jPanel2.add(this.btnUpdate);
        this.btnUpdate.getAccessibleContext().setAccessibleName("Update");
        this.btnCommit.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/commit.png")));
        this.btnCommit.setToolTipText(bundle.getString("CTL_CommitForm_Action_Commit_Tooltip"));
        this.btnCommit.setFocusable(false);
        this.btnCommit.setPreferredSize(new Dimension(22, 25));
        this.btnCommit.addActionListener(this);
        this.jPanel2.add(this.btnCommit);
        this.btnCommit.getAccessibleContext().setAccessibleName("Commit");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.tgbAll) {
            this.tgbAllActionPerformed(evt);
        } else if (evt.getSource() == this.tgbLocal) {
            this.tgbLocalActionPerformed(evt);
        } else if (evt.getSource() == this.tgbRemote) {
            this.tgbRemoteActionPerformed(evt);
        } else if (evt.getSource() == this.btnRefresh) {
            this.btnRefreshActionPerformed(evt);
        } else if (evt.getSource() == this.btnDiff) {
            this.btnDiffActionPerformed(evt);
        } else if (evt.getSource() == this.btnUpdate) {
            this.btnUpdateActionPerformed(evt);
        } else if (evt.getSource() == this.btnCommit) {
            this.btnCommitActionPerformed(evt);
        }
    }

    private void btnDiffActionPerformed(ActionEvent evt) {
        this.onDiffAction();
    }

    private void tgbAllActionPerformed(ActionEvent evt) {
        this.onDisplayedStatusChanged();
    }

    private void btnUpdateActionPerformed(ActionEvent evt) {
        this.onUpdateAction();
    }

    private void tgbRemoteActionPerformed(ActionEvent evt) {
        this.onDisplayedStatusChanged();
    }

    private void tgbLocalActionPerformed(ActionEvent evt) {
        this.onDisplayedStatusChanged();
    }

    private void btnCommitActionPerformed(ActionEvent evt) {
        this.onCommitAction();
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.onRefreshAction();
    }

    static /* synthetic */ int access$700(VersioningPanel x0) {
        return x0.displayStatuses;
    }

    static /* synthetic */ SyncFileNode[] access$800(VersioningPanel x0, Context x1, int x2) {
        return x0.getNodes(x1, x2);
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        @Override
        public void run() {
            VersioningPanel.this.setupModels();
        }
    }

    static class ModeKeeper {
        private int mode;

        private ModeKeeper(int defaultMode) {
            this.mode = defaultMode;
        }

        void storeMode() {
            SvnModuleConfig.getDefault().setLastUsedModificationContext(this.mode);
        }

        private void setMode(int mode) {
            this.mode = mode;
            this.storeMode();
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        private int TOOLBAR_HEIGHT_ADJUSTMENT = 4;
        private int TOOLBAR_SEPARATOR_MIN_WIDTH = 12;
        private int toolbarHeight = -1;
        private Dimension parentSize;
        private Set<JComponent> adjusted = new HashSet<JComponent>();

        private ToolbarLayout() {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension dim = VersioningPanel.this.getSize();
            Dimension max = parent.getSize();
            int reminder = max.width - this.minimumLayoutSize((Container)parent).width;
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                JComponent comp = (JComponent)parent.getComponent(i);
                if (!comp.isVisible()) continue;
                comp.setLocation(horizont, 0);
                Dimension pref = comp.getPreferredSize();
                int width = pref.width;
                if (comp instanceof JSeparator && dim.height - dim.width <= 0) {
                    width = Math.max(width, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                if (comp instanceof JProgressBar && reminder > 0) {
                    width += reminder;
                }
                int height = this.getToolbarHeight(dim) - 1;
                comp.setSize(width, height);
                horizont += width;
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = VersioningPanel.this.getSize();
            int height = this.getToolbarHeight(dim);
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                if (comp instanceof AbstractButton) {
                    this.adjustToobarButton((AbstractButton)comp);
                } else {
                    this.adjustToolbarComponentSize((JComponent)comp);
                }
                Dimension pref = comp.getPreferredSize();
                int width = pref.width;
                if (comp instanceof JSeparator && dim.height - dim.width <= 0) {
                    width = Math.max(width, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                horizont += width;
            }
            return new Dimension(horizont, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = VersioningPanel.this.getSize();
            int height = this.getToolbarHeight(dim);
            return new Dimension(Integer.MAX_VALUE, height);
        }

        private int getToolbarHeight(Dimension parent) {
            if (this.parentSize == null || !this.parentSize.equals(parent)) {
                this.parentSize = parent;
                this.toolbarHeight = -1;
            }
            if (this.toolbarHeight == -1) {
                Graphics g = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1).getGraphics();
                UIDefaults def = UIManager.getLookAndFeelDefaults();
                int height = 0;
                String[] fonts = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
                for (int i = 0; i < fonts.length; ++i) {
                    Font f = def.getFont(fonts[i]);
                    FontMetrics fm = g.getFontMetrics(f);
                    height = Math.max(height, fm.getHeight());
                }
                this.toolbarHeight = height + this.TOOLBAR_HEIGHT_ADJUSTMENT;
                if (parent.height - parent.width > 0) {
                    this.toolbarHeight += this.TOOLBAR_HEIGHT_ADJUSTMENT;
                }
            }
            return this.toolbarHeight;
        }

        private void adjustToobarButton(final AbstractButton button) {
            if (this.adjusted.contains(button)) {
                return;
            }
            if (!(button instanceof JToggleButton)) {
                button.setContentAreaFilled(false);
                button.setMargin(new Insets(0, 3, 0, 3));
                button.setBorderPainted(false);
                button.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        button.setContentAreaFilled(true);
                        button.setBorderPainted(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        button.setContentAreaFilled(false);
                        button.setBorderPainted(false);
                    }
                });
            }
            this.adjustToolbarComponentSize(button);
        }

        private void adjustToolbarComponentSize(JComponent button) {
            if (this.adjusted.contains(button)) {
                return;
            }
            if (button.getBorder() instanceof CompoundBorder) {
                Dimension pref = button.getPreferredSize();
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    pref.width += 9;
                }
                button.setPreferredSize(pref);
            }
            this.adjusted.add(button);
        }
    }

    private abstract class VersioningPanelProgressSupport
    extends SvnProgressSupport {
        private boolean finished;

        private VersioningPanelProgressSupport() {
        }

        public boolean isFinished() {
            return this.finished;
        }

        protected void setFinished(boolean flag) {
            this.finished = flag;
        }
    }
}

