/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.modules.javafx2.editor.completion.impl.AbstractCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.impl.Bundle;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.openide.util.ImageUtilities;

final class EventCompletionItem
extends AbstractCompletionItem {
    private static final String ICON_RESOURCE = "org/netbeans/modules/javafx2/editor/resources/event.png";
    private static ImageIcon ICON;
    private String eventType;
    private boolean attribute;
    private boolean inherited;

    public EventCompletionItem(String eventType, boolean attribute, CompletionContext ctx, String text) {
        super(ctx, text);
        this.eventType = eventType;
        this.attribute = attribute;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    @Override
    protected String getLeftHtmlText() {
        if (!this.inherited) {
            return Bundle.FMT_ownEvent(super.getLeftHtmlText());
        }
        return super.getLeftHtmlText();
    }

    @Override
    protected String getSubstituteText() {
        boolean replace = this.ctx.isReplaceExisting();
        if (this.attribute) {
            if (replace) {
                return super.getSubstituteText();
            }
            return super.getSubstituteText() + "=\"\" ";
        }
        if (replace) {
            return "<" + super.getSubstituteText();
        }
        return "<" + super.getSubstituteText() + "></" + super.getSubstituteText() + ">";
    }

    @Override
    protected int getCaretShift(Document d) {
        return 2 + super.getSubstituteText().length();
    }

    @Override
    protected String getRightHtmlText() {
        if (this.eventType == null) {
            return null;
        }
        return Bundle.FMT_eventType(this.eventType);
    }

    @Override
    protected ImageIcon getIcon() {
        if (ICON == null) {
            ICON = ImageUtilities.loadImageIcon((String)ICON_RESOURCE, (boolean)false);
        }
        return ICON;
    }

    public String toString() {
        return "event[" + this.getSubstituteText() + "]";
    }
}

