/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.WorkingCopy;

public class OperatorPrecedence {
    private static final int ASSIGNMENT = 0;
    private static final int TERNARY = 1;
    private static final int LOGICAL_OR = 2;
    private static final int LOGICAL_AND = 3;
    private static final int BITWISE_INCLUSIVE_OR = 4;
    private static final int BITWISE_EXCLUSIVE_OR = 5;
    private static final int BITWISE_AND = 6;
    private static final int EQUALITY = 7;
    private static final int RATIONAL = 8;
    private static final int SHIFT = 9;
    private static final int ADDITIVE = 10;
    private static final int MULTIPLICATIVE = 11;
    private static final int UNARY = 12;
    private static final int POSTFIX = 13;

    public static int getOperatorPrecedence(Tree.Kind kind) {
        switch (kind) {
            case AND: {
                return 6;
            }
            case BITWISE_COMPLEMENT: {
                return 12;
            }
            case CONDITIONAL_AND: {
                return 3;
            }
            case CONDITIONAL_EXPRESSION: {
                return 1;
            }
            case CONDITIONAL_OR: {
                return 2;
            }
            case DIVIDE: {
                return 11;
            }
            case EQUAL_TO: {
                return 7;
            }
            case GREATER_THAN: {
                return 8;
            }
            case INSTANCE_OF: {
                return 8;
            }
            case LEFT_SHIFT: {
                return 9;
            }
            case LESS_THAN: {
                return 8;
            }
            case LESS_THAN_EQUAL: {
                return 8;
            }
            case LOGICAL_COMPLEMENT: {
                return 12;
            }
            case MINUS: {
                return 10;
            }
            case MULTIPLY: {
                return 11;
            }
            case NOT_EQUAL_TO: {
                return 7;
            }
            case OR: {
                return 4;
            }
            case PLUS: {
                return 10;
            }
            case POSTFIX_DECREMENT: {
                return 13;
            }
            case POSTFIX_INCREMENT: {
                return 13;
            }
            case PREFIX_DECREMENT: {
                return 12;
            }
            case PREFIX_INCREMENT: {
                return 12;
            }
            case REMAINDER: {
                return 11;
            }
            case RIGHT_SHIFT: {
                return 9;
            }
            case UNARY_MINUS: {
                return 12;
            }
            case UNARY_PLUS: {
                return 12;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return 9;
            }
            case XOR: {
                return 5;
            }
        }
        return 14;
    }

    public static boolean needsParentheses(TreePath location, ExpressionTree expressionToFind, ExpressionTree expression, WorkingCopy workingcopy) {
        Trees trees = workingcopy.getTrees();
        CompilationUnitTree cut = workingcopy.getCompilationUnit();
        Element elementToFind = trees.getElement(trees.getPath(cut, expressionToFind));
        return OperatorPrecedence.needsParentheses(location, elementToFind, expression, workingcopy);
    }

    public static boolean needsParentheses(TreePath location, Element elementToFind, ExpressionTree expression, WorkingCopy workingcopy) {
        Trees trees = workingcopy.getTrees();
        CompilationUnitTree cut = workingcopy.getCompilationUnit();
        if (!OperatorPrecedence.needsParentheses(expression)) {
            return false;
        }
        TreePath parentPath = location.getParentPath();
        Tree parent = parentPath.getLeaf();
        switch (parent.getKind()) {
            case PARENTHESIZED: 
            case METHOD_INVOCATION: 
            case VARIABLE: 
            case RETURN: 
            case ASSIGNMENT: {
                return false;
            }
        }
        if (parent.getKind() == Tree.Kind.PLUS && expression.getKind() == Tree.Kind.PLUS && (((BinaryTree)expression).getLeftOperand().getKind() == Tree.Kind.STRING_LITERAL || ((BinaryTree)parent).getLeftOperand().getKind() == Tree.Kind.STRING_LITERAL || ((BinaryTree)expression).getRightOperand().getKind() == Tree.Kind.STRING_LITERAL || ((BinaryTree)parent).getRightOperand().getKind() == Tree.Kind.STRING_LITERAL)) {
            return true;
        }
        if (parent.getKind() == Tree.Kind.MINUS) {
            ExpressionTree rightOperand = ((BinaryTree)parent).getRightOperand();
            Element rightElement = trees.getElement(trees.getPath(cut, rightOperand));
            if (elementToFind != null && elementToFind.equals(rightElement)) {
                return true;
            }
        }
        switch (parent.getKind()) {
            case AND: 
            case BITWISE_COMPLEMENT: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_EXPRESSION: 
            case CONDITIONAL_OR: 
            case DIVIDE: 
            case EQUAL_TO: 
            case GREATER_THAN: 
            case INSTANCE_OF: 
            case LEFT_SHIFT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case LOGICAL_COMPLEMENT: 
            case MINUS: 
            case MULTIPLY: 
            case NOT_EQUAL_TO: 
            case OR: 
            case PLUS: 
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case REMAINDER: 
            case RIGHT_SHIFT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case UNSIGNED_RIGHT_SHIFT: 
            case XOR: {
                int substitutePrecedence = OperatorPrecedence.getOperatorPrecedence(expression.getKind());
                int locationPrecedence = OperatorPrecedence.getOperatorPrecedence(parent.getKind());
                if (substitutePrecedence < locationPrecedence) break;
                return false;
            }
        }
        return true;
    }

    public static boolean needsParentheses(Tree expression) {
        switch (expression.getKind()) {
            case PARENTHESIZED: 
            case METHOD_INVOCATION: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case NULL_LITERAL: 
            case IDENTIFIER: 
            case NEW_ARRAY: 
            case NEW_CLASS: 
            case STRING_LITERAL: {
                return false;
            }
        }
        return true;
    }
}

