/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.localentities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import nu.validator.xml.TypedInputSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocalCacheEntityResolver
implements EntityResolver {
    private static final ClassLoader LOADER = LocalCacheEntityResolver.class.getClassLoader();
    private static final Map<String, String> PATH_MAP = new HashMap<String, String>();
    private EntityResolver delegate;
    private boolean allowRnc = false;

    public static InputStream getPresetsAsStream() {
        return LOADER.getResourceAsStream("nu/validator/localentities/presets");
    }

    public static InputStream getHtml5SpecAsStream() {
        return LOADER.getResourceAsStream("nu/validator/localentities/files/html5spec");
    }

    public LocalCacheEntityResolver(EntityResolver delegate) {
        this.delegate = delegate;
    }

    public static URL getResource(String systemId) {
        String path = PATH_MAP.get(systemId);
        return path != null ? LOADER.getResource(path) : null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream stream;
        String path = PATH_MAP.get(systemId);
        if (path != null && (stream = LOADER.getResourceAsStream(path)) != null) {
            TypedInputSource is = new TypedInputSource();
            if (systemId.endsWith(".rnc")) {
                is.setType("application/relax-ng-compact-syntax");
                if (!this.allowRnc) {
                    stream.close();
                    throw new IOException("Not an XML resource: " + systemId);
                }
            } else if (systemId.endsWith(".dtd")) {
                is.setType("application/xml-dtd");
            } else if (systemId.endsWith(".ent")) {
                is.setType("application/xml-external-parsed-entity");
            } else {
                is.setType("application/xml");
            }
            is.setByteStream(stream);
            is.setSystemId(systemId);
            is.setPublicId(publicId);
            return is;
        }
        System.out.println("resolve :" + publicId + " " + systemId);
        return this.delegate.resolveEntity(publicId, systemId);
    }

    public boolean isAllowRnc() {
        return this.allowRnc;
    }

    public void setAllowRnc(boolean allowRnc) {
        this.allowRnc = allowRnc;
    }

    static {
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(LOADER.getResourceAsStream("nu/validator/localentities/files/entitymap"), "UTF-8"));
            while ((line = r.readLine()) != null && !"".equals(line.trim())) {
                String[] s = line.split("\t");
                PATH_MAP.put(s[0], "nu/validator/localentities/files/" + s[1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

