/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.codeception.options.CodeceptionOptions;
import org.netbeans.modules.php.codeception.options.CodeceptionOptionsValidator;
import org.netbeans.modules.php.codeception.ui.options.CodeceptionOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class CodeceptionOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    static final String ID = "Codeception";
    public static final String OPTIONS_SUB_PATH = "FrameworksAndTools/Codeception";
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/Codeception";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private CodeceptionOptionsPanel codeceptionOptionsPanel = null;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getCodeceptionOptionsPanel().setCodeception(this.getCodeceptionOptions().getCodeceptionPath());
        }
        this.changed = false;
    }

    public void applyChanges() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeceptionOptionsPanelController.this.getCodeceptionOptions().setCodeceptionPath(CodeceptionOptionsPanelController.this.getCodeceptionOptionsPanel().getCodeception());
                CodeceptionOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getCodeceptionOptionsPanel().setCodeception(this.getCodeceptionOptions().getCodeceptionPath());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        CodeceptionOptionsPanel panel = this.getCodeceptionOptionsPanel();
        ValidationResult result = new CodeceptionOptionsValidator().validateCodeceptionPath(panel.getCodeception()).getResult();
        if (result.hasErrors()) {
            panel.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getCodeceptionOptions().getCodeceptionPath();
        String current = this.getCodeceptionOptionsPanel().getCodeception().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.codeception.ui.options.CodeceptionOptionsPanelController");
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getCodeceptionOptionsPanel();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    private CodeceptionOptionsPanel getCodeceptionOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.codeceptionOptionsPanel == null) {
            this.codeceptionOptionsPanel = new CodeceptionOptionsPanel();
            this.codeceptionOptionsPanel.addChangeListener(this);
        }
        return this.codeceptionOptionsPanel;
    }

    private CodeceptionOptions getCodeceptionOptions() {
        return CodeceptionOptions.getInstance();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }
}

