/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.StatusCodes;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class StatusCodesStaxUnmarshaller
implements Unmarshaller<StatusCodes, StaxUnmarshallerContext> {
    private static StatusCodesStaxUnmarshaller instance;

    public StatusCodes unmarshall(StaxUnmarshallerContext context) throws Exception {
        StatusCodes statusCodes = new StatusCodes();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return statusCodes;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status2xx", targetDepth)) {
                    statusCodes.setStatus2xx(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status3xx", targetDepth)) {
                    statusCodes.setStatus3xx(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status4xx", targetDepth)) {
                    statusCodes.setStatus4xx(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status5xx", targetDepth)) continue;
                statusCodes.setStatus5xx(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return statusCodes;
    }

    public static StatusCodesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StatusCodesStaxUnmarshaller();
        }
        return instance;
    }
}

