/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateEnvironmentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String environmentId;
    private String environmentName;
    private String groupName;
    private String description;
    private EnvironmentTier tier;
    private String versionLabel;
    private String templateName;
    private String solutionStackName;
    private String platformArn;
    private SdkInternalList<ConfigurationOptionSetting> optionSettings;
    private SdkInternalList<OptionSpecification> optionsToRemove;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public UpdateEnvironmentRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public UpdateEnvironmentRequest withEnvironmentId(String environmentId) {
        this.setEnvironmentId(environmentId);
        return this;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public UpdateEnvironmentRequest withEnvironmentName(String environmentName) {
        this.setEnvironmentName(environmentName);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public UpdateEnvironmentRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateEnvironmentRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTier(EnvironmentTier tier) {
        this.tier = tier;
    }

    public EnvironmentTier getTier() {
        return this.tier;
    }

    public UpdateEnvironmentRequest withTier(EnvironmentTier tier) {
        this.setTier(tier);
        return this;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public UpdateEnvironmentRequest withVersionLabel(String versionLabel) {
        this.setVersionLabel(versionLabel);
        return this;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public UpdateEnvironmentRequest withTemplateName(String templateName) {
        this.setTemplateName(templateName);
        return this;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public UpdateEnvironmentRequest withSolutionStackName(String solutionStackName) {
        this.setSolutionStackName(solutionStackName);
        return this;
    }

    public void setPlatformArn(String platformArn) {
        this.platformArn = platformArn;
    }

    public String getPlatformArn() {
        return this.platformArn;
    }

    public UpdateEnvironmentRequest withPlatformArn(String platformArn) {
        this.setPlatformArn(platformArn);
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new SdkInternalList();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        this.optionSettings = new SdkInternalList(optionSettings);
    }

    public UpdateEnvironmentRequest withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        if (this.optionSettings == null) {
            this.setOptionSettings((Collection<ConfigurationOptionSetting>)new SdkInternalList(optionSettings.length));
        }
        for (ConfigurationOptionSetting ele : optionSettings) {
            this.optionSettings.add((Object)ele);
        }
        return this;
    }

    public UpdateEnvironmentRequest withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        this.setOptionSettings(optionSettings);
        return this;
    }

    public List<OptionSpecification> getOptionsToRemove() {
        if (this.optionsToRemove == null) {
            this.optionsToRemove = new SdkInternalList();
        }
        return this.optionsToRemove;
    }

    public void setOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        if (optionsToRemove == null) {
            this.optionsToRemove = null;
            return;
        }
        this.optionsToRemove = new SdkInternalList(optionsToRemove);
    }

    public UpdateEnvironmentRequest withOptionsToRemove(OptionSpecification ... optionsToRemove) {
        if (this.optionsToRemove == null) {
            this.setOptionsToRemove((Collection<OptionSpecification>)new SdkInternalList(optionsToRemove.length));
        }
        for (OptionSpecification ele : optionsToRemove) {
            this.optionsToRemove.add((Object)ele);
        }
        return this;
    }

    public UpdateEnvironmentRequest withOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        this.setOptionsToRemove(optionsToRemove);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getEnvironmentId() != null) {
            sb.append("EnvironmentId: ").append(this.getEnvironmentId()).append(",");
        }
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: ").append(this.getEnvironmentName()).append(",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier()).append(",");
        }
        if (this.getVersionLabel() != null) {
            sb.append("VersionLabel: ").append(this.getVersionLabel()).append(",");
        }
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: ").append(this.getTemplateName()).append(",");
        }
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.getSolutionStackName()).append(",");
        }
        if (this.getPlatformArn() != null) {
            sb.append("PlatformArn: ").append(this.getPlatformArn()).append(",");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: ").append(this.getOptionSettings()).append(",");
        }
        if (this.getOptionsToRemove() != null) {
            sb.append("OptionsToRemove: ").append(this.getOptionsToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getEnvironmentId() == null ^ this.getEnvironmentId() == null) {
            return false;
        }
        if (other.getEnvironmentId() != null && !other.getEnvironmentId().equals(this.getEnvironmentId())) {
            return false;
        }
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        if (other.getTier() != null && !other.getTier().equals(this.getTier())) {
            return false;
        }
        if (other.getVersionLabel() == null ^ this.getVersionLabel() == null) {
            return false;
        }
        if (other.getVersionLabel() != null && !other.getVersionLabel().equals(this.getVersionLabel())) {
            return false;
        }
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getPlatformArn() == null ^ this.getPlatformArn() == null) {
            return false;
        }
        if (other.getPlatformArn() != null && !other.getPlatformArn().equals(this.getPlatformArn())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        if (other.getOptionSettings() != null && !other.getOptionSettings().equals(this.getOptionSettings())) {
            return false;
        }
        if (other.getOptionsToRemove() == null ^ this.getOptionsToRemove() == null) {
            return false;
        }
        return other.getOptionsToRemove() == null || other.getOptionsToRemove().equals(this.getOptionsToRemove());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentId() == null ? 0 : this.getEnvironmentId().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        hashCode = 31 * hashCode + (this.getVersionLabel() == null ? 0 : this.getVersionLabel().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformArn() == null ? 0 : this.getPlatformArn().hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : this.getOptionSettings().hashCode());
        hashCode = 31 * hashCode + (this.getOptionsToRemove() == null ? 0 : this.getOptionsToRemove().hashCode());
        return hashCode;
    }

    public UpdateEnvironmentRequest clone() {
        return (UpdateEnvironmentRequest)super.clone();
    }
}

