/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.applet.AppletSupport;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.modules.java.api.common.project.ActionProviderSupport;
import org.netbeans.modules.java.api.common.project.JavaActionProvider;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class BaseActionProvider
implements ActionProvider {
    public static final String AUTOMATIC_BUILD_TAG = ".netbeans_automatic_build";
    private static final Logger LOG = Logger.getLogger(BaseActionProvider.class.getName());
    public static final String PROPERTY_RUN_SINGLE_ON_SERVER = "run.single.on.server";
    private final Project project;
    private final AntProjectHelper antProjectHelper;
    private final Callback callback;
    private final Function<String, ClassPath> classpaths;
    private UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private volatile String buildXMLName;
    private SourceRoots projectSourceRoots;
    private SourceRoots projectTestRoots;
    private boolean serverExecution = false;
    private ActionProviderSupport.UserPropertiesPolicy userPropertiesPolicy;
    private final List<? extends JavaActionProvider.AntTargetInvocationListener> listeners;
    private final AtomicReference<JavaActionProvider> delegate;
    public static final String BUILD_SCRIPT = "buildfile";

    public BaseActionProvider(Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testRoots, AntProjectHelper antProjectHelper, Callback callback) {
        this.antProjectHelper = antProjectHelper;
        this.callback = callback;
        this.classpaths = id -> this.getCallback().getProjectSourcesClassPath((String)id);
        this.updateHelper = updateHelper;
        this.project = project;
        this.evaluator = evaluator;
        this.projectSourceRoots = sourceRoots;
        this.projectTestRoots = testRoots;
        this.evaluator.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Class<BaseActionProvider> clazz = BaseActionProvider.class;
                synchronized (BaseActionProvider.class) {
                    String propName = evt.getPropertyName();
                    if (propName == null || BaseActionProvider.BUILD_SCRIPT.equals(propName)) {
                        BaseActionProvider.this.buildXMLName = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        this.listeners = Collections.singletonList(new EventAdaptor());
        this.delegate = new AtomicReference();
    }

    protected abstract String[] getPlatformSensitiveActions();

    protected abstract String[] getActionsDisabledForQuickRun();

    public abstract Map<String, String[]> getCommands();

    protected abstract Set<String> getScanSensitiveActions();

    protected abstract Set<String> getJavaModelActions();

    protected abstract boolean isCompileOnSaveEnabled();

    protected boolean isCompileOnSaveUpdate() {
        return this.isCompileOnSaveEnabled();
    }

    protected void setServerExecution(boolean serverExecution) {
        this.serverExecution = serverExecution;
    }

    protected boolean isServerExecution() {
        return this.serverExecution;
    }

    protected PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    protected UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    protected AntProjectHelper getAntProjectHelper() {
        return this.antProjectHelper;
    }

    protected Callback getCallback() {
        return this.callback;
    }

    public void startFSListener() {
    }

    @NonNull
    public static String getBuildXmlName(Project project, PropertyEvaluator evaluator) {
        return CommonProjectUtils.getBuildXmlName(evaluator, null);
    }

    public static FileObject getBuildXml(Project project, PropertyEvaluator evaluator) {
        return BaseActionProvider.getBuildXml(project, BaseActionProvider.getBuildXmlName(project, evaluator));
    }

    private static FileObject getBuildXml(@NonNull Project project, @NonNull String buildXmlName) {
        return project.getProjectDirectory().getFileObject(buildXmlName);
    }

    @CheckForNull
    protected final FileObject findBuildXml() {
        String name = this.buildXMLName;
        if (name == null) {
            this.buildXMLName = name = BaseActionProvider.getBuildXmlName(this.project, this.evaluator);
        }
        assert (name != null);
        return BaseActionProvider.getBuildXml(this.project, name);
    }

    protected final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAction(final String command, Lookup context) throws IllegalArgumentException {
        assert (EventQueue.isDispatchThread());
        if (this.isSupportedByDelegate(command)) {
            this.getDelegate().invokeAction(command, context);
            return;
        }
        final JavaActionProvider.Context ctx = new JavaActionProvider.Context(this.project, this.updateHelper, this.evaluator, this.classpaths, command, context, this.userPropertiesPolicy, this::getProjectPlatform, this::getAdditionalProperties, this::getConcealedProperties, this::getCompileOnSaveOperations, this.listeners);
        try {
            ActionProviderSupport.invokeTarget(new JavaActionProvider.ScriptAction(command, null, false, this.getJavaModelActions().contains(command), this.getScanSensitiveActions().contains(command), !Arrays.asList(this.getActionsDisabledForQuickRun()).contains(command)){

                @Override
                public String[] getTargetNames(JavaActionProvider.Context context) {
                    Properties p = new Properties();
                    String[] result = BaseActionProvider.this.getTargetNames(ctx.getCommand(), ctx.getActiveLookup(), p, ctx.doJavaChecks());
                    for (Map.Entry<Object, Object> e : p.entrySet()) {
                        ctx.setProperty((String)e.getKey(), (String)e.getValue());
                    }
                    return result;
                }

                @Override
                public boolean isEnabled(JavaActionProvider.Context context) {
                    return BaseActionProvider.this.isActionEnabled(command, context.getActiveLookup());
                }
            }, ctx);
        }
        finally {
            this.userPropertiesPolicy = ctx.getUserPropertiesPolicy();
        }
    }

    protected void updateJavaRunnerClasspath(String command, Map<String, Object> execProperties) {
    }

    public String[] getTargetNames(String command, Lookup context, Properties p) throws IllegalArgumentException {
        return this.getTargetNames(command, context, p, true);
    }

    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    @CheckForNull
    public String[] getTargetNames(String command, Lookup context, Properties p, boolean doJavaChecks) throws IllegalArgumentException {
        JavaActionProvider.Action action = this.getDelegate().getAction(command);
        if (action != null) {
            return Optional.of(action).map(a -> a instanceof JavaActionProvider.ScriptAction ? (JavaActionProvider.ScriptAction)a : null).map(sa -> {
                JavaActionProvider.Context ctx = new JavaActionProvider.Context(this.project, this.updateHelper, this.evaluator, this.classpaths, command, context, null, null, null, null, this::getCompileOnSaveOperations, Collections.emptyList());
                String[] targetNames = sa.getTargetNames(ctx);
                if (targetNames != null) {
                    Optional.ofNullable(ctx.getProperties()).ifPresent(p::putAll);
                }
                return targetNames;
            }).orElse(null);
        }
        if (Arrays.asList(this.getPlatformSensitiveActions()).contains(command) && this.getProjectPlatform() == null) {
            ActionProviderSupport.showPlatformWarning(this.project);
            return null;
        }
        LOG.log(Level.FINE, "COMMAND: {0}", command);
        String[] targetNames = new String[]{};
        Map<String, String[]> targetsFromConfig = ActionProviderSupport.loadTargetsFromConfig(this.project, this.evaluator);
        String[] targets = targetsFromConfig.get(command);
        String[] stringArray = targetNames = targets != null ? targets : this.getCommands().get(command);
        if (targetNames == null) {
            throw new IllegalArgumentException(command);
        }
        return targetNames;
    }

    @CheckForNull
    protected JavaPlatform getProjectPlatform() {
        return ActionProviderSupport.getActivePlatform(this.project, this.evaluator, "platform.active");
    }

    protected boolean handleJavaClass(Properties p, FileObject javaFile, String command, List<String> targetNames) {
        return false;
    }

    @CheckForNull
    protected String getProjectMainClass(boolean verify) {
        return ActionProviderSupport.getProjectMainClass(this.project, this.evaluator, this.projectSourceRoots, this.classpaths, verify);
    }

    private boolean isSupportedByDelegate(String command) {
        for (String action : this.getDelegate().getSupportedActions()) {
            if (!action.equals(command)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    private JavaActionProvider getDelegate() {
        JavaActionProvider jap = this.delegate.get();
        if (jap == null && !this.delegate.compareAndSet(null, jap = this.createDelegate())) {
            jap = this.delegate.get();
            assert (jap != null) : "Transition non-null -> null for delegate.";
        }
        return jap;
    }

    @NonNull
    private JavaActionProvider createDelegate() {
        JavaActionProvider.Builder builder = JavaActionProvider.Builder.newInstance(this.project, this.updateHelper, this.evaluator, this.projectSourceRoots, this.projectTestRoots, this.classpaths).setAdditionalPropertiesProvider(this::getAdditionalProperties).setConcealedPropertiesProvider(this::getConcealedProperties).setCompileOnSaveOperationsProvider(this::getCompileOnSaveOperations).setActivePlatformProvider(this::getProjectPlatform).setProjectMainClassProvider(this::getProjectMainClass).setProjectMainClassSelector(this::showMainClassSelector);
        HashSet<String> supported = new HashSet<String>(Arrays.asList(this.getSupportedActions()));
        for (String op : new String[]{"delete", "rename", "move", "copy"}) {
            if (!supported.contains(op)) continue;
            builder.addAction(builder.createProjectOperation(op));
        }
        Map<String, String[]> cmds = this.getCommands();
        Set<String> scanSensitive = this.getScanSensitiveActions();
        Set<String> modelSensitive = this.getJavaModelActions();
        HashSet disabledForCos = new HashSet();
        Collections.addAll(disabledForCos, this.getActionsDisabledForQuickRun());
        CustomRunner cr = new CustomRunner();
        HashSet<String> disabledByServerExecuion = new HashSet<String>(Arrays.asList("run", "debug", "profile", "debug.stepinto"));
        String[] commands = new String[]{"clean", "build", "rebuild", "run", "debug", "profile", "debug.stepinto", "test", "compile.single", "run.single", "debug.single", "profile.single", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method", "debug.fix"};
        boolean brokenAPI = this.overridesGetTargetNames();
        for (String cmd : commands) {
            JavaActionProvider.ScriptAction action;
            if (!supported.contains(cmd)) continue;
            String[] targets = cmds.get(cmd);
            if (targets != null) {
                action = builder.createDefaultScriptAction(cmd, modelSensitive.contains(cmd), scanSensitive.contains(cmd), !disabledForCos.contains(cmd), () -> targets, cr);
                action.setCoSInterceptor((c, m) -> {
                    this.updateJavaRunnerClasspath(c.getCommand(), (Map<String, Object>)m);
                    return true;
                });
            } else {
                String[] jarDisabledTargets;
                String[] jarEnabledTargets;
                switch (cmd) {
                    case "build": {
                        jarEnabledTargets = new String[]{"jar"};
                        jarDisabledTargets = new String[]{"compile"};
                        break;
                    }
                    case "rebuild": {
                        jarEnabledTargets = new String[]{"clean", "jar"};
                        jarDisabledTargets = new String[]{"clean", "compile"};
                        break;
                    }
                    default: {
                        jarDisabledTargets = null;
                        jarEnabledTargets = null;
                    }
                }
                JavaActionProvider.ScriptAction scriptAction = jarEnabledTargets != null ? builder.createDefaultScriptAction(cmd, modelSensitive.contains(cmd), scanSensitive.contains(cmd), !disabledForCos.contains(cmd), ActionProviderSupport.createConditionalTarget(this.evaluator, ActionProviderSupport.createJarEnabledPredicate(), jarEnabledTargets, jarDisabledTargets)) : (action = null);
            }
            if (action == null) continue;
            if (disabledByServerExecuion.contains(cmd)) {
                action = new ServerExecutionAwareAction(action);
            }
            if (brokenAPI) {
                action = new BrokenAPIActionDecorator(action);
            }
            builder.addAction(action);
        }
        return builder.build();
    }

    private boolean overridesGetTargetNames() {
        boolean vote = false;
        try {
            Method m = this.getClass().getMethod("getTargetNames", String.class, Lookup.class, Properties.class);
            vote |= m.getDeclaringClass() != BaseActionProvider.class;
            m = this.getClass().getDeclaredMethod("getTargetNames", String.class, Lookup.class, Properties.class, Boolean.TYPE);
            vote |= m.getDeclaringClass() != BaseActionProvider.class;
        }
        catch (NoSuchMethodException e) {
            vote = true;
        }
        return vote;
    }

    @NonNull
    private Set<String> getConcealedProperties(@NonNull String command, @NonNull Lookup context) {
        Callback clb = this.getCallback();
        if (clb instanceof Callback3) {
            return ((Callback3)clb).createConcealedProperties(command, context);
        }
        return Collections.emptySet();
    }

    @NonNull
    private Map<String, String> getAdditionalProperties(@NonNull String command, @NonNull Lookup context) {
        Callback clb = this.getCallback();
        if (clb instanceof Callback3) {
            return ((Callback3)clb).createAdditionalProperties(command, context);
        }
        return Collections.emptyMap();
    }

    @NonNull
    private Set<? extends JavaActionProvider.CompileOnSaveOperation> getCompileOnSaveOperations() {
        if (!BuildArtifactMapper.isCompileOnSaveSupported()) {
            return Collections.emptySet();
        }
        EnumSet<JavaActionProvider.CompileOnSaveOperation> ops = EnumSet.noneOf(JavaActionProvider.CompileOnSaveOperation.class);
        if (this.isCompileOnSaveEnabled()) {
            ops.add(JavaActionProvider.CompileOnSaveOperation.EXECUTE);
        }
        if (this.isCompileOnSaveUpdate()) {
            ops.add(JavaActionProvider.CompileOnSaveOperation.UPDATE);
        }
        return Collections.unmodifiableSet(ops);
    }

    protected boolean showMainClassSelector() {
        return ActionProviderSupport.showCustomizer(this.project, this.updateHelper, this.evaluator, this.projectSourceRoots, this.classpaths);
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (this.isSupportedByDelegate(command)) {
            return this.getDelegate().isActionEnabled(command, context);
        }
        return !Arrays.asList(this.getActionsDisabledForQuickRun()).contains(command) || !this.isCompileOnSaveUpdate() || ActionProviderSupport.allowAntBuild(this.evaluator, this.updateHelper);
    }

    @CheckForNull
    private static Collection<? extends String> asPaths(@NullAllowed FileObject[] fos) {
        if (fos == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(fos.length);
        for (FileObject fo : fos) {
            result.add(FileUtil.getFileDisplayName((FileObject)fo));
        }
        return result;
    }

    @NonNull
    private static Collection<? extends String> asPaths(@NonNull Lookup context) {
        Collection dobjs = context.lookupAll(DataObject.class);
        ArrayList<String> result = new ArrayList<String>(dobjs.size());
        for (DataObject dobj : dobjs) {
            result.add(FileUtil.getFileDisplayName((FileObject)dobj.getPrimaryFile()));
        }
        return result;
    }

    public static interface Callback {
        public ClassPath getProjectSourcesClassPath(String var1);

        public ClassPath findClassPath(FileObject var1, String var2);
    }

    private class EventAdaptor
    implements JavaActionProvider.AntTargetInvocationListener {
        private EventAdaptor() {
        }

        @Override
        public void antTargetInvocationStarted(String command, Lookup context) {
            Optional.ofNullable(BaseActionProvider.this.getCallback()).map(cb -> cb instanceof Callback2 ? (Callback2)cb : null).ifPresent(cb -> cb.antTargetInvocationStarted(command, context));
        }

        @Override
        public void antTargetInvocationFinished(String command, Lookup context, int result) {
            Optional.ofNullable(BaseActionProvider.this.getCallback()).map(cb -> cb instanceof Callback2 ? (Callback2)cb : null).ifPresent(cb -> cb.antTargetInvocationFinished(command, context, result));
        }

        @Override
        public void antTargetInvocationFailed(String command, Lookup context) {
            Optional.ofNullable(BaseActionProvider.this.getCallback()).map(cb -> cb instanceof Callback2 ? (Callback2)cb : null).ifPresent(cb -> cb.antTargetInvocationFailed(command, context));
        }
    }

    private class CustomRunner
    implements JavaActionProvider.Builder.CustomFileExecutor {
        private CustomRunner() {
        }

        @Override
        @CheckForNull
        public String[] getTargetNames(@NonNull FileObject fileToExecute, @NonNull JavaActionProvider.Context context) {
            boolean isTest;
            boolean bl = isTest = ActionProviderSupport.findTestSources(BaseActionProvider.this.projectSourceRoots.getRoots(), BaseActionProvider.this.projectTestRoots.getRoots(), context.getActiveLookup(), false) != null;
            if (!isTest) {
                String[] res = this.getTargetsForApplet(fileToExecute, context);
                if (res != null) {
                    return res;
                }
                Properties p = new Properties();
                ArrayList<String> targetNames = new ArrayList<String>();
                if (BaseActionProvider.this.handleJavaClass(p, fileToExecute, context.getCommand(), targetNames)) {
                    for (Map.Entry<Object, Object> e : p.entrySet()) {
                        context.setProperty((String)e.getKey(), (String)e.getValue());
                    }
                    return targetNames.isEmpty() ? null : targetNames.toArray(new String[0]);
                }
            }
            return null;
        }

        @Override
        public JavaActionProvider.ScriptAction.Result performCompileOnSave(JavaActionProvider.Context context, String[] targetNames) {
            if (targetNames.length == 1 && ("run-applet".equals(targetNames[0]) || "debug-applet".equals(targetNames[0]) || "profile-applet".equals(targetNames[0]))) {
                try {
                    Map<String, Object> execProperties = ActionProviderSupport.createBaseCoSProperties(context);
                    FileObject[] selectedFiles = ActionProviderSupport.findSources(BaseActionProvider.this.projectSourceRoots.getRoots(), context.getActiveLookup());
                    if (selectedFiles != null) {
                        FileObject file = selectedFiles[0];
                        String url = context.getProperty("applet.url");
                        execProperties.put("applet.url", url);
                        execProperties.put("execute.file", file);
                        ActionProviderSupport.prepareSystemProperties(context, execProperties, false);
                        return JavaActionProvider.ScriptAction.Result.success(JavaRunner.execute((String)targetNames[0], execProperties));
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return JavaActionProvider.ScriptAction.Result.abort();
                }
            }
            return JavaActionProvider.ScriptAction.Result.follow();
        }

        private String[] getTargetsForApplet(@NonNull FileObject file, @NonNull JavaActionProvider.Context context) {
            String[] res = null;
            if (AppletSupport.isApplet(file)) {
                URL url;
                EditableProperties ep = BaseActionProvider.this.updateHelper.getProperties("nbproject/project.properties");
                String jvmargs = ep.getProperty("run.jvmargs");
                if (jvmargs == null || jvmargs.indexOf("java.security.policy") == -1) {
                    AppletSupport.generateSecurityPolicy(BaseActionProvider.this.project.getProjectDirectory());
                    if (jvmargs == null || jvmargs.length() == 0) {
                        ep.setProperty("run.jvmargs", "-Djava.security.policy=applet.policy");
                    } else {
                        ep.setProperty("run.jvmargs", jvmargs + " -Djava.security.policy=applet.policy");
                    }
                    BaseActionProvider.this.updateHelper.putProperties("nbproject/project.properties", ep);
                    try {
                        ProjectManager.getDefault().saveProject(BaseActionProvider.this.project);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().log(1, "Error while saving project: " + e);
                    }
                }
                if ((url = file.existsExt("html") || file.existsExt("HTML") ? this.copyAppletHTML(file, "html") : this.generateAppletHTML(file)) == null) {
                    return null;
                }
                context.setProperty("applet.url", url.toString());
                String[] pathFqn = ActionProviderSupport.pathAndFqn(file, BaseActionProvider.this.projectSourceRoots.getRoots());
                if (pathFqn != null) {
                    switch (context.getCommand()) {
                        case "run.single": {
                            res = new String[]{"run-applet"};
                            break;
                        }
                        case "debug.single": {
                            context.setProperty("debug.class", pathFqn[1]);
                            res = new String[]{"debug-applet"};
                            break;
                        }
                        case "profile.single": {
                            context.setProperty("run.class", pathFqn[1]);
                            res = new String[]{"profile-applet"};
                        }
                    }
                }
            }
            return res;
        }

        private URL copyAppletHTML(FileObject file, String ext) {
            URL url = null;
            try {
                FileObject targetHtml;
                FileObject htmlFile;
                FileObject buildDir;
                String buildDirProp = BaseActionProvider.this.evaluator.getProperty("build.dir");
                FileObject fileObject = buildDir = buildDirProp != null ? BaseActionProvider.this.updateHelper.getAntProjectHelper().resolveFileObject(buildDirProp) : null;
                if (buildDir == null) {
                    buildDir = FileUtil.createFolder((FileObject)BaseActionProvider.this.project.getProjectDirectory(), (String)buildDirProp);
                }
                if ((htmlFile = file.getParent().getFileObject(file.getName(), "html")) == null) {
                    htmlFile = file.getParent().getFileObject(file.getName(), "HTML");
                }
                if (htmlFile == null) {
                    return null;
                }
                FileObject existingFile = buildDir.getFileObject(htmlFile.getName(), htmlFile.getExt());
                if (existingFile != null) {
                    existingFile.delete();
                }
                if ((targetHtml = htmlFile.copy(buildDir, file.getName(), ext)) != null) {
                    String activePlatformName = BaseActionProvider.this.evaluator.getProperty("platform.active");
                    url = AppletSupport.getHTMLPageURL(targetHtml, activePlatformName);
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
                return null;
            }
            return url;
        }

        private URL generateAppletHTML(FileObject file) {
            try {
                FileObject classesDir;
                String buildDirProp = BaseActionProvider.this.evaluator.getProperty("build.dir");
                String classesDirProp = BaseActionProvider.this.evaluator.getProperty("build.classes.dir");
                FileObject buildDir = buildDirProp != null ? BaseActionProvider.this.updateHelper.getAntProjectHelper().resolveFileObject(buildDirProp) : null;
                FileObject fileObject = classesDir = classesDirProp != null ? BaseActionProvider.this.updateHelper.getAntProjectHelper().resolveFileObject(classesDirProp) : null;
                if (buildDir == null) {
                    buildDir = FileUtil.createFolder((FileObject)BaseActionProvider.this.project.getProjectDirectory(), (String)buildDirProp);
                }
                if (classesDir == null) {
                    classesDir = FileUtil.createFolder((FileObject)BaseActionProvider.this.project.getProjectDirectory(), (String)classesDirProp);
                }
                String activePlatformName = BaseActionProvider.this.evaluator.getProperty("platform.active");
                return AppletSupport.generateHtmlFileURL(file, buildDir, classesDir, activePlatformName);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
                return null;
            }
        }
    }

    private final class ServerExecutionAwareAction
    extends JavaActionProvider.ScriptAction {
        private final JavaActionProvider.ScriptAction delegate;

        ServerExecutionAwareAction(JavaActionProvider.ScriptAction delegate) {
            super(delegate.getCommand(), null, delegate.getActionFlags().contains((Object)ActionProviderSupport.ActionFlag.PLATFORM_SENSITIVE), delegate.getActionFlags().contains((Object)ActionProviderSupport.ActionFlag.JAVA_MODEL_SENSITIVE), delegate.getActionFlags().contains((Object)ActionProviderSupport.ActionFlag.SCAN_SENSITIVE), delegate.getActionFlags().contains((Object)ActionProviderSupport.ActionFlag.COS_ENABLED));
            this.delegate = delegate;
        }

        @Override
        public String[] getTargetNames(JavaActionProvider.Context context) {
            boolean justAnotherServerExecution = context.getProperty(BaseActionProvider.PROPERTY_RUN_SINGLE_ON_SERVER) != null;
            context.removeProperty(BaseActionProvider.PROPERTY_RUN_SINGLE_ON_SERVER);
            if (!BaseActionProvider.this.isServerExecution() && !justAnotherServerExecution) {
                return this.delegate.getTargetNames(context);
            }
            Map<String, String[]> targetsFromConfig = ActionProviderSupport.loadTargetsFromConfig(BaseActionProvider.this.project, BaseActionProvider.this.evaluator);
            String[] targets = targetsFromConfig.get(this.getCommand());
            if (targets == null) {
                targets = BaseActionProvider.this.getCommands().get(this.getCommand());
            }
            if (targets == null) {
                throw new IllegalArgumentException(this.getCommand());
            }
            return targets;
        }

        @Override
        public JavaActionProvider.ScriptAction.Result performCompileOnSave(JavaActionProvider.Context context, String[] targetNames) {
            if (!BaseActionProvider.this.isServerExecution()) {
                return this.delegate.performCompileOnSave(context, targetNames);
            }
            return JavaActionProvider.ScriptAction.Result.follow();
        }

        @Override
        public boolean isEnabled(JavaActionProvider.Context context) {
            return this.delegate.isEnabled(context);
        }
    }

    private final class BrokenAPIActionDecorator
    extends JavaActionProvider.ScriptAction {
        private final JavaActionProvider.ScriptAction delegate;
        private final ThreadLocal<JavaActionProvider.Context> frame;

        BrokenAPIActionDecorator(JavaActionProvider.ScriptAction delegate) {
            super(delegate.getCommand(), null, delegate.getActionFlags().contains((Object)ActionProviderSupport.ActionFlag.PLATFORM_SENSITIVE), delegate.getActionFlags().contains((Object)ActionProviderSupport.ActionFlag.JAVA_MODEL_SENSITIVE), delegate.getActionFlags().contains((Object)ActionProviderSupport.ActionFlag.SCAN_SENSITIVE), delegate.getActionFlags().contains((Object)ActionProviderSupport.ActionFlag.COS_ENABLED));
            this.delegate = delegate;
            this.frame = new ThreadLocal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getTargetNames(JavaActionProvider.Context context) {
            JavaActionProvider.Context enclosingContext = this.frame.get();
            if (enclosingContext == null) {
                this.frame.set(context);
                try {
                    Properties p = new Properties();
                    String[] res = BaseActionProvider.this.getTargetNames(context.getCommand(), context.getActiveLookup(), p, context.doJavaChecks());
                    p.entrySet().forEach(e -> context.setProperty((String)e.getKey(), (String)e.getValue()));
                    String[] stringArray = res;
                    return stringArray;
                }
                finally {
                    this.frame.remove();
                }
            }
            return this.delegate.getTargetNames(enclosingContext);
        }

        @Override
        public JavaActionProvider.ScriptAction.Result performCompileOnSave(JavaActionProvider.Context context, String[] targetNames) {
            return this.delegate.performCompileOnSave(context, targetNames);
        }

        @Override
        public boolean isEnabled(JavaActionProvider.Context context) {
            return this.delegate.isEnabled(context);
        }
    }

    public static interface Callback3
    extends Callback2 {
        @NonNull
        public Map<String, String> createAdditionalProperties(@NonNull String var1, @NonNull Lookup var2);

        @NonNull
        public Set<String> createConcealedProperties(@NonNull String var1, @NonNull Lookup var2);
    }

    public static final class CallbackImpl
    implements Callback {
        private ClassPathProviderImpl cp;

        public CallbackImpl(ClassPathProviderImpl cp) {
            this.cp = cp;
        }

        @Override
        public ClassPath getProjectSourcesClassPath(String type) {
            return this.cp.getProjectSourcesClassPath(type);
        }

        @Override
        public ClassPath findClassPath(FileObject file, String type) {
            return this.cp.findClassPath(file, type);
        }
    }

    public static interface Callback2
    extends Callback {
        public void antTargetInvocationStarted(String var1, Lookup var2);

        public void antTargetInvocationFinished(String var1, Lookup var2, int var3);

        public void antTargetInvocationFailed(String var1, Lookup var2);
    }
}

