// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/automl/v1/service.proto

package automlpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AutoMl_CreateDataset_FullMethodName        = "/google.cloud.automl.v1.AutoMl/CreateDataset"
	AutoMl_GetDataset_FullMethodName           = "/google.cloud.automl.v1.AutoMl/GetDataset"
	AutoMl_ListDatasets_FullMethodName         = "/google.cloud.automl.v1.AutoMl/ListDatasets"
	AutoMl_UpdateDataset_FullMethodName        = "/google.cloud.automl.v1.AutoMl/UpdateDataset"
	AutoMl_DeleteDataset_FullMethodName        = "/google.cloud.automl.v1.AutoMl/DeleteDataset"
	AutoMl_ImportData_FullMethodName           = "/google.cloud.automl.v1.AutoMl/ImportData"
	AutoMl_ExportData_FullMethodName           = "/google.cloud.automl.v1.AutoMl/ExportData"
	AutoMl_GetAnnotationSpec_FullMethodName    = "/google.cloud.automl.v1.AutoMl/GetAnnotationSpec"
	AutoMl_CreateModel_FullMethodName          = "/google.cloud.automl.v1.AutoMl/CreateModel"
	AutoMl_GetModel_FullMethodName             = "/google.cloud.automl.v1.AutoMl/GetModel"
	AutoMl_ListModels_FullMethodName           = "/google.cloud.automl.v1.AutoMl/ListModels"
	AutoMl_DeleteModel_FullMethodName          = "/google.cloud.automl.v1.AutoMl/DeleteModel"
	AutoMl_UpdateModel_FullMethodName          = "/google.cloud.automl.v1.AutoMl/UpdateModel"
	AutoMl_DeployModel_FullMethodName          = "/google.cloud.automl.v1.AutoMl/DeployModel"
	AutoMl_UndeployModel_FullMethodName        = "/google.cloud.automl.v1.AutoMl/UndeployModel"
	AutoMl_ExportModel_FullMethodName          = "/google.cloud.automl.v1.AutoMl/ExportModel"
	AutoMl_GetModelEvaluation_FullMethodName   = "/google.cloud.automl.v1.AutoMl/GetModelEvaluation"
	AutoMl_ListModelEvaluations_FullMethodName = "/google.cloud.automl.v1.AutoMl/ListModelEvaluations"
)

// AutoMlClient is the client API for AutoMl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AutoMlClient interface {
	// Creates a dataset.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a dataset.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Updates a dataset.
	UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports data into a dataset.
	// For Tables this method can only be called on an empty Dataset.
	//
	// For Tables:
	// *   A
	// [schema_inference_version][google.cloud.automl.v1.InputConfig.params]
	//
	//	parameter must be explicitly set.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports dataset's data to the provided output location.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an annotation spec.
	GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a model.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists models.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Deletes a model.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a model.
	UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deploys a model. If a model is already deployed, deploying it with the
	// same parameters has no effect. Deploying with different parametrs
	// (as e.g. changing
	// [node_number][google.cloud.automl.v1p1beta.ImageObjectDetectionModelDeploymentMetadata.node_number])
	//
	//	will reset the deployment state without pausing the model's availability.
	//
	// Only applicable for Text Classification, Image Object Detection , Tables, and Image Segmentation; all other domains manage
	// deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	//
	// Only applicable for Text Classification, Image Object Detection and Tables;
	// all other domains manage deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports a trained, "export-able", model to a user specified Google Cloud
	// Storage location. A model is considered export-able if and only if it has
	// an export format defined for it in
	// [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportModel(ctx context.Context, in *ExportModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a model evaluation.
	GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error)
}

type autoMlClient struct {
	cc grpc.ClientConnInterface
}

func NewAutoMlClient(cc grpc.ClientConnInterface) AutoMlClient {
	return &autoMlClient{cc}
}

func (c *autoMlClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AutoMl_CreateDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, AutoMl_GetDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, AutoMl_ListDatasets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, AutoMl_UpdateDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AutoMl_DeleteDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AutoMl_ImportData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AutoMl_ExportData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error) {
	out := new(AnnotationSpec)
	err := c.cc.Invoke(ctx, AutoMl_GetAnnotationSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AutoMl_CreateModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, AutoMl_GetModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, AutoMl_ListModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AutoMl_DeleteModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, AutoMl_UpdateModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AutoMl_DeployModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AutoMl_UndeployModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ExportModel(ctx context.Context, in *ExportModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AutoMl_ExportModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error) {
	out := new(ModelEvaluation)
	err := c.cc.Invoke(ctx, AutoMl_GetModelEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error) {
	out := new(ListModelEvaluationsResponse)
	err := c.cc.Invoke(ctx, AutoMl_ListModelEvaluations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoMlServer is the server API for AutoMl service.
// All implementations should embed UnimplementedAutoMlServer
// for forward compatibility
type AutoMlServer interface {
	// Creates a dataset.
	CreateDataset(context.Context, *CreateDatasetRequest) (*longrunningpb.Operation, error)
	// Gets a dataset.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Updates a dataset.
	UpdateDataset(context.Context, *UpdateDatasetRequest) (*Dataset, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunningpb.Operation, error)
	// Imports data into a dataset.
	// For Tables this method can only be called on an empty Dataset.
	//
	// For Tables:
	// *   A
	// [schema_inference_version][google.cloud.automl.v1.InputConfig.params]
	//
	//	parameter must be explicitly set.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error)
	// Exports dataset's data to the provided output location.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error)
	// Gets an annotation spec.
	GetAnnotationSpec(context.Context, *GetAnnotationSpecRequest) (*AnnotationSpec, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(context.Context, *CreateModelRequest) (*longrunningpb.Operation, error)
	// Gets a model.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists models.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Deletes a model.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(context.Context, *DeleteModelRequest) (*longrunningpb.Operation, error)
	// Updates a model.
	UpdateModel(context.Context, *UpdateModelRequest) (*Model, error)
	// Deploys a model. If a model is already deployed, deploying it with the
	// same parameters has no effect. Deploying with different parametrs
	// (as e.g. changing
	// [node_number][google.cloud.automl.v1p1beta.ImageObjectDetectionModelDeploymentMetadata.node_number])
	//
	//	will reset the deployment state without pausing the model's availability.
	//
	// Only applicable for Text Classification, Image Object Detection , Tables, and Image Segmentation; all other domains manage
	// deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	DeployModel(context.Context, *DeployModelRequest) (*longrunningpb.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	//
	// Only applicable for Text Classification, Image Object Detection and Tables;
	// all other domains manage deployment automatically.
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	UndeployModel(context.Context, *UndeployModelRequest) (*longrunningpb.Operation, error)
	// Exports a trained, "export-able", model to a user specified Google Cloud
	// Storage location. A model is considered export-able if and only if it has
	// an export format defined for it in
	// [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
	//
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportModel(context.Context, *ExportModelRequest) (*longrunningpb.Operation, error)
	// Gets a model evaluation.
	GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error)
}

// UnimplementedAutoMlServer should be embedded to have forward compatible implementations.
type UnimplementedAutoMlServer struct {
}

func (UnimplementedAutoMlServer) CreateDataset(context.Context, *CreateDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataset not implemented")
}
func (UnimplementedAutoMlServer) GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (UnimplementedAutoMlServer) ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (UnimplementedAutoMlServer) UpdateDataset(context.Context, *UpdateDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataset not implemented")
}
func (UnimplementedAutoMlServer) DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataset not implemented")
}
func (UnimplementedAutoMlServer) ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportData not implemented")
}
func (UnimplementedAutoMlServer) ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportData not implemented")
}
func (UnimplementedAutoMlServer) GetAnnotationSpec(context.Context, *GetAnnotationSpecRequest) (*AnnotationSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnnotationSpec not implemented")
}
func (UnimplementedAutoMlServer) CreateModel(context.Context, *CreateModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModel not implemented")
}
func (UnimplementedAutoMlServer) GetModel(context.Context, *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (UnimplementedAutoMlServer) ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (UnimplementedAutoMlServer) DeleteModel(context.Context, *DeleteModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}
func (UnimplementedAutoMlServer) UpdateModel(context.Context, *UpdateModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModel not implemented")
}
func (UnimplementedAutoMlServer) DeployModel(context.Context, *DeployModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployModel not implemented")
}
func (UnimplementedAutoMlServer) UndeployModel(context.Context, *UndeployModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployModel not implemented")
}
func (UnimplementedAutoMlServer) ExportModel(context.Context, *ExportModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportModel not implemented")
}
func (UnimplementedAutoMlServer) GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelEvaluation not implemented")
}
func (UnimplementedAutoMlServer) ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelEvaluations not implemented")
}

// UnsafeAutoMlServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AutoMlServer will
// result in compilation errors.
type UnsafeAutoMlServer interface {
	mustEmbedUnimplementedAutoMlServer()
}

func RegisterAutoMlServer(s grpc.ServiceRegistrar, srv AutoMlServer) {
	s.RegisterService(&AutoMl_ServiceDesc, srv)
}

func _AutoMl_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_CreateDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_GetDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_ListDatasets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UpdateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UpdateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_UpdateDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UpdateDataset(ctx, req.(*UpdateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_DeleteDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_ImportData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_ExportData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetAnnotationSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetAnnotationSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_GetAnnotationSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetAnnotationSpec(ctx, req.(*GetAnnotationSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_CreateModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_GetModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_ListModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_DeleteModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UpdateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UpdateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_UpdateModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UpdateModel(ctx, req.(*UpdateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_DeployModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeployModel(ctx, req.(*DeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UndeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UndeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_UndeployModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UndeployModel(ctx, req.(*UndeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ExportModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ExportModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_ExportModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ExportModel(ctx, req.(*ExportModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_GetModelEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, req.(*GetModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModelEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoMl_ListModelEvaluations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, req.(*ListModelEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AutoMl_ServiceDesc is the grpc.ServiceDesc for AutoMl service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AutoMl_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.automl.v1.AutoMl",
	HandlerType: (*AutoMlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _AutoMl_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _AutoMl_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _AutoMl_ListDatasets_Handler,
		},
		{
			MethodName: "UpdateDataset",
			Handler:    _AutoMl_UpdateDataset_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _AutoMl_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _AutoMl_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _AutoMl_ExportData_Handler,
		},
		{
			MethodName: "GetAnnotationSpec",
			Handler:    _AutoMl_GetAnnotationSpec_Handler,
		},
		{
			MethodName: "CreateModel",
			Handler:    _AutoMl_CreateModel_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _AutoMl_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _AutoMl_ListModels_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _AutoMl_DeleteModel_Handler,
		},
		{
			MethodName: "UpdateModel",
			Handler:    _AutoMl_UpdateModel_Handler,
		},
		{
			MethodName: "DeployModel",
			Handler:    _AutoMl_DeployModel_Handler,
		},
		{
			MethodName: "UndeployModel",
			Handler:    _AutoMl_UndeployModel_Handler,
		},
		{
			MethodName: "ExportModel",
			Handler:    _AutoMl_ExportModel_Handler,
		},
		{
			MethodName: "GetModelEvaluation",
			Handler:    _AutoMl_GetModelEvaluation_Handler,
		},
		{
			MethodName: "ListModelEvaluations",
			Handler:    _AutoMl_ListModelEvaluations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/automl/v1/service.proto",
}
