// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the disco-to-proto3-converter. DO NOT EDIT!
// Source Discovery file: compute.v1beta.json
// Source file revision: 20250916
// API name: compute
// API version: v1beta

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/compute/v1beta/compute.proto

package computepb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/cloud/extendedops"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
type AccessConfig_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	AccessConfig_UNDEFINED_NETWORK_TIER AccessConfig_NetworkTier = 0
	// Public internet quality with fixed bandwidth.
	AccessConfig_FIXED_STANDARD AccessConfig_NetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	AccessConfig_PREMIUM AccessConfig_NetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	AccessConfig_STANDARD AccessConfig_NetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	AccessConfig_STANDARD_OVERRIDES_FIXED_STANDARD AccessConfig_NetworkTier = 465847234
)

// Enum value maps for AccessConfig_NetworkTier.
var (
	AccessConfig_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	AccessConfig_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER":            0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x AccessConfig_NetworkTier) Enum() *AccessConfig_NetworkTier {
	p := new(AccessConfig_NetworkTier)
	*p = x
	return p
}

func (x AccessConfig_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessConfig_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[0].Descriptor()
}

func (AccessConfig_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[0]
}

func (x AccessConfig_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessConfig_NetworkTier.Descriptor instead.
func (AccessConfig_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{9, 0}
}

// The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
type AccessConfig_Type int32

const (
	// A value indicating that the enum field is not set.
	AccessConfig_UNDEFINED_TYPE AccessConfig_Type = 0
	AccessConfig_DIRECT_IPV6    AccessConfig_Type = 4397213
	AccessConfig_ONE_TO_ONE_NAT AccessConfig_Type = 84090205
)

// Enum value maps for AccessConfig_Type.
var (
	AccessConfig_Type_name = map[int32]string{
		0:        "UNDEFINED_TYPE",
		4397213:  "DIRECT_IPV6",
		84090205: "ONE_TO_ONE_NAT",
	}
	AccessConfig_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"DIRECT_IPV6":    4397213,
		"ONE_TO_ONE_NAT": 84090205,
	}
)

func (x AccessConfig_Type) Enum() *AccessConfig_Type {
	p := new(AccessConfig_Type)
	*p = x
	return p
}

func (x AccessConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[1].Descriptor()
}

func (AccessConfig_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[1]
}

func (x AccessConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessConfig_Type.Descriptor instead.
func (AccessConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{9, 1}
}

// The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
type Address_AddressType int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_ADDRESS_TYPE Address_AddressType = 0
	// A publicly visible external IP address.
	Address_EXTERNAL Address_AddressType = 35607499
	// A private network IP address, for use with an Instance or Internal Load Balancer forwarding rule.
	Address_INTERNAL         Address_AddressType = 279295677
	Address_UNSPECIFIED_TYPE Address_AddressType = 53933922
)

// Enum value maps for Address_AddressType.
var (
	Address_AddressType_name = map[int32]string{
		0:         "UNDEFINED_ADDRESS_TYPE",
		35607499:  "EXTERNAL",
		279295677: "INTERNAL",
		53933922:  "UNSPECIFIED_TYPE",
	}
	Address_AddressType_value = map[string]int32{
		"UNDEFINED_ADDRESS_TYPE": 0,
		"EXTERNAL":               35607499,
		"INTERNAL":               279295677,
		"UNSPECIFIED_TYPE":       53933922,
	}
)

func (x Address_AddressType) Enum() *Address_AddressType {
	p := new(Address_AddressType)
	*p = x
	return p
}

func (x Address_AddressType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_AddressType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[2].Descriptor()
}

func (Address_AddressType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[2]
}

func (x Address_AddressType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_AddressType.Descriptor instead.
func (Address_AddressType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{36, 0}
}

// The IP version that will be used by this address. Valid options are IPV4 or IPV6.
type Address_IpVersion int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_IP_VERSION Address_IpVersion = 0
	Address_IPV4                 Address_IpVersion = 2254341
	Address_IPV6                 Address_IpVersion = 2254343
	Address_UNSPECIFIED_VERSION  Address_IpVersion = 21850000
)

// Enum value maps for Address_IpVersion.
var (
	Address_IpVersion_name = map[int32]string{
		0:        "UNDEFINED_IP_VERSION",
		2254341:  "IPV4",
		2254343:  "IPV6",
		21850000: "UNSPECIFIED_VERSION",
	}
	Address_IpVersion_value = map[string]int32{
		"UNDEFINED_IP_VERSION": 0,
		"IPV4":                 2254341,
		"IPV6":                 2254343,
		"UNSPECIFIED_VERSION":  21850000,
	}
)

func (x Address_IpVersion) Enum() *Address_IpVersion {
	p := new(Address_IpVersion)
	*p = x
	return p
}

func (x Address_IpVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_IpVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[3].Descriptor()
}

func (Address_IpVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[3]
}

func (x Address_IpVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_IpVersion.Descriptor instead.
func (Address_IpVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{36, 1}
}

// The endpoint type of this address, which should be VM or NETLB. This is used for deciding which type of endpoint this address can be used after the external IPv6 address reservation.
type Address_Ipv6EndpointType int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_IPV6_ENDPOINT_TYPE Address_Ipv6EndpointType = 0
	// Reserved IPv6 address can be used on network load balancer.
	Address_NETLB Address_Ipv6EndpointType = 74173363
	// Reserved IPv6 address can be used on VM.
	Address_VM Address_Ipv6EndpointType = 2743
)

// Enum value maps for Address_Ipv6EndpointType.
var (
	Address_Ipv6EndpointType_name = map[int32]string{
		0:        "UNDEFINED_IPV6_ENDPOINT_TYPE",
		74173363: "NETLB",
		2743:     "VM",
	}
	Address_Ipv6EndpointType_value = map[string]int32{
		"UNDEFINED_IPV6_ENDPOINT_TYPE": 0,
		"NETLB":                        74173363,
		"VM":                           2743,
	}
)

func (x Address_Ipv6EndpointType) Enum() *Address_Ipv6EndpointType {
	p := new(Address_Ipv6EndpointType)
	*p = x
	return p
}

func (x Address_Ipv6EndpointType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_Ipv6EndpointType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[4].Descriptor()
}

func (Address_Ipv6EndpointType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[4]
}

func (x Address_Ipv6EndpointType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_Ipv6EndpointType.Descriptor instead.
func (Address_Ipv6EndpointType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{36, 2}
}

// This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Internal IP addresses are always Premium Tier; global external IP addresses are always Premium Tier; regional external IP addresses can be either Standard or Premium Tier. If this field is not specified, it is assumed to be PREMIUM.
type Address_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_NETWORK_TIER Address_NetworkTier = 0
	// Public internet quality with fixed bandwidth.
	Address_FIXED_STANDARD Address_NetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	Address_PREMIUM Address_NetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	Address_STANDARD Address_NetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	Address_STANDARD_OVERRIDES_FIXED_STANDARD Address_NetworkTier = 465847234
)

// Enum value maps for Address_NetworkTier.
var (
	Address_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	Address_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER":            0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x Address_NetworkTier) Enum() *Address_NetworkTier {
	p := new(Address_NetworkTier)
	*p = x
	return p
}

func (x Address_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[5].Descriptor()
}

func (Address_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[5]
}

func (x Address_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_NetworkTier.Descriptor instead.
func (Address_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{36, 3}
}

// The purpose of this resource, which can be one of the following values: - GCE_ENDPOINT for addresses that are used by VM instances, alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS inbound forwarder IP addresses (regional internal IP address in a subnet of a VPC network) - VPC_PEERING for global internal IP addresses used for private services access allocated ranges. - NAT_AUTO for the regional external IP addresses used by Cloud NAT when allocating addresses using automatic NAT IP address allocation. - IPSEC_INTERCONNECT for addresses created from a private IP range that are reserved for a VLAN attachment in an *HA VPN over Cloud Interconnect* configuration. These addresses are regional resources. - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is used to configure Private Service Connect. Only global internal addresses can use this purpose.
type Address_Purpose int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_PURPOSE Address_Purpose = 0
	// DNS resolver address in the subnetwork.
	Address_DNS_RESOLVER Address_Purpose = 476114556
	// VM internal/alias IP, Internal LB service IP, etc.
	Address_GCE_ENDPOINT Address_Purpose = 230515243
	// A regional internal IP address range reserved for the VLAN attachment that is used in HA VPN over Cloud Interconnect. This regional internal IP address range must not overlap with any IP address range of subnet/route in the VPC network and its peering networks. After the VLAN attachment is created with the reserved IP address range, when creating a new VPN gateway, its interface IP address is allocated from the associated VLAN attachment’s IP address range.
	Address_IPSEC_INTERCONNECT Address_Purpose = 340437251
	// External IP automatically reserved for Cloud NAT.
	Address_NAT_AUTO Address_Purpose = 163666477
	// A private network IP address that can be used to configure Private Service Connect. This purpose can be specified only for GLOBAL addresses of Type INTERNAL
	Address_PRIVATE_SERVICE_CONNECT Address_Purpose = 48134724
	// A regional internal IP address range reserved for Serverless.
	Address_SERVERLESS Address_Purpose = 270492508
	// A private network IP address that can be shared by multiple Internal Load Balancer forwarding rules.
	Address_SHARED_LOADBALANCER_VIP Address_Purpose = 294447572
	// IP range for peer networks.
	Address_VPC_PEERING Address_Purpose = 400800170
)

// Enum value maps for Address_Purpose.
var (
	Address_Purpose_name = map[int32]string{
		0:         "UNDEFINED_PURPOSE",
		476114556: "DNS_RESOLVER",
		230515243: "GCE_ENDPOINT",
		340437251: "IPSEC_INTERCONNECT",
		163666477: "NAT_AUTO",
		48134724:  "PRIVATE_SERVICE_CONNECT",
		270492508: "SERVERLESS",
		294447572: "SHARED_LOADBALANCER_VIP",
		400800170: "VPC_PEERING",
	}
	Address_Purpose_value = map[string]int32{
		"UNDEFINED_PURPOSE":       0,
		"DNS_RESOLVER":            476114556,
		"GCE_ENDPOINT":            230515243,
		"IPSEC_INTERCONNECT":      340437251,
		"NAT_AUTO":                163666477,
		"PRIVATE_SERVICE_CONNECT": 48134724,
		"SERVERLESS":              270492508,
		"SHARED_LOADBALANCER_VIP": 294447572,
		"VPC_PEERING":             400800170,
	}
)

func (x Address_Purpose) Enum() *Address_Purpose {
	p := new(Address_Purpose)
	*p = x
	return p
}

func (x Address_Purpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_Purpose) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[6].Descriptor()
}

func (Address_Purpose) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[6]
}

func (x Address_Purpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_Purpose.Descriptor instead.
func (Address_Purpose) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{36, 4}
}

// [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
type Address_Status int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_STATUS Address_Status = 0
	// Address is being used by another resource and is not available.
	Address_IN_USE Address_Status = 17393485
	// Address is reserved and available to use.
	Address_RESERVED Address_Status = 432241448
	// Address is being reserved.
	Address_RESERVING Address_Status = 514587225
)

// Enum value maps for Address_Status.
var (
	Address_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		17393485:  "IN_USE",
		432241448: "RESERVED",
		514587225: "RESERVING",
	}
	Address_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"IN_USE":           17393485,
		"RESERVED":         432241448,
		"RESERVING":        514587225,
	}
)

func (x Address_Status) Enum() *Address_Status {
	p := new(Address_Status)
	*p = x
	return p
}

func (x Address_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[7].Descriptor()
}

func (Address_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[7]
}

func (x Address_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_Status.Descriptor instead.
func (Address_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{36, 5}
}

// Type of Performance Monitoring Unit requested on instance.
type AdvancedMachineFeatures_PerformanceMonitoringUnit int32

const (
	// A value indicating that the enum field is not set.
	AdvancedMachineFeatures_UNDEFINED_PERFORMANCE_MONITORING_UNIT AdvancedMachineFeatures_PerformanceMonitoringUnit = 0
	// Architecturally defined non-LLC events.
	AdvancedMachineFeatures_ARCHITECTURAL AdvancedMachineFeatures_PerformanceMonitoringUnit = 155113693
	// Most documented core/L2 and LLC events.
	AdvancedMachineFeatures_ENHANCED                                AdvancedMachineFeatures_PerformanceMonitoringUnit = 476873590
	AdvancedMachineFeatures_PERFORMANCE_MONITORING_UNIT_UNSPECIFIED AdvancedMachineFeatures_PerformanceMonitoringUnit = 429210692
	// Most documented core/L2 events.
	AdvancedMachineFeatures_STANDARD AdvancedMachineFeatures_PerformanceMonitoringUnit = 484642493
)

// Enum value maps for AdvancedMachineFeatures_PerformanceMonitoringUnit.
var (
	AdvancedMachineFeatures_PerformanceMonitoringUnit_name = map[int32]string{
		0:         "UNDEFINED_PERFORMANCE_MONITORING_UNIT",
		155113693: "ARCHITECTURAL",
		476873590: "ENHANCED",
		429210692: "PERFORMANCE_MONITORING_UNIT_UNSPECIFIED",
		484642493: "STANDARD",
	}
	AdvancedMachineFeatures_PerformanceMonitoringUnit_value = map[string]int32{
		"UNDEFINED_PERFORMANCE_MONITORING_UNIT":   0,
		"ARCHITECTURAL":                           155113693,
		"ENHANCED":                                476873590,
		"PERFORMANCE_MONITORING_UNIT_UNSPECIFIED": 429210692,
		"STANDARD":                                484642493,
	}
)

func (x AdvancedMachineFeatures_PerformanceMonitoringUnit) Enum() *AdvancedMachineFeatures_PerformanceMonitoringUnit {
	p := new(AdvancedMachineFeatures_PerformanceMonitoringUnit)
	*p = x
	return p
}

func (x AdvancedMachineFeatures_PerformanceMonitoringUnit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AdvancedMachineFeatures_PerformanceMonitoringUnit) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[8].Descriptor()
}

func (AdvancedMachineFeatures_PerformanceMonitoringUnit) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[8]
}

func (x AdvancedMachineFeatures_PerformanceMonitoringUnit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AdvancedMachineFeatures_PerformanceMonitoringUnit.Descriptor instead.
func (AdvancedMachineFeatures_PerformanceMonitoringUnit) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{40, 0}
}

// The VM family that all instances scheduled against this reservation must belong to.
type AllocationAggregateReservation_VmFamily int32

const (
	// A value indicating that the enum field is not set.
	AllocationAggregateReservation_UNDEFINED_VM_FAMILY                      AllocationAggregateReservation_VmFamily = 0
	AllocationAggregateReservation_VM_FAMILY_CLOUD_TPU_DEVICE_CT3           AllocationAggregateReservation_VmFamily = 42845948
	AllocationAggregateReservation_VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L     AllocationAggregateReservation_VmFamily = 108020067
	AllocationAggregateReservation_VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP AllocationAggregateReservation_VmFamily = 18705267
	AllocationAggregateReservation_VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E  AllocationAggregateReservation_VmFamily = 398926997
	AllocationAggregateReservation_VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P       AllocationAggregateReservation_VmFamily = 517384376
	AllocationAggregateReservation_VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P       AllocationAggregateReservation_VmFamily = 517384407
	AllocationAggregateReservation_VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P       AllocationAggregateReservation_VmFamily = 517384438
)

// Enum value maps for AllocationAggregateReservation_VmFamily.
var (
	AllocationAggregateReservation_VmFamily_name = map[int32]string{
		0:         "UNDEFINED_VM_FAMILY",
		42845948:  "VM_FAMILY_CLOUD_TPU_DEVICE_CT3",
		108020067: "VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L",
		18705267:  "VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP",
		398926997: "VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E",
		517384376: "VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P",
		517384407: "VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P",
		517384438: "VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P",
	}
	AllocationAggregateReservation_VmFamily_value = map[string]int32{
		"UNDEFINED_VM_FAMILY":                      0,
		"VM_FAMILY_CLOUD_TPU_DEVICE_CT3":           42845948,
		"VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L":     108020067,
		"VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP": 18705267,
		"VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E":  398926997,
		"VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P":       517384376,
		"VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P":       517384407,
		"VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P":       517384438,
	}
)

func (x AllocationAggregateReservation_VmFamily) Enum() *AllocationAggregateReservation_VmFamily {
	p := new(AllocationAggregateReservation_VmFamily)
	*p = x
	return p
}

func (x AllocationAggregateReservation_VmFamily) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationAggregateReservation_VmFamily) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[9].Descriptor()
}

func (AllocationAggregateReservation_VmFamily) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[9]
}

func (x AllocationAggregateReservation_VmFamily) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationAggregateReservation_VmFamily.Descriptor instead.
func (AllocationAggregateReservation_VmFamily) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{91, 0}
}

// The workload type of the instances that will target this reservation.
type AllocationAggregateReservation_WorkloadType int32

const (
	// A value indicating that the enum field is not set.
	AllocationAggregateReservation_UNDEFINED_WORKLOAD_TYPE AllocationAggregateReservation_WorkloadType = 0
	// Reserved resources will be optimized for BATCH workloads, such as ML training.
	AllocationAggregateReservation_BATCH AllocationAggregateReservation_WorkloadType = 62971674
	// Reserved resources will be optimized for SERVING workloads, such as ML inference.
	AllocationAggregateReservation_SERVING     AllocationAggregateReservation_WorkloadType = 17781740
	AllocationAggregateReservation_UNSPECIFIED AllocationAggregateReservation_WorkloadType = 526786327
)

// Enum value maps for AllocationAggregateReservation_WorkloadType.
var (
	AllocationAggregateReservation_WorkloadType_name = map[int32]string{
		0:         "UNDEFINED_WORKLOAD_TYPE",
		62971674:  "BATCH",
		17781740:  "SERVING",
		526786327: "UNSPECIFIED",
	}
	AllocationAggregateReservation_WorkloadType_value = map[string]int32{
		"UNDEFINED_WORKLOAD_TYPE": 0,
		"BATCH":                   62971674,
		"SERVING":                 17781740,
		"UNSPECIFIED":             526786327,
	}
)

func (x AllocationAggregateReservation_WorkloadType) Enum() *AllocationAggregateReservation_WorkloadType {
	p := new(AllocationAggregateReservation_WorkloadType)
	*p = x
	return p
}

func (x AllocationAggregateReservation_WorkloadType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationAggregateReservation_WorkloadType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[10].Descriptor()
}

func (AllocationAggregateReservation_WorkloadType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[10]
}

func (x AllocationAggregateReservation_WorkloadType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationAggregateReservation_WorkloadType.Descriptor instead.
func (AllocationAggregateReservation_WorkloadType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{91, 1}
}

// Sharing config for all Google Cloud services.
type AllocationReservationSharingPolicy_ServiceShareType int32

const (
	// A value indicating that the enum field is not set.
	AllocationReservationSharingPolicy_UNDEFINED_SERVICE_SHARE_TYPE AllocationReservationSharingPolicy_ServiceShareType = 0
	// Allow all Google Cloud managed services to share reservations.
	AllocationReservationSharingPolicy_ALLOW_ALL AllocationReservationSharingPolicy_ServiceShareType = 475536235
	// [Default] Disallow sharing with all Google Cloud services.
	AllocationReservationSharingPolicy_DISALLOW_ALL                   AllocationReservationSharingPolicy_ServiceShareType = 277786301
	AllocationReservationSharingPolicy_SERVICE_SHARE_TYPE_UNSPECIFIED AllocationReservationSharingPolicy_ServiceShareType = 279057148
)

// Enum value maps for AllocationReservationSharingPolicy_ServiceShareType.
var (
	AllocationReservationSharingPolicy_ServiceShareType_name = map[int32]string{
		0:         "UNDEFINED_SERVICE_SHARE_TYPE",
		475536235: "ALLOW_ALL",
		277786301: "DISALLOW_ALL",
		279057148: "SERVICE_SHARE_TYPE_UNSPECIFIED",
	}
	AllocationReservationSharingPolicy_ServiceShareType_value = map[string]int32{
		"UNDEFINED_SERVICE_SHARE_TYPE":   0,
		"ALLOW_ALL":                      475536235,
		"DISALLOW_ALL":                   277786301,
		"SERVICE_SHARE_TYPE_UNSPECIFIED": 279057148,
	}
)

func (x AllocationReservationSharingPolicy_ServiceShareType) Enum() *AllocationReservationSharingPolicy_ServiceShareType {
	p := new(AllocationReservationSharingPolicy_ServiceShareType)
	*p = x
	return p
}

func (x AllocationReservationSharingPolicy_ServiceShareType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationReservationSharingPolicy_ServiceShareType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[11].Descriptor()
}

func (AllocationReservationSharingPolicy_ServiceShareType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[11]
}

func (x AllocationReservationSharingPolicy_ServiceShareType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationReservationSharingPolicy_ServiceShareType.Descriptor instead.
func (AllocationReservationSharingPolicy_ServiceShareType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{94, 0}
}

// The health status of the reservation.
type AllocationResourceStatusHealthInfo_HealthStatus int32

const (
	// A value indicating that the enum field is not set.
	AllocationResourceStatusHealthInfo_UNDEFINED_HEALTH_STATUS AllocationResourceStatusHealthInfo_HealthStatus = 0
	// The reservation is degraded.
	AllocationResourceStatusHealthInfo_DEGRADED AllocationResourceStatusHealthInfo_HealthStatus = 396890926
	// The reservation is healthy.
	AllocationResourceStatusHealthInfo_HEALTHY AllocationResourceStatusHealthInfo_HealthStatus = 439801213
	// The health status of the reservation is unspecified.
	AllocationResourceStatusHealthInfo_HEALTH_STATUS_UNSPECIFIED AllocationResourceStatusHealthInfo_HealthStatus = 482246925
)

// Enum value maps for AllocationResourceStatusHealthInfo_HealthStatus.
var (
	AllocationResourceStatusHealthInfo_HealthStatus_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATUS",
		396890926: "DEGRADED",
		439801213: "HEALTHY",
		482246925: "HEALTH_STATUS_UNSPECIFIED",
	}
	AllocationResourceStatusHealthInfo_HealthStatus_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS":   0,
		"DEGRADED":                  396890926,
		"HEALTHY":                   439801213,
		"HEALTH_STATUS_UNSPECIFIED": 482246925,
	}
)

func (x AllocationResourceStatusHealthInfo_HealthStatus) Enum() *AllocationResourceStatusHealthInfo_HealthStatus {
	p := new(AllocationResourceStatusHealthInfo_HealthStatus)
	*p = x
	return p
}

func (x AllocationResourceStatusHealthInfo_HealthStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationResourceStatusHealthInfo_HealthStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[12].Descriptor()
}

func (AllocationResourceStatusHealthInfo_HealthStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[12]
}

func (x AllocationResourceStatusHealthInfo_HealthStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationResourceStatusHealthInfo_HealthStatus.Descriptor instead.
func (AllocationResourceStatusHealthInfo_HealthStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{96, 0}
}

// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
type AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface int32

const (
	// A value indicating that the enum field is not set.
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_UNDEFINED_INTERFACE AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface = 0
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_NVME                AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface = 2408800
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_SCSI                AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface = 2539686
)

// Enum value maps for AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface.
var (
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface_name = map[int32]string{
		0:       "UNDEFINED_INTERFACE",
		2408800: "NVME",
		2539686: "SCSI",
	}
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface_value = map[string]int32{
		"UNDEFINED_INTERFACE": 0,
		"NVME":                2408800,
		"SCSI":                2539686,
	}
)

func (x AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Enum() *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface {
	p := new(AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface)
	*p = x
	return p
}

func (x AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[13].Descriptor()
}

func (AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[13]
}

func (x AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface.Descriptor instead.
func (AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{98, 0}
}

// Specifies the frequency of planned maintenance events. The accepted values are: `PERIODIC`.
type AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval int32

const (
	// A value indicating that the enum field is not set.
	AllocationSpecificSKUAllocationReservedInstanceProperties_UNDEFINED_MAINTENANCE_INTERVAL AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval = 0
	// VMs are eligible to receive infrastructure and hypervisor updates as they become available. This may result in more maintenance operations (live migrations or terminations) for the VM than the PERIODIC and RECURRENT options.
	AllocationSpecificSKUAllocationReservedInstanceProperties_AS_NEEDED AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval = 500724834
	// VMs receive infrastructure and hypervisor updates on a periodic basis, minimizing the number of maintenance operations (live migrations or terminations) on an individual VM. This may mean a VM will take longer to receive an update than if it was configured for AS_NEEDED. Security updates will still be applied as soon as they are available.
	AllocationSpecificSKUAllocationReservedInstanceProperties_PERIODIC AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval = 142804635
	// VMs receive infrastructure and hypervisor updates on a periodic basis, minimizing the number of maintenance operations (live migrations or terminations) on an individual VM. This may mean a VM will take longer to receive an update than if it was configured for AS_NEEDED. Security updates will still be applied as soon as they are available. RECURRENT is used for GEN3 and Slice of Hardware VMs.
	AllocationSpecificSKUAllocationReservedInstanceProperties_RECURRENT AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval = 194244550
)

// Enum value maps for AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval.
var (
	AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval_name = map[int32]string{
		0:         "UNDEFINED_MAINTENANCE_INTERVAL",
		500724834: "AS_NEEDED",
		142804635: "PERIODIC",
		194244550: "RECURRENT",
	}
	AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval_value = map[string]int32{
		"UNDEFINED_MAINTENANCE_INTERVAL": 0,
		"AS_NEEDED":                      500724834,
		"PERIODIC":                       142804635,
		"RECURRENT":                      194244550,
	}
)

func (x AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval) Enum() *AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval {
	p := new(AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval)
	*p = x
	return p
}

func (x AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[14].Descriptor()
}

func (AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[14]
}

func (x AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval.Descriptor instead.
func (AllocationSpecificSKUAllocationReservedInstanceProperties_MaintenanceInterval) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{99, 0}
}

// [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
type AttachedDisk_Architecture int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_ARCHITECTURE AttachedDisk_Architecture = 0
	// Default value indicating Architecture is not set.
	AttachedDisk_ARCHITECTURE_UNSPECIFIED AttachedDisk_Architecture = 394750507
	// Machines with architecture ARM64
	AttachedDisk_ARM64 AttachedDisk_Architecture = 62547450
	// Machines with architecture X86_64
	AttachedDisk_X86_64 AttachedDisk_Architecture = 425300551
)

// Enum value maps for AttachedDisk_Architecture.
var (
	AttachedDisk_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	AttachedDisk_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x AttachedDisk_Architecture) Enum() *AttachedDisk_Architecture {
	p := new(AttachedDisk_Architecture)
	*p = x
	return p
}

func (x AttachedDisk_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[15].Descriptor()
}

func (AttachedDisk_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[15]
}

func (x AttachedDisk_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Architecture.Descriptor instead.
func (AttachedDisk_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{110, 0}
}

// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
type AttachedDisk_Interface int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_INTERFACE AttachedDisk_Interface = 0
	AttachedDisk_NVME                AttachedDisk_Interface = 2408800
	AttachedDisk_SCSI                AttachedDisk_Interface = 2539686
)

// Enum value maps for AttachedDisk_Interface.
var (
	AttachedDisk_Interface_name = map[int32]string{
		0:       "UNDEFINED_INTERFACE",
		2408800: "NVME",
		2539686: "SCSI",
	}
	AttachedDisk_Interface_value = map[string]int32{
		"UNDEFINED_INTERFACE": 0,
		"NVME":                2408800,
		"SCSI":                2539686,
	}
)

func (x AttachedDisk_Interface) Enum() *AttachedDisk_Interface {
	p := new(AttachedDisk_Interface)
	*p = x
	return p
}

func (x AttachedDisk_Interface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Interface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[16].Descriptor()
}

func (AttachedDisk_Interface) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[16]
}

func (x AttachedDisk_Interface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Interface.Descriptor instead.
func (AttachedDisk_Interface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{110, 1}
}

// The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
type AttachedDisk_Mode int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_MODE AttachedDisk_Mode = 0
	// Attaches this disk in read-only mode. Multiple virtual machines can use a disk in read-only mode at a time.
	AttachedDisk_READ_ONLY AttachedDisk_Mode = 91950261
	// *[Default]* Attaches this disk in read-write mode. Only one virtual machine at a time can be attached to a disk in read-write mode.
	AttachedDisk_READ_WRITE AttachedDisk_Mode = 173607894
)

// Enum value maps for AttachedDisk_Mode.
var (
	AttachedDisk_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		91950261:  "READ_ONLY",
		173607894: "READ_WRITE",
	}
	AttachedDisk_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"READ_ONLY":      91950261,
		"READ_WRITE":     173607894,
	}
)

func (x AttachedDisk_Mode) Enum() *AttachedDisk_Mode {
	p := new(AttachedDisk_Mode)
	*p = x
	return p
}

func (x AttachedDisk_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[17].Descriptor()
}

func (AttachedDisk_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[17]
}

func (x AttachedDisk_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Mode.Descriptor instead.
func (AttachedDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{110, 2}
}

// For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state, this field is set to PRESERVED if the LocalSSD data has been saved to a persistent location by customer request. (see the discard_local_ssd option on Stop/Suspend). Read-only in the api.
type AttachedDisk_SavedState int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_SAVED_STATE AttachedDisk_SavedState = 0
	// *[Default]* Disk state has not been preserved.
	AttachedDisk_DISK_SAVED_STATE_UNSPECIFIED AttachedDisk_SavedState = 391290831
	// Disk state has been preserved.
	AttachedDisk_PRESERVED AttachedDisk_SavedState = 254159736
)

// Enum value maps for AttachedDisk_SavedState.
var (
	AttachedDisk_SavedState_name = map[int32]string{
		0:         "UNDEFINED_SAVED_STATE",
		391290831: "DISK_SAVED_STATE_UNSPECIFIED",
		254159736: "PRESERVED",
	}
	AttachedDisk_SavedState_value = map[string]int32{
		"UNDEFINED_SAVED_STATE":        0,
		"DISK_SAVED_STATE_UNSPECIFIED": 391290831,
		"PRESERVED":                    254159736,
	}
)

func (x AttachedDisk_SavedState) Enum() *AttachedDisk_SavedState {
	p := new(AttachedDisk_SavedState)
	*p = x
	return p
}

func (x AttachedDisk_SavedState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_SavedState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[18].Descriptor()
}

func (AttachedDisk_SavedState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[18]
}

func (x AttachedDisk_SavedState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_SavedState.Descriptor instead.
func (AttachedDisk_SavedState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{110, 3}
}

// Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
type AttachedDisk_Type int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_TYPE AttachedDisk_Type = 0
	AttachedDisk_PERSISTENT     AttachedDisk_Type = 460683927
	AttachedDisk_SCRATCH        AttachedDisk_Type = 496778970
)

// Enum value maps for AttachedDisk_Type.
var (
	AttachedDisk_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		460683927: "PERSISTENT",
		496778970: "SCRATCH",
	}
	AttachedDisk_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"PERSISTENT":     460683927,
		"SCRATCH":        496778970,
	}
)

func (x AttachedDisk_Type) Enum() *AttachedDisk_Type {
	p := new(AttachedDisk_Type)
	*p = x
	return p
}

func (x AttachedDisk_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[19].Descriptor()
}

func (AttachedDisk_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[19]
}

func (x AttachedDisk_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Type.Descriptor instead.
func (AttachedDisk_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{110, 4}
}

// The architecture of the attached disk. Valid values are arm64 or x86_64.
type AttachedDiskInitializeParams_Architecture int32

const (
	// A value indicating that the enum field is not set.
	AttachedDiskInitializeParams_UNDEFINED_ARCHITECTURE AttachedDiskInitializeParams_Architecture = 0
	// Default value indicating Architecture is not set.
	AttachedDiskInitializeParams_ARCHITECTURE_UNSPECIFIED AttachedDiskInitializeParams_Architecture = 394750507
	// Machines with architecture ARM64
	AttachedDiskInitializeParams_ARM64 AttachedDiskInitializeParams_Architecture = 62547450
	// Machines with architecture X86_64
	AttachedDiskInitializeParams_X86_64 AttachedDiskInitializeParams_Architecture = 425300551
)

// Enum value maps for AttachedDiskInitializeParams_Architecture.
var (
	AttachedDiskInitializeParams_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	AttachedDiskInitializeParams_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x AttachedDiskInitializeParams_Architecture) Enum() *AttachedDiskInitializeParams_Architecture {
	p := new(AttachedDiskInitializeParams_Architecture)
	*p = x
	return p
}

func (x AttachedDiskInitializeParams_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDiskInitializeParams_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[20].Descriptor()
}

func (AttachedDiskInitializeParams_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[20]
}

func (x AttachedDiskInitializeParams_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDiskInitializeParams_Architecture.Descriptor instead.
func (AttachedDiskInitializeParams_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{111, 0}
}

// Specifies which action to take on instance update with this disk. Default is to use the existing disk.
type AttachedDiskInitializeParams_OnUpdateAction int32

const (
	// A value indicating that the enum field is not set.
	AttachedDiskInitializeParams_UNDEFINED_ON_UPDATE_ACTION AttachedDiskInitializeParams_OnUpdateAction = 0
	// Always recreate the disk.
	AttachedDiskInitializeParams_RECREATE_DISK AttachedDiskInitializeParams_OnUpdateAction = 494767853
	// Recreate the disk if source (image, snapshot) of this disk is different from source of existing disk.
	AttachedDiskInitializeParams_RECREATE_DISK_IF_SOURCE_CHANGED AttachedDiskInitializeParams_OnUpdateAction = 398099712
	// Use the existing disk, this is the default behaviour.
	AttachedDiskInitializeParams_USE_EXISTING_DISK AttachedDiskInitializeParams_OnUpdateAction = 232682233
)

// Enum value maps for AttachedDiskInitializeParams_OnUpdateAction.
var (
	AttachedDiskInitializeParams_OnUpdateAction_name = map[int32]string{
		0:         "UNDEFINED_ON_UPDATE_ACTION",
		494767853: "RECREATE_DISK",
		398099712: "RECREATE_DISK_IF_SOURCE_CHANGED",
		232682233: "USE_EXISTING_DISK",
	}
	AttachedDiskInitializeParams_OnUpdateAction_value = map[string]int32{
		"UNDEFINED_ON_UPDATE_ACTION":      0,
		"RECREATE_DISK":                   494767853,
		"RECREATE_DISK_IF_SOURCE_CHANGED": 398099712,
		"USE_EXISTING_DISK":               232682233,
	}
)

func (x AttachedDiskInitializeParams_OnUpdateAction) Enum() *AttachedDiskInitializeParams_OnUpdateAction {
	p := new(AttachedDiskInitializeParams_OnUpdateAction)
	*p = x
	return p
}

func (x AttachedDiskInitializeParams_OnUpdateAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDiskInitializeParams_OnUpdateAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[21].Descriptor()
}

func (AttachedDiskInitializeParams_OnUpdateAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[21]
}

func (x AttachedDiskInitializeParams_OnUpdateAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDiskInitializeParams_OnUpdateAction.Descriptor instead.
func (AttachedDiskInitializeParams_OnUpdateAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{111, 1}
}

// The log type that this config enables.
type AuditLogConfig_LogType int32

const (
	// A value indicating that the enum field is not set.
	AuditLogConfig_UNDEFINED_LOG_TYPE AuditLogConfig_LogType = 0
	// Admin reads. Example: CloudIAM getIamPolicy
	AuditLogConfig_ADMIN_READ AuditLogConfig_LogType = 128951462
	// Data reads. Example: CloudSQL Users list
	AuditLogConfig_DATA_READ AuditLogConfig_LogType = 305224971
	// Data writes. Example: CloudSQL Users create
	AuditLogConfig_DATA_WRITE AuditLogConfig_LogType = 340181738
	// Default case. Should never be this.
	AuditLogConfig_LOG_TYPE_UNSPECIFIED AuditLogConfig_LogType = 154527053
)

// Enum value maps for AuditLogConfig_LogType.
var (
	AuditLogConfig_LogType_name = map[int32]string{
		0:         "UNDEFINED_LOG_TYPE",
		128951462: "ADMIN_READ",
		305224971: "DATA_READ",
		340181738: "DATA_WRITE",
		154527053: "LOG_TYPE_UNSPECIFIED",
	}
	AuditLogConfig_LogType_value = map[string]int32{
		"UNDEFINED_LOG_TYPE":   0,
		"ADMIN_READ":           128951462,
		"DATA_READ":            305224971,
		"DATA_WRITE":           340181738,
		"LOG_TYPE_UNSPECIFIED": 154527053,
	}
)

func (x AuditLogConfig_LogType) Enum() *AuditLogConfig_LogType {
	p := new(AuditLogConfig_LogType)
	*p = x
	return p
}

func (x AuditLogConfig_LogType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuditLogConfig_LogType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[22].Descriptor()
}

func (AuditLogConfig_LogType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[22]
}

func (x AuditLogConfig_LogType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuditLogConfig_LogType.Descriptor instead.
func (AuditLogConfig_LogType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{113, 0}
}

// [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
type Autoscaler_Status int32

const (
	// A value indicating that the enum field is not set.
	Autoscaler_UNDEFINED_STATUS Autoscaler_Status = 0
	// Configuration is acknowledged to be effective
	Autoscaler_ACTIVE Autoscaler_Status = 314733318
	// Configuration is being deleted
	Autoscaler_DELETING Autoscaler_Status = 528602024
	// Configuration has errors. Actionable for users.
	Autoscaler_ERROR Autoscaler_Status = 66247144
	// Autoscaler backend hasn't read new/updated configuration
	Autoscaler_PENDING Autoscaler_Status = 35394935
)

// Enum value maps for Autoscaler_Status.
var (
	Autoscaler_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		528602024: "DELETING",
		66247144:  "ERROR",
		35394935:  "PENDING",
	}
	Autoscaler_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ACTIVE":           314733318,
		"DELETING":         528602024,
		"ERROR":            66247144,
		"PENDING":          35394935,
	}
)

func (x Autoscaler_Status) Enum() *Autoscaler_Status {
	p := new(Autoscaler_Status)
	*p = x
	return p
}

func (x Autoscaler_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Autoscaler_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[23].Descriptor()
}

func (Autoscaler_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[23]
}

func (x Autoscaler_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Autoscaler_Status.Descriptor instead.
func (Autoscaler_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{114, 0}
}

// The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.
type AutoscalerStatusDetails_Type int32

const (
	// A value indicating that the enum field is not set.
	AutoscalerStatusDetails_UNDEFINED_TYPE AutoscalerStatusDetails_Type = 0
	// All instances in the instance group are unhealthy (not in RUNNING state).
	AutoscalerStatusDetails_ALL_INSTANCES_UNHEALTHY AutoscalerStatusDetails_Type = 404965477
	// There is no backend service attached to the instance group.
	AutoscalerStatusDetails_BACKEND_SERVICE_DOES_NOT_EXIST AutoscalerStatusDetails_Type = 191417626
	// Autoscaler recommends a size greater than maxNumReplicas.
	AutoscalerStatusDetails_CAPPED_AT_MAX_NUM_REPLICAS AutoscalerStatusDetails_Type = 518617
	// The custom metric samples are not exported often enough to be a credible base for autoscaling.
	AutoscalerStatusDetails_CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE AutoscalerStatusDetails_Type = 328964659
	// The custom metric that was specified does not exist or does not have the necessary labels.
	AutoscalerStatusDetails_CUSTOM_METRIC_INVALID AutoscalerStatusDetails_Type = 204430550
	// The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group.
	AutoscalerStatusDetails_MIN_EQUALS_MAX AutoscalerStatusDetails_Type = 2821361
	// The autoscaler did not receive any data from the custom metric configured for autoscaling.
	AutoscalerStatusDetails_MISSING_CUSTOM_METRIC_DATA_POINTS AutoscalerStatusDetails_Type = 94885086
	// The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer.
	AutoscalerStatusDetails_MISSING_LOAD_BALANCING_DATA_POINTS AutoscalerStatusDetails_Type = 509858898
	// Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved.
	AutoscalerStatusDetails_MODE_OFF AutoscalerStatusDetails_Type = 164169907
	// Autoscaling is in the "Autoscale only scale out" mode. Instances in the group will be only added.
	AutoscalerStatusDetails_MODE_ONLY_SCALE_OUT AutoscalerStatusDetails_Type = 3840994
	// Autoscaling is in the "Autoscale only out" mode. Instances in the group will be only added.
	AutoscalerStatusDetails_MODE_ONLY_UP AutoscalerStatusDetails_Type = 100969842
	// The instance group cannot be autoscaled because it has more than one backend service attached to it.
	AutoscalerStatusDetails_MORE_THAN_ONE_BACKEND_SERVICE AutoscalerStatusDetails_Type = 151922141
	// There is insufficient quota for the necessary resources, such as CPU or number of instances.
	AutoscalerStatusDetails_NOT_ENOUGH_QUOTA_AVAILABLE AutoscalerStatusDetails_Type = 403101631
	// Showed only for regional autoscalers: there is a resource stockout in the chosen region.
	AutoscalerStatusDetails_REGION_RESOURCE_STOCKOUT AutoscalerStatusDetails_Type = 528622846
	// The target to be scaled does not exist.
	AutoscalerStatusDetails_SCALING_TARGET_DOES_NOT_EXIST AutoscalerStatusDetails_Type = 122636699
	// For some scaling schedules minRequiredReplicas is greater than maxNumReplicas. Autoscaler always recommends at most maxNumReplicas instances.
	AutoscalerStatusDetails_SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX AutoscalerStatusDetails_Type = 29275586
	// For some scaling schedules minRequiredReplicas is less than minNumReplicas. Autoscaler always recommends at least minNumReplicas instances.
	AutoscalerStatusDetails_SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN AutoscalerStatusDetails_Type = 398287669
	AutoscalerStatusDetails_UNKNOWN                                      AutoscalerStatusDetails_Type = 433141802
	// Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate.
	AutoscalerStatusDetails_UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION AutoscalerStatusDetails_Type = 330845009
	// For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout.
	AutoscalerStatusDetails_ZONE_RESOURCE_STOCKOUT AutoscalerStatusDetails_Type = 210200502
)

// Enum value maps for AutoscalerStatusDetails_Type.
var (
	AutoscalerStatusDetails_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		404965477: "ALL_INSTANCES_UNHEALTHY",
		191417626: "BACKEND_SERVICE_DOES_NOT_EXIST",
		518617:    "CAPPED_AT_MAX_NUM_REPLICAS",
		328964659: "CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE",
		204430550: "CUSTOM_METRIC_INVALID",
		2821361:   "MIN_EQUALS_MAX",
		94885086:  "MISSING_CUSTOM_METRIC_DATA_POINTS",
		509858898: "MISSING_LOAD_BALANCING_DATA_POINTS",
		164169907: "MODE_OFF",
		3840994:   "MODE_ONLY_SCALE_OUT",
		100969842: "MODE_ONLY_UP",
		151922141: "MORE_THAN_ONE_BACKEND_SERVICE",
		403101631: "NOT_ENOUGH_QUOTA_AVAILABLE",
		528622846: "REGION_RESOURCE_STOCKOUT",
		122636699: "SCALING_TARGET_DOES_NOT_EXIST",
		29275586:  "SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX",
		398287669: "SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN",
		433141802: "UNKNOWN",
		330845009: "UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION",
		210200502: "ZONE_RESOURCE_STOCKOUT",
	}
	AutoscalerStatusDetails_Type_value = map[string]int32{
		"UNDEFINED_TYPE":                                  0,
		"ALL_INSTANCES_UNHEALTHY":                         404965477,
		"BACKEND_SERVICE_DOES_NOT_EXIST":                  191417626,
		"CAPPED_AT_MAX_NUM_REPLICAS":                      518617,
		"CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE":            328964659,
		"CUSTOM_METRIC_INVALID":                           204430550,
		"MIN_EQUALS_MAX":                                  2821361,
		"MISSING_CUSTOM_METRIC_DATA_POINTS":               94885086,
		"MISSING_LOAD_BALANCING_DATA_POINTS":              509858898,
		"MODE_OFF":                                        164169907,
		"MODE_ONLY_SCALE_OUT":                             3840994,
		"MODE_ONLY_UP":                                    100969842,
		"MORE_THAN_ONE_BACKEND_SERVICE":                   151922141,
		"NOT_ENOUGH_QUOTA_AVAILABLE":                      403101631,
		"REGION_RESOURCE_STOCKOUT":                        528622846,
		"SCALING_TARGET_DOES_NOT_EXIST":                   122636699,
		"SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX": 29275586,
		"SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN":    398287669,
		"UNKNOWN": 433141802,
		"UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION": 330845009,
		"ZONE_RESOURCE_STOCKOUT":                            210200502,
	}
)

func (x AutoscalerStatusDetails_Type) Enum() *AutoscalerStatusDetails_Type {
	p := new(AutoscalerStatusDetails_Type)
	*p = x
	return p
}

func (x AutoscalerStatusDetails_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalerStatusDetails_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[24].Descriptor()
}

func (AutoscalerStatusDetails_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[24]
}

func (x AutoscalerStatusDetails_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalerStatusDetails_Type.Descriptor instead.
func (AutoscalerStatusDetails_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{117, 0}
}

// Defines the operating mode for this policy. The following modes are available: - OFF: Disables the autoscaler but maintains its configuration. - ONLY_SCALE_OUT: Restricts the autoscaler to add VM instances only. - ON: Enables all autoscaler activities according to its policy. For more information, see "Turning off or restricting an autoscaler"
type AutoscalingPolicy_Mode int32

const (
	// A value indicating that the enum field is not set.
	AutoscalingPolicy_UNDEFINED_MODE AutoscalingPolicy_Mode = 0
	// Do not automatically scale the MIG in or out. The recommended_size field contains the size of MIG that would be set if the actuation mode was enabled.
	AutoscalingPolicy_OFF AutoscalingPolicy_Mode = 78159
	// Automatically scale the MIG in and out according to the policy.
	AutoscalingPolicy_ON AutoscalingPolicy_Mode = 2527
	// Automatically create VMs according to the policy, but do not scale the MIG in.
	AutoscalingPolicy_ONLY_SCALE_OUT AutoscalingPolicy_Mode = 152713670
	// Automatically create VMs according to the policy, but do not scale the MIG in.
	AutoscalingPolicy_ONLY_UP AutoscalingPolicy_Mode = 478095374
)

// Enum value maps for AutoscalingPolicy_Mode.
var (
	AutoscalingPolicy_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		78159:     "OFF",
		2527:      "ON",
		152713670: "ONLY_SCALE_OUT",
		478095374: "ONLY_UP",
	}
	AutoscalingPolicy_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"OFF":            78159,
		"ON":             2527,
		"ONLY_SCALE_OUT": 152713670,
		"ONLY_UP":        478095374,
	}
)

func (x AutoscalingPolicy_Mode) Enum() *AutoscalingPolicy_Mode {
	p := new(AutoscalingPolicy_Mode)
	*p = x
	return p
}

func (x AutoscalingPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[25].Descriptor()
}

func (AutoscalingPolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[25]
}

func (x AutoscalingPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingPolicy_Mode.Descriptor instead.
func (AutoscalingPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{119, 0}
}

// Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
type AutoscalingPolicyCpuUtilization_PredictiveMethod int32

const (
	// A value indicating that the enum field is not set.
	AutoscalingPolicyCpuUtilization_UNDEFINED_PREDICTIVE_METHOD AutoscalingPolicyCpuUtilization_PredictiveMethod = 0
	// No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics
	AutoscalingPolicyCpuUtilization_NONE AutoscalingPolicyCpuUtilization_PredictiveMethod = 2402104
	// Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
	AutoscalingPolicyCpuUtilization_OPTIMIZE_AVAILABILITY         AutoscalingPolicyCpuUtilization_PredictiveMethod = 11629437
	AutoscalingPolicyCpuUtilization_PREDICTIVE_METHOD_UNSPECIFIED AutoscalingPolicyCpuUtilization_PredictiveMethod = 52410265
)

// Enum value maps for AutoscalingPolicyCpuUtilization_PredictiveMethod.
var (
	AutoscalingPolicyCpuUtilization_PredictiveMethod_name = map[int32]string{
		0:        "UNDEFINED_PREDICTIVE_METHOD",
		2402104:  "NONE",
		11629437: "OPTIMIZE_AVAILABILITY",
		52410265: "PREDICTIVE_METHOD_UNSPECIFIED",
	}
	AutoscalingPolicyCpuUtilization_PredictiveMethod_value = map[string]int32{
		"UNDEFINED_PREDICTIVE_METHOD":   0,
		"NONE":                          2402104,
		"OPTIMIZE_AVAILABILITY":         11629437,
		"PREDICTIVE_METHOD_UNSPECIFIED": 52410265,
	}
)

func (x AutoscalingPolicyCpuUtilization_PredictiveMethod) Enum() *AutoscalingPolicyCpuUtilization_PredictiveMethod {
	p := new(AutoscalingPolicyCpuUtilization_PredictiveMethod)
	*p = x
	return p
}

func (x AutoscalingPolicyCpuUtilization_PredictiveMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingPolicyCpuUtilization_PredictiveMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[26].Descriptor()
}

func (AutoscalingPolicyCpuUtilization_PredictiveMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[26]
}

func (x AutoscalingPolicyCpuUtilization_PredictiveMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingPolicyCpuUtilization_PredictiveMethod.Descriptor instead.
func (AutoscalingPolicyCpuUtilization_PredictiveMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{120, 0}
}

// Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
type AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType int32

const (
	// A value indicating that the enum field is not set.
	AutoscalingPolicyCustomMetricUtilization_UNDEFINED_UTILIZATION_TARGET_TYPE AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 0
	// Sets the utilization target value for a cumulative or delta metric, expressed as the rate of growth per minute.
	AutoscalingPolicyCustomMetricUtilization_DELTA_PER_MINUTE AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 87432861
	// Sets the utilization target value for a cumulative or delta metric, expressed as the rate of growth per second.
	AutoscalingPolicyCustomMetricUtilization_DELTA_PER_SECOND AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 255180029
	// Sets the utilization target value for a gauge metric. The autoscaler will collect the average utilization of the virtual machines from the last couple of minutes, and compare the value to the utilization target value to perform autoscaling.
	AutoscalingPolicyCustomMetricUtilization_GAUGE AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 67590361
)

// Enum value maps for AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType.
var (
	AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType_name = map[int32]string{
		0:         "UNDEFINED_UTILIZATION_TARGET_TYPE",
		87432861:  "DELTA_PER_MINUTE",
		255180029: "DELTA_PER_SECOND",
		67590361:  "GAUGE",
	}
	AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType_value = map[string]int32{
		"UNDEFINED_UTILIZATION_TARGET_TYPE": 0,
		"DELTA_PER_MINUTE":                  87432861,
		"DELTA_PER_SECOND":                  255180029,
		"GAUGE":                             67590361,
	}
)

func (x AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Enum() *AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType {
	p := new(AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType)
	*p = x
	return p
}

func (x AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[27].Descriptor()
}

func (AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[27]
}

func (x AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType.Descriptor instead.
func (AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{121, 0}
}

// Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
type Backend_BalancingMode int32

const (
	// A value indicating that the enum field is not set.
	Backend_UNDEFINED_BALANCING_MODE Backend_BalancingMode = 0
	// Balance based on the number of simultaneous connections.
	Backend_CONNECTION Backend_BalancingMode = 246311646
	// Based on custom defined and reported metrics.
	Backend_CUSTOM_METRICS Backend_BalancingMode = 331575765
	// Balance based on the number of in-flight requests.
	Backend_IN_FLIGHT Backend_BalancingMode = 190040266
	// Balance based on requests per second (RPS).
	Backend_RATE Backend_BalancingMode = 2508000
	// Balance based on the backend utilization.
	Backend_UTILIZATION Backend_BalancingMode = 157008386
)

// Enum value maps for Backend_BalancingMode.
var (
	Backend_BalancingMode_name = map[int32]string{
		0:         "UNDEFINED_BALANCING_MODE",
		246311646: "CONNECTION",
		331575765: "CUSTOM_METRICS",
		190040266: "IN_FLIGHT",
		2508000:   "RATE",
		157008386: "UTILIZATION",
	}
	Backend_BalancingMode_value = map[string]int32{
		"UNDEFINED_BALANCING_MODE": 0,
		"CONNECTION":               246311646,
		"CUSTOM_METRICS":           331575765,
		"IN_FLIGHT":                190040266,
		"RATE":                     2508000,
		"UTILIZATION":              157008386,
	}
)

func (x Backend_BalancingMode) Enum() *Backend_BalancingMode {
	p := new(Backend_BalancingMode)
	*p = x
	return p
}

func (x Backend_BalancingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backend_BalancingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[28].Descriptor()
}

func (Backend_BalancingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[28]
}

func (x Backend_BalancingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backend_BalancingMode.Descriptor instead.
func (Backend_BalancingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{126, 0}
}

// This field indicates whether this backend should be fully utilized before sending traffic to backends with default preference. The possible values are: - PREFERRED: Backends with this preference level will be filled up to their capacity limits first, based on RTT. - DEFAULT: If preferred backends don't have enough capacity, backends in this layer would be used and traffic would be assigned based on the load balancing algorithm you use. This is the default
type Backend_Preference int32

const (
	// A value indicating that the enum field is not set.
	Backend_UNDEFINED_PREFERENCE Backend_Preference = 0
	// No preference.
	Backend_DEFAULT Backend_Preference = 115302945
	// If preference is unspecified, we set it to the DEFAULT value
	Backend_PREFERENCE_UNSPECIFIED Backend_Preference = 496219571
	// Traffic will be sent to this backend first.
	Backend_PREFERRED Backend_Preference = 418847841
)

// Enum value maps for Backend_Preference.
var (
	Backend_Preference_name = map[int32]string{
		0:         "UNDEFINED_PREFERENCE",
		115302945: "DEFAULT",
		496219571: "PREFERENCE_UNSPECIFIED",
		418847841: "PREFERRED",
	}
	Backend_Preference_value = map[string]int32{
		"UNDEFINED_PREFERENCE":   0,
		"DEFAULT":                115302945,
		"PREFERENCE_UNSPECIFIED": 496219571,
		"PREFERRED":              418847841,
	}
)

func (x Backend_Preference) Enum() *Backend_Preference {
	p := new(Backend_Preference)
	*p = x
	return p
}

func (x Backend_Preference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backend_Preference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[29].Descriptor()
}

func (Backend_Preference) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[29]
}

func (x Backend_Preference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backend_Preference.Descriptor instead.
func (Backend_Preference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{126, 1}
}

type Backend_TrafficDuration int32

const (
	// A value indicating that the enum field is not set.
	Backend_UNDEFINED_TRAFFIC_DURATION Backend_TrafficDuration = 0
	// Most of the requests are expected to take more than multiple seconds to finish.
	Backend_LONG Backend_TrafficDuration = 2342524
	// Most requests are expected to finish with a sub-second latency.
	Backend_SHORT Backend_TrafficDuration = 78875740
	// Traffic duration is unspecified.
	Backend_TRAFFIC_DURATION_UNSPECIFIED Backend_TrafficDuration = 265201166
)

// Enum value maps for Backend_TrafficDuration.
var (
	Backend_TrafficDuration_name = map[int32]string{
		0:         "UNDEFINED_TRAFFIC_DURATION",
		2342524:   "LONG",
		78875740:  "SHORT",
		265201166: "TRAFFIC_DURATION_UNSPECIFIED",
	}
	Backend_TrafficDuration_value = map[string]int32{
		"UNDEFINED_TRAFFIC_DURATION":   0,
		"LONG":                         2342524,
		"SHORT":                        78875740,
		"TRAFFIC_DURATION_UNSPECIFIED": 265201166,
	}
)

func (x Backend_TrafficDuration) Enum() *Backend_TrafficDuration {
	p := new(Backend_TrafficDuration)
	*p = x
	return p
}

func (x Backend_TrafficDuration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backend_TrafficDuration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[30].Descriptor()
}

func (Backend_TrafficDuration) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[30]
}

func (x Backend_TrafficDuration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backend_TrafficDuration.Descriptor instead.
func (Backend_TrafficDuration) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{126, 2}
}

// Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
type BackendBucket_CompressionMode int32

const (
	// A value indicating that the enum field is not set.
	BackendBucket_UNDEFINED_COMPRESSION_MODE BackendBucket_CompressionMode = 0
	// Automatically uses the best compression based on the Accept-Encoding header sent by the client.
	BackendBucket_AUTOMATIC BackendBucket_CompressionMode = 165298699
	// Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
	BackendBucket_DISABLED BackendBucket_CompressionMode = 516696700
)

// Enum value maps for BackendBucket_CompressionMode.
var (
	BackendBucket_CompressionMode_name = map[int32]string{
		0:         "UNDEFINED_COMPRESSION_MODE",
		165298699: "AUTOMATIC",
		516696700: "DISABLED",
	}
	BackendBucket_CompressionMode_value = map[string]int32{
		"UNDEFINED_COMPRESSION_MODE": 0,
		"AUTOMATIC":                  165298699,
		"DISABLED":                   516696700,
	}
)

func (x BackendBucket_CompressionMode) Enum() *BackendBucket_CompressionMode {
	p := new(BackendBucket_CompressionMode)
	*p = x
	return p
}

func (x BackendBucket_CompressionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendBucket_CompressionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[31].Descriptor()
}

func (BackendBucket_CompressionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[31]
}

func (x BackendBucket_CompressionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendBucket_CompressionMode.Descriptor instead.
func (BackendBucket_CompressionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{127, 0}
}

// The value can only be INTERNAL_MANAGED for cross-region internal layer 7 load balancer. If loadBalancingScheme is not specified, the backend bucket can be used by classic global external load balancers, or global application external load balancers, or both.
type BackendBucket_LoadBalancingScheme int32

const (
	// A value indicating that the enum field is not set.
	BackendBucket_UNDEFINED_LOAD_BALANCING_SCHEME BackendBucket_LoadBalancingScheme = 0
	// Signifies that this will be used for internal Application Load Balancers.
	BackendBucket_INTERNAL_MANAGED BackendBucket_LoadBalancingScheme = 37350397
)

// Enum value maps for BackendBucket_LoadBalancingScheme.
var (
	BackendBucket_LoadBalancingScheme_name = map[int32]string{
		0:        "UNDEFINED_LOAD_BALANCING_SCHEME",
		37350397: "INTERNAL_MANAGED",
	}
	BackendBucket_LoadBalancingScheme_value = map[string]int32{
		"UNDEFINED_LOAD_BALANCING_SCHEME": 0,
		"INTERNAL_MANAGED":                37350397,
	}
)

func (x BackendBucket_LoadBalancingScheme) Enum() *BackendBucket_LoadBalancingScheme {
	p := new(BackendBucket_LoadBalancingScheme)
	*p = x
	return p
}

func (x BackendBucket_LoadBalancingScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendBucket_LoadBalancingScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[32].Descriptor()
}

func (BackendBucket_LoadBalancingScheme) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[32]
}

func (x BackendBucket_LoadBalancingScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendBucket_LoadBalancingScheme.Descriptor instead.
func (BackendBucket_LoadBalancingScheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{127, 1}
}

// Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached. If no value is provided for cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.
type BackendBucketCdnPolicy_CacheMode int32

const (
	// A value indicating that the enum field is not set.
	BackendBucketCdnPolicy_UNDEFINED_CACHE_MODE BackendBucketCdnPolicy_CacheMode = 0
	// Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
	BackendBucketCdnPolicy_CACHE_ALL_STATIC BackendBucketCdnPolicy_CacheMode = 355027945
	// Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
	BackendBucketCdnPolicy_FORCE_CACHE_ALL    BackendBucketCdnPolicy_CacheMode = 486026928
	BackendBucketCdnPolicy_INVALID_CACHE_MODE BackendBucketCdnPolicy_CacheMode = 381295560
	// Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
	BackendBucketCdnPolicy_USE_ORIGIN_HEADERS BackendBucketCdnPolicy_CacheMode = 55380261
)

// Enum value maps for BackendBucketCdnPolicy_CacheMode.
var (
	BackendBucketCdnPolicy_CacheMode_name = map[int32]string{
		0:         "UNDEFINED_CACHE_MODE",
		355027945: "CACHE_ALL_STATIC",
		486026928: "FORCE_CACHE_ALL",
		381295560: "INVALID_CACHE_MODE",
		55380261:  "USE_ORIGIN_HEADERS",
	}
	BackendBucketCdnPolicy_CacheMode_value = map[string]int32{
		"UNDEFINED_CACHE_MODE": 0,
		"CACHE_ALL_STATIC":     355027945,
		"FORCE_CACHE_ALL":      486026928,
		"INVALID_CACHE_MODE":   381295560,
		"USE_ORIGIN_HEADERS":   55380261,
	}
)

func (x BackendBucketCdnPolicy_CacheMode) Enum() *BackendBucketCdnPolicy_CacheMode {
	p := new(BackendBucketCdnPolicy_CacheMode)
	*p = x
	return p
}

func (x BackendBucketCdnPolicy_CacheMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendBucketCdnPolicy_CacheMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[33].Descriptor()
}

func (BackendBucketCdnPolicy_CacheMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[33]
}

func (x BackendBucketCdnPolicy_CacheMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendBucketCdnPolicy_CacheMode.Descriptor instead.
func (BackendBucketCdnPolicy_CacheMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{128, 0}
}

// Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
type BackendService_CompressionMode int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_COMPRESSION_MODE BackendService_CompressionMode = 0
	// Automatically uses the best compression based on the Accept-Encoding header sent by the client.
	BackendService_AUTOMATIC BackendService_CompressionMode = 165298699
	// Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
	BackendService_DISABLED BackendService_CompressionMode = 516696700
)

// Enum value maps for BackendService_CompressionMode.
var (
	BackendService_CompressionMode_name = map[int32]string{
		0:         "UNDEFINED_COMPRESSION_MODE",
		165298699: "AUTOMATIC",
		516696700: "DISABLED",
	}
	BackendService_CompressionMode_value = map[string]int32{
		"UNDEFINED_COMPRESSION_MODE": 0,
		"AUTOMATIC":                  165298699,
		"DISABLED":                   516696700,
	}
)

func (x BackendService_CompressionMode) Enum() *BackendService_CompressionMode {
	p := new(BackendService_CompressionMode)
	*p = x
	return p
}

func (x BackendService_CompressionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_CompressionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[34].Descriptor()
}

func (BackendService_CompressionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[34]
}

func (x BackendService_CompressionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_CompressionMode.Descriptor instead.
func (BackendService_CompressionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{137, 0}
}

// Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
type BackendService_ExternalManagedMigrationState int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_EXTERNAL_MANAGED_MIGRATION_STATE BackendService_ExternalManagedMigrationState = 0
	BackendService_PREPARE                                    BackendService_ExternalManagedMigrationState = 399612135
	BackendService_TEST_ALL_TRAFFIC                           BackendService_ExternalManagedMigrationState = 79728882
	BackendService_TEST_BY_PERCENTAGE                         BackendService_ExternalManagedMigrationState = 513738389
)

// Enum value maps for BackendService_ExternalManagedMigrationState.
var (
	BackendService_ExternalManagedMigrationState_name = map[int32]string{
		0:         "UNDEFINED_EXTERNAL_MANAGED_MIGRATION_STATE",
		399612135: "PREPARE",
		79728882:  "TEST_ALL_TRAFFIC",
		513738389: "TEST_BY_PERCENTAGE",
	}
	BackendService_ExternalManagedMigrationState_value = map[string]int32{
		"UNDEFINED_EXTERNAL_MANAGED_MIGRATION_STATE": 0,
		"PREPARE":            399612135,
		"TEST_ALL_TRAFFIC":   79728882,
		"TEST_BY_PERCENTAGE": 513738389,
	}
)

func (x BackendService_ExternalManagedMigrationState) Enum() *BackendService_ExternalManagedMigrationState {
	p := new(BackendService_ExternalManagedMigrationState)
	*p = x
	return p
}

func (x BackendService_ExternalManagedMigrationState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_ExternalManagedMigrationState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[35].Descriptor()
}

func (BackendService_ExternalManagedMigrationState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[35]
}

func (x BackendService_ExternalManagedMigrationState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_ExternalManagedMigrationState.Descriptor instead.
func (BackendService_ExternalManagedMigrationState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{137, 1}
}

// Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
type BackendService_IpAddressSelectionPolicy int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_IP_ADDRESS_SELECTION_POLICY BackendService_IpAddressSelectionPolicy = 0
	// Only send IPv4 traffic to the backends of the Backend Service (Instance Group, Managed Instance Group, Network Endpoint Group) regardless of traffic from the client to the proxy. Only IPv4 health-checks are used to check the health of the backends. This is the default setting.
	BackendService_IPV4_ONLY BackendService_IpAddressSelectionPolicy = 22373798
	// Only send IPv6 traffic to the backends of the Backend Service (Instance Group, Managed Instance Group, Network Endpoint Group) regardless of traffic from the client to the proxy. Only IPv6 health-checks are used to check the health of the backends.
	BackendService_IPV6_ONLY BackendService_IpAddressSelectionPolicy = 79632100
	// Unspecified IP address selection policy.
	BackendService_IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED BackendService_IpAddressSelectionPolicy = 36210144
	// Prioritize the connection to the endpoints IPv6 address over its IPv4 address (provided there is a healthy IPv6 address).
	BackendService_PREFER_IPV6 BackendService_IpAddressSelectionPolicy = 408601302
)

// Enum value maps for BackendService_IpAddressSelectionPolicy.
var (
	BackendService_IpAddressSelectionPolicy_name = map[int32]string{
		0:         "UNDEFINED_IP_ADDRESS_SELECTION_POLICY",
		22373798:  "IPV4_ONLY",
		79632100:  "IPV6_ONLY",
		36210144:  "IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED",
		408601302: "PREFER_IPV6",
	}
	BackendService_IpAddressSelectionPolicy_value = map[string]int32{
		"UNDEFINED_IP_ADDRESS_SELECTION_POLICY":   0,
		"IPV4_ONLY":                               22373798,
		"IPV6_ONLY":                               79632100,
		"IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED": 36210144,
		"PREFER_IPV6":                             408601302,
	}
)

func (x BackendService_IpAddressSelectionPolicy) Enum() *BackendService_IpAddressSelectionPolicy {
	p := new(BackendService_IpAddressSelectionPolicy)
	*p = x
	return p
}

func (x BackendService_IpAddressSelectionPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_IpAddressSelectionPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[36].Descriptor()
}

func (BackendService_IpAddressSelectionPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[36]
}

func (x BackendService_IpAddressSelectionPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_IpAddressSelectionPolicy.Descriptor instead.
func (BackendService_IpAddressSelectionPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{137, 2}
}

// Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
type BackendService_LoadBalancingScheme int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_LOAD_BALANCING_SCHEME BackendService_LoadBalancingScheme = 0
	// Signifies that this will be used for classic Application Load Balancers, global external proxy Network Load Balancers, or external passthrough Network Load Balancers.
	BackendService_EXTERNAL BackendService_LoadBalancingScheme = 35607499
	// Signifies that this will be used for global external Application Load Balancers, regional external Application Load Balancers, or regional external proxy Network Load Balancers.
	BackendService_EXTERNAL_MANAGED BackendService_LoadBalancingScheme = 512006923
	// Signifies that this will be used for internal passthrough Network Load Balancers.
	BackendService_INTERNAL BackendService_LoadBalancingScheme = 279295677
	// Signifies that this will be used for internal Application Load Balancers.
	BackendService_INTERNAL_MANAGED BackendService_LoadBalancingScheme = 37350397
	// Signifies that this will be used by Traffic Director.
	BackendService_INTERNAL_SELF_MANAGED         BackendService_LoadBalancingScheme = 236211150
	BackendService_INVALID_LOAD_BALANCING_SCHEME BackendService_LoadBalancingScheme = 275352060
)

// Enum value maps for BackendService_LoadBalancingScheme.
var (
	BackendService_LoadBalancingScheme_name = map[int32]string{
		0:         "UNDEFINED_LOAD_BALANCING_SCHEME",
		35607499:  "EXTERNAL",
		512006923: "EXTERNAL_MANAGED",
		279295677: "INTERNAL",
		37350397:  "INTERNAL_MANAGED",
		236211150: "INTERNAL_SELF_MANAGED",
		275352060: "INVALID_LOAD_BALANCING_SCHEME",
	}
	BackendService_LoadBalancingScheme_value = map[string]int32{
		"UNDEFINED_LOAD_BALANCING_SCHEME": 0,
		"EXTERNAL":                        35607499,
		"EXTERNAL_MANAGED":                512006923,
		"INTERNAL":                        279295677,
		"INTERNAL_MANAGED":                37350397,
		"INTERNAL_SELF_MANAGED":           236211150,
		"INVALID_LOAD_BALANCING_SCHEME":   275352060,
	}
)

func (x BackendService_LoadBalancingScheme) Enum() *BackendService_LoadBalancingScheme {
	p := new(BackendService_LoadBalancingScheme)
	*p = x
	return p
}

func (x BackendService_LoadBalancingScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_LoadBalancingScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[37].Descriptor()
}

func (BackendService_LoadBalancingScheme) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[37]
}

func (x BackendService_LoadBalancingScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_LoadBalancingScheme.Descriptor instead.
func (BackendService_LoadBalancingScheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{137, 3}
}

// The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
type BackendService_LocalityLbPolicy int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_LOCALITY_LB_POLICY BackendService_LocalityLbPolicy = 0
	BackendService_INVALID_LB_POLICY            BackendService_LocalityLbPolicy = 323318707
	// An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
	BackendService_LEAST_REQUEST BackendService_LocalityLbPolicy = 46604921
	// This algorithm implements consistent hashing to backends. Maglev can be used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer.
	BackendService_MAGLEV BackendService_LocalityLbPolicy = 119180266
	// Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
	BackendService_ORIGINAL_DESTINATION BackendService_LocalityLbPolicy = 166297216
	// The load balancer selects a random healthy host.
	BackendService_RANDOM BackendService_LocalityLbPolicy = 262527171
	// The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
	BackendService_RING_HASH BackendService_LocalityLbPolicy = 432795069
	// This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
	BackendService_ROUND_ROBIN BackendService_LocalityLbPolicy = 153895801
	// Per-instance weighted Load Balancing via health check reported weights. In internal passthrough network load balancing, it is weighted rendezvous hashing. This option is only supported in internal passthrough network load balancing.
	BackendService_WEIGHTED_GCP_RENDEZVOUS BackendService_LocalityLbPolicy = 82501640
	// Per-instance weighted Load Balancing via health check reported weights. If set, the Backend Service must configure a non legacy HTTP-based Health Check, and health check replies are expected to contain non-standard HTTP response header field X-Load-Balancing-Endpoint-Weight to specify the per-instance weights. If set, Load Balancing is weighted based on the per-instance weights reported in the last processed health check replies, as long as every instance either reported a valid weight or had UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains equal-weight. This option is only supported in Network Load Balancing.
	BackendService_WEIGHTED_MAGLEV BackendService_LocalityLbPolicy = 254930962
	// Per-endpoint weighted round-robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics fields.
	BackendService_WEIGHTED_ROUND_ROBIN BackendService_LocalityLbPolicy = 5584977
)

// Enum value maps for BackendService_LocalityLbPolicy.
var (
	BackendService_LocalityLbPolicy_name = map[int32]string{
		0:         "UNDEFINED_LOCALITY_LB_POLICY",
		323318707: "INVALID_LB_POLICY",
		46604921:  "LEAST_REQUEST",
		119180266: "MAGLEV",
		166297216: "ORIGINAL_DESTINATION",
		262527171: "RANDOM",
		432795069: "RING_HASH",
		153895801: "ROUND_ROBIN",
		82501640:  "WEIGHTED_GCP_RENDEZVOUS",
		254930962: "WEIGHTED_MAGLEV",
		5584977:   "WEIGHTED_ROUND_ROBIN",
	}
	BackendService_LocalityLbPolicy_value = map[string]int32{
		"UNDEFINED_LOCALITY_LB_POLICY": 0,
		"INVALID_LB_POLICY":            323318707,
		"LEAST_REQUEST":                46604921,
		"MAGLEV":                       119180266,
		"ORIGINAL_DESTINATION":         166297216,
		"RANDOM":                       262527171,
		"RING_HASH":                    432795069,
		"ROUND_ROBIN":                  153895801,
		"WEIGHTED_GCP_RENDEZVOUS":      82501640,
		"WEIGHTED_MAGLEV":              254930962,
		"WEIGHTED_ROUND_ROBIN":         5584977,
	}
)

func (x BackendService_LocalityLbPolicy) Enum() *BackendService_LocalityLbPolicy {
	p := new(BackendService_LocalityLbPolicy)
	*p = x
	return p
}

func (x BackendService_LocalityLbPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_LocalityLbPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[38].Descriptor()
}

func (BackendService_LocalityLbPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[38]
}

func (x BackendService_LocalityLbPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_LocalityLbPolicy.Descriptor instead.
func (BackendService_LocalityLbPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{137, 4}
}

// The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
type BackendService_Protocol int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_PROTOCOL BackendService_Protocol = 0
	// gRPC (available for Traffic Director).
	BackendService_GRPC BackendService_Protocol = 2196510
	// HTTP2 over cleartext
	BackendService_H2C  BackendService_Protocol = 70809
	BackendService_HTTP BackendService_Protocol = 2228360
	// HTTP/2 with SSL.
	BackendService_HTTP2 BackendService_Protocol = 69079210
	BackendService_HTTPS BackendService_Protocol = 69079243
	// TCP proxying with SSL.
	BackendService_SSL BackendService_Protocol = 82412
	// TCP proxying or TCP pass-through.
	BackendService_TCP BackendService_Protocol = 82881
	// UDP.
	BackendService_UDP BackendService_Protocol = 83873
	// If a Backend Service has UNSPECIFIED as its protocol, it can be used with any L3/L4 Forwarding Rules.
	BackendService_UNSPECIFIED BackendService_Protocol = 526786327
)

// Enum value maps for BackendService_Protocol.
var (
	BackendService_Protocol_name = map[int32]string{
		0:         "UNDEFINED_PROTOCOL",
		2196510:   "GRPC",
		70809:     "H2C",
		2228360:   "HTTP",
		69079210:  "HTTP2",
		69079243:  "HTTPS",
		82412:     "SSL",
		82881:     "TCP",
		83873:     "UDP",
		526786327: "UNSPECIFIED",
	}
	BackendService_Protocol_value = map[string]int32{
		"UNDEFINED_PROTOCOL": 0,
		"GRPC":               2196510,
		"H2C":                70809,
		"HTTP":               2228360,
		"HTTP2":              69079210,
		"HTTPS":              69079243,
		"SSL":                82412,
		"TCP":                82881,
		"UDP":                83873,
		"UNSPECIFIED":        526786327,
	}
)

func (x BackendService_Protocol) Enum() *BackendService_Protocol {
	p := new(BackendService_Protocol)
	*p = x
	return p
}

func (x BackendService_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[39].Descriptor()
}

func (BackendService_Protocol) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[39]
}

func (x BackendService_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_Protocol.Descriptor instead.
func (BackendService_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{137, 5}
}

// Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
type BackendService_SessionAffinity int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_SESSION_AFFINITY BackendService_SessionAffinity = 0
	// 2-tuple hash on packet's source and destination IP addresses. Connections from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy.
	BackendService_CLIENT_IP BackendService_SessionAffinity = 345665051
	// 1-tuple hash only on packet's source IP address. Connections from the same source IP address will be served by the same backend VM while that VM remains healthy. This option can only be used for Internal TCP/UDP Load Balancing.
	BackendService_CLIENT_IP_NO_DESTINATION BackendService_SessionAffinity = 106122516
	// 5-tuple hash on packet's source and destination IP addresses, IP protocol, and source and destination ports. Connections for the same IP protocol from the same source IP address and port to the same destination IP address and port will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
	BackendService_CLIENT_IP_PORT_PROTO BackendService_SessionAffinity = 221722926
	// 3-tuple hash on packet's source and destination IP addresses, and IP protocol. Connections for the same IP protocol from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
	BackendService_CLIENT_IP_PROTO BackendService_SessionAffinity = 25322148
	// Hash based on a cookie generated by the L7 loadbalancer. Only valid for HTTP(S) load balancing.
	BackendService_GENERATED_COOKIE BackendService_SessionAffinity = 370321204
	// The hash is based on a user specified header field.
	BackendService_HEADER_FIELD BackendService_SessionAffinity = 200737960
	// The hash is based on a user provided cookie.
	BackendService_HTTP_COOKIE BackendService_SessionAffinity = 494981627
	// No session affinity. Connections from the same client IP may go to any instance in the pool.
	BackendService_NONE BackendService_SessionAffinity = 2402104
	// Strong cookie-based affinity. Connections bearing the same cookie will be served by the same backend VM while that VM remains healthy, as long as the cookie has not expired.
	BackendService_STRONG_COOKIE_AFFINITY BackendService_SessionAffinity = 438628091
)

// Enum value maps for BackendService_SessionAffinity.
var (
	BackendService_SessionAffinity_name = map[int32]string{
		0:         "UNDEFINED_SESSION_AFFINITY",
		345665051: "CLIENT_IP",
		106122516: "CLIENT_IP_NO_DESTINATION",
		221722926: "CLIENT_IP_PORT_PROTO",
		25322148:  "CLIENT_IP_PROTO",
		370321204: "GENERATED_COOKIE",
		200737960: "HEADER_FIELD",
		494981627: "HTTP_COOKIE",
		2402104:   "NONE",
		438628091: "STRONG_COOKIE_AFFINITY",
	}
	BackendService_SessionAffinity_value = map[string]int32{
		"UNDEFINED_SESSION_AFFINITY": 0,
		"CLIENT_IP":                  345665051,
		"CLIENT_IP_NO_DESTINATION":   106122516,
		"CLIENT_IP_PORT_PROTO":       221722926,
		"CLIENT_IP_PROTO":            25322148,
		"GENERATED_COOKIE":           370321204,
		"HEADER_FIELD":               200737960,
		"HTTP_COOKIE":                494981627,
		"NONE":                       2402104,
		"STRONG_COOKIE_AFFINITY":     438628091,
	}
)

func (x BackendService_SessionAffinity) Enum() *BackendService_SessionAffinity {
	p := new(BackendService_SessionAffinity)
	*p = x
	return p
}

func (x BackendService_SessionAffinity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_SessionAffinity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[40].Descriptor()
}

func (BackendService_SessionAffinity) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[40]
}

func (x BackendService_SessionAffinity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_SessionAffinity.Descriptor instead.
func (BackendService_SessionAffinity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{137, 6}
}

// Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached. If no value is provided for cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.
type BackendServiceCdnPolicy_CacheMode int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceCdnPolicy_UNDEFINED_CACHE_MODE BackendServiceCdnPolicy_CacheMode = 0
	// Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
	BackendServiceCdnPolicy_CACHE_ALL_STATIC BackendServiceCdnPolicy_CacheMode = 355027945
	// Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
	BackendServiceCdnPolicy_FORCE_CACHE_ALL    BackendServiceCdnPolicy_CacheMode = 486026928
	BackendServiceCdnPolicy_INVALID_CACHE_MODE BackendServiceCdnPolicy_CacheMode = 381295560
	// Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
	BackendServiceCdnPolicy_USE_ORIGIN_HEADERS BackendServiceCdnPolicy_CacheMode = 55380261
)

// Enum value maps for BackendServiceCdnPolicy_CacheMode.
var (
	BackendServiceCdnPolicy_CacheMode_name = map[int32]string{
		0:         "UNDEFINED_CACHE_MODE",
		355027945: "CACHE_ALL_STATIC",
		486026928: "FORCE_CACHE_ALL",
		381295560: "INVALID_CACHE_MODE",
		55380261:  "USE_ORIGIN_HEADERS",
	}
	BackendServiceCdnPolicy_CacheMode_value = map[string]int32{
		"UNDEFINED_CACHE_MODE": 0,
		"CACHE_ALL_STATIC":     355027945,
		"FORCE_CACHE_ALL":      486026928,
		"INVALID_CACHE_MODE":   381295560,
		"USE_ORIGIN_HEADERS":   55380261,
	}
)

func (x BackendServiceCdnPolicy_CacheMode) Enum() *BackendServiceCdnPolicy_CacheMode {
	p := new(BackendServiceCdnPolicy_CacheMode)
	*p = x
	return p
}

func (x BackendServiceCdnPolicy_CacheMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceCdnPolicy_CacheMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[41].Descriptor()
}

func (BackendServiceCdnPolicy_CacheMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[41]
}

func (x BackendServiceCdnPolicy_CacheMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceCdnPolicy_CacheMode.Descriptor instead.
func (BackendServiceCdnPolicy_CacheMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{139, 0}
}

// Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
type BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceConnectionTrackingPolicy_UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends = 0
	BackendServiceConnectionTrackingPolicy_ALWAYS_PERSIST                                         BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends = 38400900
	BackendServiceConnectionTrackingPolicy_DEFAULT_FOR_PROTOCOL                                   BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends = 145265356
	BackendServiceConnectionTrackingPolicy_NEVER_PERSIST                                          BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends = 138646241
)

// Enum value maps for BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends.
var (
	BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends_name = map[int32]string{
		0:         "UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS",
		38400900:  "ALWAYS_PERSIST",
		145265356: "DEFAULT_FOR_PROTOCOL",
		138646241: "NEVER_PERSIST",
	}
	BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends_value = map[string]int32{
		"UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS": 0,
		"ALWAYS_PERSIST":       38400900,
		"DEFAULT_FOR_PROTOCOL": 145265356,
		"NEVER_PERSIST":        138646241,
	}
)

func (x BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) Enum() *BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends {
	p := new(BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends)
	*p = x
	return p
}

func (x BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[42].Descriptor()
}

func (BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[42]
}

func (x BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends.Descriptor instead.
func (BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{142, 0}
}

// Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
type BackendServiceConnectionTrackingPolicy_TrackingMode int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceConnectionTrackingPolicy_UNDEFINED_TRACKING_MODE BackendServiceConnectionTrackingPolicy_TrackingMode = 0
	BackendServiceConnectionTrackingPolicy_INVALID_TRACKING_MODE   BackendServiceConnectionTrackingPolicy_TrackingMode = 49234371
	BackendServiceConnectionTrackingPolicy_PER_CONNECTION          BackendServiceConnectionTrackingPolicy_TrackingMode = 85162848
	BackendServiceConnectionTrackingPolicy_PER_SESSION             BackendServiceConnectionTrackingPolicy_TrackingMode = 182099252
)

// Enum value maps for BackendServiceConnectionTrackingPolicy_TrackingMode.
var (
	BackendServiceConnectionTrackingPolicy_TrackingMode_name = map[int32]string{
		0:         "UNDEFINED_TRACKING_MODE",
		49234371:  "INVALID_TRACKING_MODE",
		85162848:  "PER_CONNECTION",
		182099252: "PER_SESSION",
	}
	BackendServiceConnectionTrackingPolicy_TrackingMode_value = map[string]int32{
		"UNDEFINED_TRACKING_MODE": 0,
		"INVALID_TRACKING_MODE":   49234371,
		"PER_CONNECTION":          85162848,
		"PER_SESSION":             182099252,
	}
)

func (x BackendServiceConnectionTrackingPolicy_TrackingMode) Enum() *BackendServiceConnectionTrackingPolicy_TrackingMode {
	p := new(BackendServiceConnectionTrackingPolicy_TrackingMode)
	*p = x
	return p
}

func (x BackendServiceConnectionTrackingPolicy_TrackingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceConnectionTrackingPolicy_TrackingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[43].Descriptor()
}

func (BackendServiceConnectionTrackingPolicy_TrackingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[43]
}

func (x BackendServiceConnectionTrackingPolicy_TrackingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceConnectionTrackingPolicy_TrackingMode.Descriptor instead.
func (BackendServiceConnectionTrackingPolicy_TrackingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{142, 1}
}

// Specifies whether fast IP move is enabled, and if so, the mechanism to achieve it. Supported values are: - DISABLED: Fast IP Move is disabled. You can only use the haPolicy.leader API to update the leader. - >GARP_RA: Provides a method to very quickly define a new network endpoint as the leader. This method is faster than updating the leader using the haPolicy.leader API. Fast IP move works as follows: The VM hosting the network endpoint that should become the new leader sends either a Gratuitous ARP (GARP) packet (IPv4) or an ICMPv6 Router Advertisement(RA) packet (IPv6). Google Cloud immediately but temporarily associates the forwarding rule IP address with that VM, and both new and in-flight packets are quickly delivered to that VM. Note the important properties of the Fast IP Move functionality: - The GARP/RA-initiated re-routing stays active for approximately 20 minutes. After triggering fast failover, you must also appropriately set the haPolicy.leader. - The new leader instance should continue to send GARP/RA packets periodically every 10 seconds until at least 10 minutes after updating the haPolicy.leader (but stop immediately if it is no longer the leader). - After triggering a fast failover, we recommend that you wait at least 3 seconds before sending another GARP/RA packet from a different VM instance to avoid race conditions. - Don't send GARP/RA packets from different VM instances at the same time. If multiple instances continue to send GARP/RA packets, traffic might be routed to different destinations in an alternating order. This condition ceases when a single instance issues a GARP/RA packet. - The GARP/RA request always takes priority over the leader API. Using the haPolicy.leader API to change the leader to a different instance will have no effect until the GARP/RA request becomes inactive. - The GARP/RA packets should follow the GARP/RA Packet Specifications.. - When multiple forwarding rules refer to a regional backend service, you need only send a GARP or RA packet for a single forwarding rule virtual IP. The virtual IPs for all forwarding rules targeting the same backend service will also be moved to the sender of the GARP or RA packet. The following are the Fast IP Move limitations (that is, when fastIPMove is not DISABLED): - Multiple forwarding rules cannot use the same IP address if one of them refers to a regional backend service with fastIPMove. - The regional backend service must set the network field, and all NEGs must belong to that network. However, individual NEGs can belong to different subnetworks of that network. - The maximum number of network endpoints across all backends of a backend service with fastIPMove is 32. - The maximum number of backend services with fastIPMove that can have the same network endpoint attached to one of its backends is 64. - The maximum number of backend services with fastIPMove in a VPC in a region is 64. - The network endpoints that are attached to a backend of a backend service with fastIPMove cannot resolve to Gen3+ machines for IPv6. - Traffic directed to the leader by a static route next hop will not be redirected to a new leader by fast failover. Such traffic will only be redirected once an haPolicy.leader update has taken effect. Only traffic to the forwarding rule's virtual IP will be redirected to a new leader by fast failover. haPolicy.fastIPMove can be set only at backend service creation time. Once set, it cannot be updated. By default, fastIpMove is set to DISABLED.
type BackendServiceHAPolicy_FastIPMove int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceHAPolicy_UNDEFINED_FAST_I_P_MOVE BackendServiceHAPolicy_FastIPMove = 0
	BackendServiceHAPolicy_DISABLED                BackendServiceHAPolicy_FastIPMove = 516696700
	BackendServiceHAPolicy_GARP_RA                 BackendServiceHAPolicy_FastIPMove = 527352630
)

// Enum value maps for BackendServiceHAPolicy_FastIPMove.
var (
	BackendServiceHAPolicy_FastIPMove_name = map[int32]string{
		0:         "UNDEFINED_FAST_I_P_MOVE",
		516696700: "DISABLED",
		527352630: "GARP_RA",
	}
	BackendServiceHAPolicy_FastIPMove_value = map[string]int32{
		"UNDEFINED_FAST_I_P_MOVE": 0,
		"DISABLED":                516696700,
		"GARP_RA":                 527352630,
	}
)

func (x BackendServiceHAPolicy_FastIPMove) Enum() *BackendServiceHAPolicy_FastIPMove {
	p := new(BackendServiceHAPolicy_FastIPMove)
	*p = x
	return p
}

func (x BackendServiceHAPolicy_FastIPMove) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceHAPolicy_FastIPMove) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[44].Descriptor()
}

func (BackendServiceHAPolicy_FastIPMove) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[44]
}

func (x BackendServiceHAPolicy_FastIPMove) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceHAPolicy_FastIPMove.Descriptor instead.
func (BackendServiceHAPolicy_FastIPMove) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{148, 0}
}

// The name of a locality load-balancing policy. Valid values include ROUND_ROBIN and, for Java clients, LEAST_REQUEST. For information about these values, see the description of localityLbPolicy. Do not specify the same policy more than once for a backend. If you do, the configuration is rejected.
type BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_UNDEFINED_NAME    BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 0
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_INVALID_LB_POLICY BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 323318707
	// An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_LEAST_REQUEST BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 46604921
	// This algorithm implements consistent hashing to backends. Maglev can be used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_MAGLEV BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 119180266
	// Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_ORIGINAL_DESTINATION BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 166297216
	// The load balancer selects a random healthy host.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_RANDOM BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 262527171
	// The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_RING_HASH BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 432795069
	// This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_ROUND_ROBIN BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 153895801
	// Per-instance weighted Load Balancing via health check reported weights. In internal passthrough network load balancing, it is weighted rendezvous hashing. This option is only supported in internal passthrough network load balancing.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_WEIGHTED_GCP_RENDEZVOUS BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 82501640
	// Per-instance weighted Load Balancing via health check reported weights. If set, the Backend Service must configure a non legacy HTTP-based Health Check, and health check replies are expected to contain non-standard HTTP response header field X-Load-Balancing-Endpoint-Weight to specify the per-instance weights. If set, Load Balancing is weighted based on the per-instance weights reported in the last processed health check replies, as long as every instance either reported a valid weight or had UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains equal-weight. This option is only supported in Network Load Balancing.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_WEIGHTED_MAGLEV BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 254930962
	// Per-endpoint weighted round-robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics fields.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_WEIGHTED_ROUND_ROBIN BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 5584977
)

// Enum value maps for BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name.
var (
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name_name = map[int32]string{
		0:         "UNDEFINED_NAME",
		323318707: "INVALID_LB_POLICY",
		46604921:  "LEAST_REQUEST",
		119180266: "MAGLEV",
		166297216: "ORIGINAL_DESTINATION",
		262527171: "RANDOM",
		432795069: "RING_HASH",
		153895801: "ROUND_ROBIN",
		82501640:  "WEIGHTED_GCP_RENDEZVOUS",
		254930962: "WEIGHTED_MAGLEV",
		5584977:   "WEIGHTED_ROUND_ROBIN",
	}
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name_value = map[string]int32{
		"UNDEFINED_NAME":          0,
		"INVALID_LB_POLICY":       323318707,
		"LEAST_REQUEST":           46604921,
		"MAGLEV":                  119180266,
		"ORIGINAL_DESTINATION":    166297216,
		"RANDOM":                  262527171,
		"RING_HASH":               432795069,
		"ROUND_ROBIN":             153895801,
		"WEIGHTED_GCP_RENDEZVOUS": 82501640,
		"WEIGHTED_MAGLEV":         254930962,
		"WEIGHTED_ROUND_ROBIN":    5584977,
	}
)

func (x BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) Enum() *BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name {
	p := new(BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name)
	*p = x
	return p
}

func (x BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[45].Descriptor()
}

func (BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[45]
}

func (x BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name.Descriptor instead.
func (BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{157, 0}
}

// This field can only be specified if logging is enabled for this backend service. Configures whether all, none or a subset of optional fields should be added to the reported logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
type BackendServiceLogConfig_OptionalMode int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceLogConfig_UNDEFINED_OPTIONAL_MODE BackendServiceLogConfig_OptionalMode = 0
	// A subset of optional fields.
	BackendServiceLogConfig_CUSTOM BackendServiceLogConfig_OptionalMode = 388595569
	// None optional fields.
	BackendServiceLogConfig_EXCLUDE_ALL_OPTIONAL BackendServiceLogConfig_OptionalMode = 168636099
	// All optional fields.
	BackendServiceLogConfig_INCLUDE_ALL_OPTIONAL BackendServiceLogConfig_OptionalMode = 535606965
)

// Enum value maps for BackendServiceLogConfig_OptionalMode.
var (
	BackendServiceLogConfig_OptionalMode_name = map[int32]string{
		0:         "UNDEFINED_OPTIONAL_MODE",
		388595569: "CUSTOM",
		168636099: "EXCLUDE_ALL_OPTIONAL",
		535606965: "INCLUDE_ALL_OPTIONAL",
	}
	BackendServiceLogConfig_OptionalMode_value = map[string]int32{
		"UNDEFINED_OPTIONAL_MODE": 0,
		"CUSTOM":                  388595569,
		"EXCLUDE_ALL_OPTIONAL":    168636099,
		"INCLUDE_ALL_OPTIONAL":    535606965,
	}
)

func (x BackendServiceLogConfig_OptionalMode) Enum() *BackendServiceLogConfig_OptionalMode {
	p := new(BackendServiceLogConfig_OptionalMode)
	*p = x
	return p
}

func (x BackendServiceLogConfig_OptionalMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceLogConfig_OptionalMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[46].Descriptor()
}

func (BackendServiceLogConfig_OptionalMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[46]
}

func (x BackendServiceLogConfig_OptionalMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceLogConfig_OptionalMode.Descriptor instead.
func (BackendServiceLogConfig_OptionalMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{158, 0}
}

// This field indicates whether zonal affinity is enabled or not. The possible values are: - ZONAL_AFFINITY_DISABLED: Default Value. Zonal Affinity is disabled. The load balancer distributes new connections to all healthy backend endpoints across all zones. - ZONAL_AFFINITY_STAY_WITHIN_ZONE: Zonal Affinity is enabled. The load balancer distributes new connections to all healthy backend endpoints in the local zone only. If there are no healthy backend endpoints in the local zone, the load balancer distributes new connections to all backend endpoints in the local zone. - ZONAL_AFFINITY_SPILL_CROSS_ZONE: Zonal Affinity is enabled. The load balancer distributes new connections to all healthy backend endpoints in the local zone only. If there aren't enough healthy backend endpoints in the local zone, the load balancer distributes new connections to all healthy backend endpoints across all zones.
type BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_UNDEFINED_SPILLOVER             BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover = 0
	BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_ZONAL_AFFINITY_DISABLED         BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover = 230207960
	BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_ZONAL_AFFINITY_SPILL_CROSS_ZONE BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover = 251048410
	BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_ZONAL_AFFINITY_STAY_WITHIN_ZONE BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover = 12177782
)

// Enum value maps for BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover.
var (
	BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover_name = map[int32]string{
		0:         "UNDEFINED_SPILLOVER",
		230207960: "ZONAL_AFFINITY_DISABLED",
		251048410: "ZONAL_AFFINITY_SPILL_CROSS_ZONE",
		12177782:  "ZONAL_AFFINITY_STAY_WITHIN_ZONE",
	}
	BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover_value = map[string]int32{
		"UNDEFINED_SPILLOVER":             0,
		"ZONAL_AFFINITY_DISABLED":         230207960,
		"ZONAL_AFFINITY_SPILL_CROSS_ZONE": 251048410,
		"ZONAL_AFFINITY_STAY_WITHIN_ZONE": 12177782,
	}
)

func (x BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover) Enum() *BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover {
	p := new(BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover)
	*p = x
	return p
}

func (x BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[47].Descriptor()
}

func (BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[47]
}

func (x BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover.Descriptor instead.
func (BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity_Spillover) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{160, 0}
}

// The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
type BfdPacket_Diagnostic int32

const (
	// A value indicating that the enum field is not set.
	BfdPacket_UNDEFINED_DIAGNOSTIC           BfdPacket_Diagnostic = 0
	BfdPacket_ADMINISTRATIVELY_DOWN          BfdPacket_Diagnostic = 121685798
	BfdPacket_CONCATENATED_PATH_DOWN         BfdPacket_Diagnostic = 26186892
	BfdPacket_CONTROL_DETECTION_TIME_EXPIRED BfdPacket_Diagnostic = 135478383
	BfdPacket_DIAGNOSTIC_UNSPECIFIED         BfdPacket_Diagnostic = 58720895
	BfdPacket_ECHO_FUNCTION_FAILED           BfdPacket_Diagnostic = 220687466
	BfdPacket_FORWARDING_PLANE_RESET         BfdPacket_Diagnostic = 19715882
	BfdPacket_NEIGHBOR_SIGNALED_SESSION_DOWN BfdPacket_Diagnostic = 374226742
	BfdPacket_NO_DIAGNOSTIC                  BfdPacket_Diagnostic = 222503141
	BfdPacket_PATH_DOWN                      BfdPacket_Diagnostic = 290605180
	BfdPacket_REVERSE_CONCATENATED_PATH_DOWN BfdPacket_Diagnostic = 479337129
)

// Enum value maps for BfdPacket_Diagnostic.
var (
	BfdPacket_Diagnostic_name = map[int32]string{
		0:         "UNDEFINED_DIAGNOSTIC",
		121685798: "ADMINISTRATIVELY_DOWN",
		26186892:  "CONCATENATED_PATH_DOWN",
		135478383: "CONTROL_DETECTION_TIME_EXPIRED",
		58720895:  "DIAGNOSTIC_UNSPECIFIED",
		220687466: "ECHO_FUNCTION_FAILED",
		19715882:  "FORWARDING_PLANE_RESET",
		374226742: "NEIGHBOR_SIGNALED_SESSION_DOWN",
		222503141: "NO_DIAGNOSTIC",
		290605180: "PATH_DOWN",
		479337129: "REVERSE_CONCATENATED_PATH_DOWN",
	}
	BfdPacket_Diagnostic_value = map[string]int32{
		"UNDEFINED_DIAGNOSTIC":           0,
		"ADMINISTRATIVELY_DOWN":          121685798,
		"CONCATENATED_PATH_DOWN":         26186892,
		"CONTROL_DETECTION_TIME_EXPIRED": 135478383,
		"DIAGNOSTIC_UNSPECIFIED":         58720895,
		"ECHO_FUNCTION_FAILED":           220687466,
		"FORWARDING_PLANE_RESET":         19715882,
		"NEIGHBOR_SIGNALED_SESSION_DOWN": 374226742,
		"NO_DIAGNOSTIC":                  222503141,
		"PATH_DOWN":                      290605180,
		"REVERSE_CONCATENATED_PATH_DOWN": 479337129,
	}
)

func (x BfdPacket_Diagnostic) Enum() *BfdPacket_Diagnostic {
	p := new(BfdPacket_Diagnostic)
	*p = x
	return p
}

func (x BfdPacket_Diagnostic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdPacket_Diagnostic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[48].Descriptor()
}

func (BfdPacket_Diagnostic) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[48]
}

func (x BfdPacket_Diagnostic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdPacket_Diagnostic.Descriptor instead.
func (BfdPacket_Diagnostic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{168, 0}
}

// The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
type BfdPacket_State int32

const (
	// A value indicating that the enum field is not set.
	BfdPacket_UNDEFINED_STATE   BfdPacket_State = 0
	BfdPacket_ADMIN_DOWN        BfdPacket_State = 128544690
	BfdPacket_DOWN              BfdPacket_State = 2104482
	BfdPacket_INIT              BfdPacket_State = 2252048
	BfdPacket_STATE_UNSPECIFIED BfdPacket_State = 470755401
	BfdPacket_UP                BfdPacket_State = 2715
)

// Enum value maps for BfdPacket_State.
var (
	BfdPacket_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		128544690: "ADMIN_DOWN",
		2104482:   "DOWN",
		2252048:   "INIT",
		470755401: "STATE_UNSPECIFIED",
		2715:      "UP",
	}
	BfdPacket_State_value = map[string]int32{
		"UNDEFINED_STATE":   0,
		"ADMIN_DOWN":        128544690,
		"DOWN":              2104482,
		"INIT":              2252048,
		"STATE_UNSPECIFIED": 470755401,
		"UP":                2715,
	}
)

func (x BfdPacket_State) Enum() *BfdPacket_State {
	p := new(BfdPacket_State)
	*p = x
	return p
}

func (x BfdPacket_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdPacket_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[49].Descriptor()
}

func (BfdPacket_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[49]
}

func (x BfdPacket_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdPacket_State.Descriptor instead.
func (BfdPacket_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{168, 1}
}

// The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
type BfdStatus_BfdSessionInitializationMode int32

const (
	// A value indicating that the enum field is not set.
	BfdStatus_UNDEFINED_BFD_SESSION_INITIALIZATION_MODE BfdStatus_BfdSessionInitializationMode = 0
	BfdStatus_ACTIVE                                    BfdStatus_BfdSessionInitializationMode = 314733318
	BfdStatus_DISABLED                                  BfdStatus_BfdSessionInitializationMode = 516696700
	BfdStatus_PASSIVE                                   BfdStatus_BfdSessionInitializationMode = 462813959
)

// Enum value maps for BfdStatus_BfdSessionInitializationMode.
var (
	BfdStatus_BfdSessionInitializationMode_name = map[int32]string{
		0:         "UNDEFINED_BFD_SESSION_INITIALIZATION_MODE",
		314733318: "ACTIVE",
		516696700: "DISABLED",
		462813959: "PASSIVE",
	}
	BfdStatus_BfdSessionInitializationMode_value = map[string]int32{
		"UNDEFINED_BFD_SESSION_INITIALIZATION_MODE": 0,
		"ACTIVE":   314733318,
		"DISABLED": 516696700,
		"PASSIVE":  462813959,
	}
)

func (x BfdStatus_BfdSessionInitializationMode) Enum() *BfdStatus_BfdSessionInitializationMode {
	p := new(BfdStatus_BfdSessionInitializationMode)
	*p = x
	return p
}

func (x BfdStatus_BfdSessionInitializationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdStatus_BfdSessionInitializationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[50].Descriptor()
}

func (BfdStatus_BfdSessionInitializationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[50]
}

func (x BfdStatus_BfdSessionInitializationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdStatus_BfdSessionInitializationMode.Descriptor instead.
func (BfdStatus_BfdSessionInitializationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{169, 0}
}

// The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
type BfdStatus_LocalDiagnostic int32

const (
	// A value indicating that the enum field is not set.
	BfdStatus_UNDEFINED_LOCAL_DIAGNOSTIC     BfdStatus_LocalDiagnostic = 0
	BfdStatus_ADMINISTRATIVELY_DOWN          BfdStatus_LocalDiagnostic = 121685798
	BfdStatus_CONCATENATED_PATH_DOWN         BfdStatus_LocalDiagnostic = 26186892
	BfdStatus_CONTROL_DETECTION_TIME_EXPIRED BfdStatus_LocalDiagnostic = 135478383
	BfdStatus_DIAGNOSTIC_UNSPECIFIED         BfdStatus_LocalDiagnostic = 58720895
	BfdStatus_ECHO_FUNCTION_FAILED           BfdStatus_LocalDiagnostic = 220687466
	BfdStatus_FORWARDING_PLANE_RESET         BfdStatus_LocalDiagnostic = 19715882
	BfdStatus_NEIGHBOR_SIGNALED_SESSION_DOWN BfdStatus_LocalDiagnostic = 374226742
	BfdStatus_NO_DIAGNOSTIC                  BfdStatus_LocalDiagnostic = 222503141
	BfdStatus_PATH_DOWN                      BfdStatus_LocalDiagnostic = 290605180
	BfdStatus_REVERSE_CONCATENATED_PATH_DOWN BfdStatus_LocalDiagnostic = 479337129
)

// Enum value maps for BfdStatus_LocalDiagnostic.
var (
	BfdStatus_LocalDiagnostic_name = map[int32]string{
		0:         "UNDEFINED_LOCAL_DIAGNOSTIC",
		121685798: "ADMINISTRATIVELY_DOWN",
		26186892:  "CONCATENATED_PATH_DOWN",
		135478383: "CONTROL_DETECTION_TIME_EXPIRED",
		58720895:  "DIAGNOSTIC_UNSPECIFIED",
		220687466: "ECHO_FUNCTION_FAILED",
		19715882:  "FORWARDING_PLANE_RESET",
		374226742: "NEIGHBOR_SIGNALED_SESSION_DOWN",
		222503141: "NO_DIAGNOSTIC",
		290605180: "PATH_DOWN",
		479337129: "REVERSE_CONCATENATED_PATH_DOWN",
	}
	BfdStatus_LocalDiagnostic_value = map[string]int32{
		"UNDEFINED_LOCAL_DIAGNOSTIC":     0,
		"ADMINISTRATIVELY_DOWN":          121685798,
		"CONCATENATED_PATH_DOWN":         26186892,
		"CONTROL_DETECTION_TIME_EXPIRED": 135478383,
		"DIAGNOSTIC_UNSPECIFIED":         58720895,
		"ECHO_FUNCTION_FAILED":           220687466,
		"FORWARDING_PLANE_RESET":         19715882,
		"NEIGHBOR_SIGNALED_SESSION_DOWN": 374226742,
		"NO_DIAGNOSTIC":                  222503141,
		"PATH_DOWN":                      290605180,
		"REVERSE_CONCATENATED_PATH_DOWN": 479337129,
	}
)

func (x BfdStatus_LocalDiagnostic) Enum() *BfdStatus_LocalDiagnostic {
	p := new(BfdStatus_LocalDiagnostic)
	*p = x
	return p
}

func (x BfdStatus_LocalDiagnostic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdStatus_LocalDiagnostic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[51].Descriptor()
}

func (BfdStatus_LocalDiagnostic) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[51]
}

func (x BfdStatus_LocalDiagnostic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdStatus_LocalDiagnostic.Descriptor instead.
func (BfdStatus_LocalDiagnostic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{169, 1}
}

// The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
type BfdStatus_LocalState int32

const (
	// A value indicating that the enum field is not set.
	BfdStatus_UNDEFINED_LOCAL_STATE BfdStatus_LocalState = 0
	BfdStatus_ADMIN_DOWN            BfdStatus_LocalState = 128544690
	BfdStatus_DOWN                  BfdStatus_LocalState = 2104482
	BfdStatus_INIT                  BfdStatus_LocalState = 2252048
	BfdStatus_STATE_UNSPECIFIED     BfdStatus_LocalState = 470755401
	BfdStatus_UP                    BfdStatus_LocalState = 2715
)

// Enum value maps for BfdStatus_LocalState.
var (
	BfdStatus_LocalState_name = map[int32]string{
		0:         "UNDEFINED_LOCAL_STATE",
		128544690: "ADMIN_DOWN",
		2104482:   "DOWN",
		2252048:   "INIT",
		470755401: "STATE_UNSPECIFIED",
		2715:      "UP",
	}
	BfdStatus_LocalState_value = map[string]int32{
		"UNDEFINED_LOCAL_STATE": 0,
		"ADMIN_DOWN":            128544690,
		"DOWN":                  2104482,
		"INIT":                  2252048,
		"STATE_UNSPECIFIED":     470755401,
		"UP":                    2715,
	}
)

func (x BfdStatus_LocalState) Enum() *BfdStatus_LocalState {
	p := new(BfdStatus_LocalState)
	*p = x
	return p
}

func (x BfdStatus_LocalState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdStatus_LocalState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[52].Descriptor()
}

func (BfdStatus_LocalState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[52]
}

func (x BfdStatus_LocalState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdStatus_LocalState.Descriptor instead.
func (BfdStatus_LocalState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{169, 2}
}

// [Output only] BGP origin (EGP, IGP or INCOMPLETE)
type BgpRoute_Origin int32

const (
	// A value indicating that the enum field is not set.
	BgpRoute_UNDEFINED_ORIGIN      BgpRoute_Origin = 0
	BgpRoute_BGP_ORIGIN_EGP        BgpRoute_Origin = 378906473
	BgpRoute_BGP_ORIGIN_IGP        BgpRoute_Origin = 378910317
	BgpRoute_BGP_ORIGIN_INCOMPLETE BgpRoute_Origin = 452839811
)

// Enum value maps for BgpRoute_Origin.
var (
	BgpRoute_Origin_name = map[int32]string{
		0:         "UNDEFINED_ORIGIN",
		378906473: "BGP_ORIGIN_EGP",
		378910317: "BGP_ORIGIN_IGP",
		452839811: "BGP_ORIGIN_INCOMPLETE",
	}
	BgpRoute_Origin_value = map[string]int32{
		"UNDEFINED_ORIGIN":      0,
		"BGP_ORIGIN_EGP":        378906473,
		"BGP_ORIGIN_IGP":        378910317,
		"BGP_ORIGIN_INCOMPLETE": 452839811,
	}
)

func (x BgpRoute_Origin) Enum() *BgpRoute_Origin {
	p := new(BgpRoute_Origin)
	*p = x
	return p
}

func (x BgpRoute_Origin) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BgpRoute_Origin) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[53].Descriptor()
}

func (BgpRoute_Origin) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[53]
}

func (x BgpRoute_Origin) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BgpRoute_Origin.Descriptor instead.
func (BgpRoute_Origin) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{171, 0}
}

// [Output only] Type of AS-PATH segment (SEQUENCE or SET)
type BgpRouteAsPath_Type int32

const (
	// A value indicating that the enum field is not set.
	BgpRouteAsPath_UNDEFINED_TYPE        BgpRouteAsPath_Type = 0
	BgpRouteAsPath_AS_PATH_TYPE_SEQUENCE BgpRouteAsPath_Type = 362887609
	BgpRouteAsPath_AS_PATH_TYPE_SET      BgpRouteAsPath_Type = 302584650
)

// Enum value maps for BgpRouteAsPath_Type.
var (
	BgpRouteAsPath_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		362887609: "AS_PATH_TYPE_SEQUENCE",
		302584650: "AS_PATH_TYPE_SET",
	}
	BgpRouteAsPath_Type_value = map[string]int32{
		"UNDEFINED_TYPE":        0,
		"AS_PATH_TYPE_SEQUENCE": 362887609,
		"AS_PATH_TYPE_SET":      302584650,
	}
)

func (x BgpRouteAsPath_Type) Enum() *BgpRouteAsPath_Type {
	p := new(BgpRouteAsPath_Type)
	*p = x
	return p
}

func (x BgpRouteAsPath_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BgpRouteAsPath_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[54].Descriptor()
}

func (BgpRouteAsPath_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[54]
}

func (x BgpRouteAsPath_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BgpRouteAsPath_Type.Descriptor instead.
func (BgpRouteAsPath_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{172, 0}
}

// [Output Only] Creation status of BulkInsert operation - information if the flow is rolling forward or rolling back.
type BulkInsertOperationStatus_Status int32

const (
	// A value indicating that the enum field is not set.
	BulkInsertOperationStatus_UNDEFINED_STATUS BulkInsertOperationStatus_Status = 0
	// Rolling forward - creating VMs.
	BulkInsertOperationStatus_CREATING BulkInsertOperationStatus_Status = 455564985
	// Done
	BulkInsertOperationStatus_DONE BulkInsertOperationStatus_Status = 2104194
	// Rolling back - cleaning up after an error.
	BulkInsertOperationStatus_ROLLING_BACK       BulkInsertOperationStatus_Status = 259411649
	BulkInsertOperationStatus_STATUS_UNSPECIFIED BulkInsertOperationStatus_Status = 42133066
)

// Enum value maps for BulkInsertOperationStatus_Status.
var (
	BulkInsertOperationStatus_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		2104194:   "DONE",
		259411649: "ROLLING_BACK",
		42133066:  "STATUS_UNSPECIFIED",
	}
	BulkInsertOperationStatus_Status_value = map[string]int32{
		"UNDEFINED_STATUS":   0,
		"CREATING":           455564985,
		"DONE":               2104194,
		"ROLLING_BACK":       259411649,
		"STATUS_UNSPECIFIED": 42133066,
	}
)

func (x BulkInsertOperationStatus_Status) Enum() *BulkInsertOperationStatus_Status {
	p := new(BulkInsertOperationStatus_Status)
	*p = x
	return p
}

func (x BulkInsertOperationStatus_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BulkInsertOperationStatus_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[55].Descriptor()
}

func (BulkInsertOperationStatus_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[55]
}

func (x BulkInsertOperationStatus_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BulkInsertOperationStatus_Status.Descriptor instead.
func (BulkInsertOperationStatus_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{180, 0}
}

// The category of the commitment; specifies whether the commitment is for hardware or software resources. Category MACHINE specifies that you are committing to hardware machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies that you are committing to software licenses, listed in licenseResources. Note that if you specify MACHINE commitments, then you must also specify a type to indicate the machine series of the hardware resource that you are committing to.
type Commitment_Category int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_CATEGORY   Commitment_Category = 0
	Commitment_CATEGORY_UNSPECIFIED Commitment_Category = 509189462
	Commitment_LICENSE              Commitment_Category = 347869217
	Commitment_MACHINE              Commitment_Category = 469553191
)

// Enum value maps for Commitment_Category.
var (
	Commitment_Category_name = map[int32]string{
		0:         "UNDEFINED_CATEGORY",
		509189462: "CATEGORY_UNSPECIFIED",
		347869217: "LICENSE",
		469553191: "MACHINE",
	}
	Commitment_Category_value = map[string]int32{
		"UNDEFINED_CATEGORY":   0,
		"CATEGORY_UNSPECIFIED": 509189462,
		"LICENSE":              347869217,
		"MACHINE":              469553191,
	}
)

func (x Commitment_Category) Enum() *Commitment_Category {
	p := new(Commitment_Category)
	*p = x
	return p
}

func (x Commitment_Category) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Category) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[56].Descriptor()
}

func (Commitment_Category) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[56]
}

func (x Commitment_Category) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Category.Descriptor instead.
func (Commitment_Category) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{200, 0}
}

// The minimum time duration that you commit to purchasing resources. The plan that you choose determines the preset term length of the commitment (which is 1 year or 3 years) and affects the discount rate that you receive for your resources. Committing to a longer time duration typically gives you a higher discount rate. The supported values for this field are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
type Commitment_Plan int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_PLAN   Commitment_Plan = 0
	Commitment_INVALID          Commitment_Plan = 530283991
	Commitment_THIRTY_SIX_MONTH Commitment_Plan = 266295942
	Commitment_TWELVE_MONTH     Commitment_Plan = 173083962
)

// Enum value maps for Commitment_Plan.
var (
	Commitment_Plan_name = map[int32]string{
		0:         "UNDEFINED_PLAN",
		530283991: "INVALID",
		266295942: "THIRTY_SIX_MONTH",
		173083962: "TWELVE_MONTH",
	}
	Commitment_Plan_value = map[string]int32{
		"UNDEFINED_PLAN":   0,
		"INVALID":          530283991,
		"THIRTY_SIX_MONTH": 266295942,
		"TWELVE_MONTH":     173083962,
	}
)

func (x Commitment_Plan) Enum() *Commitment_Plan {
	p := new(Commitment_Plan)
	*p = x
	return p
}

func (x Commitment_Plan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Plan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[57].Descriptor()
}

func (Commitment_Plan) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[57]
}

func (x Commitment_Plan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Plan.Descriptor instead.
func (Commitment_Plan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{200, 1}
}

// [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). Status can be one of the following values: NOT_YET_ACTIVE, ACTIVE, or EXPIRED.
type Commitment_Status int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_STATUS Commitment_Status = 0
	Commitment_ACTIVE           Commitment_Status = 314733318
	// Deprecate CANCELED status. Will use separate status to differentiate cancel by mergeCud or manual cancellation.
	Commitment_CANCELLED      Commitment_Status = 41957681
	Commitment_CREATING       Commitment_Status = 455564985
	Commitment_EXPIRED        Commitment_Status = 482489093
	Commitment_NOT_YET_ACTIVE Commitment_Status = 20607337
)

// Enum value maps for Commitment_Status.
var (
	Commitment_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		41957681:  "CANCELLED",
		455564985: "CREATING",
		482489093: "EXPIRED",
		20607337:  "NOT_YET_ACTIVE",
	}
	Commitment_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ACTIVE":           314733318,
		"CANCELLED":        41957681,
		"CREATING":         455564985,
		"EXPIRED":          482489093,
		"NOT_YET_ACTIVE":   20607337,
	}
)

func (x Commitment_Status) Enum() *Commitment_Status {
	p := new(Commitment_Status)
	*p = x
	return p
}

func (x Commitment_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[58].Descriptor()
}

func (Commitment_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[58]
}

func (x Commitment_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Status.Descriptor instead.
func (Commitment_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{200, 2}
}

// The type of commitment; specifies the machine series for which you want to commit to purchasing resources. The choice of machine series affects the discount rate and the eligible resource types. The type must be one of the following: ACCELERATOR_OPTIMIZED, ACCELERATOR_OPTIMIZED_A3, ACCELERATOR_OPTIMIZED_A3_MEGA, COMPUTE_OPTIMIZED, COMPUTE_OPTIMIZED_C2D, COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D, COMPUTE_OPTIMIZED_H3, GENERAL_PURPOSE, GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2, GENERAL_PURPOSE_N2, GENERAL_PURPOSE_N2D, GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D, GRAPHICS_OPTIMIZED, MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3, MEMORY_OPTIMIZED_X4, STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED specifies a commitment that applies only to eligible resources of memory optimized M1 and M2 machine series. Type GENERAL_PURPOSE specifies a commitment that applies only to eligible resources of general purpose N1 machine series.
type Commitment_Type int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_TYPE                 Commitment_Type = 0
	Commitment_ACCELERATOR_OPTIMIZED          Commitment_Type = 280848403
	Commitment_ACCELERATOR_OPTIMIZED_A3       Commitment_Type = 158574526
	Commitment_ACCELERATOR_OPTIMIZED_A3_MEGA  Commitment_Type = 156517459
	Commitment_ACCELERATOR_OPTIMIZED_A3_ULTRA Commitment_Type = 27812811
	Commitment_ACCELERATOR_OPTIMIZED_A4       Commitment_Type = 158574527
	Commitment_COMPUTE_OPTIMIZED              Commitment_Type = 158349023
	Commitment_COMPUTE_OPTIMIZED_C2D          Commitment_Type = 383246453
	Commitment_COMPUTE_OPTIMIZED_C3           Commitment_Type = 428004784
	Commitment_COMPUTE_OPTIMIZED_C3D          Commitment_Type = 383246484
	Commitment_COMPUTE_OPTIMIZED_H3           Commitment_Type = 428004939
	Commitment_COMPUTE_OPTIMIZED_H4D          Commitment_Type = 383251320
	Commitment_GENERAL_PURPOSE                Commitment_Type = 299793543
	Commitment_GENERAL_PURPOSE_C4             Commitment_Type = 301911817
	Commitment_GENERAL_PURPOSE_C4A            Commitment_Type = 232460888
	Commitment_GENERAL_PURPOSE_C4D            Commitment_Type = 232460891
	Commitment_GENERAL_PURPOSE_E2             Commitment_Type = 301911877
	Commitment_GENERAL_PURPOSE_N2             Commitment_Type = 301912156
	Commitment_GENERAL_PURPOSE_N2D            Commitment_Type = 232471400
	Commitment_GENERAL_PURPOSE_N4             Commitment_Type = 301912158
	Commitment_GENERAL_PURPOSE_T2D            Commitment_Type = 232477166
	Commitment_GRAPHICS_OPTIMIZED             Commitment_Type = 68500563
	Commitment_MEMORY_OPTIMIZED               Commitment_Type = 281753417
	Commitment_MEMORY_OPTIMIZED_M3            Commitment_Type = 276301372
	Commitment_MEMORY_OPTIMIZED_M4            Commitment_Type = 276301373
	Commitment_MEMORY_OPTIMIZED_M4_6TB        Commitment_Type = 210543650
	Commitment_MEMORY_OPTIMIZED_X4_16TB       Commitment_Type = 183089120
	Commitment_MEMORY_OPTIMIZED_X4_24TB       Commitment_Type = 183116989
	Commitment_MEMORY_OPTIMIZED_X4_32TB       Commitment_Type = 183144858
	Commitment_STORAGE_OPTIMIZED_Z3           Commitment_Type = 316796085
	// Note for internal users: When adding a new enum Type for v1, make sure to also add it in the comment for the `optional Type type` definition. This ensures that the public documentation displays the new enum Type.
	Commitment_TYPE_UNSPECIFIED Commitment_Type = 437714322
)

// Enum value maps for Commitment_Type.
var (
	Commitment_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		280848403: "ACCELERATOR_OPTIMIZED",
		158574526: "ACCELERATOR_OPTIMIZED_A3",
		156517459: "ACCELERATOR_OPTIMIZED_A3_MEGA",
		27812811:  "ACCELERATOR_OPTIMIZED_A3_ULTRA",
		158574527: "ACCELERATOR_OPTIMIZED_A4",
		158349023: "COMPUTE_OPTIMIZED",
		383246453: "COMPUTE_OPTIMIZED_C2D",
		428004784: "COMPUTE_OPTIMIZED_C3",
		383246484: "COMPUTE_OPTIMIZED_C3D",
		428004939: "COMPUTE_OPTIMIZED_H3",
		383251320: "COMPUTE_OPTIMIZED_H4D",
		299793543: "GENERAL_PURPOSE",
		301911817: "GENERAL_PURPOSE_C4",
		232460888: "GENERAL_PURPOSE_C4A",
		232460891: "GENERAL_PURPOSE_C4D",
		301911877: "GENERAL_PURPOSE_E2",
		301912156: "GENERAL_PURPOSE_N2",
		232471400: "GENERAL_PURPOSE_N2D",
		301912158: "GENERAL_PURPOSE_N4",
		232477166: "GENERAL_PURPOSE_T2D",
		68500563:  "GRAPHICS_OPTIMIZED",
		281753417: "MEMORY_OPTIMIZED",
		276301372: "MEMORY_OPTIMIZED_M3",
		276301373: "MEMORY_OPTIMIZED_M4",
		210543650: "MEMORY_OPTIMIZED_M4_6TB",
		183089120: "MEMORY_OPTIMIZED_X4_16TB",
		183116989: "MEMORY_OPTIMIZED_X4_24TB",
		183144858: "MEMORY_OPTIMIZED_X4_32TB",
		316796085: "STORAGE_OPTIMIZED_Z3",
		437714322: "TYPE_UNSPECIFIED",
	}
	Commitment_Type_value = map[string]int32{
		"UNDEFINED_TYPE":                 0,
		"ACCELERATOR_OPTIMIZED":          280848403,
		"ACCELERATOR_OPTIMIZED_A3":       158574526,
		"ACCELERATOR_OPTIMIZED_A3_MEGA":  156517459,
		"ACCELERATOR_OPTIMIZED_A3_ULTRA": 27812811,
		"ACCELERATOR_OPTIMIZED_A4":       158574527,
		"COMPUTE_OPTIMIZED":              158349023,
		"COMPUTE_OPTIMIZED_C2D":          383246453,
		"COMPUTE_OPTIMIZED_C3":           428004784,
		"COMPUTE_OPTIMIZED_C3D":          383246484,
		"COMPUTE_OPTIMIZED_H3":           428004939,
		"COMPUTE_OPTIMIZED_H4D":          383251320,
		"GENERAL_PURPOSE":                299793543,
		"GENERAL_PURPOSE_C4":             301911817,
		"GENERAL_PURPOSE_C4A":            232460888,
		"GENERAL_PURPOSE_C4D":            232460891,
		"GENERAL_PURPOSE_E2":             301911877,
		"GENERAL_PURPOSE_N2":             301912156,
		"GENERAL_PURPOSE_N2D":            232471400,
		"GENERAL_PURPOSE_N4":             301912158,
		"GENERAL_PURPOSE_T2D":            232477166,
		"GRAPHICS_OPTIMIZED":             68500563,
		"MEMORY_OPTIMIZED":               281753417,
		"MEMORY_OPTIMIZED_M3":            276301372,
		"MEMORY_OPTIMIZED_M4":            276301373,
		"MEMORY_OPTIMIZED_M4_6TB":        210543650,
		"MEMORY_OPTIMIZED_X4_16TB":       183089120,
		"MEMORY_OPTIMIZED_X4_24TB":       183116989,
		"MEMORY_OPTIMIZED_X4_32TB":       183144858,
		"STORAGE_OPTIMIZED_Z3":           316796085,
		"TYPE_UNSPECIFIED":               437714322,
	}
)

func (x Commitment_Type) Enum() *Commitment_Type {
	p := new(Commitment_Type)
	*p = x
	return p
}

func (x Commitment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[59].Descriptor()
}

func (Commitment_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[59]
}

func (x Commitment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Type.Descriptor instead.
func (Commitment_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{200, 3}
}

// Defines the type of technology used by the confidential instance.
type ConfidentialInstanceConfig_ConfidentialInstanceType int32

const (
	// A value indicating that the enum field is not set.
	ConfidentialInstanceConfig_UNDEFINED_CONFIDENTIAL_INSTANCE_TYPE ConfidentialInstanceConfig_ConfidentialInstanceType = 0
	// No type specified. Do not use this value.
	ConfidentialInstanceConfig_CONFIDENTIAL_INSTANCE_TYPE_UNSPECIFIED ConfidentialInstanceConfig_ConfidentialInstanceType = 115021829
	// AMD Secure Encrypted Virtualization.
	ConfidentialInstanceConfig_SEV ConfidentialInstanceConfig_ConfidentialInstanceType = 81988
	// AMD Secure Encrypted Virtualization - Secure Nested Paging.
	ConfidentialInstanceConfig_SEV_SNP ConfidentialInstanceConfig_ConfidentialInstanceType = 21753562
	// Intel Trust Domain eXtension.
	ConfidentialInstanceConfig_TDX ConfidentialInstanceConfig_ConfidentialInstanceType = 82920
)

// Enum value maps for ConfidentialInstanceConfig_ConfidentialInstanceType.
var (
	ConfidentialInstanceConfig_ConfidentialInstanceType_name = map[int32]string{
		0:         "UNDEFINED_CONFIDENTIAL_INSTANCE_TYPE",
		115021829: "CONFIDENTIAL_INSTANCE_TYPE_UNSPECIFIED",
		81988:     "SEV",
		21753562:  "SEV_SNP",
		82920:     "TDX",
	}
	ConfidentialInstanceConfig_ConfidentialInstanceType_value = map[string]int32{
		"UNDEFINED_CONFIDENTIAL_INSTANCE_TYPE":   0,
		"CONFIDENTIAL_INSTANCE_TYPE_UNSPECIFIED": 115021829,
		"SEV":                                    81988,
		"SEV_SNP":                                21753562,
		"TDX":                                    82920,
	}
)

func (x ConfidentialInstanceConfig_ConfidentialInstanceType) Enum() *ConfidentialInstanceConfig_ConfidentialInstanceType {
	p := new(ConfidentialInstanceConfig_ConfidentialInstanceType)
	*p = x
	return p
}

func (x ConfidentialInstanceConfig_ConfidentialInstanceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConfidentialInstanceConfig_ConfidentialInstanceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[60].Descriptor()
}

func (ConfidentialInstanceConfig_ConfidentialInstanceType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[60]
}

func (x ConfidentialInstanceConfig_ConfidentialInstanceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConfidentialInstanceConfig_ConfidentialInstanceType.Descriptor instead.
func (ConfidentialInstanceConfig_ConfidentialInstanceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{205, 0}
}

// The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
type DeprecationStatus_State int32

const (
	// A value indicating that the enum field is not set.
	DeprecationStatus_UNDEFINED_STATE DeprecationStatus_State = 0
	DeprecationStatus_ACTIVE          DeprecationStatus_State = 314733318
	DeprecationStatus_DELETED         DeprecationStatus_State = 120962041
	DeprecationStatus_DEPRECATED      DeprecationStatus_State = 463360435
	DeprecationStatus_OBSOLETE        DeprecationStatus_State = 66532761
)

// Enum value maps for DeprecationStatus_State.
var (
	DeprecationStatus_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		120962041: "DELETED",
		463360435: "DEPRECATED",
		66532761:  "OBSOLETE",
	}
	DeprecationStatus_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"DELETED":         120962041,
		"DEPRECATED":      463360435,
		"OBSOLETE":        66532761,
	}
)

func (x DeprecationStatus_State) Enum() *DeprecationStatus_State {
	p := new(DeprecationStatus_State)
	*p = x
	return p
}

func (x DeprecationStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeprecationStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[61].Descriptor()
}

func (DeprecationStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[61]
}

func (x DeprecationStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeprecationStatus_State.Descriptor instead.
func (DeprecationStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{330, 0}
}

// The access mode of the disk. - READ_WRITE_SINGLE: The default AccessMode, means the disk can be attached to single instance in RW mode. - READ_WRITE_MANY: The AccessMode means the disk can be attached to multiple instances in RW mode. - READ_ONLY_MANY: The AccessMode means the disk can be attached to multiple instances in RO mode. The AccessMode is only valid for Hyperdisk disk types.
type Disk_AccessMode int32

const (
	// A value indicating that the enum field is not set.
	Disk_UNDEFINED_ACCESS_MODE Disk_AccessMode = 0
	// The AccessMode means the disk can be attached to multiple instances in RO mode.
	Disk_READ_ONLY_MANY Disk_AccessMode = 63460265
	// The AccessMode means the disk can be attached to multiple instances in RW mode.
	Disk_READ_WRITE_MANY Disk_AccessMode = 488743208
	// The default AccessMode, means the disk can be attached to single instance in RW mode.
	Disk_READ_WRITE_SINGLE Disk_AccessMode = 99323089
)

// Enum value maps for Disk_AccessMode.
var (
	Disk_AccessMode_name = map[int32]string{
		0:         "UNDEFINED_ACCESS_MODE",
		63460265:  "READ_ONLY_MANY",
		488743208: "READ_WRITE_MANY",
		99323089:  "READ_WRITE_SINGLE",
	}
	Disk_AccessMode_value = map[string]int32{
		"UNDEFINED_ACCESS_MODE": 0,
		"READ_ONLY_MANY":        63460265,
		"READ_WRITE_MANY":       488743208,
		"READ_WRITE_SINGLE":     99323089,
	}
)

func (x Disk_AccessMode) Enum() *Disk_AccessMode {
	p := new(Disk_AccessMode)
	*p = x
	return p
}

func (x Disk_AccessMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Disk_AccessMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[62].Descriptor()
}

func (Disk_AccessMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[62]
}

func (x Disk_AccessMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Disk_AccessMode.Descriptor instead.
func (Disk_AccessMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{337, 0}
}

// The architecture of the disk. Valid values are ARM64 or X86_64.
type Disk_Architecture int32

const (
	// A value indicating that the enum field is not set.
	Disk_UNDEFINED_ARCHITECTURE Disk_Architecture = 0
	// Default value indicating Architecture is not set.
	Disk_ARCHITECTURE_UNSPECIFIED Disk_Architecture = 394750507
	// Machines with architecture ARM64
	Disk_ARM64 Disk_Architecture = 62547450
	// Machines with architecture X86_64
	Disk_X86_64 Disk_Architecture = 425300551
)

// Enum value maps for Disk_Architecture.
var (
	Disk_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	Disk_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x Disk_Architecture) Enum() *Disk_Architecture {
	p := new(Disk_Architecture)
	*p = x
	return p
}

func (x Disk_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Disk_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[63].Descriptor()
}

func (Disk_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[63]
}

func (x Disk_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Disk_Architecture.Descriptor instead.
func (Disk_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{337, 1}
}

// [Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
type Disk_Interface int32

const (
	// A value indicating that the enum field is not set.
	Disk_UNDEFINED_INTERFACE Disk_Interface = 0
	Disk_NVME                Disk_Interface = 2408800
	Disk_SCSI                Disk_Interface = 2539686
	Disk_UNSPECIFIED         Disk_Interface = 526786327
)

// Enum value maps for Disk_Interface.
var (
	Disk_Interface_name = map[int32]string{
		0:         "UNDEFINED_INTERFACE",
		2408800:   "NVME",
		2539686:   "SCSI",
		526786327: "UNSPECIFIED",
	}
	Disk_Interface_value = map[string]int32{
		"UNDEFINED_INTERFACE": 0,
		"NVME":                2408800,
		"SCSI":                2539686,
		"UNSPECIFIED":         526786327,
	}
)

func (x Disk_Interface) Enum() *Disk_Interface {
	p := new(Disk_Interface)
	*p = x
	return p
}

func (x Disk_Interface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Disk_Interface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[64].Descriptor()
}

func (Disk_Interface) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[64]
}

func (x Disk_Interface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Disk_Interface.Descriptor instead.
func (Disk_Interface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{337, 2}
}

// [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
type Disk_Status int32

const (
	// A value indicating that the enum field is not set.
	Disk_UNDEFINED_STATUS Disk_Status = 0
	// Disk is provisioning
	Disk_CREATING Disk_Status = 455564985
	// Disk is deleting.
	Disk_DELETING Disk_Status = 528602024
	// Disk creation failed.
	Disk_FAILED Disk_Status = 455706685
	// Disk is ready for use.
	Disk_READY Disk_Status = 77848963
	// Source data is being copied into the disk.
	Disk_RESTORING Disk_Status = 404263851
	// Disk is currently unavailable and cannot be accessed, attached or detached.
	Disk_UNAVAILABLE Disk_Status = 413756464
)

// Enum value maps for Disk_Status.
var (
	Disk_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		455706685: "FAILED",
		77848963:  "READY",
		404263851: "RESTORING",
		413756464: "UNAVAILABLE",
	}
	Disk_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"READY":            77848963,
		"RESTORING":        404263851,
		"UNAVAILABLE":      413756464,
	}
)

func (x Disk_Status) Enum() *Disk_Status {
	p := new(Disk_Status)
	*p = x
	return p
}

func (x Disk_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Disk_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[65].Descriptor()
}

func (Disk_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[65]
}

func (x Disk_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Disk_Status.Descriptor instead.
func (Disk_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{337, 3}
}

// [Deprecated] Storage type of the persistent disk.
type Disk_StorageType int32

const (
	// A value indicating that the enum field is not set.
	Disk_UNDEFINED_STORAGE_TYPE Disk_StorageType = 0
	Disk_HDD                    Disk_StorageType = 71368
	Disk_SSD                    Disk_StorageType = 82404
)

// Enum value maps for Disk_StorageType.
var (
	Disk_StorageType_name = map[int32]string{
		0:     "UNDEFINED_STORAGE_TYPE",
		71368: "HDD",
		82404: "SSD",
	}
	Disk_StorageType_value = map[string]int32{
		"UNDEFINED_STORAGE_TYPE": 0,
		"HDD":                    71368,
		"SSD":                    82404,
	}
)

func (x Disk_StorageType) Enum() *Disk_StorageType {
	p := new(Disk_StorageType)
	*p = x
	return p
}

func (x Disk_StorageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Disk_StorageType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[66].Descriptor()
}

func (Disk_StorageType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[66]
}

func (x Disk_StorageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Disk_StorageType.Descriptor instead.
func (Disk_StorageType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{337, 4}
}

// Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
type DiskInstantiationConfig_InstantiateFrom int32

const (
	// A value indicating that the enum field is not set.
	DiskInstantiationConfig_UNDEFINED_INSTANTIATE_FROM DiskInstantiationConfig_InstantiateFrom = 0
	// Attach the existing disk in read-only mode. The request will fail if the disk was attached in read-write mode on the source instance. Applicable to: read-only disks.
	DiskInstantiationConfig_ATTACH_READ_ONLY DiskInstantiationConfig_InstantiateFrom = 513775419
	// Create a blank disk. The disk will be created unformatted. Applicable to: additional read-write disks, local SSDs.
	DiskInstantiationConfig_BLANK DiskInstantiationConfig_InstantiateFrom = 63281460
	// Use the custom image specified in the custom_image field. Applicable to: boot disk, additional read-write disks.
	DiskInstantiationConfig_CUSTOM_IMAGE DiskInstantiationConfig_InstantiateFrom = 196311789
	// Use the default instantiation option for the corresponding type of disk. For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
	DiskInstantiationConfig_DEFAULT DiskInstantiationConfig_InstantiateFrom = 115302945
	// Do not include the disk in the instance template. Applicable to: additional read-write disks, local SSDs, read-only disks.
	DiskInstantiationConfig_DO_NOT_INCLUDE DiskInstantiationConfig_InstantiateFrom = 104218952
	// Use the same source image used for creation of the source instance's corresponding disk. The request will fail if the source VM's disk was created from a snapshot. Applicable to: boot disk, additional read-write disks.
	DiskInstantiationConfig_SOURCE_IMAGE DiskInstantiationConfig_InstantiateFrom = 62631959
	// Use the same source image family used for creation of the source instance's corresponding disk. The request will fail if the source image of the source disk does not belong to any image family. Applicable to: boot disk, additional read-write disks.
	DiskInstantiationConfig_SOURCE_IMAGE_FAMILY DiskInstantiationConfig_InstantiateFrom = 76850316
)

// Enum value maps for DiskInstantiationConfig_InstantiateFrom.
var (
	DiskInstantiationConfig_InstantiateFrom_name = map[int32]string{
		0:         "UNDEFINED_INSTANTIATE_FROM",
		513775419: "ATTACH_READ_ONLY",
		63281460:  "BLANK",
		196311789: "CUSTOM_IMAGE",
		115302945: "DEFAULT",
		104218952: "DO_NOT_INCLUDE",
		62631959:  "SOURCE_IMAGE",
		76850316:  "SOURCE_IMAGE_FAMILY",
	}
	DiskInstantiationConfig_InstantiateFrom_value = map[string]int32{
		"UNDEFINED_INSTANTIATE_FROM": 0,
		"ATTACH_READ_ONLY":           513775419,
		"BLANK":                      63281460,
		"CUSTOM_IMAGE":               196311789,
		"DEFAULT":                    115302945,
		"DO_NOT_INCLUDE":             104218952,
		"SOURCE_IMAGE":               62631959,
		"SOURCE_IMAGE_FAMILY":        76850316,
	}
)

func (x DiskInstantiationConfig_InstantiateFrom) Enum() *DiskInstantiationConfig_InstantiateFrom {
	p := new(DiskInstantiationConfig_InstantiateFrom)
	*p = x
	return p
}

func (x DiskInstantiationConfig_InstantiateFrom) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskInstantiationConfig_InstantiateFrom) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[67].Descriptor()
}

func (DiskInstantiationConfig_InstantiateFrom) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[67]
}

func (x DiskInstantiationConfig_InstantiateFrom) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskInstantiationConfig_InstantiateFrom.Descriptor instead.
func (DiskInstantiationConfig_InstantiateFrom) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{341, 0}
}

type DiskResourceStatusAsyncReplicationStatus_State int32

const (
	// A value indicating that the enum field is not set.
	DiskResourceStatusAsyncReplicationStatus_UNDEFINED_STATE DiskResourceStatusAsyncReplicationStatus_State = 0
	// Replication is active.
	DiskResourceStatusAsyncReplicationStatus_ACTIVE DiskResourceStatusAsyncReplicationStatus_State = 314733318
	// Secondary disk is created and is waiting for replication to start.
	DiskResourceStatusAsyncReplicationStatus_CREATED DiskResourceStatusAsyncReplicationStatus_State = 135924424
	// Replication is starting.
	DiskResourceStatusAsyncReplicationStatus_STARTING          DiskResourceStatusAsyncReplicationStatus_State = 488820800
	DiskResourceStatusAsyncReplicationStatus_STATE_UNSPECIFIED DiskResourceStatusAsyncReplicationStatus_State = 470755401
	// Replication is stopped.
	DiskResourceStatusAsyncReplicationStatus_STOPPED DiskResourceStatusAsyncReplicationStatus_State = 444276141
	// Replication is stopping.
	DiskResourceStatusAsyncReplicationStatus_STOPPING DiskResourceStatusAsyncReplicationStatus_State = 350791796
)

// Enum value maps for DiskResourceStatusAsyncReplicationStatus_State.
var (
	DiskResourceStatusAsyncReplicationStatus_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		135924424: "CREATED",
		488820800: "STARTING",
		470755401: "STATE_UNSPECIFIED",
		444276141: "STOPPED",
		350791796: "STOPPING",
	}
	DiskResourceStatusAsyncReplicationStatus_State_value = map[string]int32{
		"UNDEFINED_STATE":   0,
		"ACTIVE":            314733318,
		"CREATED":           135924424,
		"STARTING":          488820800,
		"STATE_UNSPECIFIED": 470755401,
		"STOPPED":           444276141,
		"STOPPING":          350791796,
	}
)

func (x DiskResourceStatusAsyncReplicationStatus_State) Enum() *DiskResourceStatusAsyncReplicationStatus_State {
	p := new(DiskResourceStatusAsyncReplicationStatus_State)
	*p = x
	return p
}

func (x DiskResourceStatusAsyncReplicationStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskResourceStatusAsyncReplicationStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[68].Descriptor()
}

func (DiskResourceStatusAsyncReplicationStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[68]
}

func (x DiskResourceStatusAsyncReplicationStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskResourceStatusAsyncReplicationStatus_State.Descriptor instead.
func (DiskResourceStatusAsyncReplicationStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{346, 0}
}

type DiskSettingsAccessLocation_Policy int32

const (
	// A value indicating that the enum field is not set.
	DiskSettingsAccessLocation_UNDEFINED_POLICY   DiskSettingsAccessLocation_Policy = 0
	DiskSettingsAccessLocation_ALL_REGIONS        DiskSettingsAccessLocation_Policy = 273143585
	DiskSettingsAccessLocation_POLICY_UNSPECIFIED DiskSettingsAccessLocation_Policy = 197974922
	DiskSettingsAccessLocation_SPECIFIC_REGIONS   DiskSettingsAccessLocation_Policy = 454128082
)

// Enum value maps for DiskSettingsAccessLocation_Policy.
var (
	DiskSettingsAccessLocation_Policy_name = map[int32]string{
		0:         "UNDEFINED_POLICY",
		273143585: "ALL_REGIONS",
		197974922: "POLICY_UNSPECIFIED",
		454128082: "SPECIFIC_REGIONS",
	}
	DiskSettingsAccessLocation_Policy_value = map[string]int32{
		"UNDEFINED_POLICY":   0,
		"ALL_REGIONS":        273143585,
		"POLICY_UNSPECIFIED": 197974922,
		"SPECIFIC_REGIONS":   454128082,
	}
)

func (x DiskSettingsAccessLocation_Policy) Enum() *DiskSettingsAccessLocation_Policy {
	p := new(DiskSettingsAccessLocation_Policy)
	*p = x
	return p
}

func (x DiskSettingsAccessLocation_Policy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskSettingsAccessLocation_Policy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[69].Descriptor()
}

func (DiskSettingsAccessLocation_Policy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[69]
}

func (x DiskSettingsAccessLocation_Policy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskSettingsAccessLocation_Policy.Descriptor instead.
func (DiskSettingsAccessLocation_Policy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{348, 0}
}

// The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
type DistributionPolicy_TargetShape int32

const (
	// A value indicating that the enum field is not set.
	DistributionPolicy_UNDEFINED_TARGET_SHAPE DistributionPolicy_TargetShape = 0
	// The group picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
	DistributionPolicy_ANY DistributionPolicy_TargetShape = 64972
	// The group creates all VM instances within a single zone. The zone is selected based on the present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads with heavy interprocess communication.
	DistributionPolicy_ANY_SINGLE_ZONE DistributionPolicy_TargetShape = 61100880
	// The group prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across selected zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
	DistributionPolicy_BALANCED DistributionPolicy_TargetShape = 468409608
	// The group schedules VM instance creation and deletion to achieve and maintain an even number of managed instances across the selected zones. The distribution is even when the number of managed instances does not differ by more than 1 between any two zones. Recommended for highly available serving workloads.
	DistributionPolicy_EVEN DistributionPolicy_TargetShape = 2140442
)

// Enum value maps for DistributionPolicy_TargetShape.
var (
	DistributionPolicy_TargetShape_name = map[int32]string{
		0:         "UNDEFINED_TARGET_SHAPE",
		64972:     "ANY",
		61100880:  "ANY_SINGLE_ZONE",
		468409608: "BALANCED",
		2140442:   "EVEN",
	}
	DistributionPolicy_TargetShape_value = map[string]int32{
		"UNDEFINED_TARGET_SHAPE": 0,
		"ANY":                    64972,
		"ANY_SINGLE_ZONE":        61100880,
		"BALANCED":               468409608,
		"EVEN":                   2140442,
	}
)

func (x DistributionPolicy_TargetShape) Enum() *DistributionPolicy_TargetShape {
	p := new(DistributionPolicy_TargetShape)
	*p = x
	return p
}

func (x DistributionPolicy_TargetShape) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DistributionPolicy_TargetShape) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[70].Descriptor()
}

func (DistributionPolicy_TargetShape) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[70]
}

func (x DistributionPolicy_TargetShape) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DistributionPolicy_TargetShape.Descriptor instead.
func (DistributionPolicy_TargetShape) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{361, 0}
}

// The type of the peering route.
type ExchangedPeeringRoute_Type int32

const (
	// A value indicating that the enum field is not set.
	ExchangedPeeringRoute_UNDEFINED_TYPE ExchangedPeeringRoute_Type = 0
	// For routes exported from local network.
	ExchangedPeeringRoute_DYNAMIC_PEERING_ROUTE ExchangedPeeringRoute_Type = 469794858
	// The peering route.
	ExchangedPeeringRoute_STATIC_PEERING_ROUTE ExchangedPeeringRoute_Type = 473407545
	// The peering route corresponding to subnetwork range.
	ExchangedPeeringRoute_SUBNET_PEERING_ROUTE ExchangedPeeringRoute_Type = 465782504
)

// Enum value maps for ExchangedPeeringRoute_Type.
var (
	ExchangedPeeringRoute_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		469794858: "DYNAMIC_PEERING_ROUTE",
		473407545: "STATIC_PEERING_ROUTE",
		465782504: "SUBNET_PEERING_ROUTE",
	}
	ExchangedPeeringRoute_Type_value = map[string]int32{
		"UNDEFINED_TYPE":        0,
		"DYNAMIC_PEERING_ROUTE": 469794858,
		"STATIC_PEERING_ROUTE":  473407545,
		"SUBNET_PEERING_ROUTE":  465782504,
	}
)

func (x ExchangedPeeringRoute_Type) Enum() *ExchangedPeeringRoute_Type {
	p := new(ExchangedPeeringRoute_Type)
	*p = x
	return p
}

func (x ExchangedPeeringRoute_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExchangedPeeringRoute_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[71].Descriptor()
}

func (ExchangedPeeringRoute_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[71]
}

func (x ExchangedPeeringRoute_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExchangedPeeringRoute_Type.Descriptor instead.
func (ExchangedPeeringRoute_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{370, 0}
}

// Indicates the user-supplied redundancy type of this external VPN gateway.
type ExternalVpnGateway_RedundancyType int32

const (
	// A value indicating that the enum field is not set.
	ExternalVpnGateway_UNDEFINED_REDUNDANCY_TYPE ExternalVpnGateway_RedundancyType = 0
	// The external VPN gateway has four public IP addresses; at the time of writing this API, the AWS virtual private gateway is an example which has four public IP addresses for high availability connections; there should be two VPN connections in the AWS virtual private gateway , each AWS VPN connection has two public IP addresses; please make sure to put two public IP addresses from one AWS VPN connection into interfaces 0 and 1 of this external VPN gateway, and put the other two public IP addresses from another AWS VPN connection into interfaces 2 and 3 of this external VPN gateway. When displaying highly available configuration status for the VPN tunnels connected to FOUR_IPS_REDUNDANCY external VPN gateway, Google will always detect whether interfaces 0 and 1 are connected on one interface of HA Cloud VPN gateway, and detect whether interfaces 2 and 3 are connected to another interface of the HA Cloud VPN gateway.
	ExternalVpnGateway_FOUR_IPS_REDUNDANCY ExternalVpnGateway_RedundancyType = 520087913
	// The external VPN gateway has only one public IP address which internally provide redundancy or failover.
	ExternalVpnGateway_SINGLE_IP_INTERNALLY_REDUNDANT ExternalVpnGateway_RedundancyType = 133914873
	// The external VPN gateway has two public IP addresses which are redundant with each other, the following two types of setup on your on-premises side would have this type of redundancy: (1) Two separate on-premises gateways, each with one public IP address, the two on-premises gateways are redundant with each other. (2) A single on-premise gateway with two public IP addresses that are redundant with eatch other.
	ExternalVpnGateway_TWO_IPS_REDUNDANCY ExternalVpnGateway_RedundancyType = 367049635
)

// Enum value maps for ExternalVpnGateway_RedundancyType.
var (
	ExternalVpnGateway_RedundancyType_name = map[int32]string{
		0:         "UNDEFINED_REDUNDANCY_TYPE",
		520087913: "FOUR_IPS_REDUNDANCY",
		133914873: "SINGLE_IP_INTERNALLY_REDUNDANT",
		367049635: "TWO_IPS_REDUNDANCY",
	}
	ExternalVpnGateway_RedundancyType_value = map[string]int32{
		"UNDEFINED_REDUNDANCY_TYPE":      0,
		"FOUR_IPS_REDUNDANCY":            520087913,
		"SINGLE_IP_INTERNALLY_REDUNDANT": 133914873,
		"TWO_IPS_REDUNDANCY":             367049635,
	}
)

func (x ExternalVpnGateway_RedundancyType) Enum() *ExternalVpnGateway_RedundancyType {
	p := new(ExternalVpnGateway_RedundancyType)
	*p = x
	return p
}

func (x ExternalVpnGateway_RedundancyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExternalVpnGateway_RedundancyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[72].Descriptor()
}

func (ExternalVpnGateway_RedundancyType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[72]
}

func (x ExternalVpnGateway_RedundancyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExternalVpnGateway_RedundancyType.Descriptor instead.
func (ExternalVpnGateway_RedundancyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{374, 0}
}

// The file type of source file.
type FileContentBuffer_FileType int32

const (
	// A value indicating that the enum field is not set.
	FileContentBuffer_UNDEFINED_FILE_TYPE FileContentBuffer_FileType = 0
	FileContentBuffer_BIN                 FileContentBuffer_FileType = 65767
	FileContentBuffer_UNDEFINED           FileContentBuffer_FileType = 137851184
	FileContentBuffer_X509                FileContentBuffer_FileType = 2674086
)

// Enum value maps for FileContentBuffer_FileType.
var (
	FileContentBuffer_FileType_name = map[int32]string{
		0:         "UNDEFINED_FILE_TYPE",
		65767:     "BIN",
		137851184: "UNDEFINED",
		2674086:   "X509",
	}
	FileContentBuffer_FileType_value = map[string]int32{
		"UNDEFINED_FILE_TYPE": 0,
		"BIN":                 65767,
		"UNDEFINED":           137851184,
		"X509":                2674086,
	}
)

func (x FileContentBuffer_FileType) Enum() *FileContentBuffer_FileType {
	p := new(FileContentBuffer_FileType)
	*p = x
	return p
}

func (x FileContentBuffer_FileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileContentBuffer_FileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[73].Descriptor()
}

func (FileContentBuffer_FileType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[73]
}

func (x FileContentBuffer_FileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileContentBuffer_FileType.Descriptor instead.
func (FileContentBuffer_FileType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{377, 0}
}

// Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
type Firewall_Direction int32

const (
	// A value indicating that the enum field is not set.
	Firewall_UNDEFINED_DIRECTION Firewall_Direction = 0
	// Indicates that firewall should apply to outgoing traffic.
	Firewall_EGRESS Firewall_Direction = 432880501
	// Indicates that firewall should apply to incoming traffic.
	Firewall_INGRESS Firewall_Direction = 516931221
)

// Enum value maps for Firewall_Direction.
var (
	Firewall_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		432880501: "EGRESS",
		516931221: "INGRESS",
	}
	Firewall_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"EGRESS":              432880501,
		"INGRESS":             516931221,
	}
)

func (x Firewall_Direction) Enum() *Firewall_Direction {
	p := new(Firewall_Direction)
	*p = x
	return p
}

func (x Firewall_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Firewall_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[74].Descriptor()
}

func (Firewall_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[74]
}

func (x Firewall_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Firewall_Direction.Descriptor instead.
func (Firewall_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{378, 0}
}

// This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
type FirewallLogConfig_Metadata int32

const (
	// A value indicating that the enum field is not set.
	FirewallLogConfig_UNDEFINED_METADATA   FirewallLogConfig_Metadata = 0
	FirewallLogConfig_EXCLUDE_ALL_METADATA FirewallLogConfig_Metadata = 334519954
	FirewallLogConfig_INCLUDE_ALL_METADATA FirewallLogConfig_Metadata = 164619908
)

// Enum value maps for FirewallLogConfig_Metadata.
var (
	FirewallLogConfig_Metadata_name = map[int32]string{
		0:         "UNDEFINED_METADATA",
		334519954: "EXCLUDE_ALL_METADATA",
		164619908: "INCLUDE_ALL_METADATA",
	}
	FirewallLogConfig_Metadata_value = map[string]int32{
		"UNDEFINED_METADATA":   0,
		"EXCLUDE_ALL_METADATA": 334519954,
		"INCLUDE_ALL_METADATA": 164619908,
	}
)

func (x FirewallLogConfig_Metadata) Enum() *FirewallLogConfig_Metadata {
	p := new(FirewallLogConfig_Metadata)
	*p = x
	return p
}

func (x FirewallLogConfig_Metadata) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallLogConfig_Metadata) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[75].Descriptor()
}

func (FirewallLogConfig_Metadata) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[75]
}

func (x FirewallLogConfig_Metadata) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallLogConfig_Metadata.Descriptor instead.
func (FirewallLogConfig_Metadata) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{380, 0}
}

// [Output Only] Source of this Firewall Policy. USER_DEFINED if created by a Cloud user, or SYSTEM if created by managed services like GKE.
type FirewallPolicy_PolicySource int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicy_UNDEFINED_POLICY_SOURCE FirewallPolicy_PolicySource = 0
	FirewallPolicy_SYSTEM                  FirewallPolicy_PolicySource = 313484847
	FirewallPolicy_USER_DEFINED            FirewallPolicy_PolicySource = 491485557
)

// Enum value maps for FirewallPolicy_PolicySource.
var (
	FirewallPolicy_PolicySource_name = map[int32]string{
		0:         "UNDEFINED_POLICY_SOURCE",
		313484847: "SYSTEM",
		491485557: "USER_DEFINED",
	}
	FirewallPolicy_PolicySource_value = map[string]int32{
		"UNDEFINED_POLICY_SOURCE": 0,
		"SYSTEM":                  313484847,
		"USER_DEFINED":            491485557,
	}
)

func (x FirewallPolicy_PolicySource) Enum() *FirewallPolicy_PolicySource {
	p := new(FirewallPolicy_PolicySource)
	*p = x
	return p
}

func (x FirewallPolicy_PolicySource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicy_PolicySource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[76].Descriptor()
}

func (FirewallPolicy_PolicySource) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[76]
}

func (x FirewallPolicy_PolicySource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicy_PolicySource.Descriptor instead.
func (FirewallPolicy_PolicySource) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{384, 0}
}

// The type of the firewall policy. This field can be either VPC_POLICY or RDMA_ROCE_POLICY. Note: if not specified then VPC_POLICY will be used.
type FirewallPolicy_PolicyType int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicy_UNDEFINED_POLICY_TYPE FirewallPolicy_PolicyType = 0
	FirewallPolicy_RDMA_ROCE_POLICY      FirewallPolicy_PolicyType = 148757145
	FirewallPolicy_VPC_POLICY            FirewallPolicy_PolicyType = 74319208
)

// Enum value maps for FirewallPolicy_PolicyType.
var (
	FirewallPolicy_PolicyType_name = map[int32]string{
		0:         "UNDEFINED_POLICY_TYPE",
		148757145: "RDMA_ROCE_POLICY",
		74319208:  "VPC_POLICY",
	}
	FirewallPolicy_PolicyType_value = map[string]int32{
		"UNDEFINED_POLICY_TYPE": 0,
		"RDMA_ROCE_POLICY":      148757145,
		"VPC_POLICY":            74319208,
	}
)

func (x FirewallPolicy_PolicyType) Enum() *FirewallPolicy_PolicyType {
	p := new(FirewallPolicy_PolicyType)
	*p = x
	return p
}

func (x FirewallPolicy_PolicyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicy_PolicyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[77].Descriptor()
}

func (FirewallPolicy_PolicyType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[77]
}

func (x FirewallPolicy_PolicyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicy_PolicyType.Descriptor instead.
func (FirewallPolicy_PolicyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{384, 1}
}

// The direction in which this rule applies.
type FirewallPolicyRule_Direction int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRule_UNDEFINED_DIRECTION FirewallPolicyRule_Direction = 0
	FirewallPolicyRule_EGRESS              FirewallPolicyRule_Direction = 432880501
	FirewallPolicyRule_INGRESS             FirewallPolicyRule_Direction = 516931221
)

// Enum value maps for FirewallPolicyRule_Direction.
var (
	FirewallPolicyRule_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		432880501: "EGRESS",
		516931221: "INGRESS",
	}
	FirewallPolicyRule_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"EGRESS":              432880501,
		"INGRESS":             516931221,
	}
)

func (x FirewallPolicyRule_Direction) Enum() *FirewallPolicyRule_Direction {
	p := new(FirewallPolicyRule_Direction)
	*p = x
	return p
}

func (x FirewallPolicyRule_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRule_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[78].Descriptor()
}

func (FirewallPolicyRule_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[78]
}

func (x FirewallPolicyRule_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRule_Direction.Descriptor instead.
func (FirewallPolicyRule_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{387, 0}
}

// Target types of the firewall policy rule. Default value is INSTANCES.
type FirewallPolicyRule_TargetType int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRule_UNDEFINED_TARGET_TYPE FirewallPolicyRule_TargetType = 0
	FirewallPolicyRule_INSTANCES             FirewallPolicyRule_TargetType = 131337822
	FirewallPolicyRule_INTERNAL_MANAGED_LB   FirewallPolicyRule_TargetType = 309241080
)

// Enum value maps for FirewallPolicyRule_TargetType.
var (
	FirewallPolicyRule_TargetType_name = map[int32]string{
		0:         "UNDEFINED_TARGET_TYPE",
		131337822: "INSTANCES",
		309241080: "INTERNAL_MANAGED_LB",
	}
	FirewallPolicyRule_TargetType_value = map[string]int32{
		"UNDEFINED_TARGET_TYPE": 0,
		"INSTANCES":             131337822,
		"INTERNAL_MANAGED_LB":   309241080,
	}
)

func (x FirewallPolicyRule_TargetType) Enum() *FirewallPolicyRule_TargetType {
	p := new(FirewallPolicyRule_TargetType)
	*p = x
	return p
}

func (x FirewallPolicyRule_TargetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRule_TargetType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[79].Descriptor()
}

func (FirewallPolicyRule_TargetType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[79]
}

func (x FirewallPolicyRule_TargetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRule_TargetType.Descriptor instead.
func (FirewallPolicyRule_TargetType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{387, 1}
}

// Network scope of the traffic destination.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// INTERNET
// INTRA_VPC
// NON_INTERNET
// UNSPECIFIED
// VPC_NETWORKS
type FirewallPolicyRuleMatcher_DestNetworkScope int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRuleMatcher_UNDEFINED_DEST_NETWORK_SCOPE FirewallPolicyRuleMatcher_DestNetworkScope = 0
)

// Enum value maps for FirewallPolicyRuleMatcher_DestNetworkScope.
var (
	FirewallPolicyRuleMatcher_DestNetworkScope_name = map[int32]string{
		0: "UNDEFINED_DEST_NETWORK_SCOPE",
	}
	FirewallPolicyRuleMatcher_DestNetworkScope_value = map[string]int32{
		"UNDEFINED_DEST_NETWORK_SCOPE": 0,
	}
)

func (x FirewallPolicyRuleMatcher_DestNetworkScope) Enum() *FirewallPolicyRuleMatcher_DestNetworkScope {
	p := new(FirewallPolicyRuleMatcher_DestNetworkScope)
	*p = x
	return p
}

func (x FirewallPolicyRuleMatcher_DestNetworkScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRuleMatcher_DestNetworkScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[80].Descriptor()
}

func (FirewallPolicyRuleMatcher_DestNetworkScope) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[80]
}

func (x FirewallPolicyRuleMatcher_DestNetworkScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRuleMatcher_DestNetworkScope.Descriptor instead.
func (FirewallPolicyRuleMatcher_DestNetworkScope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{388, 0}
}

// Network type of the traffic destination. Allowed values are: - UNSPECIFIED - INTERNET - NON_INTERNET
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// INTERNET
// INTRA_VPC
// NON_INTERNET
// UNSPECIFIED
// VPC_NETWORKS
type FirewallPolicyRuleMatcher_DestNetworkType int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRuleMatcher_UNDEFINED_DEST_NETWORK_TYPE FirewallPolicyRuleMatcher_DestNetworkType = 0
)

// Enum value maps for FirewallPolicyRuleMatcher_DestNetworkType.
var (
	FirewallPolicyRuleMatcher_DestNetworkType_name = map[int32]string{
		0: "UNDEFINED_DEST_NETWORK_TYPE",
	}
	FirewallPolicyRuleMatcher_DestNetworkType_value = map[string]int32{
		"UNDEFINED_DEST_NETWORK_TYPE": 0,
	}
)

func (x FirewallPolicyRuleMatcher_DestNetworkType) Enum() *FirewallPolicyRuleMatcher_DestNetworkType {
	p := new(FirewallPolicyRuleMatcher_DestNetworkType)
	*p = x
	return p
}

func (x FirewallPolicyRuleMatcher_DestNetworkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRuleMatcher_DestNetworkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[81].Descriptor()
}

func (FirewallPolicyRuleMatcher_DestNetworkType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[81]
}

func (x FirewallPolicyRuleMatcher_DestNetworkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRuleMatcher_DestNetworkType.Descriptor instead.
func (FirewallPolicyRuleMatcher_DestNetworkType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{388, 1}
}

// Network scope of the traffic source.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// INTERNET
// INTRA_VPC
// NON_INTERNET
// UNSPECIFIED
// VPC_NETWORKS
type FirewallPolicyRuleMatcher_SrcNetworkScope int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRuleMatcher_UNDEFINED_SRC_NETWORK_SCOPE FirewallPolicyRuleMatcher_SrcNetworkScope = 0
)

// Enum value maps for FirewallPolicyRuleMatcher_SrcNetworkScope.
var (
	FirewallPolicyRuleMatcher_SrcNetworkScope_name = map[int32]string{
		0: "UNDEFINED_SRC_NETWORK_SCOPE",
	}
	FirewallPolicyRuleMatcher_SrcNetworkScope_value = map[string]int32{
		"UNDEFINED_SRC_NETWORK_SCOPE": 0,
	}
)

func (x FirewallPolicyRuleMatcher_SrcNetworkScope) Enum() *FirewallPolicyRuleMatcher_SrcNetworkScope {
	p := new(FirewallPolicyRuleMatcher_SrcNetworkScope)
	*p = x
	return p
}

func (x FirewallPolicyRuleMatcher_SrcNetworkScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRuleMatcher_SrcNetworkScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[82].Descriptor()
}

func (FirewallPolicyRuleMatcher_SrcNetworkScope) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[82]
}

func (x FirewallPolicyRuleMatcher_SrcNetworkScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRuleMatcher_SrcNetworkScope.Descriptor instead.
func (FirewallPolicyRuleMatcher_SrcNetworkScope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{388, 2}
}

// Network type of the traffic source. Allowed values are: - UNSPECIFIED - INTERNET - INTRA_VPC - NON_INTERNET - VPC_NETWORKS
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// INTERNET
// INTRA_VPC
// NON_INTERNET
// UNSPECIFIED
// VPC_NETWORKS
type FirewallPolicyRuleMatcher_SrcNetworkType int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRuleMatcher_UNDEFINED_SRC_NETWORK_TYPE FirewallPolicyRuleMatcher_SrcNetworkType = 0
)

// Enum value maps for FirewallPolicyRuleMatcher_SrcNetworkType.
var (
	FirewallPolicyRuleMatcher_SrcNetworkType_name = map[int32]string{
		0: "UNDEFINED_SRC_NETWORK_TYPE",
	}
	FirewallPolicyRuleMatcher_SrcNetworkType_value = map[string]int32{
		"UNDEFINED_SRC_NETWORK_TYPE": 0,
	}
)

func (x FirewallPolicyRuleMatcher_SrcNetworkType) Enum() *FirewallPolicyRuleMatcher_SrcNetworkType {
	p := new(FirewallPolicyRuleMatcher_SrcNetworkType)
	*p = x
	return p
}

func (x FirewallPolicyRuleMatcher_SrcNetworkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRuleMatcher_SrcNetworkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[83].Descriptor()
}

func (FirewallPolicyRuleMatcher_SrcNetworkType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[83]
}

func (x FirewallPolicyRuleMatcher_SrcNetworkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRuleMatcher_SrcNetworkType.Descriptor instead.
func (FirewallPolicyRuleMatcher_SrcNetworkType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{388, 3}
}

// [Output Only] State of the secure tag, either `EFFECTIVE` or `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or its network is deleted.
type FirewallPolicyRuleSecureTag_State int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRuleSecureTag_UNDEFINED_STATE FirewallPolicyRuleSecureTag_State = 0
	FirewallPolicyRuleSecureTag_EFFECTIVE       FirewallPolicyRuleSecureTag_State = 244201863
	FirewallPolicyRuleSecureTag_INEFFECTIVE     FirewallPolicyRuleSecureTag_State = 304458242
)

// Enum value maps for FirewallPolicyRuleSecureTag_State.
var (
	FirewallPolicyRuleSecureTag_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		244201863: "EFFECTIVE",
		304458242: "INEFFECTIVE",
	}
	FirewallPolicyRuleSecureTag_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"EFFECTIVE":       244201863,
		"INEFFECTIVE":     304458242,
	}
)

func (x FirewallPolicyRuleSecureTag_State) Enum() *FirewallPolicyRuleSecureTag_State {
	p := new(FirewallPolicyRuleSecureTag_State)
	*p = x
	return p
}

func (x FirewallPolicyRuleSecureTag_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRuleSecureTag_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[84].Descriptor()
}

func (FirewallPolicyRuleSecureTag_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[84]
}

func (x FirewallPolicyRuleSecureTag_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRuleSecureTag_State.Descriptor instead.
func (FirewallPolicyRuleSecureTag_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{390, 0}
}

// Specifies the canary migration state for the backend buckets attached to this forwarding rule. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic to backend buckets attached to this forwarding rule by percentage using externalManagedBackendBucketMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
type ForwardingRule_ExternalManagedBackendBucketMigrationState int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_EXTERNAL_MANAGED_BACKEND_BUCKET_MIGRATION_STATE ForwardingRule_ExternalManagedBackendBucketMigrationState = 0
	ForwardingRule_PREPARE                                                   ForwardingRule_ExternalManagedBackendBucketMigrationState = 399612135
	ForwardingRule_TEST_ALL_TRAFFIC                                          ForwardingRule_ExternalManagedBackendBucketMigrationState = 79728882
	ForwardingRule_TEST_BY_PERCENTAGE                                        ForwardingRule_ExternalManagedBackendBucketMigrationState = 513738389
)

// Enum value maps for ForwardingRule_ExternalManagedBackendBucketMigrationState.
var (
	ForwardingRule_ExternalManagedBackendBucketMigrationState_name = map[int32]string{
		0:         "UNDEFINED_EXTERNAL_MANAGED_BACKEND_BUCKET_MIGRATION_STATE",
		399612135: "PREPARE",
		79728882:  "TEST_ALL_TRAFFIC",
		513738389: "TEST_BY_PERCENTAGE",
	}
	ForwardingRule_ExternalManagedBackendBucketMigrationState_value = map[string]int32{
		"UNDEFINED_EXTERNAL_MANAGED_BACKEND_BUCKET_MIGRATION_STATE": 0,
		"PREPARE":            399612135,
		"TEST_ALL_TRAFFIC":   79728882,
		"TEST_BY_PERCENTAGE": 513738389,
	}
)

func (x ForwardingRule_ExternalManagedBackendBucketMigrationState) Enum() *ForwardingRule_ExternalManagedBackendBucketMigrationState {
	p := new(ForwardingRule_ExternalManagedBackendBucketMigrationState)
	*p = x
	return p
}

func (x ForwardingRule_ExternalManagedBackendBucketMigrationState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_ExternalManagedBackendBucketMigrationState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[85].Descriptor()
}

func (ForwardingRule_ExternalManagedBackendBucketMigrationState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[85]
}

func (x ForwardingRule_ExternalManagedBackendBucketMigrationState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_ExternalManagedBackendBucketMigrationState.Descriptor instead.
func (ForwardingRule_ExternalManagedBackendBucketMigrationState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{393, 0}
}

// The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
type ForwardingRule_IPProtocolEnum int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_I_P_PROTOCOL_ENUM ForwardingRule_IPProtocolEnum = 0
	ForwardingRule_AH                          ForwardingRule_IPProtocolEnum = 2087
	ForwardingRule_ESP                         ForwardingRule_IPProtocolEnum = 68962
	ForwardingRule_ICMP                        ForwardingRule_IPProtocolEnum = 2241597
	ForwardingRule_L3_DEFAULT                  ForwardingRule_IPProtocolEnum = 48151369
	ForwardingRule_SCTP                        ForwardingRule_IPProtocolEnum = 2539724
	ForwardingRule_TCP                         ForwardingRule_IPProtocolEnum = 82881
	ForwardingRule_UDP                         ForwardingRule_IPProtocolEnum = 83873
)

// Enum value maps for ForwardingRule_IPProtocolEnum.
var (
	ForwardingRule_IPProtocolEnum_name = map[int32]string{
		0:        "UNDEFINED_I_P_PROTOCOL_ENUM",
		2087:     "AH",
		68962:    "ESP",
		2241597:  "ICMP",
		48151369: "L3_DEFAULT",
		2539724:  "SCTP",
		82881:    "TCP",
		83873:    "UDP",
	}
	ForwardingRule_IPProtocolEnum_value = map[string]int32{
		"UNDEFINED_I_P_PROTOCOL_ENUM": 0,
		"AH":                          2087,
		"ESP":                         68962,
		"ICMP":                        2241597,
		"L3_DEFAULT":                  48151369,
		"SCTP":                        2539724,
		"TCP":                         82881,
		"UDP":                         83873,
	}
)

func (x ForwardingRule_IPProtocolEnum) Enum() *ForwardingRule_IPProtocolEnum {
	p := new(ForwardingRule_IPProtocolEnum)
	*p = x
	return p
}

func (x ForwardingRule_IPProtocolEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_IPProtocolEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[86].Descriptor()
}

func (ForwardingRule_IPProtocolEnum) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[86]
}

func (x ForwardingRule_IPProtocolEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_IPProtocolEnum.Descriptor instead.
func (ForwardingRule_IPProtocolEnum) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{393, 1}
}

// The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
type ForwardingRule_IpVersion int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_IP_VERSION ForwardingRule_IpVersion = 0
	ForwardingRule_IPV4                 ForwardingRule_IpVersion = 2254341
	ForwardingRule_IPV6                 ForwardingRule_IpVersion = 2254343
	ForwardingRule_UNSPECIFIED_VERSION  ForwardingRule_IpVersion = 21850000
)

// Enum value maps for ForwardingRule_IpVersion.
var (
	ForwardingRule_IpVersion_name = map[int32]string{
		0:        "UNDEFINED_IP_VERSION",
		2254341:  "IPV4",
		2254343:  "IPV6",
		21850000: "UNSPECIFIED_VERSION",
	}
	ForwardingRule_IpVersion_value = map[string]int32{
		"UNDEFINED_IP_VERSION": 0,
		"IPV4":                 2254341,
		"IPV6":                 2254343,
		"UNSPECIFIED_VERSION":  21850000,
	}
)

func (x ForwardingRule_IpVersion) Enum() *ForwardingRule_IpVersion {
	p := new(ForwardingRule_IpVersion)
	*p = x
	return p
}

func (x ForwardingRule_IpVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_IpVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[87].Descriptor()
}

func (ForwardingRule_IpVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[87]
}

func (x ForwardingRule_IpVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_IpVersion.Descriptor instead.
func (ForwardingRule_IpVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{393, 2}
}

// Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
type ForwardingRule_LoadBalancingScheme int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_LOAD_BALANCING_SCHEME ForwardingRule_LoadBalancingScheme = 0
	ForwardingRule_EXTERNAL                        ForwardingRule_LoadBalancingScheme = 35607499
	ForwardingRule_EXTERNAL_MANAGED                ForwardingRule_LoadBalancingScheme = 512006923
	ForwardingRule_INTERNAL                        ForwardingRule_LoadBalancingScheme = 279295677
	ForwardingRule_INTERNAL_MANAGED                ForwardingRule_LoadBalancingScheme = 37350397
	ForwardingRule_INTERNAL_SELF_MANAGED           ForwardingRule_LoadBalancingScheme = 236211150
	ForwardingRule_INVALID                         ForwardingRule_LoadBalancingScheme = 530283991
)

// Enum value maps for ForwardingRule_LoadBalancingScheme.
var (
	ForwardingRule_LoadBalancingScheme_name = map[int32]string{
		0:         "UNDEFINED_LOAD_BALANCING_SCHEME",
		35607499:  "EXTERNAL",
		512006923: "EXTERNAL_MANAGED",
		279295677: "INTERNAL",
		37350397:  "INTERNAL_MANAGED",
		236211150: "INTERNAL_SELF_MANAGED",
		530283991: "INVALID",
	}
	ForwardingRule_LoadBalancingScheme_value = map[string]int32{
		"UNDEFINED_LOAD_BALANCING_SCHEME": 0,
		"EXTERNAL":                        35607499,
		"EXTERNAL_MANAGED":                512006923,
		"INTERNAL":                        279295677,
		"INTERNAL_MANAGED":                37350397,
		"INTERNAL_SELF_MANAGED":           236211150,
		"INVALID":                         530283991,
	}
)

func (x ForwardingRule_LoadBalancingScheme) Enum() *ForwardingRule_LoadBalancingScheme {
	p := new(ForwardingRule_LoadBalancingScheme)
	*p = x
	return p
}

func (x ForwardingRule_LoadBalancingScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_LoadBalancingScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[88].Descriptor()
}

func (ForwardingRule_LoadBalancingScheme) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[88]
}

func (x ForwardingRule_LoadBalancingScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_LoadBalancingScheme.Descriptor instead.
func (ForwardingRule_LoadBalancingScheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{393, 3}
}

// This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
type ForwardingRule_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_NETWORK_TIER ForwardingRule_NetworkTier = 0
	// Public internet quality with fixed bandwidth.
	ForwardingRule_FIXED_STANDARD ForwardingRule_NetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	ForwardingRule_PREMIUM ForwardingRule_NetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	ForwardingRule_STANDARD ForwardingRule_NetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	ForwardingRule_STANDARD_OVERRIDES_FIXED_STANDARD ForwardingRule_NetworkTier = 465847234
)

// Enum value maps for ForwardingRule_NetworkTier.
var (
	ForwardingRule_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	ForwardingRule_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER":            0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x ForwardingRule_NetworkTier) Enum() *ForwardingRule_NetworkTier {
	p := new(ForwardingRule_NetworkTier)
	*p = x
	return p
}

func (x ForwardingRule_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[89].Descriptor()
}

func (ForwardingRule_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[89]
}

func (x ForwardingRule_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_NetworkTier.Descriptor instead.
func (ForwardingRule_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{393, 4}
}

type ForwardingRule_PscConnectionStatus int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_PSC_CONNECTION_STATUS ForwardingRule_PscConnectionStatus = 0
	// The connection has been accepted by the producer.
	ForwardingRule_ACCEPTED ForwardingRule_PscConnectionStatus = 246714279
	// The connection has been closed by the producer and will not serve traffic going forward.
	ForwardingRule_CLOSED ForwardingRule_PscConnectionStatus = 380163436
	// The connection has been accepted by the producer, but the producer needs to take further action before the forwarding rule can serve traffic.
	ForwardingRule_NEEDS_ATTENTION ForwardingRule_PscConnectionStatus = 344491452
	// The connection is pending acceptance by the producer.
	ForwardingRule_PENDING ForwardingRule_PscConnectionStatus = 35394935
	// The connection has been rejected by the producer.
	ForwardingRule_REJECTED           ForwardingRule_PscConnectionStatus = 174130302
	ForwardingRule_STATUS_UNSPECIFIED ForwardingRule_PscConnectionStatus = 42133066
)

// Enum value maps for ForwardingRule_PscConnectionStatus.
var (
	ForwardingRule_PscConnectionStatus_name = map[int32]string{
		0:         "UNDEFINED_PSC_CONNECTION_STATUS",
		246714279: "ACCEPTED",
		380163436: "CLOSED",
		344491452: "NEEDS_ATTENTION",
		35394935:  "PENDING",
		174130302: "REJECTED",
		42133066:  "STATUS_UNSPECIFIED",
	}
	ForwardingRule_PscConnectionStatus_value = map[string]int32{
		"UNDEFINED_PSC_CONNECTION_STATUS": 0,
		"ACCEPTED":                        246714279,
		"CLOSED":                          380163436,
		"NEEDS_ATTENTION":                 344491452,
		"PENDING":                         35394935,
		"REJECTED":                        174130302,
		"STATUS_UNSPECIFIED":              42133066,
	}
)

func (x ForwardingRule_PscConnectionStatus) Enum() *ForwardingRule_PscConnectionStatus {
	p := new(ForwardingRule_PscConnectionStatus)
	*p = x
	return p
}

func (x ForwardingRule_PscConnectionStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_PscConnectionStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[90].Descriptor()
}

func (ForwardingRule_PscConnectionStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[90]
}

func (x ForwardingRule_PscConnectionStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_PscConnectionStatus.Descriptor instead.
func (ForwardingRule_PscConnectionStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{393, 5}
}

// Type of the deployment requested as part of future reservation.
type FutureReservation_DeploymentType int32

const (
	// A value indicating that the enum field is not set.
	FutureReservation_UNDEFINED_DEPLOYMENT_TYPE FutureReservation_DeploymentType = 0
	// The reserved capacity is made up of densely deployed reservation blocks.
	FutureReservation_DENSE                       FutureReservation_DeploymentType = 64932607
	FutureReservation_DEPLOYMENT_TYPE_UNSPECIFIED FutureReservation_DeploymentType = 234847180
	// The reserved capacity is made up of highly flexible, logical reservation blocks.
	FutureReservation_FLEXIBLE FutureReservation_DeploymentType = 379880395
)

// Enum value maps for FutureReservation_DeploymentType.
var (
	FutureReservation_DeploymentType_name = map[int32]string{
		0:         "UNDEFINED_DEPLOYMENT_TYPE",
		64932607:  "DENSE",
		234847180: "DEPLOYMENT_TYPE_UNSPECIFIED",
		379880395: "FLEXIBLE",
	}
	FutureReservation_DeploymentType_value = map[string]int32{
		"UNDEFINED_DEPLOYMENT_TYPE":   0,
		"DENSE":                       64932607,
		"DEPLOYMENT_TYPE_UNSPECIFIED": 234847180,
		"FLEXIBLE":                    379880395,
	}
)

func (x FutureReservation_DeploymentType) Enum() *FutureReservation_DeploymentType {
	p := new(FutureReservation_DeploymentType)
	*p = x
	return p
}

func (x FutureReservation_DeploymentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservation_DeploymentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[91].Descriptor()
}

func (FutureReservation_DeploymentType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[91]
}

func (x FutureReservation_DeploymentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservation_DeploymentType.Descriptor instead.
func (FutureReservation_DeploymentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{399, 0}
}

// Planning state before being submitted for evaluation
type FutureReservation_PlanningStatus int32

const (
	// A value indicating that the enum field is not set.
	FutureReservation_UNDEFINED_PLANNING_STATUS FutureReservation_PlanningStatus = 0
	// Future Reservation is being drafted.
	FutureReservation_DRAFT                       FutureReservation_PlanningStatus = 65307009
	FutureReservation_PLANNING_STATUS_UNSPECIFIED FutureReservation_PlanningStatus = 252728940
	// Future Reservation has been submitted for evaluation by GCP.
	FutureReservation_SUBMITTED FutureReservation_PlanningStatus = 450918619
)

// Enum value maps for FutureReservation_PlanningStatus.
var (
	FutureReservation_PlanningStatus_name = map[int32]string{
		0:         "UNDEFINED_PLANNING_STATUS",
		65307009:  "DRAFT",
		252728940: "PLANNING_STATUS_UNSPECIFIED",
		450918619: "SUBMITTED",
	}
	FutureReservation_PlanningStatus_value = map[string]int32{
		"UNDEFINED_PLANNING_STATUS":   0,
		"DRAFT":                       65307009,
		"PLANNING_STATUS_UNSPECIFIED": 252728940,
		"SUBMITTED":                   450918619,
	}
)

func (x FutureReservation_PlanningStatus) Enum() *FutureReservation_PlanningStatus {
	p := new(FutureReservation_PlanningStatus)
	*p = x
	return p
}

func (x FutureReservation_PlanningStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservation_PlanningStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[92].Descriptor()
}

func (FutureReservation_PlanningStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[92]
}

func (x FutureReservation_PlanningStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservation_PlanningStatus.Descriptor instead.
func (FutureReservation_PlanningStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{399, 1}
}

// Protection tier for the workload.
type FutureReservation_ProtectionTier int32

const (
	// A value indicating that the enum field is not set.
	FutureReservation_UNDEFINED_PROTECTION_TIER FutureReservation_ProtectionTier = 0
	// CAPACITY_OPTIMIZED capacity leverages redundancies (e.g. power, cooling) at the data center during normal operating conditions. In the event of infrastructure failures at data center (e.g. power and/or cooling failures), this workload may be disrupted. As a consequence, it has a weaker availability SLO than STANDARD.
	FutureReservation_CAPACITY_OPTIMIZED FutureReservation_ProtectionTier = 17430466
	// Unspecified protection tier.
	FutureReservation_PROTECTION_TIER_UNSPECIFIED FutureReservation_ProtectionTier = 262261984
	// STANDARD protection for workload that should be protected by redundancies (e.g. power, cooling) at the data center level. In the event of infrastructure failures at data center (e.g. power and/or cooling failures), this workload is expected to continue as normal using the redundancies.
	FutureReservation_STANDARD FutureReservation_ProtectionTier = 484642493
)

// Enum value maps for FutureReservation_ProtectionTier.
var (
	FutureReservation_ProtectionTier_name = map[int32]string{
		0:         "UNDEFINED_PROTECTION_TIER",
		17430466:  "CAPACITY_OPTIMIZED",
		262261984: "PROTECTION_TIER_UNSPECIFIED",
		484642493: "STANDARD",
	}
	FutureReservation_ProtectionTier_value = map[string]int32{
		"UNDEFINED_PROTECTION_TIER":   0,
		"CAPACITY_OPTIMIZED":          17430466,
		"PROTECTION_TIER_UNSPECIFIED": 262261984,
		"STANDARD":                    484642493,
	}
)

func (x FutureReservation_ProtectionTier) Enum() *FutureReservation_ProtectionTier {
	p := new(FutureReservation_ProtectionTier)
	*p = x
	return p
}

func (x FutureReservation_ProtectionTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservation_ProtectionTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[93].Descriptor()
}

func (FutureReservation_ProtectionTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[93]
}

func (x FutureReservation_ProtectionTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservation_ProtectionTier.Descriptor instead.
func (FutureReservation_ProtectionTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{399, 2}
}

// The reservation mode which determines reservation-termination behavior and expected pricing.
type FutureReservation_ReservationMode int32

const (
	// A value indicating that the enum field is not set.
	FutureReservation_UNDEFINED_RESERVATION_MODE FutureReservation_ReservationMode = 0
	// The delivered reservations will delivered at specified start time and terminated at specified end time along with terminating the VMs running on it.
	FutureReservation_CALENDAR FutureReservation_ReservationMode = 67431230
	// The delivered reservations do not terminate VMs at the end of reservations. This is default mode.
	FutureReservation_DEFAULT                      FutureReservation_ReservationMode = 115302945
	FutureReservation_RESERVATION_MODE_UNSPECIFIED FutureReservation_ReservationMode = 233810606
)

// Enum value maps for FutureReservation_ReservationMode.
var (
	FutureReservation_ReservationMode_name = map[int32]string{
		0:         "UNDEFINED_RESERVATION_MODE",
		67431230:  "CALENDAR",
		115302945: "DEFAULT",
		233810606: "RESERVATION_MODE_UNSPECIFIED",
	}
	FutureReservation_ReservationMode_value = map[string]int32{
		"UNDEFINED_RESERVATION_MODE":   0,
		"CALENDAR":                     67431230,
		"DEFAULT":                      115302945,
		"RESERVATION_MODE_UNSPECIFIED": 233810606,
	}
)

func (x FutureReservation_ReservationMode) Enum() *FutureReservation_ReservationMode {
	p := new(FutureReservation_ReservationMode)
	*p = x
	return p
}

func (x FutureReservation_ReservationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservation_ReservationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[94].Descriptor()
}

func (FutureReservation_ReservationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[94]
}

func (x FutureReservation_ReservationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservation_ReservationMode.Descriptor instead.
func (FutureReservation_ReservationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{399, 3}
}

// Maintenance information for this reservation
type FutureReservation_SchedulingType int32

const (
	// A value indicating that the enum field is not set.
	FutureReservation_UNDEFINED_SCHEDULING_TYPE FutureReservation_SchedulingType = 0
	// Maintenance on all reserved instances in the reservation is synchronized.
	FutureReservation_GROUPED FutureReservation_SchedulingType = 474540862
	// Unknown maintenance type.
	FutureReservation_GROUP_MAINTENANCE_TYPE_UNSPECIFIED FutureReservation_SchedulingType = 447183678
	// Maintenance is not synchronized for this reservation. Instead, each instance has its own maintenance window.
	FutureReservation_INDEPENDENT FutureReservation_SchedulingType = 127011674
)

// Enum value maps for FutureReservation_SchedulingType.
var (
	FutureReservation_SchedulingType_name = map[int32]string{
		0:         "UNDEFINED_SCHEDULING_TYPE",
		474540862: "GROUPED",
		447183678: "GROUP_MAINTENANCE_TYPE_UNSPECIFIED",
		127011674: "INDEPENDENT",
	}
	FutureReservation_SchedulingType_value = map[string]int32{
		"UNDEFINED_SCHEDULING_TYPE":          0,
		"GROUPED":                            474540862,
		"GROUP_MAINTENANCE_TYPE_UNSPECIFIED": 447183678,
		"INDEPENDENT":                        127011674,
	}
)

func (x FutureReservation_SchedulingType) Enum() *FutureReservation_SchedulingType {
	p := new(FutureReservation_SchedulingType)
	*p = x
	return p
}

func (x FutureReservation_SchedulingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservation_SchedulingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[95].Descriptor()
}

func (FutureReservation_SchedulingType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[95]
}

func (x FutureReservation_SchedulingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservation_SchedulingType.Descriptor instead.
func (FutureReservation_SchedulingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{399, 4}
}

// Indicates if a Commitment needs to be created as part of FR delivery. If this field is not present, then no commitment needs to be created.
type FutureReservationCommitmentInfo_CommitmentPlan int32

const (
	// A value indicating that the enum field is not set.
	FutureReservationCommitmentInfo_UNDEFINED_COMMITMENT_PLAN FutureReservationCommitmentInfo_CommitmentPlan = 0
	FutureReservationCommitmentInfo_INVALID                   FutureReservationCommitmentInfo_CommitmentPlan = 530283991
	FutureReservationCommitmentInfo_THIRTY_SIX_MONTH          FutureReservationCommitmentInfo_CommitmentPlan = 266295942
	FutureReservationCommitmentInfo_TWELVE_MONTH              FutureReservationCommitmentInfo_CommitmentPlan = 173083962
)

// Enum value maps for FutureReservationCommitmentInfo_CommitmentPlan.
var (
	FutureReservationCommitmentInfo_CommitmentPlan_name = map[int32]string{
		0:         "UNDEFINED_COMMITMENT_PLAN",
		530283991: "INVALID",
		266295942: "THIRTY_SIX_MONTH",
		173083962: "TWELVE_MONTH",
	}
	FutureReservationCommitmentInfo_CommitmentPlan_value = map[string]int32{
		"UNDEFINED_COMMITMENT_PLAN": 0,
		"INVALID":                   530283991,
		"THIRTY_SIX_MONTH":          266295942,
		"TWELVE_MONTH":              173083962,
	}
)

func (x FutureReservationCommitmentInfo_CommitmentPlan) Enum() *FutureReservationCommitmentInfo_CommitmentPlan {
	p := new(FutureReservationCommitmentInfo_CommitmentPlan)
	*p = x
	return p
}

func (x FutureReservationCommitmentInfo_CommitmentPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservationCommitmentInfo_CommitmentPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[96].Descriptor()
}

func (FutureReservationCommitmentInfo_CommitmentPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[96]
}

func (x FutureReservationCommitmentInfo_CommitmentPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservationCommitmentInfo_CommitmentPlan.Descriptor instead.
func (FutureReservationCommitmentInfo_CommitmentPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{400, 0}
}

// Only applicable if FR is delivering to the same reservation. If set, all parent commitments will be extended to match the end date of the plan for this commitment.
type FutureReservationCommitmentInfo_PreviousCommitmentTerms int32

const (
	// A value indicating that the enum field is not set.
	FutureReservationCommitmentInfo_UNDEFINED_PREVIOUS_COMMITMENT_TERMS FutureReservationCommitmentInfo_PreviousCommitmentTerms = 0
	// All associated parent Committed Used Discount(s) end-date/term will be extended to the end-time of this future reservation. Default is to extend previous commitment(s) time to the end_time of the reservation.
	FutureReservationCommitmentInfo_EXTEND FutureReservationCommitmentInfo_PreviousCommitmentTerms = 448639770
	// No changes to associated parents Committed Used Discount(s) terms.
	FutureReservationCommitmentInfo_PREVIOUSCOMMITMENTTERM_UNSPECIFIED FutureReservationCommitmentInfo_PreviousCommitmentTerms = 98482448
)

// Enum value maps for FutureReservationCommitmentInfo_PreviousCommitmentTerms.
var (
	FutureReservationCommitmentInfo_PreviousCommitmentTerms_name = map[int32]string{
		0:         "UNDEFINED_PREVIOUS_COMMITMENT_TERMS",
		448639770: "EXTEND",
		98482448:  "PREVIOUSCOMMITMENTTERM_UNSPECIFIED",
	}
	FutureReservationCommitmentInfo_PreviousCommitmentTerms_value = map[string]int32{
		"UNDEFINED_PREVIOUS_COMMITMENT_TERMS": 0,
		"EXTEND":                              448639770,
		"PREVIOUSCOMMITMENTTERM_UNSPECIFIED":  98482448,
	}
)

func (x FutureReservationCommitmentInfo_PreviousCommitmentTerms) Enum() *FutureReservationCommitmentInfo_PreviousCommitmentTerms {
	p := new(FutureReservationCommitmentInfo_PreviousCommitmentTerms)
	*p = x
	return p
}

func (x FutureReservationCommitmentInfo_PreviousCommitmentTerms) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservationCommitmentInfo_PreviousCommitmentTerms) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[97].Descriptor()
}

func (FutureReservationCommitmentInfo_PreviousCommitmentTerms) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[97]
}

func (x FutureReservationCommitmentInfo_PreviousCommitmentTerms) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservationCommitmentInfo_PreviousCommitmentTerms.Descriptor instead.
func (FutureReservationCommitmentInfo_PreviousCommitmentTerms) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{400, 1}
}

// [Output Only] The current status of the requested amendment.
type FutureReservationStatus_AmendmentStatus int32

const (
	// A value indicating that the enum field is not set.
	FutureReservationStatus_UNDEFINED_AMENDMENT_STATUS FutureReservationStatus_AmendmentStatus = 0
	// The requested amendment to the Future Resevation has been approved and applied by GCP.
	FutureReservationStatus_AMENDMENT_APPROVED FutureReservationStatus_AmendmentStatus = 150573001
	// The requested amendment to the Future Reservation has been declined by GCP and the original state was restored.
	FutureReservationStatus_AMENDMENT_DECLINED FutureReservationStatus_AmendmentStatus = 70395200
	// The requested amendment to the Future Reservation is currently being reviewd by GCP.
	FutureReservationStatus_AMENDMENT_IN_REVIEW          FutureReservationStatus_AmendmentStatus = 25830624
	FutureReservationStatus_AMENDMENT_STATUS_UNSPECIFIED FutureReservationStatus_AmendmentStatus = 412250332
)

// Enum value maps for FutureReservationStatus_AmendmentStatus.
var (
	FutureReservationStatus_AmendmentStatus_name = map[int32]string{
		0:         "UNDEFINED_AMENDMENT_STATUS",
		150573001: "AMENDMENT_APPROVED",
		70395200:  "AMENDMENT_DECLINED",
		25830624:  "AMENDMENT_IN_REVIEW",
		412250332: "AMENDMENT_STATUS_UNSPECIFIED",
	}
	FutureReservationStatus_AmendmentStatus_value = map[string]int32{
		"UNDEFINED_AMENDMENT_STATUS":   0,
		"AMENDMENT_APPROVED":           150573001,
		"AMENDMENT_DECLINED":           70395200,
		"AMENDMENT_IN_REVIEW":          25830624,
		"AMENDMENT_STATUS_UNSPECIFIED": 412250332,
	}
)

func (x FutureReservationStatus_AmendmentStatus) Enum() *FutureReservationStatus_AmendmentStatus {
	p := new(FutureReservationStatus_AmendmentStatus)
	*p = x
	return p
}

func (x FutureReservationStatus_AmendmentStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservationStatus_AmendmentStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[98].Descriptor()
}

func (FutureReservationStatus_AmendmentStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[98]
}

func (x FutureReservationStatus_AmendmentStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservationStatus_AmendmentStatus.Descriptor instead.
func (FutureReservationStatus_AmendmentStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{402, 0}
}

// Current state of this Future Reservation
type FutureReservationStatus_ProcurementStatus int32

const (
	// A value indicating that the enum field is not set.
	FutureReservationStatus_UNDEFINED_PROCUREMENT_STATUS FutureReservationStatus_ProcurementStatus = 0
	// Future reservation is approved by GCP.
	FutureReservationStatus_APPROVED FutureReservationStatus_ProcurementStatus = 357258935
	// Future reservation is cancelled by the customer.
	FutureReservationStatus_CANCELLED FutureReservationStatus_ProcurementStatus = 41957681
	// Future reservation is committed by the customer.
	FutureReservationStatus_COMMITTED FutureReservationStatus_ProcurementStatus = 221710172
	// Future reservation is rejected by GCP.
	FutureReservationStatus_DECLINED FutureReservationStatus_ProcurementStatus = 277081134
	// Related status for PlanningStatus.Draft. Transitions to PENDING_APPROVAL upon user submitting FR.
	FutureReservationStatus_DRAFTING FutureReservationStatus_ProcurementStatus = 477863585
	// Future reservation failed. No additional reservations were provided.
	FutureReservationStatus_FAILED FutureReservationStatus_ProcurementStatus = 455706685
	// Future reservation is partially fulfilled. Additional reservations were provided but did not reach total_count reserved instance slots.
	FutureReservationStatus_FAILED_PARTIALLY_FULFILLED FutureReservationStatus_ProcurementStatus = 14455212
	// Future reservation is fulfilled completely.
	FutureReservationStatus_FULFILLED FutureReservationStatus_ProcurementStatus = 409958655
	// An Amendment to the Future Reservation has been requested. If the Amendment is declined, the Future Reservation will be restored to the last known good state.
	FutureReservationStatus_PENDING_AMENDMENT_APPROVAL FutureReservationStatus_ProcurementStatus = 510150429
	// Future reservation is pending approval by GCP.
	FutureReservationStatus_PENDING_APPROVAL               FutureReservationStatus_ProcurementStatus = 209692683
	FutureReservationStatus_PROCUREMENT_STATUS_UNSPECIFIED FutureReservationStatus_ProcurementStatus = 45807705
	// Future reservation is being procured by GCP. Beyond this point, Future reservation is locked and no further modifications are allowed.
	FutureReservationStatus_PROCURING FutureReservationStatus_ProcurementStatus = 95959663
	// Future reservation capacity is being provisioned. This state will be entered after start_time, while reservations are being created to provide total_count reserved instance slots. This state will not persist past start_time + 24h.
	FutureReservationStatus_PROVISIONING FutureReservationStatus_ProcurementStatus = 290896621
)

// Enum value maps for FutureReservationStatus_ProcurementStatus.
var (
	FutureReservationStatus_ProcurementStatus_name = map[int32]string{
		0:         "UNDEFINED_PROCUREMENT_STATUS",
		357258935: "APPROVED",
		41957681:  "CANCELLED",
		221710172: "COMMITTED",
		277081134: "DECLINED",
		477863585: "DRAFTING",
		455706685: "FAILED",
		14455212:  "FAILED_PARTIALLY_FULFILLED",
		409958655: "FULFILLED",
		510150429: "PENDING_AMENDMENT_APPROVAL",
		209692683: "PENDING_APPROVAL",
		45807705:  "PROCUREMENT_STATUS_UNSPECIFIED",
		95959663:  "PROCURING",
		290896621: "PROVISIONING",
	}
	FutureReservationStatus_ProcurementStatus_value = map[string]int32{
		"UNDEFINED_PROCUREMENT_STATUS":   0,
		"APPROVED":                       357258935,
		"CANCELLED":                      41957681,
		"COMMITTED":                      221710172,
		"DECLINED":                       277081134,
		"DRAFTING":                       477863585,
		"FAILED":                         455706685,
		"FAILED_PARTIALLY_FULFILLED":     14455212,
		"FULFILLED":                      409958655,
		"PENDING_AMENDMENT_APPROVAL":     510150429,
		"PENDING_APPROVAL":               209692683,
		"PROCUREMENT_STATUS_UNSPECIFIED": 45807705,
		"PROCURING":                      95959663,
		"PROVISIONING":                   290896621,
	}
)

func (x FutureReservationStatus_ProcurementStatus) Enum() *FutureReservationStatus_ProcurementStatus {
	p := new(FutureReservationStatus_ProcurementStatus)
	*p = x
	return p
}

func (x FutureReservationStatus_ProcurementStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservationStatus_ProcurementStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[99].Descriptor()
}

func (FutureReservationStatus_ProcurementStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[99]
}

func (x FutureReservationStatus_ProcurementStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservationStatus_ProcurementStatus.Descriptor instead.
func (FutureReservationStatus_ProcurementStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{402, 1}
}

// [Output Only] The status of the last known good state for the Future Reservation.
type FutureReservationStatusLastKnownGoodState_ProcurementStatus int32

const (
	// A value indicating that the enum field is not set.
	FutureReservationStatusLastKnownGoodState_UNDEFINED_PROCUREMENT_STATUS FutureReservationStatusLastKnownGoodState_ProcurementStatus = 0
	// Future reservation is approved by GCP.
	FutureReservationStatusLastKnownGoodState_APPROVED FutureReservationStatusLastKnownGoodState_ProcurementStatus = 357258935
	// Future reservation is cancelled by the customer.
	FutureReservationStatusLastKnownGoodState_CANCELLED FutureReservationStatusLastKnownGoodState_ProcurementStatus = 41957681
	// Future reservation is committed by the customer.
	FutureReservationStatusLastKnownGoodState_COMMITTED FutureReservationStatusLastKnownGoodState_ProcurementStatus = 221710172
	// Future reservation is rejected by GCP.
	FutureReservationStatusLastKnownGoodState_DECLINED FutureReservationStatusLastKnownGoodState_ProcurementStatus = 277081134
	// Related status for PlanningStatus.Draft. Transitions to PENDING_APPROVAL upon user submitting FR.
	FutureReservationStatusLastKnownGoodState_DRAFTING FutureReservationStatusLastKnownGoodState_ProcurementStatus = 477863585
	// Future reservation failed. No additional reservations were provided.
	FutureReservationStatusLastKnownGoodState_FAILED FutureReservationStatusLastKnownGoodState_ProcurementStatus = 455706685
	// Future reservation is partially fulfilled. Additional reservations were provided but did not reach total_count reserved instance slots.
	FutureReservationStatusLastKnownGoodState_FAILED_PARTIALLY_FULFILLED FutureReservationStatusLastKnownGoodState_ProcurementStatus = 14455212
	// Future reservation is fulfilled completely.
	FutureReservationStatusLastKnownGoodState_FULFILLED FutureReservationStatusLastKnownGoodState_ProcurementStatus = 409958655
	// An Amendment to the Future Reservation has been requested. If the Amendment is declined, the Future Reservation will be restored to the last known good state.
	FutureReservationStatusLastKnownGoodState_PENDING_AMENDMENT_APPROVAL FutureReservationStatusLastKnownGoodState_ProcurementStatus = 510150429
	// Future reservation is pending approval by GCP.
	FutureReservationStatusLastKnownGoodState_PENDING_APPROVAL               FutureReservationStatusLastKnownGoodState_ProcurementStatus = 209692683
	FutureReservationStatusLastKnownGoodState_PROCUREMENT_STATUS_UNSPECIFIED FutureReservationStatusLastKnownGoodState_ProcurementStatus = 45807705
	// Future reservation is being procured by GCP. Beyond this point, Future reservation is locked and no further modifications are allowed.
	FutureReservationStatusLastKnownGoodState_PROCURING FutureReservationStatusLastKnownGoodState_ProcurementStatus = 95959663
	// Future reservation capacity is being provisioned. This state will be entered after start_time, while reservations are being created to provide total_count reserved instance slots. This state will not persist past start_time + 24h.
	FutureReservationStatusLastKnownGoodState_PROVISIONING FutureReservationStatusLastKnownGoodState_ProcurementStatus = 290896621
)

// Enum value maps for FutureReservationStatusLastKnownGoodState_ProcurementStatus.
var (
	FutureReservationStatusLastKnownGoodState_ProcurementStatus_name = map[int32]string{
		0:         "UNDEFINED_PROCUREMENT_STATUS",
		357258935: "APPROVED",
		41957681:  "CANCELLED",
		221710172: "COMMITTED",
		277081134: "DECLINED",
		477863585: "DRAFTING",
		455706685: "FAILED",
		14455212:  "FAILED_PARTIALLY_FULFILLED",
		409958655: "FULFILLED",
		510150429: "PENDING_AMENDMENT_APPROVAL",
		209692683: "PENDING_APPROVAL",
		45807705:  "PROCUREMENT_STATUS_UNSPECIFIED",
		95959663:  "PROCURING",
		290896621: "PROVISIONING",
	}
	FutureReservationStatusLastKnownGoodState_ProcurementStatus_value = map[string]int32{
		"UNDEFINED_PROCUREMENT_STATUS":   0,
		"APPROVED":                       357258935,
		"CANCELLED":                      41957681,
		"COMMITTED":                      221710172,
		"DECLINED":                       277081134,
		"DRAFTING":                       477863585,
		"FAILED":                         455706685,
		"FAILED_PARTIALLY_FULFILLED":     14455212,
		"FULFILLED":                      409958655,
		"PENDING_AMENDMENT_APPROVAL":     510150429,
		"PENDING_APPROVAL":               209692683,
		"PROCUREMENT_STATUS_UNSPECIFIED": 45807705,
		"PROCURING":                      95959663,
		"PROVISIONING":                   290896621,
	}
)

func (x FutureReservationStatusLastKnownGoodState_ProcurementStatus) Enum() *FutureReservationStatusLastKnownGoodState_ProcurementStatus {
	p := new(FutureReservationStatusLastKnownGoodState_ProcurementStatus)
	*p = x
	return p
}

func (x FutureReservationStatusLastKnownGoodState_ProcurementStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureReservationStatusLastKnownGoodState_ProcurementStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[100].Descriptor()
}

func (FutureReservationStatusLastKnownGoodState_ProcurementStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[100]
}

func (x FutureReservationStatusLastKnownGoodState_ProcurementStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureReservationStatusLastKnownGoodState_ProcurementStatus.Descriptor instead.
func (FutureReservationStatusLastKnownGoodState_ProcurementStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{404, 0}
}

// Type of recommendation. Currently only FUTURE_RESERVATION is supported.
type FutureResourcesRecommendation_RecommendationType int32

const (
	// A value indicating that the enum field is not set.
	FutureResourcesRecommendation_UNDEFINED_RECOMMENDATION_TYPE FutureResourcesRecommendation_RecommendationType = 0
	// A Future Reservation is recommended.
	FutureResourcesRecommendation_FUTURE_RESERVATION FutureResourcesRecommendation_RecommendationType = 41036592
	// Default value, unused.
	FutureResourcesRecommendation_RECOMMENDATION_TYPE_UNSPECIFIED FutureResourcesRecommendation_RecommendationType = 140641624
)

// Enum value maps for FutureResourcesRecommendation_RecommendationType.
var (
	FutureResourcesRecommendation_RecommendationType_name = map[int32]string{
		0:         "UNDEFINED_RECOMMENDATION_TYPE",
		41036592:  "FUTURE_RESERVATION",
		140641624: "RECOMMENDATION_TYPE_UNSPECIFIED",
	}
	FutureResourcesRecommendation_RecommendationType_value = map[string]int32{
		"UNDEFINED_RECOMMENDATION_TYPE":   0,
		"FUTURE_RESERVATION":              41036592,
		"RECOMMENDATION_TYPE_UNSPECIFIED": 140641624,
	}
)

func (x FutureResourcesRecommendation_RecommendationType) Enum() *FutureResourcesRecommendation_RecommendationType {
	p := new(FutureResourcesRecommendation_RecommendationType)
	*p = x
	return p
}

func (x FutureResourcesRecommendation_RecommendationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureResourcesRecommendation_RecommendationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[101].Descriptor()
}

func (FutureResourcesRecommendation_RecommendationType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[101]
}

func (x FutureResourcesRecommendation_RecommendationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureResourcesRecommendation_RecommendationType.Descriptor instead.
func (FutureResourcesRecommendation_RecommendationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{411, 0}
}

// Status of recommendation in this location.
type FutureResourcesRecommendationOtherLocation_Status int32

const (
	// A value indicating that the enum field is not set.
	FutureResourcesRecommendationOtherLocation_UNDEFINED_STATUS FutureResourcesRecommendationOtherLocation_Status = 0
	// The requested resources are offered in this location but the requested time window is does not meet the required conditions.
	FutureResourcesRecommendationOtherLocation_CONDITIONS_NOT_MET FutureResourcesRecommendationOtherLocation_Status = 363628457
	// The requested resources are not offered in this location. Retrying the request will not change this status.
	FutureResourcesRecommendationOtherLocation_NOT_SUPPORTED FutureResourcesRecommendationOtherLocation_Status = 317950466
	// The requested resources are offered in this location and the requested time window is accepted but there is no capacity within the requested time window.
	FutureResourcesRecommendationOtherLocation_NO_CAPACITY FutureResourcesRecommendationOtherLocation_Status = 274240888
	// Default value, unused.
	FutureResourcesRecommendationOtherLocation_OTHER_LOCATION_STATUS_UNDEFINED FutureResourcesRecommendationOtherLocation_Status = 222662622
	// The requested resources are offered in this location and it is possible to request them. However, another location was better and was recommended.
	FutureResourcesRecommendationOtherLocation_RECOMMENDED FutureResourcesRecommendationOtherLocation_Status = 369652283
)

// Enum value maps for FutureResourcesRecommendationOtherLocation_Status.
var (
	FutureResourcesRecommendationOtherLocation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		363628457: "CONDITIONS_NOT_MET",
		317950466: "NOT_SUPPORTED",
		274240888: "NO_CAPACITY",
		222662622: "OTHER_LOCATION_STATUS_UNDEFINED",
		369652283: "RECOMMENDED",
	}
	FutureResourcesRecommendationOtherLocation_Status_value = map[string]int32{
		"UNDEFINED_STATUS":                0,
		"CONDITIONS_NOT_MET":              363628457,
		"NOT_SUPPORTED":                   317950466,
		"NO_CAPACITY":                     274240888,
		"OTHER_LOCATION_STATUS_UNDEFINED": 222662622,
		"RECOMMENDED":                     369652283,
	}
)

func (x FutureResourcesRecommendationOtherLocation_Status) Enum() *FutureResourcesRecommendationOtherLocation_Status {
	p := new(FutureResourcesRecommendationOtherLocation_Status)
	*p = x
	return p
}

func (x FutureResourcesRecommendationOtherLocation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureResourcesRecommendationOtherLocation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[102].Descriptor()
}

func (FutureResourcesRecommendationOtherLocation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[102]
}

func (x FutureResourcesRecommendationOtherLocation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureResourcesRecommendationOtherLocation_Status.Descriptor instead.
func (FutureResourcesRecommendationOtherLocation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{412, 0}
}

// Indicates if the reservation allocation strategy is static (DENSE) or dynamic (STANDARD). Defaults to DENSE.
type FutureResourcesSpec_DeploymentType int32

const (
	// A value indicating that the enum field is not set.
	FutureResourcesSpec_UNDEFINED_DEPLOYMENT_TYPE FutureResourcesSpec_DeploymentType = 0
	// The reserved capacity is made up of densely deployed reservation blocks.
	FutureResourcesSpec_DENSE                       FutureResourcesSpec_DeploymentType = 64932607
	FutureResourcesSpec_DEPLOYMENT_TYPE_UNSPECIFIED FutureResourcesSpec_DeploymentType = 234847180
	// The reserved capacity is made up of highly flexible, logical reservation blocks.
	FutureResourcesSpec_FLEXIBLE FutureResourcesSpec_DeploymentType = 379880395
)

// Enum value maps for FutureResourcesSpec_DeploymentType.
var (
	FutureResourcesSpec_DeploymentType_name = map[int32]string{
		0:         "UNDEFINED_DEPLOYMENT_TYPE",
		64932607:  "DENSE",
		234847180: "DEPLOYMENT_TYPE_UNSPECIFIED",
		379880395: "FLEXIBLE",
	}
	FutureResourcesSpec_DeploymentType_value = map[string]int32{
		"UNDEFINED_DEPLOYMENT_TYPE":   0,
		"DENSE":                       64932607,
		"DEPLOYMENT_TYPE_UNSPECIFIED": 234847180,
		"FLEXIBLE":                    379880395,
	}
)

func (x FutureResourcesSpec_DeploymentType) Enum() *FutureResourcesSpec_DeploymentType {
	p := new(FutureResourcesSpec_DeploymentType)
	*p = x
	return p
}

func (x FutureResourcesSpec_DeploymentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureResourcesSpec_DeploymentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[103].Descriptor()
}

func (FutureResourcesSpec_DeploymentType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[103]
}

func (x FutureResourcesSpec_DeploymentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureResourcesSpec_DeploymentType.Descriptor instead.
func (FutureResourcesSpec_DeploymentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{413, 0}
}

// The VM family that all instances scheduled against this reservation must belong to. Use for TPU reservations.
type FutureResourcesSpecAggregateResources_VmFamily int32

const (
	// A value indicating that the enum field is not set.
	FutureResourcesSpecAggregateResources_UNDEFINED_VM_FAMILY                      FutureResourcesSpecAggregateResources_VmFamily = 0
	FutureResourcesSpecAggregateResources_VM_FAMILY_CLOUD_TPU_DEVICE_CT3           FutureResourcesSpecAggregateResources_VmFamily = 42845948
	FutureResourcesSpecAggregateResources_VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L     FutureResourcesSpecAggregateResources_VmFamily = 108020067
	FutureResourcesSpecAggregateResources_VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP FutureResourcesSpecAggregateResources_VmFamily = 18705267
	FutureResourcesSpecAggregateResources_VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E  FutureResourcesSpecAggregateResources_VmFamily = 398926997
	FutureResourcesSpecAggregateResources_VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P       FutureResourcesSpecAggregateResources_VmFamily = 517384376
	FutureResourcesSpecAggregateResources_VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P       FutureResourcesSpecAggregateResources_VmFamily = 517384407
	FutureResourcesSpecAggregateResources_VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P       FutureResourcesSpecAggregateResources_VmFamily = 517384438
)

// Enum value maps for FutureResourcesSpecAggregateResources_VmFamily.
var (
	FutureResourcesSpecAggregateResources_VmFamily_name = map[int32]string{
		0:         "UNDEFINED_VM_FAMILY",
		42845948:  "VM_FAMILY_CLOUD_TPU_DEVICE_CT3",
		108020067: "VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L",
		18705267:  "VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP",
		398926997: "VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E",
		517384376: "VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P",
		517384407: "VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P",
		517384438: "VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P",
	}
	FutureResourcesSpecAggregateResources_VmFamily_value = map[string]int32{
		"UNDEFINED_VM_FAMILY":                      0,
		"VM_FAMILY_CLOUD_TPU_DEVICE_CT3":           42845948,
		"VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L":     108020067,
		"VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP": 18705267,
		"VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E":  398926997,
		"VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P":       517384376,
		"VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P":       517384407,
		"VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P":       517384438,
	}
)

func (x FutureResourcesSpecAggregateResources_VmFamily) Enum() *FutureResourcesSpecAggregateResources_VmFamily {
	p := new(FutureResourcesSpecAggregateResources_VmFamily)
	*p = x
	return p
}

func (x FutureResourcesSpecAggregateResources_VmFamily) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureResourcesSpecAggregateResources_VmFamily) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[104].Descriptor()
}

func (FutureResourcesSpecAggregateResources_VmFamily) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[104]
}

func (x FutureResourcesSpecAggregateResources_VmFamily) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureResourcesSpecAggregateResources_VmFamily.Descriptor instead.
func (FutureResourcesSpecAggregateResources_VmFamily) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{414, 0}
}

// Workload type. Use for TPU reservations.
type FutureResourcesSpecAggregateResources_WorkloadType int32

const (
	// A value indicating that the enum field is not set.
	FutureResourcesSpecAggregateResources_UNDEFINED_WORKLOAD_TYPE FutureResourcesSpecAggregateResources_WorkloadType = 0
	// Reserved resources will be optimized for BATCH workloads, such as ML training.
	FutureResourcesSpecAggregateResources_BATCH FutureResourcesSpecAggregateResources_WorkloadType = 62971674
	// Reserved resources will be optimized for SERVING workloads, such as ML inference.
	FutureResourcesSpecAggregateResources_SERVING     FutureResourcesSpecAggregateResources_WorkloadType = 17781740
	FutureResourcesSpecAggregateResources_UNSPECIFIED FutureResourcesSpecAggregateResources_WorkloadType = 526786327
)

// Enum value maps for FutureResourcesSpecAggregateResources_WorkloadType.
var (
	FutureResourcesSpecAggregateResources_WorkloadType_name = map[int32]string{
		0:         "UNDEFINED_WORKLOAD_TYPE",
		62971674:  "BATCH",
		17781740:  "SERVING",
		526786327: "UNSPECIFIED",
	}
	FutureResourcesSpecAggregateResources_WorkloadType_value = map[string]int32{
		"UNDEFINED_WORKLOAD_TYPE": 0,
		"BATCH":                   62971674,
		"SERVING":                 17781740,
		"UNSPECIFIED":             526786327,
	}
)

func (x FutureResourcesSpecAggregateResources_WorkloadType) Enum() *FutureResourcesSpecAggregateResources_WorkloadType {
	p := new(FutureResourcesSpecAggregateResources_WorkloadType)
	*p = x
	return p
}

func (x FutureResourcesSpecAggregateResources_WorkloadType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureResourcesSpecAggregateResources_WorkloadType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[105].Descriptor()
}

func (FutureResourcesSpecAggregateResources_WorkloadType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[105]
}

func (x FutureResourcesSpecAggregateResources_WorkloadType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureResourcesSpecAggregateResources_WorkloadType.Descriptor instead.
func (FutureResourcesSpecAggregateResources_WorkloadType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{414, 1}
}

// Disk interface. Defaults to SCSI.
type FutureResourcesSpecLocalSsdPartition_DiskInterface int32

const (
	// A value indicating that the enum field is not set.
	FutureResourcesSpecLocalSsdPartition_UNDEFINED_DISK_INTERFACE FutureResourcesSpecLocalSsdPartition_DiskInterface = 0
	FutureResourcesSpecLocalSsdPartition_NVME                     FutureResourcesSpecLocalSsdPartition_DiskInterface = 2408800
	FutureResourcesSpecLocalSsdPartition_SCSI                     FutureResourcesSpecLocalSsdPartition_DiskInterface = 2539686
)

// Enum value maps for FutureResourcesSpecLocalSsdPartition_DiskInterface.
var (
	FutureResourcesSpecLocalSsdPartition_DiskInterface_name = map[int32]string{
		0:       "UNDEFINED_DISK_INTERFACE",
		2408800: "NVME",
		2539686: "SCSI",
	}
	FutureResourcesSpecLocalSsdPartition_DiskInterface_value = map[string]int32{
		"UNDEFINED_DISK_INTERFACE": 0,
		"NVME":                     2408800,
		"SCSI":                     2539686,
	}
)

func (x FutureResourcesSpecLocalSsdPartition_DiskInterface) Enum() *FutureResourcesSpecLocalSsdPartition_DiskInterface {
	p := new(FutureResourcesSpecLocalSsdPartition_DiskInterface)
	*p = x
	return p
}

func (x FutureResourcesSpecLocalSsdPartition_DiskInterface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureResourcesSpecLocalSsdPartition_DiskInterface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[106].Descriptor()
}

func (FutureResourcesSpecLocalSsdPartition_DiskInterface) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[106]
}

func (x FutureResourcesSpecLocalSsdPartition_DiskInterface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureResourcesSpecLocalSsdPartition_DiskInterface.Descriptor instead.
func (FutureResourcesSpecLocalSsdPartition_DiskInterface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{415, 0}
}

// Preference for this location.
type FutureResourcesSpecLocationPolicyLocation_Preference int32

const (
	// A value indicating that the enum field is not set.
	FutureResourcesSpecLocationPolicyLocation_UNDEFINED_PREFERENCE FutureResourcesSpecLocationPolicyLocation_Preference = 0
	// Location is allowed for use.
	FutureResourcesSpecLocationPolicyLocation_ALLOW FutureResourcesSpecLocationPolicyLocation_Preference = 62368553
	// Location is prohibited.
	FutureResourcesSpecLocationPolicyLocation_DENY FutureResourcesSpecLocationPolicyLocation_Preference = 2094604
	// Default value, unused.
	FutureResourcesSpecLocationPolicyLocation_PREFERENCE_UNSPECIFIED FutureResourcesSpecLocationPolicyLocation_Preference = 496219571
)

// Enum value maps for FutureResourcesSpecLocationPolicyLocation_Preference.
var (
	FutureResourcesSpecLocationPolicyLocation_Preference_name = map[int32]string{
		0:         "UNDEFINED_PREFERENCE",
		62368553:  "ALLOW",
		2094604:   "DENY",
		496219571: "PREFERENCE_UNSPECIFIED",
	}
	FutureResourcesSpecLocationPolicyLocation_Preference_value = map[string]int32{
		"UNDEFINED_PREFERENCE":   0,
		"ALLOW":                  62368553,
		"DENY":                   2094604,
		"PREFERENCE_UNSPECIFIED": 496219571,
	}
)

func (x FutureResourcesSpecLocationPolicyLocation_Preference) Enum() *FutureResourcesSpecLocationPolicyLocation_Preference {
	p := new(FutureResourcesSpecLocationPolicyLocation_Preference)
	*p = x
	return p
}

func (x FutureResourcesSpecLocationPolicyLocation_Preference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FutureResourcesSpecLocationPolicyLocation_Preference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[107].Descriptor()
}

func (FutureResourcesSpecLocationPolicyLocation_Preference) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[107]
}

func (x FutureResourcesSpecLocationPolicyLocation_Preference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FutureResourcesSpecLocationPolicyLocation_Preference.Descriptor instead.
func (FutureResourcesSpecLocationPolicyLocation_Preference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{417, 0}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type GRPCHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	GRPCHealthCheck_UNDEFINED_PORT_SPECIFICATION GRPCHealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	GRPCHealthCheck_USE_FIXED_PORT GRPCHealthCheck_PortSpecification = 190235748
	// Not supported.
	GRPCHealthCheck_USE_NAMED_PORT GRPCHealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	GRPCHealthCheck_USE_SERVING_PORT GRPCHealthCheck_PortSpecification = 362637516
)

// Enum value maps for GRPCHealthCheck_PortSpecification.
var (
	GRPCHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	GRPCHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x GRPCHealthCheck_PortSpecification) Enum() *GRPCHealthCheck_PortSpecification {
	p := new(GRPCHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x GRPCHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GRPCHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[108].Descriptor()
}

func (GRPCHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[108]
}

func (x GRPCHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GRPCHealthCheck_PortSpecification.Descriptor instead.
func (GRPCHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{420, 0}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type GRPCTLSHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	GRPCTLSHealthCheck_UNDEFINED_PORT_SPECIFICATION GRPCTLSHealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	GRPCTLSHealthCheck_USE_FIXED_PORT GRPCTLSHealthCheck_PortSpecification = 190235748
	// Not supported.
	GRPCTLSHealthCheck_USE_NAMED_PORT GRPCTLSHealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	GRPCTLSHealthCheck_USE_SERVING_PORT GRPCTLSHealthCheck_PortSpecification = 362637516
)

// Enum value maps for GRPCTLSHealthCheck_PortSpecification.
var (
	GRPCTLSHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	GRPCTLSHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x GRPCTLSHealthCheck_PortSpecification) Enum() *GRPCTLSHealthCheck_PortSpecification {
	p := new(GRPCTLSHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x GRPCTLSHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GRPCTLSHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[109].Descriptor()
}

func (GRPCTLSHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[109]
}

func (x GRPCTLSHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GRPCTLSHealthCheck_PortSpecification.Descriptor instead.
func (GRPCTLSHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{421, 0}
}

// View of the instance.
type GetInstanceRequest_View int32

const (
	// A value indicating that the enum field is not set.
	GetInstanceRequest_UNDEFINED_VIEW GetInstanceRequest_View = 0
	// Include everything except Partner Metadata.
	GetInstanceRequest_BASIC GetInstanceRequest_View = 62970894
	// Include everything.
	GetInstanceRequest_FULL GetInstanceRequest_View = 2169487
	// The default / unset value. The API will default to the BASIC view.
	GetInstanceRequest_INSTANCE_VIEW_UNSPECIFIED GetInstanceRequest_View = 8444647
)

// Enum value maps for GetInstanceRequest_View.
var (
	GetInstanceRequest_View_name = map[int32]string{
		0:        "UNDEFINED_VIEW",
		62970894: "BASIC",
		2169487:  "FULL",
		8444647:  "INSTANCE_VIEW_UNSPECIFIED",
	}
	GetInstanceRequest_View_value = map[string]int32{
		"UNDEFINED_VIEW":            0,
		"BASIC":                     62970894,
		"FULL":                      2169487,
		"INSTANCE_VIEW_UNSPECIFIED": 8444647,
	}
)

func (x GetInstanceRequest_View) Enum() *GetInstanceRequest_View {
	p := new(GetInstanceRequest_View)
	*p = x
	return p
}

func (x GetInstanceRequest_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetInstanceRequest_View) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[110].Descriptor()
}

func (GetInstanceRequest_View) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[110]
}

func (x GetInstanceRequest_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetInstanceRequest_View.Descriptor instead.
func (GetInstanceRequest_View) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{490, 0}
}

// View of the instance template.
type GetInstanceTemplateRequest_View int32

const (
	// A value indicating that the enum field is not set.
	GetInstanceTemplateRequest_UNDEFINED_VIEW GetInstanceTemplateRequest_View = 0
	// Include everything except Partner Metadata.
	GetInstanceTemplateRequest_BASIC GetInstanceTemplateRequest_View = 62970894
	// Include everything.
	GetInstanceTemplateRequest_FULL GetInstanceTemplateRequest_View = 2169487
	// The default / unset value. The API will default to the BASIC view.
	GetInstanceTemplateRequest_INSTANCE_VIEW_UNSPECIFIED GetInstanceTemplateRequest_View = 8444647
)

// Enum value maps for GetInstanceTemplateRequest_View.
var (
	GetInstanceTemplateRequest_View_name = map[int32]string{
		0:        "UNDEFINED_VIEW",
		62970894: "BASIC",
		2169487:  "FULL",
		8444647:  "INSTANCE_VIEW_UNSPECIFIED",
	}
	GetInstanceTemplateRequest_View_value = map[string]int32{
		"UNDEFINED_VIEW":            0,
		"BASIC":                     62970894,
		"FULL":                      2169487,
		"INSTANCE_VIEW_UNSPECIFIED": 8444647,
	}
)

func (x GetInstanceTemplateRequest_View) Enum() *GetInstanceTemplateRequest_View {
	p := new(GetInstanceTemplateRequest_View)
	*p = x
	return p
}

func (x GetInstanceTemplateRequest_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetInstanceTemplateRequest_View) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[111].Descriptor()
}

func (GetInstanceTemplateRequest_View) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[111]
}

func (x GetInstanceTemplateRequest_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetInstanceTemplateRequest_View.Descriptor instead.
func (GetInstanceTemplateRequest_View) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{492, 0}
}

// View of the instance template.
type GetRegionInstanceTemplateRequest_View int32

const (
	// A value indicating that the enum field is not set.
	GetRegionInstanceTemplateRequest_UNDEFINED_VIEW GetRegionInstanceTemplateRequest_View = 0
	// Include everything except Partner Metadata.
	GetRegionInstanceTemplateRequest_BASIC GetRegionInstanceTemplateRequest_View = 62970894
	// Include everything.
	GetRegionInstanceTemplateRequest_FULL GetRegionInstanceTemplateRequest_View = 2169487
	// The default / unset value. The API will default to the BASIC view.
	GetRegionInstanceTemplateRequest_INSTANCE_VIEW_UNSPECIFIED GetRegionInstanceTemplateRequest_View = 8444647
)

// Enum value maps for GetRegionInstanceTemplateRequest_View.
var (
	GetRegionInstanceTemplateRequest_View_name = map[int32]string{
		0:        "UNDEFINED_VIEW",
		62970894: "BASIC",
		2169487:  "FULL",
		8444647:  "INSTANCE_VIEW_UNSPECIFIED",
	}
	GetRegionInstanceTemplateRequest_View_value = map[string]int32{
		"UNDEFINED_VIEW":            0,
		"BASIC":                     62970894,
		"FULL":                      2169487,
		"INSTANCE_VIEW_UNSPECIFIED": 8444647,
	}
)

func (x GetRegionInstanceTemplateRequest_View) Enum() *GetRegionInstanceTemplateRequest_View {
	p := new(GetRegionInstanceTemplateRequest_View)
	*p = x
	return p
}

func (x GetRegionInstanceTemplateRequest_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetRegionInstanceTemplateRequest_View) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[112].Descriptor()
}

func (GetRegionInstanceTemplateRequest_View) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[112]
}

func (x GetRegionInstanceTemplateRequest_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetRegionInstanceTemplateRequest_View.Descriptor instead.
func (GetRegionInstanceTemplateRequest_View) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{539, 0}
}

// View of the Block.
type GetReservationBlockRequest_View int32

const (
	// A value indicating that the enum field is not set.
	GetReservationBlockRequest_UNDEFINED_VIEW GetReservationBlockRequest_View = 0
	// This view includes basic information about the reservation block
	GetReservationBlockRequest_BASIC GetReservationBlockRequest_View = 62970894
	// The default / unset value. The API will default to the BASIC view.
	GetReservationBlockRequest_BLOCK_VIEW_UNSPECIFIED GetReservationBlockRequest_View = 275070479
	// Includes detailed topology view.
	GetReservationBlockRequest_FULL GetReservationBlockRequest_View = 2169487
)

// Enum value maps for GetReservationBlockRequest_View.
var (
	GetReservationBlockRequest_View_name = map[int32]string{
		0:         "UNDEFINED_VIEW",
		62970894:  "BASIC",
		275070479: "BLOCK_VIEW_UNSPECIFIED",
		2169487:   "FULL",
	}
	GetReservationBlockRequest_View_value = map[string]int32{
		"UNDEFINED_VIEW":         0,
		"BASIC":                  62970894,
		"BLOCK_VIEW_UNSPECIFIED": 275070479,
		"FULL":                   2169487,
	}
)

func (x GetReservationBlockRequest_View) Enum() *GetReservationBlockRequest_View {
	p := new(GetReservationBlockRequest_View)
	*p = x
	return p
}

func (x GetReservationBlockRequest_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetReservationBlockRequest_View) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[113].Descriptor()
}

func (GetReservationBlockRequest_View) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[113]
}

func (x GetReservationBlockRequest_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetReservationBlockRequest_View.Descriptor instead.
func (GetReservationBlockRequest_View) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{557, 0}
}

// Defines the extra views returned back in the subnetwork resource. Supported values: - WITH_UTILIZATION: Utilization data is included in the response.
type GetSubnetworkRequest_Views int32

const (
	// A value indicating that the enum field is not set.
	GetSubnetworkRequest_UNDEFINED_VIEWS GetSubnetworkRequest_Views = 0
	GetSubnetworkRequest_DEFAULT         GetSubnetworkRequest_Views = 115302945
	// Utilization data is included in the response.
	GetSubnetworkRequest_WITH_UTILIZATION GetSubnetworkRequest_Views = 504090633
)

// Enum value maps for GetSubnetworkRequest_Views.
var (
	GetSubnetworkRequest_Views_name = map[int32]string{
		0:         "UNDEFINED_VIEWS",
		115302945: "DEFAULT",
		504090633: "WITH_UTILIZATION",
	}
	GetSubnetworkRequest_Views_value = map[string]int32{
		"UNDEFINED_VIEWS":  0,
		"DEFAULT":          115302945,
		"WITH_UTILIZATION": 504090633,
	}
)

func (x GetSubnetworkRequest_Views) Enum() *GetSubnetworkRequest_Views {
	p := new(GetSubnetworkRequest_Views)
	*p = x
	return p
}

func (x GetSubnetworkRequest_Views) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetSubnetworkRequest_Views) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[114].Descriptor()
}

func (GetSubnetworkRequest_Views) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[114]
}

func (x GetSubnetworkRequest_Views) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetSubnetworkRequest_Views.Descriptor instead.
func (GetSubnetworkRequest_Views) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{584, 0}
}

// The type of maintenance for the reservation.
type GroupMaintenanceInfo_SchedulingType int32

const (
	// A value indicating that the enum field is not set.
	GroupMaintenanceInfo_UNDEFINED_SCHEDULING_TYPE GroupMaintenanceInfo_SchedulingType = 0
	// Maintenance on all reserved instances in the reservation is synchronized.
	GroupMaintenanceInfo_GROUPED GroupMaintenanceInfo_SchedulingType = 474540862
	// Unknown maintenance type.
	GroupMaintenanceInfo_GROUP_MAINTENANCE_TYPE_UNSPECIFIED GroupMaintenanceInfo_SchedulingType = 447183678
	// Maintenance is not synchronized for this reservation. Instead, each instance has its own maintenance window.
	GroupMaintenanceInfo_INDEPENDENT GroupMaintenanceInfo_SchedulingType = 127011674
)

// Enum value maps for GroupMaintenanceInfo_SchedulingType.
var (
	GroupMaintenanceInfo_SchedulingType_name = map[int32]string{
		0:         "UNDEFINED_SCHEDULING_TYPE",
		474540862: "GROUPED",
		447183678: "GROUP_MAINTENANCE_TYPE_UNSPECIFIED",
		127011674: "INDEPENDENT",
	}
	GroupMaintenanceInfo_SchedulingType_value = map[string]int32{
		"UNDEFINED_SCHEDULING_TYPE":          0,
		"GROUPED":                            474540862,
		"GROUP_MAINTENANCE_TYPE_UNSPECIFIED": 447183678,
		"INDEPENDENT":                        127011674,
	}
)

func (x GroupMaintenanceInfo_SchedulingType) Enum() *GroupMaintenanceInfo_SchedulingType {
	p := new(GroupMaintenanceInfo_SchedulingType)
	*p = x
	return p
}

func (x GroupMaintenanceInfo_SchedulingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GroupMaintenanceInfo_SchedulingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[115].Descriptor()
}

func (GroupMaintenanceInfo_SchedulingType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[115]
}

func (x GroupMaintenanceInfo_SchedulingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GroupMaintenanceInfo_SchedulingType.Descriptor instead.
func (GroupMaintenanceInfo_SchedulingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{608, 0}
}

// The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE - SEV_LIVE_MIGRATABLE_V2 - SEV_SNP_CAPABLE - TDX_CAPABLE - IDPF - SNP_SVSM_CAPABLE For more information, see Enabling guest operating system features.
type GuestOsFeature_Type int32

const (
	// A value indicating that the enum field is not set.
	GuestOsFeature_UNDEFINED_TYPE              GuestOsFeature_Type = 0
	GuestOsFeature_BARE_METAL_LINUX_COMPATIBLE GuestOsFeature_Type = 354232740
	GuestOsFeature_FEATURE_TYPE_UNSPECIFIED    GuestOsFeature_Type = 531767259
	GuestOsFeature_GVNIC                       GuestOsFeature_Type = 68209305
	GuestOsFeature_IDPF                        GuestOsFeature_Type = 2242641
	GuestOsFeature_MULTI_IP_SUBNET             GuestOsFeature_Type = 151776719
	GuestOsFeature_SECURE_BOOT                 GuestOsFeature_Type = 376811194
	GuestOsFeature_SEV_CAPABLE                 GuestOsFeature_Type = 87083793
	GuestOsFeature_SEV_LIVE_MIGRATABLE         GuestOsFeature_Type = 392039820
	GuestOsFeature_SEV_LIVE_MIGRATABLE_V2      GuestOsFeature_Type = 168551983
	GuestOsFeature_SEV_SNP_CAPABLE             GuestOsFeature_Type = 426919
	GuestOsFeature_SNP_SVSM_CAPABLE            GuestOsFeature_Type = 52921460
	GuestOsFeature_TDX_CAPABLE                 GuestOsFeature_Type = 240446133
	GuestOsFeature_UEFI_COMPATIBLE             GuestOsFeature_Type = 195865408
	GuestOsFeature_VIRTIO_SCSI_MULTIQUEUE      GuestOsFeature_Type = 201597069
	GuestOsFeature_WINDOWS                     GuestOsFeature_Type = 456863331
)

// Enum value maps for GuestOsFeature_Type.
var (
	GuestOsFeature_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		354232740: "BARE_METAL_LINUX_COMPATIBLE",
		531767259: "FEATURE_TYPE_UNSPECIFIED",
		68209305:  "GVNIC",
		2242641:   "IDPF",
		151776719: "MULTI_IP_SUBNET",
		376811194: "SECURE_BOOT",
		87083793:  "SEV_CAPABLE",
		392039820: "SEV_LIVE_MIGRATABLE",
		168551983: "SEV_LIVE_MIGRATABLE_V2",
		426919:    "SEV_SNP_CAPABLE",
		52921460:  "SNP_SVSM_CAPABLE",
		240446133: "TDX_CAPABLE",
		195865408: "UEFI_COMPATIBLE",
		201597069: "VIRTIO_SCSI_MULTIQUEUE",
		456863331: "WINDOWS",
	}
	GuestOsFeature_Type_value = map[string]int32{
		"UNDEFINED_TYPE":              0,
		"BARE_METAL_LINUX_COMPATIBLE": 354232740,
		"FEATURE_TYPE_UNSPECIFIED":    531767259,
		"GVNIC":                       68209305,
		"IDPF":                        2242641,
		"MULTI_IP_SUBNET":             151776719,
		"SECURE_BOOT":                 376811194,
		"SEV_CAPABLE":                 87083793,
		"SEV_LIVE_MIGRATABLE":         392039820,
		"SEV_LIVE_MIGRATABLE_V2":      168551983,
		"SEV_SNP_CAPABLE":             426919,
		"SNP_SVSM_CAPABLE":            52921460,
		"TDX_CAPABLE":                 240446133,
		"UEFI_COMPATIBLE":             195865408,
		"VIRTIO_SCSI_MULTIQUEUE":      201597069,
		"WINDOWS":                     456863331,
	}
)

func (x GuestOsFeature_Type) Enum() *GuestOsFeature_Type {
	p := new(GuestOsFeature_Type)
	*p = x
	return p
}

func (x GuestOsFeature_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GuestOsFeature_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[116].Descriptor()
}

func (GuestOsFeature_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[116]
}

func (x GuestOsFeature_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GuestOsFeature_Type.Descriptor instead.
func (GuestOsFeature_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{612, 0}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type HTTP2HealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	HTTP2HealthCheck_UNDEFINED_PORT_SPECIFICATION HTTP2HealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	HTTP2HealthCheck_USE_FIXED_PORT HTTP2HealthCheck_PortSpecification = 190235748
	// Not supported.
	HTTP2HealthCheck_USE_NAMED_PORT HTTP2HealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	HTTP2HealthCheck_USE_SERVING_PORT HTTP2HealthCheck_PortSpecification = 362637516
)

// Enum value maps for HTTP2HealthCheck_PortSpecification.
var (
	HTTP2HealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	HTTP2HealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x HTTP2HealthCheck_PortSpecification) Enum() *HTTP2HealthCheck_PortSpecification {
	p := new(HTTP2HealthCheck_PortSpecification)
	*p = x
	return p
}

func (x HTTP2HealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTP2HealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[117].Descriptor()
}

func (HTTP2HealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[117]
}

func (x HTTP2HealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTP2HealthCheck_PortSpecification.Descriptor instead.
func (HTTP2HealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{613, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type HTTP2HealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	HTTP2HealthCheck_UNDEFINED_PROXY_HEADER HTTP2HealthCheck_ProxyHeader = 0
	HTTP2HealthCheck_NONE                   HTTP2HealthCheck_ProxyHeader = 2402104
	HTTP2HealthCheck_PROXY_V1               HTTP2HealthCheck_ProxyHeader = 334352940
)

// Enum value maps for HTTP2HealthCheck_ProxyHeader.
var (
	HTTP2HealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	HTTP2HealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x HTTP2HealthCheck_ProxyHeader) Enum() *HTTP2HealthCheck_ProxyHeader {
	p := new(HTTP2HealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x HTTP2HealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTP2HealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[118].Descriptor()
}

func (HTTP2HealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[118]
}

func (x HTTP2HealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTP2HealthCheck_ProxyHeader.Descriptor instead.
func (HTTP2HealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{613, 1}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Also supported in legacy HTTP health checks for target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type HTTPHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	HTTPHealthCheck_UNDEFINED_PORT_SPECIFICATION HTTPHealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	HTTPHealthCheck_USE_FIXED_PORT HTTPHealthCheck_PortSpecification = 190235748
	// Not supported.
	HTTPHealthCheck_USE_NAMED_PORT HTTPHealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	HTTPHealthCheck_USE_SERVING_PORT HTTPHealthCheck_PortSpecification = 362637516
)

// Enum value maps for HTTPHealthCheck_PortSpecification.
var (
	HTTPHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	HTTPHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x HTTPHealthCheck_PortSpecification) Enum() *HTTPHealthCheck_PortSpecification {
	p := new(HTTPHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x HTTPHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[119].Descriptor()
}

func (HTTPHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[119]
}

func (x HTTPHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPHealthCheck_PortSpecification.Descriptor instead.
func (HTTPHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{614, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type HTTPHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	HTTPHealthCheck_UNDEFINED_PROXY_HEADER HTTPHealthCheck_ProxyHeader = 0
	HTTPHealthCheck_NONE                   HTTPHealthCheck_ProxyHeader = 2402104
	HTTPHealthCheck_PROXY_V1               HTTPHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for HTTPHealthCheck_ProxyHeader.
var (
	HTTPHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	HTTPHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x HTTPHealthCheck_ProxyHeader) Enum() *HTTPHealthCheck_ProxyHeader {
	p := new(HTTPHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x HTTPHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[120].Descriptor()
}

func (HTTPHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[120]
}

func (x HTTPHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPHealthCheck_ProxyHeader.Descriptor instead.
func (HTTPHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{614, 1}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for passthrough load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for passthrough load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type HTTPSHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	HTTPSHealthCheck_UNDEFINED_PORT_SPECIFICATION HTTPSHealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	HTTPSHealthCheck_USE_FIXED_PORT HTTPSHealthCheck_PortSpecification = 190235748
	// Not supported.
	HTTPSHealthCheck_USE_NAMED_PORT HTTPSHealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	HTTPSHealthCheck_USE_SERVING_PORT HTTPSHealthCheck_PortSpecification = 362637516
)

// Enum value maps for HTTPSHealthCheck_PortSpecification.
var (
	HTTPSHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	HTTPSHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x HTTPSHealthCheck_PortSpecification) Enum() *HTTPSHealthCheck_PortSpecification {
	p := new(HTTPSHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x HTTPSHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPSHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[121].Descriptor()
}

func (HTTPSHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[121]
}

func (x HTTPSHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPSHealthCheck_PortSpecification.Descriptor instead.
func (HTTPSHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{615, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type HTTPSHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	HTTPSHealthCheck_UNDEFINED_PROXY_HEADER HTTPSHealthCheck_ProxyHeader = 0
	HTTPSHealthCheck_NONE                   HTTPSHealthCheck_ProxyHeader = 2402104
	HTTPSHealthCheck_PROXY_V1               HTTPSHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for HTTPSHealthCheck_ProxyHeader.
var (
	HTTPSHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	HTTPSHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x HTTPSHealthCheck_ProxyHeader) Enum() *HTTPSHealthCheck_ProxyHeader {
	p := new(HTTPSHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x HTTPSHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPSHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[122].Descriptor()
}

func (HTTPSHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[122]
}

func (x HTTPSHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPSHealthCheck_ProxyHeader.Descriptor instead.
func (HTTPSHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{615, 1}
}

// Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
type HealthCheck_Type int32

const (
	// A value indicating that the enum field is not set.
	HealthCheck_UNDEFINED_TYPE HealthCheck_Type = 0
	HealthCheck_GRPC           HealthCheck_Type = 2196510
	HealthCheck_GRPC_WITH_TLS  HealthCheck_Type = 268089571
	HealthCheck_HTTP           HealthCheck_Type = 2228360
	HealthCheck_HTTP2          HealthCheck_Type = 69079210
	HealthCheck_HTTPS          HealthCheck_Type = 69079243
	HealthCheck_INVALID        HealthCheck_Type = 530283991
	HealthCheck_SSL            HealthCheck_Type = 82412
	HealthCheck_TCP            HealthCheck_Type = 82881
)

// Enum value maps for HealthCheck_Type.
var (
	HealthCheck_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		2196510:   "GRPC",
		268089571: "GRPC_WITH_TLS",
		2228360:   "HTTP",
		69079210:  "HTTP2",
		69079243:  "HTTPS",
		530283991: "INVALID",
		82412:     "SSL",
		82881:     "TCP",
	}
	HealthCheck_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"GRPC":           2196510,
		"GRPC_WITH_TLS":  268089571,
		"HTTP":           2228360,
		"HTTP2":          69079210,
		"HTTPS":          69079243,
		"INVALID":        530283991,
		"SSL":            82412,
		"TCP":            82881,
	}
)

func (x HealthCheck_Type) Enum() *HealthCheck_Type {
	p := new(HealthCheck_Type)
	*p = x
	return p
}

func (x HealthCheck_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthCheck_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[123].Descriptor()
}

func (HealthCheck_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[123]
}

func (x HealthCheck_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthCheck_Type.Descriptor instead.
func (HealthCheck_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{616, 0}
}

// Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified. - NO_AGGREGATION. An EndpointHealth message is returned for each pair in the health check service. - AND. If any health check of an endpoint reports UNHEALTHY, then UNHEALTHY is the HealthState of the endpoint. If all health checks report HEALTHY, the HealthState of the endpoint is HEALTHY. . This is only allowed with regional HealthCheckService.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// AND
// NO_AGGREGATION
type HealthCheckService_HealthStatusAggregationPolicy int32

const (
	// A value indicating that the enum field is not set.
	HealthCheckService_UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY HealthCheckService_HealthStatusAggregationPolicy = 0
	HealthCheckService_AND                                        HealthCheckService_HealthStatusAggregationPolicy = 64951
	HealthCheckService_NO_AGGREGATION                             HealthCheckService_HealthStatusAggregationPolicy = 426445124
)

// Enum value maps for HealthCheckService_HealthStatusAggregationPolicy.
var (
	HealthCheckService_HealthStatusAggregationPolicy_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY",
		64951:     "AND",
		426445124: "NO_AGGREGATION",
	}
	HealthCheckService_HealthStatusAggregationPolicy_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY": 0,
		"AND":            64951,
		"NO_AGGREGATION": 426445124,
	}
)

func (x HealthCheckService_HealthStatusAggregationPolicy) Enum() *HealthCheckService_HealthStatusAggregationPolicy {
	p := new(HealthCheckService_HealthStatusAggregationPolicy)
	*p = x
	return p
}

func (x HealthCheckService_HealthStatusAggregationPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthCheckService_HealthStatusAggregationPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[124].Descriptor()
}

func (HealthCheckService_HealthStatusAggregationPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[124]
}

func (x HealthCheckService_HealthStatusAggregationPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthCheckService_HealthStatusAggregationPolicy.Descriptor instead.
func (HealthCheckService_HealthStatusAggregationPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{620, 0}
}

// This field is deprecated. Use health_status_aggregation_policy instead. Policy for how the results from multiple health checks for the same endpoint are aggregated. - NO_AGGREGATION. An EndpointHealth message is returned for each backend in the health check service. - AND. If any backend's health check reports UNHEALTHY, then UNHEALTHY is the HealthState of the entire health check service. If all backend's are healthy, the HealthState of the health check service is HEALTHY. .
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// AND
// NO_AGGREGATION
type HealthCheckService_HealthStatusAggregationStrategy int32

const (
	// A value indicating that the enum field is not set.
	HealthCheckService_UNDEFINED_HEALTH_STATUS_AGGREGATION_STRATEGY HealthCheckService_HealthStatusAggregationStrategy = 0
)

// Enum value maps for HealthCheckService_HealthStatusAggregationStrategy.
var (
	HealthCheckService_HealthStatusAggregationStrategy_name = map[int32]string{
		0: "UNDEFINED_HEALTH_STATUS_AGGREGATION_STRATEGY",
	}
	HealthCheckService_HealthStatusAggregationStrategy_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS_AGGREGATION_STRATEGY": 0,
	}
)

func (x HealthCheckService_HealthStatusAggregationStrategy) Enum() *HealthCheckService_HealthStatusAggregationStrategy {
	p := new(HealthCheckService_HealthStatusAggregationStrategy)
	*p = x
	return p
}

func (x HealthCheckService_HealthStatusAggregationStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthCheckService_HealthStatusAggregationStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[125].Descriptor()
}

func (HealthCheckService_HealthStatusAggregationStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[125]
}

func (x HealthCheckService_HealthStatusAggregationStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthCheckService_HealthStatusAggregationStrategy.Descriptor instead.
func (HealthCheckService_HealthStatusAggregationStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{620, 1}
}

// Specifies the type of the HealthSource. The only allowed value is BACKEND_SERVICE. Must be specified when the HealthSource is created, and cannot be mutated.
type HealthSource_SourceType int32

const (
	// A value indicating that the enum field is not set.
	HealthSource_UNDEFINED_SOURCE_TYPE HealthSource_SourceType = 0
	HealthSource_BACKEND_SERVICE       HealthSource_SourceType = 285792202
)

// Enum value maps for HealthSource_SourceType.
var (
	HealthSource_SourceType_name = map[int32]string{
		0:         "UNDEFINED_SOURCE_TYPE",
		285792202: "BACKEND_SERVICE",
	}
	HealthSource_SourceType_value = map[string]int32{
		"UNDEFINED_SOURCE_TYPE": 0,
		"BACKEND_SERVICE":       285792202,
	}
)

func (x HealthSource_SourceType) Enum() *HealthSource_SourceType {
	p := new(HealthSource_SourceType)
	*p = x
	return p
}

func (x HealthSource_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthSource_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[126].Descriptor()
}

func (HealthSource_SourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[126]
}

func (x HealthSource_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthSource_SourceType.Descriptor instead.
func (HealthSource_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{625, 0}
}

// Health state of the IPv4 address of the instance.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// HEALTHY
// UNHEALTHY
type HealthStatus_HealthState int32

const (
	// A value indicating that the enum field is not set.
	HealthStatus_UNDEFINED_HEALTH_STATE HealthStatus_HealthState = 0
	HealthStatus_HEALTHY                HealthStatus_HealthState = 439801213
	HealthStatus_UNHEALTHY              HealthStatus_HealthState = 462118084
)

// Enum value maps for HealthStatus_HealthState.
var (
	HealthStatus_HealthState_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATE",
		439801213: "HEALTHY",
		462118084: "UNHEALTHY",
	}
	HealthStatus_HealthState_value = map[string]int32{
		"UNDEFINED_HEALTH_STATE": 0,
		"HEALTHY":                439801213,
		"UNHEALTHY":              462118084,
	}
)

func (x HealthStatus_HealthState) Enum() *HealthStatus_HealthState {
	p := new(HealthStatus_HealthState)
	*p = x
	return p
}

func (x HealthStatus_HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatus_HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[127].Descriptor()
}

func (HealthStatus_HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[127]
}

func (x HealthStatus_HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatus_HealthState.Descriptor instead.
func (HealthStatus_HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{629, 0}
}

// Health state of the IPv6 address of the instance.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// HEALTHY
// UNHEALTHY
type HealthStatus_Ipv6HealthState int32

const (
	// A value indicating that the enum field is not set.
	HealthStatus_UNDEFINED_IPV6_HEALTH_STATE HealthStatus_Ipv6HealthState = 0
)

// Enum value maps for HealthStatus_Ipv6HealthState.
var (
	HealthStatus_Ipv6HealthState_name = map[int32]string{
		0: "UNDEFINED_IPV6_HEALTH_STATE",
	}
	HealthStatus_Ipv6HealthState_value = map[string]int32{
		"UNDEFINED_IPV6_HEALTH_STATE": 0,
	}
)

func (x HealthStatus_Ipv6HealthState) Enum() *HealthStatus_Ipv6HealthState {
	p := new(HealthStatus_Ipv6HealthState)
	*p = x
	return p
}

func (x HealthStatus_Ipv6HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatus_Ipv6HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[128].Descriptor()
}

func (HealthStatus_Ipv6HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[128]
}

func (x HealthStatus_Ipv6HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatus_Ipv6HealthState.Descriptor instead.
func (HealthStatus_Ipv6HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{629, 1}
}

type HealthStatus_WeightError int32

const (
	// A value indicating that the enum field is not set.
	HealthStatus_UNDEFINED_WEIGHT_ERROR HealthStatus_WeightError = 0
	// The response to a Health Check probe had the HTTP response header field X-Load-Balancing-Endpoint-Weight, but its content was invalid (i.e., not a non-negative single-precision floating-point number in decimal string representation).
	HealthStatus_INVALID_WEIGHT HealthStatus_WeightError = 383698400
	// The response to a Health Check probe did not have the HTTP response header field X-Load-Balancing-Endpoint-Weight.
	HealthStatus_MISSING_WEIGHT HealthStatus_WeightError = 384027537
	// This is the value when the accompanied health status is either TIMEOUT (i.e.,the Health Check probe was not able to get a response in time) or UNKNOWN. For the latter, it should be typically because there has not been sufficient time to parse and report the weight for a new backend (which is with 0.0.0.0 ip address). However, it can be also due to an outage case for which the health status is explicitly reset to UNKNOWN.
	HealthStatus_UNAVAILABLE_WEIGHT HealthStatus_WeightError = 439464295
	// This is the default value when WeightReportMode is DISABLE, and is also the initial value when WeightReportMode has just updated to ENABLE or DRY_RUN and there has not been sufficient time to parse and report the backend weight.
	HealthStatus_WEIGHT_NONE HealthStatus_WeightError = 502428831
)

// Enum value maps for HealthStatus_WeightError.
var (
	HealthStatus_WeightError_name = map[int32]string{
		0:         "UNDEFINED_WEIGHT_ERROR",
		383698400: "INVALID_WEIGHT",
		384027537: "MISSING_WEIGHT",
		439464295: "UNAVAILABLE_WEIGHT",
		502428831: "WEIGHT_NONE",
	}
	HealthStatus_WeightError_value = map[string]int32{
		"UNDEFINED_WEIGHT_ERROR": 0,
		"INVALID_WEIGHT":         383698400,
		"MISSING_WEIGHT":         384027537,
		"UNAVAILABLE_WEIGHT":     439464295,
		"WEIGHT_NONE":            502428831,
	}
)

func (x HealthStatus_WeightError) Enum() *HealthStatus_WeightError {
	p := new(HealthStatus_WeightError)
	*p = x
	return p
}

func (x HealthStatus_WeightError) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatus_WeightError) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[129].Descriptor()
}

func (HealthStatus_WeightError) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[129]
}

func (x HealthStatus_WeightError) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatus_WeightError.Descriptor instead.
func (HealthStatus_WeightError) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{629, 2}
}

// Health state of the network endpoint determined based on the health checks configured.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// DRAINING
// HEALTHY
// UNHEALTHY
// UNKNOWN
type HealthStatusForNetworkEndpoint_HealthState int32

const (
	// A value indicating that the enum field is not set.
	HealthStatusForNetworkEndpoint_UNDEFINED_HEALTH_STATE HealthStatusForNetworkEndpoint_HealthState = 0
	HealthStatusForNetworkEndpoint_DRAINING               HealthStatusForNetworkEndpoint_HealthState = 480455402
	HealthStatusForNetworkEndpoint_HEALTHY                HealthStatusForNetworkEndpoint_HealthState = 439801213
	HealthStatusForNetworkEndpoint_UNHEALTHY              HealthStatusForNetworkEndpoint_HealthState = 462118084
	HealthStatusForNetworkEndpoint_UNKNOWN                HealthStatusForNetworkEndpoint_HealthState = 433141802
)

// Enum value maps for HealthStatusForNetworkEndpoint_HealthState.
var (
	HealthStatusForNetworkEndpoint_HealthState_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATE",
		480455402: "DRAINING",
		439801213: "HEALTHY",
		462118084: "UNHEALTHY",
		433141802: "UNKNOWN",
	}
	HealthStatusForNetworkEndpoint_HealthState_value = map[string]int32{
		"UNDEFINED_HEALTH_STATE": 0,
		"DRAINING":               480455402,
		"HEALTHY":                439801213,
		"UNHEALTHY":              462118084,
		"UNKNOWN":                433141802,
	}
)

func (x HealthStatusForNetworkEndpoint_HealthState) Enum() *HealthStatusForNetworkEndpoint_HealthState {
	p := new(HealthStatusForNetworkEndpoint_HealthState)
	*p = x
	return p
}

func (x HealthStatusForNetworkEndpoint_HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatusForNetworkEndpoint_HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[130].Descriptor()
}

func (HealthStatusForNetworkEndpoint_HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[130]
}

func (x HealthStatusForNetworkEndpoint_HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatusForNetworkEndpoint_HealthState.Descriptor instead.
func (HealthStatusForNetworkEndpoint_HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{630, 0}
}

// Health state of the ipv6 network endpoint determined based on the health checks configured.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// DRAINING
// HEALTHY
// UNHEALTHY
// UNKNOWN
type HealthStatusForNetworkEndpoint_Ipv6HealthState int32

const (
	// A value indicating that the enum field is not set.
	HealthStatusForNetworkEndpoint_UNDEFINED_IPV6_HEALTH_STATE HealthStatusForNetworkEndpoint_Ipv6HealthState = 0
)

// Enum value maps for HealthStatusForNetworkEndpoint_Ipv6HealthState.
var (
	HealthStatusForNetworkEndpoint_Ipv6HealthState_name = map[int32]string{
		0: "UNDEFINED_IPV6_HEALTH_STATE",
	}
	HealthStatusForNetworkEndpoint_Ipv6HealthState_value = map[string]int32{
		"UNDEFINED_IPV6_HEALTH_STATE": 0,
	}
)

func (x HealthStatusForNetworkEndpoint_Ipv6HealthState) Enum() *HealthStatusForNetworkEndpoint_Ipv6HealthState {
	p := new(HealthStatusForNetworkEndpoint_Ipv6HealthState)
	*p = x
	return p
}

func (x HealthStatusForNetworkEndpoint_Ipv6HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatusForNetworkEndpoint_Ipv6HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[131].Descriptor()
}

func (HealthStatusForNetworkEndpoint_Ipv6HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[131]
}

func (x HealthStatusForNetworkEndpoint_Ipv6HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatusForNetworkEndpoint_Ipv6HealthState.Descriptor instead.
func (HealthStatusForNetworkEndpoint_Ipv6HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{630, 1}
}

// The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
type HttpRedirectAction_RedirectResponseCode int32

const (
	// A value indicating that the enum field is not set.
	HttpRedirectAction_UNDEFINED_REDIRECT_RESPONSE_CODE HttpRedirectAction_RedirectResponseCode = 0
	// Http Status Code 302 - Found.
	HttpRedirectAction_FOUND HttpRedirectAction_RedirectResponseCode = 67084130
	// Http Status Code 301 - Moved Permanently.
	HttpRedirectAction_MOVED_PERMANENTLY_DEFAULT HttpRedirectAction_RedirectResponseCode = 386698449
	// Http Status Code 308 - Permanent Redirect maintaining HTTP method.
	HttpRedirectAction_PERMANENT_REDIRECT HttpRedirectAction_RedirectResponseCode = 382006381
	// Http Status Code 303 - See Other.
	HttpRedirectAction_SEE_OTHER HttpRedirectAction_RedirectResponseCode = 445380580
	// Http Status Code 307 - Temporary Redirect maintaining HTTP method.
	HttpRedirectAction_TEMPORARY_REDIRECT HttpRedirectAction_RedirectResponseCode = 489550378
)

// Enum value maps for HttpRedirectAction_RedirectResponseCode.
var (
	HttpRedirectAction_RedirectResponseCode_name = map[int32]string{
		0:         "UNDEFINED_REDIRECT_RESPONSE_CODE",
		67084130:  "FOUND",
		386698449: "MOVED_PERMANENTLY_DEFAULT",
		382006381: "PERMANENT_REDIRECT",
		445380580: "SEE_OTHER",
		489550378: "TEMPORARY_REDIRECT",
	}
	HttpRedirectAction_RedirectResponseCode_value = map[string]int32{
		"UNDEFINED_REDIRECT_RESPONSE_CODE": 0,
		"FOUND":                            67084130,
		"MOVED_PERMANENTLY_DEFAULT":        386698449,
		"PERMANENT_REDIRECT":               382006381,
		"SEE_OTHER":                        445380580,
		"TEMPORARY_REDIRECT":               489550378,
	}
)

func (x HttpRedirectAction_RedirectResponseCode) Enum() *HttpRedirectAction_RedirectResponseCode {
	p := new(HttpRedirectAction_RedirectResponseCode)
	*p = x
	return p
}

func (x HttpRedirectAction_RedirectResponseCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpRedirectAction_RedirectResponseCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[132].Descriptor()
}

func (HttpRedirectAction_RedirectResponseCode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[132]
}

func (x HttpRedirectAction_RedirectResponseCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpRedirectAction_RedirectResponseCode.Descriptor instead.
func (HttpRedirectAction_RedirectResponseCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{642, 0}
}

// The architecture of the image. Valid values are ARM64 or X86_64.
type Image_Architecture int32

const (
	// A value indicating that the enum field is not set.
	Image_UNDEFINED_ARCHITECTURE Image_Architecture = 0
	// Default value indicating Architecture is not set.
	Image_ARCHITECTURE_UNSPECIFIED Image_Architecture = 394750507
	// Machines with architecture ARM64
	Image_ARM64 Image_Architecture = 62547450
	// Machines with architecture X86_64
	Image_X86_64 Image_Architecture = 425300551
)

// Enum value maps for Image_Architecture.
var (
	Image_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	Image_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x Image_Architecture) Enum() *Image_Architecture {
	p := new(Image_Architecture)
	*p = x
	return p
}

func (x Image_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Image_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[133].Descriptor()
}

func (Image_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[133]
}

func (x Image_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Image_Architecture.Descriptor instead.
func (Image_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{647, 0}
}

// The type of the image used to create this disk. The default and only valid value is RAW.
type Image_SourceType int32

const (
	// A value indicating that the enum field is not set.
	Image_UNDEFINED_SOURCE_TYPE Image_SourceType = 0
	Image_RAW                   Image_SourceType = 80904
)

// Enum value maps for Image_SourceType.
var (
	Image_SourceType_name = map[int32]string{
		0:     "UNDEFINED_SOURCE_TYPE",
		80904: "RAW",
	}
	Image_SourceType_value = map[string]int32{
		"UNDEFINED_SOURCE_TYPE": 0,
		"RAW":                   80904,
	}
)

func (x Image_SourceType) Enum() *Image_SourceType {
	p := new(Image_SourceType)
	*p = x
	return p
}

func (x Image_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Image_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[134].Descriptor()
}

func (Image_SourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[134]
}

func (x Image_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Image_SourceType.Descriptor instead.
func (Image_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{647, 1}
}

// [Output Only] The status of the image. An image can be used to create other resources, such as instances, only after the image has been successfully created and the status is set to READY. Possible values are FAILED, PENDING, or READY.
type Image_Status int32

const (
	// A value indicating that the enum field is not set.
	Image_UNDEFINED_STATUS Image_Status = 0
	// Image is deleting.
	Image_DELETING Image_Status = 528602024
	// Image creation failed due to an error.
	Image_FAILED Image_Status = 455706685
	// Image hasn't been created as yet.
	Image_PENDING Image_Status = 35394935
	// Image has been successfully created.
	Image_READY Image_Status = 77848963
)

// Enum value maps for Image_Status.
var (
	Image_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		528602024: "DELETING",
		455706685: "FAILED",
		35394935:  "PENDING",
		77848963:  "READY",
	}
	Image_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"PENDING":          35394935,
		"READY":            77848963,
	}
)

func (x Image_Status) Enum() *Image_Status {
	p := new(Image_Status)
	*p = x
	return p
}

func (x Image_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Image_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[135].Descriptor()
}

func (Image_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[135]
}

func (x Image_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Image_Status.Descriptor instead.
func (Image_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{647, 2}
}

// KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
type Instance_KeyRevocationActionType int32

const (
	// A value indicating that the enum field is not set.
	Instance_UNDEFINED_KEY_REVOCATION_ACTION_TYPE Instance_KeyRevocationActionType = 0
	// Default value. This value is unused.
	Instance_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED Instance_KeyRevocationActionType = 467110106
	// Indicates user chose no operation.
	Instance_NONE Instance_KeyRevocationActionType = 2402104
	// Indicates user chose to opt for VM shutdown on key revocation.
	Instance_STOP Instance_KeyRevocationActionType = 2555906
)

// Enum value maps for Instance_KeyRevocationActionType.
var (
	Instance_KeyRevocationActionType_name = map[int32]string{
		0:         "UNDEFINED_KEY_REVOCATION_ACTION_TYPE",
		467110106: "KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED",
		2402104:   "NONE",
		2555906:   "STOP",
	}
	Instance_KeyRevocationActionType_value = map[string]int32{
		"UNDEFINED_KEY_REVOCATION_ACTION_TYPE":   0,
		"KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED": 467110106,
		"NONE":                                   2402104,
		"STOP":                                   2555906,
	}
)

func (x Instance_KeyRevocationActionType) Enum() *Instance_KeyRevocationActionType {
	p := new(Instance_KeyRevocationActionType)
	*p = x
	return p
}

func (x Instance_KeyRevocationActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_KeyRevocationActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[136].Descriptor()
}

func (Instance_KeyRevocationActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[136]
}

func (x Instance_KeyRevocationActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_KeyRevocationActionType.Descriptor instead.
func (Instance_KeyRevocationActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{739, 0}
}

// PostKeyRevocationActionType of the instance.
type Instance_PostKeyRevocationActionType int32

const (
	// A value indicating that the enum field is not set.
	Instance_UNDEFINED_POST_KEY_REVOCATION_ACTION_TYPE Instance_PostKeyRevocationActionType = 0
	// Indicates user chose no operation.
	Instance_NOOP Instance_PostKeyRevocationActionType = 2402146
	// Default value. This value is unused.
	Instance_POST_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED Instance_PostKeyRevocationActionType = 228738393
	// Indicates user chose to opt for VM shutdown on key revocation.
	Instance_SHUTDOWN Instance_PostKeyRevocationActionType = 76412502
)

// Enum value maps for Instance_PostKeyRevocationActionType.
var (
	Instance_PostKeyRevocationActionType_name = map[int32]string{
		0:         "UNDEFINED_POST_KEY_REVOCATION_ACTION_TYPE",
		2402146:   "NOOP",
		228738393: "POST_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED",
		76412502:  "SHUTDOWN",
	}
	Instance_PostKeyRevocationActionType_value = map[string]int32{
		"UNDEFINED_POST_KEY_REVOCATION_ACTION_TYPE": 0,
		"NOOP": 2402146,
		"POST_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED": 228738393,
		"SHUTDOWN": 76412502,
	}
)

func (x Instance_PostKeyRevocationActionType) Enum() *Instance_PostKeyRevocationActionType {
	p := new(Instance_PostKeyRevocationActionType)
	*p = x
	return p
}

func (x Instance_PostKeyRevocationActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_PostKeyRevocationActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[137].Descriptor()
}

func (Instance_PostKeyRevocationActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[137]
}

func (x Instance_PostKeyRevocationActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_PostKeyRevocationActionType.Descriptor instead.
func (Instance_PostKeyRevocationActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{739, 1}
}

// The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
type Instance_PrivateIpv6GoogleAccess int32

const (
	// A value indicating that the enum field is not set.
	Instance_UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS Instance_PrivateIpv6GoogleAccess = 0
	// Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
	Instance_ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE Instance_PrivateIpv6GoogleAccess = 427975994
	// Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
	Instance_ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE Instance_PrivateIpv6GoogleAccess = 288210263
	// Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
	Instance_INHERIT_FROM_SUBNETWORK Instance_PrivateIpv6GoogleAccess = 530256959
)

// Enum value maps for Instance_PrivateIpv6GoogleAccess.
var (
	Instance_PrivateIpv6GoogleAccess_name = map[int32]string{
		0:         "UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS",
		427975994: "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE",
		288210263: "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE",
		530256959: "INHERIT_FROM_SUBNETWORK",
	}
	Instance_PrivateIpv6GoogleAccess_value = map[string]int32{
		"UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS":  0,
		"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE": 427975994,
		"ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE":   288210263,
		"INHERIT_FROM_SUBNETWORK":               530256959,
	}
)

func (x Instance_PrivateIpv6GoogleAccess) Enum() *Instance_PrivateIpv6GoogleAccess {
	p := new(Instance_PrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x Instance_PrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_PrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[138].Descriptor()
}

func (Instance_PrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[138]
}

func (x Instance_PrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_PrivateIpv6GoogleAccess.Descriptor instead.
func (Instance_PrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{739, 2}
}

// [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
type Instance_Status int32

const (
	// A value indicating that the enum field is not set.
	Instance_UNDEFINED_STATUS Instance_Status = 0
	// The instance is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
	Instance_DEPROVISIONING Instance_Status = 428935662
	// For Flex Start provisioning instance is waiting for available capacity from Dynamic Workload Scheduler (DWS).
	Instance_PENDING Instance_Status = 35394935
	// The instance is gracefully shutting down.
	Instance_PENDING_STOP Instance_Status = 362509770
	// Resources are being allocated for the instance.
	Instance_PROVISIONING Instance_Status = 290896621
	// The instance is in repair.
	Instance_REPAIRING Instance_Status = 413483285
	// The instance is running.
	Instance_RUNNING Instance_Status = 121282975
	// All required resources have been allocated and the instance is being started.
	Instance_STAGING Instance_Status = 431072283
	// The instance has stopped successfully.
	Instance_STOPPED Instance_Status = 444276141
	// The instance is currently stopping (either being deleted or killed).
	Instance_STOPPING Instance_Status = 350791796
	// The instance has suspended.
	Instance_SUSPENDED Instance_Status = 51223995
	// The instance is suspending.
	Instance_SUSPENDING Instance_Status = 514206246
	// The instance has stopped (either by explicit action or underlying failure).
	Instance_TERMINATED Instance_Status = 250018339
)

// Enum value maps for Instance_Status.
var (
	Instance_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		428935662: "DEPROVISIONING",
		35394935:  "PENDING",
		362509770: "PENDING_STOP",
		290896621: "PROVISIONING",
		413483285: "REPAIRING",
		121282975: "RUNNING",
		431072283: "STAGING",
		444276141: "STOPPED",
		350791796: "STOPPING",
		51223995:  "SUSPENDED",
		514206246: "SUSPENDING",
		250018339: "TERMINATED",
	}
	Instance_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DEPROVISIONING":   428935662,
		"PENDING":          35394935,
		"PENDING_STOP":     362509770,
		"PROVISIONING":     290896621,
		"REPAIRING":        413483285,
		"RUNNING":          121282975,
		"STAGING":          431072283,
		"STOPPED":          444276141,
		"STOPPING":         350791796,
		"SUSPENDED":        51223995,
		"SUSPENDING":       514206246,
		"TERMINATED":       250018339,
	}
)

func (x Instance_Status) Enum() *Instance_Status {
	p := new(Instance_Status)
	*p = x
	return p
}

func (x Instance_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[139].Descriptor()
}

func (Instance_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[139]
}

func (x Instance_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_Status.Descriptor instead.
func (Instance_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{739, 3}
}

// The action to perform in case of zone failure. Only one value is supported, NO_FAILOVER. The default is NO_FAILOVER.
type InstanceGroupManager_FailoverAction int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManager_UNDEFINED_FAILOVER_ACTION InstanceGroupManager_FailoverAction = 0
	InstanceGroupManager_NO_FAILOVER               InstanceGroupManager_FailoverAction = 480957872
	InstanceGroupManager_UNKNOWN                   InstanceGroupManager_FailoverAction = 433141802
)

// Enum value maps for InstanceGroupManager_FailoverAction.
var (
	InstanceGroupManager_FailoverAction_name = map[int32]string{
		0:         "UNDEFINED_FAILOVER_ACTION",
		480957872: "NO_FAILOVER",
		433141802: "UNKNOWN",
	}
	InstanceGroupManager_FailoverAction_value = map[string]int32{
		"UNDEFINED_FAILOVER_ACTION": 0,
		"NO_FAILOVER":               480957872,
		"UNKNOWN":                   433141802,
	}
)

func (x InstanceGroupManager_FailoverAction) Enum() *InstanceGroupManager_FailoverAction {
	p := new(InstanceGroupManager_FailoverAction)
	*p = x
	return p
}

func (x InstanceGroupManager_FailoverAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManager_FailoverAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[140].Descriptor()
}

func (InstanceGroupManager_FailoverAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[140]
}

func (x InstanceGroupManager_FailoverAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManager_FailoverAction.Descriptor instead.
func (InstanceGroupManager_FailoverAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{746, 0}
}

// Pagination behavior of the listManagedInstances API method for this managed instance group.
type InstanceGroupManager_ListManagedInstancesResults int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManager_UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS InstanceGroupManager_ListManagedInstancesResults = 0
	// (Default) Pagination is disabled for the group's listManagedInstances API method. maxResults and pageToken query parameters are ignored and all instances are returned in a single response.
	InstanceGroupManager_PAGELESS InstanceGroupManager_ListManagedInstancesResults = 32183464
	// Pagination is enabled for the group's listManagedInstances API method. maxResults and pageToken query parameters are respected.
	InstanceGroupManager_PAGINATED InstanceGroupManager_ListManagedInstancesResults = 40190637
)

// Enum value maps for InstanceGroupManager_ListManagedInstancesResults.
var (
	InstanceGroupManager_ListManagedInstancesResults_name = map[int32]string{
		0:        "UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS",
		32183464: "PAGELESS",
		40190637: "PAGINATED",
	}
	InstanceGroupManager_ListManagedInstancesResults_value = map[string]int32{
		"UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS": 0,
		"PAGELESS":  32183464,
		"PAGINATED": 40190637,
	}
)

func (x InstanceGroupManager_ListManagedInstancesResults) Enum() *InstanceGroupManager_ListManagedInstancesResults {
	p := new(InstanceGroupManager_ListManagedInstancesResults)
	*p = x
	return p
}

func (x InstanceGroupManager_ListManagedInstancesResults) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManager_ListManagedInstancesResults) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[141].Descriptor()
}

func (InstanceGroupManager_ListManagedInstancesResults) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[141]
}

func (x InstanceGroupManager_ListManagedInstancesResults) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManager_ListManagedInstancesResults.Descriptor instead.
func (InstanceGroupManager_ListManagedInstancesResults) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{746, 1}
}

// The action that a MIG performs on a failed VM. If the value of the onFailedHealthCheck field is `DEFAULT_ACTION`, then the same action also applies to the VMs on which your application fails a health check. Valid values are - REPAIR (default): MIG automatically repairs a failed VM by recreating it. For more information, see About repairing VMs in a MIG. - DO_NOTHING: MIG does not repair a failed VM.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// DO_NOTHING
// REPAIR
type InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerInstanceLifecyclePolicy_UNDEFINED_DEFAULT_ACTION_ON_FAILURE InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure = 0
	// MIG deletes a failed or an unhealthy VM. Deleting the VM decreases the target size of the MIG.
	InstanceGroupManagerInstanceLifecyclePolicy_DELETE     InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure = 402225579
	InstanceGroupManagerInstanceLifecyclePolicy_DO_NOTHING InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure = 451307513
	InstanceGroupManagerInstanceLifecyclePolicy_REPAIR     InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure = 266277773
)

// Enum value maps for InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure.
var (
	InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure_name = map[int32]string{
		0:         "UNDEFINED_DEFAULT_ACTION_ON_FAILURE",
		402225579: "DELETE",
		451307513: "DO_NOTHING",
		266277773: "REPAIR",
	}
	InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure_value = map[string]int32{
		"UNDEFINED_DEFAULT_ACTION_ON_FAILURE": 0,
		"DELETE":                              402225579,
		"DO_NOTHING":                          451307513,
		"REPAIR":                              266277773,
	}
)

func (x InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure) Enum() *InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure {
	p := new(InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure)
	*p = x
	return p
}

func (x InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[142].Descriptor()
}

func (InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[142]
}

func (x InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure.Descriptor instead.
func (InstanceGroupManagerInstanceLifecyclePolicy_DefaultActionOnFailure) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{754, 0}
}

// A bit indicating whether to forcefully apply the group's latest configuration when repairing a VM. Valid options are: - NO (default): If configuration updates are available, they are not forcefully applied during repair. Instead, configuration updates are applied according to the group's update policy. - YES: If configuration updates are available, they are applied during repair.
type InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerInstanceLifecyclePolicy_UNDEFINED_FORCE_UPDATE_ON_REPAIR InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair = 0
	InstanceGroupManagerInstanceLifecyclePolicy_NO                               InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair = 2497
	InstanceGroupManagerInstanceLifecyclePolicy_YES                              InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair = 87751
)

// Enum value maps for InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair.
var (
	InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair_name = map[int32]string{
		0:     "UNDEFINED_FORCE_UPDATE_ON_REPAIR",
		2497:  "NO",
		87751: "YES",
	}
	InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair_value = map[string]int32{
		"UNDEFINED_FORCE_UPDATE_ON_REPAIR": 0,
		"NO":                               2497,
		"YES":                              87751,
	}
)

func (x InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair) Enum() *InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair {
	p := new(InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair)
	*p = x
	return p
}

func (x InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[143].Descriptor()
}

func (InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[143]
}

func (x InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair.Descriptor instead.
func (InstanceGroupManagerInstanceLifecyclePolicy_ForceUpdateOnRepair) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{754, 1}
}

// The action that a MIG performs on an unhealthy VM. A VM is marked as unhealthy when the application running on that VM fails a health check. Valid values are: - DEFAULT_ACTION (default): MIG uses the same action configured for instanceLifecyclePolicy.defaultActionOnFailure field. - REPAIR: MIG automatically repairs an unhealthy VM by recreating it. - DO_NOTHING: MIG doesn't repair an unhealthy VM. For more information, see About repairing VMs in a MIG.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// DO_NOTHING
// REPAIR
type InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerInstanceLifecyclePolicy_UNDEFINED_ON_FAILED_HEALTH_CHECK InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck = 0
	// (Default) MIG uses the same action configured for instanceLifecyclePolicy.defaultActionOnFailure field.
	InstanceGroupManagerInstanceLifecyclePolicy_DEFAULT_ACTION InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck = 463967764
)

// Enum value maps for InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck.
var (
	InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck_name = map[int32]string{
		0:         "UNDEFINED_ON_FAILED_HEALTH_CHECK",
		463967764: "DEFAULT_ACTION",
	}
	InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck_value = map[string]int32{
		"UNDEFINED_ON_FAILED_HEALTH_CHECK": 0,
		"DEFAULT_ACTION":                   463967764,
	}
)

func (x InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck) Enum() *InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck {
	p := new(InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck)
	*p = x
	return p
}

func (x InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[144].Descriptor()
}

func (InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[144]
}

func (x InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck.Descriptor instead.
func (InstanceGroupManagerInstanceLifecyclePolicy_OnFailedHealthCheck) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{754, 2}
}

// Specifies whether the MIG can change a VM's zone during a repair.
type InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerInstanceLifecyclePolicyOnRepair_UNDEFINED_ALLOW_CHANGING_ZONE InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone = 0
	// [Default] MIG cannot change a VM's zone during a repair.
	InstanceGroupManagerInstanceLifecyclePolicyOnRepair_NO InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone = 2497
	// MIG can select a different zone for the VM during a repair.
	InstanceGroupManagerInstanceLifecyclePolicyOnRepair_YES InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone = 87751
)

// Enum value maps for InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone.
var (
	InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone_name = map[int32]string{
		0:     "UNDEFINED_ALLOW_CHANGING_ZONE",
		2497:  "NO",
		87751: "YES",
	}
	InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone_value = map[string]int32{
		"UNDEFINED_ALLOW_CHANGING_ZONE": 0,
		"NO":                            2497,
		"YES":                           87751,
	}
)

func (x InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone) Enum() *InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone {
	p := new(InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone)
	*p = x
	return p
}

func (x InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[145].Descriptor()
}

func (InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[145]
}

func (x InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone.Descriptor instead.
func (InstanceGroupManagerInstanceLifecyclePolicyOnRepair_AllowChangingZone) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{755, 0}
}

// [Output only] Current state of the request.
type InstanceGroupManagerResizeRequest_State int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerResizeRequest_UNDEFINED_STATE InstanceGroupManagerResizeRequest_State = 0
	// The request was created successfully and was accepted for provisioning when the capacity becomes available.
	InstanceGroupManagerResizeRequest_ACCEPTED InstanceGroupManagerResizeRequest_State = 246714279
	// The request is cancelled.
	InstanceGroupManagerResizeRequest_CANCELLED InstanceGroupManagerResizeRequest_State = 41957681
	// Resize request is being created and may still fail creation.
	InstanceGroupManagerResizeRequest_CREATING InstanceGroupManagerResizeRequest_State = 455564985
	// The request failed before or during provisioning. If the request fails during provisioning, any VMs that were created during provisioning are rolled back and removed from the MIG.
	InstanceGroupManagerResizeRequest_FAILED InstanceGroupManagerResizeRequest_State = 455706685
	// The value is deprecated. ResizeRequests would stay in the ACCEPTED state during provisioning attempts. The target resource(s) are being provisioned.
	InstanceGroupManagerResizeRequest_PROVISIONING InstanceGroupManagerResizeRequest_State = 290896621
	// Default value. This value should never be returned.
	InstanceGroupManagerResizeRequest_STATE_UNSPECIFIED InstanceGroupManagerResizeRequest_State = 470755401
	// The request succeeded.
	InstanceGroupManagerResizeRequest_SUCCEEDED InstanceGroupManagerResizeRequest_State = 511103553
)

// Enum value maps for InstanceGroupManagerResizeRequest_State.
var (
	InstanceGroupManagerResizeRequest_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		246714279: "ACCEPTED",
		41957681:  "CANCELLED",
		455564985: "CREATING",
		455706685: "FAILED",
		290896621: "PROVISIONING",
		470755401: "STATE_UNSPECIFIED",
		511103553: "SUCCEEDED",
	}
	InstanceGroupManagerResizeRequest_State_value = map[string]int32{
		"UNDEFINED_STATE":   0,
		"ACCEPTED":          246714279,
		"CANCELLED":         41957681,
		"CREATING":          455564985,
		"FAILED":            455706685,
		"PROVISIONING":      290896621,
		"STATE_UNSPECIFIED": 470755401,
		"SUCCEEDED":         511103553,
	}
)

func (x InstanceGroupManagerResizeRequest_State) Enum() *InstanceGroupManagerResizeRequest_State {
	p := new(InstanceGroupManagerResizeRequest_State)
	*p = x
	return p
}

func (x InstanceGroupManagerResizeRequest_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerResizeRequest_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[146].Descriptor()
}

func (InstanceGroupManagerResizeRequest_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[146]
}

func (x InstanceGroupManagerResizeRequest_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerResizeRequest_State.Descriptor instead.
func (InstanceGroupManagerResizeRequest_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{758, 0}
}

// Defines how a MIG resumes or starts VMs from a standby pool when the group scales out. The default mode is `MANUAL`.
type InstanceGroupManagerStandbyPolicy_Mode int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerStandbyPolicy_UNDEFINED_MODE InstanceGroupManagerStandbyPolicy_Mode = 0
	// MIG does not automatically resume or start VMs in the standby pool when the group scales out.
	InstanceGroupManagerStandbyPolicy_MANUAL InstanceGroupManagerStandbyPolicy_Mode = 119397318
	// MIG automatically resumes or starts VMs in the standby pool when the group scales out, and replenishes the standby pool afterwards.
	InstanceGroupManagerStandbyPolicy_SCALE_OUT_POOL InstanceGroupManagerStandbyPolicy_Mode = 635394
)

// Enum value maps for InstanceGroupManagerStandbyPolicy_Mode.
var (
	InstanceGroupManagerStandbyPolicy_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		119397318: "MANUAL",
		635394:    "SCALE_OUT_POOL",
	}
	InstanceGroupManagerStandbyPolicy_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"MANUAL":         119397318,
		"SCALE_OUT_POOL": 635394,
	}
)

func (x InstanceGroupManagerStandbyPolicy_Mode) Enum() *InstanceGroupManagerStandbyPolicy_Mode {
	p := new(InstanceGroupManagerStandbyPolicy_Mode)
	*p = x
	return p
}

func (x InstanceGroupManagerStandbyPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerStandbyPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[147].Descriptor()
}

func (InstanceGroupManagerStandbyPolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[147]
}

func (x InstanceGroupManagerStandbyPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerStandbyPolicy_Mode.Descriptor instead.
func (InstanceGroupManagerStandbyPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{763, 0}
}

// The mode of target size policy based on which the MIG creates its VMs individually or all at once.
type InstanceGroupManagerTargetSizePolicy_Mode int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerTargetSizePolicy_UNDEFINED_MODE InstanceGroupManagerTargetSizePolicy_Mode = 0
	// The mode in which the MIG creates VMs all at once. In this mode, if the MIG is unable to create even one VM, the MIG waits until all VMs can be created at the same time.
	InstanceGroupManagerTargetSizePolicy_BULK InstanceGroupManagerTargetSizePolicy_Mode = 2050322
	// The mode in which the MIG creates VMs individually. In this mode, if the MIG is unable to create a VM, the MIG will continue to create the other VMs in the group. This is the default mode.
	InstanceGroupManagerTargetSizePolicy_INDIVIDUAL InstanceGroupManagerTargetSizePolicy_Mode = 438800025
	// If mode is unspecified, MIG will behave as in the default `INDIVIDUAL` mode.
	InstanceGroupManagerTargetSizePolicy_UNSPECIFIED_MODE InstanceGroupManagerTargetSizePolicy_Mode = 53715403
)

// Enum value maps for InstanceGroupManagerTargetSizePolicy_Mode.
var (
	InstanceGroupManagerTargetSizePolicy_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		2050322:   "BULK",
		438800025: "INDIVIDUAL",
		53715403:  "UNSPECIFIED_MODE",
	}
	InstanceGroupManagerTargetSizePolicy_Mode_value = map[string]int32{
		"UNDEFINED_MODE":   0,
		"BULK":             2050322,
		"INDIVIDUAL":       438800025,
		"UNSPECIFIED_MODE": 53715403,
	}
)

func (x InstanceGroupManagerTargetSizePolicy_Mode) Enum() *InstanceGroupManagerTargetSizePolicy_Mode {
	p := new(InstanceGroupManagerTargetSizePolicy_Mode)
	*p = x
	return p
}

func (x InstanceGroupManagerTargetSizePolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerTargetSizePolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[148].Descriptor()
}

func (InstanceGroupManagerTargetSizePolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[148]
}

func (x InstanceGroupManagerTargetSizePolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerTargetSizePolicy_Mode.Descriptor instead.
func (InstanceGroupManagerTargetSizePolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{771, 0}
}

// The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// PROACTIVE
type InstanceGroupManagerUpdatePolicy_InstanceRedistributionType int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE InstanceGroupManagerUpdatePolicy_InstanceRedistributionType = 0
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_InstanceRedistributionType.
var (
	InstanceGroupManagerUpdatePolicy_InstanceRedistributionType_name = map[int32]string{
		0: "UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE",
	}
	InstanceGroupManagerUpdatePolicy_InstanceRedistributionType_value = map[string]int32{
		"UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE": 0,
	}
)

func (x InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) Enum() *InstanceGroupManagerUpdatePolicy_InstanceRedistributionType {
	p := new(InstanceGroupManagerUpdatePolicy_InstanceRedistributionType)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[149].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[149]
}

func (x InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_InstanceRedistributionType.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{772, 0}
}

// Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type InstanceGroupManagerUpdatePolicy_MinimalAction int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_MINIMAL_ACTION InstanceGroupManagerUpdatePolicy_MinimalAction = 0
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_MinimalAction.
var (
	InstanceGroupManagerUpdatePolicy_MinimalAction_name = map[int32]string{
		0: "UNDEFINED_MINIMAL_ACTION",
	}
	InstanceGroupManagerUpdatePolicy_MinimalAction_value = map[string]int32{
		"UNDEFINED_MINIMAL_ACTION": 0,
	}
)

func (x InstanceGroupManagerUpdatePolicy_MinimalAction) Enum() *InstanceGroupManagerUpdatePolicy_MinimalAction {
	p := new(InstanceGroupManagerUpdatePolicy_MinimalAction)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_MinimalAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_MinimalAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[150].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_MinimalAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[150]
}

func (x InstanceGroupManagerUpdatePolicy_MinimalAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_MinimalAction.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_MinimalAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{772, 1}
}

// Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to avoid restarting the VM and to limit disruption as much as possible. RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction = 0
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction.
var (
	InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction_name = map[int32]string{
		0: "UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION",
	}
	InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction_value = map[string]int32{
		"UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION": 0,
	}
)

func (x InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) Enum() *InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction {
	p := new(InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[151].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[151]
}

func (x InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{772, 2}
}

// What action should be used to replace instances. See minimal_action.REPLACE
type InstanceGroupManagerUpdatePolicy_ReplacementMethod int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_REPLACEMENT_METHOD InstanceGroupManagerUpdatePolicy_ReplacementMethod = 0
	// Instances will be recreated (with the same name)
	InstanceGroupManagerUpdatePolicy_RECREATE InstanceGroupManagerUpdatePolicy_ReplacementMethod = 522644719
	// Default option: instances will be deleted and created (with a new name)
	InstanceGroupManagerUpdatePolicy_SUBSTITUTE InstanceGroupManagerUpdatePolicy_ReplacementMethod = 280924314
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_ReplacementMethod.
var (
	InstanceGroupManagerUpdatePolicy_ReplacementMethod_name = map[int32]string{
		0:         "UNDEFINED_REPLACEMENT_METHOD",
		522644719: "RECREATE",
		280924314: "SUBSTITUTE",
	}
	InstanceGroupManagerUpdatePolicy_ReplacementMethod_value = map[string]int32{
		"UNDEFINED_REPLACEMENT_METHOD": 0,
		"RECREATE":                     522644719,
		"SUBSTITUTE":                   280924314,
	}
)

func (x InstanceGroupManagerUpdatePolicy_ReplacementMethod) Enum() *InstanceGroupManagerUpdatePolicy_ReplacementMethod {
	p := new(InstanceGroupManagerUpdatePolicy_ReplacementMethod)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_ReplacementMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_ReplacementMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[152].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_ReplacementMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[152]
}

func (x InstanceGroupManagerUpdatePolicy_ReplacementMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_ReplacementMethod.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_ReplacementMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{772, 3}
}

// The type of update process. You can specify either PROACTIVE so that the MIG automatically updates VMs to the latest configurations or OPPORTUNISTIC so that you can select the VMs that you want to update.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// PROACTIVE
type InstanceGroupManagerUpdatePolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_TYPE InstanceGroupManagerUpdatePolicy_Type = 0
	// MIG will apply new configurations to existing VMs only when you selectively target specific or all VMs to be updated.
	InstanceGroupManagerUpdatePolicy_OPPORTUNISTIC InstanceGroupManagerUpdatePolicy_Type = 429530089
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_Type.
var (
	InstanceGroupManagerUpdatePolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		429530089: "OPPORTUNISTIC",
	}
	InstanceGroupManagerUpdatePolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"OPPORTUNISTIC":  429530089,
	}
)

func (x InstanceGroupManagerUpdatePolicy_Type) Enum() *InstanceGroupManagerUpdatePolicy_Type {
	p := new(InstanceGroupManagerUpdatePolicy_Type)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[153].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[153]
}

func (x InstanceGroupManagerUpdatePolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_Type.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{772, 4}
}

// The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type InstanceGroupManagersApplyUpdatesRequest_MinimalAction int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagersApplyUpdatesRequest_UNDEFINED_MINIMAL_ACTION InstanceGroupManagersApplyUpdatesRequest_MinimalAction = 0
)

// Enum value maps for InstanceGroupManagersApplyUpdatesRequest_MinimalAction.
var (
	InstanceGroupManagersApplyUpdatesRequest_MinimalAction_name = map[int32]string{
		0: "UNDEFINED_MINIMAL_ACTION",
	}
	InstanceGroupManagersApplyUpdatesRequest_MinimalAction_value = map[string]int32{
		"UNDEFINED_MINIMAL_ACTION": 0,
	}
)

func (x InstanceGroupManagersApplyUpdatesRequest_MinimalAction) Enum() *InstanceGroupManagersApplyUpdatesRequest_MinimalAction {
	p := new(InstanceGroupManagersApplyUpdatesRequest_MinimalAction)
	*p = x
	return p
}

func (x InstanceGroupManagersApplyUpdatesRequest_MinimalAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagersApplyUpdatesRequest_MinimalAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[154].Descriptor()
}

func (InstanceGroupManagersApplyUpdatesRequest_MinimalAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[154]
}

func (x InstanceGroupManagersApplyUpdatesRequest_MinimalAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagersApplyUpdatesRequest_MinimalAction.Descriptor instead.
func (InstanceGroupManagersApplyUpdatesRequest_MinimalAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{775, 0}
}

// The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagersApplyUpdatesRequest_UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction = 0
)

// Enum value maps for InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction.
var (
	InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction_name = map[int32]string{
		0: "UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION",
	}
	InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction_value = map[string]int32{
		"UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION": 0,
	}
)

func (x InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Enum() *InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction {
	p := new(InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction)
	*p = x
	return p
}

func (x InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[155].Descriptor()
}

func (InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[155]
}

func (x InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction.Descriptor instead.
func (InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{775, 1}
}

// A filter for the state of the instances in the instance group. Valid options are ALL or RUNNING. If you do not specify this parameter the list includes all instances regardless of their state.
type InstanceGroupsListInstancesRequest_InstanceState int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupsListInstancesRequest_UNDEFINED_INSTANCE_STATE InstanceGroupsListInstancesRequest_InstanceState = 0
	// Includes all instances in the generated list regardless of their state.
	InstanceGroupsListInstancesRequest_ALL InstanceGroupsListInstancesRequest_InstanceState = 64897
	// Includes instances in the generated list only if they have a RUNNING state.
	InstanceGroupsListInstancesRequest_RUNNING InstanceGroupsListInstancesRequest_InstanceState = 121282975
)

// Enum value maps for InstanceGroupsListInstancesRequest_InstanceState.
var (
	InstanceGroupsListInstancesRequest_InstanceState_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_STATE",
		64897:     "ALL",
		121282975: "RUNNING",
	}
	InstanceGroupsListInstancesRequest_InstanceState_value = map[string]int32{
		"UNDEFINED_INSTANCE_STATE": 0,
		"ALL":                      64897,
		"RUNNING":                  121282975,
	}
)

func (x InstanceGroupsListInstancesRequest_InstanceState) Enum() *InstanceGroupsListInstancesRequest_InstanceState {
	p := new(InstanceGroupsListInstancesRequest_InstanceState)
	*p = x
	return p
}

func (x InstanceGroupsListInstancesRequest_InstanceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupsListInstancesRequest_InstanceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[156].Descriptor()
}

func (InstanceGroupsListInstancesRequest_InstanceState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[156]
}

func (x InstanceGroupsListInstancesRequest_InstanceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupsListInstancesRequest_InstanceState.Descriptor instead.
func (InstanceGroupsListInstancesRequest_InstanceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{796, 0}
}

// [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
type InstanceManagedByIgmErrorInstanceActionDetails_Action int32

const (
	// A value indicating that the enum field is not set.
	InstanceManagedByIgmErrorInstanceActionDetails_UNDEFINED_ACTION InstanceManagedByIgmErrorInstanceActionDetails_Action = 0
	// The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
	InstanceManagedByIgmErrorInstanceActionDetails_ABANDONING InstanceManagedByIgmErrorInstanceActionDetails_Action = 388244813
	// The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
	InstanceManagedByIgmErrorInstanceActionDetails_CREATING InstanceManagedByIgmErrorInstanceActionDetails_Action = 455564985
	// The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased.
	InstanceManagedByIgmErrorInstanceActionDetails_CREATING_WITHOUT_RETRIES InstanceManagedByIgmErrorInstanceActionDetails_Action = 428843785
	// The managed instance group is permanently deleting this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_DELETING InstanceManagedByIgmErrorInstanceActionDetails_Action = 528602024
	// The managed instance group has not scheduled any actions for this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_NONE InstanceManagedByIgmErrorInstanceActionDetails_Action = 2402104
	// The managed instance group is recreating this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_RECREATING InstanceManagedByIgmErrorInstanceActionDetails_Action = 287278572
	// The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
	InstanceManagedByIgmErrorInstanceActionDetails_REFRESHING InstanceManagedByIgmErrorInstanceActionDetails_Action = 163266343
	// The managed instance group is restarting this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_RESTARTING InstanceManagedByIgmErrorInstanceActionDetails_Action = 320534387
	// The managed instance group is resuming this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_RESUMING InstanceManagedByIgmErrorInstanceActionDetails_Action = 446856618
	// The managed instance group is starting this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_STARTING InstanceManagedByIgmErrorInstanceActionDetails_Action = 488820800
	// The managed instance group is stopping this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_STOPPING InstanceManagedByIgmErrorInstanceActionDetails_Action = 350791796
	// The managed instance group is suspending this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_SUSPENDING InstanceManagedByIgmErrorInstanceActionDetails_Action = 514206246
	// The managed instance group is verifying this already created instance. Verification happens every time the instance is (re)created or restarted and consists of: 1. Waiting until health check specified as part of this managed instance group's autohealing policy reports HEALTHY. Note: Applies only if autohealing policy has a health check specified 2. Waiting for addition verification steps performed as post-instance creation (subject to future extensions).
	InstanceManagedByIgmErrorInstanceActionDetails_VERIFYING InstanceManagedByIgmErrorInstanceActionDetails_Action = 16982185
)

// Enum value maps for InstanceManagedByIgmErrorInstanceActionDetails_Action.
var (
	InstanceManagedByIgmErrorInstanceActionDetails_Action_name = map[int32]string{
		0:         "UNDEFINED_ACTION",
		388244813: "ABANDONING",
		455564985: "CREATING",
		428843785: "CREATING_WITHOUT_RETRIES",
		528602024: "DELETING",
		2402104:   "NONE",
		287278572: "RECREATING",
		163266343: "REFRESHING",
		320534387: "RESTARTING",
		446856618: "RESUMING",
		488820800: "STARTING",
		350791796: "STOPPING",
		514206246: "SUSPENDING",
		16982185:  "VERIFYING",
	}
	InstanceManagedByIgmErrorInstanceActionDetails_Action_value = map[string]int32{
		"UNDEFINED_ACTION":         0,
		"ABANDONING":               388244813,
		"CREATING":                 455564985,
		"CREATING_WITHOUT_RETRIES": 428843785,
		"DELETING":                 528602024,
		"NONE":                     2402104,
		"RECREATING":               287278572,
		"REFRESHING":               163266343,
		"RESTARTING":               320534387,
		"RESUMING":                 446856618,
		"STARTING":                 488820800,
		"STOPPING":                 350791796,
		"SUSPENDING":               514206246,
		"VERIFYING":                16982185,
	}
)

func (x InstanceManagedByIgmErrorInstanceActionDetails_Action) Enum() *InstanceManagedByIgmErrorInstanceActionDetails_Action {
	p := new(InstanceManagedByIgmErrorInstanceActionDetails_Action)
	*p = x
	return p
}

func (x InstanceManagedByIgmErrorInstanceActionDetails_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceManagedByIgmErrorInstanceActionDetails_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[157].Descriptor()
}

func (InstanceManagedByIgmErrorInstanceActionDetails_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[157]
}

func (x InstanceManagedByIgmErrorInstanceActionDetails_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceManagedByIgmErrorInstanceActionDetails_Action.Descriptor instead.
func (InstanceManagedByIgmErrorInstanceActionDetails_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{803, 0}
}

// KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
type InstanceProperties_KeyRevocationActionType int32

const (
	// A value indicating that the enum field is not set.
	InstanceProperties_UNDEFINED_KEY_REVOCATION_ACTION_TYPE InstanceProperties_KeyRevocationActionType = 0
	// Default value. This value is unused.
	InstanceProperties_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED InstanceProperties_KeyRevocationActionType = 467110106
	// Indicates user chose no operation.
	InstanceProperties_NONE InstanceProperties_KeyRevocationActionType = 2402104
	// Indicates user chose to opt for VM shutdown on key revocation.
	InstanceProperties_STOP InstanceProperties_KeyRevocationActionType = 2555906
)

// Enum value maps for InstanceProperties_KeyRevocationActionType.
var (
	InstanceProperties_KeyRevocationActionType_name = map[int32]string{
		0:         "UNDEFINED_KEY_REVOCATION_ACTION_TYPE",
		467110106: "KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED",
		2402104:   "NONE",
		2555906:   "STOP",
	}
	InstanceProperties_KeyRevocationActionType_value = map[string]int32{
		"UNDEFINED_KEY_REVOCATION_ACTION_TYPE":   0,
		"KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED": 467110106,
		"NONE":                                   2402104,
		"STOP":                                   2555906,
	}
)

func (x InstanceProperties_KeyRevocationActionType) Enum() *InstanceProperties_KeyRevocationActionType {
	p := new(InstanceProperties_KeyRevocationActionType)
	*p = x
	return p
}

func (x InstanceProperties_KeyRevocationActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceProperties_KeyRevocationActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[158].Descriptor()
}

func (InstanceProperties_KeyRevocationActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[158]
}

func (x InstanceProperties_KeyRevocationActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceProperties_KeyRevocationActionType.Descriptor instead.
func (InstanceProperties_KeyRevocationActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{807, 0}
}

// PostKeyRevocationActionType of the instance.
type InstanceProperties_PostKeyRevocationActionType int32

const (
	// A value indicating that the enum field is not set.
	InstanceProperties_UNDEFINED_POST_KEY_REVOCATION_ACTION_TYPE InstanceProperties_PostKeyRevocationActionType = 0
	// Indicates user chose no operation.
	InstanceProperties_NOOP InstanceProperties_PostKeyRevocationActionType = 2402146
	// Default value. This value is unused.
	InstanceProperties_POST_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED InstanceProperties_PostKeyRevocationActionType = 228738393
	// Indicates user chose to opt for VM shutdown on key revocation.
	InstanceProperties_SHUTDOWN InstanceProperties_PostKeyRevocationActionType = 76412502
)

// Enum value maps for InstanceProperties_PostKeyRevocationActionType.
var (
	InstanceProperties_PostKeyRevocationActionType_name = map[int32]string{
		0:         "UNDEFINED_POST_KEY_REVOCATION_ACTION_TYPE",
		2402146:   "NOOP",
		228738393: "POST_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED",
		76412502:  "SHUTDOWN",
	}
	InstanceProperties_PostKeyRevocationActionType_value = map[string]int32{
		"UNDEFINED_POST_KEY_REVOCATION_ACTION_TYPE": 0,
		"NOOP": 2402146,
		"POST_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED": 228738393,
		"SHUTDOWN": 76412502,
	}
)

func (x InstanceProperties_PostKeyRevocationActionType) Enum() *InstanceProperties_PostKeyRevocationActionType {
	p := new(InstanceProperties_PostKeyRevocationActionType)
	*p = x
	return p
}

func (x InstanceProperties_PostKeyRevocationActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceProperties_PostKeyRevocationActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[159].Descriptor()
}

func (InstanceProperties_PostKeyRevocationActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[159]
}

func (x InstanceProperties_PostKeyRevocationActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceProperties_PostKeyRevocationActionType.Descriptor instead.
func (InstanceProperties_PostKeyRevocationActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{807, 1}
}

// The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
type InstanceProperties_PrivateIpv6GoogleAccess int32

const (
	// A value indicating that the enum field is not set.
	InstanceProperties_UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS InstanceProperties_PrivateIpv6GoogleAccess = 0
	// Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
	InstanceProperties_ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE InstanceProperties_PrivateIpv6GoogleAccess = 427975994
	// Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
	InstanceProperties_ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE InstanceProperties_PrivateIpv6GoogleAccess = 288210263
	// Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
	InstanceProperties_INHERIT_FROM_SUBNETWORK InstanceProperties_PrivateIpv6GoogleAccess = 530256959
)

// Enum value maps for InstanceProperties_PrivateIpv6GoogleAccess.
var (
	InstanceProperties_PrivateIpv6GoogleAccess_name = map[int32]string{
		0:         "UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS",
		427975994: "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE",
		288210263: "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE",
		530256959: "INHERIT_FROM_SUBNETWORK",
	}
	InstanceProperties_PrivateIpv6GoogleAccess_value = map[string]int32{
		"UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS":  0,
		"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE": 427975994,
		"ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE":   288210263,
		"INHERIT_FROM_SUBNETWORK":               530256959,
	}
)

func (x InstanceProperties_PrivateIpv6GoogleAccess) Enum() *InstanceProperties_PrivateIpv6GoogleAccess {
	p := new(InstanceProperties_PrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x InstanceProperties_PrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceProperties_PrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[160].Descriptor()
}

func (InstanceProperties_PrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[160]
}

func (x InstanceProperties_PrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceProperties_PrivateIpv6GoogleAccess.Descriptor instead.
func (InstanceProperties_PrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{807, 2}
}

// [Output Only] The status of the instance.
type InstanceWithNamedPorts_Status int32

const (
	// A value indicating that the enum field is not set.
	InstanceWithNamedPorts_UNDEFINED_STATUS InstanceWithNamedPorts_Status = 0
	// The instance is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
	InstanceWithNamedPorts_DEPROVISIONING InstanceWithNamedPorts_Status = 428935662
	// For Flex Start provisioning instance is waiting for available capacity from Dynamic Workload Scheduler (DWS).
	InstanceWithNamedPorts_PENDING InstanceWithNamedPorts_Status = 35394935
	// The instance is gracefully shutting down.
	InstanceWithNamedPorts_PENDING_STOP InstanceWithNamedPorts_Status = 362509770
	// Resources are being allocated for the instance.
	InstanceWithNamedPorts_PROVISIONING InstanceWithNamedPorts_Status = 290896621
	// The instance is in repair.
	InstanceWithNamedPorts_REPAIRING InstanceWithNamedPorts_Status = 413483285
	// The instance is running.
	InstanceWithNamedPorts_RUNNING InstanceWithNamedPorts_Status = 121282975
	// All required resources have been allocated and the instance is being started.
	InstanceWithNamedPorts_STAGING InstanceWithNamedPorts_Status = 431072283
	// The instance has stopped successfully.
	InstanceWithNamedPorts_STOPPED InstanceWithNamedPorts_Status = 444276141
	// The instance is currently stopping (either being deleted or killed).
	InstanceWithNamedPorts_STOPPING InstanceWithNamedPorts_Status = 350791796
	// The instance has suspended.
	InstanceWithNamedPorts_SUSPENDED InstanceWithNamedPorts_Status = 51223995
	// The instance is suspending.
	InstanceWithNamedPorts_SUSPENDING InstanceWithNamedPorts_Status = 514206246
	// The instance has stopped (either by explicit action or underlying failure).
	InstanceWithNamedPorts_TERMINATED InstanceWithNamedPorts_Status = 250018339
)

// Enum value maps for InstanceWithNamedPorts_Status.
var (
	InstanceWithNamedPorts_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		428935662: "DEPROVISIONING",
		35394935:  "PENDING",
		362509770: "PENDING_STOP",
		290896621: "PROVISIONING",
		413483285: "REPAIRING",
		121282975: "RUNNING",
		431072283: "STAGING",
		444276141: "STOPPED",
		350791796: "STOPPING",
		51223995:  "SUSPENDED",
		514206246: "SUSPENDING",
		250018339: "TERMINATED",
	}
	InstanceWithNamedPorts_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DEPROVISIONING":   428935662,
		"PENDING":          35394935,
		"PENDING_STOP":     362509770,
		"PROVISIONING":     290896621,
		"REPAIRING":        413483285,
		"RUNNING":          121282975,
		"STAGING":          431072283,
		"STOPPED":          444276141,
		"STOPPING":         350791796,
		"SUSPENDED":        51223995,
		"SUSPENDING":       514206246,
		"TERMINATED":       250018339,
	}
)

func (x InstanceWithNamedPorts_Status) Enum() *InstanceWithNamedPorts_Status {
	p := new(InstanceWithNamedPorts_Status)
	*p = x
	return p
}

func (x InstanceWithNamedPorts_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceWithNamedPorts_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[161].Descriptor()
}

func (InstanceWithNamedPorts_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[161]
}

func (x InstanceWithNamedPorts_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceWithNamedPorts_Status.Descriptor instead.
func (InstanceWithNamedPorts_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{816, 0}
}

// [Output Only] The type of the firewall policy. Can be one of HIERARCHY, NETWORK, NETWORK_REGIONAL, SYSTEM_GLOBAL, SYSTEM_REGIONAL.
type InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNDEFINED_TYPE   InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 0
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_HIERARCHY        InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 69902869
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK          InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 413984270
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK_REGIONAL InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 190804272
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_SYSTEM_GLOBAL    InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 60099507
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_SYSTEM_REGIONAL  InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 161777199
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNSPECIFIED      InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 526786327
)

// Enum value maps for InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.
var (
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		69902869:  "HIERARCHY",
		413984270: "NETWORK",
		190804272: "NETWORK_REGIONAL",
		60099507:  "SYSTEM_GLOBAL",
		161777199: "SYSTEM_REGIONAL",
		526786327: "UNSPECIFIED",
	}
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"HIERARCHY":        69902869,
		"NETWORK":          413984270,
		"NETWORK_REGIONAL": 190804272,
		"SYSTEM_GLOBAL":    60099507,
		"SYSTEM_REGIONAL":  161777199,
		"UNSPECIFIED":      526786327,
	}
)

func (x InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Enum() *InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type {
	p := new(InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type)
	*p = x
	return p
}

func (x InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[162].Descriptor()
}

func (InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[162]
}

func (x InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.Descriptor instead.
func (InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{820, 0}
}

// The disruption schedule for the VM. Required field, only allows IMMEDIATE.
type InstancesReportHostAsFaultyRequest_DisruptionSchedule int32

const (
	// A value indicating that the enum field is not set.
	InstancesReportHostAsFaultyRequest_UNDEFINED_DISRUPTION_SCHEDULE InstancesReportHostAsFaultyRequest_DisruptionSchedule = 0
	// Not used. Required as per aip/126.
	InstancesReportHostAsFaultyRequest_DISRUPTION_SCHEDULE_UNSPECIFIED InstancesReportHostAsFaultyRequest_DisruptionSchedule = 332543835
	// Delay disruption for caller control. Will be default soon.
	InstancesReportHostAsFaultyRequest_FUTURE InstancesReportHostAsFaultyRequest_DisruptionSchedule = 474513859
	// Default value. Disrupt the VM immediately.
	InstancesReportHostAsFaultyRequest_IMMEDIATE InstancesReportHostAsFaultyRequest_DisruptionSchedule = 152881041
)

// Enum value maps for InstancesReportHostAsFaultyRequest_DisruptionSchedule.
var (
	InstancesReportHostAsFaultyRequest_DisruptionSchedule_name = map[int32]string{
		0:         "UNDEFINED_DISRUPTION_SCHEDULE",
		332543835: "DISRUPTION_SCHEDULE_UNSPECIFIED",
		474513859: "FUTURE",
		152881041: "IMMEDIATE",
	}
	InstancesReportHostAsFaultyRequest_DisruptionSchedule_value = map[string]int32{
		"UNDEFINED_DISRUPTION_SCHEDULE":   0,
		"DISRUPTION_SCHEDULE_UNSPECIFIED": 332543835,
		"FUTURE":                          474513859,
		"IMMEDIATE":                       152881041,
	}
)

func (x InstancesReportHostAsFaultyRequest_DisruptionSchedule) Enum() *InstancesReportHostAsFaultyRequest_DisruptionSchedule {
	p := new(InstancesReportHostAsFaultyRequest_DisruptionSchedule)
	*p = x
	return p
}

func (x InstancesReportHostAsFaultyRequest_DisruptionSchedule) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstancesReportHostAsFaultyRequest_DisruptionSchedule) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[163].Descriptor()
}

func (InstancesReportHostAsFaultyRequest_DisruptionSchedule) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[163]
}

func (x InstancesReportHostAsFaultyRequest_DisruptionSchedule) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstancesReportHostAsFaultyRequest_DisruptionSchedule.Descriptor instead.
func (InstancesReportHostAsFaultyRequest_DisruptionSchedule) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{823, 0}
}

type InstancesReportHostAsFaultyRequestFaultReason_Behavior int32

const (
	// A value indicating that the enum field is not set.
	InstancesReportHostAsFaultyRequestFaultReason_UNDEFINED_BEHAVIOR InstancesReportHostAsFaultyRequestFaultReason_Behavior = 0
	// Public reportable behaviors
	InstancesReportHostAsFaultyRequestFaultReason_BEHAVIOR_UNSPECIFIED    InstancesReportHostAsFaultyRequestFaultReason_Behavior = 85734570
	InstancesReportHostAsFaultyRequestFaultReason_PERFORMANCE             InstancesReportHostAsFaultyRequestFaultReason_Behavior = 135701520
	InstancesReportHostAsFaultyRequestFaultReason_SILENT_DATA_CORRUPTION  InstancesReportHostAsFaultyRequestFaultReason_Behavior = 111360678
	InstancesReportHostAsFaultyRequestFaultReason_UNRECOVERABLE_GPU_ERROR InstancesReportHostAsFaultyRequestFaultReason_Behavior = 363710747
)

// Enum value maps for InstancesReportHostAsFaultyRequestFaultReason_Behavior.
var (
	InstancesReportHostAsFaultyRequestFaultReason_Behavior_name = map[int32]string{
		0:         "UNDEFINED_BEHAVIOR",
		85734570:  "BEHAVIOR_UNSPECIFIED",
		135701520: "PERFORMANCE",
		111360678: "SILENT_DATA_CORRUPTION",
		363710747: "UNRECOVERABLE_GPU_ERROR",
	}
	InstancesReportHostAsFaultyRequestFaultReason_Behavior_value = map[string]int32{
		"UNDEFINED_BEHAVIOR":      0,
		"BEHAVIOR_UNSPECIFIED":    85734570,
		"PERFORMANCE":             135701520,
		"SILENT_DATA_CORRUPTION":  111360678,
		"UNRECOVERABLE_GPU_ERROR": 363710747,
	}
)

func (x InstancesReportHostAsFaultyRequestFaultReason_Behavior) Enum() *InstancesReportHostAsFaultyRequestFaultReason_Behavior {
	p := new(InstancesReportHostAsFaultyRequestFaultReason_Behavior)
	*p = x
	return p
}

func (x InstancesReportHostAsFaultyRequestFaultReason_Behavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstancesReportHostAsFaultyRequestFaultReason_Behavior) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[164].Descriptor()
}

func (InstancesReportHostAsFaultyRequestFaultReason_Behavior) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[164]
}

func (x InstancesReportHostAsFaultyRequestFaultReason_Behavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstancesReportHostAsFaultyRequestFaultReason_Behavior.Descriptor instead.
func (InstancesReportHostAsFaultyRequestFaultReason_Behavior) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{824, 0}
}

// [Output Only] The architecture of the instant snapshot. Valid values are ARM64 or X86_64.
type InstantSnapshot_Architecture int32

const (
	// A value indicating that the enum field is not set.
	InstantSnapshot_UNDEFINED_ARCHITECTURE InstantSnapshot_Architecture = 0
	// Default value indicating Architecture is not set.
	InstantSnapshot_ARCHITECTURE_UNSPECIFIED InstantSnapshot_Architecture = 394750507
	// Machines with architecture ARM64
	InstantSnapshot_ARM64 InstantSnapshot_Architecture = 62547450
	// Machines with architecture X86_64
	InstantSnapshot_X86_64 InstantSnapshot_Architecture = 425300551
)

// Enum value maps for InstantSnapshot_Architecture.
var (
	InstantSnapshot_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	InstantSnapshot_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x InstantSnapshot_Architecture) Enum() *InstantSnapshot_Architecture {
	p := new(InstantSnapshot_Architecture)
	*p = x
	return p
}

func (x InstantSnapshot_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstantSnapshot_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[165].Descriptor()
}

func (InstantSnapshot_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[165]
}

func (x InstantSnapshot_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstantSnapshot_Architecture.Descriptor instead.
func (InstantSnapshot_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{835, 0}
}

// [Output Only] The status of the instantSnapshot. This can be CREATING, DELETING, FAILED, or READY.
type InstantSnapshot_Status int32

const (
	// A value indicating that the enum field is not set.
	InstantSnapshot_UNDEFINED_STATUS InstantSnapshot_Status = 0
	// InstantSnapshot creation is in progress.
	InstantSnapshot_CREATING InstantSnapshot_Status = 455564985
	// InstantSnapshot is currently being deleted.
	InstantSnapshot_DELETING InstantSnapshot_Status = 528602024
	// InstantSnapshot creation failed.
	InstantSnapshot_FAILED InstantSnapshot_Status = 455706685
	// InstantSnapshot has been created successfully.
	InstantSnapshot_READY InstantSnapshot_Status = 77848963
	// InstantSnapshot is currently unavailable and cannot be used for Disk restoration
	InstantSnapshot_UNAVAILABLE InstantSnapshot_Status = 413756464
)

// Enum value maps for InstantSnapshot_Status.
var (
	InstantSnapshot_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		455706685: "FAILED",
		77848963:  "READY",
		413756464: "UNAVAILABLE",
	}
	InstantSnapshot_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"READY":            77848963,
		"UNAVAILABLE":      413756464,
	}
)

func (x InstantSnapshot_Status) Enum() *InstantSnapshot_Status {
	p := new(InstantSnapshot_Status)
	*p = x
	return p
}

func (x InstantSnapshot_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstantSnapshot_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[166].Descriptor()
}

func (InstantSnapshot_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[166]
}

func (x InstantSnapshot_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstantSnapshot_Status.Descriptor instead.
func (InstantSnapshot_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{835, 1}
}

// Additional supported values which may be not listed in the enum directly due to technical reasons:
// IF_CROSS_SITE_NETWORK
// IF_MACSEC
type Interconnect_AvailableFeatures int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_AVAILABLE_FEATURES Interconnect_AvailableFeatures = 0
)

// Enum value maps for Interconnect_AvailableFeatures.
var (
	Interconnect_AvailableFeatures_name = map[int32]string{
		0: "UNDEFINED_AVAILABLE_FEATURES",
	}
	Interconnect_AvailableFeatures_value = map[string]int32{
		"UNDEFINED_AVAILABLE_FEATURES": 0,
	}
)

func (x Interconnect_AvailableFeatures) Enum() *Interconnect_AvailableFeatures {
	p := new(Interconnect_AvailableFeatures)
	*p = x
	return p
}

func (x Interconnect_AvailableFeatures) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_AvailableFeatures) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[167].Descriptor()
}

func (Interconnect_AvailableFeatures) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[167]
}

func (x Interconnect_AvailableFeatures) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_AvailableFeatures.Descriptor instead.
func (Interconnect_AvailableFeatures) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{841, 0}
}

// Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
type Interconnect_InterconnectType int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_INTERCONNECT_TYPE Interconnect_InterconnectType = 0
	// A dedicated physical interconnection with the customer.
	Interconnect_DEDICATED Interconnect_InterconnectType = 258411983
	// [Deprecated] A private, physical interconnection with the customer.
	Interconnect_IT_PRIVATE Interconnect_InterconnectType = 335677007
	// A partner-managed interconnection shared between customers via partner.
	Interconnect_PARTNER Interconnect_InterconnectType = 461924520
)

// Enum value maps for Interconnect_InterconnectType.
var (
	Interconnect_InterconnectType_name = map[int32]string{
		0:         "UNDEFINED_INTERCONNECT_TYPE",
		258411983: "DEDICATED",
		335677007: "IT_PRIVATE",
		461924520: "PARTNER",
	}
	Interconnect_InterconnectType_value = map[string]int32{
		"UNDEFINED_INTERCONNECT_TYPE": 0,
		"DEDICATED":                   258411983,
		"IT_PRIVATE":                  335677007,
		"PARTNER":                     461924520,
	}
)

func (x Interconnect_InterconnectType) Enum() *Interconnect_InterconnectType {
	p := new(Interconnect_InterconnectType)
	*p = x
	return p
}

func (x Interconnect_InterconnectType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_InterconnectType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[168].Descriptor()
}

func (Interconnect_InterconnectType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[168]
}

func (x Interconnect_InterconnectType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_InterconnectType.Descriptor instead.
func (Interconnect_InterconnectType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{841, 1}
}

// Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
type Interconnect_LinkType int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_LINK_TYPE Interconnect_LinkType = 0
	// 100G Ethernet, LR Optics.
	Interconnect_LINK_TYPE_ETHERNET_100G_LR Interconnect_LinkType = 337672551
	// 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
	Interconnect_LINK_TYPE_ETHERNET_10G_LR Interconnect_LinkType = 236739749
	// 400G Ethernet, LR4 Optics.
	Interconnect_LINK_TYPE_ETHERNET_400G_LR4 Interconnect_LinkType = 127023690
)

// Enum value maps for Interconnect_LinkType.
var (
	Interconnect_LinkType_name = map[int32]string{
		0:         "UNDEFINED_LINK_TYPE",
		337672551: "LINK_TYPE_ETHERNET_100G_LR",
		236739749: "LINK_TYPE_ETHERNET_10G_LR",
		127023690: "LINK_TYPE_ETHERNET_400G_LR4",
	}
	Interconnect_LinkType_value = map[string]int32{
		"UNDEFINED_LINK_TYPE":         0,
		"LINK_TYPE_ETHERNET_100G_LR":  337672551,
		"LINK_TYPE_ETHERNET_10G_LR":   236739749,
		"LINK_TYPE_ETHERNET_400G_LR4": 127023690,
	}
)

func (x Interconnect_LinkType) Enum() *Interconnect_LinkType {
	p := new(Interconnect_LinkType)
	*p = x
	return p
}

func (x Interconnect_LinkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_LinkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[169].Descriptor()
}

func (Interconnect_LinkType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[169]
}

func (x Interconnect_LinkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_LinkType.Descriptor instead.
func (Interconnect_LinkType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{841, 2}
}

// [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
type Interconnect_OperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_OPERATIONAL_STATUS Interconnect_OperationalStatus = 0
	// The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
	Interconnect_OS_ACTIVE Interconnect_OperationalStatus = 55721409
	// The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
	Interconnect_OS_UNPROVISIONED Interconnect_OperationalStatus = 239771840
)

// Enum value maps for Interconnect_OperationalStatus.
var (
	Interconnect_OperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_OPERATIONAL_STATUS",
		55721409:  "OS_ACTIVE",
		239771840: "OS_UNPROVISIONED",
	}
	Interconnect_OperationalStatus_value = map[string]int32{
		"UNDEFINED_OPERATIONAL_STATUS": 0,
		"OS_ACTIVE":                    55721409,
		"OS_UNPROVISIONED":             239771840,
	}
)

func (x Interconnect_OperationalStatus) Enum() *Interconnect_OperationalStatus {
	p := new(Interconnect_OperationalStatus)
	*p = x
	return p
}

func (x Interconnect_OperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_OperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[170].Descriptor()
}

func (Interconnect_OperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[170]
}

func (x Interconnect_OperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_OperationalStatus.Descriptor instead.
func (Interconnect_OperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{841, 3}
}

// Additional supported values which may be not listed in the enum directly due to technical reasons:
// IF_CROSS_SITE_NETWORK
// IF_MACSEC
type Interconnect_RequestedFeatures int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_REQUESTED_FEATURES Interconnect_RequestedFeatures = 0
)

// Enum value maps for Interconnect_RequestedFeatures.
var (
	Interconnect_RequestedFeatures_name = map[int32]string{
		0: "UNDEFINED_REQUESTED_FEATURES",
	}
	Interconnect_RequestedFeatures_value = map[string]int32{
		"UNDEFINED_REQUESTED_FEATURES": 0,
	}
)

func (x Interconnect_RequestedFeatures) Enum() *Interconnect_RequestedFeatures {
	p := new(Interconnect_RequestedFeatures)
	*p = x
	return p
}

func (x Interconnect_RequestedFeatures) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_RequestedFeatures) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[171].Descriptor()
}

func (Interconnect_RequestedFeatures) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[171]
}

func (x Interconnect_RequestedFeatures) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_RequestedFeatures.Descriptor instead.
func (Interconnect_RequestedFeatures) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{841, 4}
}

// [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
type Interconnect_State int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_STATE Interconnect_State = 0
	// The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
	Interconnect_ACTIVE Interconnect_State = 314733318
	// The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
	Interconnect_UNPROVISIONED Interconnect_State = 517333979
)

// Enum value maps for Interconnect_State.
var (
	Interconnect_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		517333979: "UNPROVISIONED",
	}
	Interconnect_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"UNPROVISIONED":   517333979,
	}
)

func (x Interconnect_State) Enum() *Interconnect_State {
	p := new(Interconnect_State)
	*p = x
	return p
}

func (x Interconnect_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[172].Descriptor()
}

func (Interconnect_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[172]
}

func (x Interconnect_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_State.Descriptor instead.
func (Interconnect_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{841, 5}
}

// Specific subzone in the InterconnectLocation that represents where this connection is to be provisioned.
type Interconnect_Subzone int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_SUBZONE Interconnect_Subzone = 0
	// Subzone A.
	Interconnect_SUBZONE_A Interconnect_Subzone = 291575438
	// Subzone B.
	Interconnect_SUBZONE_B Interconnect_Subzone = 291575439
)

// Enum value maps for Interconnect_Subzone.
var (
	Interconnect_Subzone_name = map[int32]string{
		0:         "UNDEFINED_SUBZONE",
		291575438: "SUBZONE_A",
		291575439: "SUBZONE_B",
	}
	Interconnect_Subzone_value = map[string]int32{
		"UNDEFINED_SUBZONE": 0,
		"SUBZONE_A":         291575438,
		"SUBZONE_B":         291575439,
	}
)

func (x Interconnect_Subzone) Enum() *Interconnect_Subzone {
	p := new(Interconnect_Subzone)
	*p = x
	return p
}

func (x Interconnect_Subzone) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_Subzone) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[173].Descriptor()
}

func (Interconnect_Subzone) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[173]
}

func (x Interconnect_Subzone) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_Subzone.Descriptor instead.
func (Interconnect_Subzone) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{841, 6}
}

// TrafficClass whose bandwidth percentage is being specified.
type InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass int32

const (
	// A value indicating that the enum field is not set.
	InterconnectApplicationAwareInterconnectBandwidthPercentage_UNDEFINED_TRAFFIC_CLASS InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass = 0
	// Traffic Class 1, corresponding to DSCP ranges (0-7) 000xxx.
	InterconnectApplicationAwareInterconnectBandwidthPercentage_TC1 InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass = 82850
	// Traffic Class 2, corresponding to DSCP ranges (8-15) 001xxx.
	InterconnectApplicationAwareInterconnectBandwidthPercentage_TC2 InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass = 82851
	// Traffic Class 3, corresponding to DSCP ranges (16-23) 010xxx.
	InterconnectApplicationAwareInterconnectBandwidthPercentage_TC3 InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass = 82852
	// Traffic Class 4, corresponding to DSCP ranges (24-31) 011xxx.
	InterconnectApplicationAwareInterconnectBandwidthPercentage_TC4 InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass = 82853
	// Traffic Class 5, corresponding to DSCP ranges (32-47) 10xxxx.
	InterconnectApplicationAwareInterconnectBandwidthPercentage_TC5 InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass = 82854
	// Traffic Class 6, corresponding to DSCP ranges (48-63) 11xxxx.
	InterconnectApplicationAwareInterconnectBandwidthPercentage_TC6 InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass = 82855
)

// Enum value maps for InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass.
var (
	InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass_name = map[int32]string{
		0:     "UNDEFINED_TRAFFIC_CLASS",
		82850: "TC1",
		82851: "TC2",
		82852: "TC3",
		82853: "TC4",
		82854: "TC5",
		82855: "TC6",
	}
	InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass_value = map[string]int32{
		"UNDEFINED_TRAFFIC_CLASS": 0,
		"TC1":                     82850,
		"TC2":                     82851,
		"TC3":                     82852,
		"TC4":                     82853,
		"TC5":                     82854,
		"TC6":                     82855,
	}
)

func (x InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass) Enum() *InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass {
	p := new(InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass)
	*p = x
	return p
}

func (x InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[174].Descriptor()
}

func (InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[174]
}

func (x InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass.Descriptor instead.
func (InterconnectApplicationAwareInterconnectBandwidthPercentage_TrafficClass) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{843, 0}
}

// Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s - BPS_100G: 100 Gbit/s
type InterconnectAttachment_Bandwidth int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_BANDWIDTH InterconnectAttachment_Bandwidth = 0
	// 100 Gbit/s
	InterconnectAttachment_BPS_100G InterconnectAttachment_Bandwidth = 49547952
	// 100 Mbit/s
	InterconnectAttachment_BPS_100M InterconnectAttachment_Bandwidth = 49547958
	// 10 Gbit/s
	InterconnectAttachment_BPS_10G InterconnectAttachment_Bandwidth = 278693006
	// 1 Gbit/s
	InterconnectAttachment_BPS_1G InterconnectAttachment_Bandwidth = 355358448
	// 200 Mbit/s
	InterconnectAttachment_BPS_200M InterconnectAttachment_Bandwidth = 49577749
	// 20 Gbit/s
	InterconnectAttachment_BPS_20G InterconnectAttachment_Bandwidth = 278693967
	// 2 Gbit/s
	InterconnectAttachment_BPS_2G InterconnectAttachment_Bandwidth = 355358479
	// 300 Mbit/s
	InterconnectAttachment_BPS_300M InterconnectAttachment_Bandwidth = 49607540
	// 400 Mbit/s
	InterconnectAttachment_BPS_400M InterconnectAttachment_Bandwidth = 49637331
	// 500 Mbit/s
	InterconnectAttachment_BPS_500M InterconnectAttachment_Bandwidth = 49667122
	// 50 Gbit/s
	InterconnectAttachment_BPS_50G InterconnectAttachment_Bandwidth = 278696850
	// 50 Mbit/s
	InterconnectAttachment_BPS_50M InterconnectAttachment_Bandwidth = 278696856
	// 5 Gbit/s
	InterconnectAttachment_BPS_5G InterconnectAttachment_Bandwidth = 355358572
)

// Enum value maps for InterconnectAttachment_Bandwidth.
var (
	InterconnectAttachment_Bandwidth_name = map[int32]string{
		0:         "UNDEFINED_BANDWIDTH",
		49547952:  "BPS_100G",
		49547958:  "BPS_100M",
		278693006: "BPS_10G",
		355358448: "BPS_1G",
		49577749:  "BPS_200M",
		278693967: "BPS_20G",
		355358479: "BPS_2G",
		49607540:  "BPS_300M",
		49637331:  "BPS_400M",
		49667122:  "BPS_500M",
		278696850: "BPS_50G",
		278696856: "BPS_50M",
		355358572: "BPS_5G",
	}
	InterconnectAttachment_Bandwidth_value = map[string]int32{
		"UNDEFINED_BANDWIDTH": 0,
		"BPS_100G":            49547952,
		"BPS_100M":            49547958,
		"BPS_10G":             278693006,
		"BPS_1G":              355358448,
		"BPS_200M":            49577749,
		"BPS_20G":             278693967,
		"BPS_2G":              355358479,
		"BPS_300M":            49607540,
		"BPS_400M":            49637331,
		"BPS_500M":            49667122,
		"BPS_50G":             278696850,
		"BPS_50M":             278696856,
		"BPS_5G":              355358572,
	}
)

func (x InterconnectAttachment_Bandwidth) Enum() *InterconnectAttachment_Bandwidth {
	p := new(InterconnectAttachment_Bandwidth)
	*p = x
	return p
}

func (x InterconnectAttachment_Bandwidth) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_Bandwidth) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[175].Descriptor()
}

func (InterconnectAttachment_Bandwidth) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[175]
}

func (x InterconnectAttachment_Bandwidth) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_Bandwidth.Descriptor instead.
func (InterconnectAttachment_Bandwidth) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{846, 0}
}

// Input only. Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
type InterconnectAttachment_EdgeAvailabilityDomain int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_EDGE_AVAILABILITY_DOMAIN InterconnectAttachment_EdgeAvailabilityDomain = 0
	InterconnectAttachment_AVAILABILITY_DOMAIN_1              InterconnectAttachment_EdgeAvailabilityDomain = 349552090
	InterconnectAttachment_AVAILABILITY_DOMAIN_2              InterconnectAttachment_EdgeAvailabilityDomain = 349552091
	InterconnectAttachment_AVAILABILITY_DOMAIN_ANY            InterconnectAttachment_EdgeAvailabilityDomain = 375256373
)

// Enum value maps for InterconnectAttachment_EdgeAvailabilityDomain.
var (
	InterconnectAttachment_EdgeAvailabilityDomain_name = map[int32]string{
		0:         "UNDEFINED_EDGE_AVAILABILITY_DOMAIN",
		349552090: "AVAILABILITY_DOMAIN_1",
		349552091: "AVAILABILITY_DOMAIN_2",
		375256373: "AVAILABILITY_DOMAIN_ANY",
	}
	InterconnectAttachment_EdgeAvailabilityDomain_value = map[string]int32{
		"UNDEFINED_EDGE_AVAILABILITY_DOMAIN": 0,
		"AVAILABILITY_DOMAIN_1":              349552090,
		"AVAILABILITY_DOMAIN_2":              349552091,
		"AVAILABILITY_DOMAIN_ANY":            375256373,
	}
)

func (x InterconnectAttachment_EdgeAvailabilityDomain) Enum() *InterconnectAttachment_EdgeAvailabilityDomain {
	p := new(InterconnectAttachment_EdgeAvailabilityDomain)
	*p = x
	return p
}

func (x InterconnectAttachment_EdgeAvailabilityDomain) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_EdgeAvailabilityDomain) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[176].Descriptor()
}

func (InterconnectAttachment_EdgeAvailabilityDomain) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[176]
}

func (x InterconnectAttachment_EdgeAvailabilityDomain) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_EdgeAvailabilityDomain.Descriptor instead.
func (InterconnectAttachment_EdgeAvailabilityDomain) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{846, 1}
}

// Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
type InterconnectAttachment_Encryption int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_ENCRYPTION InterconnectAttachment_Encryption = 0
	// The interconnect attachment will carry only encrypted traffic that is encrypted by an IPsec device such as HA VPN gateway; VMs cannot directly send traffic to or receive traffic from such an interconnect attachment. To use HA VPN over Cloud Interconnect, the interconnect attachment must be created with this option.
	InterconnectAttachment_IPSEC InterconnectAttachment_Encryption = 69882282
	// This is the default value, which means the Interconnect Attachment will carry unencrypted traffic. VMs will be able to send traffic to or receive traffic from such interconnect attachment.
	InterconnectAttachment_NONE InterconnectAttachment_Encryption = 2402104
)

// Enum value maps for InterconnectAttachment_Encryption.
var (
	InterconnectAttachment_Encryption_name = map[int32]string{
		0:        "UNDEFINED_ENCRYPTION",
		69882282: "IPSEC",
		2402104:  "NONE",
	}
	InterconnectAttachment_Encryption_value = map[string]int32{
		"UNDEFINED_ENCRYPTION": 0,
		"IPSEC":                69882282,
		"NONE":                 2402104,
	}
)

func (x InterconnectAttachment_Encryption) Enum() *InterconnectAttachment_Encryption {
	p := new(InterconnectAttachment_Encryption)
	*p = x
	return p
}

func (x InterconnectAttachment_Encryption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_Encryption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[177].Descriptor()
}

func (InterconnectAttachment_Encryption) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[177]
}

func (x InterconnectAttachment_Encryption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_Encryption.Descriptor instead.
func (InterconnectAttachment_Encryption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{846, 2}
}

// [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
type InterconnectAttachment_OperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_OPERATIONAL_STATUS InterconnectAttachment_OperationalStatus = 0
	// Indicates that attachment has been turned up and is ready to use.
	InterconnectAttachment_OS_ACTIVE InterconnectAttachment_OperationalStatus = 55721409
	// Indicates that attachment is not ready to use yet, because turnup is not complete.
	InterconnectAttachment_OS_UNPROVISIONED InterconnectAttachment_OperationalStatus = 239771840
)

// Enum value maps for InterconnectAttachment_OperationalStatus.
var (
	InterconnectAttachment_OperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_OPERATIONAL_STATUS",
		55721409:  "OS_ACTIVE",
		239771840: "OS_UNPROVISIONED",
	}
	InterconnectAttachment_OperationalStatus_value = map[string]int32{
		"UNDEFINED_OPERATIONAL_STATUS": 0,
		"OS_ACTIVE":                    55721409,
		"OS_UNPROVISIONED":             239771840,
	}
)

func (x InterconnectAttachment_OperationalStatus) Enum() *InterconnectAttachment_OperationalStatus {
	p := new(InterconnectAttachment_OperationalStatus)
	*p = x
	return p
}

func (x InterconnectAttachment_OperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_OperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[178].Descriptor()
}

func (InterconnectAttachment_OperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[178]
}

func (x InterconnectAttachment_OperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_OperationalStatus.Descriptor instead.
func (InterconnectAttachment_OperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{846, 3}
}

// The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
type InterconnectAttachment_StackType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_STACK_TYPE InterconnectAttachment_StackType = 0
	// The interconnect attachment can have both IPv4 and IPv6 addresses.
	InterconnectAttachment_IPV4_IPV6 InterconnectAttachment_StackType = 22197249
	// The interconnect attachment will only be assigned IPv4 addresses.
	InterconnectAttachment_IPV4_ONLY InterconnectAttachment_StackType = 22373798
)

// Enum value maps for InterconnectAttachment_StackType.
var (
	InterconnectAttachment_StackType_name = map[int32]string{
		0:        "UNDEFINED_STACK_TYPE",
		22197249: "IPV4_IPV6",
		22373798: "IPV4_ONLY",
	}
	InterconnectAttachment_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE": 0,
		"IPV4_IPV6":            22197249,
		"IPV4_ONLY":            22373798,
	}
)

func (x InterconnectAttachment_StackType) Enum() *InterconnectAttachment_StackType {
	p := new(InterconnectAttachment_StackType)
	*p = x
	return p
}

func (x InterconnectAttachment_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[179].Descriptor()
}

func (InterconnectAttachment_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[179]
}

func (x InterconnectAttachment_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_StackType.Descriptor instead.
func (InterconnectAttachment_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{846, 4}
}

// [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
type InterconnectAttachment_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_STATE InterconnectAttachment_State = 0
	// Indicates that attachment has been turned up and is ready to use.
	InterconnectAttachment_ACTIVE InterconnectAttachment_State = 314733318
	// The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was wiped out, or because the other side of a Partner attachment was deleted.
	InterconnectAttachment_DEFUNCT InterconnectAttachment_State = 115891759
	// A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
	InterconnectAttachment_PARTNER_REQUEST_RECEIVED InterconnectAttachment_State = 513587304
	// PARTNER or PARTNER_PROVIDER attachment that is waiting for the customer to activate.
	InterconnectAttachment_PENDING_CUSTOMER InterconnectAttachment_State = 167494054
	// A newly created PARTNER attachment that has not yet been configured on the Partner side.
	InterconnectAttachment_PENDING_PARTNER   InterconnectAttachment_State = 387890656
	InterconnectAttachment_STATE_UNSPECIFIED InterconnectAttachment_State = 470755401
	// Indicates that attachment is not ready to use yet, because turnup is not complete.
	InterconnectAttachment_UNPROVISIONED InterconnectAttachment_State = 517333979
)

// Enum value maps for InterconnectAttachment_State.
var (
	InterconnectAttachment_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		115891759: "DEFUNCT",
		513587304: "PARTNER_REQUEST_RECEIVED",
		167494054: "PENDING_CUSTOMER",
		387890656: "PENDING_PARTNER",
		470755401: "STATE_UNSPECIFIED",
		517333979: "UNPROVISIONED",
	}
	InterconnectAttachment_State_value = map[string]int32{
		"UNDEFINED_STATE":          0,
		"ACTIVE":                   314733318,
		"DEFUNCT":                  115891759,
		"PARTNER_REQUEST_RECEIVED": 513587304,
		"PENDING_CUSTOMER":         167494054,
		"PENDING_PARTNER":          387890656,
		"STATE_UNSPECIFIED":        470755401,
		"UNPROVISIONED":            517333979,
	}
)

func (x InterconnectAttachment_State) Enum() *InterconnectAttachment_State {
	p := new(InterconnectAttachment_State)
	*p = x
	return p
}

func (x InterconnectAttachment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[180].Descriptor()
}

func (InterconnectAttachment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[180]
}

func (x InterconnectAttachment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_State.Descriptor instead.
func (InterconnectAttachment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{846, 5}
}

// The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
type InterconnectAttachment_Type int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_TYPE InterconnectAttachment_Type = 0
	// Attachment to a dedicated interconnect.
	InterconnectAttachment_DEDICATED InterconnectAttachment_Type = 258411983
	// Attachment to a partner interconnect, created by the customer.
	InterconnectAttachment_PARTNER InterconnectAttachment_Type = 461924520
	// Attachment to a partner interconnect, created by the partner.
	InterconnectAttachment_PARTNER_PROVIDER InterconnectAttachment_Type = 483261352
)

// Enum value maps for InterconnectAttachment_Type.
var (
	InterconnectAttachment_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		258411983: "DEDICATED",
		461924520: "PARTNER",
		483261352: "PARTNER_PROVIDER",
	}
	InterconnectAttachment_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"DEDICATED":        258411983,
		"PARTNER":          461924520,
		"PARTNER_PROVIDER": 483261352,
	}
)

func (x InterconnectAttachment_Type) Enum() *InterconnectAttachment_Type {
	p := new(InterconnectAttachment_Type)
	*p = x
	return p
}

func (x InterconnectAttachment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[181].Descriptor()
}

func (InterconnectAttachment_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[181]
}

func (x InterconnectAttachment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_Type.Descriptor instead.
func (InterconnectAttachment_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{846, 6}
}

// [Output Only] Whether the attachment's BGP session requires/allows/disallows BGP MD5 authentication. This can take one of the following values: MD5_OPTIONAL, MD5_REQUIRED, MD5_UNSUPPORTED. For example, a Cross-Cloud Interconnect connection to a remote cloud provider that requires BGP MD5 authentication has the interconnectRemoteLocation attachment_configuration_constraints.bgp_md5 field set to MD5_REQUIRED, and that property is propagated to the attachment. Similarly, if BGP MD5 is MD5_UNSUPPORTED, an error is returned if MD5 is requested.
type InterconnectAttachmentConfigurationConstraints_BgpMd5 int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachmentConfigurationConstraints_UNDEFINED_BGP_MD5 InterconnectAttachmentConfigurationConstraints_BgpMd5 = 0
	// MD5_OPTIONAL: BGP MD5 authentication is supported and can optionally be configured.
	InterconnectAttachmentConfigurationConstraints_MD5_OPTIONAL InterconnectAttachmentConfigurationConstraints_BgpMd5 = 532156673
	// MD5_REQUIRED: BGP MD5 authentication must be configured.
	InterconnectAttachmentConfigurationConstraints_MD5_REQUIRED InterconnectAttachmentConfigurationConstraints_BgpMd5 = 218034496
	// MD5_UNSUPPORTED: BGP MD5 authentication must not be configured
	InterconnectAttachmentConfigurationConstraints_MD5_UNSUPPORTED InterconnectAttachmentConfigurationConstraints_BgpMd5 = 86962388
)

// Enum value maps for InterconnectAttachmentConfigurationConstraints_BgpMd5.
var (
	InterconnectAttachmentConfigurationConstraints_BgpMd5_name = map[int32]string{
		0:         "UNDEFINED_BGP_MD5",
		532156673: "MD5_OPTIONAL",
		218034496: "MD5_REQUIRED",
		86962388:  "MD5_UNSUPPORTED",
	}
	InterconnectAttachmentConfigurationConstraints_BgpMd5_value = map[string]int32{
		"UNDEFINED_BGP_MD5": 0,
		"MD5_OPTIONAL":      532156673,
		"MD5_REQUIRED":      218034496,
		"MD5_UNSUPPORTED":   86962388,
	}
)

func (x InterconnectAttachmentConfigurationConstraints_BgpMd5) Enum() *InterconnectAttachmentConfigurationConstraints_BgpMd5 {
	p := new(InterconnectAttachmentConfigurationConstraints_BgpMd5)
	*p = x
	return p
}

func (x InterconnectAttachmentConfigurationConstraints_BgpMd5) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachmentConfigurationConstraints_BgpMd5) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[182].Descriptor()
}

func (InterconnectAttachmentConfigurationConstraints_BgpMd5) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[182]
}

func (x InterconnectAttachmentConfigurationConstraints_BgpMd5) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachmentConfigurationConstraints_BgpMd5.Descriptor instead.
func (InterconnectAttachmentConfigurationConstraints_BgpMd5) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{848, 0}
}

type InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachmentGroupConfiguredAvailabilitySLA_UNDEFINED_EFFECTIVE_SLA   InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla = 0
	InterconnectAttachmentGroupConfiguredAvailabilitySLA_EFFECTIVE_SLA_UNSPECIFIED InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla = 491000744
	InterconnectAttachmentGroupConfiguredAvailabilitySLA_NO_SLA                    InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla = 161460618
	InterconnectAttachmentGroupConfiguredAvailabilitySLA_PRODUCTION_CRITICAL       InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla = 470416485
	InterconnectAttachmentGroupConfiguredAvailabilitySLA_PRODUCTION_NON_CRITICAL   InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla = 117399223
)

// Enum value maps for InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla.
var (
	InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla_name = map[int32]string{
		0:         "UNDEFINED_EFFECTIVE_SLA",
		491000744: "EFFECTIVE_SLA_UNSPECIFIED",
		161460618: "NO_SLA",
		470416485: "PRODUCTION_CRITICAL",
		117399223: "PRODUCTION_NON_CRITICAL",
	}
	InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla_value = map[string]int32{
		"UNDEFINED_EFFECTIVE_SLA":   0,
		"EFFECTIVE_SLA_UNSPECIFIED": 491000744,
		"NO_SLA":                    161460618,
		"PRODUCTION_CRITICAL":       470416485,
		"PRODUCTION_NON_CRITICAL":   117399223,
	}
)

func (x InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla) Enum() *InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla {
	p := new(InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla)
	*p = x
	return p
}

func (x InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[183].Descriptor()
}

func (InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[183]
}

func (x InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla.Descriptor instead.
func (InterconnectAttachmentGroupConfiguredAvailabilitySLA_EffectiveSla) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{853, 0}
}

type InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_UNDEFINED_BLOCKER_TYPE           InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType = 0
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BLOCKER_TYPE_UNSPECIFIED         InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType = 429793623
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_INCOMPATIBLE_METROS              InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType = 290410432
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_INCOMPATIBLE_REGIONS             InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType = 6195033
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_MISSING_GLOBAL_ROUTING           InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType = 165913635
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_NO_ATTACHMENTS                   InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType = 456535570
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_NO_ATTACHMENTS_IN_METRO_AND_ZONE InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType = 51684135
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_OTHER                            InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType = 75532016
)

// Enum value maps for InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType.
var (
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType_name = map[int32]string{
		0:         "UNDEFINED_BLOCKER_TYPE",
		429793623: "BLOCKER_TYPE_UNSPECIFIED",
		290410432: "INCOMPATIBLE_METROS",
		6195033:   "INCOMPATIBLE_REGIONS",
		165913635: "MISSING_GLOBAL_ROUTING",
		456535570: "NO_ATTACHMENTS",
		51684135:  "NO_ATTACHMENTS_IN_METRO_AND_ZONE",
		75532016:  "OTHER",
	}
	InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType_value = map[string]int32{
		"UNDEFINED_BLOCKER_TYPE":           0,
		"BLOCKER_TYPE_UNSPECIFIED":         429793623,
		"INCOMPATIBLE_METROS":              290410432,
		"INCOMPATIBLE_REGIONS":             6195033,
		"MISSING_GLOBAL_ROUTING":           165913635,
		"NO_ATTACHMENTS":                   456535570,
		"NO_ATTACHMENTS_IN_METRO_AND_ZONE": 51684135,
		"OTHER":                            75532016,
	}
)

func (x InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType) Enum() *InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType {
	p := new(InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType)
	*p = x
	return p
}

func (x InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[184].Descriptor()
}

func (InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[184]
}

func (x InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType.Descriptor instead.
func (InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_BlockerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{854, 0}
}

type InterconnectAttachmentGroupIntent_AvailabilitySla int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachmentGroupIntent_UNDEFINED_AVAILABILITY_SLA   InterconnectAttachmentGroupIntent_AvailabilitySla = 0
	InterconnectAttachmentGroupIntent_AVAILABILITY_SLA_UNSPECIFIED InterconnectAttachmentGroupIntent_AvailabilitySla = 11186044
	InterconnectAttachmentGroupIntent_NO_SLA                       InterconnectAttachmentGroupIntent_AvailabilitySla = 161460618
	InterconnectAttachmentGroupIntent_PRODUCTION_CRITICAL          InterconnectAttachmentGroupIntent_AvailabilitySla = 470416485
	InterconnectAttachmentGroupIntent_PRODUCTION_NON_CRITICAL      InterconnectAttachmentGroupIntent_AvailabilitySla = 117399223
)

// Enum value maps for InterconnectAttachmentGroupIntent_AvailabilitySla.
var (
	InterconnectAttachmentGroupIntent_AvailabilitySla_name = map[int32]string{
		0:         "UNDEFINED_AVAILABILITY_SLA",
		11186044:  "AVAILABILITY_SLA_UNSPECIFIED",
		161460618: "NO_SLA",
		470416485: "PRODUCTION_CRITICAL",
		117399223: "PRODUCTION_NON_CRITICAL",
	}
	InterconnectAttachmentGroupIntent_AvailabilitySla_value = map[string]int32{
		"UNDEFINED_AVAILABILITY_SLA":   0,
		"AVAILABILITY_SLA_UNSPECIFIED": 11186044,
		"NO_SLA":                       161460618,
		"PRODUCTION_CRITICAL":          470416485,
		"PRODUCTION_NON_CRITICAL":      117399223,
	}
)

func (x InterconnectAttachmentGroupIntent_AvailabilitySla) Enum() *InterconnectAttachmentGroupIntent_AvailabilitySla {
	p := new(InterconnectAttachmentGroupIntent_AvailabilitySla)
	*p = x
	return p
}

func (x InterconnectAttachmentGroupIntent_AvailabilitySla) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachmentGroupIntent_AvailabilitySla) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[185].Descriptor()
}

func (InterconnectAttachmentGroupIntent_AvailabilitySla) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[185]
}

func (x InterconnectAttachmentGroupIntent_AvailabilitySla) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachmentGroupIntent_AvailabilitySla.Descriptor instead.
func (InterconnectAttachmentGroupIntent_AvailabilitySla) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{855, 0}
}

// Summarizes the status of the group.
type InterconnectAttachmentGroupsOperationalStatus_GroupStatus int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachmentGroupsOperationalStatus_UNDEFINED_GROUP_STATUS InterconnectAttachmentGroupsOperationalStatus_GroupStatus = 0
	InterconnectAttachmentGroupsOperationalStatus_DEGRADED               InterconnectAttachmentGroupsOperationalStatus_GroupStatus = 396890926
	InterconnectAttachmentGroupsOperationalStatus_FULLY_DOWN             InterconnectAttachmentGroupsOperationalStatus_GroupStatus = 255514647
	InterconnectAttachmentGroupsOperationalStatus_FULLY_UP               InterconnectAttachmentGroupsOperationalStatus_GroupStatus = 504176464
	InterconnectAttachmentGroupsOperationalStatus_UNSPECIFIED            InterconnectAttachmentGroupsOperationalStatus_GroupStatus = 526786327
)

// Enum value maps for InterconnectAttachmentGroupsOperationalStatus_GroupStatus.
var (
	InterconnectAttachmentGroupsOperationalStatus_GroupStatus_name = map[int32]string{
		0:         "UNDEFINED_GROUP_STATUS",
		396890926: "DEGRADED",
		255514647: "FULLY_DOWN",
		504176464: "FULLY_UP",
		526786327: "UNSPECIFIED",
	}
	InterconnectAttachmentGroupsOperationalStatus_GroupStatus_value = map[string]int32{
		"UNDEFINED_GROUP_STATUS": 0,
		"DEGRADED":               396890926,
		"FULLY_DOWN":             255514647,
		"FULLY_UP":               504176464,
		"UNSPECIFIED":            526786327,
	}
)

func (x InterconnectAttachmentGroupsOperationalStatus_GroupStatus) Enum() *InterconnectAttachmentGroupsOperationalStatus_GroupStatus {
	p := new(InterconnectAttachmentGroupsOperationalStatus_GroupStatus)
	*p = x
	return p
}

func (x InterconnectAttachmentGroupsOperationalStatus_GroupStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachmentGroupsOperationalStatus_GroupStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[186].Descriptor()
}

func (InterconnectAttachmentGroupsOperationalStatus_GroupStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[186]
}

func (x InterconnectAttachmentGroupsOperationalStatus_GroupStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachmentGroupsOperationalStatus_GroupStatus.Descriptor instead.
func (InterconnectAttachmentGroupsOperationalStatus_GroupStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{863, 0}
}

// Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
type InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_UNDEFINED_IS_ACTIVE InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive = 0
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_ACTIVE              InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive = 314733318
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_INACTIVE            InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive = 270421099
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_UNSPECIFIED         InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive = 526786327
)

// Enum value maps for InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive.
var (
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive_name = map[int32]string{
		0:         "UNDEFINED_IS_ACTIVE",
		314733318: "ACTIVE",
		270421099: "INACTIVE",
		526786327: "UNSPECIFIED",
	}
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive_value = map[string]int32{
		"UNDEFINED_IS_ACTIVE": 0,
		"ACTIVE":              314733318,
		"INACTIVE":            270421099,
		"UNSPECIFIED":         526786327,
	}
)

func (x InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive) Enum() *InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive {
	p := new(InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive)
	*p = x
	return p
}

func (x InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[187].Descriptor()
}

func (InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[187]
}

func (x InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive.Descriptor instead.
func (InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IsActive) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{864, 0}
}

// Whether this Attachment is active, and if so, whether BGP is up.
type InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_UNDEFINED_STATUS                  InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 0
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_ATTACHMENT_STATUS_UNKNOWN         InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 472477561
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_CONNECTION_DISABLED               InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 432687805
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_CONNECTION_DOWN                   InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 267552099
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_CONNECTION_UP                     InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 455585692
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_DEFUNCT                           InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 115891759
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IPSEC_CONFIGURATION_NEEDED_STATUS InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 455203582
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IPSEC_READY_TO_RESUME_FLOW_STATUS InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 384830596
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IPV4_DOWN_IPV6_UP                 InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 277490992
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_IPV4_UP_IPV6_DOWN                 InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 316051248
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_PARTNER_REQUEST_RECEIVED          InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 513587304
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_PENDING_CUSTOMER                  InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 167494054
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_PENDING_PARTNER                   InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 387890656
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_PROVISIONED                       InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 355751956
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_ROUTER_CONFIGURATION_BROKEN       InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 150505108
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_UNPROVISIONED                     InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status = 517333979
)

// Enum value maps for InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status.
var (
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		472477561: "ATTACHMENT_STATUS_UNKNOWN",
		432687805: "CONNECTION_DISABLED",
		267552099: "CONNECTION_DOWN",
		455585692: "CONNECTION_UP",
		115891759: "DEFUNCT",
		455203582: "IPSEC_CONFIGURATION_NEEDED_STATUS",
		384830596: "IPSEC_READY_TO_RESUME_FLOW_STATUS",
		277490992: "IPV4_DOWN_IPV6_UP",
		316051248: "IPV4_UP_IPV6_DOWN",
		513587304: "PARTNER_REQUEST_RECEIVED",
		167494054: "PENDING_CUSTOMER",
		387890656: "PENDING_PARTNER",
		355751956: "PROVISIONED",
		150505108: "ROUTER_CONFIGURATION_BROKEN",
		517333979: "UNPROVISIONED",
	}
	InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status_value = map[string]int32{
		"UNDEFINED_STATUS":                  0,
		"ATTACHMENT_STATUS_UNKNOWN":         472477561,
		"CONNECTION_DISABLED":               432687805,
		"CONNECTION_DOWN":                   267552099,
		"CONNECTION_UP":                     455585692,
		"DEFUNCT":                           115891759,
		"IPSEC_CONFIGURATION_NEEDED_STATUS": 455203582,
		"IPSEC_READY_TO_RESUME_FLOW_STATUS": 384830596,
		"IPV4_DOWN_IPV6_UP":                 277490992,
		"IPV4_UP_IPV6_DOWN":                 316051248,
		"PARTNER_REQUEST_RECEIVED":          513587304,
		"PENDING_CUSTOMER":                  167494054,
		"PENDING_PARTNER":                   387890656,
		"PROVISIONED":                       355751956,
		"ROUTER_CONFIGURATION_BROKEN":       150505108,
		"UNPROVISIONED":                     517333979,
	}
)

func (x InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status) Enum() *InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status {
	p := new(InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status)
	*p = x
	return p
}

func (x InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[188].Descriptor()
}

func (InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[188]
}

func (x InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status.Descriptor instead.
func (InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{864, 1}
}

// The aggregation type of the bundle interface.
type InterconnectDiagnostics_BundleAggregationType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnostics_UNDEFINED_BUNDLE_AGGREGATION_TYPE InterconnectDiagnostics_BundleAggregationType = 0
	// LACP is enabled.
	InterconnectDiagnostics_BUNDLE_AGGREGATION_TYPE_LACP InterconnectDiagnostics_BundleAggregationType = 27758925
	// LACP is disabled.
	InterconnectDiagnostics_BUNDLE_AGGREGATION_TYPE_STATIC InterconnectDiagnostics_BundleAggregationType = 50678873
)

// Enum value maps for InterconnectDiagnostics_BundleAggregationType.
var (
	InterconnectDiagnostics_BundleAggregationType_name = map[int32]string{
		0:        "UNDEFINED_BUNDLE_AGGREGATION_TYPE",
		27758925: "BUNDLE_AGGREGATION_TYPE_LACP",
		50678873: "BUNDLE_AGGREGATION_TYPE_STATIC",
	}
	InterconnectDiagnostics_BundleAggregationType_value = map[string]int32{
		"UNDEFINED_BUNDLE_AGGREGATION_TYPE": 0,
		"BUNDLE_AGGREGATION_TYPE_LACP":      27758925,
		"BUNDLE_AGGREGATION_TYPE_STATIC":    50678873,
	}
)

func (x InterconnectDiagnostics_BundleAggregationType) Enum() *InterconnectDiagnostics_BundleAggregationType {
	p := new(InterconnectDiagnostics_BundleAggregationType)
	*p = x
	return p
}

func (x InterconnectDiagnostics_BundleAggregationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnostics_BundleAggregationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[189].Descriptor()
}

func (InterconnectDiagnostics_BundleAggregationType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[189]
}

func (x InterconnectDiagnostics_BundleAggregationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnostics_BundleAggregationType.Descriptor instead.
func (InterconnectDiagnostics_BundleAggregationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{870, 0}
}

// The operational status of the bundle interface.
type InterconnectDiagnostics_BundleOperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnostics_UNDEFINED_BUNDLE_OPERATIONAL_STATUS InterconnectDiagnostics_BundleOperationalStatus = 0
	// If bundleAggregationType is LACP: LACP is not established and/or all links in the bundle have DOWN operational status. If bundleAggregationType is STATIC: one or more links in the bundle has DOWN operational status.
	InterconnectDiagnostics_BUNDLE_OPERATIONAL_STATUS_DOWN InterconnectDiagnostics_BundleOperationalStatus = 453842693
	// If bundleAggregationType is LACP: LACP is established and at least one link in the bundle has UP operational status. If bundleAggregationType is STATIC: all links in the bundle (typically just one) have UP operational status.
	InterconnectDiagnostics_BUNDLE_OPERATIONAL_STATUS_UP InterconnectDiagnostics_BundleOperationalStatus = 161366462
)

// Enum value maps for InterconnectDiagnostics_BundleOperationalStatus.
var (
	InterconnectDiagnostics_BundleOperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_BUNDLE_OPERATIONAL_STATUS",
		453842693: "BUNDLE_OPERATIONAL_STATUS_DOWN",
		161366462: "BUNDLE_OPERATIONAL_STATUS_UP",
	}
	InterconnectDiagnostics_BundleOperationalStatus_value = map[string]int32{
		"UNDEFINED_BUNDLE_OPERATIONAL_STATUS": 0,
		"BUNDLE_OPERATIONAL_STATUS_DOWN":      453842693,
		"BUNDLE_OPERATIONAL_STATUS_UP":        161366462,
	}
)

func (x InterconnectDiagnostics_BundleOperationalStatus) Enum() *InterconnectDiagnostics_BundleOperationalStatus {
	p := new(InterconnectDiagnostics_BundleOperationalStatus)
	*p = x
	return p
}

func (x InterconnectDiagnostics_BundleOperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnostics_BundleOperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[190].Descriptor()
}

func (InterconnectDiagnostics_BundleOperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[190]
}

func (x InterconnectDiagnostics_BundleOperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnostics_BundleOperationalStatus.Descriptor instead.
func (InterconnectDiagnostics_BundleOperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{870, 1}
}

// The state of a LACP link, which can take one of the following values: - ACTIVE: The link is configured and active within the bundle. - DETACHED: The link is not configured within the bundle. This means that the rest of the object should be empty.
type InterconnectDiagnosticsLinkLACPStatus_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnosticsLinkLACPStatus_UNDEFINED_STATE InterconnectDiagnosticsLinkLACPStatus_State = 0
	// The link is configured and active within the bundle.
	InterconnectDiagnosticsLinkLACPStatus_ACTIVE InterconnectDiagnosticsLinkLACPStatus_State = 314733318
	// The link is not configured within the bundle, this means the rest of the object should be empty.
	InterconnectDiagnosticsLinkLACPStatus_DETACHED InterconnectDiagnosticsLinkLACPStatus_State = 216562546
)

// Enum value maps for InterconnectDiagnosticsLinkLACPStatus_State.
var (
	InterconnectDiagnosticsLinkLACPStatus_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		216562546: "DETACHED",
	}
	InterconnectDiagnosticsLinkLACPStatus_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"DETACHED":        216562546,
	}
)

func (x InterconnectDiagnosticsLinkLACPStatus_State) Enum() *InterconnectDiagnosticsLinkLACPStatus_State {
	p := new(InterconnectDiagnosticsLinkLACPStatus_State)
	*p = x
	return p
}

func (x InterconnectDiagnosticsLinkLACPStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnosticsLinkLACPStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[191].Descriptor()
}

func (InterconnectDiagnosticsLinkLACPStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[191]
}

func (x InterconnectDiagnosticsLinkLACPStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnosticsLinkLACPStatus_State.Descriptor instead.
func (InterconnectDiagnosticsLinkLACPStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{872, 0}
}

// The status of the current value when compared to the warning and alarm levels for the receiving or transmitting transceiver. Possible states include: - OK: The value has not crossed a warning threshold. - LOW_WARNING: The value has crossed below the low warning threshold. - HIGH_WARNING: The value has crossed above the high warning threshold. - LOW_ALARM: The value has crossed below the low alarm threshold. - HIGH_ALARM: The value has crossed above the high alarm threshold.
type InterconnectDiagnosticsLinkOpticalPower_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnosticsLinkOpticalPower_UNDEFINED_STATE InterconnectDiagnosticsLinkOpticalPower_State = 0
	// The value has crossed above the high alarm threshold.
	InterconnectDiagnosticsLinkOpticalPower_HIGH_ALARM InterconnectDiagnosticsLinkOpticalPower_State = 305363284
	// The value of the current optical power has crossed above the high warning threshold.
	InterconnectDiagnosticsLinkOpticalPower_HIGH_WARNING InterconnectDiagnosticsLinkOpticalPower_State = 220984799
	// The value of the current optical power has crossed below the low alarm threshold.
	InterconnectDiagnosticsLinkOpticalPower_LOW_ALARM InterconnectDiagnosticsLinkOpticalPower_State = 316659046
	// The value of the current optical power has crossed below the low warning threshold.
	InterconnectDiagnosticsLinkOpticalPower_LOW_WARNING InterconnectDiagnosticsLinkOpticalPower_State = 338793841
	// The value of the current optical power has not crossed a warning threshold.
	InterconnectDiagnosticsLinkOpticalPower_OK InterconnectDiagnosticsLinkOpticalPower_State = 2524
)

// Enum value maps for InterconnectDiagnosticsLinkOpticalPower_State.
var (
	InterconnectDiagnosticsLinkOpticalPower_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		305363284: "HIGH_ALARM",
		220984799: "HIGH_WARNING",
		316659046: "LOW_ALARM",
		338793841: "LOW_WARNING",
		2524:      "OK",
	}
	InterconnectDiagnosticsLinkOpticalPower_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"HIGH_ALARM":      305363284,
		"HIGH_WARNING":    220984799,
		"LOW_ALARM":       316659046,
		"LOW_WARNING":     338793841,
		"OK":              2524,
	}
)

func (x InterconnectDiagnosticsLinkOpticalPower_State) Enum() *InterconnectDiagnosticsLinkOpticalPower_State {
	p := new(InterconnectDiagnosticsLinkOpticalPower_State)
	*p = x
	return p
}

func (x InterconnectDiagnosticsLinkOpticalPower_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnosticsLinkOpticalPower_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[192].Descriptor()
}

func (InterconnectDiagnosticsLinkOpticalPower_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[192]
}

func (x InterconnectDiagnosticsLinkOpticalPower_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnosticsLinkOpticalPower_State.Descriptor instead.
func (InterconnectDiagnosticsLinkOpticalPower_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{873, 0}
}

// The operational status of the link.
type InterconnectDiagnosticsLinkStatus_OperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnosticsLinkStatus_UNDEFINED_OPERATIONAL_STATUS InterconnectDiagnosticsLinkStatus_OperationalStatus = 0
	// The interface is unable to communicate with the remote end.
	InterconnectDiagnosticsLinkStatus_LINK_OPERATIONAL_STATUS_DOWN InterconnectDiagnosticsLinkStatus_OperationalStatus = 281653885
	// The interface has low level communication with the remote end.
	InterconnectDiagnosticsLinkStatus_LINK_OPERATIONAL_STATUS_UP InterconnectDiagnosticsLinkStatus_OperationalStatus = 305879862
)

// Enum value maps for InterconnectDiagnosticsLinkStatus_OperationalStatus.
var (
	InterconnectDiagnosticsLinkStatus_OperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_OPERATIONAL_STATUS",
		281653885: "LINK_OPERATIONAL_STATUS_DOWN",
		305879862: "LINK_OPERATIONAL_STATUS_UP",
	}
	InterconnectDiagnosticsLinkStatus_OperationalStatus_value = map[string]int32{
		"UNDEFINED_OPERATIONAL_STATUS": 0,
		"LINK_OPERATIONAL_STATUS_DOWN": 281653885,
		"LINK_OPERATIONAL_STATUS_UP":   305879862,
	}
)

func (x InterconnectDiagnosticsLinkStatus_OperationalStatus) Enum() *InterconnectDiagnosticsLinkStatus_OperationalStatus {
	p := new(InterconnectDiagnosticsLinkStatus_OperationalStatus)
	*p = x
	return p
}

func (x InterconnectDiagnosticsLinkStatus_OperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnosticsLinkStatus_OperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[193].Descriptor()
}

func (InterconnectDiagnosticsLinkStatus_OperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[193]
}

func (x InterconnectDiagnosticsLinkStatus_OperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnosticsLinkStatus_OperationalStatus.Descriptor instead.
func (InterconnectDiagnosticsLinkStatus_OperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{874, 0}
}

type InterconnectGroupConfiguredTopologyCapability_SupportedSla int32

const (
	// A value indicating that the enum field is not set.
	InterconnectGroupConfiguredTopologyCapability_UNDEFINED_SUPPORTED_SLA InterconnectGroupConfiguredTopologyCapability_SupportedSla = 0
	InterconnectGroupConfiguredTopologyCapability_NO_SLA                  InterconnectGroupConfiguredTopologyCapability_SupportedSla = 161460618
	InterconnectGroupConfiguredTopologyCapability_PRODUCTION_CRITICAL     InterconnectGroupConfiguredTopologyCapability_SupportedSla = 470416485
	InterconnectGroupConfiguredTopologyCapability_PRODUCTION_NON_CRITICAL InterconnectGroupConfiguredTopologyCapability_SupportedSla = 117399223
	InterconnectGroupConfiguredTopologyCapability_UNSPECIFIED             InterconnectGroupConfiguredTopologyCapability_SupportedSla = 526786327
)

// Enum value maps for InterconnectGroupConfiguredTopologyCapability_SupportedSla.
var (
	InterconnectGroupConfiguredTopologyCapability_SupportedSla_name = map[int32]string{
		0:         "UNDEFINED_SUPPORTED_SLA",
		161460618: "NO_SLA",
		470416485: "PRODUCTION_CRITICAL",
		117399223: "PRODUCTION_NON_CRITICAL",
		526786327: "UNSPECIFIED",
	}
	InterconnectGroupConfiguredTopologyCapability_SupportedSla_value = map[string]int32{
		"UNDEFINED_SUPPORTED_SLA": 0,
		"NO_SLA":                  161460618,
		"PRODUCTION_CRITICAL":     470416485,
		"PRODUCTION_NON_CRITICAL": 117399223,
		"UNSPECIFIED":             526786327,
	}
)

func (x InterconnectGroupConfiguredTopologyCapability_SupportedSla) Enum() *InterconnectGroupConfiguredTopologyCapability_SupportedSla {
	p := new(InterconnectGroupConfiguredTopologyCapability_SupportedSla)
	*p = x
	return p
}

func (x InterconnectGroupConfiguredTopologyCapability_SupportedSla) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectGroupConfiguredTopologyCapability_SupportedSla) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[194].Descriptor()
}

func (InterconnectGroupConfiguredTopologyCapability_SupportedSla) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[194]
}

func (x InterconnectGroupConfiguredTopologyCapability_SupportedSla) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectGroupConfiguredTopologyCapability_SupportedSla.Descriptor instead.
func (InterconnectGroupConfiguredTopologyCapability_SupportedSla) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{878, 0}
}

type InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_UNDEFINED_BLOCKER_TYPE             InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType = 0
	InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_INCOMPATIBLE_METROS                InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType = 290410432
	InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_NOT_AVAILABLE                      InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType = 140722205
	InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_NO_INTERCONNECTS                   InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType = 523549575
	InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_NO_INTERCONNECTS_IN_METRO_AND_ZONE InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType = 440966492
	InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_OTHER                              InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType = 75532016
	InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_UNSPECIFIED                        InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType = 526786327
)

// Enum value maps for InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType.
var (
	InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType_name = map[int32]string{
		0:         "UNDEFINED_BLOCKER_TYPE",
		290410432: "INCOMPATIBLE_METROS",
		140722205: "NOT_AVAILABLE",
		523549575: "NO_INTERCONNECTS",
		440966492: "NO_INTERCONNECTS_IN_METRO_AND_ZONE",
		75532016:  "OTHER",
		526786327: "UNSPECIFIED",
	}
	InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType_value = map[string]int32{
		"UNDEFINED_BLOCKER_TYPE":             0,
		"INCOMPATIBLE_METROS":                290410432,
		"NOT_AVAILABLE":                      140722205,
		"NO_INTERCONNECTS":                   523549575,
		"NO_INTERCONNECTS_IN_METRO_AND_ZONE": 440966492,
		"OTHER":                              75532016,
		"UNSPECIFIED":                        526786327,
	}
)

func (x InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType) Enum() *InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType {
	p := new(InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType)
	*p = x
	return p
}

func (x InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[195].Descriptor()
}

func (InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[195]
}

func (x InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType.Descriptor instead.
func (InterconnectGroupConfiguredTopologyCapabilityIntendedCapabilityBlockers_BlockerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{879, 0}
}

type InterconnectGroupIntent_TopologyCapability int32

const (
	// A value indicating that the enum field is not set.
	InterconnectGroupIntent_UNDEFINED_TOPOLOGY_CAPABILITY InterconnectGroupIntent_TopologyCapability = 0
	InterconnectGroupIntent_NO_SLA                        InterconnectGroupIntent_TopologyCapability = 161460618
	InterconnectGroupIntent_PRODUCTION_CRITICAL           InterconnectGroupIntent_TopologyCapability = 470416485
	InterconnectGroupIntent_PRODUCTION_NON_CRITICAL       InterconnectGroupIntent_TopologyCapability = 117399223
	InterconnectGroupIntent_UNSPECIFIED                   InterconnectGroupIntent_TopologyCapability = 526786327
)

// Enum value maps for InterconnectGroupIntent_TopologyCapability.
var (
	InterconnectGroupIntent_TopologyCapability_name = map[int32]string{
		0:         "UNDEFINED_TOPOLOGY_CAPABILITY",
		161460618: "NO_SLA",
		470416485: "PRODUCTION_CRITICAL",
		117399223: "PRODUCTION_NON_CRITICAL",
		526786327: "UNSPECIFIED",
	}
	InterconnectGroupIntent_TopologyCapability_value = map[string]int32{
		"UNDEFINED_TOPOLOGY_CAPABILITY": 0,
		"NO_SLA":                        161460618,
		"PRODUCTION_CRITICAL":           470416485,
		"PRODUCTION_NON_CRITICAL":       117399223,
		"UNSPECIFIED":                   526786327,
	}
)

func (x InterconnectGroupIntent_TopologyCapability) Enum() *InterconnectGroupIntent_TopologyCapability {
	p := new(InterconnectGroupIntent_TopologyCapability)
	*p = x
	return p
}

func (x InterconnectGroupIntent_TopologyCapability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectGroupIntent_TopologyCapability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[196].Descriptor()
}

func (InterconnectGroupIntent_TopologyCapability) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[196]
}

func (x InterconnectGroupIntent_TopologyCapability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectGroupIntent_TopologyCapability.Descriptor instead.
func (InterconnectGroupIntent_TopologyCapability) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{880, 0}
}

// How to behave when configured.topologyCapability.supportedSLA would not equal intent.topologyCapability after this call.
type InterconnectGroupsCreateMembers_IntentMismatchBehavior int32

const (
	// A value indicating that the enum field is not set.
	InterconnectGroupsCreateMembers_UNDEFINED_INTENT_MISMATCH_BEHAVIOR InterconnectGroupsCreateMembers_IntentMismatchBehavior = 0
	InterconnectGroupsCreateMembers_CREATE                             InterconnectGroupsCreateMembers_IntentMismatchBehavior = 385389820
	InterconnectGroupsCreateMembers_REJECT                             InterconnectGroupsCreateMembers_IntentMismatchBehavior = 266102687
	InterconnectGroupsCreateMembers_UNSPECIFIED                        InterconnectGroupsCreateMembers_IntentMismatchBehavior = 526786327
)

// Enum value maps for InterconnectGroupsCreateMembers_IntentMismatchBehavior.
var (
	InterconnectGroupsCreateMembers_IntentMismatchBehavior_name = map[int32]string{
		0:         "UNDEFINED_INTENT_MISMATCH_BEHAVIOR",
		385389820: "CREATE",
		266102687: "REJECT",
		526786327: "UNSPECIFIED",
	}
	InterconnectGroupsCreateMembers_IntentMismatchBehavior_value = map[string]int32{
		"UNDEFINED_INTENT_MISMATCH_BEHAVIOR": 0,
		"CREATE":                             385389820,
		"REJECT":                             266102687,
		"UNSPECIFIED":                        526786327,
	}
)

func (x InterconnectGroupsCreateMembers_IntentMismatchBehavior) Enum() *InterconnectGroupsCreateMembers_IntentMismatchBehavior {
	p := new(InterconnectGroupsCreateMembers_IntentMismatchBehavior)
	*p = x
	return p
}

func (x InterconnectGroupsCreateMembers_IntentMismatchBehavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectGroupsCreateMembers_IntentMismatchBehavior) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[197].Descriptor()
}

func (InterconnectGroupsCreateMembers_IntentMismatchBehavior) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[197]
}

func (x InterconnectGroupsCreateMembers_IntentMismatchBehavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectGroupsCreateMembers_IntentMismatchBehavior.Descriptor instead.
func (InterconnectGroupsCreateMembers_IntentMismatchBehavior) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{886, 0}
}

// Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
type InterconnectGroupsCreateMembersInterconnectInput_InterconnectType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectGroupsCreateMembersInterconnectInput_UNDEFINED_INTERCONNECT_TYPE InterconnectGroupsCreateMembersInterconnectInput_InterconnectType = 0
	// A dedicated physical interconnection with the customer.
	InterconnectGroupsCreateMembersInterconnectInput_DEDICATED InterconnectGroupsCreateMembersInterconnectInput_InterconnectType = 258411983
	// [Deprecated] A private, physical interconnection with the customer.
	InterconnectGroupsCreateMembersInterconnectInput_IT_PRIVATE InterconnectGroupsCreateMembersInterconnectInput_InterconnectType = 335677007
	// A partner-managed interconnection shared between customers via partner.
	InterconnectGroupsCreateMembersInterconnectInput_PARTNER InterconnectGroupsCreateMembersInterconnectInput_InterconnectType = 461924520
)

// Enum value maps for InterconnectGroupsCreateMembersInterconnectInput_InterconnectType.
var (
	InterconnectGroupsCreateMembersInterconnectInput_InterconnectType_name = map[int32]string{
		0:         "UNDEFINED_INTERCONNECT_TYPE",
		258411983: "DEDICATED",
		335677007: "IT_PRIVATE",
		461924520: "PARTNER",
	}
	InterconnectGroupsCreateMembersInterconnectInput_InterconnectType_value = map[string]int32{
		"UNDEFINED_INTERCONNECT_TYPE": 0,
		"DEDICATED":                   258411983,
		"IT_PRIVATE":                  335677007,
		"PARTNER":                     461924520,
	}
)

func (x InterconnectGroupsCreateMembersInterconnectInput_InterconnectType) Enum() *InterconnectGroupsCreateMembersInterconnectInput_InterconnectType {
	p := new(InterconnectGroupsCreateMembersInterconnectInput_InterconnectType)
	*p = x
	return p
}

func (x InterconnectGroupsCreateMembersInterconnectInput_InterconnectType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectGroupsCreateMembersInterconnectInput_InterconnectType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[198].Descriptor()
}

func (InterconnectGroupsCreateMembersInterconnectInput_InterconnectType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[198]
}

func (x InterconnectGroupsCreateMembersInterconnectInput_InterconnectType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectGroupsCreateMembersInterconnectInput_InterconnectType.Descriptor instead.
func (InterconnectGroupsCreateMembersInterconnectInput_InterconnectType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{887, 0}
}

// Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. - LINK_TYPE_ETHERNET_400G_LR4: A 400G Ethernet with LR4 optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
type InterconnectGroupsCreateMembersInterconnectInput_LinkType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectGroupsCreateMembersInterconnectInput_UNDEFINED_LINK_TYPE InterconnectGroupsCreateMembersInterconnectInput_LinkType = 0
	// 100G Ethernet, LR Optics.
	InterconnectGroupsCreateMembersInterconnectInput_LINK_TYPE_ETHERNET_100G_LR InterconnectGroupsCreateMembersInterconnectInput_LinkType = 337672551
	// 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
	InterconnectGroupsCreateMembersInterconnectInput_LINK_TYPE_ETHERNET_10G_LR InterconnectGroupsCreateMembersInterconnectInput_LinkType = 236739749
	// 400G Ethernet, LR4 Optics.
	InterconnectGroupsCreateMembersInterconnectInput_LINK_TYPE_ETHERNET_400G_LR4 InterconnectGroupsCreateMembersInterconnectInput_LinkType = 127023690
)

// Enum value maps for InterconnectGroupsCreateMembersInterconnectInput_LinkType.
var (
	InterconnectGroupsCreateMembersInterconnectInput_LinkType_name = map[int32]string{
		0:         "UNDEFINED_LINK_TYPE",
		337672551: "LINK_TYPE_ETHERNET_100G_LR",
		236739749: "LINK_TYPE_ETHERNET_10G_LR",
		127023690: "LINK_TYPE_ETHERNET_400G_LR4",
	}
	InterconnectGroupsCreateMembersInterconnectInput_LinkType_value = map[string]int32{
		"UNDEFINED_LINK_TYPE":         0,
		"LINK_TYPE_ETHERNET_100G_LR":  337672551,
		"LINK_TYPE_ETHERNET_10G_LR":   236739749,
		"LINK_TYPE_ETHERNET_400G_LR4": 127023690,
	}
)

func (x InterconnectGroupsCreateMembersInterconnectInput_LinkType) Enum() *InterconnectGroupsCreateMembersInterconnectInput_LinkType {
	p := new(InterconnectGroupsCreateMembersInterconnectInput_LinkType)
	*p = x
	return p
}

func (x InterconnectGroupsCreateMembersInterconnectInput_LinkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectGroupsCreateMembersInterconnectInput_LinkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[199].Descriptor()
}

func (InterconnectGroupsCreateMembersInterconnectInput_LinkType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[199]
}

func (x InterconnectGroupsCreateMembersInterconnectInput_LinkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectGroupsCreateMembersInterconnectInput_LinkType.Descriptor instead.
func (InterconnectGroupsCreateMembersInterconnectInput_LinkType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{887, 1}
}

type InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures int32

const (
	// A value indicating that the enum field is not set.
	InterconnectGroupsCreateMembersInterconnectInput_UNDEFINED_REQUESTED_FEATURES InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures = 0
	// Cross-Site Networking
	InterconnectGroupsCreateMembersInterconnectInput_IF_CROSS_SITE_NETWORK InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures = 469111095
	// Media Access Control security (MACsec)
	InterconnectGroupsCreateMembersInterconnectInput_IF_MACSEC InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures = 396279300
)

// Enum value maps for InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures.
var (
	InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures_name = map[int32]string{
		0:         "UNDEFINED_REQUESTED_FEATURES",
		469111095: "IF_CROSS_SITE_NETWORK",
		396279300: "IF_MACSEC",
	}
	InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures_value = map[string]int32{
		"UNDEFINED_REQUESTED_FEATURES": 0,
		"IF_CROSS_SITE_NETWORK":        469111095,
		"IF_MACSEC":                    396279300,
	}
)

func (x InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures) Enum() *InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures {
	p := new(InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures)
	*p = x
	return p
}

func (x InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[200].Descriptor()
}

func (InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[200]
}

func (x InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures.Descriptor instead.
func (InterconnectGroupsCreateMembersInterconnectInput_RequestedFeatures) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{887, 2}
}

// Summarizes the status of the group.
type InterconnectGroupsOperationalStatus_GroupStatus int32

const (
	// A value indicating that the enum field is not set.
	InterconnectGroupsOperationalStatus_UNDEFINED_GROUP_STATUS    InterconnectGroupsOperationalStatus_GroupStatus = 0
	InterconnectGroupsOperationalStatus_DEGRADED                  InterconnectGroupsOperationalStatus_GroupStatus = 396890926
	InterconnectGroupsOperationalStatus_FULLY_DOWN                InterconnectGroupsOperationalStatus_GroupStatus = 255514647
	InterconnectGroupsOperationalStatus_FULLY_UP                  InterconnectGroupsOperationalStatus_GroupStatus = 504176464
	InterconnectGroupsOperationalStatus_GROUPS_STATUS_UNSPECIFIED InterconnectGroupsOperationalStatus_GroupStatus = 261932693
)

// Enum value maps for InterconnectGroupsOperationalStatus_GroupStatus.
var (
	InterconnectGroupsOperationalStatus_GroupStatus_name = map[int32]string{
		0:         "UNDEFINED_GROUP_STATUS",
		396890926: "DEGRADED",
		255514647: "FULLY_DOWN",
		504176464: "FULLY_UP",
		261932693: "GROUPS_STATUS_UNSPECIFIED",
	}
	InterconnectGroupsOperationalStatus_GroupStatus_value = map[string]int32{
		"UNDEFINED_GROUP_STATUS":    0,
		"DEGRADED":                  396890926,
		"FULLY_DOWN":                255514647,
		"FULLY_UP":                  504176464,
		"GROUPS_STATUS_UNSPECIFIED": 261932693,
	}
)

func (x InterconnectGroupsOperationalStatus_GroupStatus) Enum() *InterconnectGroupsOperationalStatus_GroupStatus {
	p := new(InterconnectGroupsOperationalStatus_GroupStatus)
	*p = x
	return p
}

func (x InterconnectGroupsOperationalStatus_GroupStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectGroupsOperationalStatus_GroupStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[201].Descriptor()
}

func (InterconnectGroupsOperationalStatus_GroupStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[201]
}

func (x InterconnectGroupsOperationalStatus_GroupStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectGroupsOperationalStatus_GroupStatus.Descriptor instead.
func (InterconnectGroupsOperationalStatus_GroupStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{891, 0}
}

// Whether this interconnect is participating in the redundant configuration.
type InterconnectGroupsOperationalStatusInterconnectStatus_IsActive int32

const (
	// A value indicating that the enum field is not set.
	InterconnectGroupsOperationalStatusInterconnectStatus_UNDEFINED_IS_ACTIVE   InterconnectGroupsOperationalStatusInterconnectStatus_IsActive = 0
	InterconnectGroupsOperationalStatusInterconnectStatus_ACTIVE                InterconnectGroupsOperationalStatusInterconnectStatus_IsActive = 314733318
	InterconnectGroupsOperationalStatusInterconnectStatus_INACTIVE              InterconnectGroupsOperationalStatusInterconnectStatus_IsActive = 270421099
	InterconnectGroupsOperationalStatusInterconnectStatus_IS_ACTIVE_UNSPECIFIED InterconnectGroupsOperationalStatusInterconnectStatus_IsActive = 274948243
)

// Enum value maps for InterconnectGroupsOperationalStatusInterconnectStatus_IsActive.
var (
	InterconnectGroupsOperationalStatusInterconnectStatus_IsActive_name = map[int32]string{
		0:         "UNDEFINED_IS_ACTIVE",
		314733318: "ACTIVE",
		270421099: "INACTIVE",
		274948243: "IS_ACTIVE_UNSPECIFIED",
	}
	InterconnectGroupsOperationalStatusInterconnectStatus_IsActive_value = map[string]int32{
		"UNDEFINED_IS_ACTIVE":   0,
		"ACTIVE":                314733318,
		"INACTIVE":              270421099,
		"IS_ACTIVE_UNSPECIFIED": 274948243,
	}
)

func (x InterconnectGroupsOperationalStatusInterconnectStatus_IsActive) Enum() *InterconnectGroupsOperationalStatusInterconnectStatus_IsActive {
	p := new(InterconnectGroupsOperationalStatusInterconnectStatus_IsActive)
	*p = x
	return p
}

func (x InterconnectGroupsOperationalStatusInterconnectStatus_IsActive) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectGroupsOperationalStatusInterconnectStatus_IsActive) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[202].Descriptor()
}

func (InterconnectGroupsOperationalStatusInterconnectStatus_IsActive) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[202]
}

func (x InterconnectGroupsOperationalStatusInterconnectStatus_IsActive) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectGroupsOperationalStatusInterconnectStatus_IsActive.Descriptor instead.
func (InterconnectGroupsOperationalStatusInterconnectStatus_IsActive) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{892, 0}
}

type InterconnectLocation_AvailableFeatures int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocation_UNDEFINED_AVAILABLE_FEATURES InterconnectLocation_AvailableFeatures = 0
	// Cross-Site Networking
	InterconnectLocation_IF_CROSS_SITE_NETWORK InterconnectLocation_AvailableFeatures = 469111095
	// Media Access Control security (MACsec)
	InterconnectLocation_IF_MACSEC InterconnectLocation_AvailableFeatures = 396279300
)

// Enum value maps for InterconnectLocation_AvailableFeatures.
var (
	InterconnectLocation_AvailableFeatures_name = map[int32]string{
		0:         "UNDEFINED_AVAILABLE_FEATURES",
		469111095: "IF_CROSS_SITE_NETWORK",
		396279300: "IF_MACSEC",
	}
	InterconnectLocation_AvailableFeatures_value = map[string]int32{
		"UNDEFINED_AVAILABLE_FEATURES": 0,
		"IF_CROSS_SITE_NETWORK":        469111095,
		"IF_MACSEC":                    396279300,
	}
)

func (x InterconnectLocation_AvailableFeatures) Enum() *InterconnectLocation_AvailableFeatures {
	p := new(InterconnectLocation_AvailableFeatures)
	*p = x
	return p
}

func (x InterconnectLocation_AvailableFeatures) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocation_AvailableFeatures) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[203].Descriptor()
}

func (InterconnectLocation_AvailableFeatures) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[203]
}

func (x InterconnectLocation_AvailableFeatures) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocation_AvailableFeatures.Descriptor instead.
func (InterconnectLocation_AvailableFeatures) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{894, 0}
}

type InterconnectLocation_AvailableLinkTypes int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocation_UNDEFINED_AVAILABLE_LINK_TYPES InterconnectLocation_AvailableLinkTypes = 0
	// 100G Ethernet, LR Optics.
	InterconnectLocation_LINK_TYPE_ETHERNET_100G_LR InterconnectLocation_AvailableLinkTypes = 337672551
	// 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
	InterconnectLocation_LINK_TYPE_ETHERNET_10G_LR InterconnectLocation_AvailableLinkTypes = 236739749
	// 400G Ethernet, LR4 Optics.
	InterconnectLocation_LINK_TYPE_ETHERNET_400G_LR4 InterconnectLocation_AvailableLinkTypes = 127023690
)

// Enum value maps for InterconnectLocation_AvailableLinkTypes.
var (
	InterconnectLocation_AvailableLinkTypes_name = map[int32]string{
		0:         "UNDEFINED_AVAILABLE_LINK_TYPES",
		337672551: "LINK_TYPE_ETHERNET_100G_LR",
		236739749: "LINK_TYPE_ETHERNET_10G_LR",
		127023690: "LINK_TYPE_ETHERNET_400G_LR4",
	}
	InterconnectLocation_AvailableLinkTypes_value = map[string]int32{
		"UNDEFINED_AVAILABLE_LINK_TYPES": 0,
		"LINK_TYPE_ETHERNET_100G_LR":     337672551,
		"LINK_TYPE_ETHERNET_10G_LR":      236739749,
		"LINK_TYPE_ETHERNET_400G_LR4":    127023690,
	}
)

func (x InterconnectLocation_AvailableLinkTypes) Enum() *InterconnectLocation_AvailableLinkTypes {
	p := new(InterconnectLocation_AvailableLinkTypes)
	*p = x
	return p
}

func (x InterconnectLocation_AvailableLinkTypes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocation_AvailableLinkTypes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[204].Descriptor()
}

func (InterconnectLocation_AvailableLinkTypes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[204]
}

func (x InterconnectLocation_AvailableLinkTypes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocation_AvailableLinkTypes.Descriptor instead.
func (InterconnectLocation_AvailableLinkTypes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{894, 1}
}

// [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
type InterconnectLocation_Continent int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocation_UNDEFINED_CONTINENT InterconnectLocation_Continent = 0
	InterconnectLocation_AFRICA              InterconnectLocation_Continent = 317443706
	InterconnectLocation_ASIA_PAC            InterconnectLocation_Continent = 119782269
	InterconnectLocation_C_AFRICA            InterconnectLocation_Continent = 71993846
	InterconnectLocation_C_ASIA_PAC          InterconnectLocation_Continent = 465668089
	InterconnectLocation_C_EUROPE            InterconnectLocation_Continent = 200369438
	InterconnectLocation_C_NORTH_AMERICA     InterconnectLocation_Continent = 275697048
	InterconnectLocation_C_SOUTH_AMERICA     InterconnectLocation_Continent = 397149792
	InterconnectLocation_EUROPE              InterconnectLocation_Continent = 445819298
	InterconnectLocation_NORTH_AMERICA       InterconnectLocation_Continent = 448015508
	InterconnectLocation_SOUTH_AMERICA       InterconnectLocation_Continent = 32597340
)

// Enum value maps for InterconnectLocation_Continent.
var (
	InterconnectLocation_Continent_name = map[int32]string{
		0:         "UNDEFINED_CONTINENT",
		317443706: "AFRICA",
		119782269: "ASIA_PAC",
		71993846:  "C_AFRICA",
		465668089: "C_ASIA_PAC",
		200369438: "C_EUROPE",
		275697048: "C_NORTH_AMERICA",
		397149792: "C_SOUTH_AMERICA",
		445819298: "EUROPE",
		448015508: "NORTH_AMERICA",
		32597340:  "SOUTH_AMERICA",
	}
	InterconnectLocation_Continent_value = map[string]int32{
		"UNDEFINED_CONTINENT": 0,
		"AFRICA":              317443706,
		"ASIA_PAC":            119782269,
		"C_AFRICA":            71993846,
		"C_ASIA_PAC":          465668089,
		"C_EUROPE":            200369438,
		"C_NORTH_AMERICA":     275697048,
		"C_SOUTH_AMERICA":     397149792,
		"EUROPE":              445819298,
		"NORTH_AMERICA":       448015508,
		"SOUTH_AMERICA":       32597340,
	}
)

func (x InterconnectLocation_Continent) Enum() *InterconnectLocation_Continent {
	p := new(InterconnectLocation_Continent)
	*p = x
	return p
}

func (x InterconnectLocation_Continent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocation_Continent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[205].Descriptor()
}

func (InterconnectLocation_Continent) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[205]
}

func (x InterconnectLocation_Continent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocation_Continent.Descriptor instead.
func (InterconnectLocation_Continent) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{894, 2}
}

// [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
type InterconnectLocation_Status int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocation_UNDEFINED_STATUS InterconnectLocation_Status = 0
	// The InterconnectLocation is available for provisioning new Interconnects.
	InterconnectLocation_AVAILABLE InterconnectLocation_Status = 442079913
	// The InterconnectLocation is closed for provisioning new Interconnects.
	InterconnectLocation_CLOSED InterconnectLocation_Status = 380163436
)

// Enum value maps for InterconnectLocation_Status.
var (
	InterconnectLocation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		442079913: "AVAILABLE",
		380163436: "CLOSED",
	}
	InterconnectLocation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"AVAILABLE":        442079913,
		"CLOSED":           380163436,
	}
)

func (x InterconnectLocation_Status) Enum() *InterconnectLocation_Status {
	p := new(InterconnectLocation_Status)
	*p = x
	return p
}

func (x InterconnectLocation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[206].Descriptor()
}

func (InterconnectLocation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[206]
}

func (x InterconnectLocation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocation_Status.Descriptor instead.
func (InterconnectLocation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{894, 3}
}

// Identifies the network presence of this location.
type InterconnectLocationRegionInfo_LocationPresence int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocationRegionInfo_UNDEFINED_LOCATION_PRESENCE InterconnectLocationRegionInfo_LocationPresence = 0
	// This region is not in any common network presence with this InterconnectLocation.
	InterconnectLocationRegionInfo_GLOBAL InterconnectLocationRegionInfo_LocationPresence = 494663587
	// This region shares the same regional network presence as this InterconnectLocation.
	InterconnectLocationRegionInfo_LOCAL_REGION InterconnectLocationRegionInfo_LocationPresence = 403535464
	// [Deprecated] This region is not in any common network presence with this InterconnectLocation.
	InterconnectLocationRegionInfo_LP_GLOBAL InterconnectLocationRegionInfo_LocationPresence = 429584062
	// [Deprecated] This region shares the same regional network presence as this InterconnectLocation.
	InterconnectLocationRegionInfo_LP_LOCAL_REGION InterconnectLocationRegionInfo_LocationPresence = 488598851
)

// Enum value maps for InterconnectLocationRegionInfo_LocationPresence.
var (
	InterconnectLocationRegionInfo_LocationPresence_name = map[int32]string{
		0:         "UNDEFINED_LOCATION_PRESENCE",
		494663587: "GLOBAL",
		403535464: "LOCAL_REGION",
		429584062: "LP_GLOBAL",
		488598851: "LP_LOCAL_REGION",
	}
	InterconnectLocationRegionInfo_LocationPresence_value = map[string]int32{
		"UNDEFINED_LOCATION_PRESENCE": 0,
		"GLOBAL":                      494663587,
		"LOCAL_REGION":                403535464,
		"LP_GLOBAL":                   429584062,
		"LP_LOCAL_REGION":             488598851,
	}
)

func (x InterconnectLocationRegionInfo_LocationPresence) Enum() *InterconnectLocationRegionInfo_LocationPresence {
	p := new(InterconnectLocationRegionInfo_LocationPresence)
	*p = x
	return p
}

func (x InterconnectLocationRegionInfo_LocationPresence) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocationRegionInfo_LocationPresence) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[207].Descriptor()
}

func (InterconnectLocationRegionInfo_LocationPresence) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[207]
}

func (x InterconnectLocationRegionInfo_LocationPresence) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocationRegionInfo_LocationPresence.Descriptor instead.
func (InterconnectLocationRegionInfo_LocationPresence) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{897, 0}
}

// Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
type InterconnectOutageNotification_IssueType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectOutageNotification_UNDEFINED_ISSUE_TYPE InterconnectOutageNotification_IssueType = 0
	// [Deprecated] The Interconnect may be completely out of service for some or all of the specified window.
	InterconnectOutageNotification_IT_OUTAGE InterconnectOutageNotification_IssueType = 175779973
	// [Deprecated] Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
	InterconnectOutageNotification_IT_PARTIAL_OUTAGE InterconnectOutageNotification_IssueType = 92103971
	// The Interconnect may be completely out of service for some or all of the specified window.
	InterconnectOutageNotification_OUTAGE InterconnectOutageNotification_IssueType = 195285745
	// Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
	InterconnectOutageNotification_PARTIAL_OUTAGE InterconnectOutageNotification_IssueType = 147053455
)

// Enum value maps for InterconnectOutageNotification_IssueType.
var (
	InterconnectOutageNotification_IssueType_name = map[int32]string{
		0:         "UNDEFINED_ISSUE_TYPE",
		175779973: "IT_OUTAGE",
		92103971:  "IT_PARTIAL_OUTAGE",
		195285745: "OUTAGE",
		147053455: "PARTIAL_OUTAGE",
	}
	InterconnectOutageNotification_IssueType_value = map[string]int32{
		"UNDEFINED_ISSUE_TYPE": 0,
		"IT_OUTAGE":            175779973,
		"IT_PARTIAL_OUTAGE":    92103971,
		"OUTAGE":               195285745,
		"PARTIAL_OUTAGE":       147053455,
	}
)

func (x InterconnectOutageNotification_IssueType) Enum() *InterconnectOutageNotification_IssueType {
	p := new(InterconnectOutageNotification_IssueType)
	*p = x
	return p
}

func (x InterconnectOutageNotification_IssueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectOutageNotification_IssueType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[208].Descriptor()
}

func (InterconnectOutageNotification_IssueType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[208]
}

func (x InterconnectOutageNotification_IssueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectOutageNotification_IssueType.Descriptor instead.
func (InterconnectOutageNotification_IssueType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{902, 0}
}

// The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
type InterconnectOutageNotification_Source int32

const (
	// A value indicating that the enum field is not set.
	InterconnectOutageNotification_UNDEFINED_SOURCE InterconnectOutageNotification_Source = 0
	// This notification was generated by Google.
	InterconnectOutageNotification_GOOGLE InterconnectOutageNotification_Source = 497439289
	// [Deprecated] This notification was generated by Google.
	InterconnectOutageNotification_NSRC_GOOGLE InterconnectOutageNotification_Source = 510574562
)

// Enum value maps for InterconnectOutageNotification_Source.
var (
	InterconnectOutageNotification_Source_name = map[int32]string{
		0:         "UNDEFINED_SOURCE",
		497439289: "GOOGLE",
		510574562: "NSRC_GOOGLE",
	}
	InterconnectOutageNotification_Source_value = map[string]int32{
		"UNDEFINED_SOURCE": 0,
		"GOOGLE":           497439289,
		"NSRC_GOOGLE":      510574562,
	}
)

func (x InterconnectOutageNotification_Source) Enum() *InterconnectOutageNotification_Source {
	p := new(InterconnectOutageNotification_Source)
	*p = x
	return p
}

func (x InterconnectOutageNotification_Source) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectOutageNotification_Source) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[209].Descriptor()
}

func (InterconnectOutageNotification_Source) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[209]
}

func (x InterconnectOutageNotification_Source) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectOutageNotification_Source.Descriptor instead.
func (InterconnectOutageNotification_Source) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{902, 1}
}

// State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
type InterconnectOutageNotification_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectOutageNotification_UNDEFINED_STATE InterconnectOutageNotification_State = 0
	// This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
	InterconnectOutageNotification_ACTIVE InterconnectOutageNotification_State = 314733318
	// The outage associated with this notification was cancelled before the outage was due to start.
	InterconnectOutageNotification_CANCELLED InterconnectOutageNotification_State = 41957681
	// The outage associated with this notification is complete.
	InterconnectOutageNotification_COMPLETED InterconnectOutageNotification_State = 309921323
	// [Deprecated] This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
	InterconnectOutageNotification_NS_ACTIVE InterconnectOutageNotification_State = 252563136
	// [Deprecated] The outage associated with this notification was canceled before the outage was due to start.
	InterconnectOutageNotification_NS_CANCELED InterconnectOutageNotification_State = 506579411
)

// Enum value maps for InterconnectOutageNotification_State.
var (
	InterconnectOutageNotification_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		41957681:  "CANCELLED",
		309921323: "COMPLETED",
		252563136: "NS_ACTIVE",
		506579411: "NS_CANCELED",
	}
	InterconnectOutageNotification_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"CANCELLED":       41957681,
		"COMPLETED":       309921323,
		"NS_ACTIVE":       252563136,
		"NS_CANCELED":     506579411,
	}
)

func (x InterconnectOutageNotification_State) Enum() *InterconnectOutageNotification_State {
	p := new(InterconnectOutageNotification_State)
	*p = x
	return p
}

func (x InterconnectOutageNotification_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectOutageNotification_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[210].Descriptor()
}

func (InterconnectOutageNotification_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[210]
}

func (x InterconnectOutageNotification_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectOutageNotification_State.Descriptor instead.
func (InterconnectOutageNotification_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{902, 2}
}

// [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
type InterconnectRemoteLocation_Continent int32

const (
	// A value indicating that the enum field is not set.
	InterconnectRemoteLocation_UNDEFINED_CONTINENT InterconnectRemoteLocation_Continent = 0
	InterconnectRemoteLocation_AFRICA              InterconnectRemoteLocation_Continent = 317443706
	InterconnectRemoteLocation_ASIA_PAC            InterconnectRemoteLocation_Continent = 119782269
	InterconnectRemoteLocation_EUROPE              InterconnectRemoteLocation_Continent = 445819298
	InterconnectRemoteLocation_NORTH_AMERICA       InterconnectRemoteLocation_Continent = 448015508
	InterconnectRemoteLocation_SOUTH_AMERICA       InterconnectRemoteLocation_Continent = 32597340
)

// Enum value maps for InterconnectRemoteLocation_Continent.
var (
	InterconnectRemoteLocation_Continent_name = map[int32]string{
		0:         "UNDEFINED_CONTINENT",
		317443706: "AFRICA",
		119782269: "ASIA_PAC",
		445819298: "EUROPE",
		448015508: "NORTH_AMERICA",
		32597340:  "SOUTH_AMERICA",
	}
	InterconnectRemoteLocation_Continent_value = map[string]int32{
		"UNDEFINED_CONTINENT": 0,
		"AFRICA":              317443706,
		"ASIA_PAC":            119782269,
		"EUROPE":              445819298,
		"NORTH_AMERICA":       448015508,
		"SOUTH_AMERICA":       32597340,
	}
)

func (x InterconnectRemoteLocation_Continent) Enum() *InterconnectRemoteLocation_Continent {
	p := new(InterconnectRemoteLocation_Continent)
	*p = x
	return p
}

func (x InterconnectRemoteLocation_Continent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectRemoteLocation_Continent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[211].Descriptor()
}

func (InterconnectRemoteLocation_Continent) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[211]
}

func (x InterconnectRemoteLocation_Continent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectRemoteLocation_Continent.Descriptor instead.
func (InterconnectRemoteLocation_Continent) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{903, 0}
}

// [Output Only] Link Aggregation Control Protocol (LACP) constraints, which can take one of the following values: LACP_SUPPORTED, LACP_UNSUPPORTED
type InterconnectRemoteLocation_Lacp int32

const (
	// A value indicating that the enum field is not set.
	InterconnectRemoteLocation_UNDEFINED_LACP InterconnectRemoteLocation_Lacp = 0
	// LACP_SUPPORTED: LACP is supported, and enabled by default on the Cross-Cloud Interconnect.
	InterconnectRemoteLocation_LACP_SUPPORTED InterconnectRemoteLocation_Lacp = 339576113
	// LACP_UNSUPPORTED: LACP is not supported and is not be enabled on this port. GetDiagnostics shows bundleAggregationType as "static". GCP does not support LAGs without LACP, so requestedLinkCount must be 1.
	InterconnectRemoteLocation_LACP_UNSUPPORTED InterconnectRemoteLocation_Lacp = 203930104
)

// Enum value maps for InterconnectRemoteLocation_Lacp.
var (
	InterconnectRemoteLocation_Lacp_name = map[int32]string{
		0:         "UNDEFINED_LACP",
		339576113: "LACP_SUPPORTED",
		203930104: "LACP_UNSUPPORTED",
	}
	InterconnectRemoteLocation_Lacp_value = map[string]int32{
		"UNDEFINED_LACP":   0,
		"LACP_SUPPORTED":   339576113,
		"LACP_UNSUPPORTED": 203930104,
	}
)

func (x InterconnectRemoteLocation_Lacp) Enum() *InterconnectRemoteLocation_Lacp {
	p := new(InterconnectRemoteLocation_Lacp)
	*p = x
	return p
}

func (x InterconnectRemoteLocation_Lacp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectRemoteLocation_Lacp) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[212].Descriptor()
}

func (InterconnectRemoteLocation_Lacp) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[212]
}

func (x InterconnectRemoteLocation_Lacp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectRemoteLocation_Lacp.Descriptor instead.
func (InterconnectRemoteLocation_Lacp) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{903, 1}
}

// [Output Only] The status of this InterconnectRemoteLocation, which can take one of the following values: - CLOSED: The InterconnectRemoteLocation is closed and is unavailable for provisioning new Cross-Cloud Interconnects. - AVAILABLE: The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
type InterconnectRemoteLocation_Status int32

const (
	// A value indicating that the enum field is not set.
	InterconnectRemoteLocation_UNDEFINED_STATUS InterconnectRemoteLocation_Status = 0
	// The InterconnectRemoteLocation is available for provisioning new Cross-Cloud Interconnects.
	InterconnectRemoteLocation_AVAILABLE InterconnectRemoteLocation_Status = 442079913
	// The InterconnectRemoteLocation is closed for provisioning new Cross-Cloud Interconnects.
	InterconnectRemoteLocation_CLOSED InterconnectRemoteLocation_Status = 380163436
)

// Enum value maps for InterconnectRemoteLocation_Status.
var (
	InterconnectRemoteLocation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		442079913: "AVAILABLE",
		380163436: "CLOSED",
	}
	InterconnectRemoteLocation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"AVAILABLE":        442079913,
		"CLOSED":           380163436,
	}
)

func (x InterconnectRemoteLocation_Status) Enum() *InterconnectRemoteLocation_Status {
	p := new(InterconnectRemoteLocation_Status)
	*p = x
	return p
}

func (x InterconnectRemoteLocation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectRemoteLocation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[213].Descriptor()
}

func (InterconnectRemoteLocation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[213]
}

func (x InterconnectRemoteLocation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectRemoteLocation_Status.Descriptor instead.
func (InterconnectRemoteLocation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{903, 2}
}

// [Output Only] Port pair remote location constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, PORT_PAIR_MATCHING_REMOTE_LOCATION. Google Cloud API refers only to individual ports, but the UI uses this field when ordering a pair of ports, to prevent users from accidentally ordering something that is incompatible with their cloud provider. Specifically, when ordering a redundant pair of Cross-Cloud Interconnect ports, and one of them uses a remote location with portPairMatchingRemoteLocation set to matching, the UI requires that both ports use the same remote location.
type InterconnectRemoteLocationConstraints_PortPairRemoteLocation int32

const (
	// A value indicating that the enum field is not set.
	InterconnectRemoteLocationConstraints_UNDEFINED_PORT_PAIR_REMOTE_LOCATION InterconnectRemoteLocationConstraints_PortPairRemoteLocation = 0
	// If PORT_PAIR_MATCHING_REMOTE_LOCATION, the remote cloud provider allocates ports in pairs, and the user should choose the same remote location for both ports.
	InterconnectRemoteLocationConstraints_PORT_PAIR_MATCHING_REMOTE_LOCATION InterconnectRemoteLocationConstraints_PortPairRemoteLocation = 207291859
	// If PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION, a user may opt to provision a redundant pair of Cross-Cloud Interconnects using two different remote locations in the same city.
	InterconnectRemoteLocationConstraints_PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION InterconnectRemoteLocationConstraints_PortPairRemoteLocation = 60609829
)

// Enum value maps for InterconnectRemoteLocationConstraints_PortPairRemoteLocation.
var (
	InterconnectRemoteLocationConstraints_PortPairRemoteLocation_name = map[int32]string{
		0:         "UNDEFINED_PORT_PAIR_REMOTE_LOCATION",
		207291859: "PORT_PAIR_MATCHING_REMOTE_LOCATION",
		60609829:  "PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION",
	}
	InterconnectRemoteLocationConstraints_PortPairRemoteLocation_value = map[string]int32{
		"UNDEFINED_PORT_PAIR_REMOTE_LOCATION":     0,
		"PORT_PAIR_MATCHING_REMOTE_LOCATION":      207291859,
		"PORT_PAIR_UNCONSTRAINED_REMOTE_LOCATION": 60609829,
	}
)

func (x InterconnectRemoteLocationConstraints_PortPairRemoteLocation) Enum() *InterconnectRemoteLocationConstraints_PortPairRemoteLocation {
	p := new(InterconnectRemoteLocationConstraints_PortPairRemoteLocation)
	*p = x
	return p
}

func (x InterconnectRemoteLocationConstraints_PortPairRemoteLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectRemoteLocationConstraints_PortPairRemoteLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[214].Descriptor()
}

func (InterconnectRemoteLocationConstraints_PortPairRemoteLocation) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[214]
}

func (x InterconnectRemoteLocationConstraints_PortPairRemoteLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectRemoteLocationConstraints_PortPairRemoteLocation.Descriptor instead.
func (InterconnectRemoteLocationConstraints_PortPairRemoteLocation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{904, 0}
}

// [Output Only] Port pair VLAN constraints, which can take one of the following values: PORT_PAIR_UNCONSTRAINED_VLAN, PORT_PAIR_MATCHING_VLAN
type InterconnectRemoteLocationConstraints_PortPairVlan int32

const (
	// A value indicating that the enum field is not set.
	InterconnectRemoteLocationConstraints_UNDEFINED_PORT_PAIR_VLAN InterconnectRemoteLocationConstraints_PortPairVlan = 0
	// If PORT_PAIR_MATCHING_VLAN, the Interconnect for this attachment is part of a pair of ports that should have matching VLAN allocations. This occurs with Cross-Cloud Interconnect to Azure remote locations. While GCP's API does not explicitly group pairs of ports, the UI uses this field to ensure matching VLAN ids when configuring a redundant VLAN pair.
	InterconnectRemoteLocationConstraints_PORT_PAIR_MATCHING_VLAN InterconnectRemoteLocationConstraints_PortPairVlan = 250295358
	// PORT_PAIR_UNCONSTRAINED_VLAN means there is no constraint.
	InterconnectRemoteLocationConstraints_PORT_PAIR_UNCONSTRAINED_VLAN InterconnectRemoteLocationConstraints_PortPairVlan = 175227948
)

// Enum value maps for InterconnectRemoteLocationConstraints_PortPairVlan.
var (
	InterconnectRemoteLocationConstraints_PortPairVlan_name = map[int32]string{
		0:         "UNDEFINED_PORT_PAIR_VLAN",
		250295358: "PORT_PAIR_MATCHING_VLAN",
		175227948: "PORT_PAIR_UNCONSTRAINED_VLAN",
	}
	InterconnectRemoteLocationConstraints_PortPairVlan_value = map[string]int32{
		"UNDEFINED_PORT_PAIR_VLAN":     0,
		"PORT_PAIR_MATCHING_VLAN":      250295358,
		"PORT_PAIR_UNCONSTRAINED_VLAN": 175227948,
	}
)

func (x InterconnectRemoteLocationConstraints_PortPairVlan) Enum() *InterconnectRemoteLocationConstraints_PortPairVlan {
	p := new(InterconnectRemoteLocationConstraints_PortPairVlan)
	*p = x
	return p
}

func (x InterconnectRemoteLocationConstraints_PortPairVlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectRemoteLocationConstraints_PortPairVlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[215].Descriptor()
}

func (InterconnectRemoteLocationConstraints_PortPairVlan) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[215]
}

func (x InterconnectRemoteLocationConstraints_PortPairVlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectRemoteLocationConstraints_PortPairVlan.Descriptor instead.
func (InterconnectRemoteLocationConstraints_PortPairVlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{904, 1}
}

// [Output Only] Current state of this License Code.
type LicenseCode_State int32

const (
	// A value indicating that the enum field is not set.
	LicenseCode_UNDEFINED_STATE LicenseCode_State = 0
	// Machines are not allowed to attach boot disks with this License Code. Requests to create new resources with this license will be rejected.
	LicenseCode_DISABLED LicenseCode_State = 516696700
	// Use is allowed for anyone with USE_READ_ONLY access to this License Code.
	LicenseCode_ENABLED LicenseCode_State = 182130465
	// Use of this license is limited to a project whitelist.
	LicenseCode_RESTRICTED        LicenseCode_State = 261551195
	LicenseCode_STATE_UNSPECIFIED LicenseCode_State = 470755401
	// Reserved state.
	LicenseCode_TERMINATED LicenseCode_State = 250018339
)

// Enum value maps for LicenseCode_State.
var (
	LicenseCode_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		516696700: "DISABLED",
		182130465: "ENABLED",
		261551195: "RESTRICTED",
		470755401: "STATE_UNSPECIFIED",
		250018339: "TERMINATED",
	}
	LicenseCode_State_value = map[string]int32{
		"UNDEFINED_STATE":   0,
		"DISABLED":          516696700,
		"ENABLED":           182130465,
		"RESTRICTED":        261551195,
		"STATE_UNSPECIFIED": 470755401,
		"TERMINATED":        250018339,
	}
)

func (x LicenseCode_State) Enum() *LicenseCode_State {
	p := new(LicenseCode_State)
	*p = x
	return p
}

func (x LicenseCode_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LicenseCode_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[216].Descriptor()
}

func (LicenseCode_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[216]
}

func (x LicenseCode_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LicenseCode_State.Descriptor instead.
func (LicenseCode_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{914, 0}
}

// (Required) limit results to this address family (either IPv4 or IPv6)
type ListBgpRoutesRoutersRequest_AddressFamily int32

const (
	// A value indicating that the enum field is not set.
	ListBgpRoutesRoutersRequest_UNDEFINED_ADDRESS_FAMILY ListBgpRoutesRoutersRequest_AddressFamily = 0
	ListBgpRoutesRoutersRequest_IPV4                     ListBgpRoutesRoutersRequest_AddressFamily = 2254341
	ListBgpRoutesRoutersRequest_IPV6                     ListBgpRoutesRoutersRequest_AddressFamily = 2254343
	ListBgpRoutesRoutersRequest_UNSPECIFIED_IP_VERSION   ListBgpRoutesRoutersRequest_AddressFamily = 72938440
)

// Enum value maps for ListBgpRoutesRoutersRequest_AddressFamily.
var (
	ListBgpRoutesRoutersRequest_AddressFamily_name = map[int32]string{
		0:        "UNDEFINED_ADDRESS_FAMILY",
		2254341:  "IPV4",
		2254343:  "IPV6",
		72938440: "UNSPECIFIED_IP_VERSION",
	}
	ListBgpRoutesRoutersRequest_AddressFamily_value = map[string]int32{
		"UNDEFINED_ADDRESS_FAMILY": 0,
		"IPV4":                     2254341,
		"IPV6":                     2254343,
		"UNSPECIFIED_IP_VERSION":   72938440,
	}
)

func (x ListBgpRoutesRoutersRequest_AddressFamily) Enum() *ListBgpRoutesRoutersRequest_AddressFamily {
	p := new(ListBgpRoutesRoutersRequest_AddressFamily)
	*p = x
	return p
}

func (x ListBgpRoutesRoutersRequest_AddressFamily) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListBgpRoutesRoutersRequest_AddressFamily) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[217].Descriptor()
}

func (ListBgpRoutesRoutersRequest_AddressFamily) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[217]
}

func (x ListBgpRoutesRoutersRequest_AddressFamily) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListBgpRoutesRoutersRequest_AddressFamily.Descriptor instead.
func (ListBgpRoutesRoutersRequest_AddressFamily) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{928, 0}
}

// (Required) limit results to this type of route (either LEARNED or ADVERTISED)
type ListBgpRoutesRoutersRequest_RouteType int32

const (
	// A value indicating that the enum field is not set.
	ListBgpRoutesRoutersRequest_UNDEFINED_ROUTE_TYPE   ListBgpRoutesRoutersRequest_RouteType = 0
	ListBgpRoutesRoutersRequest_ADVERTISED             ListBgpRoutesRoutersRequest_RouteType = 20302109
	ListBgpRoutesRoutersRequest_LEARNED                ListBgpRoutesRoutersRequest_RouteType = 231892419
	ListBgpRoutesRoutersRequest_UNSPECIFIED_ROUTE_TYPE ListBgpRoutesRoutersRequest_RouteType = 248064440
)

// Enum value maps for ListBgpRoutesRoutersRequest_RouteType.
var (
	ListBgpRoutesRoutersRequest_RouteType_name = map[int32]string{
		0:         "UNDEFINED_ROUTE_TYPE",
		20302109:  "ADVERTISED",
		231892419: "LEARNED",
		248064440: "UNSPECIFIED_ROUTE_TYPE",
	}
	ListBgpRoutesRoutersRequest_RouteType_value = map[string]int32{
		"UNDEFINED_ROUTE_TYPE":   0,
		"ADVERTISED":             20302109,
		"LEARNED":                231892419,
		"UNSPECIFIED_ROUTE_TYPE": 248064440,
	}
)

func (x ListBgpRoutesRoutersRequest_RouteType) Enum() *ListBgpRoutesRoutersRequest_RouteType {
	p := new(ListBgpRoutesRoutersRequest_RouteType)
	*p = x
	return p
}

func (x ListBgpRoutesRoutersRequest_RouteType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListBgpRoutesRoutersRequest_RouteType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[218].Descriptor()
}

func (ListBgpRoutesRoutersRequest_RouteType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[218]
}

func (x ListBgpRoutesRoutersRequest_RouteType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListBgpRoutesRoutersRequest_RouteType.Descriptor instead.
func (ListBgpRoutesRoutersRequest_RouteType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{928, 1}
}

// View of the instance template.
type ListInstanceTemplatesRequest_View int32

const (
	// A value indicating that the enum field is not set.
	ListInstanceTemplatesRequest_UNDEFINED_VIEW ListInstanceTemplatesRequest_View = 0
	// Include everything except Partner Metadata.
	ListInstanceTemplatesRequest_BASIC ListInstanceTemplatesRequest_View = 62970894
	// Include everything.
	ListInstanceTemplatesRequest_FULL ListInstanceTemplatesRequest_View = 2169487
	// The default / unset value. The API will default to the BASIC view.
	ListInstanceTemplatesRequest_INSTANCE_VIEW_UNSPECIFIED ListInstanceTemplatesRequest_View = 8444647
)

// Enum value maps for ListInstanceTemplatesRequest_View.
var (
	ListInstanceTemplatesRequest_View_name = map[int32]string{
		0:        "UNDEFINED_VIEW",
		62970894: "BASIC",
		2169487:  "FULL",
		8444647:  "INSTANCE_VIEW_UNSPECIFIED",
	}
	ListInstanceTemplatesRequest_View_value = map[string]int32{
		"UNDEFINED_VIEW":            0,
		"BASIC":                     62970894,
		"FULL":                      2169487,
		"INSTANCE_VIEW_UNSPECIFIED": 8444647,
	}
)

func (x ListInstanceTemplatesRequest_View) Enum() *ListInstanceTemplatesRequest_View {
	p := new(ListInstanceTemplatesRequest_View)
	*p = x
	return p
}

func (x ListInstanceTemplatesRequest_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListInstanceTemplatesRequest_View) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[219].Descriptor()
}

func (ListInstanceTemplatesRequest_View) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[219]
}

func (x ListInstanceTemplatesRequest_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListInstanceTemplatesRequest_View.Descriptor instead.
func (ListInstanceTemplatesRequest_View) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{951, 0}
}

// View of the instance.
type ListInstancesRequest_View int32

const (
	// A value indicating that the enum field is not set.
	ListInstancesRequest_UNDEFINED_VIEW ListInstancesRequest_View = 0
	// Include everything except Partner Metadata.
	ListInstancesRequest_BASIC ListInstancesRequest_View = 62970894
	// Include everything.
	ListInstancesRequest_FULL ListInstancesRequest_View = 2169487
	// The default / unset value. The API will default to the BASIC view.
	ListInstancesRequest_INSTANCE_VIEW_UNSPECIFIED ListInstancesRequest_View = 8444647
)

// Enum value maps for ListInstancesRequest_View.
var (
	ListInstancesRequest_View_name = map[int32]string{
		0:        "UNDEFINED_VIEW",
		62970894: "BASIC",
		2169487:  "FULL",
		8444647:  "INSTANCE_VIEW_UNSPECIFIED",
	}
	ListInstancesRequest_View_value = map[string]int32{
		"UNDEFINED_VIEW":            0,
		"BASIC":                     62970894,
		"FULL":                      2169487,
		"INSTANCE_VIEW_UNSPECIFIED": 8444647,
	}
)

func (x ListInstancesRequest_View) Enum() *ListInstancesRequest_View {
	p := new(ListInstancesRequest_View)
	*p = x
	return p
}

func (x ListInstancesRequest_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListInstancesRequest_View) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[220].Descriptor()
}

func (ListInstancesRequest_View) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[220]
}

func (x ListInstancesRequest_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListInstancesRequest_View.Descriptor instead.
func (ListInstancesRequest_View) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{954, 0}
}

// The direction of the exchanged routes.
type ListPeeringRoutesNetworksRequest_Direction int32

const (
	// A value indicating that the enum field is not set.
	ListPeeringRoutesNetworksRequest_UNDEFINED_DIRECTION ListPeeringRoutesNetworksRequest_Direction = 0
	// For routes exported from peer network.
	ListPeeringRoutesNetworksRequest_INCOMING ListPeeringRoutesNetworksRequest_Direction = 338552870
	// For routes exported from local network.
	ListPeeringRoutesNetworksRequest_OUTGOING ListPeeringRoutesNetworksRequest_Direction = 307438444
)

// Enum value maps for ListPeeringRoutesNetworksRequest_Direction.
var (
	ListPeeringRoutesNetworksRequest_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		338552870: "INCOMING",
		307438444: "OUTGOING",
	}
	ListPeeringRoutesNetworksRequest_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"INCOMING":            338552870,
		"OUTGOING":            307438444,
	}
)

func (x ListPeeringRoutesNetworksRequest_Direction) Enum() *ListPeeringRoutesNetworksRequest_Direction {
	p := new(ListPeeringRoutesNetworksRequest_Direction)
	*p = x
	return p
}

func (x ListPeeringRoutesNetworksRequest_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListPeeringRoutesNetworksRequest_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[221].Descriptor()
}

func (ListPeeringRoutesNetworksRequest_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[221]
}

func (x ListPeeringRoutesNetworksRequest_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListPeeringRoutesNetworksRequest_Direction.Descriptor instead.
func (ListPeeringRoutesNetworksRequest_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{981, 0}
}

// View of the instance template.
type ListRegionInstanceTemplatesRequest_View int32

const (
	// A value indicating that the enum field is not set.
	ListRegionInstanceTemplatesRequest_UNDEFINED_VIEW ListRegionInstanceTemplatesRequest_View = 0
	// Include everything except Partner Metadata.
	ListRegionInstanceTemplatesRequest_BASIC ListRegionInstanceTemplatesRequest_View = 62970894
	// Include everything.
	ListRegionInstanceTemplatesRequest_FULL ListRegionInstanceTemplatesRequest_View = 2169487
	// The default / unset value. The API will default to the BASIC view.
	ListRegionInstanceTemplatesRequest_INSTANCE_VIEW_UNSPECIFIED ListRegionInstanceTemplatesRequest_View = 8444647
)

// Enum value maps for ListRegionInstanceTemplatesRequest_View.
var (
	ListRegionInstanceTemplatesRequest_View_name = map[int32]string{
		0:        "UNDEFINED_VIEW",
		62970894: "BASIC",
		2169487:  "FULL",
		8444647:  "INSTANCE_VIEW_UNSPECIFIED",
	}
	ListRegionInstanceTemplatesRequest_View_value = map[string]int32{
		"UNDEFINED_VIEW":            0,
		"BASIC":                     62970894,
		"FULL":                      2169487,
		"INSTANCE_VIEW_UNSPECIFIED": 8444647,
	}
)

func (x ListRegionInstanceTemplatesRequest_View) Enum() *ListRegionInstanceTemplatesRequest_View {
	p := new(ListRegionInstanceTemplatesRequest_View)
	*p = x
	return p
}

func (x ListRegionInstanceTemplatesRequest_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListRegionInstanceTemplatesRequest_View) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[222].Descriptor()
}

func (ListRegionInstanceTemplatesRequest_View) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[222]
}

func (x ListRegionInstanceTemplatesRequest_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListRegionInstanceTemplatesRequest_View.Descriptor instead.
func (ListRegionInstanceTemplatesRequest_View) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1001, 0}
}

// Defines the extra views returned back in the subnetwork resource. Supported values: - WITH_UTILIZATION: Utilization data is included in the response.
type ListSubnetworksRequest_Views int32

const (
	// A value indicating that the enum field is not set.
	ListSubnetworksRequest_UNDEFINED_VIEWS ListSubnetworksRequest_Views = 0
	ListSubnetworksRequest_DEFAULT         ListSubnetworksRequest_Views = 115302945
	// Utilization data is included in the response.
	ListSubnetworksRequest_WITH_UTILIZATION ListSubnetworksRequest_Views = 504090633
)

// Enum value maps for ListSubnetworksRequest_Views.
var (
	ListSubnetworksRequest_Views_name = map[int32]string{
		0:         "UNDEFINED_VIEWS",
		115302945: "DEFAULT",
		504090633: "WITH_UTILIZATION",
	}
	ListSubnetworksRequest_Views_value = map[string]int32{
		"UNDEFINED_VIEWS":  0,
		"DEFAULT":          115302945,
		"WITH_UTILIZATION": 504090633,
	}
)

func (x ListSubnetworksRequest_Views) Enum() *ListSubnetworksRequest_Views {
	p := new(ListSubnetworksRequest_Views)
	*p = x
	return p
}

func (x ListSubnetworksRequest_Views) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListSubnetworksRequest_Views) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[223].Descriptor()
}

func (ListSubnetworksRequest_Views) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[223]
}

func (x ListSubnetworksRequest_Views) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListSubnetworksRequest_Views.Descriptor instead.
func (ListSubnetworksRequest_Views) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1033, 0}
}

// Strategy for distributing VMs across zones in a region.
type LocationPolicy_TargetShape int32

const (
	// A value indicating that the enum field is not set.
	LocationPolicy_UNDEFINED_TARGET_SHAPE LocationPolicy_TargetShape = 0
	// GCE picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
	LocationPolicy_ANY LocationPolicy_TargetShape = 64972
	// GCE always selects a single zone for all the VMs, optimizing for resource quotas, available reservations and general capacity. Recommended for batch workloads that cannot tollerate distribution over multiple zones. This the default shape in Bulk Insert and Capacity Advisor APIs.
	LocationPolicy_ANY_SINGLE_ZONE LocationPolicy_TargetShape = 61100880
	// GCE prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across allowed zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
	LocationPolicy_BALANCED LocationPolicy_TargetShape = 468409608
)

// Enum value maps for LocationPolicy_TargetShape.
var (
	LocationPolicy_TargetShape_name = map[int32]string{
		0:         "UNDEFINED_TARGET_SHAPE",
		64972:     "ANY",
		61100880:  "ANY_SINGLE_ZONE",
		468409608: "BALANCED",
	}
	LocationPolicy_TargetShape_value = map[string]int32{
		"UNDEFINED_TARGET_SHAPE": 0,
		"ANY":                    64972,
		"ANY_SINGLE_ZONE":        61100880,
		"BALANCED":               468409608,
	}
)

func (x LocationPolicy_TargetShape) Enum() *LocationPolicy_TargetShape {
	p := new(LocationPolicy_TargetShape)
	*p = x
	return p
}

func (x LocationPolicy_TargetShape) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationPolicy_TargetShape) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[224].Descriptor()
}

func (LocationPolicy_TargetShape) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[224]
}

func (x LocationPolicy_TargetShape) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationPolicy_TargetShape.Descriptor instead.
func (LocationPolicy_TargetShape) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1055, 0}
}

// Preference for a given location. Set to either ALLOW or DENY.
type LocationPolicyLocation_Preference int32

const (
	// A value indicating that the enum field is not set.
	LocationPolicyLocation_UNDEFINED_PREFERENCE LocationPolicyLocation_Preference = 0
	// Location is allowed for use.
	LocationPolicyLocation_ALLOW LocationPolicyLocation_Preference = 62368553
	// Location is prohibited.
	LocationPolicyLocation_DENY LocationPolicyLocation_Preference = 2094604
	// Default value, unused.
	LocationPolicyLocation_PREFERENCE_UNSPECIFIED LocationPolicyLocation_Preference = 496219571
)

// Enum value maps for LocationPolicyLocation_Preference.
var (
	LocationPolicyLocation_Preference_name = map[int32]string{
		0:         "UNDEFINED_PREFERENCE",
		62368553:  "ALLOW",
		2094604:   "DENY",
		496219571: "PREFERENCE_UNSPECIFIED",
	}
	LocationPolicyLocation_Preference_value = map[string]int32{
		"UNDEFINED_PREFERENCE":   0,
		"ALLOW":                  62368553,
		"DENY":                   2094604,
		"PREFERENCE_UNSPECIFIED": 496219571,
	}
)

func (x LocationPolicyLocation_Preference) Enum() *LocationPolicyLocation_Preference {
	p := new(LocationPolicyLocation_Preference)
	*p = x
	return p
}

func (x LocationPolicyLocation_Preference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationPolicyLocation_Preference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[225].Descriptor()
}

func (LocationPolicyLocation_Preference) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[225]
}

func (x LocationPolicyLocation_Preference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationPolicyLocation_Preference.Descriptor instead.
func (LocationPolicyLocation_Preference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1056, 0}
}

// [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
type MachineImage_Status int32

const (
	// A value indicating that the enum field is not set.
	MachineImage_UNDEFINED_STATUS MachineImage_Status = 0
	MachineImage_CREATING         MachineImage_Status = 455564985
	MachineImage_DELETING         MachineImage_Status = 528602024
	MachineImage_INVALID          MachineImage_Status = 530283991
	MachineImage_READY            MachineImage_Status = 77848963
	MachineImage_UPLOADING        MachineImage_Status = 267603489
)

// Enum value maps for MachineImage_Status.
var (
	MachineImage_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
		267603489: "UPLOADING",
	}
	MachineImage_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
		"UPLOADING":        267603489,
	}
)

func (x MachineImage_Status) Enum() *MachineImage_Status {
	p := new(MachineImage_Status)
	*p = x
	return p
}

func (x MachineImage_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MachineImage_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[226].Descriptor()
}

func (MachineImage_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[226]
}

func (x MachineImage_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MachineImage_Status.Descriptor instead.
func (MachineImage_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1058, 0}
}

// [Output Only] The architecture of the machine type.
type MachineType_Architecture int32

const (
	// A value indicating that the enum field is not set.
	MachineType_UNDEFINED_ARCHITECTURE MachineType_Architecture = 0
	// Default value indicating Architecture is not set.
	MachineType_ARCHITECTURE_UNSPECIFIED MachineType_Architecture = 394750507
	// Machines with architecture ARM64
	MachineType_ARM64 MachineType_Architecture = 62547450
	// Machines with architecture X86_64
	MachineType_X86_64 MachineType_Architecture = 425300551
)

// Enum value maps for MachineType_Architecture.
var (
	MachineType_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	MachineType_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x MachineType_Architecture) Enum() *MachineType_Architecture {
	p := new(MachineType_Architecture)
	*p = x
	return p
}

func (x MachineType_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MachineType_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[227].Descriptor()
}

func (MachineType_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[227]
}

func (x MachineType_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MachineType_Architecture.Descriptor instead.
func (MachineType_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1060, 0}
}

// [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// STOPPING
// SUSPENDING
type ManagedInstance_CurrentAction int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstance_UNDEFINED_CURRENT_ACTION ManagedInstance_CurrentAction = 0
	// The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
	ManagedInstance_ABANDONING ManagedInstance_CurrentAction = 388244813
	// The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
	ManagedInstance_CREATING ManagedInstance_CurrentAction = 455564985
	// The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased.
	ManagedInstance_CREATING_WITHOUT_RETRIES ManagedInstance_CurrentAction = 428843785
	// The managed instance group is permanently deleting this instance.
	ManagedInstance_DELETING ManagedInstance_CurrentAction = 528602024
	// The managed instance group has not scheduled any actions for this instance.
	ManagedInstance_NONE ManagedInstance_CurrentAction = 2402104
	// The managed instance group is recreating this instance.
	ManagedInstance_RECREATING ManagedInstance_CurrentAction = 287278572
	// The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
	ManagedInstance_REFRESHING ManagedInstance_CurrentAction = 163266343
	// The managed instance group is restarting this instance.
	ManagedInstance_RESTARTING ManagedInstance_CurrentAction = 320534387
	// The managed instance group is resuming this instance.
	ManagedInstance_RESUMING ManagedInstance_CurrentAction = 446856618
	// The managed instance group is starting this instance.
	ManagedInstance_STARTING ManagedInstance_CurrentAction = 488820800
	// The managed instance group is verifying this already created instance. Verification happens every time the instance is (re)created or restarted and consists of: 1. Waiting until health check specified as part of this managed instance group's autohealing policy reports HEALTHY. Note: Applies only if autohealing policy has a health check specified 2. Waiting for addition verification steps performed as post-instance creation (subject to future extensions).
	ManagedInstance_VERIFYING ManagedInstance_CurrentAction = 16982185
)

// Enum value maps for ManagedInstance_CurrentAction.
var (
	ManagedInstance_CurrentAction_name = map[int32]string{
		0:         "UNDEFINED_CURRENT_ACTION",
		388244813: "ABANDONING",
		455564985: "CREATING",
		428843785: "CREATING_WITHOUT_RETRIES",
		528602024: "DELETING",
		2402104:   "NONE",
		287278572: "RECREATING",
		163266343: "REFRESHING",
		320534387: "RESTARTING",
		446856618: "RESUMING",
		488820800: "STARTING",
		16982185:  "VERIFYING",
	}
	ManagedInstance_CurrentAction_value = map[string]int32{
		"UNDEFINED_CURRENT_ACTION": 0,
		"ABANDONING":               388244813,
		"CREATING":                 455564985,
		"CREATING_WITHOUT_RETRIES": 428843785,
		"DELETING":                 528602024,
		"NONE":                     2402104,
		"RECREATING":               287278572,
		"REFRESHING":               163266343,
		"RESTARTING":               320534387,
		"RESUMING":                 446856618,
		"STARTING":                 488820800,
		"VERIFYING":                16982185,
	}
)

func (x ManagedInstance_CurrentAction) Enum() *ManagedInstance_CurrentAction {
	p := new(ManagedInstance_CurrentAction)
	*p = x
	return p
}

func (x ManagedInstance_CurrentAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstance_CurrentAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[228].Descriptor()
}

func (ManagedInstance_CurrentAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[228]
}

func (x ManagedInstance_CurrentAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstance_CurrentAction.Descriptor instead.
func (ManagedInstance_CurrentAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1064, 0}
}

// [Output Only] The status of the instance. This field is empty when the instance does not exist.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// RUNNING
// STOPPED
// STOPPING
// SUSPENDED
// SUSPENDING
type ManagedInstance_InstanceStatus int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstance_UNDEFINED_INSTANCE_STATUS ManagedInstance_InstanceStatus = 0
	// The instance is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
	ManagedInstance_DEPROVISIONING ManagedInstance_InstanceStatus = 428935662
	// For Flex Start provisioning instance is waiting for available capacity from Dynamic Workload Scheduler (DWS).
	ManagedInstance_PENDING ManagedInstance_InstanceStatus = 35394935
	// The instance is gracefully shutting down.
	ManagedInstance_PENDING_STOP ManagedInstance_InstanceStatus = 362509770
	// Resources are being allocated for the instance.
	ManagedInstance_PROVISIONING ManagedInstance_InstanceStatus = 290896621
	// The instance is in repair.
	ManagedInstance_REPAIRING ManagedInstance_InstanceStatus = 413483285
	ManagedInstance_RUNNING   ManagedInstance_InstanceStatus = 121282975
	// All required resources have been allocated and the instance is being started.
	ManagedInstance_STAGING    ManagedInstance_InstanceStatus = 431072283
	ManagedInstance_STOPPED    ManagedInstance_InstanceStatus = 444276141
	ManagedInstance_STOPPING   ManagedInstance_InstanceStatus = 350791796
	ManagedInstance_SUSPENDED  ManagedInstance_InstanceStatus = 51223995
	ManagedInstance_SUSPENDING ManagedInstance_InstanceStatus = 514206246
	// The instance has stopped (either by explicit action or underlying failure).
	ManagedInstance_TERMINATED ManagedInstance_InstanceStatus = 250018339
)

// Enum value maps for ManagedInstance_InstanceStatus.
var (
	ManagedInstance_InstanceStatus_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_STATUS",
		428935662: "DEPROVISIONING",
		35394935:  "PENDING",
		362509770: "PENDING_STOP",
		290896621: "PROVISIONING",
		413483285: "REPAIRING",
		121282975: "RUNNING",
		431072283: "STAGING",
		444276141: "STOPPED",
		350791796: "STOPPING",
		51223995:  "SUSPENDED",
		514206246: "SUSPENDING",
		250018339: "TERMINATED",
	}
	ManagedInstance_InstanceStatus_value = map[string]int32{
		"UNDEFINED_INSTANCE_STATUS": 0,
		"DEPROVISIONING":            428935662,
		"PENDING":                   35394935,
		"PENDING_STOP":              362509770,
		"PROVISIONING":              290896621,
		"REPAIRING":                 413483285,
		"RUNNING":                   121282975,
		"STAGING":                   431072283,
		"STOPPED":                   444276141,
		"STOPPING":                  350791796,
		"SUSPENDED":                 51223995,
		"SUSPENDING":                514206246,
		"TERMINATED":                250018339,
	}
)

func (x ManagedInstance_InstanceStatus) Enum() *ManagedInstance_InstanceStatus {
	p := new(ManagedInstance_InstanceStatus)
	*p = x
	return p
}

func (x ManagedInstance_InstanceStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstance_InstanceStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[229].Descriptor()
}

func (ManagedInstance_InstanceStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[229]
}

func (x ManagedInstance_InstanceStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstance_InstanceStatus.Descriptor instead.
func (ManagedInstance_InstanceStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1064, 1}
}

// [Output Only] The eventual status of the instance. The instance group manager will not be identified as stable till each managed instance reaches its targetStatus.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// RUNNING
// STOPPED
// SUSPENDED
type ManagedInstance_TargetStatus int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstance_UNDEFINED_TARGET_STATUS ManagedInstance_TargetStatus = 0
	// The managed instance will eventually be ABANDONED, i.e. dissociated from the managed instance group.
	ManagedInstance_ABANDONED ManagedInstance_TargetStatus = 81797556
	// The managed instance will eventually be DELETED.
	ManagedInstance_DELETED ManagedInstance_TargetStatus = 120962041
)

// Enum value maps for ManagedInstance_TargetStatus.
var (
	ManagedInstance_TargetStatus_name = map[int32]string{
		0:         "UNDEFINED_TARGET_STATUS",
		81797556:  "ABANDONED",
		120962041: "DELETED",
	}
	ManagedInstance_TargetStatus_value = map[string]int32{
		"UNDEFINED_TARGET_STATUS": 0,
		"ABANDONED":               81797556,
		"DELETED":                 120962041,
	}
)

func (x ManagedInstance_TargetStatus) Enum() *ManagedInstance_TargetStatus {
	p := new(ManagedInstance_TargetStatus)
	*p = x
	return p
}

func (x ManagedInstance_TargetStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstance_TargetStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[230].Descriptor()
}

func (ManagedInstance_TargetStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[230]
}

func (x ManagedInstance_TargetStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstance_TargetStatus.Descriptor instead.
func (ManagedInstance_TargetStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1064, 2}
}

// [Output Only] The current detailed instance health state.
type ManagedInstanceInstanceHealth_DetailedHealthState int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstanceInstanceHealth_UNDEFINED_DETAILED_HEALTH_STATE ManagedInstanceInstanceHealth_DetailedHealthState = 0
	// The instance is being drained. The existing connections to the instance have time to complete, but the new ones are being refused.
	ManagedInstanceInstanceHealth_DRAINING ManagedInstanceInstanceHealth_DetailedHealthState = 480455402
	// The instance is reachable i.e. a connection to the application health checking endpoint can be established, and conforms to the requirements defined by the health check.
	ManagedInstanceInstanceHealth_HEALTHY ManagedInstanceInstanceHealth_DetailedHealthState = 439801213
	// The instance is unreachable i.e. a connection to the application health checking endpoint cannot be established, or the server does not respond within the specified timeout.
	ManagedInstanceInstanceHealth_TIMEOUT ManagedInstanceInstanceHealth_DetailedHealthState = 477813057
	// The instance is reachable, but does not conform to the requirements defined by the health check.
	ManagedInstanceInstanceHealth_UNHEALTHY ManagedInstanceInstanceHealth_DetailedHealthState = 462118084
	// The health checking system is aware of the instance but its health is not known at the moment.
	ManagedInstanceInstanceHealth_UNKNOWN ManagedInstanceInstanceHealth_DetailedHealthState = 433141802
)

// Enum value maps for ManagedInstanceInstanceHealth_DetailedHealthState.
var (
	ManagedInstanceInstanceHealth_DetailedHealthState_name = map[int32]string{
		0:         "UNDEFINED_DETAILED_HEALTH_STATE",
		480455402: "DRAINING",
		439801213: "HEALTHY",
		477813057: "TIMEOUT",
		462118084: "UNHEALTHY",
		433141802: "UNKNOWN",
	}
	ManagedInstanceInstanceHealth_DetailedHealthState_value = map[string]int32{
		"UNDEFINED_DETAILED_HEALTH_STATE": 0,
		"DRAINING":                        480455402,
		"HEALTHY":                         439801213,
		"TIMEOUT":                         477813057,
		"UNHEALTHY":                       462118084,
		"UNKNOWN":                         433141802,
	}
)

func (x ManagedInstanceInstanceHealth_DetailedHealthState) Enum() *ManagedInstanceInstanceHealth_DetailedHealthState {
	p := new(ManagedInstanceInstanceHealth_DetailedHealthState)
	*p = x
	return p
}

func (x ManagedInstanceInstanceHealth_DetailedHealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstanceInstanceHealth_DetailedHealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[231].Descriptor()
}

func (ManagedInstanceInstanceHealth_DetailedHealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[231]
}

func (x ManagedInstanceInstanceHealth_DetailedHealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstanceInstanceHealth_DetailedHealthState.Descriptor instead.
func (ManagedInstanceInstanceHealth_DetailedHealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1066, 0}
}

// The provisioning model to be used for this instance.
type ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstancePropertiesFromFlexibilityPolicy_UNDEFINED_PROVISIONING_MODEL ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel = 0
	// Instance is provisioned using the Flex Start provisioning model and has a limited runtime.
	ManagedInstancePropertiesFromFlexibilityPolicy_FLEX_START ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel = 101746812
	// Bound to the lifecycle of the reservation in which it is provisioned.
	ManagedInstancePropertiesFromFlexibilityPolicy_RESERVATION_BOUND ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel = 293538571
	// Heavily discounted, no guaranteed runtime.
	ManagedInstancePropertiesFromFlexibilityPolicy_SPOT ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel = 2552066
	// Standard provisioning with user controlled runtime, no discounts.
	ManagedInstancePropertiesFromFlexibilityPolicy_STANDARD ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel = 484642493
)

// Enum value maps for ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel.
var (
	ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel_name = map[int32]string{
		0:         "UNDEFINED_PROVISIONING_MODEL",
		101746812: "FLEX_START",
		293538571: "RESERVATION_BOUND",
		2552066:   "SPOT",
		484642493: "STANDARD",
	}
	ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel_value = map[string]int32{
		"UNDEFINED_PROVISIONING_MODEL": 0,
		"FLEX_START":                   101746812,
		"RESERVATION_BOUND":            293538571,
		"SPOT":                         2552066,
		"STANDARD":                     484642493,
	}
)

func (x ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel) Enum() *ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel {
	p := new(ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel)
	*p = x
	return p
}

func (x ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[232].Descriptor()
}

func (ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[232]
}

func (x ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel.Descriptor instead.
func (ManagedInstancePropertiesFromFlexibilityPolicy_ProvisioningModel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1069, 0}
}

// Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
type MetadataFilter_FilterMatchCriteria int32

const (
	// A value indicating that the enum field is not set.
	MetadataFilter_UNDEFINED_FILTER_MATCH_CRITERIA MetadataFilter_FilterMatchCriteria = 0
	// Specifies that all filterLabels must match for the metadataFilter to be considered a match.
	MetadataFilter_MATCH_ALL MetadataFilter_FilterMatchCriteria = 180663271
	// Specifies that any filterLabel must match for the metadataFilter to be considered a match.
	MetadataFilter_MATCH_ANY MetadataFilter_FilterMatchCriteria = 180663346
	// Indicates that the match criteria was not set. A metadataFilter must never be created with this value.
	MetadataFilter_NOT_SET MetadataFilter_FilterMatchCriteria = 163646646
)

// Enum value maps for MetadataFilter_FilterMatchCriteria.
var (
	MetadataFilter_FilterMatchCriteria_name = map[int32]string{
		0:         "UNDEFINED_FILTER_MATCH_CRITERIA",
		180663271: "MATCH_ALL",
		180663346: "MATCH_ANY",
		163646646: "NOT_SET",
	}
	MetadataFilter_FilterMatchCriteria_value = map[string]int32{
		"UNDEFINED_FILTER_MATCH_CRITERIA": 0,
		"MATCH_ALL":                       180663271,
		"MATCH_ANY":                       180663346,
		"NOT_SET":                         163646646,
	}
)

func (x MetadataFilter_FilterMatchCriteria) Enum() *MetadataFilter_FilterMatchCriteria {
	p := new(MetadataFilter_FilterMatchCriteria)
	*p = x
	return p
}

func (x MetadataFilter_FilterMatchCriteria) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataFilter_FilterMatchCriteria) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[233].Descriptor()
}

func (MetadataFilter_FilterMatchCriteria) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[233]
}

func (x MetadataFilter_FilterMatchCriteria) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataFilter_FilterMatchCriteria.Descriptor instead.
func (MetadataFilter_FilterMatchCriteria) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1073, 0}
}

// [Output Only] The state of the accelerator topology.
type MultiMigStatusAcceleratorTopology_AcceleratorTopologyState int32

const (
	// A value indicating that the enum field is not set.
	MultiMigStatusAcceleratorTopology_UNDEFINED_ACCELERATOR_TOPOLOGY_STATE MultiMigStatusAcceleratorTopology_AcceleratorTopologyState = 0
	// The accelerator topology is being activated.
	MultiMigStatusAcceleratorTopology_ACTIVATING MultiMigStatusAcceleratorTopology_AcceleratorTopologyState = 378825968
	// The accelerator topology is active.
	MultiMigStatusAcceleratorTopology_ACTIVE MultiMigStatusAcceleratorTopology_AcceleratorTopologyState = 314733318
	// The accelerator topology is active but operating in degraded mode.
	MultiMigStatusAcceleratorTopology_ACTIVE_DEGRADED MultiMigStatusAcceleratorTopology_AcceleratorTopologyState = 471128135
	// The accelerator topology is being deactivated.
	MultiMigStatusAcceleratorTopology_DEACTIVATING MultiMigStatusAcceleratorTopology_AcceleratorTopologyState = 57182257
	// The accelerator topology failed.
	MultiMigStatusAcceleratorTopology_FAILED MultiMigStatusAcceleratorTopology_AcceleratorTopologyState = 455706685
	// The configuration is incomplete and the accelerator topology cannot be activated due to insufficient number of running VMs.
	MultiMigStatusAcceleratorTopology_INCOMPLETE MultiMigStatusAcceleratorTopology_AcceleratorTopologyState = 11941214
)

// Enum value maps for MultiMigStatusAcceleratorTopology_AcceleratorTopologyState.
var (
	MultiMigStatusAcceleratorTopology_AcceleratorTopologyState_name = map[int32]string{
		0:         "UNDEFINED_ACCELERATOR_TOPOLOGY_STATE",
		378825968: "ACTIVATING",
		314733318: "ACTIVE",
		471128135: "ACTIVE_DEGRADED",
		57182257:  "DEACTIVATING",
		455706685: "FAILED",
		11941214:  "INCOMPLETE",
	}
	MultiMigStatusAcceleratorTopology_AcceleratorTopologyState_value = map[string]int32{
		"UNDEFINED_ACCELERATOR_TOPOLOGY_STATE": 0,
		"ACTIVATING":                           378825968,
		"ACTIVE":                               314733318,
		"ACTIVE_DEGRADED":                      471128135,
		"DEACTIVATING":                         57182257,
		"FAILED":                               455706685,
		"INCOMPLETE":                           11941214,
	}
)

func (x MultiMigStatusAcceleratorTopology_AcceleratorTopologyState) Enum() *MultiMigStatusAcceleratorTopology_AcceleratorTopologyState {
	p := new(MultiMigStatusAcceleratorTopology_AcceleratorTopologyState)
	*p = x
	return p
}

func (x MultiMigStatusAcceleratorTopology_AcceleratorTopologyState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MultiMigStatusAcceleratorTopology_AcceleratorTopologyState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[234].Descriptor()
}

func (MultiMigStatusAcceleratorTopology_AcceleratorTopologyState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[234]
}

func (x MultiMigStatusAcceleratorTopology_AcceleratorTopologyState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MultiMigStatusAcceleratorTopology_AcceleratorTopologyState.Descriptor instead.
func (MultiMigStatusAcceleratorTopology_AcceleratorTopologyState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1084, 0}
}

// Specifies whether NAT IP is auto or manual.
type NatIpInfoNatIpInfoMapping_Mode int32

const (
	// A value indicating that the enum field is not set.
	NatIpInfoNatIpInfoMapping_UNDEFINED_MODE NatIpInfoNatIpInfoMapping_Mode = 0
	NatIpInfoNatIpInfoMapping_AUTO           NatIpInfoNatIpInfoMapping_Mode = 2020783
	NatIpInfoNatIpInfoMapping_MANUAL         NatIpInfoNatIpInfoMapping_Mode = 119397318
)

// Enum value maps for NatIpInfoNatIpInfoMapping_Mode.
var (
	NatIpInfoNatIpInfoMapping_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		2020783:   "AUTO",
		119397318: "MANUAL",
	}
	NatIpInfoNatIpInfoMapping_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"AUTO":           2020783,
		"MANUAL":         119397318,
	}
)

func (x NatIpInfoNatIpInfoMapping_Mode) Enum() *NatIpInfoNatIpInfoMapping_Mode {
	p := new(NatIpInfoNatIpInfoMapping_Mode)
	*p = x
	return p
}

func (x NatIpInfoNatIpInfoMapping_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NatIpInfoNatIpInfoMapping_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[235].Descriptor()
}

func (NatIpInfoNatIpInfoMapping_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[235]
}

func (x NatIpInfoNatIpInfoMapping_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NatIpInfoNatIpInfoMapping_Mode.Descriptor instead.
func (NatIpInfoNatIpInfoMapping_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1089, 0}
}

// Specifies whether NAT IP is currently serving at least one endpoint or not.
type NatIpInfoNatIpInfoMapping_Usage int32

const (
	// A value indicating that the enum field is not set.
	NatIpInfoNatIpInfoMapping_UNDEFINED_USAGE NatIpInfoNatIpInfoMapping_Usage = 0
	NatIpInfoNatIpInfoMapping_IN_USE          NatIpInfoNatIpInfoMapping_Usage = 17393485
	NatIpInfoNatIpInfoMapping_UNUSED          NatIpInfoNatIpInfoMapping_Usage = 360643030
)

// Enum value maps for NatIpInfoNatIpInfoMapping_Usage.
var (
	NatIpInfoNatIpInfoMapping_Usage_name = map[int32]string{
		0:         "UNDEFINED_USAGE",
		17393485:  "IN_USE",
		360643030: "UNUSED",
	}
	NatIpInfoNatIpInfoMapping_Usage_value = map[string]int32{
		"UNDEFINED_USAGE": 0,
		"IN_USE":          17393485,
		"UNUSED":          360643030,
	}
)

func (x NatIpInfoNatIpInfoMapping_Usage) Enum() *NatIpInfoNatIpInfoMapping_Usage {
	p := new(NatIpInfoNatIpInfoMapping_Usage)
	*p = x
	return p
}

func (x NatIpInfoNatIpInfoMapping_Usage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NatIpInfoNatIpInfoMapping_Usage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[236].Descriptor()
}

func (NatIpInfoNatIpInfoMapping_Usage) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[236]
}

func (x NatIpInfoNatIpInfoMapping_Usage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NatIpInfoNatIpInfoMapping_Usage.Descriptor instead.
func (NatIpInfoNatIpInfoMapping_Usage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1089, 1}
}

// The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
type Network_NetworkFirewallPolicyEnforcementOrder int32

const (
	// A value indicating that the enum field is not set.
	Network_UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER Network_NetworkFirewallPolicyEnforcementOrder = 0
	Network_AFTER_CLASSIC_FIREWALL                              Network_NetworkFirewallPolicyEnforcementOrder = 154582608
	Network_BEFORE_CLASSIC_FIREWALL                             Network_NetworkFirewallPolicyEnforcementOrder = 338458349
)

// Enum value maps for Network_NetworkFirewallPolicyEnforcementOrder.
var (
	Network_NetworkFirewallPolicyEnforcementOrder_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER",
		154582608: "AFTER_CLASSIC_FIREWALL",
		338458349: "BEFORE_CLASSIC_FIREWALL",
	}
	Network_NetworkFirewallPolicyEnforcementOrder_value = map[string]int32{
		"UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER": 0,
		"AFTER_CLASSIC_FIREWALL":                              154582608,
		"BEFORE_CLASSIC_FIREWALL":                             338458349,
	}
)

func (x Network_NetworkFirewallPolicyEnforcementOrder) Enum() *Network_NetworkFirewallPolicyEnforcementOrder {
	p := new(Network_NetworkFirewallPolicyEnforcementOrder)
	*p = x
	return p
}

func (x Network_NetworkFirewallPolicyEnforcementOrder) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Network_NetworkFirewallPolicyEnforcementOrder) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[237].Descriptor()
}

func (Network_NetworkFirewallPolicyEnforcementOrder) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[237]
}

func (x Network_NetworkFirewallPolicyEnforcementOrder) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Network_NetworkFirewallPolicyEnforcementOrder.Descriptor instead.
func (Network_NetworkFirewallPolicyEnforcementOrder) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1091, 0}
}

type NetworkAttachment_ConnectionPreference int32

const (
	// A value indicating that the enum field is not set.
	NetworkAttachment_UNDEFINED_CONNECTION_PREFERENCE NetworkAttachment_ConnectionPreference = 0
	NetworkAttachment_ACCEPT_AUTOMATIC                NetworkAttachment_ConnectionPreference = 75250580
	NetworkAttachment_ACCEPT_MANUAL                   NetworkAttachment_ConnectionPreference = 373061341
	NetworkAttachment_INVALID                         NetworkAttachment_ConnectionPreference = 530283991
)

// Enum value maps for NetworkAttachment_ConnectionPreference.
var (
	NetworkAttachment_ConnectionPreference_name = map[int32]string{
		0:         "UNDEFINED_CONNECTION_PREFERENCE",
		75250580:  "ACCEPT_AUTOMATIC",
		373061341: "ACCEPT_MANUAL",
		530283991: "INVALID",
	}
	NetworkAttachment_ConnectionPreference_value = map[string]int32{
		"UNDEFINED_CONNECTION_PREFERENCE": 0,
		"ACCEPT_AUTOMATIC":                75250580,
		"ACCEPT_MANUAL":                   373061341,
		"INVALID":                         530283991,
	}
)

func (x NetworkAttachment_ConnectionPreference) Enum() *NetworkAttachment_ConnectionPreference {
	p := new(NetworkAttachment_ConnectionPreference)
	*p = x
	return p
}

func (x NetworkAttachment_ConnectionPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkAttachment_ConnectionPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[238].Descriptor()
}

func (NetworkAttachment_ConnectionPreference) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[238]
}

func (x NetworkAttachment_ConnectionPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkAttachment_ConnectionPreference.Descriptor instead.
func (NetworkAttachment_ConnectionPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1092, 0}
}

// The status of a connected endpoint to this network attachment.
type NetworkAttachmentConnectedEndpoint_Status int32

const (
	// A value indicating that the enum field is not set.
	NetworkAttachmentConnectedEndpoint_UNDEFINED_STATUS NetworkAttachmentConnectedEndpoint_Status = 0
	// The consumer allows traffic from the producer to reach its VPC.
	NetworkAttachmentConnectedEndpoint_ACCEPTED NetworkAttachmentConnectedEndpoint_Status = 246714279
	// The consumer network attachment no longer exists.
	NetworkAttachmentConnectedEndpoint_CLOSED NetworkAttachmentConnectedEndpoint_Status = 380163436
	// The consumer needs to take further action before traffic can be served.
	NetworkAttachmentConnectedEndpoint_NEEDS_ATTENTION NetworkAttachmentConnectedEndpoint_Status = 344491452
	// The consumer neither allows nor prohibits traffic from the producer to reach its VPC.
	NetworkAttachmentConnectedEndpoint_PENDING NetworkAttachmentConnectedEndpoint_Status = 35394935
	// The consumer prohibits traffic from the producer to reach its VPC.
	NetworkAttachmentConnectedEndpoint_REJECTED           NetworkAttachmentConnectedEndpoint_Status = 174130302
	NetworkAttachmentConnectedEndpoint_STATUS_UNSPECIFIED NetworkAttachmentConnectedEndpoint_Status = 42133066
)

// Enum value maps for NetworkAttachmentConnectedEndpoint_Status.
var (
	NetworkAttachmentConnectedEndpoint_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		246714279: "ACCEPTED",
		380163436: "CLOSED",
		344491452: "NEEDS_ATTENTION",
		35394935:  "PENDING",
		174130302: "REJECTED",
		42133066:  "STATUS_UNSPECIFIED",
	}
	NetworkAttachmentConnectedEndpoint_Status_value = map[string]int32{
		"UNDEFINED_STATUS":   0,
		"ACCEPTED":           246714279,
		"CLOSED":             380163436,
		"NEEDS_ATTENTION":    344491452,
		"PENDING":            35394935,
		"REJECTED":           174130302,
		"STATUS_UNSPECIFIED": 42133066,
	}
)

func (x NetworkAttachmentConnectedEndpoint_Status) Enum() *NetworkAttachmentConnectedEndpoint_Status {
	p := new(NetworkAttachmentConnectedEndpoint_Status)
	*p = x
	return p
}

func (x NetworkAttachmentConnectedEndpoint_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkAttachmentConnectedEndpoint_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[239].Descriptor()
}

func (NetworkAttachmentConnectedEndpoint_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[239]
}

func (x NetworkAttachmentConnectedEndpoint_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkAttachmentConnectedEndpoint_Status.Descriptor instead.
func (NetworkAttachmentConnectedEndpoint_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1094, 0}
}

// Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
type NetworkEndpointGroup_NetworkEndpointType int32

const (
	// A value indicating that the enum field is not set.
	NetworkEndpointGroup_UNDEFINED_NETWORK_ENDPOINT_TYPE NetworkEndpointGroup_NetworkEndpointType = 0
	// The network endpoint is represented by an IP address.
	NetworkEndpointGroup_GCE_VM_IP NetworkEndpointGroup_NetworkEndpointType = 401880793
	// The network endpoint is represented by IP address and port pair.
	NetworkEndpointGroup_GCE_VM_IP_PORT NetworkEndpointGroup_NetworkEndpointType = 501838375
	// The network endpoint is represented by an IP, Port and Client Destination Port.
	NetworkEndpointGroup_GCE_VM_IP_PORTMAP NetworkEndpointGroup_NetworkEndpointType = 22819253
	// The network endpoint is represented by fully qualified domain name and port.
	NetworkEndpointGroup_INTERNET_FQDN_PORT NetworkEndpointGroup_NetworkEndpointType = 404154477
	// The network endpoint is represented by an internet IP address and port.
	NetworkEndpointGroup_INTERNET_IP_PORT NetworkEndpointGroup_NetworkEndpointType = 477719963
	// The network endpoint is represented by an IP address and port. The endpoint belongs to a VM or pod running in a customer's on-premises.
	NetworkEndpointGroup_NON_GCP_PRIVATE_IP_PORT NetworkEndpointGroup_NetworkEndpointType = 336447968
	// The network endpoint is either public Google APIs or services exposed by other GCP Project with a Service Attachment. The connection is set up by private service connect
	NetworkEndpointGroup_PRIVATE_SERVICE_CONNECT NetworkEndpointGroup_NetworkEndpointType = 48134724
	// The network endpoint is handled by specified serverless infrastructure.
	NetworkEndpointGroup_SERVERLESS NetworkEndpointGroup_NetworkEndpointType = 270492508
)

// Enum value maps for NetworkEndpointGroup_NetworkEndpointType.
var (
	NetworkEndpointGroup_NetworkEndpointType_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_ENDPOINT_TYPE",
		401880793: "GCE_VM_IP",
		501838375: "GCE_VM_IP_PORT",
		22819253:  "GCE_VM_IP_PORTMAP",
		404154477: "INTERNET_FQDN_PORT",
		477719963: "INTERNET_IP_PORT",
		336447968: "NON_GCP_PRIVATE_IP_PORT",
		48134724:  "PRIVATE_SERVICE_CONNECT",
		270492508: "SERVERLESS",
	}
	NetworkEndpointGroup_NetworkEndpointType_value = map[string]int32{
		"UNDEFINED_NETWORK_ENDPOINT_TYPE": 0,
		"GCE_VM_IP":                       401880793,
		"GCE_VM_IP_PORT":                  501838375,
		"GCE_VM_IP_PORTMAP":               22819253,
		"INTERNET_FQDN_PORT":              404154477,
		"INTERNET_IP_PORT":                477719963,
		"NON_GCP_PRIVATE_IP_PORT":         336447968,
		"PRIVATE_SERVICE_CONNECT":         48134724,
		"SERVERLESS":                      270492508,
	}
)

func (x NetworkEndpointGroup_NetworkEndpointType) Enum() *NetworkEndpointGroup_NetworkEndpointType {
	p := new(NetworkEndpointGroup_NetworkEndpointType)
	*p = x
	return p
}

func (x NetworkEndpointGroup_NetworkEndpointType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkEndpointGroup_NetworkEndpointType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[240].Descriptor()
}

func (NetworkEndpointGroup_NetworkEndpointType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[240]
}

func (x NetworkEndpointGroup_NetworkEndpointType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkEndpointGroup_NetworkEndpointType.Descriptor instead.
func (NetworkEndpointGroup_NetworkEndpointType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1101, 0}
}

// [Output Only] The connection status of the PSC Forwarding Rule.
type NetworkEndpointGroupPscData_PscConnectionStatus int32

const (
	// A value indicating that the enum field is not set.
	NetworkEndpointGroupPscData_UNDEFINED_PSC_CONNECTION_STATUS NetworkEndpointGroupPscData_PscConnectionStatus = 0
	// The connection has been accepted by the producer.
	NetworkEndpointGroupPscData_ACCEPTED NetworkEndpointGroupPscData_PscConnectionStatus = 246714279
	// The connection has been closed by the producer and will not serve traffic going forward.
	NetworkEndpointGroupPscData_CLOSED NetworkEndpointGroupPscData_PscConnectionStatus = 380163436
	// The connection has been accepted by the producer, but the producer needs to take further action before the forwarding rule can serve traffic.
	NetworkEndpointGroupPscData_NEEDS_ATTENTION NetworkEndpointGroupPscData_PscConnectionStatus = 344491452
	// The connection is pending acceptance by the producer.
	NetworkEndpointGroupPscData_PENDING NetworkEndpointGroupPscData_PscConnectionStatus = 35394935
	// The connection has been rejected by the producer.
	NetworkEndpointGroupPscData_REJECTED           NetworkEndpointGroupPscData_PscConnectionStatus = 174130302
	NetworkEndpointGroupPscData_STATUS_UNSPECIFIED NetworkEndpointGroupPscData_PscConnectionStatus = 42133066
)

// Enum value maps for NetworkEndpointGroupPscData_PscConnectionStatus.
var (
	NetworkEndpointGroupPscData_PscConnectionStatus_name = map[int32]string{
		0:         "UNDEFINED_PSC_CONNECTION_STATUS",
		246714279: "ACCEPTED",
		380163436: "CLOSED",
		344491452: "NEEDS_ATTENTION",
		35394935:  "PENDING",
		174130302: "REJECTED",
		42133066:  "STATUS_UNSPECIFIED",
	}
	NetworkEndpointGroupPscData_PscConnectionStatus_value = map[string]int32{
		"UNDEFINED_PSC_CONNECTION_STATUS": 0,
		"ACCEPTED":                        246714279,
		"CLOSED":                          380163436,
		"NEEDS_ATTENTION":                 344491452,
		"PENDING":                         35394935,
		"REJECTED":                        174130302,
		"STATUS_UNSPECIFIED":              42133066,
	}
)

func (x NetworkEndpointGroupPscData_PscConnectionStatus) Enum() *NetworkEndpointGroupPscData_PscConnectionStatus {
	p := new(NetworkEndpointGroupPscData_PscConnectionStatus)
	*p = x
	return p
}

func (x NetworkEndpointGroupPscData_PscConnectionStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkEndpointGroupPscData_PscConnectionStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[241].Descriptor()
}

func (NetworkEndpointGroupPscData_PscConnectionStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[241]
}

func (x NetworkEndpointGroupPscData_PscConnectionStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkEndpointGroupPscData_PscConnectionStatus.Descriptor instead.
func (NetworkEndpointGroupPscData_PscConnectionStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1108, 0}
}

// Optional query parameter for showing the health status of each network endpoint. Valid options are SKIP or SHOW. If you don't specify this parameter, the health status of network endpoints will not be provided.
type NetworkEndpointGroupsListEndpointsRequest_HealthStatus int32

const (
	// A value indicating that the enum field is not set.
	NetworkEndpointGroupsListEndpointsRequest_UNDEFINED_HEALTH_STATUS NetworkEndpointGroupsListEndpointsRequest_HealthStatus = 0
	// Show the health status for each network endpoint. Impacts latency of the call.
	NetworkEndpointGroupsListEndpointsRequest_SHOW NetworkEndpointGroupsListEndpointsRequest_HealthStatus = 2544381
	// Health status for network endpoints will not be provided.
	NetworkEndpointGroupsListEndpointsRequest_SKIP NetworkEndpointGroupsListEndpointsRequest_HealthStatus = 2547071
)

// Enum value maps for NetworkEndpointGroupsListEndpointsRequest_HealthStatus.
var (
	NetworkEndpointGroupsListEndpointsRequest_HealthStatus_name = map[int32]string{
		0:       "UNDEFINED_HEALTH_STATUS",
		2544381: "SHOW",
		2547071: "SKIP",
	}
	NetworkEndpointGroupsListEndpointsRequest_HealthStatus_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS": 0,
		"SHOW":                    2544381,
		"SKIP":                    2547071,
	}
)

func (x NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Enum() *NetworkEndpointGroupsListEndpointsRequest_HealthStatus {
	p := new(NetworkEndpointGroupsListEndpointsRequest_HealthStatus)
	*p = x
	return p
}

func (x NetworkEndpointGroupsListEndpointsRequest_HealthStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[242].Descriptor()
}

func (NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[242]
}

func (x NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkEndpointGroupsListEndpointsRequest_HealthStatus.Descriptor instead.
func (NetworkEndpointGroupsListEndpointsRequest_HealthStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1112, 0}
}

// Indicate whether igmp query is enabled on the network interface or not. If enabled, also indicates the version of IGMP supported.
type NetworkInterface_IgmpQuery int32

const (
	// A value indicating that the enum field is not set.
	NetworkInterface_UNDEFINED_IGMP_QUERY NetworkInterface_IgmpQuery = 0
	// The network interface has disabled IGMP query.
	NetworkInterface_IGMP_QUERY_DISABLED NetworkInterface_IgmpQuery = 28285169
	// The network interface has enabled IGMP query - v2.
	NetworkInterface_IGMP_QUERY_V2 NetworkInterface_IgmpQuery = 333493457
)

// Enum value maps for NetworkInterface_IgmpQuery.
var (
	NetworkInterface_IgmpQuery_name = map[int32]string{
		0:         "UNDEFINED_IGMP_QUERY",
		28285169:  "IGMP_QUERY_DISABLED",
		333493457: "IGMP_QUERY_V2",
	}
	NetworkInterface_IgmpQuery_value = map[string]int32{
		"UNDEFINED_IGMP_QUERY": 0,
		"IGMP_QUERY_DISABLED":  28285169,
		"IGMP_QUERY_V2":        333493457,
	}
)

func (x NetworkInterface_IgmpQuery) Enum() *NetworkInterface_IgmpQuery {
	p := new(NetworkInterface_IgmpQuery)
	*p = x
	return p
}

func (x NetworkInterface_IgmpQuery) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_IgmpQuery) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[243].Descriptor()
}

func (NetworkInterface_IgmpQuery) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[243]
}

func (x NetworkInterface_IgmpQuery) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_IgmpQuery.Descriptor instead.
func (NetworkInterface_IgmpQuery) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1118, 0}
}

// [Output Only] One of EXTERNAL, INTERNAL to indicate whether the IP can be accessed from the Internet. This field is always inherited from its subnetwork. Valid only if stackType is IPV4_IPV6.
type NetworkInterface_Ipv6AccessType int32

const (
	// A value indicating that the enum field is not set.
	NetworkInterface_UNDEFINED_IPV6_ACCESS_TYPE NetworkInterface_Ipv6AccessType = 0
	// This network interface can have external IPv6.
	NetworkInterface_EXTERNAL NetworkInterface_Ipv6AccessType = 35607499
	// This network interface can have internal IPv6.
	NetworkInterface_INTERNAL                     NetworkInterface_Ipv6AccessType = 279295677
	NetworkInterface_UNSPECIFIED_IPV6_ACCESS_TYPE NetworkInterface_Ipv6AccessType = 313080613
)

// Enum value maps for NetworkInterface_Ipv6AccessType.
var (
	NetworkInterface_Ipv6AccessType_name = map[int32]string{
		0:         "UNDEFINED_IPV6_ACCESS_TYPE",
		35607499:  "EXTERNAL",
		279295677: "INTERNAL",
		313080613: "UNSPECIFIED_IPV6_ACCESS_TYPE",
	}
	NetworkInterface_Ipv6AccessType_value = map[string]int32{
		"UNDEFINED_IPV6_ACCESS_TYPE":   0,
		"EXTERNAL":                     35607499,
		"INTERNAL":                     279295677,
		"UNSPECIFIED_IPV6_ACCESS_TYPE": 313080613,
	}
)

func (x NetworkInterface_Ipv6AccessType) Enum() *NetworkInterface_Ipv6AccessType {
	p := new(NetworkInterface_Ipv6AccessType)
	*p = x
	return p
}

func (x NetworkInterface_Ipv6AccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_Ipv6AccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[244].Descriptor()
}

func (NetworkInterface_Ipv6AccessType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[244]
}

func (x NetworkInterface_Ipv6AccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_Ipv6AccessType.Descriptor instead.
func (NetworkInterface_Ipv6AccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1118, 1}
}

// The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
type NetworkInterface_NicType int32

const (
	// A value indicating that the enum field is not set.
	NetworkInterface_UNDEFINED_NIC_TYPE NetworkInterface_NicType = 0
	// GVNIC
	NetworkInterface_GVNIC NetworkInterface_NicType = 68209305
	// IDPF
	NetworkInterface_IDPF NetworkInterface_NicType = 2242641
	// IRDMA
	NetworkInterface_IRDMA NetworkInterface_NicType = 69927695
	// MRDMA
	NetworkInterface_MRDMA NetworkInterface_NicType = 73621779
	// No type specified.
	NetworkInterface_UNSPECIFIED_NIC_TYPE NetworkInterface_NicType = 67411801
	// VIRTIO
	NetworkInterface_VIRTIO_NET NetworkInterface_NicType = 452123481
)

// Enum value maps for NetworkInterface_NicType.
var (
	NetworkInterface_NicType_name = map[int32]string{
		0:         "UNDEFINED_NIC_TYPE",
		68209305:  "GVNIC",
		2242641:   "IDPF",
		69927695:  "IRDMA",
		73621779:  "MRDMA",
		67411801:  "UNSPECIFIED_NIC_TYPE",
		452123481: "VIRTIO_NET",
	}
	NetworkInterface_NicType_value = map[string]int32{
		"UNDEFINED_NIC_TYPE":   0,
		"GVNIC":                68209305,
		"IDPF":                 2242641,
		"IRDMA":                69927695,
		"MRDMA":                73621779,
		"UNSPECIFIED_NIC_TYPE": 67411801,
		"VIRTIO_NET":           452123481,
	}
)

func (x NetworkInterface_NicType) Enum() *NetworkInterface_NicType {
	p := new(NetworkInterface_NicType)
	*p = x
	return p
}

func (x NetworkInterface_NicType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_NicType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[245].Descriptor()
}

func (NetworkInterface_NicType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[245]
}

func (x NetworkInterface_NicType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_NicType.Descriptor instead.
func (NetworkInterface_NicType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1118, 2}
}

// The stack type for this network interface. To assign only IPv4 addresses, use IPV4_ONLY. To assign both IPv4 and IPv6 addresses, use IPV4_IPV6. If not specified, IPV4_ONLY is used. This field can be both set at instance creation and update network interface operations.
type NetworkInterface_StackType int32

const (
	// A value indicating that the enum field is not set.
	NetworkInterface_UNDEFINED_STACK_TYPE NetworkInterface_StackType = 0
	// The network interface can have both IPv4 and IPv6 addresses.
	NetworkInterface_IPV4_IPV6 NetworkInterface_StackType = 22197249
	// The network interface will only be assigned IPv4 addresses.
	NetworkInterface_IPV4_ONLY NetworkInterface_StackType = 22373798
	// The network interface will only be assigned IPv6 addresses.
	NetworkInterface_IPV6_ONLY              NetworkInterface_StackType = 79632100
	NetworkInterface_UNSPECIFIED_STACK_TYPE NetworkInterface_StackType = 298084569
)

// Enum value maps for NetworkInterface_StackType.
var (
	NetworkInterface_StackType_name = map[int32]string{
		0:         "UNDEFINED_STACK_TYPE",
		22197249:  "IPV4_IPV6",
		22373798:  "IPV4_ONLY",
		79632100:  "IPV6_ONLY",
		298084569: "UNSPECIFIED_STACK_TYPE",
	}
	NetworkInterface_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE":   0,
		"IPV4_IPV6":              22197249,
		"IPV4_ONLY":              22373798,
		"IPV6_ONLY":              79632100,
		"UNSPECIFIED_STACK_TYPE": 298084569,
	}
)

func (x NetworkInterface_StackType) Enum() *NetworkInterface_StackType {
	p := new(NetworkInterface_StackType)
	*p = x
	return p
}

func (x NetworkInterface_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[246].Descriptor()
}

func (NetworkInterface_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[246]
}

func (x NetworkInterface_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_StackType.Descriptor instead.
func (NetworkInterface_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1118, 3}
}

// Which IP version(s) of traffic and routes are allowed to be imported or exported between peer networks. The default value is IPV4_ONLY.
type NetworkPeering_StackType int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeering_UNDEFINED_STACK_TYPE NetworkPeering_StackType = 0
	// This Peering will allow IPv4 traffic and routes to be exchanged. Additionally if the matching peering is IPV4_IPV6, IPv6 traffic and routes will be exchanged as well.
	NetworkPeering_IPV4_IPV6 NetworkPeering_StackType = 22197249
	// This Peering will only allow IPv4 traffic and routes to be exchanged, even if the matching peering is IPV4_IPV6.
	NetworkPeering_IPV4_ONLY NetworkPeering_StackType = 22373798
)

// Enum value maps for NetworkPeering_StackType.
var (
	NetworkPeering_StackType_name = map[int32]string{
		0:        "UNDEFINED_STACK_TYPE",
		22197249: "IPV4_IPV6",
		22373798: "IPV4_ONLY",
	}
	NetworkPeering_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE": 0,
		"IPV4_IPV6":            22197249,
		"IPV4_ONLY":            22373798,
	}
)

func (x NetworkPeering_StackType) Enum() *NetworkPeering_StackType {
	p := new(NetworkPeering_StackType)
	*p = x
	return p
}

func (x NetworkPeering_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeering_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[247].Descriptor()
}

func (NetworkPeering_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[247]
}

func (x NetworkPeering_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeering_StackType.Descriptor instead.
func (NetworkPeering_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1121, 0}
}

// [Output Only] State for the peering, either `ACTIVE` or `INACTIVE`. The peering is `ACTIVE` when there's a matching configuration in the peer network.
type NetworkPeering_State int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeering_UNDEFINED_STATE NetworkPeering_State = 0
	// Matching configuration exists on the peer.
	NetworkPeering_ACTIVE NetworkPeering_State = 314733318
	// There is no matching configuration on the peer, including the case when peer does not exist.
	NetworkPeering_INACTIVE NetworkPeering_State = 270421099
)

// Enum value maps for NetworkPeering_State.
var (
	NetworkPeering_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		270421099: "INACTIVE",
	}
	NetworkPeering_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"INACTIVE":        270421099,
	}
)

func (x NetworkPeering_State) Enum() *NetworkPeering_State {
	p := new(NetworkPeering_State)
	*p = x
	return p
}

func (x NetworkPeering_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeering_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[248].Descriptor()
}

func (NetworkPeering_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[248]
}

func (x NetworkPeering_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeering_State.Descriptor instead.
func (NetworkPeering_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1121, 1}
}

// The update strategy determines the semantics for updates and deletes to the peering connection configuration.
type NetworkPeering_UpdateStrategy int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeering_UNDEFINED_UPDATE_STRATEGY NetworkPeering_UpdateStrategy = 0
	// Updates are reflected in the local peering but aren't applied to the peering connection until a complementary change is made to the matching peering. To delete a peering with the consensus update strategy, both the peerings must request the deletion of the peering before the peering can be deleted.
	NetworkPeering_CONSENSUS NetworkPeering_UpdateStrategy = 203373655
	// In this mode, changes to the peering configuration can be unilaterally altered by changing either side of the peering. This is the default value if the field is unspecified.
	NetworkPeering_INDEPENDENT NetworkPeering_UpdateStrategy = 127011674
	// Peerings with update strategy UNSPECIFIED are created with update strategy INDEPENDENT.
	NetworkPeering_UNSPECIFIED NetworkPeering_UpdateStrategy = 526786327
)

// Enum value maps for NetworkPeering_UpdateStrategy.
var (
	NetworkPeering_UpdateStrategy_name = map[int32]string{
		0:         "UNDEFINED_UPDATE_STRATEGY",
		203373655: "CONSENSUS",
		127011674: "INDEPENDENT",
		526786327: "UNSPECIFIED",
	}
	NetworkPeering_UpdateStrategy_value = map[string]int32{
		"UNDEFINED_UPDATE_STRATEGY": 0,
		"CONSENSUS":                 203373655,
		"INDEPENDENT":               127011674,
		"UNSPECIFIED":               526786327,
	}
)

func (x NetworkPeering_UpdateStrategy) Enum() *NetworkPeering_UpdateStrategy {
	p := new(NetworkPeering_UpdateStrategy)
	*p = x
	return p
}

func (x NetworkPeering_UpdateStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeering_UpdateStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[249].Descriptor()
}

func (NetworkPeering_UpdateStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[249]
}

func (x NetworkPeering_UpdateStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeering_UpdateStrategy.Descriptor instead.
func (NetworkPeering_UpdateStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1121, 2}
}

// The update strategy determines the update/delete semantics for this peering connection.
type NetworkPeeringConnectionStatus_UpdateStrategy int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeeringConnectionStatus_UNDEFINED_UPDATE_STRATEGY NetworkPeeringConnectionStatus_UpdateStrategy = 0
	// Updates are reflected in the local peering but aren't applied to the peering connection until a complementary change is made to the matching peering. To delete a peering with the consensus update strategy, both the peerings must request the deletion of the peering before the peering can be deleted.
	NetworkPeeringConnectionStatus_CONSENSUS NetworkPeeringConnectionStatus_UpdateStrategy = 203373655
	// In this mode, changes to the peering configuration can be unilaterally altered by changing either side of the peering. This is the default value if the field is unspecified.
	NetworkPeeringConnectionStatus_INDEPENDENT NetworkPeeringConnectionStatus_UpdateStrategy = 127011674
	// Peerings with update strategy UNSPECIFIED are created with update strategy INDEPENDENT.
	NetworkPeeringConnectionStatus_UNSPECIFIED NetworkPeeringConnectionStatus_UpdateStrategy = 526786327
)

// Enum value maps for NetworkPeeringConnectionStatus_UpdateStrategy.
var (
	NetworkPeeringConnectionStatus_UpdateStrategy_name = map[int32]string{
		0:         "UNDEFINED_UPDATE_STRATEGY",
		203373655: "CONSENSUS",
		127011674: "INDEPENDENT",
		526786327: "UNSPECIFIED",
	}
	NetworkPeeringConnectionStatus_UpdateStrategy_value = map[string]int32{
		"UNDEFINED_UPDATE_STRATEGY": 0,
		"CONSENSUS":                 203373655,
		"INDEPENDENT":               127011674,
		"UNSPECIFIED":               526786327,
	}
)

func (x NetworkPeeringConnectionStatus_UpdateStrategy) Enum() *NetworkPeeringConnectionStatus_UpdateStrategy {
	p := new(NetworkPeeringConnectionStatus_UpdateStrategy)
	*p = x
	return p
}

func (x NetworkPeeringConnectionStatus_UpdateStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeeringConnectionStatus_UpdateStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[250].Descriptor()
}

func (NetworkPeeringConnectionStatus_UpdateStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[250]
}

func (x NetworkPeeringConnectionStatus_UpdateStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeeringConnectionStatus_UpdateStrategy.Descriptor instead.
func (NetworkPeeringConnectionStatus_UpdateStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1122, 0}
}

// The status of the delete request.
type NetworkPeeringConnectionStatusConsensusState_DeleteStatus int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeeringConnectionStatusConsensusState_UNDEFINED_DELETE_STATUS NetworkPeeringConnectionStatusConsensusState_DeleteStatus = 0
	// Both network admins have agreed this consensus peering connection can be deleted.
	NetworkPeeringConnectionStatusConsensusState_DELETE_ACKNOWLEDGED       NetworkPeeringConnectionStatusConsensusState_DeleteStatus = 325293916
	NetworkPeeringConnectionStatusConsensusState_DELETE_STATUS_UNSPECIFIED NetworkPeeringConnectionStatusConsensusState_DeleteStatus = 395396446
	// Network admin has requested deletion of this peering connection.
	NetworkPeeringConnectionStatusConsensusState_LOCAL_DELETE_REQUESTED NetworkPeeringConnectionStatusConsensusState_DeleteStatus = 227335214
	// The peer network admin has requested deletion of this peering connection.
	NetworkPeeringConnectionStatusConsensusState_PEER_DELETE_REQUESTED NetworkPeeringConnectionStatusConsensusState_DeleteStatus = 197847799
)

// Enum value maps for NetworkPeeringConnectionStatusConsensusState_DeleteStatus.
var (
	NetworkPeeringConnectionStatusConsensusState_DeleteStatus_name = map[int32]string{
		0:         "UNDEFINED_DELETE_STATUS",
		325293916: "DELETE_ACKNOWLEDGED",
		395396446: "DELETE_STATUS_UNSPECIFIED",
		227335214: "LOCAL_DELETE_REQUESTED",
		197847799: "PEER_DELETE_REQUESTED",
	}
	NetworkPeeringConnectionStatusConsensusState_DeleteStatus_value = map[string]int32{
		"UNDEFINED_DELETE_STATUS":   0,
		"DELETE_ACKNOWLEDGED":       325293916,
		"DELETE_STATUS_UNSPECIFIED": 395396446,
		"LOCAL_DELETE_REQUESTED":    227335214,
		"PEER_DELETE_REQUESTED":     197847799,
	}
)

func (x NetworkPeeringConnectionStatusConsensusState_DeleteStatus) Enum() *NetworkPeeringConnectionStatusConsensusState_DeleteStatus {
	p := new(NetworkPeeringConnectionStatusConsensusState_DeleteStatus)
	*p = x
	return p
}

func (x NetworkPeeringConnectionStatusConsensusState_DeleteStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeeringConnectionStatusConsensusState_DeleteStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[251].Descriptor()
}

func (NetworkPeeringConnectionStatusConsensusState_DeleteStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[251]
}

func (x NetworkPeeringConnectionStatusConsensusState_DeleteStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeeringConnectionStatusConsensusState_DeleteStatus.Descriptor instead.
func (NetworkPeeringConnectionStatusConsensusState_DeleteStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1123, 0}
}

// The status of the update request.
type NetworkPeeringConnectionStatusConsensusState_UpdateStatus int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeeringConnectionStatusConsensusState_UNDEFINED_UPDATE_STATUS NetworkPeeringConnectionStatusConsensusState_UpdateStatus = 0
	// No pending configuration update proposals to the peering connection.
	NetworkPeeringConnectionStatusConsensusState_IN_SYNC NetworkPeeringConnectionStatusConsensusState_UpdateStatus = 2273653
	// The peer network admin has made an updatePeering call. The change is awaiting acknowledgment from this peering's network admin.
	NetworkPeeringConnectionStatusConsensusState_PENDING_LOCAL_ACKNOWLEDMENT NetworkPeeringConnectionStatusConsensusState_UpdateStatus = 229926592
	// The local network admin has made an updatePeering call. The change is awaiting acknowledgment from the peer network admin.
	NetworkPeeringConnectionStatusConsensusState_PENDING_PEER_ACKNOWLEDGEMENT NetworkPeeringConnectionStatusConsensusState_UpdateStatus = 420185797
	NetworkPeeringConnectionStatusConsensusState_UPDATE_STATUS_UNSPECIFIED    NetworkPeeringConnectionStatusConsensusState_UpdateStatus = 120836480
)

// Enum value maps for NetworkPeeringConnectionStatusConsensusState_UpdateStatus.
var (
	NetworkPeeringConnectionStatusConsensusState_UpdateStatus_name = map[int32]string{
		0:         "UNDEFINED_UPDATE_STATUS",
		2273653:   "IN_SYNC",
		229926592: "PENDING_LOCAL_ACKNOWLEDMENT",
		420185797: "PENDING_PEER_ACKNOWLEDGEMENT",
		120836480: "UPDATE_STATUS_UNSPECIFIED",
	}
	NetworkPeeringConnectionStatusConsensusState_UpdateStatus_value = map[string]int32{
		"UNDEFINED_UPDATE_STATUS":      0,
		"IN_SYNC":                      2273653,
		"PENDING_LOCAL_ACKNOWLEDMENT":  229926592,
		"PENDING_PEER_ACKNOWLEDGEMENT": 420185797,
		"UPDATE_STATUS_UNSPECIFIED":    120836480,
	}
)

func (x NetworkPeeringConnectionStatusConsensusState_UpdateStatus) Enum() *NetworkPeeringConnectionStatusConsensusState_UpdateStatus {
	p := new(NetworkPeeringConnectionStatusConsensusState_UpdateStatus)
	*p = x
	return p
}

func (x NetworkPeeringConnectionStatusConsensusState_UpdateStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeeringConnectionStatusConsensusState_UpdateStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[252].Descriptor()
}

func (NetworkPeeringConnectionStatusConsensusState_UpdateStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[252]
}

func (x NetworkPeeringConnectionStatusConsensusState_UpdateStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeeringConnectionStatusConsensusState_UpdateStatus.Descriptor instead.
func (NetworkPeeringConnectionStatusConsensusState_UpdateStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1123, 1}
}

// Which IP version(s) of traffic and routes are being imported or exported between peer networks.
type NetworkPeeringConnectionStatusTrafficConfiguration_StackType int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeeringConnectionStatusTrafficConfiguration_UNDEFINED_STACK_TYPE NetworkPeeringConnectionStatusTrafficConfiguration_StackType = 0
	// This Peering will allow IPv4 traffic and routes to be exchanged. Additionally if the matching peering is IPV4_IPV6, IPv6 traffic and routes will be exchanged as well.
	NetworkPeeringConnectionStatusTrafficConfiguration_IPV4_IPV6 NetworkPeeringConnectionStatusTrafficConfiguration_StackType = 22197249
	// This Peering will only allow IPv4 traffic and routes to be exchanged, even if the matching peering is IPV4_IPV6.
	NetworkPeeringConnectionStatusTrafficConfiguration_IPV4_ONLY NetworkPeeringConnectionStatusTrafficConfiguration_StackType = 22373798
)

// Enum value maps for NetworkPeeringConnectionStatusTrafficConfiguration_StackType.
var (
	NetworkPeeringConnectionStatusTrafficConfiguration_StackType_name = map[int32]string{
		0:        "UNDEFINED_STACK_TYPE",
		22197249: "IPV4_IPV6",
		22373798: "IPV4_ONLY",
	}
	NetworkPeeringConnectionStatusTrafficConfiguration_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE": 0,
		"IPV4_IPV6":            22197249,
		"IPV4_ONLY":            22373798,
	}
)

func (x NetworkPeeringConnectionStatusTrafficConfiguration_StackType) Enum() *NetworkPeeringConnectionStatusTrafficConfiguration_StackType {
	p := new(NetworkPeeringConnectionStatusTrafficConfiguration_StackType)
	*p = x
	return p
}

func (x NetworkPeeringConnectionStatusTrafficConfiguration_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeeringConnectionStatusTrafficConfiguration_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[253].Descriptor()
}

func (NetworkPeeringConnectionStatusTrafficConfiguration_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[253]
}

func (x NetworkPeeringConnectionStatusTrafficConfiguration_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeeringConnectionStatusTrafficConfiguration_StackType.Descriptor instead.
func (NetworkPeeringConnectionStatusTrafficConfiguration_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1124, 0}
}

type NetworkPerformanceConfig_TotalEgressBandwidthTier int32

const (
	// A value indicating that the enum field is not set.
	NetworkPerformanceConfig_UNDEFINED_TOTAL_EGRESS_BANDWIDTH_TIER NetworkPerformanceConfig_TotalEgressBandwidthTier = 0
	NetworkPerformanceConfig_DEFAULT                               NetworkPerformanceConfig_TotalEgressBandwidthTier = 115302945
	NetworkPerformanceConfig_TIER_1                                NetworkPerformanceConfig_TotalEgressBandwidthTier = 326919444
)

// Enum value maps for NetworkPerformanceConfig_TotalEgressBandwidthTier.
var (
	NetworkPerformanceConfig_TotalEgressBandwidthTier_name = map[int32]string{
		0:         "UNDEFINED_TOTAL_EGRESS_BANDWIDTH_TIER",
		115302945: "DEFAULT",
		326919444: "TIER_1",
	}
	NetworkPerformanceConfig_TotalEgressBandwidthTier_value = map[string]int32{
		"UNDEFINED_TOTAL_EGRESS_BANDWIDTH_TIER": 0,
		"DEFAULT":                               115302945,
		"TIER_1":                                326919444,
	}
)

func (x NetworkPerformanceConfig_TotalEgressBandwidthTier) Enum() *NetworkPerformanceConfig_TotalEgressBandwidthTier {
	p := new(NetworkPerformanceConfig_TotalEgressBandwidthTier)
	*p = x
	return p
}

func (x NetworkPerformanceConfig_TotalEgressBandwidthTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPerformanceConfig_TotalEgressBandwidthTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[254].Descriptor()
}

func (NetworkPerformanceConfig_TotalEgressBandwidthTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[254]
}

func (x NetworkPerformanceConfig_TotalEgressBandwidthTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPerformanceConfig_TotalEgressBandwidthTier.Descriptor instead.
func (NetworkPerformanceConfig_TotalEgressBandwidthTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1125, 0}
}

// The traffic class that should be applied to the matching packet.
type NetworkPolicyTrafficClassificationRuleAction_DscpMode int32

const (
	// A value indicating that the enum field is not set.
	NetworkPolicyTrafficClassificationRuleAction_UNDEFINED_DSCP_MODE NetworkPolicyTrafficClassificationRuleAction_DscpMode = 0
	// DSCP value will be automatically picked up based on configured traffic_class.
	NetworkPolicyTrafficClassificationRuleAction_AUTO NetworkPolicyTrafficClassificationRuleAction_DscpMode = 2020783
	// Allows to specify custom DSCP value from selected traffic_class range.
	NetworkPolicyTrafficClassificationRuleAction_CUSTOM NetworkPolicyTrafficClassificationRuleAction_DscpMode = 388595569
)

// Enum value maps for NetworkPolicyTrafficClassificationRuleAction_DscpMode.
var (
	NetworkPolicyTrafficClassificationRuleAction_DscpMode_name = map[int32]string{
		0:         "UNDEFINED_DSCP_MODE",
		2020783:   "AUTO",
		388595569: "CUSTOM",
	}
	NetworkPolicyTrafficClassificationRuleAction_DscpMode_value = map[string]int32{
		"UNDEFINED_DSCP_MODE": 0,
		"AUTO":                2020783,
		"CUSTOM":              388595569,
	}
)

func (x NetworkPolicyTrafficClassificationRuleAction_DscpMode) Enum() *NetworkPolicyTrafficClassificationRuleAction_DscpMode {
	p := new(NetworkPolicyTrafficClassificationRuleAction_DscpMode)
	*p = x
	return p
}

func (x NetworkPolicyTrafficClassificationRuleAction_DscpMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPolicyTrafficClassificationRuleAction_DscpMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[255].Descriptor()
}

func (NetworkPolicyTrafficClassificationRuleAction_DscpMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[255]
}

func (x NetworkPolicyTrafficClassificationRuleAction_DscpMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPolicyTrafficClassificationRuleAction_DscpMode.Descriptor instead.
func (NetworkPolicyTrafficClassificationRuleAction_DscpMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1132, 0}
}

// The traffic class that should be applied to the matching packet.
type NetworkPolicyTrafficClassificationRuleAction_TrafficClass int32

const (
	// A value indicating that the enum field is not set.
	NetworkPolicyTrafficClassificationRuleAction_UNDEFINED_TRAFFIC_CLASS NetworkPolicyTrafficClassificationRuleAction_TrafficClass = 0
	// Traffic Class 1, corresponding to DSCP ranges (0-7) 000xxx.
	NetworkPolicyTrafficClassificationRuleAction_TC1 NetworkPolicyTrafficClassificationRuleAction_TrafficClass = 82850
	// Traffic Class 2, corresponding to DSCP ranges (8-15) 001xxx.
	NetworkPolicyTrafficClassificationRuleAction_TC2 NetworkPolicyTrafficClassificationRuleAction_TrafficClass = 82851
	// Traffic Class 3, corresponding to DSCP ranges (16-23) 010xxx.
	NetworkPolicyTrafficClassificationRuleAction_TC3 NetworkPolicyTrafficClassificationRuleAction_TrafficClass = 82852
	// Traffic Class 4, corresponding to DSCP ranges (24-31) 011xxx.
	NetworkPolicyTrafficClassificationRuleAction_TC4 NetworkPolicyTrafficClassificationRuleAction_TrafficClass = 82853
	// Traffic Class 5, corresponding to DSCP ranges (32-47) 10xxxx.
	NetworkPolicyTrafficClassificationRuleAction_TC5 NetworkPolicyTrafficClassificationRuleAction_TrafficClass = 82854
	// Traffic Class 6, corresponding to DSCP ranges (48-63) 11xxxx.
	NetworkPolicyTrafficClassificationRuleAction_TC6 NetworkPolicyTrafficClassificationRuleAction_TrafficClass = 82855
)

// Enum value maps for NetworkPolicyTrafficClassificationRuleAction_TrafficClass.
var (
	NetworkPolicyTrafficClassificationRuleAction_TrafficClass_name = map[int32]string{
		0:     "UNDEFINED_TRAFFIC_CLASS",
		82850: "TC1",
		82851: "TC2",
		82852: "TC3",
		82853: "TC4",
		82854: "TC5",
		82855: "TC6",
	}
	NetworkPolicyTrafficClassificationRuleAction_TrafficClass_value = map[string]int32{
		"UNDEFINED_TRAFFIC_CLASS": 0,
		"TC1":                     82850,
		"TC2":                     82851,
		"TC3":                     82852,
		"TC4":                     82853,
		"TC5":                     82854,
		"TC6":                     82855,
	}
)

func (x NetworkPolicyTrafficClassificationRuleAction_TrafficClass) Enum() *NetworkPolicyTrafficClassificationRuleAction_TrafficClass {
	p := new(NetworkPolicyTrafficClassificationRuleAction_TrafficClass)
	*p = x
	return p
}

func (x NetworkPolicyTrafficClassificationRuleAction_TrafficClass) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPolicyTrafficClassificationRuleAction_TrafficClass) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[256].Descriptor()
}

func (NetworkPolicyTrafficClassificationRuleAction_TrafficClass) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[256]
}

func (x NetworkPolicyTrafficClassificationRuleAction_TrafficClass) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPolicyTrafficClassificationRuleAction_TrafficClass.Descriptor instead.
func (NetworkPolicyTrafficClassificationRuleAction_TrafficClass) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1132, 1}
}

// [Output Only] State of the secure tag, either `EFFECTIVE` or `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or its network is deleted.
type NetworkPolicyTrafficClassificationRuleSecureTag_State int32

const (
	// A value indicating that the enum field is not set.
	NetworkPolicyTrafficClassificationRuleSecureTag_UNDEFINED_STATE   NetworkPolicyTrafficClassificationRuleSecureTag_State = 0
	NetworkPolicyTrafficClassificationRuleSecureTag_EFFECTIVE         NetworkPolicyTrafficClassificationRuleSecureTag_State = 244201863
	NetworkPolicyTrafficClassificationRuleSecureTag_INEFFECTIVE       NetworkPolicyTrafficClassificationRuleSecureTag_State = 304458242
	NetworkPolicyTrafficClassificationRuleSecureTag_STATE_UNSPECIFIED NetworkPolicyTrafficClassificationRuleSecureTag_State = 470755401
)

// Enum value maps for NetworkPolicyTrafficClassificationRuleSecureTag_State.
var (
	NetworkPolicyTrafficClassificationRuleSecureTag_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		244201863: "EFFECTIVE",
		304458242: "INEFFECTIVE",
		470755401: "STATE_UNSPECIFIED",
	}
	NetworkPolicyTrafficClassificationRuleSecureTag_State_value = map[string]int32{
		"UNDEFINED_STATE":   0,
		"EFFECTIVE":         244201863,
		"INEFFECTIVE":       304458242,
		"STATE_UNSPECIFIED": 470755401,
	}
)

func (x NetworkPolicyTrafficClassificationRuleSecureTag_State) Enum() *NetworkPolicyTrafficClassificationRuleSecureTag_State {
	p := new(NetworkPolicyTrafficClassificationRuleSecureTag_State)
	*p = x
	return p
}

func (x NetworkPolicyTrafficClassificationRuleSecureTag_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPolicyTrafficClassificationRuleSecureTag_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[257].Descriptor()
}

func (NetworkPolicyTrafficClassificationRuleSecureTag_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[257]
}

func (x NetworkPolicyTrafficClassificationRuleSecureTag_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPolicyTrafficClassificationRuleSecureTag_State.Descriptor instead.
func (NetworkPolicyTrafficClassificationRuleSecureTag_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1135, 0}
}

type NetworkProfileLocation_Scope int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileLocation_UNDEFINED_SCOPE NetworkProfileLocation_Scope = 0
	NetworkProfileLocation_REGION          NetworkProfileLocation_Scope = 266017524
	NetworkProfileLocation_ZONE            NetworkProfileLocation_Scope = 2759596
)

// Enum value maps for NetworkProfileLocation_Scope.
var (
	NetworkProfileLocation_Scope_name = map[int32]string{
		0:         "UNDEFINED_SCOPE",
		266017524: "REGION",
		2759596:   "ZONE",
	}
	NetworkProfileLocation_Scope_value = map[string]int32{
		"UNDEFINED_SCOPE": 0,
		"REGION":          266017524,
		"ZONE":            2759596,
	}
)

func (x NetworkProfileLocation_Scope) Enum() *NetworkProfileLocation_Scope {
	p := new(NetworkProfileLocation_Scope)
	*p = x
	return p
}

func (x NetworkProfileLocation_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileLocation_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[258].Descriptor()
}

func (NetworkProfileLocation_Scope) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[258]
}

func (x NetworkProfileLocation_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileLocation_Scope.Descriptor instead.
func (NetworkProfileLocation_Scope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1137, 0}
}

// Additional supported values which may be not listed in the enum directly due to technical reasons:
// PRIVATE_SERVICE_CONNECT
type NetworkProfileNetworkFeatures_AddressPurposes int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ADDRESS_PURPOSES NetworkProfileNetworkFeatures_AddressPurposes = 0
	// DNS resolver address in the subnetwork.
	NetworkProfileNetworkFeatures_DNS_RESOLVER NetworkProfileNetworkFeatures_AddressPurposes = 476114556
	// VM internal/alias IP, Internal LB service IP, etc.
	NetworkProfileNetworkFeatures_GCE_ENDPOINT NetworkProfileNetworkFeatures_AddressPurposes = 230515243
	// A regional internal IP address range reserved for the VLAN attachment that is used in HA VPN over Cloud Interconnect. This regional internal IP address range must not overlap with any IP address range of subnet/route in the VPC network and its peering networks. After the VLAN attachment is created with the reserved IP address range, when creating a new VPN gateway, its interface IP address is allocated from the associated VLAN attachment’s IP address range.
	NetworkProfileNetworkFeatures_IPSEC_INTERCONNECT NetworkProfileNetworkFeatures_AddressPurposes = 340437251
	// External IP automatically reserved for Cloud NAT.
	NetworkProfileNetworkFeatures_NAT_AUTO                NetworkProfileNetworkFeatures_AddressPurposes = 163666477
	NetworkProfileNetworkFeatures_PRIVATE_SERVICE_CONNECT NetworkProfileNetworkFeatures_AddressPurposes = 48134724
	// A regional internal IP address range reserved for Serverless.
	NetworkProfileNetworkFeatures_SERVERLESS NetworkProfileNetworkFeatures_AddressPurposes = 270492508
	// A private network IP address that can be shared by multiple Internal Load Balancer forwarding rules.
	NetworkProfileNetworkFeatures_SHARED_LOADBALANCER_VIP NetworkProfileNetworkFeatures_AddressPurposes = 294447572
	// IP range for peer networks.
	NetworkProfileNetworkFeatures_VPC_PEERING NetworkProfileNetworkFeatures_AddressPurposes = 400800170
)

// Enum value maps for NetworkProfileNetworkFeatures_AddressPurposes.
var (
	NetworkProfileNetworkFeatures_AddressPurposes_name = map[int32]string{
		0:         "UNDEFINED_ADDRESS_PURPOSES",
		476114556: "DNS_RESOLVER",
		230515243: "GCE_ENDPOINT",
		340437251: "IPSEC_INTERCONNECT",
		163666477: "NAT_AUTO",
		48134724:  "PRIVATE_SERVICE_CONNECT",
		270492508: "SERVERLESS",
		294447572: "SHARED_LOADBALANCER_VIP",
		400800170: "VPC_PEERING",
	}
	NetworkProfileNetworkFeatures_AddressPurposes_value = map[string]int32{
		"UNDEFINED_ADDRESS_PURPOSES": 0,
		"DNS_RESOLVER":               476114556,
		"GCE_ENDPOINT":               230515243,
		"IPSEC_INTERCONNECT":         340437251,
		"NAT_AUTO":                   163666477,
		"PRIVATE_SERVICE_CONNECT":    48134724,
		"SERVERLESS":                 270492508,
		"SHARED_LOADBALANCER_VIP":    294447572,
		"VPC_PEERING":                400800170,
	}
)

func (x NetworkProfileNetworkFeatures_AddressPurposes) Enum() *NetworkProfileNetworkFeatures_AddressPurposes {
	p := new(NetworkProfileNetworkFeatures_AddressPurposes)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AddressPurposes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AddressPurposes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[259].Descriptor()
}

func (NetworkProfileNetworkFeatures_AddressPurposes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[259]
}

func (x NetworkProfileNetworkFeatures_AddressPurposes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AddressPurposes.Descriptor instead.
func (NetworkProfileNetworkFeatures_AddressPurposes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 0}
}

// Specifies whether alias IP ranges (and secondary address ranges) are allowed.
type NetworkProfileNetworkFeatures_AllowAliasIpRanges int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_ALIAS_IP_RANGES NetworkProfileNetworkFeatures_AllowAliasIpRanges = 0
	NetworkProfileNetworkFeatures_ALIAS_IP_RANGES_ALLOWED         NetworkProfileNetworkFeatures_AllowAliasIpRanges = 464867048
	NetworkProfileNetworkFeatures_ALIAS_IP_RANGES_BLOCKED         NetworkProfileNetworkFeatures_AllowAliasIpRanges = 281030444
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowAliasIpRanges.
var (
	NetworkProfileNetworkFeatures_AllowAliasIpRanges_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_ALIAS_IP_RANGES",
		464867048: "ALIAS_IP_RANGES_ALLOWED",
		281030444: "ALIAS_IP_RANGES_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowAliasIpRanges_value = map[string]int32{
		"UNDEFINED_ALLOW_ALIAS_IP_RANGES": 0,
		"ALIAS_IP_RANGES_ALLOWED":         464867048,
		"ALIAS_IP_RANGES_BLOCKED":         281030444,
	}
)

func (x NetworkProfileNetworkFeatures_AllowAliasIpRanges) Enum() *NetworkProfileNetworkFeatures_AllowAliasIpRanges {
	p := new(NetworkProfileNetworkFeatures_AllowAliasIpRanges)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowAliasIpRanges) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowAliasIpRanges) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[260].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowAliasIpRanges) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[260]
}

func (x NetworkProfileNetworkFeatures_AllowAliasIpRanges) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowAliasIpRanges.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowAliasIpRanges) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 1}
}

// Specifies whether auto mode subnet creation is allowed.
type NetworkProfileNetworkFeatures_AllowAutoModeSubnet int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_AUTO_MODE_SUBNET NetworkProfileNetworkFeatures_AllowAutoModeSubnet = 0
	NetworkProfileNetworkFeatures_AUTO_MODE_SUBNET_ALLOWED         NetworkProfileNetworkFeatures_AllowAutoModeSubnet = 391042610
	NetworkProfileNetworkFeatures_AUTO_MODE_SUBNET_BLOCKED         NetworkProfileNetworkFeatures_AllowAutoModeSubnet = 207206006
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowAutoModeSubnet.
var (
	NetworkProfileNetworkFeatures_AllowAutoModeSubnet_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_AUTO_MODE_SUBNET",
		391042610: "AUTO_MODE_SUBNET_ALLOWED",
		207206006: "AUTO_MODE_SUBNET_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowAutoModeSubnet_value = map[string]int32{
		"UNDEFINED_ALLOW_AUTO_MODE_SUBNET": 0,
		"AUTO_MODE_SUBNET_ALLOWED":         391042610,
		"AUTO_MODE_SUBNET_BLOCKED":         207206006,
	}
)

func (x NetworkProfileNetworkFeatures_AllowAutoModeSubnet) Enum() *NetworkProfileNetworkFeatures_AllowAutoModeSubnet {
	p := new(NetworkProfileNetworkFeatures_AllowAutoModeSubnet)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowAutoModeSubnet) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowAutoModeSubnet) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[261].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowAutoModeSubnet) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[261]
}

func (x NetworkProfileNetworkFeatures_AllowAutoModeSubnet) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowAutoModeSubnet.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowAutoModeSubnet) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 2}
}

// Specifies whether firewalls for Class D address ranges are supported.
type NetworkProfileNetworkFeatures_AllowClassDFirewalls int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_CLASS_D_FIREWALLS NetworkProfileNetworkFeatures_AllowClassDFirewalls = 0
	NetworkProfileNetworkFeatures_CLASS_D_FIREWALLS_ALLOWED         NetworkProfileNetworkFeatures_AllowClassDFirewalls = 348219386
	NetworkProfileNetworkFeatures_CLASS_D_FIREWALLS_BLOCKED         NetworkProfileNetworkFeatures_AllowClassDFirewalls = 164382782
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowClassDFirewalls.
var (
	NetworkProfileNetworkFeatures_AllowClassDFirewalls_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_CLASS_D_FIREWALLS",
		348219386: "CLASS_D_FIREWALLS_ALLOWED",
		164382782: "CLASS_D_FIREWALLS_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowClassDFirewalls_value = map[string]int32{
		"UNDEFINED_ALLOW_CLASS_D_FIREWALLS": 0,
		"CLASS_D_FIREWALLS_ALLOWED":         348219386,
		"CLASS_D_FIREWALLS_BLOCKED":         164382782,
	}
)

func (x NetworkProfileNetworkFeatures_AllowClassDFirewalls) Enum() *NetworkProfileNetworkFeatures_AllowClassDFirewalls {
	p := new(NetworkProfileNetworkFeatures_AllowClassDFirewalls)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowClassDFirewalls) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowClassDFirewalls) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[262].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowClassDFirewalls) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[262]
}

func (x NetworkProfileNetworkFeatures_AllowClassDFirewalls) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowClassDFirewalls.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowClassDFirewalls) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 3}
}

// Specifies whether cloud NAT creation is allowed.
type NetworkProfileNetworkFeatures_AllowCloudNat int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_CLOUD_NAT NetworkProfileNetworkFeatures_AllowCloudNat = 0
	NetworkProfileNetworkFeatures_CLOUD_NAT_ALLOWED         NetworkProfileNetworkFeatures_AllowCloudNat = 245931296
	NetworkProfileNetworkFeatures_CLOUD_NAT_BLOCKED         NetworkProfileNetworkFeatures_AllowCloudNat = 62094692
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowCloudNat.
var (
	NetworkProfileNetworkFeatures_AllowCloudNat_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_CLOUD_NAT",
		245931296: "CLOUD_NAT_ALLOWED",
		62094692:  "CLOUD_NAT_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowCloudNat_value = map[string]int32{
		"UNDEFINED_ALLOW_CLOUD_NAT": 0,
		"CLOUD_NAT_ALLOWED":         245931296,
		"CLOUD_NAT_BLOCKED":         62094692,
	}
)

func (x NetworkProfileNetworkFeatures_AllowCloudNat) Enum() *NetworkProfileNetworkFeatures_AllowCloudNat {
	p := new(NetworkProfileNetworkFeatures_AllowCloudNat)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowCloudNat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowCloudNat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[263].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowCloudNat) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[263]
}

func (x NetworkProfileNetworkFeatures_AllowCloudNat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowCloudNat.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowCloudNat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 4}
}

// Specifies whether cloud router creation is allowed.
type NetworkProfileNetworkFeatures_AllowCloudRouter int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_CLOUD_ROUTER NetworkProfileNetworkFeatures_AllowCloudRouter = 0
	NetworkProfileNetworkFeatures_CLOUD_ROUTER_ALLOWED         NetworkProfileNetworkFeatures_AllowCloudRouter = 365388284
	NetworkProfileNetworkFeatures_CLOUD_ROUTER_BLOCKED         NetworkProfileNetworkFeatures_AllowCloudRouter = 181551680
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowCloudRouter.
var (
	NetworkProfileNetworkFeatures_AllowCloudRouter_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_CLOUD_ROUTER",
		365388284: "CLOUD_ROUTER_ALLOWED",
		181551680: "CLOUD_ROUTER_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowCloudRouter_value = map[string]int32{
		"UNDEFINED_ALLOW_CLOUD_ROUTER": 0,
		"CLOUD_ROUTER_ALLOWED":         365388284,
		"CLOUD_ROUTER_BLOCKED":         181551680,
	}
)

func (x NetworkProfileNetworkFeatures_AllowCloudRouter) Enum() *NetworkProfileNetworkFeatures_AllowCloudRouter {
	p := new(NetworkProfileNetworkFeatures_AllowCloudRouter)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowCloudRouter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowCloudRouter) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[264].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowCloudRouter) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[264]
}

func (x NetworkProfileNetworkFeatures_AllowCloudRouter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowCloudRouter.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowCloudRouter) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 5}
}

// Specifies whether default NIC attachment is allowed.
type NetworkProfileNetworkFeatures_AllowDefaultNicAttachment int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_DEFAULT_NIC_ATTACHMENT NetworkProfileNetworkFeatures_AllowDefaultNicAttachment = 0
	NetworkProfileNetworkFeatures_DEFAULT_NIC_ATTACHMENT_ALLOWED         NetworkProfileNetworkFeatures_AllowDefaultNicAttachment = 11570689
	NetworkProfileNetworkFeatures_DEFAULT_NIC_ATTACHMENT_BLOCKED         NetworkProfileNetworkFeatures_AllowDefaultNicAttachment = 364604997
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowDefaultNicAttachment.
var (
	NetworkProfileNetworkFeatures_AllowDefaultNicAttachment_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_DEFAULT_NIC_ATTACHMENT",
		11570689:  "DEFAULT_NIC_ATTACHMENT_ALLOWED",
		364604997: "DEFAULT_NIC_ATTACHMENT_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowDefaultNicAttachment_value = map[string]int32{
		"UNDEFINED_ALLOW_DEFAULT_NIC_ATTACHMENT": 0,
		"DEFAULT_NIC_ATTACHMENT_ALLOWED":         11570689,
		"DEFAULT_NIC_ATTACHMENT_BLOCKED":         364604997,
	}
)

func (x NetworkProfileNetworkFeatures_AllowDefaultNicAttachment) Enum() *NetworkProfileNetworkFeatures_AllowDefaultNicAttachment {
	p := new(NetworkProfileNetworkFeatures_AllowDefaultNicAttachment)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowDefaultNicAttachment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowDefaultNicAttachment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[265].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowDefaultNicAttachment) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[265]
}

func (x NetworkProfileNetworkFeatures_AllowDefaultNicAttachment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowDefaultNicAttachment.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowDefaultNicAttachment) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 6}
}

// Specifies whether VMs are allowed to have external IP access on network interfaces connected to this VPC.
type NetworkProfileNetworkFeatures_AllowExternalIpAccess int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_EXTERNAL_IP_ACCESS NetworkProfileNetworkFeatures_AllowExternalIpAccess = 0
	NetworkProfileNetworkFeatures_EXTERNAL_IP_ACCESS_ALLOWED         NetworkProfileNetworkFeatures_AllowExternalIpAccess = 109530193
	NetworkProfileNetworkFeatures_EXTERNAL_IP_ACCESS_BLOCKED         NetworkProfileNetworkFeatures_AllowExternalIpAccess = 462564501
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowExternalIpAccess.
var (
	NetworkProfileNetworkFeatures_AllowExternalIpAccess_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_EXTERNAL_IP_ACCESS",
		109530193: "EXTERNAL_IP_ACCESS_ALLOWED",
		462564501: "EXTERNAL_IP_ACCESS_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowExternalIpAccess_value = map[string]int32{
		"UNDEFINED_ALLOW_EXTERNAL_IP_ACCESS": 0,
		"EXTERNAL_IP_ACCESS_ALLOWED":         109530193,
		"EXTERNAL_IP_ACCESS_BLOCKED":         462564501,
	}
)

func (x NetworkProfileNetworkFeatures_AllowExternalIpAccess) Enum() *NetworkProfileNetworkFeatures_AllowExternalIpAccess {
	p := new(NetworkProfileNetworkFeatures_AllowExternalIpAccess)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowExternalIpAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowExternalIpAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[266].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowExternalIpAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[266]
}

func (x NetworkProfileNetworkFeatures_AllowExternalIpAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowExternalIpAccess.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowExternalIpAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 7}
}

// Specifies whether Cloud Interconnect creation is allowed.
type NetworkProfileNetworkFeatures_AllowInterconnect int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_INTERCONNECT NetworkProfileNetworkFeatures_AllowInterconnect = 0
	NetworkProfileNetworkFeatures_INTERCONNECT_ALLOWED         NetworkProfileNetworkFeatures_AllowInterconnect = 162845399
	NetworkProfileNetworkFeatures_INTERCONNECT_BLOCKED         NetworkProfileNetworkFeatures_AllowInterconnect = 515879707
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowInterconnect.
var (
	NetworkProfileNetworkFeatures_AllowInterconnect_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_INTERCONNECT",
		162845399: "INTERCONNECT_ALLOWED",
		515879707: "INTERCONNECT_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowInterconnect_value = map[string]int32{
		"UNDEFINED_ALLOW_INTERCONNECT": 0,
		"INTERCONNECT_ALLOWED":         162845399,
		"INTERCONNECT_BLOCKED":         515879707,
	}
)

func (x NetworkProfileNetworkFeatures_AllowInterconnect) Enum() *NetworkProfileNetworkFeatures_AllowInterconnect {
	p := new(NetworkProfileNetworkFeatures_AllowInterconnect)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowInterconnect) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowInterconnect) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[267].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowInterconnect) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[267]
}

func (x NetworkProfileNetworkFeatures_AllowInterconnect) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowInterconnect.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowInterconnect) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 8}
}

// Specifies whether IP forwarding is allowed.
type NetworkProfileNetworkFeatures_AllowIpForwarding int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_IP_FORWARDING NetworkProfileNetworkFeatures_AllowIpForwarding = 0
	NetworkProfileNetworkFeatures_IP_FORWARDING_ALLOWED         NetworkProfileNetworkFeatures_AllowIpForwarding = 152595550
	NetworkProfileNetworkFeatures_IP_FORWARDING_BLOCKED         NetworkProfileNetworkFeatures_AllowIpForwarding = 505629858
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowIpForwarding.
var (
	NetworkProfileNetworkFeatures_AllowIpForwarding_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_IP_FORWARDING",
		152595550: "IP_FORWARDING_ALLOWED",
		505629858: "IP_FORWARDING_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowIpForwarding_value = map[string]int32{
		"UNDEFINED_ALLOW_IP_FORWARDING": 0,
		"IP_FORWARDING_ALLOWED":         152595550,
		"IP_FORWARDING_BLOCKED":         505629858,
	}
)

func (x NetworkProfileNetworkFeatures_AllowIpForwarding) Enum() *NetworkProfileNetworkFeatures_AllowIpForwarding {
	p := new(NetworkProfileNetworkFeatures_AllowIpForwarding)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowIpForwarding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowIpForwarding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[268].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowIpForwarding) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[268]
}

func (x NetworkProfileNetworkFeatures_AllowIpForwarding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowIpForwarding.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowIpForwarding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 9}
}

// Specifies whether cloud load balancing is allowed.
type NetworkProfileNetworkFeatures_AllowLoadBalancing int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_LOAD_BALANCING NetworkProfileNetworkFeatures_AllowLoadBalancing = 0
	NetworkProfileNetworkFeatures_LOAD_BALANCING_ALLOWED         NetworkProfileNetworkFeatures_AllowLoadBalancing = 28407977
	NetworkProfileNetworkFeatures_LOAD_BALANCING_BLOCKED         NetworkProfileNetworkFeatures_AllowLoadBalancing = 381442285
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowLoadBalancing.
var (
	NetworkProfileNetworkFeatures_AllowLoadBalancing_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_LOAD_BALANCING",
		28407977:  "LOAD_BALANCING_ALLOWED",
		381442285: "LOAD_BALANCING_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowLoadBalancing_value = map[string]int32{
		"UNDEFINED_ALLOW_LOAD_BALANCING": 0,
		"LOAD_BALANCING_ALLOWED":         28407977,
		"LOAD_BALANCING_BLOCKED":         381442285,
	}
)

func (x NetworkProfileNetworkFeatures_AllowLoadBalancing) Enum() *NetworkProfileNetworkFeatures_AllowLoadBalancing {
	p := new(NetworkProfileNetworkFeatures_AllowLoadBalancing)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowLoadBalancing) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowLoadBalancing) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[269].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowLoadBalancing) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[269]
}

func (x NetworkProfileNetworkFeatures_AllowLoadBalancing) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowLoadBalancing.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowLoadBalancing) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 10}
}

// Specifies whether multi-nic in the same network is allowed.
type NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_MULTI_NIC_IN_SAME_NETWORK NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork = 0
	NetworkProfileNetworkFeatures_MULTI_NIC_IN_SAME_NETWORK_ALLOWED         NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork = 457555419
	NetworkProfileNetworkFeatures_MULTI_NIC_IN_SAME_NETWORK_BLOCKED         NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork = 273718815
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork.
var (
	NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_MULTI_NIC_IN_SAME_NETWORK",
		457555419: "MULTI_NIC_IN_SAME_NETWORK_ALLOWED",
		273718815: "MULTI_NIC_IN_SAME_NETWORK_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork_value = map[string]int32{
		"UNDEFINED_ALLOW_MULTI_NIC_IN_SAME_NETWORK": 0,
		"MULTI_NIC_IN_SAME_NETWORK_ALLOWED":         457555419,
		"MULTI_NIC_IN_SAME_NETWORK_BLOCKED":         273718815,
	}
)

func (x NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork) Enum() *NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork {
	p := new(NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[270].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[270]
}

func (x NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowMultiNicInSameNetwork) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 11}
}

// Specifies whether NCC is allowed.
type NetworkProfileNetworkFeatures_AllowNcc int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_NCC NetworkProfileNetworkFeatures_AllowNcc = 0
	NetworkProfileNetworkFeatures_NCC_ALLOWED         NetworkProfileNetworkFeatures_AllowNcc = 467227511
	NetworkProfileNetworkFeatures_NCC_BLOCKED         NetworkProfileNetworkFeatures_AllowNcc = 283390907
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowNcc.
var (
	NetworkProfileNetworkFeatures_AllowNcc_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_NCC",
		467227511: "NCC_ALLOWED",
		283390907: "NCC_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowNcc_value = map[string]int32{
		"UNDEFINED_ALLOW_NCC": 0,
		"NCC_ALLOWED":         467227511,
		"NCC_BLOCKED":         283390907,
	}
)

func (x NetworkProfileNetworkFeatures_AllowNcc) Enum() *NetworkProfileNetworkFeatures_AllowNcc {
	p := new(NetworkProfileNetworkFeatures_AllowNcc)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowNcc) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowNcc) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[271].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowNcc) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[271]
}

func (x NetworkProfileNetworkFeatures_AllowNcc) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowNcc.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowNcc) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 12}
}

// Specifies whether VM network migration is allowed.
type NetworkProfileNetworkFeatures_AllowNetworkMigration int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_NETWORK_MIGRATION NetworkProfileNetworkFeatures_AllowNetworkMigration = 0
	NetworkProfileNetworkFeatures_NETWORK_MIGRATION_ALLOWED         NetworkProfileNetworkFeatures_AllowNetworkMigration = 14389766
	NetworkProfileNetworkFeatures_NETWORK_MIGRATION_BLOCKED         NetworkProfileNetworkFeatures_AllowNetworkMigration = 367424074
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowNetworkMigration.
var (
	NetworkProfileNetworkFeatures_AllowNetworkMigration_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_NETWORK_MIGRATION",
		14389766:  "NETWORK_MIGRATION_ALLOWED",
		367424074: "NETWORK_MIGRATION_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowNetworkMigration_value = map[string]int32{
		"UNDEFINED_ALLOW_NETWORK_MIGRATION": 0,
		"NETWORK_MIGRATION_ALLOWED":         14389766,
		"NETWORK_MIGRATION_BLOCKED":         367424074,
	}
)

func (x NetworkProfileNetworkFeatures_AllowNetworkMigration) Enum() *NetworkProfileNetworkFeatures_AllowNetworkMigration {
	p := new(NetworkProfileNetworkFeatures_AllowNetworkMigration)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowNetworkMigration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowNetworkMigration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[272].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowNetworkMigration) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[272]
}

func (x NetworkProfileNetworkFeatures_AllowNetworkMigration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowNetworkMigration.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowNetworkMigration) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 13}
}

// Specifies whether Packet Mirroring 1.0 is supported.
type NetworkProfileNetworkFeatures_AllowPacketMirroring int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_PACKET_MIRRORING NetworkProfileNetworkFeatures_AllowPacketMirroring = 0
	NetworkProfileNetworkFeatures_PACKET_MIRRORING_ALLOWED         NetworkProfileNetworkFeatures_AllowPacketMirroring = 92416245
	NetworkProfileNetworkFeatures_PACKET_MIRRORING_BLOCKED         NetworkProfileNetworkFeatures_AllowPacketMirroring = 445450553
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowPacketMirroring.
var (
	NetworkProfileNetworkFeatures_AllowPacketMirroring_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_PACKET_MIRRORING",
		92416245:  "PACKET_MIRRORING_ALLOWED",
		445450553: "PACKET_MIRRORING_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowPacketMirroring_value = map[string]int32{
		"UNDEFINED_ALLOW_PACKET_MIRRORING": 0,
		"PACKET_MIRRORING_ALLOWED":         92416245,
		"PACKET_MIRRORING_BLOCKED":         445450553,
	}
)

func (x NetworkProfileNetworkFeatures_AllowPacketMirroring) Enum() *NetworkProfileNetworkFeatures_AllowPacketMirroring {
	p := new(NetworkProfileNetworkFeatures_AllowPacketMirroring)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowPacketMirroring) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowPacketMirroring) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[273].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowPacketMirroring) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[273]
}

func (x NetworkProfileNetworkFeatures_AllowPacketMirroring) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowPacketMirroring.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowPacketMirroring) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 14}
}

// Specifies whether private Google access is allowed.
type NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_PRIVATE_GOOGLE_ACCESS NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess = 0
	NetworkProfileNetworkFeatures_PRIVATE_GOOGLE_ACCESS_ALLOWED         NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess = 220787351
	NetworkProfileNetworkFeatures_PRIVATE_GOOGLE_ACCESS_BLOCKED         NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess = 36950747
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess.
var (
	NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_PRIVATE_GOOGLE_ACCESS",
		220787351: "PRIVATE_GOOGLE_ACCESS_ALLOWED",
		36950747:  "PRIVATE_GOOGLE_ACCESS_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess_value = map[string]int32{
		"UNDEFINED_ALLOW_PRIVATE_GOOGLE_ACCESS": 0,
		"PRIVATE_GOOGLE_ACCESS_ALLOWED":         220787351,
		"PRIVATE_GOOGLE_ACCESS_BLOCKED":         36950747,
	}
)

func (x NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess) Enum() *NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess {
	p := new(NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[274].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[274]
}

func (x NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowPrivateGoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 15}
}

// Specifies whether PSC creation is allowed.
type NetworkProfileNetworkFeatures_AllowPsc int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_PSC NetworkProfileNetworkFeatures_AllowPsc = 0
	NetworkProfileNetworkFeatures_PSC_ALLOWED         NetworkProfileNetworkFeatures_AllowPsc = 171559657
	NetworkProfileNetworkFeatures_PSC_BLOCKED         NetworkProfileNetworkFeatures_AllowPsc = 524593965
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowPsc.
var (
	NetworkProfileNetworkFeatures_AllowPsc_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_PSC",
		171559657: "PSC_ALLOWED",
		524593965: "PSC_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowPsc_value = map[string]int32{
		"UNDEFINED_ALLOW_PSC": 0,
		"PSC_ALLOWED":         171559657,
		"PSC_BLOCKED":         524593965,
	}
)

func (x NetworkProfileNetworkFeatures_AllowPsc) Enum() *NetworkProfileNetworkFeatures_AllowPsc {
	p := new(NetworkProfileNetworkFeatures_AllowPsc)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowPsc) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowPsc) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[275].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowPsc) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[275]
}

func (x NetworkProfileNetworkFeatures_AllowPsc) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowPsc.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowPsc) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 16}
}

// Specifies whether unicast within the same network is allowed.
type NetworkProfileNetworkFeatures_AllowSameNetworkUnicast int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_SAME_NETWORK_UNICAST NetworkProfileNetworkFeatures_AllowSameNetworkUnicast = 0
	NetworkProfileNetworkFeatures_SAME_NETWORK_UNICAST_ALLOWED         NetworkProfileNetworkFeatures_AllowSameNetworkUnicast = 159732814
	NetworkProfileNetworkFeatures_SAME_NETWORK_UNICAST_BLOCKED         NetworkProfileNetworkFeatures_AllowSameNetworkUnicast = 512767122
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowSameNetworkUnicast.
var (
	NetworkProfileNetworkFeatures_AllowSameNetworkUnicast_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_SAME_NETWORK_UNICAST",
		159732814: "SAME_NETWORK_UNICAST_ALLOWED",
		512767122: "SAME_NETWORK_UNICAST_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowSameNetworkUnicast_value = map[string]int32{
		"UNDEFINED_ALLOW_SAME_NETWORK_UNICAST": 0,
		"SAME_NETWORK_UNICAST_ALLOWED":         159732814,
		"SAME_NETWORK_UNICAST_BLOCKED":         512767122,
	}
)

func (x NetworkProfileNetworkFeatures_AllowSameNetworkUnicast) Enum() *NetworkProfileNetworkFeatures_AllowSameNetworkUnicast {
	p := new(NetworkProfileNetworkFeatures_AllowSameNetworkUnicast)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowSameNetworkUnicast) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowSameNetworkUnicast) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[276].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowSameNetworkUnicast) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[276]
}

func (x NetworkProfileNetworkFeatures_AllowSameNetworkUnicast) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowSameNetworkUnicast.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowSameNetworkUnicast) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 17}
}

// Specifies whether static route creation is allowed.
type NetworkProfileNetworkFeatures_AllowStaticRoutes int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_STATIC_ROUTES NetworkProfileNetworkFeatures_AllowStaticRoutes = 0
	NetworkProfileNetworkFeatures_STATIC_ROUTES_ALLOWED         NetworkProfileNetworkFeatures_AllowStaticRoutes = 409048964
	NetworkProfileNetworkFeatures_STATIC_ROUTES_BLOCKED         NetworkProfileNetworkFeatures_AllowStaticRoutes = 225212360
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowStaticRoutes.
var (
	NetworkProfileNetworkFeatures_AllowStaticRoutes_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_STATIC_ROUTES",
		409048964: "STATIC_ROUTES_ALLOWED",
		225212360: "STATIC_ROUTES_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowStaticRoutes_value = map[string]int32{
		"UNDEFINED_ALLOW_STATIC_ROUTES": 0,
		"STATIC_ROUTES_ALLOWED":         409048964,
		"STATIC_ROUTES_BLOCKED":         225212360,
	}
)

func (x NetworkProfileNetworkFeatures_AllowStaticRoutes) Enum() *NetworkProfileNetworkFeatures_AllowStaticRoutes {
	p := new(NetworkProfileNetworkFeatures_AllowStaticRoutes)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowStaticRoutes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowStaticRoutes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[277].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowStaticRoutes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[277]
}

func (x NetworkProfileNetworkFeatures_AllowStaticRoutes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowStaticRoutes.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowStaticRoutes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 18}
}

// Specifies whether sub interfaces are allowed.
type NetworkProfileNetworkFeatures_AllowSubInterfaces int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_SUB_INTERFACES NetworkProfileNetworkFeatures_AllowSubInterfaces = 0
	NetworkProfileNetworkFeatures_SUBINTERFACES_ALLOWED          NetworkProfileNetworkFeatures_AllowSubInterfaces = 158685891
	NetworkProfileNetworkFeatures_SUBINTERFACES_BLOCKED          NetworkProfileNetworkFeatures_AllowSubInterfaces = 511720199
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowSubInterfaces.
var (
	NetworkProfileNetworkFeatures_AllowSubInterfaces_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_SUB_INTERFACES",
		158685891: "SUBINTERFACES_ALLOWED",
		511720199: "SUBINTERFACES_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowSubInterfaces_value = map[string]int32{
		"UNDEFINED_ALLOW_SUB_INTERFACES": 0,
		"SUBINTERFACES_ALLOWED":          158685891,
		"SUBINTERFACES_BLOCKED":          511720199,
	}
)

func (x NetworkProfileNetworkFeatures_AllowSubInterfaces) Enum() *NetworkProfileNetworkFeatures_AllowSubInterfaces {
	p := new(NetworkProfileNetworkFeatures_AllowSubInterfaces)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowSubInterfaces) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowSubInterfaces) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[278].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowSubInterfaces) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[278]
}

func (x NetworkProfileNetworkFeatures_AllowSubInterfaces) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowSubInterfaces.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowSubInterfaces) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 19}
}

// Specifies whether VPC peering is allowed.
type NetworkProfileNetworkFeatures_AllowVpcPeering int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_VPC_PEERING NetworkProfileNetworkFeatures_AllowVpcPeering = 0
	NetworkProfileNetworkFeatures_VPC_PEERING_ALLOWED         NetworkProfileNetworkFeatures_AllowVpcPeering = 261465075
	NetworkProfileNetworkFeatures_VPC_PEERING_BLOCKED         NetworkProfileNetworkFeatures_AllowVpcPeering = 77628471
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowVpcPeering.
var (
	NetworkProfileNetworkFeatures_AllowVpcPeering_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_VPC_PEERING",
		261465075: "VPC_PEERING_ALLOWED",
		77628471:  "VPC_PEERING_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowVpcPeering_value = map[string]int32{
		"UNDEFINED_ALLOW_VPC_PEERING": 0,
		"VPC_PEERING_ALLOWED":         261465075,
		"VPC_PEERING_BLOCKED":         77628471,
	}
)

func (x NetworkProfileNetworkFeatures_AllowVpcPeering) Enum() *NetworkProfileNetworkFeatures_AllowVpcPeering {
	p := new(NetworkProfileNetworkFeatures_AllowVpcPeering)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowVpcPeering) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowVpcPeering) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[279].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowVpcPeering) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[279]
}

func (x NetworkProfileNetworkFeatures_AllowVpcPeering) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowVpcPeering.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowVpcPeering) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 20}
}

// Specifies whether VPN creation is allowed.
type NetworkProfileNetworkFeatures_AllowVpn int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_ALLOW_VPN NetworkProfileNetworkFeatures_AllowVpn = 0
	NetworkProfileNetworkFeatures_VPN_ALLOWED         NetworkProfileNetworkFeatures_AllowVpn = 162163997
	NetworkProfileNetworkFeatures_VPN_BLOCKED         NetworkProfileNetworkFeatures_AllowVpn = 515198305
)

// Enum value maps for NetworkProfileNetworkFeatures_AllowVpn.
var (
	NetworkProfileNetworkFeatures_AllowVpn_name = map[int32]string{
		0:         "UNDEFINED_ALLOW_VPN",
		162163997: "VPN_ALLOWED",
		515198305: "VPN_BLOCKED",
	}
	NetworkProfileNetworkFeatures_AllowVpn_value = map[string]int32{
		"UNDEFINED_ALLOW_VPN": 0,
		"VPN_ALLOWED":         162163997,
		"VPN_BLOCKED":         515198305,
	}
)

func (x NetworkProfileNetworkFeatures_AllowVpn) Enum() *NetworkProfileNetworkFeatures_AllowVpn {
	p := new(NetworkProfileNetworkFeatures_AllowVpn)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_AllowVpn) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_AllowVpn) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[280].Descriptor()
}

func (NetworkProfileNetworkFeatures_AllowVpn) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[280]
}

func (x NetworkProfileNetworkFeatures_AllowVpn) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_AllowVpn.Descriptor instead.
func (NetworkProfileNetworkFeatures_AllowVpn) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 21}
}

type NetworkProfileNetworkFeatures_InterfaceTypes int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_INTERFACE_TYPES NetworkProfileNetworkFeatures_InterfaceTypes = 0
	// GVNIC
	NetworkProfileNetworkFeatures_GVNIC NetworkProfileNetworkFeatures_InterfaceTypes = 68209305
	// IDPF
	NetworkProfileNetworkFeatures_IDPF NetworkProfileNetworkFeatures_InterfaceTypes = 2242641
	// IRDMA
	NetworkProfileNetworkFeatures_IRDMA NetworkProfileNetworkFeatures_InterfaceTypes = 69927695
	// MRDMA
	NetworkProfileNetworkFeatures_MRDMA NetworkProfileNetworkFeatures_InterfaceTypes = 73621779
	// No type specified.
	NetworkProfileNetworkFeatures_UNSPECIFIED_NIC_TYPE NetworkProfileNetworkFeatures_InterfaceTypes = 67411801
	// VIRTIO
	NetworkProfileNetworkFeatures_VIRTIO_NET NetworkProfileNetworkFeatures_InterfaceTypes = 452123481
)

// Enum value maps for NetworkProfileNetworkFeatures_InterfaceTypes.
var (
	NetworkProfileNetworkFeatures_InterfaceTypes_name = map[int32]string{
		0:         "UNDEFINED_INTERFACE_TYPES",
		68209305:  "GVNIC",
		2242641:   "IDPF",
		69927695:  "IRDMA",
		73621779:  "MRDMA",
		67411801:  "UNSPECIFIED_NIC_TYPE",
		452123481: "VIRTIO_NET",
	}
	NetworkProfileNetworkFeatures_InterfaceTypes_value = map[string]int32{
		"UNDEFINED_INTERFACE_TYPES": 0,
		"GVNIC":                     68209305,
		"IDPF":                      2242641,
		"IRDMA":                     69927695,
		"MRDMA":                     73621779,
		"UNSPECIFIED_NIC_TYPE":      67411801,
		"VIRTIO_NET":                452123481,
	}
)

func (x NetworkProfileNetworkFeatures_InterfaceTypes) Enum() *NetworkProfileNetworkFeatures_InterfaceTypes {
	p := new(NetworkProfileNetworkFeatures_InterfaceTypes)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_InterfaceTypes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_InterfaceTypes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[281].Descriptor()
}

func (NetworkProfileNetworkFeatures_InterfaceTypes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[281]
}

func (x NetworkProfileNetworkFeatures_InterfaceTypes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_InterfaceTypes.Descriptor instead.
func (NetworkProfileNetworkFeatures_InterfaceTypes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 22}
}

type NetworkProfileNetworkFeatures_SubnetPurposes int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_SUBNET_PURPOSES      NetworkProfileNetworkFeatures_SubnetPurposes = 0
	NetworkProfileNetworkFeatures_SUBNET_PURPOSE_CUSTOM_HARDWARE NetworkProfileNetworkFeatures_SubnetPurposes = 283160275
	NetworkProfileNetworkFeatures_SUBNET_PURPOSE_PRIVATE         NetworkProfileNetworkFeatures_SubnetPurposes = 404371008
)

// Enum value maps for NetworkProfileNetworkFeatures_SubnetPurposes.
var (
	NetworkProfileNetworkFeatures_SubnetPurposes_name = map[int32]string{
		0:         "UNDEFINED_SUBNET_PURPOSES",
		283160275: "SUBNET_PURPOSE_CUSTOM_HARDWARE",
		404371008: "SUBNET_PURPOSE_PRIVATE",
	}
	NetworkProfileNetworkFeatures_SubnetPurposes_value = map[string]int32{
		"UNDEFINED_SUBNET_PURPOSES":      0,
		"SUBNET_PURPOSE_CUSTOM_HARDWARE": 283160275,
		"SUBNET_PURPOSE_PRIVATE":         404371008,
	}
)

func (x NetworkProfileNetworkFeatures_SubnetPurposes) Enum() *NetworkProfileNetworkFeatures_SubnetPurposes {
	p := new(NetworkProfileNetworkFeatures_SubnetPurposes)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_SubnetPurposes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_SubnetPurposes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[282].Descriptor()
}

func (NetworkProfileNetworkFeatures_SubnetPurposes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[282]
}

func (x NetworkProfileNetworkFeatures_SubnetPurposes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_SubnetPurposes.Descriptor instead.
func (NetworkProfileNetworkFeatures_SubnetPurposes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 23}
}

type NetworkProfileNetworkFeatures_SubnetStackTypes int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_SUBNET_STACK_TYPES NetworkProfileNetworkFeatures_SubnetStackTypes = 0
	NetworkProfileNetworkFeatures_SUBNET_STACK_TYPE_IPV4_IPV6  NetworkProfileNetworkFeatures_SubnetStackTypes = 41454485
	NetworkProfileNetworkFeatures_SUBNET_STACK_TYPE_IPV4_ONLY  NetworkProfileNetworkFeatures_SubnetStackTypes = 41631034
	NetworkProfileNetworkFeatures_SUBNET_STACK_TYPE_IPV6_ONLY  NetworkProfileNetworkFeatures_SubnetStackTypes = 98889336
)

// Enum value maps for NetworkProfileNetworkFeatures_SubnetStackTypes.
var (
	NetworkProfileNetworkFeatures_SubnetStackTypes_name = map[int32]string{
		0:        "UNDEFINED_SUBNET_STACK_TYPES",
		41454485: "SUBNET_STACK_TYPE_IPV4_IPV6",
		41631034: "SUBNET_STACK_TYPE_IPV4_ONLY",
		98889336: "SUBNET_STACK_TYPE_IPV6_ONLY",
	}
	NetworkProfileNetworkFeatures_SubnetStackTypes_value = map[string]int32{
		"UNDEFINED_SUBNET_STACK_TYPES": 0,
		"SUBNET_STACK_TYPE_IPV4_IPV6":  41454485,
		"SUBNET_STACK_TYPE_IPV4_ONLY":  41631034,
		"SUBNET_STACK_TYPE_IPV6_ONLY":  98889336,
	}
)

func (x NetworkProfileNetworkFeatures_SubnetStackTypes) Enum() *NetworkProfileNetworkFeatures_SubnetStackTypes {
	p := new(NetworkProfileNetworkFeatures_SubnetStackTypes)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_SubnetStackTypes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_SubnetStackTypes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[283].Descriptor()
}

func (NetworkProfileNetworkFeatures_SubnetStackTypes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[283]
}

func (x NetworkProfileNetworkFeatures_SubnetStackTypes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_SubnetStackTypes.Descriptor instead.
func (NetworkProfileNetworkFeatures_SubnetStackTypes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 24}
}

// Additional supported values which may be not listed in the enum directly due to technical reasons:
// PRIVATE_SERVICE_CONNECT
type NetworkProfileNetworkFeatures_SubnetworkPurposes int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_SUBNETWORK_PURPOSES NetworkProfileNetworkFeatures_SubnetworkPurposes = 0
	// Subnet reserved for Global Envoy-based Load Balancing.
	NetworkProfileNetworkFeatures_GLOBAL_MANAGED_PROXY NetworkProfileNetworkFeatures_SubnetworkPurposes = 236463602
	// Subnet reserved for Internal HTTP(S) Load Balancing. This is a legacy purpose, please use REGIONAL_MANAGED_PROXY instead.
	NetworkProfileNetworkFeatures_INTERNAL_HTTPS_LOAD_BALANCER NetworkProfileNetworkFeatures_SubnetworkPurposes = 248748889
	// Subnetwork will be used for Migration from one peered VPC to another. (a transient state of subnetwork while migrating resources from one project to another).
	NetworkProfileNetworkFeatures_PEER_MIGRATION NetworkProfileNetworkFeatures_SubnetworkPurposes = 491902225
	// Regular user created or automatically created subnet.
	NetworkProfileNetworkFeatures_PRIVATE NetworkProfileNetworkFeatures_SubnetworkPurposes = 403485027
	// Subnetwork used as source range for Private NAT Gateways.
	NetworkProfileNetworkFeatures_PRIVATE_NAT NetworkProfileNetworkFeatures_SubnetworkPurposes = 367764517
	// Regular user created or automatically created subnet.
	NetworkProfileNetworkFeatures_PRIVATE_RFC_1918 NetworkProfileNetworkFeatures_SubnetworkPurposes = 254902107
	// Subnetwork used for Regional Envoy-based Load Balancing.
	NetworkProfileNetworkFeatures_REGIONAL_MANAGED_PROXY NetworkProfileNetworkFeatures_SubnetworkPurposes = 153049966
)

// Enum value maps for NetworkProfileNetworkFeatures_SubnetworkPurposes.
var (
	NetworkProfileNetworkFeatures_SubnetworkPurposes_name = map[int32]string{
		0:         "UNDEFINED_SUBNETWORK_PURPOSES",
		236463602: "GLOBAL_MANAGED_PROXY",
		248748889: "INTERNAL_HTTPS_LOAD_BALANCER",
		491902225: "PEER_MIGRATION",
		403485027: "PRIVATE",
		367764517: "PRIVATE_NAT",
		254902107: "PRIVATE_RFC_1918",
		153049966: "REGIONAL_MANAGED_PROXY",
	}
	NetworkProfileNetworkFeatures_SubnetworkPurposes_value = map[string]int32{
		"UNDEFINED_SUBNETWORK_PURPOSES": 0,
		"GLOBAL_MANAGED_PROXY":          236463602,
		"INTERNAL_HTTPS_LOAD_BALANCER":  248748889,
		"PEER_MIGRATION":                491902225,
		"PRIVATE":                       403485027,
		"PRIVATE_NAT":                   367764517,
		"PRIVATE_RFC_1918":              254902107,
		"REGIONAL_MANAGED_PROXY":        153049966,
	}
)

func (x NetworkProfileNetworkFeatures_SubnetworkPurposes) Enum() *NetworkProfileNetworkFeatures_SubnetworkPurposes {
	p := new(NetworkProfileNetworkFeatures_SubnetworkPurposes)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_SubnetworkPurposes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_SubnetworkPurposes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[284].Descriptor()
}

func (NetworkProfileNetworkFeatures_SubnetworkPurposes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[284]
}

func (x NetworkProfileNetworkFeatures_SubnetworkPurposes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_SubnetworkPurposes.Descriptor instead.
func (NetworkProfileNetworkFeatures_SubnetworkPurposes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 25}
}

type NetworkProfileNetworkFeatures_SubnetworkStackTypes int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_SUBNETWORK_STACK_TYPES NetworkProfileNetworkFeatures_SubnetworkStackTypes = 0
	// New VMs in this subnet can have both IPv4 and IPv6 addresses.
	NetworkProfileNetworkFeatures_IPV4_IPV6 NetworkProfileNetworkFeatures_SubnetworkStackTypes = 22197249
	// New VMs in this subnet will only be assigned IPv4 addresses.
	NetworkProfileNetworkFeatures_IPV4_ONLY NetworkProfileNetworkFeatures_SubnetworkStackTypes = 22373798
	// New VMs in this subnet will only be assigned IPv6 addresses.
	NetworkProfileNetworkFeatures_IPV6_ONLY NetworkProfileNetworkFeatures_SubnetworkStackTypes = 79632100
)

// Enum value maps for NetworkProfileNetworkFeatures_SubnetworkStackTypes.
var (
	NetworkProfileNetworkFeatures_SubnetworkStackTypes_name = map[int32]string{
		0:        "UNDEFINED_SUBNETWORK_STACK_TYPES",
		22197249: "IPV4_IPV6",
		22373798: "IPV4_ONLY",
		79632100: "IPV6_ONLY",
	}
	NetworkProfileNetworkFeatures_SubnetworkStackTypes_value = map[string]int32{
		"UNDEFINED_SUBNETWORK_STACK_TYPES": 0,
		"IPV4_IPV6":                        22197249,
		"IPV4_ONLY":                        22373798,
		"IPV6_ONLY":                        79632100,
	}
)

func (x NetworkProfileNetworkFeatures_SubnetworkStackTypes) Enum() *NetworkProfileNetworkFeatures_SubnetworkStackTypes {
	p := new(NetworkProfileNetworkFeatures_SubnetworkStackTypes)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_SubnetworkStackTypes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_SubnetworkStackTypes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[285].Descriptor()
}

func (NetworkProfileNetworkFeatures_SubnetworkStackTypes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[285]
}

func (x NetworkProfileNetworkFeatures_SubnetworkStackTypes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_SubnetworkStackTypes.Descriptor instead.
func (NetworkProfileNetworkFeatures_SubnetworkStackTypes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 26}
}

// Specifies which type of unicast is supported.
type NetworkProfileNetworkFeatures_Unicast int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileNetworkFeatures_UNDEFINED_UNICAST NetworkProfileNetworkFeatures_Unicast = 0
	NetworkProfileNetworkFeatures_UNICAST_SDN       NetworkProfileNetworkFeatures_Unicast = 379954157
	NetworkProfileNetworkFeatures_UNICAST_ULL       NetworkProfileNetworkFeatures_Unicast = 379956325
)

// Enum value maps for NetworkProfileNetworkFeatures_Unicast.
var (
	NetworkProfileNetworkFeatures_Unicast_name = map[int32]string{
		0:         "UNDEFINED_UNICAST",
		379954157: "UNICAST_SDN",
		379956325: "UNICAST_ULL",
	}
	NetworkProfileNetworkFeatures_Unicast_value = map[string]int32{
		"UNDEFINED_UNICAST": 0,
		"UNICAST_SDN":       379954157,
		"UNICAST_ULL":       379956325,
	}
)

func (x NetworkProfileNetworkFeatures_Unicast) Enum() *NetworkProfileNetworkFeatures_Unicast {
	p := new(NetworkProfileNetworkFeatures_Unicast)
	*p = x
	return p
}

func (x NetworkProfileNetworkFeatures_Unicast) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileNetworkFeatures_Unicast) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[286].Descriptor()
}

func (NetworkProfileNetworkFeatures_Unicast) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[286]
}

func (x NetworkProfileNetworkFeatures_Unicast) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileNetworkFeatures_Unicast.Descriptor instead.
func (NetworkProfileNetworkFeatures_Unicast) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1138, 27}
}

type NetworkProfileProfileType_NetworkType int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileProfileType_UNDEFINED_NETWORK_TYPE NetworkProfileProfileType_NetworkType = 0
	// RDMA network.
	NetworkProfileProfileType_RDMA NetworkProfileProfileType_NetworkType = 2510662
	// ULL network.
	NetworkProfileProfileType_ULL NetworkProfileProfileType_NetworkType = 84117
	// VPC network.
	NetworkProfileProfileType_VPC NetworkProfileProfileType_NetworkType = 85193
)

// Enum value maps for NetworkProfileProfileType_NetworkType.
var (
	NetworkProfileProfileType_NetworkType_name = map[int32]string{
		0:       "UNDEFINED_NETWORK_TYPE",
		2510662: "RDMA",
		84117:   "ULL",
		85193:   "VPC",
	}
	NetworkProfileProfileType_NetworkType_value = map[string]int32{
		"UNDEFINED_NETWORK_TYPE": 0,
		"RDMA":                   2510662,
		"ULL":                    84117,
		"VPC":                    85193,
	}
)

func (x NetworkProfileProfileType_NetworkType) Enum() *NetworkProfileProfileType_NetworkType {
	p := new(NetworkProfileProfileType_NetworkType)
	*p = x
	return p
}

func (x NetworkProfileProfileType_NetworkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileProfileType_NetworkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[287].Descriptor()
}

func (NetworkProfileProfileType_NetworkType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[287]
}

func (x NetworkProfileProfileType_NetworkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileProfileType_NetworkType.Descriptor instead.
func (NetworkProfileProfileType_NetworkType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1139, 0}
}

type NetworkProfileProfileType_RdmaSubtype int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileProfileType_UNDEFINED_RDMA_SUBTYPE NetworkProfileProfileType_RdmaSubtype = 0
	// RDMA over Falcon.
	NetworkProfileProfileType_FALCON NetworkProfileProfileType_RdmaSubtype = 455787729
	// RDMA over Converged Ethernet (RoCE).
	NetworkProfileProfileType_ROCE NetworkProfileProfileType_RdmaSubtype = 2520927
)

// Enum value maps for NetworkProfileProfileType_RdmaSubtype.
var (
	NetworkProfileProfileType_RdmaSubtype_name = map[int32]string{
		0:         "UNDEFINED_RDMA_SUBTYPE",
		455787729: "FALCON",
		2520927:   "ROCE",
	}
	NetworkProfileProfileType_RdmaSubtype_value = map[string]int32{
		"UNDEFINED_RDMA_SUBTYPE": 0,
		"FALCON":                 455787729,
		"ROCE":                   2520927,
	}
)

func (x NetworkProfileProfileType_RdmaSubtype) Enum() *NetworkProfileProfileType_RdmaSubtype {
	p := new(NetworkProfileProfileType_RdmaSubtype)
	*p = x
	return p
}

func (x NetworkProfileProfileType_RdmaSubtype) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileProfileType_RdmaSubtype) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[288].Descriptor()
}

func (NetworkProfileProfileType_RdmaSubtype) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[288]
}

func (x NetworkProfileProfileType_RdmaSubtype) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileProfileType_RdmaSubtype.Descriptor instead.
func (NetworkProfileProfileType_RdmaSubtype) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1139, 1}
}

type NetworkProfileProfileType_UllSubtype int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileProfileType_UNDEFINED_ULL_SUBTYPE NetworkProfileProfileType_UllSubtype = 0
	// Exchange operator.
	NetworkProfileProfileType_OPERATOR NetworkProfileProfileType_UllSubtype = 282073252
	// Exchange participant.
	NetworkProfileProfileType_PARTICIPANT NetworkProfileProfileType_UllSubtype = 236028691
)

// Enum value maps for NetworkProfileProfileType_UllSubtype.
var (
	NetworkProfileProfileType_UllSubtype_name = map[int32]string{
		0:         "UNDEFINED_ULL_SUBTYPE",
		282073252: "OPERATOR",
		236028691: "PARTICIPANT",
	}
	NetworkProfileProfileType_UllSubtype_value = map[string]int32{
		"UNDEFINED_ULL_SUBTYPE": 0,
		"OPERATOR":              282073252,
		"PARTICIPANT":           236028691,
	}
)

func (x NetworkProfileProfileType_UllSubtype) Enum() *NetworkProfileProfileType_UllSubtype {
	p := new(NetworkProfileProfileType_UllSubtype)
	*p = x
	return p
}

func (x NetworkProfileProfileType_UllSubtype) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileProfileType_UllSubtype) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[289].Descriptor()
}

func (NetworkProfileProfileType_UllSubtype) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[289]
}

func (x NetworkProfileProfileType_UllSubtype) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileProfileType_UllSubtype.Descriptor instead.
func (NetworkProfileProfileType_UllSubtype) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1139, 2}
}

type NetworkProfileProfileType_VpcSubtype int32

const (
	// A value indicating that the enum field is not set.
	NetworkProfileProfileType_UNDEFINED_VPC_SUBTYPE NetworkProfileProfileType_VpcSubtype = 0
	// Regionally bound VPC network.
	NetworkProfileProfileType_REGIONAL NetworkProfileProfileType_VpcSubtype = 92288543
)

// Enum value maps for NetworkProfileProfileType_VpcSubtype.
var (
	NetworkProfileProfileType_VpcSubtype_name = map[int32]string{
		0:        "UNDEFINED_VPC_SUBTYPE",
		92288543: "REGIONAL",
	}
	NetworkProfileProfileType_VpcSubtype_value = map[string]int32{
		"UNDEFINED_VPC_SUBTYPE": 0,
		"REGIONAL":              92288543,
	}
)

func (x NetworkProfileProfileType_VpcSubtype) Enum() *NetworkProfileProfileType_VpcSubtype {
	p := new(NetworkProfileProfileType_VpcSubtype)
	*p = x
	return p
}

func (x NetworkProfileProfileType_VpcSubtype) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkProfileProfileType_VpcSubtype) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[290].Descriptor()
}

func (NetworkProfileProfileType_VpcSubtype) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[290]
}

func (x NetworkProfileProfileType_VpcSubtype) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkProfileProfileType_VpcSubtype.Descriptor instead.
func (NetworkProfileProfileType_VpcSubtype) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1139, 3}
}

// The BGP best path selection algorithm to be employed within this network for dynamic routes learned by Cloud Routers. Can be LEGACY (default) or STANDARD.
type NetworkRoutingConfig_BgpBestPathSelectionMode int32

const (
	// A value indicating that the enum field is not set.
	NetworkRoutingConfig_UNDEFINED_BGP_BEST_PATH_SELECTION_MODE NetworkRoutingConfig_BgpBestPathSelectionMode = 0
	NetworkRoutingConfig_LEGACY                                 NetworkRoutingConfig_BgpBestPathSelectionMode = 94234569
	NetworkRoutingConfig_STANDARD                               NetworkRoutingConfig_BgpBestPathSelectionMode = 484642493
)

// Enum value maps for NetworkRoutingConfig_BgpBestPathSelectionMode.
var (
	NetworkRoutingConfig_BgpBestPathSelectionMode_name = map[int32]string{
		0:         "UNDEFINED_BGP_BEST_PATH_SELECTION_MODE",
		94234569:  "LEGACY",
		484642493: "STANDARD",
	}
	NetworkRoutingConfig_BgpBestPathSelectionMode_value = map[string]int32{
		"UNDEFINED_BGP_BEST_PATH_SELECTION_MODE": 0,
		"LEGACY":                                 94234569,
		"STANDARD":                               484642493,
	}
)

func (x NetworkRoutingConfig_BgpBestPathSelectionMode) Enum() *NetworkRoutingConfig_BgpBestPathSelectionMode {
	p := new(NetworkRoutingConfig_BgpBestPathSelectionMode)
	*p = x
	return p
}

func (x NetworkRoutingConfig_BgpBestPathSelectionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkRoutingConfig_BgpBestPathSelectionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[291].Descriptor()
}

func (NetworkRoutingConfig_BgpBestPathSelectionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[291]
}

func (x NetworkRoutingConfig_BgpBestPathSelectionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkRoutingConfig_BgpBestPathSelectionMode.Descriptor instead.
func (NetworkRoutingConfig_BgpBestPathSelectionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1141, 0}
}

// Allows to define a preferred approach for handling inter-region cost in the selection process when using the STANDARD BGP best path selection algorithm. Can be DEFAULT or ADD_COST_TO_MED.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// ADD_COST_TO_MED
// DEFAULT
type NetworkRoutingConfig_BgpInterRegionCost int32

const (
	// A value indicating that the enum field is not set.
	NetworkRoutingConfig_UNDEFINED_BGP_INTER_REGION_COST NetworkRoutingConfig_BgpInterRegionCost = 0
	NetworkRoutingConfig_ADD_COST_TO_MED                 NetworkRoutingConfig_BgpInterRegionCost = 490583004
	NetworkRoutingConfig_DEFAULT                         NetworkRoutingConfig_BgpInterRegionCost = 115302945
)

// Enum value maps for NetworkRoutingConfig_BgpInterRegionCost.
var (
	NetworkRoutingConfig_BgpInterRegionCost_name = map[int32]string{
		0:         "UNDEFINED_BGP_INTER_REGION_COST",
		490583004: "ADD_COST_TO_MED",
		115302945: "DEFAULT",
	}
	NetworkRoutingConfig_BgpInterRegionCost_value = map[string]int32{
		"UNDEFINED_BGP_INTER_REGION_COST": 0,
		"ADD_COST_TO_MED":                 490583004,
		"DEFAULT":                         115302945,
	}
)

func (x NetworkRoutingConfig_BgpInterRegionCost) Enum() *NetworkRoutingConfig_BgpInterRegionCost {
	p := new(NetworkRoutingConfig_BgpInterRegionCost)
	*p = x
	return p
}

func (x NetworkRoutingConfig_BgpInterRegionCost) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkRoutingConfig_BgpInterRegionCost) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[292].Descriptor()
}

func (NetworkRoutingConfig_BgpInterRegionCost) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[292]
}

func (x NetworkRoutingConfig_BgpInterRegionCost) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkRoutingConfig_BgpInterRegionCost.Descriptor instead.
func (NetworkRoutingConfig_BgpInterRegionCost) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1141, 1}
}

// [Output Only] Effective value of the bgp_inter_region_cost field.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// ADD_COST_TO_MED
// DEFAULT
type NetworkRoutingConfig_EffectiveBgpInterRegionCost int32

const (
	// A value indicating that the enum field is not set.
	NetworkRoutingConfig_UNDEFINED_EFFECTIVE_BGP_INTER_REGION_COST NetworkRoutingConfig_EffectiveBgpInterRegionCost = 0
)

// Enum value maps for NetworkRoutingConfig_EffectiveBgpInterRegionCost.
var (
	NetworkRoutingConfig_EffectiveBgpInterRegionCost_name = map[int32]string{
		0: "UNDEFINED_EFFECTIVE_BGP_INTER_REGION_COST",
	}
	NetworkRoutingConfig_EffectiveBgpInterRegionCost_value = map[string]int32{
		"UNDEFINED_EFFECTIVE_BGP_INTER_REGION_COST": 0,
	}
)

func (x NetworkRoutingConfig_EffectiveBgpInterRegionCost) Enum() *NetworkRoutingConfig_EffectiveBgpInterRegionCost {
	p := new(NetworkRoutingConfig_EffectiveBgpInterRegionCost)
	*p = x
	return p
}

func (x NetworkRoutingConfig_EffectiveBgpInterRegionCost) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkRoutingConfig_EffectiveBgpInterRegionCost) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[293].Descriptor()
}

func (NetworkRoutingConfig_EffectiveBgpInterRegionCost) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[293]
}

func (x NetworkRoutingConfig_EffectiveBgpInterRegionCost) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkRoutingConfig_EffectiveBgpInterRegionCost.Descriptor instead.
func (NetworkRoutingConfig_EffectiveBgpInterRegionCost) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1141, 2}
}

// The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
type NetworkRoutingConfig_RoutingMode int32

const (
	// A value indicating that the enum field is not set.
	NetworkRoutingConfig_UNDEFINED_ROUTING_MODE NetworkRoutingConfig_RoutingMode = 0
	NetworkRoutingConfig_GLOBAL                 NetworkRoutingConfig_RoutingMode = 494663587
	NetworkRoutingConfig_REGIONAL               NetworkRoutingConfig_RoutingMode = 92288543
)

// Enum value maps for NetworkRoutingConfig_RoutingMode.
var (
	NetworkRoutingConfig_RoutingMode_name = map[int32]string{
		0:         "UNDEFINED_ROUTING_MODE",
		494663587: "GLOBAL",
		92288543:  "REGIONAL",
	}
	NetworkRoutingConfig_RoutingMode_value = map[string]int32{
		"UNDEFINED_ROUTING_MODE": 0,
		"GLOBAL":                 494663587,
		"REGIONAL":               92288543,
	}
)

func (x NetworkRoutingConfig_RoutingMode) Enum() *NetworkRoutingConfig_RoutingMode {
	p := new(NetworkRoutingConfig_RoutingMode)
	*p = x
	return p
}

func (x NetworkRoutingConfig_RoutingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkRoutingConfig_RoutingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[294].Descriptor()
}

func (NetworkRoutingConfig_RoutingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[294]
}

func (x NetworkRoutingConfig_RoutingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkRoutingConfig_RoutingMode.Descriptor instead.
func (NetworkRoutingConfig_RoutingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1141, 3}
}

// [Output Only] The type of the firewall policy.
type NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNDEFINED_TYPE NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 0
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_HIERARCHY      NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 69902869
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK        NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 413984270
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_SYSTEM         NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 313484847
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNSPECIFIED    NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 526786327
)

// Enum value maps for NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.
var (
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		69902869:  "HIERARCHY",
		413984270: "NETWORK",
		313484847: "SYSTEM",
		526786327: "UNSPECIFIED",
	}
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"HIERARCHY":      69902869,
		"NETWORK":        413984270,
		"SYSTEM":         313484847,
		"UNSPECIFIED":    526786327,
	}
)

func (x NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Enum() *NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type {
	p := new(NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type)
	*p = x
	return p
}

func (x NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[295].Descriptor()
}

func (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[295]
}

func (x NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.Descriptor instead.
func (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1144, 0}
}

// Specifies the frequency of planned maintenance events. The accepted values are: `AS_NEEDED` and `RECURRENT`.
type NodeGroup_MaintenanceInterval int32

const (
	// A value indicating that the enum field is not set.
	NodeGroup_UNDEFINED_MAINTENANCE_INTERVAL NodeGroup_MaintenanceInterval = 0
	// VMs are eligible to receive infrastructure and hypervisor updates as they become available. This may result in more maintenance operations (live migrations or terminations) for the VM than the PERIODIC and RECURRENT options.
	NodeGroup_AS_NEEDED NodeGroup_MaintenanceInterval = 500724834
	// VMs receive infrastructure and hypervisor updates on a periodic basis, minimizing the number of maintenance operations (live migrations or terminations) on an individual VM. This may mean a VM will take longer to receive an update than if it was configured for AS_NEEDED. Security updates will still be applied as soon as they are available.
	NodeGroup_PERIODIC NodeGroup_MaintenanceInterval = 142804635
	// VMs receive infrastructure and hypervisor updates on a periodic basis, minimizing the number of maintenance operations (live migrations or terminations) on an individual VM. This may mean a VM will take longer to receive an update than if it was configured for AS_NEEDED. Security updates will still be applied as soon as they are available. RECURRENT is used for GEN3 and Slice of Hardware VMs.
	NodeGroup_RECURRENT NodeGroup_MaintenanceInterval = 194244550
)

// Enum value maps for NodeGroup_MaintenanceInterval.
var (
	NodeGroup_MaintenanceInterval_name = map[int32]string{
		0:         "UNDEFINED_MAINTENANCE_INTERVAL",
		500724834: "AS_NEEDED",
		142804635: "PERIODIC",
		194244550: "RECURRENT",
	}
	NodeGroup_MaintenanceInterval_value = map[string]int32{
		"UNDEFINED_MAINTENANCE_INTERVAL": 0,
		"AS_NEEDED":                      500724834,
		"PERIODIC":                       142804635,
		"RECURRENT":                      194244550,
	}
)

func (x NodeGroup_MaintenanceInterval) Enum() *NodeGroup_MaintenanceInterval {
	p := new(NodeGroup_MaintenanceInterval)
	*p = x
	return p
}

func (x NodeGroup_MaintenanceInterval) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroup_MaintenanceInterval) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[296].Descriptor()
}

func (NodeGroup_MaintenanceInterval) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[296]
}

func (x NodeGroup_MaintenanceInterval) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroup_MaintenanceInterval.Descriptor instead.
func (NodeGroup_MaintenanceInterval) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1149, 0}
}

// Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
type NodeGroup_MaintenancePolicy int32

const (
	// A value indicating that the enum field is not set.
	NodeGroup_UNDEFINED_MAINTENANCE_POLICY NodeGroup_MaintenancePolicy = 0
	// Allow the node and corresponding instances to retain default maintenance behavior.
	NodeGroup_DEFAULT                        NodeGroup_MaintenancePolicy = 115302945
	NodeGroup_MAINTENANCE_POLICY_UNSPECIFIED NodeGroup_MaintenancePolicy = 72964182
	// When maintenance must be done on a node, the instances on that node will be moved to other nodes in the group. Instances with onHostMaintenance = MIGRATE will live migrate to their destinations while instances with onHostMaintenance = TERMINATE will terminate and then restart on their destination nodes if automaticRestart = true.
	NodeGroup_MIGRATE_WITHIN_NODE_GROUP NodeGroup_MaintenancePolicy = 153483394
	// Instances in this group will restart on the same node when maintenance has completed. Instances must have onHostMaintenance = TERMINATE, and they will only restart if automaticRestart = true.
	NodeGroup_RESTART_IN_PLACE NodeGroup_MaintenancePolicy = 228647325
)

// Enum value maps for NodeGroup_MaintenancePolicy.
var (
	NodeGroup_MaintenancePolicy_name = map[int32]string{
		0:         "UNDEFINED_MAINTENANCE_POLICY",
		115302945: "DEFAULT",
		72964182:  "MAINTENANCE_POLICY_UNSPECIFIED",
		153483394: "MIGRATE_WITHIN_NODE_GROUP",
		228647325: "RESTART_IN_PLACE",
	}
	NodeGroup_MaintenancePolicy_value = map[string]int32{
		"UNDEFINED_MAINTENANCE_POLICY":   0,
		"DEFAULT":                        115302945,
		"MAINTENANCE_POLICY_UNSPECIFIED": 72964182,
		"MIGRATE_WITHIN_NODE_GROUP":      153483394,
		"RESTART_IN_PLACE":               228647325,
	}
)

func (x NodeGroup_MaintenancePolicy) Enum() *NodeGroup_MaintenancePolicy {
	p := new(NodeGroup_MaintenancePolicy)
	*p = x
	return p
}

func (x NodeGroup_MaintenancePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroup_MaintenancePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[297].Descriptor()
}

func (NodeGroup_MaintenancePolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[297]
}

func (x NodeGroup_MaintenancePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroup_MaintenancePolicy.Descriptor instead.
func (NodeGroup_MaintenancePolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1149, 1}
}

type NodeGroup_Status int32

const (
	// A value indicating that the enum field is not set.
	NodeGroup_UNDEFINED_STATUS NodeGroup_Status = 0
	NodeGroup_CREATING         NodeGroup_Status = 455564985
	NodeGroup_DELETING         NodeGroup_Status = 528602024
	NodeGroup_INVALID          NodeGroup_Status = 530283991
	NodeGroup_READY            NodeGroup_Status = 77848963
)

// Enum value maps for NodeGroup_Status.
var (
	NodeGroup_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
	}
	NodeGroup_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x NodeGroup_Status) Enum() *NodeGroup_Status {
	p := new(NodeGroup_Status)
	*p = x
	return p
}

func (x NodeGroup_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroup_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[298].Descriptor()
}

func (NodeGroup_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[298]
}

func (x NodeGroup_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroup_Status.Descriptor instead.
func (NodeGroup_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1149, 2}
}

// The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see Autoscaler modes.
type NodeGroupAutoscalingPolicy_Mode int32

const (
	// A value indicating that the enum field is not set.
	NodeGroupAutoscalingPolicy_UNDEFINED_MODE   NodeGroupAutoscalingPolicy_Mode = 0
	NodeGroupAutoscalingPolicy_MODE_UNSPECIFIED NodeGroupAutoscalingPolicy_Mode = 371348091
	// Autoscaling is disabled.
	NodeGroupAutoscalingPolicy_OFF NodeGroupAutoscalingPolicy_Mode = 78159
	// Autocaling is fully enabled.
	NodeGroupAutoscalingPolicy_ON NodeGroupAutoscalingPolicy_Mode = 2527
	// Autoscaling will only scale out and will not remove nodes.
	NodeGroupAutoscalingPolicy_ONLY_SCALE_OUT NodeGroupAutoscalingPolicy_Mode = 152713670
)

// Enum value maps for NodeGroupAutoscalingPolicy_Mode.
var (
	NodeGroupAutoscalingPolicy_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		371348091: "MODE_UNSPECIFIED",
		78159:     "OFF",
		2527:      "ON",
		152713670: "ONLY_SCALE_OUT",
	}
	NodeGroupAutoscalingPolicy_Mode_value = map[string]int32{
		"UNDEFINED_MODE":   0,
		"MODE_UNSPECIFIED": 371348091,
		"OFF":              78159,
		"ON":               2527,
		"ONLY_SCALE_OUT":   152713670,
	}
)

func (x NodeGroupAutoscalingPolicy_Mode) Enum() *NodeGroupAutoscalingPolicy_Mode {
	p := new(NodeGroupAutoscalingPolicy_Mode)
	*p = x
	return p
}

func (x NodeGroupAutoscalingPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroupAutoscalingPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[299].Descriptor()
}

func (NodeGroupAutoscalingPolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[299]
}

func (x NodeGroupAutoscalingPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroupAutoscalingPolicy_Mode.Descriptor instead.
func (NodeGroupAutoscalingPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1151, 0}
}

// CPU overcommit.
type NodeGroupNode_CpuOvercommitType int32

const (
	// A value indicating that the enum field is not set.
	NodeGroupNode_UNDEFINED_CPU_OVERCOMMIT_TYPE   NodeGroupNode_CpuOvercommitType = 0
	NodeGroupNode_CPU_OVERCOMMIT_TYPE_UNSPECIFIED NodeGroupNode_CpuOvercommitType = 520665615
	NodeGroupNode_ENABLED                         NodeGroupNode_CpuOvercommitType = 182130465
	NodeGroupNode_NONE                            NodeGroupNode_CpuOvercommitType = 2402104
)

// Enum value maps for NodeGroupNode_CpuOvercommitType.
var (
	NodeGroupNode_CpuOvercommitType_name = map[int32]string{
		0:         "UNDEFINED_CPU_OVERCOMMIT_TYPE",
		520665615: "CPU_OVERCOMMIT_TYPE_UNSPECIFIED",
		182130465: "ENABLED",
		2402104:   "NONE",
	}
	NodeGroupNode_CpuOvercommitType_value = map[string]int32{
		"UNDEFINED_CPU_OVERCOMMIT_TYPE":   0,
		"CPU_OVERCOMMIT_TYPE_UNSPECIFIED": 520665615,
		"ENABLED":                         182130465,
		"NONE":                            2402104,
	}
)

func (x NodeGroupNode_CpuOvercommitType) Enum() *NodeGroupNode_CpuOvercommitType {
	p := new(NodeGroupNode_CpuOvercommitType)
	*p = x
	return p
}

func (x NodeGroupNode_CpuOvercommitType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroupNode_CpuOvercommitType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[300].Descriptor()
}

func (NodeGroupNode_CpuOvercommitType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[300]
}

func (x NodeGroupNode_CpuOvercommitType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroupNode_CpuOvercommitType.Descriptor instead.
func (NodeGroupNode_CpuOvercommitType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1154, 0}
}

type NodeGroupNode_Status int32

const (
	// A value indicating that the enum field is not set.
	NodeGroupNode_UNDEFINED_STATUS NodeGroupNode_Status = 0
	NodeGroupNode_CREATING         NodeGroupNode_Status = 455564985
	NodeGroupNode_DELETING         NodeGroupNode_Status = 528602024
	NodeGroupNode_INVALID          NodeGroupNode_Status = 530283991
	NodeGroupNode_READY            NodeGroupNode_Status = 77848963
	NodeGroupNode_REPAIRING        NodeGroupNode_Status = 413483285
)

// Enum value maps for NodeGroupNode_Status.
var (
	NodeGroupNode_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
		413483285: "REPAIRING",
	}
	NodeGroupNode_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
		"REPAIRING":        413483285,
	}
)

func (x NodeGroupNode_Status) Enum() *NodeGroupNode_Status {
	p := new(NodeGroupNode_Status)
	*p = x
	return p
}

func (x NodeGroupNode_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroupNode_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[301].Descriptor()
}

func (NodeGroupNode_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[301]
}

func (x NodeGroupNode_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroupNode_Status.Descriptor instead.
func (NodeGroupNode_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1154, 1}
}

// CPU overcommit.
type NodeTemplate_CpuOvercommitType int32

const (
	// A value indicating that the enum field is not set.
	NodeTemplate_UNDEFINED_CPU_OVERCOMMIT_TYPE   NodeTemplate_CpuOvercommitType = 0
	NodeTemplate_CPU_OVERCOMMIT_TYPE_UNSPECIFIED NodeTemplate_CpuOvercommitType = 520665615
	NodeTemplate_ENABLED                         NodeTemplate_CpuOvercommitType = 182130465
	NodeTemplate_NONE                            NodeTemplate_CpuOvercommitType = 2402104
)

// Enum value maps for NodeTemplate_CpuOvercommitType.
var (
	NodeTemplate_CpuOvercommitType_name = map[int32]string{
		0:         "UNDEFINED_CPU_OVERCOMMIT_TYPE",
		520665615: "CPU_OVERCOMMIT_TYPE_UNSPECIFIED",
		182130465: "ENABLED",
		2402104:   "NONE",
	}
	NodeTemplate_CpuOvercommitType_value = map[string]int32{
		"UNDEFINED_CPU_OVERCOMMIT_TYPE":   0,
		"CPU_OVERCOMMIT_TYPE_UNSPECIFIED": 520665615,
		"ENABLED":                         182130465,
		"NONE":                            2402104,
	}
)

func (x NodeTemplate_CpuOvercommitType) Enum() *NodeTemplate_CpuOvercommitType {
	p := new(NodeTemplate_CpuOvercommitType)
	*p = x
	return p
}

func (x NodeTemplate_CpuOvercommitType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTemplate_CpuOvercommitType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[302].Descriptor()
}

func (NodeTemplate_CpuOvercommitType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[302]
}

func (x NodeTemplate_CpuOvercommitType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTemplate_CpuOvercommitType.Descriptor instead.
func (NodeTemplate_CpuOvercommitType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1162, 0}
}

// [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
type NodeTemplate_Status int32

const (
	// A value indicating that the enum field is not set.
	NodeTemplate_UNDEFINED_STATUS NodeTemplate_Status = 0
	// Resources are being allocated.
	NodeTemplate_CREATING NodeTemplate_Status = 455564985
	// The node template is currently being deleted.
	NodeTemplate_DELETING NodeTemplate_Status = 528602024
	// Invalid status.
	NodeTemplate_INVALID NodeTemplate_Status = 530283991
	// The node template is ready.
	NodeTemplate_READY NodeTemplate_Status = 77848963
)

// Enum value maps for NodeTemplate_Status.
var (
	NodeTemplate_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
	}
	NodeTemplate_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x NodeTemplate_Status) Enum() *NodeTemplate_Status {
	p := new(NodeTemplate_Status)
	*p = x
	return p
}

func (x NodeTemplate_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTemplate_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[303].Descriptor()
}

func (NodeTemplate_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[303]
}

func (x NodeTemplate_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTemplate_Status.Descriptor instead.
func (NodeTemplate_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1162, 1}
}

// [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
type Operation_Status int32

const (
	// A value indicating that the enum field is not set.
	Operation_UNDEFINED_STATUS Operation_Status = 0
	Operation_DONE             Operation_Status = 2104194
	Operation_PENDING          Operation_Status = 35394935
	Operation_RUNNING          Operation_Status = 121282975
)

// Enum value maps for Operation_Status.
var (
	Operation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		2104194:   "DONE",
		35394935:  "PENDING",
		121282975: "RUNNING",
	}
	Operation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DONE":             2104194,
		"PENDING":          35394935,
		"RUNNING":          121282975,
	}
)

func (x Operation_Status) Enum() *Operation_Status {
	p := new(Operation_Status)
	*p = x
	return p
}

func (x Operation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[304].Descriptor()
}

func (Operation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[304]
}

func (x Operation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_Status.Descriptor instead.
func (Operation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1174, 0}
}

// From how long ago in the past these intervals were observed.
type PacketIntervals_Duration int32

const (
	// A value indicating that the enum field is not set.
	PacketIntervals_UNDEFINED_DURATION   PacketIntervals_Duration = 0
	PacketIntervals_DURATION_UNSPECIFIED PacketIntervals_Duration = 529071340
	PacketIntervals_HOUR                 PacketIntervals_Duration = 2223588
	// From BfdSession object creation time.
	PacketIntervals_MAX    PacketIntervals_Duration = 76100
	PacketIntervals_MINUTE PacketIntervals_Duration = 126786068
)

// Enum value maps for PacketIntervals_Duration.
var (
	PacketIntervals_Duration_name = map[int32]string{
		0:         "UNDEFINED_DURATION",
		529071340: "DURATION_UNSPECIFIED",
		2223588:   "HOUR",
		76100:     "MAX",
		126786068: "MINUTE",
	}
	PacketIntervals_Duration_value = map[string]int32{
		"UNDEFINED_DURATION":   0,
		"DURATION_UNSPECIFIED": 529071340,
		"HOUR":                 2223588,
		"MAX":                  76100,
		"MINUTE":               126786068,
	}
)

func (x PacketIntervals_Duration) Enum() *PacketIntervals_Duration {
	p := new(PacketIntervals_Duration)
	*p = x
	return p
}

func (x PacketIntervals_Duration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketIntervals_Duration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[305].Descriptor()
}

func (PacketIntervals_Duration) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[305]
}

func (x PacketIntervals_Duration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketIntervals_Duration.Descriptor instead.
func (PacketIntervals_Duration) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1180, 0}
}

// The type of packets for which inter-packet intervals were computed.
type PacketIntervals_Type int32

const (
	// A value indicating that the enum field is not set.
	PacketIntervals_UNDEFINED_TYPE PacketIntervals_Type = 0
	// Only applies to Echo packets. This shows the intervals between sending and receiving the same packet.
	PacketIntervals_LOOPBACK PacketIntervals_Type = 356174219
	// Intervals between received packets.
	PacketIntervals_RECEIVE PacketIntervals_Type = 189660867
	// Intervals between transmitted packets.
	PacketIntervals_TRANSMIT         PacketIntervals_Type = 452903600
	PacketIntervals_TYPE_UNSPECIFIED PacketIntervals_Type = 437714322
)

// Enum value maps for PacketIntervals_Type.
var (
	PacketIntervals_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		356174219: "LOOPBACK",
		189660867: "RECEIVE",
		452903600: "TRANSMIT",
		437714322: "TYPE_UNSPECIFIED",
	}
	PacketIntervals_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"LOOPBACK":         356174219,
		"RECEIVE":          189660867,
		"TRANSMIT":         452903600,
		"TYPE_UNSPECIFIED": 437714322,
	}
)

func (x PacketIntervals_Type) Enum() *PacketIntervals_Type {
	p := new(PacketIntervals_Type)
	*p = x
	return p
}

func (x PacketIntervals_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketIntervals_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[306].Descriptor()
}

func (PacketIntervals_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[306]
}

func (x PacketIntervals_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketIntervals_Type.Descriptor instead.
func (PacketIntervals_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1180, 1}
}

// Indicates whether or not this packet mirroring takes effect. If set to FALSE, this packet mirroring policy will not be enforced on the network. The default is TRUE.
type PacketMirroring_Enable int32

const (
	// A value indicating that the enum field is not set.
	PacketMirroring_UNDEFINED_ENABLE PacketMirroring_Enable = 0
	PacketMirroring_FALSE            PacketMirroring_Enable = 66658563
	PacketMirroring_TRUE             PacketMirroring_Enable = 2583950
)

// Enum value maps for PacketMirroring_Enable.
var (
	PacketMirroring_Enable_name = map[int32]string{
		0:        "UNDEFINED_ENABLE",
		66658563: "FALSE",
		2583950:  "TRUE",
	}
	PacketMirroring_Enable_value = map[string]int32{
		"UNDEFINED_ENABLE": 0,
		"FALSE":            66658563,
		"TRUE":             2583950,
	}
)

func (x PacketMirroring_Enable) Enum() *PacketMirroring_Enable {
	p := new(PacketMirroring_Enable)
	*p = x
	return p
}

func (x PacketMirroring_Enable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketMirroring_Enable) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[307].Descriptor()
}

func (PacketMirroring_Enable) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[307]
}

func (x PacketMirroring_Enable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketMirroring_Enable.Descriptor instead.
func (PacketMirroring_Enable) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1181, 0}
}

// Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
type PacketMirroringFilter_Direction int32

const (
	// A value indicating that the enum field is not set.
	PacketMirroringFilter_UNDEFINED_DIRECTION PacketMirroringFilter_Direction = 0
	// Default, both directions are mirrored.
	PacketMirroringFilter_BOTH PacketMirroringFilter_Direction = 2044801
	// Only egress traffic is mirrored.
	PacketMirroringFilter_EGRESS PacketMirroringFilter_Direction = 432880501
	// Only ingress traffic is mirrored.
	PacketMirroringFilter_INGRESS PacketMirroringFilter_Direction = 516931221
)

// Enum value maps for PacketMirroringFilter_Direction.
var (
	PacketMirroringFilter_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		2044801:   "BOTH",
		432880501: "EGRESS",
		516931221: "INGRESS",
	}
	PacketMirroringFilter_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"BOTH":                2044801,
		"EGRESS":              432880501,
		"INGRESS":             516931221,
	}
)

func (x PacketMirroringFilter_Direction) Enum() *PacketMirroringFilter_Direction {
	p := new(PacketMirroringFilter_Direction)
	*p = x
	return p
}

func (x PacketMirroringFilter_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketMirroringFilter_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[308].Descriptor()
}

func (PacketMirroringFilter_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[308]
}

func (x PacketMirroringFilter_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketMirroringFilter_Direction.Descriptor instead.
func (PacketMirroringFilter_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1183, 0}
}

// The status of applying this per-instance configuration on the corresponding managed instance.
type PerInstanceConfig_Status int32

const (
	// A value indicating that the enum field is not set.
	PerInstanceConfig_UNDEFINED_STATUS PerInstanceConfig_Status = 0
	// The per-instance configuration is being applied to the instance, but is not yet effective, possibly waiting for the instance to, for example, REFRESH.
	PerInstanceConfig_APPLYING PerInstanceConfig_Status = 352003508
	// The per-instance configuration deletion is being applied on the instance, possibly waiting for the instance to, for example, REFRESH.
	PerInstanceConfig_DELETING PerInstanceConfig_Status = 528602024
	// The per-instance configuration is effective on the instance, meaning that all disks, ips and metadata specified in this configuration are attached or set on the instance.
	PerInstanceConfig_EFFECTIVE PerInstanceConfig_Status = 244201863
	// *[Default]* The default status, when no per-instance configuration exists.
	PerInstanceConfig_NONE PerInstanceConfig_Status = 2402104
	// The per-instance configuration is set on an instance but not been applied yet.
	PerInstanceConfig_UNAPPLIED PerInstanceConfig_Status = 483935140
	// The per-instance configuration has been deleted, but the deletion is not yet applied.
	PerInstanceConfig_UNAPPLIED_DELETION PerInstanceConfig_Status = 313956873
)

// Enum value maps for PerInstanceConfig_Status.
var (
	PerInstanceConfig_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		352003508: "APPLYING",
		528602024: "DELETING",
		244201863: "EFFECTIVE",
		2402104:   "NONE",
		483935140: "UNAPPLIED",
		313956873: "UNAPPLIED_DELETION",
	}
	PerInstanceConfig_Status_value = map[string]int32{
		"UNDEFINED_STATUS":   0,
		"APPLYING":           352003508,
		"DELETING":           528602024,
		"EFFECTIVE":          244201863,
		"NONE":               2402104,
		"UNAPPLIED":          483935140,
		"UNAPPLIED_DELETION": 313956873,
	}
)

func (x PerInstanceConfig_Status) Enum() *PerInstanceConfig_Status {
	p := new(PerInstanceConfig_Status)
	*p = x
	return p
}

func (x PerInstanceConfig_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PerInstanceConfig_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[309].Descriptor()
}

func (PerInstanceConfig_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[309]
}

func (x PerInstanceConfig_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PerInstanceConfig_Status.Descriptor instead.
func (PerInstanceConfig_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1261, 0}
}

// These stateful disks will never be deleted during autohealing, update, instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole MIG is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.
type PreservedStatePreservedDisk_AutoDelete int32

const (
	// A value indicating that the enum field is not set.
	PreservedStatePreservedDisk_UNDEFINED_AUTO_DELETE          PreservedStatePreservedDisk_AutoDelete = 0
	PreservedStatePreservedDisk_NEVER                          PreservedStatePreservedDisk_AutoDelete = 74175084
	PreservedStatePreservedDisk_ON_PERMANENT_INSTANCE_DELETION PreservedStatePreservedDisk_AutoDelete = 95727719
)

// Enum value maps for PreservedStatePreservedDisk_AutoDelete.
var (
	PreservedStatePreservedDisk_AutoDelete_name = map[int32]string{
		0:        "UNDEFINED_AUTO_DELETE",
		74175084: "NEVER",
		95727719: "ON_PERMANENT_INSTANCE_DELETION",
	}
	PreservedStatePreservedDisk_AutoDelete_value = map[string]int32{
		"UNDEFINED_AUTO_DELETE":          0,
		"NEVER":                          74175084,
		"ON_PERMANENT_INSTANCE_DELETION": 95727719,
	}
)

func (x PreservedStatePreservedDisk_AutoDelete) Enum() *PreservedStatePreservedDisk_AutoDelete {
	p := new(PreservedStatePreservedDisk_AutoDelete)
	*p = x
	return p
}

func (x PreservedStatePreservedDisk_AutoDelete) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreservedStatePreservedDisk_AutoDelete) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[310].Descriptor()
}

func (PreservedStatePreservedDisk_AutoDelete) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[310]
}

func (x PreservedStatePreservedDisk_AutoDelete) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreservedStatePreservedDisk_AutoDelete.Descriptor instead.
func (PreservedStatePreservedDisk_AutoDelete) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1270, 0}
}

// The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
type PreservedStatePreservedDisk_Mode int32

const (
	// A value indicating that the enum field is not set.
	PreservedStatePreservedDisk_UNDEFINED_MODE PreservedStatePreservedDisk_Mode = 0
	// Attaches this disk in read-only mode. Multiple VM instances can use a disk in READ_ONLY mode at a time.
	PreservedStatePreservedDisk_READ_ONLY PreservedStatePreservedDisk_Mode = 91950261
	// *[Default]* Attaches this disk in READ_WRITE mode. Only one VM instance at a time can be attached to a disk in READ_WRITE mode.
	PreservedStatePreservedDisk_READ_WRITE PreservedStatePreservedDisk_Mode = 173607894
)

// Enum value maps for PreservedStatePreservedDisk_Mode.
var (
	PreservedStatePreservedDisk_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		91950261:  "READ_ONLY",
		173607894: "READ_WRITE",
	}
	PreservedStatePreservedDisk_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"READ_ONLY":      91950261,
		"READ_WRITE":     173607894,
	}
)

func (x PreservedStatePreservedDisk_Mode) Enum() *PreservedStatePreservedDisk_Mode {
	p := new(PreservedStatePreservedDisk_Mode)
	*p = x
	return p
}

func (x PreservedStatePreservedDisk_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreservedStatePreservedDisk_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[311].Descriptor()
}

func (PreservedStatePreservedDisk_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[311]
}

func (x PreservedStatePreservedDisk_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreservedStatePreservedDisk_Mode.Descriptor instead.
func (PreservedStatePreservedDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1270, 1}
}

// These stateful IPs will never be released during autohealing, update or VM instance recreate operations. This flag is used to configure if the IP reservation should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted.
type PreservedStatePreservedNetworkIp_AutoDelete int32

const (
	// A value indicating that the enum field is not set.
	PreservedStatePreservedNetworkIp_UNDEFINED_AUTO_DELETE          PreservedStatePreservedNetworkIp_AutoDelete = 0
	PreservedStatePreservedNetworkIp_NEVER                          PreservedStatePreservedNetworkIp_AutoDelete = 74175084
	PreservedStatePreservedNetworkIp_ON_PERMANENT_INSTANCE_DELETION PreservedStatePreservedNetworkIp_AutoDelete = 95727719
)

// Enum value maps for PreservedStatePreservedNetworkIp_AutoDelete.
var (
	PreservedStatePreservedNetworkIp_AutoDelete_name = map[int32]string{
		0:        "UNDEFINED_AUTO_DELETE",
		74175084: "NEVER",
		95727719: "ON_PERMANENT_INSTANCE_DELETION",
	}
	PreservedStatePreservedNetworkIp_AutoDelete_value = map[string]int32{
		"UNDEFINED_AUTO_DELETE":          0,
		"NEVER":                          74175084,
		"ON_PERMANENT_INSTANCE_DELETION": 95727719,
	}
)

func (x PreservedStatePreservedNetworkIp_AutoDelete) Enum() *PreservedStatePreservedNetworkIp_AutoDelete {
	p := new(PreservedStatePreservedNetworkIp_AutoDelete)
	*p = x
	return p
}

func (x PreservedStatePreservedNetworkIp_AutoDelete) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreservedStatePreservedNetworkIp_AutoDelete) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[312].Descriptor()
}

func (PreservedStatePreservedNetworkIp_AutoDelete) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[312]
}

func (x PreservedStatePreservedNetworkIp_AutoDelete) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreservedStatePreservedNetworkIp_AutoDelete.Descriptor instead.
func (PreservedStatePreservedNetworkIp_AutoDelete) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1271, 0}
}

// Specifies whether the feature is enabled or disabled.
type PreviewFeature_ActivationStatus int32

const (
	// A value indicating that the enum field is not set.
	PreviewFeature_UNDEFINED_ACTIVATION_STATUS  PreviewFeature_ActivationStatus = 0
	PreviewFeature_ACTIVATION_STATE_UNSPECIFIED PreviewFeature_ActivationStatus = 632160
	PreviewFeature_DISABLED                     PreviewFeature_ActivationStatus = 516696700
	PreviewFeature_ENABLED                      PreviewFeature_ActivationStatus = 182130465
)

// Enum value maps for PreviewFeature_ActivationStatus.
var (
	PreviewFeature_ActivationStatus_name = map[int32]string{
		0:         "UNDEFINED_ACTIVATION_STATUS",
		632160:    "ACTIVATION_STATE_UNSPECIFIED",
		516696700: "DISABLED",
		182130465: "ENABLED",
	}
	PreviewFeature_ActivationStatus_value = map[string]int32{
		"UNDEFINED_ACTIVATION_STATUS":  0,
		"ACTIVATION_STATE_UNSPECIFIED": 632160,
		"DISABLED":                     516696700,
		"ENABLED":                      182130465,
	}
)

func (x PreviewFeature_ActivationStatus) Enum() *PreviewFeature_ActivationStatus {
	p := new(PreviewFeature_ActivationStatus)
	*p = x
	return p
}

func (x PreviewFeature_ActivationStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreviewFeature_ActivationStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[313].Descriptor()
}

func (PreviewFeature_ActivationStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[313]
}

func (x PreviewFeature_ActivationStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreviewFeature_ActivationStatus.Descriptor instead.
func (PreviewFeature_ActivationStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1273, 0}
}

// Predefined rollout plan.
type PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan int32

const (
	// A value indicating that the enum field is not set.
	PreviewFeatureRolloutOperationRolloutInput_UNDEFINED_PREDEFINED_ROLLOUT_PLAN PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan = 0
	PreviewFeatureRolloutOperationRolloutInput_ROLLOUT_PLAN_FAST_ROLLOUT         PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan = 167808726
	PreviewFeatureRolloutOperationRolloutInput_ROLLOUT_PLAN_TWO_DAY_ROLLOUT      PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan = 349866771
	PreviewFeatureRolloutOperationRolloutInput_ROLLOUT_PLAN_UNSPECIFIED          PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan = 144511983
)

// Enum value maps for PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan.
var (
	PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan_name = map[int32]string{
		0:         "UNDEFINED_PREDEFINED_ROLLOUT_PLAN",
		167808726: "ROLLOUT_PLAN_FAST_ROLLOUT",
		349866771: "ROLLOUT_PLAN_TWO_DAY_ROLLOUT",
		144511983: "ROLLOUT_PLAN_UNSPECIFIED",
	}
	PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan_value = map[string]int32{
		"UNDEFINED_PREDEFINED_ROLLOUT_PLAN": 0,
		"ROLLOUT_PLAN_FAST_ROLLOUT":         167808726,
		"ROLLOUT_PLAN_TWO_DAY_ROLLOUT":      349866771,
		"ROLLOUT_PLAN_UNSPECIFIED":          144511983,
	}
)

func (x PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan) Enum() *PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan {
	p := new(PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan)
	*p = x
	return p
}

func (x PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[314].Descriptor()
}

func (PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[314]
}

func (x PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan.Descriptor instead.
func (PreviewFeatureRolloutOperationRolloutInput_PredefinedRolloutPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1276, 0}
}

// [Output Only] The stage of the feature.
type PreviewFeatureStatusReleaseStatus_Stage int32

const (
	// A value indicating that the enum field is not set.
	PreviewFeatureStatusReleaseStatus_UNDEFINED_STAGE   PreviewFeatureStatusReleaseStatus_Stage = 0
	PreviewFeatureStatusReleaseStatus_DEPRECATED        PreviewFeatureStatusReleaseStatus_Stage = 463360435
	PreviewFeatureStatusReleaseStatus_GA                PreviewFeatureStatusReleaseStatus_Stage = 2266
	PreviewFeatureStatusReleaseStatus_INTERNAL          PreviewFeatureStatusReleaseStatus_Stage = 279295677
	PreviewFeatureStatusReleaseStatus_PREVIEW           PreviewFeatureStatusReleaseStatus_Stage = 399798184
	PreviewFeatureStatusReleaseStatus_STAGE_UNSPECIFIED PreviewFeatureStatusReleaseStatus_Stage = 63695670
)

// Enum value maps for PreviewFeatureStatusReleaseStatus_Stage.
var (
	PreviewFeatureStatusReleaseStatus_Stage_name = map[int32]string{
		0:         "UNDEFINED_STAGE",
		463360435: "DEPRECATED",
		2266:      "GA",
		279295677: "INTERNAL",
		399798184: "PREVIEW",
		63695670:  "STAGE_UNSPECIFIED",
	}
	PreviewFeatureStatusReleaseStatus_Stage_value = map[string]int32{
		"UNDEFINED_STAGE":   0,
		"DEPRECATED":        463360435,
		"GA":                2266,
		"INTERNAL":          279295677,
		"PREVIEW":           399798184,
		"STAGE_UNSPECIFIED": 63695670,
	}
)

func (x PreviewFeatureStatusReleaseStatus_Stage) Enum() *PreviewFeatureStatusReleaseStatus_Stage {
	p := new(PreviewFeatureStatusReleaseStatus_Stage)
	*p = x
	return p
}

func (x PreviewFeatureStatusReleaseStatus_Stage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreviewFeatureStatusReleaseStatus_Stage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[315].Descriptor()
}

func (PreviewFeatureStatusReleaseStatus_Stage) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[315]
}

func (x PreviewFeatureStatusReleaseStatus_Stage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreviewFeatureStatusReleaseStatus_Stage.Descriptor instead.
func (PreviewFeatureStatusReleaseStatus_Stage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1278, 0}
}

// [Output Only] The Cloud Armor tier for this project. It can be one of the following values: CA_STANDARD, CA_ENTERPRISE_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// CA_STANDARD
type Project_CloudArmorTier int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_CLOUD_ARMOR_TIER Project_CloudArmorTier = 0
	// Enterprise tier protection billed annually.
	Project_CA_ENTERPRISE_ANNUAL Project_CloudArmorTier = 219921116
	// Enterprise tier protection billed monthly.
	Project_CA_ENTERPRISE_PAYGO Project_CloudArmorTier = 453530323
	Project_CA_STANDARD         Project_CloudArmorTier = 13156734
)

// Enum value maps for Project_CloudArmorTier.
var (
	Project_CloudArmorTier_name = map[int32]string{
		0:         "UNDEFINED_CLOUD_ARMOR_TIER",
		219921116: "CA_ENTERPRISE_ANNUAL",
		453530323: "CA_ENTERPRISE_PAYGO",
		13156734:  "CA_STANDARD",
	}
	Project_CloudArmorTier_value = map[string]int32{
		"UNDEFINED_CLOUD_ARMOR_TIER": 0,
		"CA_ENTERPRISE_ANNUAL":       219921116,
		"CA_ENTERPRISE_PAYGO":        453530323,
		"CA_STANDARD":                13156734,
	}
)

func (x Project_CloudArmorTier) Enum() *Project_CloudArmorTier {
	p := new(Project_CloudArmorTier)
	*p = x
	return p
}

func (x Project_CloudArmorTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_CloudArmorTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[316].Descriptor()
}

func (Project_CloudArmorTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[316]
}

func (x Project_CloudArmorTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_CloudArmorTier.Descriptor instead.
func (Project_CloudArmorTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1280, 0}
}

// This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
type Project_DefaultNetworkTier int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_DEFAULT_NETWORK_TIER Project_DefaultNetworkTier = 0
	// Public internet quality with fixed bandwidth.
	Project_FIXED_STANDARD Project_DefaultNetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	Project_PREMIUM Project_DefaultNetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	Project_STANDARD Project_DefaultNetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	Project_STANDARD_OVERRIDES_FIXED_STANDARD Project_DefaultNetworkTier = 465847234
)

// Enum value maps for Project_DefaultNetworkTier.
var (
	Project_DefaultNetworkTier_name = map[int32]string{
		0:         "UNDEFINED_DEFAULT_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	Project_DefaultNetworkTier_value = map[string]int32{
		"UNDEFINED_DEFAULT_NETWORK_TIER":    0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x Project_DefaultNetworkTier) Enum() *Project_DefaultNetworkTier {
	p := new(Project_DefaultNetworkTier)
	*p = x
	return p
}

func (x Project_DefaultNetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_DefaultNetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[317].Descriptor()
}

func (Project_DefaultNetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[317]
}

func (x Project_DefaultNetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_DefaultNetworkTier.Descriptor instead.
func (Project_DefaultNetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1280, 1}
}

// [Output Only] The Cloud Armor Managed Protection (CAMP) tier for this project. It can be one of the following values: CA_STANDARD, CAMP_PLUS_PAYGO. If this field is not specified, it is assumed to be CA_STANDARD.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// CA_STANDARD
type Project_ManagedProtectionTier int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_MANAGED_PROTECTION_TIER Project_ManagedProtectionTier = 0
	// Plus tier protection annual.
	Project_CAMP_PLUS_ANNUAL Project_ManagedProtectionTier = 406967142
	// Plus tier protection monthly.
	Project_CAMP_PLUS_PAYGO Project_ManagedProtectionTier = 165150985
)

// Enum value maps for Project_ManagedProtectionTier.
var (
	Project_ManagedProtectionTier_name = map[int32]string{
		0:         "UNDEFINED_MANAGED_PROTECTION_TIER",
		406967142: "CAMP_PLUS_ANNUAL",
		165150985: "CAMP_PLUS_PAYGO",
	}
	Project_ManagedProtectionTier_value = map[string]int32{
		"UNDEFINED_MANAGED_PROTECTION_TIER": 0,
		"CAMP_PLUS_ANNUAL":                  406967142,
		"CAMP_PLUS_PAYGO":                   165150985,
	}
)

func (x Project_ManagedProtectionTier) Enum() *Project_ManagedProtectionTier {
	p := new(Project_ManagedProtectionTier)
	*p = x
	return p
}

func (x Project_ManagedProtectionTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_ManagedProtectionTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[318].Descriptor()
}

func (Project_ManagedProtectionTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[318]
}

func (x Project_ManagedProtectionTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_ManagedProtectionTier.Descriptor instead.
func (Project_ManagedProtectionTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1280, 2}
}

// [Output Only] Default internal DNS setting used by VMs running in this project.
type Project_VmDnsSetting int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_VM_DNS_SETTING   Project_VmDnsSetting = 0
	Project_GLOBAL_DEFAULT             Project_VmDnsSetting = 345419141
	Project_UNSPECIFIED_VM_DNS_SETTING Project_VmDnsSetting = 35691930
	Project_ZONAL_DEFAULT              Project_VmDnsSetting = 368475782
	Project_ZONAL_ONLY                 Project_VmDnsSetting = 521198951
)

// Enum value maps for Project_VmDnsSetting.
var (
	Project_VmDnsSetting_name = map[int32]string{
		0:         "UNDEFINED_VM_DNS_SETTING",
		345419141: "GLOBAL_DEFAULT",
		35691930:  "UNSPECIFIED_VM_DNS_SETTING",
		368475782: "ZONAL_DEFAULT",
		521198951: "ZONAL_ONLY",
	}
	Project_VmDnsSetting_value = map[string]int32{
		"UNDEFINED_VM_DNS_SETTING":   0,
		"GLOBAL_DEFAULT":             345419141,
		"UNSPECIFIED_VM_DNS_SETTING": 35691930,
		"ZONAL_DEFAULT":              368475782,
		"ZONAL_ONLY":                 521198951,
	}
)

func (x Project_VmDnsSetting) Enum() *Project_VmDnsSetting {
	p := new(Project_VmDnsSetting)
	*p = x
	return p
}

func (x Project_VmDnsSetting) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_VmDnsSetting) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[319].Descriptor()
}

func (Project_VmDnsSetting) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[319]
}

func (x Project_VmDnsSetting) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_VmDnsSetting.Descriptor instead.
func (Project_VmDnsSetting) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1280, 3}
}

// [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
type Project_XpnProjectStatus int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_XPN_PROJECT_STATUS   Project_XpnProjectStatus = 0
	Project_HOST                           Project_XpnProjectStatus = 2223528
	Project_UNSPECIFIED_XPN_PROJECT_STATUS Project_XpnProjectStatus = 340393257
)

// Enum value maps for Project_XpnProjectStatus.
var (
	Project_XpnProjectStatus_name = map[int32]string{
		0:         "UNDEFINED_XPN_PROJECT_STATUS",
		2223528:   "HOST",
		340393257: "UNSPECIFIED_XPN_PROJECT_STATUS",
	}
	Project_XpnProjectStatus_value = map[string]int32{
		"UNDEFINED_XPN_PROJECT_STATUS":   0,
		"HOST":                           2223528,
		"UNSPECIFIED_XPN_PROJECT_STATUS": 340393257,
	}
)

func (x Project_XpnProjectStatus) Enum() *Project_XpnProjectStatus {
	p := new(Project_XpnProjectStatus)
	*p = x
	return p
}

func (x Project_XpnProjectStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_XpnProjectStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[320].Descriptor()
}

func (Project_XpnProjectStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[320]
}

func (x Project_XpnProjectStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_XpnProjectStatus.Descriptor instead.
func (Project_XpnProjectStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1280, 4}
}

// Managed protection tier to be set.
type ProjectsSetCloudArmorTierRequest_CloudArmorTier int32

const (
	// A value indicating that the enum field is not set.
	ProjectsSetCloudArmorTierRequest_UNDEFINED_CLOUD_ARMOR_TIER ProjectsSetCloudArmorTierRequest_CloudArmorTier = 0
	// Enterprise tier protection billed annually.
	ProjectsSetCloudArmorTierRequest_CA_ENTERPRISE_ANNUAL ProjectsSetCloudArmorTierRequest_CloudArmorTier = 219921116
	// Enterprise tier protection billed monthly.
	ProjectsSetCloudArmorTierRequest_CA_ENTERPRISE_PAYGO ProjectsSetCloudArmorTierRequest_CloudArmorTier = 453530323
	// Standard protection.
	ProjectsSetCloudArmorTierRequest_CA_STANDARD ProjectsSetCloudArmorTierRequest_CloudArmorTier = 13156734
)

// Enum value maps for ProjectsSetCloudArmorTierRequest_CloudArmorTier.
var (
	ProjectsSetCloudArmorTierRequest_CloudArmorTier_name = map[int32]string{
		0:         "UNDEFINED_CLOUD_ARMOR_TIER",
		219921116: "CA_ENTERPRISE_ANNUAL",
		453530323: "CA_ENTERPRISE_PAYGO",
		13156734:  "CA_STANDARD",
	}
	ProjectsSetCloudArmorTierRequest_CloudArmorTier_value = map[string]int32{
		"UNDEFINED_CLOUD_ARMOR_TIER": 0,
		"CA_ENTERPRISE_ANNUAL":       219921116,
		"CA_ENTERPRISE_PAYGO":        453530323,
		"CA_STANDARD":                13156734,
	}
)

func (x ProjectsSetCloudArmorTierRequest_CloudArmorTier) Enum() *ProjectsSetCloudArmorTierRequest_CloudArmorTier {
	p := new(ProjectsSetCloudArmorTierRequest_CloudArmorTier)
	*p = x
	return p
}

func (x ProjectsSetCloudArmorTierRequest_CloudArmorTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProjectsSetCloudArmorTierRequest_CloudArmorTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[321].Descriptor()
}

func (ProjectsSetCloudArmorTierRequest_CloudArmorTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[321]
}

func (x ProjectsSetCloudArmorTierRequest_CloudArmorTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProjectsSetCloudArmorTierRequest_CloudArmorTier.Descriptor instead.
func (ProjectsSetCloudArmorTierRequest_CloudArmorTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1285, 0}
}

// Default network tier to be set.
type ProjectsSetDefaultNetworkTierRequest_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	ProjectsSetDefaultNetworkTierRequest_UNDEFINED_NETWORK_TIER ProjectsSetDefaultNetworkTierRequest_NetworkTier = 0
	// Public internet quality with fixed bandwidth.
	ProjectsSetDefaultNetworkTierRequest_FIXED_STANDARD ProjectsSetDefaultNetworkTierRequest_NetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	ProjectsSetDefaultNetworkTierRequest_PREMIUM ProjectsSetDefaultNetworkTierRequest_NetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	ProjectsSetDefaultNetworkTierRequest_STANDARD ProjectsSetDefaultNetworkTierRequest_NetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	ProjectsSetDefaultNetworkTierRequest_STANDARD_OVERRIDES_FIXED_STANDARD ProjectsSetDefaultNetworkTierRequest_NetworkTier = 465847234
)

// Enum value maps for ProjectsSetDefaultNetworkTierRequest_NetworkTier.
var (
	ProjectsSetDefaultNetworkTierRequest_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	ProjectsSetDefaultNetworkTierRequest_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER":            0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x ProjectsSetDefaultNetworkTierRequest_NetworkTier) Enum() *ProjectsSetDefaultNetworkTierRequest_NetworkTier {
	p := new(ProjectsSetDefaultNetworkTierRequest_NetworkTier)
	*p = x
	return p
}

func (x ProjectsSetDefaultNetworkTierRequest_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProjectsSetDefaultNetworkTierRequest_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[322].Descriptor()
}

func (ProjectsSetDefaultNetworkTierRequest_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[322]
}

func (x ProjectsSetDefaultNetworkTierRequest_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProjectsSetDefaultNetworkTierRequest_NetworkTier.Descriptor instead.
func (ProjectsSetDefaultNetworkTierRequest_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1286, 0}
}

// Managed protection tier to be set.
type ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier int32

const (
	// A value indicating that the enum field is not set.
	ProjectsSetManagedProtectionTierRequest_UNDEFINED_MANAGED_PROTECTION_TIER ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier = 0
	// Plus tier protection annual.
	ProjectsSetManagedProtectionTierRequest_CAMP_PLUS_ANNUAL ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier = 406967142
	// Plus tier protection monthly.
	ProjectsSetManagedProtectionTierRequest_CAMP_PLUS_PAYGO ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier = 165150985
	// Standard protection.
	ProjectsSetManagedProtectionTierRequest_CA_STANDARD ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier = 13156734
)

// Enum value maps for ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier.
var (
	ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier_name = map[int32]string{
		0:         "UNDEFINED_MANAGED_PROTECTION_TIER",
		406967142: "CAMP_PLUS_ANNUAL",
		165150985: "CAMP_PLUS_PAYGO",
		13156734:  "CA_STANDARD",
	}
	ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier_value = map[string]int32{
		"UNDEFINED_MANAGED_PROTECTION_TIER": 0,
		"CAMP_PLUS_ANNUAL":                  406967142,
		"CAMP_PLUS_PAYGO":                   165150985,
		"CA_STANDARD":                       13156734,
	}
)

func (x ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier) Enum() *ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier {
	p := new(ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier)
	*p = x
	return p
}

func (x ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[323].Descriptor()
}

func (ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[323]
}

func (x ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier.Descriptor instead.
func (ProjectsSetManagedProtectionTierRequest_ManagedProtectionTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1287, 0}
}

// [Output Only] The version of BYOIP API.
type PublicAdvertisedPrefix_ByoipApiVersion int32

const (
	// A value indicating that the enum field is not set.
	PublicAdvertisedPrefix_UNDEFINED_BYOIP_API_VERSION PublicAdvertisedPrefix_ByoipApiVersion = 0
	// This public advertised prefix can be used to create both regional and global public delegated prefixes. It usually takes 4 weeks to create or delete a public delegated prefix. The BGP status cannot be changed.
	PublicAdvertisedPrefix_V1 PublicAdvertisedPrefix_ByoipApiVersion = 2715
	// This public advertised prefix can only be used to create regional public delegated prefixes. Public delegated prefix creation and deletion takes minutes and the BGP status can be modified.
	PublicAdvertisedPrefix_V2 PublicAdvertisedPrefix_ByoipApiVersion = 2716
)

// Enum value maps for PublicAdvertisedPrefix_ByoipApiVersion.
var (
	PublicAdvertisedPrefix_ByoipApiVersion_name = map[int32]string{
		0:    "UNDEFINED_BYOIP_API_VERSION",
		2715: "V1",
		2716: "V2",
	}
	PublicAdvertisedPrefix_ByoipApiVersion_value = map[string]int32{
		"UNDEFINED_BYOIP_API_VERSION": 0,
		"V1":                          2715,
		"V2":                          2716,
	}
)

func (x PublicAdvertisedPrefix_ByoipApiVersion) Enum() *PublicAdvertisedPrefix_ByoipApiVersion {
	p := new(PublicAdvertisedPrefix_ByoipApiVersion)
	*p = x
	return p
}

func (x PublicAdvertisedPrefix_ByoipApiVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicAdvertisedPrefix_ByoipApiVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[324].Descriptor()
}

func (PublicAdvertisedPrefix_ByoipApiVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[324]
}

func (x PublicAdvertisedPrefix_ByoipApiVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicAdvertisedPrefix_ByoipApiVersion.Descriptor instead.
func (PublicAdvertisedPrefix_ByoipApiVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1288, 0}
}

// Specifies how child public delegated prefix will be scoped. It could be one of following values: - `REGIONAL`: The public delegated prefix is regional only. The provisioning will take a few minutes. - `GLOBAL`: The public delegated prefix is global only. The provisioning will take ~4 weeks. - `GLOBAL_AND_REGIONAL` [output only]: The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
type PublicAdvertisedPrefix_PdpScope int32

const (
	// A value indicating that the enum field is not set.
	PublicAdvertisedPrefix_UNDEFINED_PDP_SCOPE PublicAdvertisedPrefix_PdpScope = 0
	// The public delegated prefix is global only. The provisioning will take ~4 weeks.
	PublicAdvertisedPrefix_GLOBAL PublicAdvertisedPrefix_PdpScope = 494663587
	// The public delegated prefixes is BYOIP V1 legacy prefix. This is output only value and no longer supported in BYOIP V2.
	PublicAdvertisedPrefix_GLOBAL_AND_REGIONAL PublicAdvertisedPrefix_PdpScope = 318053059
	// The public delegated prefix is regional only. The provisioning will take a few minutes.
	PublicAdvertisedPrefix_REGIONAL PublicAdvertisedPrefix_PdpScope = 92288543
)

// Enum value maps for PublicAdvertisedPrefix_PdpScope.
var (
	PublicAdvertisedPrefix_PdpScope_name = map[int32]string{
		0:         "UNDEFINED_PDP_SCOPE",
		494663587: "GLOBAL",
		318053059: "GLOBAL_AND_REGIONAL",
		92288543:  "REGIONAL",
	}
	PublicAdvertisedPrefix_PdpScope_value = map[string]int32{
		"UNDEFINED_PDP_SCOPE": 0,
		"GLOBAL":              494663587,
		"GLOBAL_AND_REGIONAL": 318053059,
		"REGIONAL":            92288543,
	}
)

func (x PublicAdvertisedPrefix_PdpScope) Enum() *PublicAdvertisedPrefix_PdpScope {
	p := new(PublicAdvertisedPrefix_PdpScope)
	*p = x
	return p
}

func (x PublicAdvertisedPrefix_PdpScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicAdvertisedPrefix_PdpScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[325].Descriptor()
}

func (PublicAdvertisedPrefix_PdpScope) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[325]
}

func (x PublicAdvertisedPrefix_PdpScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicAdvertisedPrefix_PdpScope.Descriptor instead.
func (PublicAdvertisedPrefix_PdpScope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1288, 1}
}

// The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
type PublicAdvertisedPrefix_Status int32

const (
	// A value indicating that the enum field is not set.
	PublicAdvertisedPrefix_UNDEFINED_STATUS PublicAdvertisedPrefix_Status = 0
	// The prefix is announced to Internet.
	PublicAdvertisedPrefix_ANNOUNCED_TO_INTERNET PublicAdvertisedPrefix_Status = 177880897
	// RPKI validation is complete.
	PublicAdvertisedPrefix_INITIAL PublicAdvertisedPrefix_Status = 518841124
	// The prefix is fully configured.
	PublicAdvertisedPrefix_PREFIX_CONFIGURATION_COMPLETE PublicAdvertisedPrefix_Status = 480889551
	// The prefix is being configured.
	PublicAdvertisedPrefix_PREFIX_CONFIGURATION_IN_PROGRESS PublicAdvertisedPrefix_Status = 378550961
	// The prefix is being removed.
	PublicAdvertisedPrefix_PREFIX_REMOVAL_IN_PROGRESS PublicAdvertisedPrefix_Status = 284375783
	// User has configured the PTR.
	PublicAdvertisedPrefix_PTR_CONFIGURED PublicAdvertisedPrefix_Status = 513497167
	// The prefix is currently withdrawn but ready to be announced.
	PublicAdvertisedPrefix_READY_TO_ANNOUNCE PublicAdvertisedPrefix_Status = 64641265
	// Reverse DNS lookup failed.
	PublicAdvertisedPrefix_REVERSE_DNS_LOOKUP_FAILED PublicAdvertisedPrefix_Status = 295755183
	// Reverse DNS lookup is successful.
	PublicAdvertisedPrefix_VALIDATED PublicAdvertisedPrefix_Status = 66197998
)

// Enum value maps for PublicAdvertisedPrefix_Status.
var (
	PublicAdvertisedPrefix_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		177880897: "ANNOUNCED_TO_INTERNET",
		518841124: "INITIAL",
		480889551: "PREFIX_CONFIGURATION_COMPLETE",
		378550961: "PREFIX_CONFIGURATION_IN_PROGRESS",
		284375783: "PREFIX_REMOVAL_IN_PROGRESS",
		513497167: "PTR_CONFIGURED",
		64641265:  "READY_TO_ANNOUNCE",
		295755183: "REVERSE_DNS_LOOKUP_FAILED",
		66197998:  "VALIDATED",
	}
	PublicAdvertisedPrefix_Status_value = map[string]int32{
		"UNDEFINED_STATUS":                 0,
		"ANNOUNCED_TO_INTERNET":            177880897,
		"INITIAL":                          518841124,
		"PREFIX_CONFIGURATION_COMPLETE":    480889551,
		"PREFIX_CONFIGURATION_IN_PROGRESS": 378550961,
		"PREFIX_REMOVAL_IN_PROGRESS":       284375783,
		"PTR_CONFIGURED":                   513497167,
		"READY_TO_ANNOUNCE":                64641265,
		"REVERSE_DNS_LOOKUP_FAILED":        295755183,
		"VALIDATED":                        66197998,
	}
)

func (x PublicAdvertisedPrefix_Status) Enum() *PublicAdvertisedPrefix_Status {
	p := new(PublicAdvertisedPrefix_Status)
	*p = x
	return p
}

func (x PublicAdvertisedPrefix_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicAdvertisedPrefix_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[326].Descriptor()
}

func (PublicAdvertisedPrefix_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[326]
}

func (x PublicAdvertisedPrefix_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicAdvertisedPrefix_Status.Descriptor instead.
func (PublicAdvertisedPrefix_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1288, 2}
}

// [Output Only] The version of BYOIP API.
type PublicDelegatedPrefix_ByoipApiVersion int32

const (
	// A value indicating that the enum field is not set.
	PublicDelegatedPrefix_UNDEFINED_BYOIP_API_VERSION PublicDelegatedPrefix_ByoipApiVersion = 0
	// This public delegated prefix usually takes 4 weeks to delete, and the BGP status cannot be changed. Announce and Withdraw APIs can not be used on this prefix.
	PublicDelegatedPrefix_V1 PublicDelegatedPrefix_ByoipApiVersion = 2715
	// This public delegated prefix takes minutes to delete. Announce and Withdraw APIs can be used on this prefix to change the BGP status.
	PublicDelegatedPrefix_V2 PublicDelegatedPrefix_ByoipApiVersion = 2716
)

// Enum value maps for PublicDelegatedPrefix_ByoipApiVersion.
var (
	PublicDelegatedPrefix_ByoipApiVersion_name = map[int32]string{
		0:    "UNDEFINED_BYOIP_API_VERSION",
		2715: "V1",
		2716: "V2",
	}
	PublicDelegatedPrefix_ByoipApiVersion_value = map[string]int32{
		"UNDEFINED_BYOIP_API_VERSION": 0,
		"V1":                          2715,
		"V2":                          2716,
	}
)

func (x PublicDelegatedPrefix_ByoipApiVersion) Enum() *PublicDelegatedPrefix_ByoipApiVersion {
	p := new(PublicDelegatedPrefix_ByoipApiVersion)
	*p = x
	return p
}

func (x PublicDelegatedPrefix_ByoipApiVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicDelegatedPrefix_ByoipApiVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[327].Descriptor()
}

func (PublicDelegatedPrefix_ByoipApiVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[327]
}

func (x PublicDelegatedPrefix_ByoipApiVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicDelegatedPrefix_ByoipApiVersion.Descriptor instead.
func (PublicDelegatedPrefix_ByoipApiVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1291, 0}
}

// The public delegated prefix mode for IPv6 only.
type PublicDelegatedPrefix_Mode int32

const (
	// A value indicating that the enum field is not set.
	PublicDelegatedPrefix_UNDEFINED_MODE PublicDelegatedPrefix_Mode = 0
	// The public delegated prefix is used for further sub-delegation only. Such prefixes cannot set allocatablePrefixLength.
	PublicDelegatedPrefix_DELEGATION PublicDelegatedPrefix_Mode = 264149288
	// The public delegated prefix is used for creating forwarding rules only. Such prefixes cannot set publicDelegatedSubPrefixes.
	PublicDelegatedPrefix_EXTERNAL_IPV6_FORWARDING_RULE_CREATION PublicDelegatedPrefix_Mode = 398684356
	// The public delegated prefix is used for creating dual-mode subnetworks only. Such prefixes cannot set publicDelegatedSubPrefixes.
	PublicDelegatedPrefix_EXTERNAL_IPV6_SUBNETWORK_CREATION PublicDelegatedPrefix_Mode = 61198284
)

// Enum value maps for PublicDelegatedPrefix_Mode.
var (
	PublicDelegatedPrefix_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		264149288: "DELEGATION",
		398684356: "EXTERNAL_IPV6_FORWARDING_RULE_CREATION",
		61198284:  "EXTERNAL_IPV6_SUBNETWORK_CREATION",
	}
	PublicDelegatedPrefix_Mode_value = map[string]int32{
		"UNDEFINED_MODE":                         0,
		"DELEGATION":                             264149288,
		"EXTERNAL_IPV6_FORWARDING_RULE_CREATION": 398684356,
		"EXTERNAL_IPV6_SUBNETWORK_CREATION":      61198284,
	}
)

func (x PublicDelegatedPrefix_Mode) Enum() *PublicDelegatedPrefix_Mode {
	p := new(PublicDelegatedPrefix_Mode)
	*p = x
	return p
}

func (x PublicDelegatedPrefix_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicDelegatedPrefix_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[328].Descriptor()
}

func (PublicDelegatedPrefix_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[328]
}

func (x PublicDelegatedPrefix_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicDelegatedPrefix_Mode.Descriptor instead.
func (PublicDelegatedPrefix_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1291, 1}
}

// [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is announced and ready to use. - `DELETING` The public delegated prefix is being deprovsioned.
type PublicDelegatedPrefix_Status int32

const (
	// A value indicating that the enum field is not set.
	PublicDelegatedPrefix_UNDEFINED_STATUS PublicDelegatedPrefix_Status = 0
	// The public delegated prefix is announced and ready to use.
	PublicDelegatedPrefix_ANNOUNCED PublicDelegatedPrefix_Status = 365103355
	// The prefix is announced within Google network.
	PublicDelegatedPrefix_ANNOUNCED_TO_GOOGLE PublicDelegatedPrefix_Status = 454875705
	// The prefix is announced to Internet and within Google.
	PublicDelegatedPrefix_ANNOUNCED_TO_INTERNET PublicDelegatedPrefix_Status = 177880897
	// The public delegated prefix is being deprovsioned.
	PublicDelegatedPrefix_DELETING PublicDelegatedPrefix_Status = 528602024
	// The public delegated prefix is being initialized and addresses cannot be created yet.
	PublicDelegatedPrefix_INITIALIZING PublicDelegatedPrefix_Status = 306588749
	// The public delegated prefix is currently withdrawn but ready to be announced.
	PublicDelegatedPrefix_READY_TO_ANNOUNCE PublicDelegatedPrefix_Status = 64641265
)

// Enum value maps for PublicDelegatedPrefix_Status.
var (
	PublicDelegatedPrefix_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		365103355: "ANNOUNCED",
		454875705: "ANNOUNCED_TO_GOOGLE",
		177880897: "ANNOUNCED_TO_INTERNET",
		528602024: "DELETING",
		306588749: "INITIALIZING",
		64641265:  "READY_TO_ANNOUNCE",
	}
	PublicDelegatedPrefix_Status_value = map[string]int32{
		"UNDEFINED_STATUS":      0,
		"ANNOUNCED":             365103355,
		"ANNOUNCED_TO_GOOGLE":   454875705,
		"ANNOUNCED_TO_INTERNET": 177880897,
		"DELETING":              528602024,
		"INITIALIZING":          306588749,
		"READY_TO_ANNOUNCE":     64641265,
	}
)

func (x PublicDelegatedPrefix_Status) Enum() *PublicDelegatedPrefix_Status {
	p := new(PublicDelegatedPrefix_Status)
	*p = x
	return p
}

func (x PublicDelegatedPrefix_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicDelegatedPrefix_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[329].Descriptor()
}

func (PublicDelegatedPrefix_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[329]
}

func (x PublicDelegatedPrefix_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicDelegatedPrefix_Status.Descriptor instead.
func (PublicDelegatedPrefix_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1291, 2}
}

// The PublicDelegatedSubPrefix mode for IPv6 only.
type PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode int32

const (
	// A value indicating that the enum field is not set.
	PublicDelegatedPrefixPublicDelegatedSubPrefix_UNDEFINED_MODE PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode = 0
	// The public delegated prefix is used for further sub-delegation only. Such prefixes cannot set allocatablePrefixLength.
	PublicDelegatedPrefixPublicDelegatedSubPrefix_DELEGATION PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode = 264149288
	// The public delegated prefix is used for creating forwarding rules only. Such prefixes cannot set publicDelegatedSubPrefixes.
	PublicDelegatedPrefixPublicDelegatedSubPrefix_EXTERNAL_IPV6_FORWARDING_RULE_CREATION PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode = 398684356
	// The public delegated prefix is used for creating dual-mode subnetworks only. Such prefixes cannot set publicDelegatedSubPrefixes.
	PublicDelegatedPrefixPublicDelegatedSubPrefix_EXTERNAL_IPV6_SUBNETWORK_CREATION PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode = 61198284
)

// Enum value maps for PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode.
var (
	PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		264149288: "DELEGATION",
		398684356: "EXTERNAL_IPV6_FORWARDING_RULE_CREATION",
		61198284:  "EXTERNAL_IPV6_SUBNETWORK_CREATION",
	}
	PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode_value = map[string]int32{
		"UNDEFINED_MODE":                         0,
		"DELEGATION":                             264149288,
		"EXTERNAL_IPV6_FORWARDING_RULE_CREATION": 398684356,
		"EXTERNAL_IPV6_SUBNETWORK_CREATION":      61198284,
	}
)

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode) Enum() *PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode {
	p := new(PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode)
	*p = x
	return p
}

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[330].Descriptor()
}

func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[330]
}

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode.Descriptor instead.
func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1294, 0}
}

// [Output Only] The status of the sub public delegated prefix.
type PublicDelegatedPrefixPublicDelegatedSubPrefix_Status int32

const (
	// A value indicating that the enum field is not set.
	PublicDelegatedPrefixPublicDelegatedSubPrefix_UNDEFINED_STATUS PublicDelegatedPrefixPublicDelegatedSubPrefix_Status = 0
	PublicDelegatedPrefixPublicDelegatedSubPrefix_ACTIVE           PublicDelegatedPrefixPublicDelegatedSubPrefix_Status = 314733318
	PublicDelegatedPrefixPublicDelegatedSubPrefix_INACTIVE         PublicDelegatedPrefixPublicDelegatedSubPrefix_Status = 270421099
)

// Enum value maps for PublicDelegatedPrefixPublicDelegatedSubPrefix_Status.
var (
	PublicDelegatedPrefixPublicDelegatedSubPrefix_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		270421099: "INACTIVE",
	}
	PublicDelegatedPrefixPublicDelegatedSubPrefix_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ACTIVE":           314733318,
		"INACTIVE":         270421099,
	}
)

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Enum() *PublicDelegatedPrefixPublicDelegatedSubPrefix_Status {
	p := new(PublicDelegatedPrefixPublicDelegatedSubPrefix_Status)
	*p = x
	return p
}

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[331].Descriptor()
}

func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[331]
}

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicDelegatedPrefixPublicDelegatedSubPrefix_Status.Descriptor instead.
func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1294, 1}
}

// [Output Only] Name of the quota metric.
type Quota_Metric int32

const (
	// A value indicating that the enum field is not set.
	Quota_UNDEFINED_METRIC                Quota_Metric = 0
	Quota_A2_CPUS                         Quota_Metric = 153206585
	Quota_AFFINITY_GROUPS                 Quota_Metric = 108303563
	Quota_AUTOSCALERS                     Quota_Metric = 471248988
	Quota_BACKEND_BUCKETS                 Quota_Metric = 137626846
	Quota_BACKEND_SERVICES                Quota_Metric = 269623753
	Quota_C2D_CPUS                        Quota_Metric = 508182517
	Quota_C2_CPUS                         Quota_Metric = 317601211
	Quota_C3_CPUS                         Quota_Metric = 346230362
	Quota_COMMITMENTS                     Quota_Metric = 456141790
	Quota_COMMITTED_A2_CPUS               Quota_Metric = 59330902
	Quota_COMMITTED_C2D_CPUS              Quota_Metric = 282390904
	Quota_COMMITTED_C2_CPUS               Quota_Metric = 223725528
	Quota_COMMITTED_C3_CPUS               Quota_Metric = 252354679
	Quota_COMMITTED_CPUS                  Quota_Metric = 292394702
	Quota_COMMITTED_E2_CPUS               Quota_Metric = 388120154
	Quota_COMMITTED_LICENSES              Quota_Metric = 357606869
	Quota_COMMITTED_LOCAL_SSD_TOTAL_GB    Quota_Metric = 308393480
	Quota_COMMITTED_M3_CPUS               Quota_Metric = 585985
	Quota_COMMITTED_MEMORY_OPTIMIZED_CPUS Quota_Metric = 489057886
	Quota_COMMITTED_N2A_CPUS              Quota_Metric = 40064304
	Quota_COMMITTED_N2D_CPUS              Quota_Metric = 125951757
	Quota_COMMITTED_N2_CPUS               Quota_Metric = 322589603
	Quota_COMMITTED_NVIDIA_A100_80GB_GPUS Quota_Metric = 464326565
	Quota_COMMITTED_NVIDIA_A100_GPUS      Quota_Metric = 375799445
	Quota_COMMITTED_NVIDIA_H100_GPUS      Quota_Metric = 71649180
	Quota_COMMITTED_NVIDIA_K80_GPUS       Quota_Metric = 3857188
	Quota_COMMITTED_NVIDIA_L4_GPUS        Quota_Metric = 19163645
	Quota_COMMITTED_NVIDIA_P100_GPUS      Quota_Metric = 107528100
	Quota_COMMITTED_NVIDIA_P4_GPUS        Quota_Metric = 347952897
	Quota_COMMITTED_NVIDIA_T4_GPUS        Quota_Metric = 139871237
	Quota_COMMITTED_NVIDIA_V100_GPUS      Quota_Metric = 219562
	Quota_COMMITTED_T2A_CPUS              Quota_Metric = 296378986
	Quota_COMMITTED_T2D_CPUS              Quota_Metric = 382266439
	Quota_COMMITTED_Z3_CPUS               Quota_Metric = 263844686
	// Guest CPUs
	Quota_CPUS                                                   Quota_Metric = 2075595
	Quota_CPUS_ALL_REGIONS                                       Quota_Metric = 470911149
	Quota_DISKS_TOTAL_GB                                         Quota_Metric = 353520543
	Quota_E2_CPUS                                                Quota_Metric = 481995837
	Quota_EXTERNAL_MANAGED_FORWARDING_RULES                      Quota_Metric = 150790089
	Quota_EXTERNAL_NETWORK_LB_FORWARDING_RULES                   Quota_Metric = 374298265
	Quota_EXTERNAL_PROTOCOL_FORWARDING_RULES                     Quota_Metric = 63478888
	Quota_EXTERNAL_VPN_GATEWAYS                                  Quota_Metric = 272457134
	Quota_FIREWALLS                                              Quota_Metric = 374485843
	Quota_FORWARDING_RULES                                       Quota_Metric = 432668949
	Quota_GLOBAL_EXTERNAL_MANAGED_BACKEND_SERVICES               Quota_Metric = 164566753
	Quota_GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES               Quota_Metric = 327611949
	Quota_GLOBAL_EXTERNAL_PROXY_LB_BACKEND_SERVICES              Quota_Metric = 400256169
	Quota_GLOBAL_INTERNAL_ADDRESSES                              Quota_Metric = 42738332
	Quota_GLOBAL_INTERNAL_MANAGED_BACKEND_SERVICES               Quota_Metric = 256608303
	Quota_GLOBAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES      Quota_Metric = 323514196
	Quota_GPUS_ALL_REGIONS                                       Quota_Metric = 39387177
	Quota_HDB_TOTAL_GB                                           Quota_Metric = 319316271
	Quota_HDB_TOTAL_IOPS                                         Quota_Metric = 309720317
	Quota_HDB_TOTAL_THROUGHPUT                                   Quota_Metric = 20981374
	Quota_HEALTH_CHECKS                                          Quota_Metric = 289347502
	Quota_IMAGES                                                 Quota_Metric = 15562360
	Quota_INSTANCES                                              Quota_Metric = 131337822
	Quota_INSTANCE_GROUPS                                        Quota_Metric = 355919038
	Quota_INSTANCE_GROUP_MANAGERS                                Quota_Metric = 101798192
	Quota_INSTANCE_TEMPLATES                                     Quota_Metric = 226188271
	Quota_INTERCONNECTS                                          Quota_Metric = 415204741
	Quota_INTERCONNECT_ATTACHMENTS_PER_REGION                    Quota_Metric = 159968086
	Quota_INTERCONNECT_ATTACHMENTS_TOTAL_MBPS                    Quota_Metric = 425090419
	Quota_INTERCONNECT_TOTAL_GBPS                                Quota_Metric = 285341866
	Quota_INTERNAL_ADDRESSES                                     Quota_Metric = 197899392
	Quota_INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES             Quota_Metric = 266433668
	Quota_IN_PLACE_SNAPSHOTS                                     Quota_Metric = 151359133
	Quota_IN_USE_ADDRESSES                                       Quota_Metric = 402125072
	Quota_IN_USE_BACKUP_SCHEDULES                                Quota_Metric = 32786705
	Quota_IN_USE_SNAPSHOT_SCHEDULES                              Quota_Metric = 462104083
	Quota_LOCAL_SSD_TOTAL_GB                                     Quota_Metric = 330878021
	Quota_M1_CPUS                                                Quota_Metric = 37203366
	Quota_M2_CPUS                                                Quota_Metric = 65832517
	Quota_M3_CPUS                                                Quota_Metric = 94461668
	Quota_MACHINE_IMAGES                                         Quota_Metric = 446986640
	Quota_N2A_CPUS                                               Quota_Metric = 265855917
	Quota_N2D_CPUS                                               Quota_Metric = 351743370
	Quota_N2_CPUS                                                Quota_Metric = 416465286
	Quota_NETWORKS                                               Quota_Metric = 485481477
	Quota_NETWORK_ATTACHMENTS                                    Quota_Metric = 149028575
	Quota_NETWORK_ENDPOINT_GROUPS                                Quota_Metric = 102144909
	Quota_NETWORK_FIREWALL_POLICIES                              Quota_Metric = 101117374
	Quota_NET_LB_SECURITY_POLICIES_PER_REGION                    Quota_Metric = 157892269
	Quota_NET_LB_SECURITY_POLICY_RULES_PER_REGION                Quota_Metric = 356090931
	Quota_NET_LB_SECURITY_POLICY_RULE_ATTRIBUTES_PER_REGION      Quota_Metric = 311243888
	Quota_NODE_GROUPS                                            Quota_Metric = 24624817
	Quota_NODE_TEMPLATES                                         Quota_Metric = 474896668
	Quota_NVIDIA_A100_80GB_GPUS                                  Quota_Metric = 286389320
	Quota_NVIDIA_A100_GPUS                                       Quota_Metric = 504872978
	Quota_NVIDIA_K80_GPUS                                        Quota_Metric = 163886599
	Quota_NVIDIA_L4_GPUS                                         Quota_Metric = 491923130
	Quota_NVIDIA_P100_GPUS                                       Quota_Metric = 236601633
	Quota_NVIDIA_P100_VWS_GPUS                                   Quota_Metric = 213970574
	Quota_NVIDIA_P4_GPUS                                         Quota_Metric = 283841470
	Quota_NVIDIA_P4_VWS_GPUS                                     Quota_Metric = 528296619
	Quota_NVIDIA_T4_GPUS                                         Quota_Metric = 75759810
	Quota_NVIDIA_T4_VWS_GPUS                                     Quota_Metric = 319813039
	Quota_NVIDIA_V100_GPUS                                       Quota_Metric = 129293095
	Quota_PACKET_MIRRORINGS                                      Quota_Metric = 15578407
	Quota_PD_EXTREME_TOTAL_PROVISIONED_IOPS                      Quota_Metric = 69593965
	Quota_PREEMPTIBLE_CPUS                                       Quota_Metric = 251184841
	Quota_PREEMPTIBLE_LOCAL_SSD_GB                               Quota_Metric = 260819336
	Quota_PREEMPTIBLE_NVIDIA_A100_80GB_GPUS                      Quota_Metric = 151942410
	Quota_PREEMPTIBLE_NVIDIA_A100_GPUS                           Quota_Metric = 68832784
	Quota_PREEMPTIBLE_NVIDIA_H100_GPUS                           Quota_Metric = 301553431
	Quota_PREEMPTIBLE_NVIDIA_K80_GPUS                            Quota_Metric = 374960201
	Quota_PREEMPTIBLE_NVIDIA_L4_GPUS                             Quota_Metric = 100408376
	Quota_PREEMPTIBLE_NVIDIA_P100_GPUS                           Quota_Metric = 337432351
	Quota_PREEMPTIBLE_NVIDIA_P100_VWS_GPUS                       Quota_Metric = 313544076
	Quota_PREEMPTIBLE_NVIDIA_P4_GPUS                             Quota_Metric = 429197628
	Quota_PREEMPTIBLE_NVIDIA_P4_VWS_GPUS                         Quota_Metric = 252981545
	Quota_PREEMPTIBLE_NVIDIA_T4_GPUS                             Quota_Metric = 221115968
	Quota_PREEMPTIBLE_NVIDIA_T4_VWS_GPUS                         Quota_Metric = 44497965
	Quota_PREEMPTIBLE_NVIDIA_V100_GPUS                           Quota_Metric = 230123813
	Quota_PREEMPTIBLE_TPU_LITE_DEVICE_V5                         Quota_Metric = 174262523
	Quota_PREEMPTIBLE_TPU_LITE_PODSLICE_V5                       Quota_Metric = 112281796
	Quota_PREEMPTIBLE_TPU_PODSLICE_V4                            Quota_Metric = 425541132
	Quota_PRIVATE_V6_ACCESS_SUBNETWORKS                          Quota_Metric = 47021549
	Quota_PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK Quota_Metric = 231164291
	Quota_PSC_INTERNAL_LB_FORWARDING_RULES                       Quota_Metric = 169005435
	Quota_PUBLIC_ADVERTISED_PREFIXES                             Quota_Metric = 471371980
	Quota_PUBLIC_DELEGATED_PREFIXES                              Quota_Metric = 532465974
	Quota_REGIONAL_AUTOSCALERS                                   Quota_Metric = 29363772
	Quota_REGIONAL_EXTERNAL_MANAGED_BACKEND_SERVICES             Quota_Metric = 4240989
	Quota_REGIONAL_EXTERNAL_NETWORK_LB_BACKEND_SERVICES          Quota_Metric = 409564525
	Quota_REGIONAL_INSTANCE_GROUP_MANAGERS                       Quota_Metric = 37543696
	Quota_REGIONAL_INTERNAL_LB_BACKEND_SERVICES                  Quota_Metric = 137983760
	Quota_REGIONAL_INTERNAL_MANAGED_BACKEND_SERVICES             Quota_Metric = 96282539
	Quota_REGIONAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES    Quota_Metric = 483162968
	Quota_RESERVATIONS                                           Quota_Metric = 32644647
	Quota_RESOURCE_POLICIES                                      Quota_Metric = 83955297
	Quota_ROUTERS                                                Quota_Metric = 493018666
	Quota_ROUTES                                                 Quota_Metric = 275680074
	Quota_SECURITY_POLICIES                                      Quota_Metric = 189518703
	Quota_SECURITY_POLICIES_PER_REGION                           Quota_Metric = 249041734
	Quota_SECURITY_POLICY_ADVANCED_RULES_PER_REGION              Quota_Metric = 371815341
	Quota_SECURITY_POLICY_CEVAL_RULES                            Quota_Metric = 470815689
	Quota_SECURITY_POLICY_RULES                                  Quota_Metric = 203549225
	Quota_SECURITY_POLICY_RULES_PER_REGION                       Quota_Metric = 126510156
	Quota_SERVICE_ATTACHMENTS                                    Quota_Metric = 471521510
	// The total number of snapshots allowed for a single project.
	Quota_SNAPSHOTS                               Quota_Metric = 343405327
	Quota_SSD_TOTAL_GB                            Quota_Metric = 161732561
	Quota_SSL_CERTIFICATES                        Quota_Metric = 378372399
	Quota_SSL_POLICIES                            Quota_Metric = 523254339
	Quota_STATIC_ADDRESSES                        Quota_Metric = 93624049
	Quota_STATIC_BYOIP_ADDRESSES                  Quota_Metric = 275809649
	Quota_STATIC_EXTERNAL_IPV6_ADDRESS_RANGES     Quota_Metric = 472346774
	Quota_SUBNETWORKS                             Quota_Metric = 421330469
	Quota_T2A_CPUS                                Quota_Metric = 522170599
	Quota_T2D_CPUS                                Quota_Metric = 71187140
	Quota_TARGET_HTTPS_PROXIES                    Quota_Metric = 219522506
	Quota_TARGET_HTTP_PROXIES                     Quota_Metric = 164117155
	Quota_TARGET_INSTANCES                        Quota_Metric = 284519728
	Quota_TARGET_POOLS                            Quota_Metric = 348261257
	Quota_TARGET_SSL_PROXIES                      Quota_Metric = 159216235
	Quota_TARGET_TCP_PROXIES                      Quota_Metric = 182243136
	Quota_TARGET_VPN_GATEWAYS                     Quota_Metric = 75029928
	Quota_TPU_LITE_DEVICE_V5                      Quota_Metric = 449577597
	Quota_TPU_LITE_PODSLICE_V5                    Quota_Metric = 12708294
	Quota_TPU_PODSLICE_V4                         Quota_Metric = 214467530
	Quota_URL_MAPS                                Quota_Metric = 378660743
	Quota_VARIABLE_IPV6_PUBLIC_DELEGATED_PREFIXES Quota_Metric = 128400161
	Quota_VPN_GATEWAYS                            Quota_Metric = 35620282
	Quota_VPN_TUNNELS                             Quota_Metric = 104327296
	Quota_XPN_SERVICE_PROJECTS                    Quota_Metric = 95191981
)

// Enum value maps for Quota_Metric.
var (
	Quota_Metric_name = map[int32]string{
		0:         "UNDEFINED_METRIC",
		153206585: "A2_CPUS",
		108303563: "AFFINITY_GROUPS",
		471248988: "AUTOSCALERS",
		137626846: "BACKEND_BUCKETS",
		269623753: "BACKEND_SERVICES",
		508182517: "C2D_CPUS",
		317601211: "C2_CPUS",
		346230362: "C3_CPUS",
		456141790: "COMMITMENTS",
		59330902:  "COMMITTED_A2_CPUS",
		282390904: "COMMITTED_C2D_CPUS",
		223725528: "COMMITTED_C2_CPUS",
		252354679: "COMMITTED_C3_CPUS",
		292394702: "COMMITTED_CPUS",
		388120154: "COMMITTED_E2_CPUS",
		357606869: "COMMITTED_LICENSES",
		308393480: "COMMITTED_LOCAL_SSD_TOTAL_GB",
		585985:    "COMMITTED_M3_CPUS",
		489057886: "COMMITTED_MEMORY_OPTIMIZED_CPUS",
		40064304:  "COMMITTED_N2A_CPUS",
		125951757: "COMMITTED_N2D_CPUS",
		322589603: "COMMITTED_N2_CPUS",
		464326565: "COMMITTED_NVIDIA_A100_80GB_GPUS",
		375799445: "COMMITTED_NVIDIA_A100_GPUS",
		71649180:  "COMMITTED_NVIDIA_H100_GPUS",
		3857188:   "COMMITTED_NVIDIA_K80_GPUS",
		19163645:  "COMMITTED_NVIDIA_L4_GPUS",
		107528100: "COMMITTED_NVIDIA_P100_GPUS",
		347952897: "COMMITTED_NVIDIA_P4_GPUS",
		139871237: "COMMITTED_NVIDIA_T4_GPUS",
		219562:    "COMMITTED_NVIDIA_V100_GPUS",
		296378986: "COMMITTED_T2A_CPUS",
		382266439: "COMMITTED_T2D_CPUS",
		263844686: "COMMITTED_Z3_CPUS",
		2075595:   "CPUS",
		470911149: "CPUS_ALL_REGIONS",
		353520543: "DISKS_TOTAL_GB",
		481995837: "E2_CPUS",
		150790089: "EXTERNAL_MANAGED_FORWARDING_RULES",
		374298265: "EXTERNAL_NETWORK_LB_FORWARDING_RULES",
		63478888:  "EXTERNAL_PROTOCOL_FORWARDING_RULES",
		272457134: "EXTERNAL_VPN_GATEWAYS",
		374485843: "FIREWALLS",
		432668949: "FORWARDING_RULES",
		164566753: "GLOBAL_EXTERNAL_MANAGED_BACKEND_SERVICES",
		327611949: "GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES",
		400256169: "GLOBAL_EXTERNAL_PROXY_LB_BACKEND_SERVICES",
		42738332:  "GLOBAL_INTERNAL_ADDRESSES",
		256608303: "GLOBAL_INTERNAL_MANAGED_BACKEND_SERVICES",
		323514196: "GLOBAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES",
		39387177:  "GPUS_ALL_REGIONS",
		319316271: "HDB_TOTAL_GB",
		309720317: "HDB_TOTAL_IOPS",
		20981374:  "HDB_TOTAL_THROUGHPUT",
		289347502: "HEALTH_CHECKS",
		15562360:  "IMAGES",
		131337822: "INSTANCES",
		355919038: "INSTANCE_GROUPS",
		101798192: "INSTANCE_GROUP_MANAGERS",
		226188271: "INSTANCE_TEMPLATES",
		415204741: "INTERCONNECTS",
		159968086: "INTERCONNECT_ATTACHMENTS_PER_REGION",
		425090419: "INTERCONNECT_ATTACHMENTS_TOTAL_MBPS",
		285341866: "INTERCONNECT_TOTAL_GBPS",
		197899392: "INTERNAL_ADDRESSES",
		266433668: "INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES",
		151359133: "IN_PLACE_SNAPSHOTS",
		402125072: "IN_USE_ADDRESSES",
		32786705:  "IN_USE_BACKUP_SCHEDULES",
		462104083: "IN_USE_SNAPSHOT_SCHEDULES",
		330878021: "LOCAL_SSD_TOTAL_GB",
		37203366:  "M1_CPUS",
		65832517:  "M2_CPUS",
		94461668:  "M3_CPUS",
		446986640: "MACHINE_IMAGES",
		265855917: "N2A_CPUS",
		351743370: "N2D_CPUS",
		416465286: "N2_CPUS",
		485481477: "NETWORKS",
		149028575: "NETWORK_ATTACHMENTS",
		102144909: "NETWORK_ENDPOINT_GROUPS",
		101117374: "NETWORK_FIREWALL_POLICIES",
		157892269: "NET_LB_SECURITY_POLICIES_PER_REGION",
		356090931: "NET_LB_SECURITY_POLICY_RULES_PER_REGION",
		311243888: "NET_LB_SECURITY_POLICY_RULE_ATTRIBUTES_PER_REGION",
		24624817:  "NODE_GROUPS",
		474896668: "NODE_TEMPLATES",
		286389320: "NVIDIA_A100_80GB_GPUS",
		504872978: "NVIDIA_A100_GPUS",
		163886599: "NVIDIA_K80_GPUS",
		491923130: "NVIDIA_L4_GPUS",
		236601633: "NVIDIA_P100_GPUS",
		213970574: "NVIDIA_P100_VWS_GPUS",
		283841470: "NVIDIA_P4_GPUS",
		528296619: "NVIDIA_P4_VWS_GPUS",
		75759810:  "NVIDIA_T4_GPUS",
		319813039: "NVIDIA_T4_VWS_GPUS",
		129293095: "NVIDIA_V100_GPUS",
		15578407:  "PACKET_MIRRORINGS",
		69593965:  "PD_EXTREME_TOTAL_PROVISIONED_IOPS",
		251184841: "PREEMPTIBLE_CPUS",
		260819336: "PREEMPTIBLE_LOCAL_SSD_GB",
		151942410: "PREEMPTIBLE_NVIDIA_A100_80GB_GPUS",
		68832784:  "PREEMPTIBLE_NVIDIA_A100_GPUS",
		301553431: "PREEMPTIBLE_NVIDIA_H100_GPUS",
		374960201: "PREEMPTIBLE_NVIDIA_K80_GPUS",
		100408376: "PREEMPTIBLE_NVIDIA_L4_GPUS",
		337432351: "PREEMPTIBLE_NVIDIA_P100_GPUS",
		313544076: "PREEMPTIBLE_NVIDIA_P100_VWS_GPUS",
		429197628: "PREEMPTIBLE_NVIDIA_P4_GPUS",
		252981545: "PREEMPTIBLE_NVIDIA_P4_VWS_GPUS",
		221115968: "PREEMPTIBLE_NVIDIA_T4_GPUS",
		44497965:  "PREEMPTIBLE_NVIDIA_T4_VWS_GPUS",
		230123813: "PREEMPTIBLE_NVIDIA_V100_GPUS",
		174262523: "PREEMPTIBLE_TPU_LITE_DEVICE_V5",
		112281796: "PREEMPTIBLE_TPU_LITE_PODSLICE_V5",
		425541132: "PREEMPTIBLE_TPU_PODSLICE_V4",
		47021549:  "PRIVATE_V6_ACCESS_SUBNETWORKS",
		231164291: "PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK",
		169005435: "PSC_INTERNAL_LB_FORWARDING_RULES",
		471371980: "PUBLIC_ADVERTISED_PREFIXES",
		532465974: "PUBLIC_DELEGATED_PREFIXES",
		29363772:  "REGIONAL_AUTOSCALERS",
		4240989:   "REGIONAL_EXTERNAL_MANAGED_BACKEND_SERVICES",
		409564525: "REGIONAL_EXTERNAL_NETWORK_LB_BACKEND_SERVICES",
		37543696:  "REGIONAL_INSTANCE_GROUP_MANAGERS",
		137983760: "REGIONAL_INTERNAL_LB_BACKEND_SERVICES",
		96282539:  "REGIONAL_INTERNAL_MANAGED_BACKEND_SERVICES",
		483162968: "REGIONAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES",
		32644647:  "RESERVATIONS",
		83955297:  "RESOURCE_POLICIES",
		493018666: "ROUTERS",
		275680074: "ROUTES",
		189518703: "SECURITY_POLICIES",
		249041734: "SECURITY_POLICIES_PER_REGION",
		371815341: "SECURITY_POLICY_ADVANCED_RULES_PER_REGION",
		470815689: "SECURITY_POLICY_CEVAL_RULES",
		203549225: "SECURITY_POLICY_RULES",
		126510156: "SECURITY_POLICY_RULES_PER_REGION",
		471521510: "SERVICE_ATTACHMENTS",
		343405327: "SNAPSHOTS",
		161732561: "SSD_TOTAL_GB",
		378372399: "SSL_CERTIFICATES",
		523254339: "SSL_POLICIES",
		93624049:  "STATIC_ADDRESSES",
		275809649: "STATIC_BYOIP_ADDRESSES",
		472346774: "STATIC_EXTERNAL_IPV6_ADDRESS_RANGES",
		421330469: "SUBNETWORKS",
		522170599: "T2A_CPUS",
		71187140:  "T2D_CPUS",
		219522506: "TARGET_HTTPS_PROXIES",
		164117155: "TARGET_HTTP_PROXIES",
		284519728: "TARGET_INSTANCES",
		348261257: "TARGET_POOLS",
		159216235: "TARGET_SSL_PROXIES",
		182243136: "TARGET_TCP_PROXIES",
		75029928:  "TARGET_VPN_GATEWAYS",
		449577597: "TPU_LITE_DEVICE_V5",
		12708294:  "TPU_LITE_PODSLICE_V5",
		214467530: "TPU_PODSLICE_V4",
		378660743: "URL_MAPS",
		128400161: "VARIABLE_IPV6_PUBLIC_DELEGATED_PREFIXES",
		35620282:  "VPN_GATEWAYS",
		104327296: "VPN_TUNNELS",
		95191981:  "XPN_SERVICE_PROJECTS",
	}
	Quota_Metric_value = map[string]int32{
		"UNDEFINED_METRIC":                          0,
		"A2_CPUS":                                   153206585,
		"AFFINITY_GROUPS":                           108303563,
		"AUTOSCALERS":                               471248988,
		"BACKEND_BUCKETS":                           137626846,
		"BACKEND_SERVICES":                          269623753,
		"C2D_CPUS":                                  508182517,
		"C2_CPUS":                                   317601211,
		"C3_CPUS":                                   346230362,
		"COMMITMENTS":                               456141790,
		"COMMITTED_A2_CPUS":                         59330902,
		"COMMITTED_C2D_CPUS":                        282390904,
		"COMMITTED_C2_CPUS":                         223725528,
		"COMMITTED_C3_CPUS":                         252354679,
		"COMMITTED_CPUS":                            292394702,
		"COMMITTED_E2_CPUS":                         388120154,
		"COMMITTED_LICENSES":                        357606869,
		"COMMITTED_LOCAL_SSD_TOTAL_GB":              308393480,
		"COMMITTED_M3_CPUS":                         585985,
		"COMMITTED_MEMORY_OPTIMIZED_CPUS":           489057886,
		"COMMITTED_N2A_CPUS":                        40064304,
		"COMMITTED_N2D_CPUS":                        125951757,
		"COMMITTED_N2_CPUS":                         322589603,
		"COMMITTED_NVIDIA_A100_80GB_GPUS":           464326565,
		"COMMITTED_NVIDIA_A100_GPUS":                375799445,
		"COMMITTED_NVIDIA_H100_GPUS":                71649180,
		"COMMITTED_NVIDIA_K80_GPUS":                 3857188,
		"COMMITTED_NVIDIA_L4_GPUS":                  19163645,
		"COMMITTED_NVIDIA_P100_GPUS":                107528100,
		"COMMITTED_NVIDIA_P4_GPUS":                  347952897,
		"COMMITTED_NVIDIA_T4_GPUS":                  139871237,
		"COMMITTED_NVIDIA_V100_GPUS":                219562,
		"COMMITTED_T2A_CPUS":                        296378986,
		"COMMITTED_T2D_CPUS":                        382266439,
		"COMMITTED_Z3_CPUS":                         263844686,
		"CPUS":                                      2075595,
		"CPUS_ALL_REGIONS":                          470911149,
		"DISKS_TOTAL_GB":                            353520543,
		"E2_CPUS":                                   481995837,
		"EXTERNAL_MANAGED_FORWARDING_RULES":         150790089,
		"EXTERNAL_NETWORK_LB_FORWARDING_RULES":      374298265,
		"EXTERNAL_PROTOCOL_FORWARDING_RULES":        63478888,
		"EXTERNAL_VPN_GATEWAYS":                     272457134,
		"FIREWALLS":                                 374485843,
		"FORWARDING_RULES":                          432668949,
		"GLOBAL_EXTERNAL_MANAGED_BACKEND_SERVICES":  164566753,
		"GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES":  327611949,
		"GLOBAL_EXTERNAL_PROXY_LB_BACKEND_SERVICES": 400256169,
		"GLOBAL_INTERNAL_ADDRESSES":                 42738332,
		"GLOBAL_INTERNAL_MANAGED_BACKEND_SERVICES":  256608303,
		"GLOBAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES": 323514196,
		"GPUS_ALL_REGIONS":                           39387177,
		"HDB_TOTAL_GB":                               319316271,
		"HDB_TOTAL_IOPS":                             309720317,
		"HDB_TOTAL_THROUGHPUT":                       20981374,
		"HEALTH_CHECKS":                              289347502,
		"IMAGES":                                     15562360,
		"INSTANCES":                                  131337822,
		"INSTANCE_GROUPS":                            355919038,
		"INSTANCE_GROUP_MANAGERS":                    101798192,
		"INSTANCE_TEMPLATES":                         226188271,
		"INTERCONNECTS":                              415204741,
		"INTERCONNECT_ATTACHMENTS_PER_REGION":        159968086,
		"INTERCONNECT_ATTACHMENTS_TOTAL_MBPS":        425090419,
		"INTERCONNECT_TOTAL_GBPS":                    285341866,
		"INTERNAL_ADDRESSES":                         197899392,
		"INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES": 266433668,
		"IN_PLACE_SNAPSHOTS":                         151359133,
		"IN_USE_ADDRESSES":                           402125072,
		"IN_USE_BACKUP_SCHEDULES":                    32786705,
		"IN_USE_SNAPSHOT_SCHEDULES":                  462104083,
		"LOCAL_SSD_TOTAL_GB":                         330878021,
		"M1_CPUS":                                    37203366,
		"M2_CPUS":                                    65832517,
		"M3_CPUS":                                    94461668,
		"MACHINE_IMAGES":                             446986640,
		"N2A_CPUS":                                   265855917,
		"N2D_CPUS":                                   351743370,
		"N2_CPUS":                                    416465286,
		"NETWORKS":                                   485481477,
		"NETWORK_ATTACHMENTS":                        149028575,
		"NETWORK_ENDPOINT_GROUPS":                    102144909,
		"NETWORK_FIREWALL_POLICIES":                  101117374,
		"NET_LB_SECURITY_POLICIES_PER_REGION":        157892269,
		"NET_LB_SECURITY_POLICY_RULES_PER_REGION":    356090931,
		"NET_LB_SECURITY_POLICY_RULE_ATTRIBUTES_PER_REGION": 311243888,
		"NODE_GROUPS":                                            24624817,
		"NODE_TEMPLATES":                                         474896668,
		"NVIDIA_A100_80GB_GPUS":                                  286389320,
		"NVIDIA_A100_GPUS":                                       504872978,
		"NVIDIA_K80_GPUS":                                        163886599,
		"NVIDIA_L4_GPUS":                                         491923130,
		"NVIDIA_P100_GPUS":                                       236601633,
		"NVIDIA_P100_VWS_GPUS":                                   213970574,
		"NVIDIA_P4_GPUS":                                         283841470,
		"NVIDIA_P4_VWS_GPUS":                                     528296619,
		"NVIDIA_T4_GPUS":                                         75759810,
		"NVIDIA_T4_VWS_GPUS":                                     319813039,
		"NVIDIA_V100_GPUS":                                       129293095,
		"PACKET_MIRRORINGS":                                      15578407,
		"PD_EXTREME_TOTAL_PROVISIONED_IOPS":                      69593965,
		"PREEMPTIBLE_CPUS":                                       251184841,
		"PREEMPTIBLE_LOCAL_SSD_GB":                               260819336,
		"PREEMPTIBLE_NVIDIA_A100_80GB_GPUS":                      151942410,
		"PREEMPTIBLE_NVIDIA_A100_GPUS":                           68832784,
		"PREEMPTIBLE_NVIDIA_H100_GPUS":                           301553431,
		"PREEMPTIBLE_NVIDIA_K80_GPUS":                            374960201,
		"PREEMPTIBLE_NVIDIA_L4_GPUS":                             100408376,
		"PREEMPTIBLE_NVIDIA_P100_GPUS":                           337432351,
		"PREEMPTIBLE_NVIDIA_P100_VWS_GPUS":                       313544076,
		"PREEMPTIBLE_NVIDIA_P4_GPUS":                             429197628,
		"PREEMPTIBLE_NVIDIA_P4_VWS_GPUS":                         252981545,
		"PREEMPTIBLE_NVIDIA_T4_GPUS":                             221115968,
		"PREEMPTIBLE_NVIDIA_T4_VWS_GPUS":                         44497965,
		"PREEMPTIBLE_NVIDIA_V100_GPUS":                           230123813,
		"PREEMPTIBLE_TPU_LITE_DEVICE_V5":                         174262523,
		"PREEMPTIBLE_TPU_LITE_PODSLICE_V5":                       112281796,
		"PREEMPTIBLE_TPU_PODSLICE_V4":                            425541132,
		"PRIVATE_V6_ACCESS_SUBNETWORKS":                          47021549,
		"PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK": 231164291,
		"PSC_INTERNAL_LB_FORWARDING_RULES":                       169005435,
		"PUBLIC_ADVERTISED_PREFIXES":                             471371980,
		"PUBLIC_DELEGATED_PREFIXES":                              532465974,
		"REGIONAL_AUTOSCALERS":                                   29363772,
		"REGIONAL_EXTERNAL_MANAGED_BACKEND_SERVICES":             4240989,
		"REGIONAL_EXTERNAL_NETWORK_LB_BACKEND_SERVICES":          409564525,
		"REGIONAL_INSTANCE_GROUP_MANAGERS":                       37543696,
		"REGIONAL_INTERNAL_LB_BACKEND_SERVICES":                  137983760,
		"REGIONAL_INTERNAL_MANAGED_BACKEND_SERVICES":             96282539,
		"REGIONAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES":    483162968,
		"RESERVATIONS":                                           32644647,
		"RESOURCE_POLICIES":                                      83955297,
		"ROUTERS":                                                493018666,
		"ROUTES":                                                 275680074,
		"SECURITY_POLICIES":                                      189518703,
		"SECURITY_POLICIES_PER_REGION":                           249041734,
		"SECURITY_POLICY_ADVANCED_RULES_PER_REGION":              371815341,
		"SECURITY_POLICY_CEVAL_RULES":                            470815689,
		"SECURITY_POLICY_RULES":                                  203549225,
		"SECURITY_POLICY_RULES_PER_REGION":                       126510156,
		"SERVICE_ATTACHMENTS":                                    471521510,
		"SNAPSHOTS":                                              343405327,
		"SSD_TOTAL_GB":                                           161732561,
		"SSL_CERTIFICATES":                                       378372399,
		"SSL_POLICIES":                                           523254339,
		"STATIC_ADDRESSES":                                       93624049,
		"STATIC_BYOIP_ADDRESSES":                                 275809649,
		"STATIC_EXTERNAL_IPV6_ADDRESS_RANGES":                    472346774,
		"SUBNETWORKS":                                            421330469,
		"T2A_CPUS":                                               522170599,
		"T2D_CPUS":                                               71187140,
		"TARGET_HTTPS_PROXIES":                                   219522506,
		"TARGET_HTTP_PROXIES":                                    164117155,
		"TARGET_INSTANCES":                                       284519728,
		"TARGET_POOLS":                                           348261257,
		"TARGET_SSL_PROXIES":                                     159216235,
		"TARGET_TCP_PROXIES":                                     182243136,
		"TARGET_VPN_GATEWAYS":                                    75029928,
		"TPU_LITE_DEVICE_V5":                                     449577597,
		"TPU_LITE_PODSLICE_V5":                                   12708294,
		"TPU_PODSLICE_V4":                                        214467530,
		"URL_MAPS":                                               378660743,
		"VARIABLE_IPV6_PUBLIC_DELEGATED_PREFIXES":                128400161,
		"VPN_GATEWAYS":                                           35620282,
		"VPN_TUNNELS":                                            104327296,
		"XPN_SERVICE_PROJECTS":                                   95191981,
	}
)

func (x Quota_Metric) Enum() *Quota_Metric {
	p := new(Quota_Metric)
	*p = x
	return p
}

func (x Quota_Metric) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Quota_Metric) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[332].Descriptor()
}

func (Quota_Metric) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[332]
}

func (x Quota_Metric) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Quota_Metric.Descriptor instead.
func (Quota_Metric) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1296, 0}
}

// Rollout status of the future quota limit.
type QuotaExceededInfo_RolloutStatus int32

const (
	// A value indicating that the enum field is not set.
	QuotaExceededInfo_UNDEFINED_ROLLOUT_STATUS QuotaExceededInfo_RolloutStatus = 0
	// IN_PROGRESS - A rollout is in process which will change the limit value to future limit.
	QuotaExceededInfo_IN_PROGRESS QuotaExceededInfo_RolloutStatus = 469193735
	// ROLLOUT_STATUS_UNSPECIFIED - Rollout status is not specified. The default value.
	QuotaExceededInfo_ROLLOUT_STATUS_UNSPECIFIED QuotaExceededInfo_RolloutStatus = 26864568
)

// Enum value maps for QuotaExceededInfo_RolloutStatus.
var (
	QuotaExceededInfo_RolloutStatus_name = map[int32]string{
		0:         "UNDEFINED_ROLLOUT_STATUS",
		469193735: "IN_PROGRESS",
		26864568:  "ROLLOUT_STATUS_UNSPECIFIED",
	}
	QuotaExceededInfo_RolloutStatus_value = map[string]int32{
		"UNDEFINED_ROLLOUT_STATUS":   0,
		"IN_PROGRESS":                469193735,
		"ROLLOUT_STATUS_UNSPECIFIED": 26864568,
	}
)

func (x QuotaExceededInfo_RolloutStatus) Enum() *QuotaExceededInfo_RolloutStatus {
	p := new(QuotaExceededInfo_RolloutStatus)
	*p = x
	return p
}

func (x QuotaExceededInfo_RolloutStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaExceededInfo_RolloutStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[333].Descriptor()
}

func (QuotaExceededInfo_RolloutStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[333]
}

func (x QuotaExceededInfo_RolloutStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaExceededInfo_RolloutStatus.Descriptor instead.
func (QuotaExceededInfo_RolloutStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1297, 0}
}

// [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
type QuotaStatusWarning_Code int32

const (
	// A value indicating that the enum field is not set.
	QuotaStatusWarning_UNDEFINED_CODE QuotaStatusWarning_Code = 0
	// Warning about failed cleanup of transient changes made by a failed operation.
	QuotaStatusWarning_CLEANUP_FAILED QuotaStatusWarning_Code = 150308440
	// A link to a deprecated resource was created.
	QuotaStatusWarning_DEPRECATED_RESOURCE_USED QuotaStatusWarning_Code = 391835586
	// When deploying and at least one of the resources has a type marked as deprecated
	QuotaStatusWarning_DEPRECATED_TYPE_USED QuotaStatusWarning_Code = 346526230
	// The user created a boot disk that is larger than image size.
	QuotaStatusWarning_DISK_SIZE_LARGER_THAN_IMAGE_SIZE QuotaStatusWarning_Code = 369442967
	// When deploying and at least one of the resources has a type marked as experimental
	QuotaStatusWarning_EXPERIMENTAL_TYPE_USED QuotaStatusWarning_Code = 451954443
	// Warning that is present in an external api call
	QuotaStatusWarning_EXTERNAL_API_WARNING QuotaStatusWarning_Code = 175546307
	// Warning that value of a field has been overridden. Deprecated unused field.
	QuotaStatusWarning_FIELD_VALUE_OVERRIDEN QuotaStatusWarning_Code = 329669423
	// The operation involved use of an injected kernel, which is deprecated.
	QuotaStatusWarning_INJECTED_KERNELS_DEPRECATED QuotaStatusWarning_Code = 417377419
	// A WEIGHTED_MAGLEV backend service is associated with a health check that is not of type HTTP/HTTPS/HTTP2.
	QuotaStatusWarning_INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB QuotaStatusWarning_Code = 401542606
	// When deploying a deployment with a exceedingly large number of resources
	QuotaStatusWarning_LARGE_DEPLOYMENT_WARNING QuotaStatusWarning_Code = 481440678
	// Resource can't be retrieved due to list overhead quota exceed which captures the amount of resources filtered out by user-defined list filter.
	QuotaStatusWarning_LIST_OVERHEAD_QUOTA_EXCEED QuotaStatusWarning_Code = 47618117
	// A resource depends on a missing type
	QuotaStatusWarning_MISSING_TYPE_DEPENDENCY QuotaStatusWarning_Code = 344505463
	// The route's nextHopIp address is not assigned to an instance on the network.
	QuotaStatusWarning_NEXT_HOP_ADDRESS_NOT_ASSIGNED QuotaStatusWarning_Code = 324964999
	// The route's next hop instance cannot ip forward.
	QuotaStatusWarning_NEXT_HOP_CANNOT_IP_FORWARD QuotaStatusWarning_Code = 383382887
	// The route's nextHopInstance URL refers to an instance that does not have an ipv6 interface on the same network as the route.
	QuotaStatusWarning_NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE QuotaStatusWarning_Code = 146748434
	// The route's nextHopInstance URL refers to an instance that does not exist.
	QuotaStatusWarning_NEXT_HOP_INSTANCE_NOT_FOUND QuotaStatusWarning_Code = 464250446
	// The route's nextHopInstance URL refers to an instance that is not on the same network as the route.
	QuotaStatusWarning_NEXT_HOP_INSTANCE_NOT_ON_NETWORK QuotaStatusWarning_Code = 243758146
	// The route's next hop instance does not have a status of RUNNING.
	QuotaStatusWarning_NEXT_HOP_NOT_RUNNING QuotaStatusWarning_Code = 417081265
	// Error which is not critical. We decided to continue the process despite the mentioned error.
	QuotaStatusWarning_NOT_CRITICAL_ERROR QuotaStatusWarning_Code = 105763924
	// No results are present on a particular list page.
	QuotaStatusWarning_NO_RESULTS_ON_PAGE QuotaStatusWarning_Code = 30036744
	// Success is reported, but some results may be missing due to errors
	QuotaStatusWarning_PARTIAL_SUCCESS QuotaStatusWarning_Code = 39966469
	// Quota information is not available to client requests (e.g: regions.list).
	QuotaStatusWarning_QUOTA_INFO_UNAVAILABLE QuotaStatusWarning_Code = 304294182
	// The user attempted to use a resource that requires a TOS they have not accepted.
	QuotaStatusWarning_REQUIRED_TOS_AGREEMENT QuotaStatusWarning_Code = 3745539
	// Warning that a resource is in use.
	QuotaStatusWarning_RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING QuotaStatusWarning_Code = 496728641
	// One or more of the resources set to auto-delete could not be deleted because they were in use.
	QuotaStatusWarning_RESOURCE_NOT_DELETED QuotaStatusWarning_Code = 168598460
	// When a resource schema validation is ignored.
	QuotaStatusWarning_SCHEMA_VALIDATION_IGNORED QuotaStatusWarning_Code = 275245642
	// Instance template used in instance group manager is valid as such, but its application does not make a lot of sense, because it allows only single instance in instance group.
	QuotaStatusWarning_SINGLE_INSTANCE_PROPERTY_TEMPLATE QuotaStatusWarning_Code = 268305617
	// When undeclared properties in the schema are present
	QuotaStatusWarning_UNDECLARED_PROPERTIES QuotaStatusWarning_Code = 390513439
	// A given scope cannot be reached.
	QuotaStatusWarning_UNREACHABLE QuotaStatusWarning_Code = 13328052
)

// Enum value maps for QuotaStatusWarning_Code.
var (
	QuotaStatusWarning_Code_name = map[int32]string{
		0:         "UNDEFINED_CODE",
		150308440: "CLEANUP_FAILED",
		391835586: "DEPRECATED_RESOURCE_USED",
		346526230: "DEPRECATED_TYPE_USED",
		369442967: "DISK_SIZE_LARGER_THAN_IMAGE_SIZE",
		451954443: "EXPERIMENTAL_TYPE_USED",
		175546307: "EXTERNAL_API_WARNING",
		329669423: "FIELD_VALUE_OVERRIDEN",
		417377419: "INJECTED_KERNELS_DEPRECATED",
		401542606: "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB",
		481440678: "LARGE_DEPLOYMENT_WARNING",
		47618117:  "LIST_OVERHEAD_QUOTA_EXCEED",
		344505463: "MISSING_TYPE_DEPENDENCY",
		324964999: "NEXT_HOP_ADDRESS_NOT_ASSIGNED",
		383382887: "NEXT_HOP_CANNOT_IP_FORWARD",
		146748434: "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE",
		464250446: "NEXT_HOP_INSTANCE_NOT_FOUND",
		243758146: "NEXT_HOP_INSTANCE_NOT_ON_NETWORK",
		417081265: "NEXT_HOP_NOT_RUNNING",
		105763924: "NOT_CRITICAL_ERROR",
		30036744:  "NO_RESULTS_ON_PAGE",
		39966469:  "PARTIAL_SUCCESS",
		304294182: "QUOTA_INFO_UNAVAILABLE",
		3745539:   "REQUIRED_TOS_AGREEMENT",
		496728641: "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING",
		168598460: "RESOURCE_NOT_DELETED",
		275245642: "SCHEMA_VALIDATION_IGNORED",
		268305617: "SINGLE_INSTANCE_PROPERTY_TEMPLATE",
		390513439: "UNDECLARED_PROPERTIES",
		13328052:  "UNREACHABLE",
	}
	QuotaStatusWarning_Code_value = map[string]int32{
		"UNDEFINED_CODE":                               0,
		"CLEANUP_FAILED":                               150308440,
		"DEPRECATED_RESOURCE_USED":                     391835586,
		"DEPRECATED_TYPE_USED":                         346526230,
		"DISK_SIZE_LARGER_THAN_IMAGE_SIZE":             369442967,
		"EXPERIMENTAL_TYPE_USED":                       451954443,
		"EXTERNAL_API_WARNING":                         175546307,
		"FIELD_VALUE_OVERRIDEN":                        329669423,
		"INJECTED_KERNELS_DEPRECATED":                  417377419,
		"INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB": 401542606,
		"LARGE_DEPLOYMENT_WARNING":                     481440678,
		"LIST_OVERHEAD_QUOTA_EXCEED":                   47618117,
		"MISSING_TYPE_DEPENDENCY":                      344505463,
		"NEXT_HOP_ADDRESS_NOT_ASSIGNED":                324964999,
		"NEXT_HOP_CANNOT_IP_FORWARD":                   383382887,
		"NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE":      146748434,
		"NEXT_HOP_INSTANCE_NOT_FOUND":                  464250446,
		"NEXT_HOP_INSTANCE_NOT_ON_NETWORK":             243758146,
		"NEXT_HOP_NOT_RUNNING":                         417081265,
		"NOT_CRITICAL_ERROR":                           105763924,
		"NO_RESULTS_ON_PAGE":                           30036744,
		"PARTIAL_SUCCESS":                              39966469,
		"QUOTA_INFO_UNAVAILABLE":                       304294182,
		"REQUIRED_TOS_AGREEMENT":                       3745539,
		"RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING":    496728641,
		"RESOURCE_NOT_DELETED":                         168598460,
		"SCHEMA_VALIDATION_IGNORED":                    275245642,
		"SINGLE_INSTANCE_PROPERTY_TEMPLATE":            268305617,
		"UNDECLARED_PROPERTIES":                        390513439,
		"UNREACHABLE":                                  13328052,
	}
)

func (x QuotaStatusWarning_Code) Enum() *QuotaStatusWarning_Code {
	p := new(QuotaStatusWarning_Code)
	*p = x
	return p
}

func (x QuotaStatusWarning_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaStatusWarning_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[334].Descriptor()
}

func (QuotaStatusWarning_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[334]
}

func (x QuotaStatusWarning_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaStatusWarning_Code.Descriptor instead.
func (QuotaStatusWarning_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1298, 0}
}

// The format used to encode and transmit the block device, which should be TAR. This is just a container and transmission format and not a runtime format. Provided by the client when the disk image is created.
type RawDisk_ContainerType int32

const (
	// A value indicating that the enum field is not set.
	RawDisk_UNDEFINED_CONTAINER_TYPE RawDisk_ContainerType = 0
	RawDisk_TAR                      RawDisk_ContainerType = 82821
)

// Enum value maps for RawDisk_ContainerType.
var (
	RawDisk_ContainerType_name = map[int32]string{
		0:     "UNDEFINED_CONTAINER_TYPE",
		82821: "TAR",
	}
	RawDisk_ContainerType_value = map[string]int32{
		"UNDEFINED_CONTAINER_TYPE": 0,
		"TAR":                      82821,
	}
)

func (x RawDisk_ContainerType) Enum() *RawDisk_ContainerType {
	p := new(RawDisk_ContainerType)
	*p = x
	return p
}

func (x RawDisk_ContainerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RawDisk_ContainerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[335].Descriptor()
}

func (RawDisk_ContainerType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[335]
}

func (x RawDisk_ContainerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RawDisk_ContainerType.Descriptor instead.
func (RawDisk_ContainerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1299, 0}
}

// [Output Only] Status of the region, either UP or DOWN.
type Region_Status int32

const (
	// A value indicating that the enum field is not set.
	Region_UNDEFINED_STATUS Region_Status = 0
	Region_DOWN             Region_Status = 2104482
	Region_UP               Region_Status = 2715
)

// Enum value maps for Region_Status.
var (
	Region_Status_name = map[int32]string{
		0:       "UNDEFINED_STATUS",
		2104482: "DOWN",
		2715:    "UP",
	}
	Region_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DOWN":             2104482,
		"UP":               2715,
	}
)

func (x Region_Status) Enum() *Region_Status {
	p := new(Region_Status)
	*p = x
	return p
}

func (x Region_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Region_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[336].Descriptor()
}

func (Region_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[336]
}

func (x Region_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Region_Status.Descriptor instead.
func (Region_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1303, 0}
}

// The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction int32

const (
	// A value indicating that the enum field is not set.
	RegionInstanceGroupManagersApplyUpdatesRequest_UNDEFINED_MINIMAL_ACTION RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction = 0
)

// Enum value maps for RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction.
var (
	RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction_name = map[int32]string{
		0: "UNDEFINED_MINIMAL_ACTION",
	}
	RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction_value = map[string]int32{
		"UNDEFINED_MINIMAL_ACTION": 0,
	}
)

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) Enum() *RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction {
	p := new(RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction)
	*p = x
	return p
}

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[337].Descriptor()
}

func (RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[337]
}

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction.Descriptor instead.
func (RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1319, 0}
}

// The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance and limit disruption as much as possible. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction int32

const (
	// A value indicating that the enum field is not set.
	RegionInstanceGroupManagersApplyUpdatesRequest_UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction = 0
)

// Enum value maps for RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction.
var (
	RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction_name = map[int32]string{
		0: "UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION",
	}
	RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction_value = map[string]int32{
		"UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION": 0,
	}
)

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Enum() *RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction {
	p := new(RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction)
	*p = x
	return p
}

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[338].Descriptor()
}

func (RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[338]
}

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction.Descriptor instead.
func (RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1319, 1}
}

// Instances in which state should be returned. Valid options are: 'ALL', 'RUNNING'. By default, it lists all instances.
type RegionInstanceGroupsListInstancesRequest_InstanceState int32

const (
	// A value indicating that the enum field is not set.
	RegionInstanceGroupsListInstancesRequest_UNDEFINED_INSTANCE_STATE RegionInstanceGroupsListInstancesRequest_InstanceState = 0
	// Matches any status of the instances, running, non-running and others.
	RegionInstanceGroupsListInstancesRequest_ALL RegionInstanceGroupsListInstancesRequest_InstanceState = 64897
	// Instance is in RUNNING state if it is running.
	RegionInstanceGroupsListInstancesRequest_RUNNING RegionInstanceGroupsListInstancesRequest_InstanceState = 121282975
)

// Enum value maps for RegionInstanceGroupsListInstancesRequest_InstanceState.
var (
	RegionInstanceGroupsListInstancesRequest_InstanceState_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_STATE",
		64897:     "ALL",
		121282975: "RUNNING",
	}
	RegionInstanceGroupsListInstancesRequest_InstanceState_value = map[string]int32{
		"UNDEFINED_INSTANCE_STATE": 0,
		"ALL":                      64897,
		"RUNNING":                  121282975,
	}
)

func (x RegionInstanceGroupsListInstancesRequest_InstanceState) Enum() *RegionInstanceGroupsListInstancesRequest_InstanceState {
	p := new(RegionInstanceGroupsListInstancesRequest_InstanceState)
	*p = x
	return p
}

func (x RegionInstanceGroupsListInstancesRequest_InstanceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegionInstanceGroupsListInstancesRequest_InstanceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[339].Descriptor()
}

func (RegionInstanceGroupsListInstancesRequest_InstanceState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[339]
}

func (x RegionInstanceGroupsListInstancesRequest_InstanceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegionInstanceGroupsListInstancesRequest_InstanceState.Descriptor instead.
func (RegionInstanceGroupsListInstancesRequest_InstanceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1335, 0}
}

// [Output Only] The type of the firewall policy. Can be one of HIERARCHY, NETWORK, NETWORK_REGIONAL, SYSTEM_GLOBAL, SYSTEM_REGIONAL.
type RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNDEFINED_TYPE   RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 0
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_HIERARCHY        RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 69902869
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK          RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 413984270
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK_REGIONAL RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 190804272
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_SYSTEM_GLOBAL    RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 60099507
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_SYSTEM_REGIONAL  RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 161777199
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNSPECIFIED      RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 526786327
)

// Enum value maps for RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.
var (
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		69902869:  "HIERARCHY",
		413984270: "NETWORK",
		190804272: "NETWORK_REGIONAL",
		60099507:  "SYSTEM_GLOBAL",
		161777199: "SYSTEM_REGIONAL",
		526786327: "UNSPECIFIED",
	}
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"HIERARCHY":        69902869,
		"NETWORK":          413984270,
		"NETWORK_REGIONAL": 190804272,
		"SYSTEM_GLOBAL":    60099507,
		"SYSTEM_REGIONAL":  161777199,
		"UNSPECIFIED":      526786327,
	}
)

func (x RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Enum() *RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type {
	p := new(RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type)
	*p = x
	return p
}

func (x RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[340].Descriptor()
}

func (RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[340]
}

func (x RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.Descriptor instead.
func (RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1341, 0}
}

// Specifies the deployment strategy for this reservation.
type Reservation_DeploymentType int32

const (
	// A value indicating that the enum field is not set.
	Reservation_UNDEFINED_DEPLOYMENT_TYPE Reservation_DeploymentType = 0
	// The reserved capacity is made up of densely deployed reservation blocks.
	Reservation_DENSE                       Reservation_DeploymentType = 64932607
	Reservation_DEPLOYMENT_TYPE_UNSPECIFIED Reservation_DeploymentType = 234847180
	// The reserved capacity is made up of highly flexible, logical reservation blocks.
	Reservation_FLEXIBLE Reservation_DeploymentType = 379880395
)

// Enum value maps for Reservation_DeploymentType.
var (
	Reservation_DeploymentType_name = map[int32]string{
		0:         "UNDEFINED_DEPLOYMENT_TYPE",
		64932607:  "DENSE",
		234847180: "DEPLOYMENT_TYPE_UNSPECIFIED",
		379880395: "FLEXIBLE",
	}
	Reservation_DeploymentType_value = map[string]int32{
		"UNDEFINED_DEPLOYMENT_TYPE":   0,
		"DENSE":                       64932607,
		"DEPLOYMENT_TYPE_UNSPECIFIED": 234847180,
		"FLEXIBLE":                    379880395,
	}
)

func (x Reservation_DeploymentType) Enum() *Reservation_DeploymentType {
	p := new(Reservation_DeploymentType)
	*p = x
	return p
}

func (x Reservation_DeploymentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Reservation_DeploymentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[341].Descriptor()
}

func (Reservation_DeploymentType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[341]
}

func (x Reservation_DeploymentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Reservation_DeploymentType.Descriptor instead.
func (Reservation_DeploymentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1371, 0}
}

// Protection tier for the workload which specifies the workload expectations in the event of infrastructure failures at data center (e.g. power and/or cooling failures).
type Reservation_ProtectionTier int32

const (
	// A value indicating that the enum field is not set.
	Reservation_UNDEFINED_PROTECTION_TIER Reservation_ProtectionTier = 0
	// CAPACITY_OPTIMIZED capacity leverages redundancies (e.g. power, cooling) at the data center during normal operating conditions. In the event of infrastructure failures at data center (e.g. power and/or cooling failures), this workload may be disrupted. As a consequence, it has a weaker availability SLO than STANDARD.
	Reservation_CAPACITY_OPTIMIZED Reservation_ProtectionTier = 17430466
	// Unspecified protection tier.
	Reservation_PROTECTION_TIER_UNSPECIFIED Reservation_ProtectionTier = 262261984
	// STANDARD protection for workload that should be protected by redundancies (e.g. power, cooling) at the data center level. In the event of infrastructure failures at data center (e.g. power and/or cooling failures), this workload is expected to continue as normal using the redundancies.
	Reservation_STANDARD Reservation_ProtectionTier = 484642493
)

// Enum value maps for Reservation_ProtectionTier.
var (
	Reservation_ProtectionTier_name = map[int32]string{
		0:         "UNDEFINED_PROTECTION_TIER",
		17430466:  "CAPACITY_OPTIMIZED",
		262261984: "PROTECTION_TIER_UNSPECIFIED",
		484642493: "STANDARD",
	}
	Reservation_ProtectionTier_value = map[string]int32{
		"UNDEFINED_PROTECTION_TIER":   0,
		"CAPACITY_OPTIMIZED":          17430466,
		"PROTECTION_TIER_UNSPECIFIED": 262261984,
		"STANDARD":                    484642493,
	}
)

func (x Reservation_ProtectionTier) Enum() *Reservation_ProtectionTier {
	p := new(Reservation_ProtectionTier)
	*p = x
	return p
}

func (x Reservation_ProtectionTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Reservation_ProtectionTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[342].Descriptor()
}

func (Reservation_ProtectionTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[342]
}

func (x Reservation_ProtectionTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Reservation_ProtectionTier.Descriptor instead.
func (Reservation_ProtectionTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1371, 1}
}

// [Output only] Indicates the reservation mode of the reservation.
type Reservation_ReservationMode int32

const (
	// A value indicating that the enum field is not set.
	Reservation_UNDEFINED_RESERVATION_MODE Reservation_ReservationMode = 0
	// The delivered reservations terminate at specified endtime along with terminating VMs running on it. The price for this reservation is different from on-demand. Currently offered for A3+ GPUs and TPUs only.
	Reservation_CALENDAR Reservation_ReservationMode = 67431230
	// The delivered reservations do not terminate VMs at the end of reservations. On-demand pricing and available for all VM families. This is default mode.
	Reservation_DEFAULT                      Reservation_ReservationMode = 115302945
	Reservation_RESERVATION_MODE_UNSPECIFIED Reservation_ReservationMode = 233810606
)

// Enum value maps for Reservation_ReservationMode.
var (
	Reservation_ReservationMode_name = map[int32]string{
		0:         "UNDEFINED_RESERVATION_MODE",
		67431230:  "CALENDAR",
		115302945: "DEFAULT",
		233810606: "RESERVATION_MODE_UNSPECIFIED",
	}
	Reservation_ReservationMode_value = map[string]int32{
		"UNDEFINED_RESERVATION_MODE":   0,
		"CALENDAR":                     67431230,
		"DEFAULT":                      115302945,
		"RESERVATION_MODE_UNSPECIFIED": 233810606,
	}
)

func (x Reservation_ReservationMode) Enum() *Reservation_ReservationMode {
	p := new(Reservation_ReservationMode)
	*p = x
	return p
}

func (x Reservation_ReservationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Reservation_ReservationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[343].Descriptor()
}

func (Reservation_ReservationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[343]
}

func (x Reservation_ReservationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Reservation_ReservationMode.Descriptor instead.
func (Reservation_ReservationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1371, 2}
}

// The type of maintenance for the reservation.
type Reservation_SchedulingType int32

const (
	// A value indicating that the enum field is not set.
	Reservation_UNDEFINED_SCHEDULING_TYPE Reservation_SchedulingType = 0
	// Maintenance on all reserved instances in the reservation is synchronized.
	Reservation_GROUPED Reservation_SchedulingType = 474540862
	// Unknown maintenance type.
	Reservation_GROUP_MAINTENANCE_TYPE_UNSPECIFIED Reservation_SchedulingType = 447183678
	// Maintenance is not synchronized for this reservation. Instead, each instance has its own maintenance window.
	Reservation_INDEPENDENT Reservation_SchedulingType = 127011674
)

// Enum value maps for Reservation_SchedulingType.
var (
	Reservation_SchedulingType_name = map[int32]string{
		0:         "UNDEFINED_SCHEDULING_TYPE",
		474540862: "GROUPED",
		447183678: "GROUP_MAINTENANCE_TYPE_UNSPECIFIED",
		127011674: "INDEPENDENT",
	}
	Reservation_SchedulingType_value = map[string]int32{
		"UNDEFINED_SCHEDULING_TYPE":          0,
		"GROUPED":                            474540862,
		"GROUP_MAINTENANCE_TYPE_UNSPECIFIED": 447183678,
		"INDEPENDENT":                        127011674,
	}
)

func (x Reservation_SchedulingType) Enum() *Reservation_SchedulingType {
	p := new(Reservation_SchedulingType)
	*p = x
	return p
}

func (x Reservation_SchedulingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Reservation_SchedulingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[344].Descriptor()
}

func (Reservation_SchedulingType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[344]
}

func (x Reservation_SchedulingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Reservation_SchedulingType.Descriptor instead.
func (Reservation_SchedulingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1371, 3}
}

// [Output Only] The status of the reservation. - CREATING: Reservation resources are being allocated. - READY: Reservation resources have been allocated, and the reservation is ready for use. - DELETING: Reservation deletion is in progress. - UPDATING: Reservation update is in progress.
type Reservation_Status int32

const (
	// A value indicating that the enum field is not set.
	Reservation_UNDEFINED_STATUS Reservation_Status = 0
	// Reservation resources are being allocated.
	Reservation_CREATING Reservation_Status = 455564985
	// Reservation deletion is in progress.
	Reservation_DELETING Reservation_Status = 528602024
	Reservation_INVALID  Reservation_Status = 530283991
	// Reservation resources have been allocated, and the reservation is ready for use.
	Reservation_READY Reservation_Status = 77848963
	// Reservation update is in progress.
	Reservation_UPDATING Reservation_Status = 494614342
)

// Enum value maps for Reservation_Status.
var (
	Reservation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
		494614342: "UPDATING",
	}
	Reservation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
		"UPDATING":         494614342,
	}
)

func (x Reservation_Status) Enum() *Reservation_Status {
	p := new(Reservation_Status)
	*p = x
	return p
}

func (x Reservation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Reservation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[345].Descriptor()
}

func (Reservation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[345]
}

func (x Reservation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Reservation_Status.Descriptor instead.
func (Reservation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1371, 4}
}

// Indicates chosen reservation operational mode for the reservation.
type ReservationAdvancedDeploymentControl_ReservationOperationalMode int32

const (
	// A value indicating that the enum field is not set.
	ReservationAdvancedDeploymentControl_UNDEFINED_RESERVATION_OPERATIONAL_MODE ReservationAdvancedDeploymentControl_ReservationOperationalMode = 0
	// Google Cloud does not manage the failure of machines, but provides additional capacity, which is not guaranteed to be available.
	ReservationAdvancedDeploymentControl_ALL_CAPACITY ReservationAdvancedDeploymentControl_ReservationOperationalMode = 500029880
	// Google Cloud manages the failure of machines to provide high availability.
	ReservationAdvancedDeploymentControl_HIGHLY_AVAILABLE_CAPACITY                ReservationAdvancedDeploymentControl_ReservationOperationalMode = 110861600
	ReservationAdvancedDeploymentControl_RESERVATION_OPERATIONAL_MODE_UNSPECIFIED ReservationAdvancedDeploymentControl_ReservationOperationalMode = 194296603
)

// Enum value maps for ReservationAdvancedDeploymentControl_ReservationOperationalMode.
var (
	ReservationAdvancedDeploymentControl_ReservationOperationalMode_name = map[int32]string{
		0:         "UNDEFINED_RESERVATION_OPERATIONAL_MODE",
		500029880: "ALL_CAPACITY",
		110861600: "HIGHLY_AVAILABLE_CAPACITY",
		194296603: "RESERVATION_OPERATIONAL_MODE_UNSPECIFIED",
	}
	ReservationAdvancedDeploymentControl_ReservationOperationalMode_value = map[string]int32{
		"UNDEFINED_RESERVATION_OPERATIONAL_MODE":   0,
		"ALL_CAPACITY":                             500029880,
		"HIGHLY_AVAILABLE_CAPACITY":                110861600,
		"RESERVATION_OPERATIONAL_MODE_UNSPECIFIED": 194296603,
	}
)

func (x ReservationAdvancedDeploymentControl_ReservationOperationalMode) Enum() *ReservationAdvancedDeploymentControl_ReservationOperationalMode {
	p := new(ReservationAdvancedDeploymentControl_ReservationOperationalMode)
	*p = x
	return p
}

func (x ReservationAdvancedDeploymentControl_ReservationOperationalMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationAdvancedDeploymentControl_ReservationOperationalMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[346].Descriptor()
}

func (ReservationAdvancedDeploymentControl_ReservationOperationalMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[346]
}

func (x ReservationAdvancedDeploymentControl_ReservationOperationalMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationAdvancedDeploymentControl_ReservationOperationalMode.Descriptor instead.
func (ReservationAdvancedDeploymentControl_ReservationOperationalMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1372, 0}
}

// Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See Consuming reserved instances for examples.
type ReservationAffinity_ConsumeReservationType int32

const (
	// A value indicating that the enum field is not set.
	ReservationAffinity_UNDEFINED_CONSUME_RESERVATION_TYPE ReservationAffinity_ConsumeReservationType = 0
	// Consume any allocation available.
	ReservationAffinity_ANY_RESERVATION ReservationAffinity_ConsumeReservationType = 200008121
	// Do not consume from any allocated capacity.
	ReservationAffinity_NO_RESERVATION ReservationAffinity_ConsumeReservationType = 169322030
	// Must consume from a specific reservation. Must specify key value fields for specifying the reservations.
	ReservationAffinity_SPECIFIC_RESERVATION ReservationAffinity_ConsumeReservationType = 229889055
	// Prefer to consume from a specific reservation, but still consume any reservation available if the specified reservation is not available or exhausted. Must specify key value fields for specifying the reservations.
	ReservationAffinity_SPECIFIC_THEN_ANY_RESERVATION ReservationAffinity_ConsumeReservationType = 37025924
	// Prefer to consume from a specific reservation, but still consume from the on-demand pool if the specified reservation is exhausted. Must specify key value fields for specifying the reservations.
	ReservationAffinity_SPECIFIC_THEN_NO_RESERVATION ReservationAffinity_ConsumeReservationType = 406522371
	ReservationAffinity_UNSPECIFIED                  ReservationAffinity_ConsumeReservationType = 526786327
)

// Enum value maps for ReservationAffinity_ConsumeReservationType.
var (
	ReservationAffinity_ConsumeReservationType_name = map[int32]string{
		0:         "UNDEFINED_CONSUME_RESERVATION_TYPE",
		200008121: "ANY_RESERVATION",
		169322030: "NO_RESERVATION",
		229889055: "SPECIFIC_RESERVATION",
		37025924:  "SPECIFIC_THEN_ANY_RESERVATION",
		406522371: "SPECIFIC_THEN_NO_RESERVATION",
		526786327: "UNSPECIFIED",
	}
	ReservationAffinity_ConsumeReservationType_value = map[string]int32{
		"UNDEFINED_CONSUME_RESERVATION_TYPE": 0,
		"ANY_RESERVATION":                    200008121,
		"NO_RESERVATION":                     169322030,
		"SPECIFIC_RESERVATION":               229889055,
		"SPECIFIC_THEN_ANY_RESERVATION":      37025924,
		"SPECIFIC_THEN_NO_RESERVATION":       406522371,
		"UNSPECIFIED":                        526786327,
	}
)

func (x ReservationAffinity_ConsumeReservationType) Enum() *ReservationAffinity_ConsumeReservationType {
	p := new(ReservationAffinity_ConsumeReservationType)
	*p = x
	return p
}

func (x ReservationAffinity_ConsumeReservationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationAffinity_ConsumeReservationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[347].Descriptor()
}

func (ReservationAffinity_ConsumeReservationType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[347]
}

func (x ReservationAffinity_ConsumeReservationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationAffinity_ConsumeReservationType.Descriptor instead.
func (ReservationAffinity_ConsumeReservationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1373, 0}
}

// [Output Only] Status of the reservation block.
type ReservationBlock_Status int32

const (
	// A value indicating that the enum field is not set.
	ReservationBlock_UNDEFINED_STATUS ReservationBlock_Status = 0
	// Resources are being allocated for the reservation block.
	ReservationBlock_CREATING ReservationBlock_Status = 455564985
	// Reservation block is currently being deleted.
	ReservationBlock_DELETING ReservationBlock_Status = 528602024
	ReservationBlock_INVALID  ReservationBlock_Status = 530283991
	// Reservation block has allocated all its resources.
	ReservationBlock_READY ReservationBlock_Status = 77848963
)

// Enum value maps for ReservationBlock_Status.
var (
	ReservationBlock_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
	}
	ReservationBlock_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x ReservationBlock_Status) Enum() *ReservationBlock_Status {
	p := new(ReservationBlock_Status)
	*p = x
	return p
}

func (x ReservationBlock_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationBlock_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[348].Descriptor()
}

func (ReservationBlock_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[348]
}

func (x ReservationBlock_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationBlock_Status.Descriptor instead.
func (ReservationBlock_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1375, 0}
}

// The health status of the reservation block.
type ReservationBlockHealthInfo_HealthStatus int32

const (
	// A value indicating that the enum field is not set.
	ReservationBlockHealthInfo_UNDEFINED_HEALTH_STATUS ReservationBlockHealthInfo_HealthStatus = 0
	// The reservation block is degraded.
	ReservationBlockHealthInfo_DEGRADED ReservationBlockHealthInfo_HealthStatus = 396890926
	// The reservation block is healthy.
	ReservationBlockHealthInfo_HEALTHY ReservationBlockHealthInfo_HealthStatus = 439801213
	// The health status of the reservation block is unspecified.
	ReservationBlockHealthInfo_HEALTH_STATUS_UNSPECIFIED ReservationBlockHealthInfo_HealthStatus = 482246925
)

// Enum value maps for ReservationBlockHealthInfo_HealthStatus.
var (
	ReservationBlockHealthInfo_HealthStatus_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATUS",
		396890926: "DEGRADED",
		439801213: "HEALTHY",
		482246925: "HEALTH_STATUS_UNSPECIFIED",
	}
	ReservationBlockHealthInfo_HealthStatus_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS":   0,
		"DEGRADED":                  396890926,
		"HEALTHY":                   439801213,
		"HEALTH_STATUS_UNSPECIFIED": 482246925,
	}
)

func (x ReservationBlockHealthInfo_HealthStatus) Enum() *ReservationBlockHealthInfo_HealthStatus {
	p := new(ReservationBlockHealthInfo_HealthStatus)
	*p = x
	return p
}

func (x ReservationBlockHealthInfo_HealthStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationBlockHealthInfo_HealthStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[349].Descriptor()
}

func (ReservationBlockHealthInfo_HealthStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[349]
}

func (x ReservationBlockHealthInfo_HealthStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationBlockHealthInfo_HealthStatus.Descriptor instead.
func (ReservationBlockHealthInfo_HealthStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1376, 0}
}

// [Output Only] Status of the reservation subBlock.
type ReservationSubBlock_Status int32

const (
	// A value indicating that the enum field is not set.
	ReservationSubBlock_UNDEFINED_STATUS ReservationSubBlock_Status = 0
	// Resources are being allocated for the reservation subBlock.
	ReservationSubBlock_CREATING ReservationSubBlock_Status = 455564985
	// Reservation subBlock is currently being deleted.
	ReservationSubBlock_DELETING ReservationSubBlock_Status = 528602024
	ReservationSubBlock_INVALID  ReservationSubBlock_Status = 530283991
	// Reservation subBlock has allocated all its resources.
	ReservationSubBlock_READY ReservationSubBlock_Status = 77848963
)

// Enum value maps for ReservationSubBlock_Status.
var (
	ReservationSubBlock_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
	}
	ReservationSubBlock_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x ReservationSubBlock_Status) Enum() *ReservationSubBlock_Status {
	p := new(ReservationSubBlock_Status)
	*p = x
	return p
}

func (x ReservationSubBlock_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationSubBlock_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[350].Descriptor()
}

func (ReservationSubBlock_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[350]
}

func (x ReservationSubBlock_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationSubBlock_Status.Descriptor instead.
func (ReservationSubBlock_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1383, 0}
}

// The health status of the reservation subBlock.
type ReservationSubBlockHealthInfo_HealthStatus int32

const (
	// A value indicating that the enum field is not set.
	ReservationSubBlockHealthInfo_UNDEFINED_HEALTH_STATUS ReservationSubBlockHealthInfo_HealthStatus = 0
	// The reservation subBlock is degraded.
	ReservationSubBlockHealthInfo_DEGRADED ReservationSubBlockHealthInfo_HealthStatus = 396890926
	// The reservation subBlock is healthy.
	ReservationSubBlockHealthInfo_HEALTHY ReservationSubBlockHealthInfo_HealthStatus = 439801213
	// The health status of the reservation subBlock is unspecified.
	ReservationSubBlockHealthInfo_HEALTH_STATUS_UNSPECIFIED ReservationSubBlockHealthInfo_HealthStatus = 482246925
)

// Enum value maps for ReservationSubBlockHealthInfo_HealthStatus.
var (
	ReservationSubBlockHealthInfo_HealthStatus_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATUS",
		396890926: "DEGRADED",
		439801213: "HEALTHY",
		482246925: "HEALTH_STATUS_UNSPECIFIED",
	}
	ReservationSubBlockHealthInfo_HealthStatus_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS":   0,
		"DEGRADED":                  396890926,
		"HEALTHY":                   439801213,
		"HEALTH_STATUS_UNSPECIFIED": 482246925,
	}
)

func (x ReservationSubBlockHealthInfo_HealthStatus) Enum() *ReservationSubBlockHealthInfo_HealthStatus {
	p := new(ReservationSubBlockHealthInfo_HealthStatus)
	*p = x
	return p
}

func (x ReservationSubBlockHealthInfo_HealthStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationSubBlockHealthInfo_HealthStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[351].Descriptor()
}

func (ReservationSubBlockHealthInfo_HealthStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[351]
}

func (x ReservationSubBlockHealthInfo_HealthStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationSubBlockHealthInfo_HealthStatus.Descriptor instead.
func (ReservationSubBlockHealthInfo_HealthStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1384, 0}
}

// The disruption schedule for the subBlock.
type ReservationSubBlocksReportFaultyRequest_DisruptionSchedule int32

const (
	// A value indicating that the enum field is not set.
	ReservationSubBlocksReportFaultyRequest_UNDEFINED_DISRUPTION_SCHEDULE   ReservationSubBlocksReportFaultyRequest_DisruptionSchedule = 0
	ReservationSubBlocksReportFaultyRequest_DISRUPTION_SCHEDULE_UNSPECIFIED ReservationSubBlocksReportFaultyRequest_DisruptionSchedule = 332543835
	// All VMs will be disrupted immediately.
	ReservationSubBlocksReportFaultyRequest_IMMEDIATE ReservationSubBlocksReportFaultyRequest_DisruptionSchedule = 152881041
)

// Enum value maps for ReservationSubBlocksReportFaultyRequest_DisruptionSchedule.
var (
	ReservationSubBlocksReportFaultyRequest_DisruptionSchedule_name = map[int32]string{
		0:         "UNDEFINED_DISRUPTION_SCHEDULE",
		332543835: "DISRUPTION_SCHEDULE_UNSPECIFIED",
		152881041: "IMMEDIATE",
	}
	ReservationSubBlocksReportFaultyRequest_DisruptionSchedule_value = map[string]int32{
		"UNDEFINED_DISRUPTION_SCHEDULE":   0,
		"DISRUPTION_SCHEDULE_UNSPECIFIED": 332543835,
		"IMMEDIATE":                       152881041,
	}
)

func (x ReservationSubBlocksReportFaultyRequest_DisruptionSchedule) Enum() *ReservationSubBlocksReportFaultyRequest_DisruptionSchedule {
	p := new(ReservationSubBlocksReportFaultyRequest_DisruptionSchedule)
	*p = x
	return p
}

func (x ReservationSubBlocksReportFaultyRequest_DisruptionSchedule) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationSubBlocksReportFaultyRequest_DisruptionSchedule) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[352].Descriptor()
}

func (ReservationSubBlocksReportFaultyRequest_DisruptionSchedule) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[352]
}

func (x ReservationSubBlocksReportFaultyRequest_DisruptionSchedule) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationSubBlocksReportFaultyRequest_DisruptionSchedule.Descriptor instead.
func (ReservationSubBlocksReportFaultyRequest_DisruptionSchedule) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1388, 0}
}

// The component that experienced the fault.
type ReservationSubBlocksReportFaultyRequest_FailureComponent int32

const (
	// A value indicating that the enum field is not set.
	ReservationSubBlocksReportFaultyRequest_UNDEFINED_FAILURE_COMPONENT   ReservationSubBlocksReportFaultyRequest_FailureComponent = 0
	ReservationSubBlocksReportFaultyRequest_FAILURE_COMPONENT_UNSPECIFIED ReservationSubBlocksReportFaultyRequest_FailureComponent = 332003744
	// Multiple hosts experienced the fault.
	ReservationSubBlocksReportFaultyRequest_MULTIPLE_FAULTY_HOSTS ReservationSubBlocksReportFaultyRequest_FailureComponent = 423545298
	// The NVLink switch experienced the fault.
	ReservationSubBlocksReportFaultyRequest_NVLINK_SWITCH ReservationSubBlocksReportFaultyRequest_FailureComponent = 239107153
)

// Enum value maps for ReservationSubBlocksReportFaultyRequest_FailureComponent.
var (
	ReservationSubBlocksReportFaultyRequest_FailureComponent_name = map[int32]string{
		0:         "UNDEFINED_FAILURE_COMPONENT",
		332003744: "FAILURE_COMPONENT_UNSPECIFIED",
		423545298: "MULTIPLE_FAULTY_HOSTS",
		239107153: "NVLINK_SWITCH",
	}
	ReservationSubBlocksReportFaultyRequest_FailureComponent_value = map[string]int32{
		"UNDEFINED_FAILURE_COMPONENT":   0,
		"FAILURE_COMPONENT_UNSPECIFIED": 332003744,
		"MULTIPLE_FAULTY_HOSTS":         423545298,
		"NVLINK_SWITCH":                 239107153,
	}
)

func (x ReservationSubBlocksReportFaultyRequest_FailureComponent) Enum() *ReservationSubBlocksReportFaultyRequest_FailureComponent {
	p := new(ReservationSubBlocksReportFaultyRequest_FailureComponent)
	*p = x
	return p
}

func (x ReservationSubBlocksReportFaultyRequest_FailureComponent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationSubBlocksReportFaultyRequest_FailureComponent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[353].Descriptor()
}

func (ReservationSubBlocksReportFaultyRequest_FailureComponent) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[353]
}

func (x ReservationSubBlocksReportFaultyRequest_FailureComponent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationSubBlocksReportFaultyRequest_FailureComponent.Descriptor instead.
func (ReservationSubBlocksReportFaultyRequest_FailureComponent) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1388, 1}
}

// The behavior of the fault experienced with the subBlock.
type ReservationSubBlocksReportFaultyRequestFaultReason_Behavior int32

const (
	// A value indicating that the enum field is not set.
	ReservationSubBlocksReportFaultyRequestFaultReason_UNDEFINED_BEHAVIOR         ReservationSubBlocksReportFaultyRequestFaultReason_Behavior = 0
	ReservationSubBlocksReportFaultyRequestFaultReason_FAULT_BEHAVIOR_UNSPECIFIED ReservationSubBlocksReportFaultyRequestFaultReason_Behavior = 447660743
	// The subBlock experienced a GPU error.
	ReservationSubBlocksReportFaultyRequestFaultReason_GPU_ERROR ReservationSubBlocksReportFaultyRequestFaultReason_Behavior = 198817909
	// The subBlock experienced performance issues.
	ReservationSubBlocksReportFaultyRequestFaultReason_PERFORMANCE ReservationSubBlocksReportFaultyRequestFaultReason_Behavior = 135701520
	// The subBlock experienced a switch failure.
	ReservationSubBlocksReportFaultyRequestFaultReason_SWITCH_FAILURE ReservationSubBlocksReportFaultyRequestFaultReason_Behavior = 254909279
)

// Enum value maps for ReservationSubBlocksReportFaultyRequestFaultReason_Behavior.
var (
	ReservationSubBlocksReportFaultyRequestFaultReason_Behavior_name = map[int32]string{
		0:         "UNDEFINED_BEHAVIOR",
		447660743: "FAULT_BEHAVIOR_UNSPECIFIED",
		198817909: "GPU_ERROR",
		135701520: "PERFORMANCE",
		254909279: "SWITCH_FAILURE",
	}
	ReservationSubBlocksReportFaultyRequestFaultReason_Behavior_value = map[string]int32{
		"UNDEFINED_BEHAVIOR":         0,
		"FAULT_BEHAVIOR_UNSPECIFIED": 447660743,
		"GPU_ERROR":                  198817909,
		"PERFORMANCE":                135701520,
		"SWITCH_FAILURE":             254909279,
	}
)

func (x ReservationSubBlocksReportFaultyRequestFaultReason_Behavior) Enum() *ReservationSubBlocksReportFaultyRequestFaultReason_Behavior {
	p := new(ReservationSubBlocksReportFaultyRequestFaultReason_Behavior)
	*p = x
	return p
}

func (x ReservationSubBlocksReportFaultyRequestFaultReason_Behavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationSubBlocksReportFaultyRequestFaultReason_Behavior) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[354].Descriptor()
}

func (ReservationSubBlocksReportFaultyRequestFaultReason_Behavior) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[354]
}

func (x ReservationSubBlocksReportFaultyRequestFaultReason_Behavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationSubBlocksReportFaultyRequestFaultReason_Behavior.Descriptor instead.
func (ReservationSubBlocksReportFaultyRequestFaultReason_Behavior) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1389, 0}
}

// Specifies if all, running or unused hosts are in scope for this request.
type ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope int32

const (
	// A value indicating that the enum field is not set.
	ReservationsBlocksPerformMaintenanceRequest_UNDEFINED_MAINTENANCE_SCOPE ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope = 0
	// Trigger maintenance for all hosts belonging to this reservation irrespective of whether VMs are running on them or not.
	ReservationsBlocksPerformMaintenanceRequest_ALL ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope = 64897
	// Internal only
	ReservationsBlocksPerformMaintenanceRequest_MAINTENANCE_SCOPE_UNSPECIFIED ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope = 78827328
	// Trigger maintenance only on the hosts belonging to this reservation which have VMs running on them.
	ReservationsBlocksPerformMaintenanceRequest_RUNNING_VMS ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope = 535770588
	// Trigger maintenance only on the hosts belonging to this reservation which do not have any VMs running on them. This is not allowed for Standard ExR
	ReservationsBlocksPerformMaintenanceRequest_UNUSED_CAPACITY ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope = 212724995
)

// Enum value maps for ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope.
var (
	ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope_name = map[int32]string{
		0:         "UNDEFINED_MAINTENANCE_SCOPE",
		64897:     "ALL",
		78827328:  "MAINTENANCE_SCOPE_UNSPECIFIED",
		535770588: "RUNNING_VMS",
		212724995: "UNUSED_CAPACITY",
	}
	ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope_value = map[string]int32{
		"UNDEFINED_MAINTENANCE_SCOPE":   0,
		"ALL":                           64897,
		"MAINTENANCE_SCOPE_UNSPECIFIED": 78827328,
		"RUNNING_VMS":                   535770588,
		"UNUSED_CAPACITY":               212724995,
	}
)

func (x ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope) Enum() *ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope {
	p := new(ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope)
	*p = x
	return p
}

func (x ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[355].Descriptor()
}

func (ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[355]
}

func (x ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope.Descriptor instead.
func (ReservationsBlocksPerformMaintenanceRequest_MaintenanceScope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1390, 0}
}

// Specifies if all, running or unused hosts are in scope for this request.
type ReservationsPerformMaintenanceRequest_MaintenanceScope int32

const (
	// A value indicating that the enum field is not set.
	ReservationsPerformMaintenanceRequest_UNDEFINED_MAINTENANCE_SCOPE ReservationsPerformMaintenanceRequest_MaintenanceScope = 0
	// Trigger maintenance for all hosts belonging to this reservation irrespective of whether VMs are running on them or not.
	ReservationsPerformMaintenanceRequest_ALL ReservationsPerformMaintenanceRequest_MaintenanceScope = 64897
	// Internal only
	ReservationsPerformMaintenanceRequest_MAINTENANCE_SCOPE_UNSPECIFIED ReservationsPerformMaintenanceRequest_MaintenanceScope = 78827328
	// Trigger maintenance only on the hosts belonging to this reservation which have VMs running on them.
	ReservationsPerformMaintenanceRequest_RUNNING_VMS ReservationsPerformMaintenanceRequest_MaintenanceScope = 535770588
	// Trigger maintenance only on the hosts belonging to this reservation which do not have any VMs running on them. This is not allowed for Standard ExR
	ReservationsPerformMaintenanceRequest_UNUSED_CAPACITY ReservationsPerformMaintenanceRequest_MaintenanceScope = 212724995
)

// Enum value maps for ReservationsPerformMaintenanceRequest_MaintenanceScope.
var (
	ReservationsPerformMaintenanceRequest_MaintenanceScope_name = map[int32]string{
		0:         "UNDEFINED_MAINTENANCE_SCOPE",
		64897:     "ALL",
		78827328:  "MAINTENANCE_SCOPE_UNSPECIFIED",
		535770588: "RUNNING_VMS",
		212724995: "UNUSED_CAPACITY",
	}
	ReservationsPerformMaintenanceRequest_MaintenanceScope_value = map[string]int32{
		"UNDEFINED_MAINTENANCE_SCOPE":   0,
		"ALL":                           64897,
		"MAINTENANCE_SCOPE_UNSPECIFIED": 78827328,
		"RUNNING_VMS":                   535770588,
		"UNUSED_CAPACITY":               212724995,
	}
)

func (x ReservationsPerformMaintenanceRequest_MaintenanceScope) Enum() *ReservationsPerformMaintenanceRequest_MaintenanceScope {
	p := new(ReservationsPerformMaintenanceRequest_MaintenanceScope)
	*p = x
	return p
}

func (x ReservationsPerformMaintenanceRequest_MaintenanceScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationsPerformMaintenanceRequest_MaintenanceScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[356].Descriptor()
}

func (ReservationsPerformMaintenanceRequest_MaintenanceScope) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[356]
}

func (x ReservationsPerformMaintenanceRequest_MaintenanceScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationsPerformMaintenanceRequest_MaintenanceScope.Descriptor instead.
func (ReservationsPerformMaintenanceRequest_MaintenanceScope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1391, 0}
}

// The type of hardware resource that you want to specify. You can specify any of the following values: - VCPU - MEMORY - LOCAL_SSD - ACCELERATOR Specify as a separate entry in the list for each individual resource type.
type ResourceCommitment_Type int32

const (
	// A value indicating that the enum field is not set.
	ResourceCommitment_UNDEFINED_TYPE ResourceCommitment_Type = 0
	ResourceCommitment_ACCELERATOR    ResourceCommitment_Type = 429815371
	ResourceCommitment_LOCAL_SSD      ResourceCommitment_Type = 508934896
	ResourceCommitment_MEMORY         ResourceCommitment_Type = 123056385
	ResourceCommitment_UNSPECIFIED    ResourceCommitment_Type = 526786327
	ResourceCommitment_VCPU           ResourceCommitment_Type = 2628978
)

// Enum value maps for ResourceCommitment_Type.
var (
	ResourceCommitment_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		429815371: "ACCELERATOR",
		508934896: "LOCAL_SSD",
		123056385: "MEMORY",
		526786327: "UNSPECIFIED",
		2628978:   "VCPU",
	}
	ResourceCommitment_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"ACCELERATOR":    429815371,
		"LOCAL_SSD":      508934896,
		"MEMORY":         123056385,
		"UNSPECIFIED":    526786327,
		"VCPU":           2628978,
	}
)

func (x ResourceCommitment_Type) Enum() *ResourceCommitment_Type {
	p := new(ResourceCommitment_Type)
	*p = x
	return p
}

func (x ResourceCommitment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceCommitment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[357].Descriptor()
}

func (ResourceCommitment_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[357]
}

func (x ResourceCommitment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceCommitment_Type.Descriptor instead.
func (ResourceCommitment_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1402, 0}
}

// [Output Only] The status of resource policy creation.
type ResourcePolicy_Status int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicy_UNDEFINED_STATUS ResourcePolicy_Status = 0
	// Resource policy is being created.
	ResourcePolicy_CREATING ResourcePolicy_Status = 455564985
	// Resource policy is being deleted.
	ResourcePolicy_DELETING ResourcePolicy_Status = 528602024
	// Resource policy is expired and will not run again.
	ResourcePolicy_EXPIRED ResourcePolicy_Status = 482489093
	ResourcePolicy_INVALID ResourcePolicy_Status = 530283991
	// Resource policy is ready to be used.
	ResourcePolicy_READY ResourcePolicy_Status = 77848963
)

// Enum value maps for ResourcePolicy_Status.
var (
	ResourcePolicy_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		482489093: "EXPIRED",
		530283991: "INVALID",
		77848963:  "READY",
	}
	ResourcePolicy_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"EXPIRED":          482489093,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x ResourcePolicy_Status) Enum() *ResourcePolicy_Status {
	p := new(ResourcePolicy_Status)
	*p = x
	return p
}

func (x ResourcePolicy_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicy_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[358].Descriptor()
}

func (ResourcePolicy_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[358]
}

func (x ResourcePolicy_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicy_Status.Descriptor instead.
func (ResourcePolicy_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1405, 0}
}

// Specifies network collocation
type ResourcePolicyGroupPlacementPolicy_Collocation int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicyGroupPlacementPolicy_UNDEFINED_COLLOCATION   ResourcePolicyGroupPlacementPolicy_Collocation = 0
	ResourcePolicyGroupPlacementPolicy_COLLOCATED              ResourcePolicyGroupPlacementPolicy_Collocation = 103257554
	ResourcePolicyGroupPlacementPolicy_UNSPECIFIED_COLLOCATION ResourcePolicyGroupPlacementPolicy_Collocation = 464308205
)

// Enum value maps for ResourcePolicyGroupPlacementPolicy_Collocation.
var (
	ResourcePolicyGroupPlacementPolicy_Collocation_name = map[int32]string{
		0:         "UNDEFINED_COLLOCATION",
		103257554: "COLLOCATED",
		464308205: "UNSPECIFIED_COLLOCATION",
	}
	ResourcePolicyGroupPlacementPolicy_Collocation_value = map[string]int32{
		"UNDEFINED_COLLOCATION":   0,
		"COLLOCATED":              103257554,
		"UNSPECIFIED_COLLOCATION": 464308205,
	}
)

func (x ResourcePolicyGroupPlacementPolicy_Collocation) Enum() *ResourcePolicyGroupPlacementPolicy_Collocation {
	p := new(ResourcePolicyGroupPlacementPolicy_Collocation)
	*p = x
	return p
}

func (x ResourcePolicyGroupPlacementPolicy_Collocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicyGroupPlacementPolicy_Collocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[359].Descriptor()
}

func (ResourcePolicyGroupPlacementPolicy_Collocation) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[359]
}

func (x ResourcePolicyGroupPlacementPolicy_Collocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicyGroupPlacementPolicy_Collocation.Descriptor instead.
func (ResourcePolicyGroupPlacementPolicy_Collocation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1409, 0}
}

// Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
type ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_UNDEFINED_ON_SOURCE_DISK_DELETE   ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 0
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_APPLY_RETENTION_POLICY            ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 535071332
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_KEEP_AUTO_SNAPSHOTS               ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 258925689
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_UNSPECIFIED_ON_SOURCE_DISK_DELETE ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 239140769
)

// Enum value maps for ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete.
var (
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete_name = map[int32]string{
		0:         "UNDEFINED_ON_SOURCE_DISK_DELETE",
		535071332: "APPLY_RETENTION_POLICY",
		258925689: "KEEP_AUTO_SNAPSHOTS",
		239140769: "UNSPECIFIED_ON_SOURCE_DISK_DELETE",
	}
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete_value = map[string]int32{
		"UNDEFINED_ON_SOURCE_DISK_DELETE":   0,
		"APPLY_RETENTION_POLICY":            535071332,
		"KEEP_AUTO_SNAPSHOTS":               258925689,
		"UNSPECIFIED_ON_SOURCE_DISK_DELETE": 239140769,
	}
)

func (x ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Enum() *ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete {
	p := new(ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete)
	*p = x
	return p
}

func (x ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[360].Descriptor()
}

func (ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[360]
}

func (x ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete.Descriptor instead.
func (ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1417, 0}
}

// Defines a schedule that runs on specific days of the week. Specify one or more days. The following options are available: MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.
type ResourcePolicyWeeklyCycleDayOfWeek_Day int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicyWeeklyCycleDayOfWeek_UNDEFINED_DAY ResourcePolicyWeeklyCycleDayOfWeek_Day = 0
	ResourcePolicyWeeklyCycleDayOfWeek_FRIDAY        ResourcePolicyWeeklyCycleDayOfWeek_Day = 471398751
	ResourcePolicyWeeklyCycleDayOfWeek_INVALID       ResourcePolicyWeeklyCycleDayOfWeek_Day = 530283991
	ResourcePolicyWeeklyCycleDayOfWeek_MONDAY        ResourcePolicyWeeklyCycleDayOfWeek_Day = 132310288
	ResourcePolicyWeeklyCycleDayOfWeek_SATURDAY      ResourcePolicyWeeklyCycleDayOfWeek_Day = 279037881
	ResourcePolicyWeeklyCycleDayOfWeek_SUNDAY        ResourcePolicyWeeklyCycleDayOfWeek_Day = 309626320
	ResourcePolicyWeeklyCycleDayOfWeek_THURSDAY      ResourcePolicyWeeklyCycleDayOfWeek_Day = 207198682
	ResourcePolicyWeeklyCycleDayOfWeek_TUESDAY       ResourcePolicyWeeklyCycleDayOfWeek_Day = 277509677
	ResourcePolicyWeeklyCycleDayOfWeek_WEDNESDAY     ResourcePolicyWeeklyCycleDayOfWeek_Day = 422029110
)

// Enum value maps for ResourcePolicyWeeklyCycleDayOfWeek_Day.
var (
	ResourcePolicyWeeklyCycleDayOfWeek_Day_name = map[int32]string{
		0:         "UNDEFINED_DAY",
		471398751: "FRIDAY",
		530283991: "INVALID",
		132310288: "MONDAY",
		279037881: "SATURDAY",
		309626320: "SUNDAY",
		207198682: "THURSDAY",
		277509677: "TUESDAY",
		422029110: "WEDNESDAY",
	}
	ResourcePolicyWeeklyCycleDayOfWeek_Day_value = map[string]int32{
		"UNDEFINED_DAY": 0,
		"FRIDAY":        471398751,
		"INVALID":       530283991,
		"MONDAY":        132310288,
		"SATURDAY":      279037881,
		"SUNDAY":        309626320,
		"THURSDAY":      207198682,
		"TUESDAY":       277509677,
		"WEDNESDAY":     422029110,
	}
)

func (x ResourcePolicyWeeklyCycleDayOfWeek_Day) Enum() *ResourcePolicyWeeklyCycleDayOfWeek_Day {
	p := new(ResourcePolicyWeeklyCycleDayOfWeek_Day)
	*p = x
	return p
}

func (x ResourcePolicyWeeklyCycleDayOfWeek_Day) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicyWeeklyCycleDayOfWeek_Day) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[361].Descriptor()
}

func (ResourcePolicyWeeklyCycleDayOfWeek_Day) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[361]
}

func (x ResourcePolicyWeeklyCycleDayOfWeek_Day) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicyWeeklyCycleDayOfWeek_Day.Descriptor instead.
func (ResourcePolicyWeeklyCycleDayOfWeek_Day) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1421, 0}
}

// Specifies the maximum distance between instances.
type ResourcePolicyWorkloadPolicy_MaxTopologyDistance int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicyWorkloadPolicy_UNDEFINED_MAX_TOPOLOGY_DISTANCE ResourcePolicyWorkloadPolicy_MaxTopologyDistance = 0
	// VMs must be provisioned in the same block.
	ResourcePolicyWorkloadPolicy_BLOCK ResourcePolicyWorkloadPolicy_MaxTopologyDistance = 63294573
	// VMs must be provisioned in the same cluster.
	ResourcePolicyWorkloadPolicy_CLUSTER ResourcePolicyWorkloadPolicy_MaxTopologyDistance = 516333018
	// VMs must be provisioned in the same subblock.
	ResourcePolicyWorkloadPolicy_SUBBLOCK ResourcePolicyWorkloadPolicy_MaxTopologyDistance = 316202573
)

// Enum value maps for ResourcePolicyWorkloadPolicy_MaxTopologyDistance.
var (
	ResourcePolicyWorkloadPolicy_MaxTopologyDistance_name = map[int32]string{
		0:         "UNDEFINED_MAX_TOPOLOGY_DISTANCE",
		63294573:  "BLOCK",
		516333018: "CLUSTER",
		316202573: "SUBBLOCK",
	}
	ResourcePolicyWorkloadPolicy_MaxTopologyDistance_value = map[string]int32{
		"UNDEFINED_MAX_TOPOLOGY_DISTANCE": 0,
		"BLOCK":                           63294573,
		"CLUSTER":                         516333018,
		"SUBBLOCK":                        316202573,
	}
)

func (x ResourcePolicyWorkloadPolicy_MaxTopologyDistance) Enum() *ResourcePolicyWorkloadPolicy_MaxTopologyDistance {
	p := new(ResourcePolicyWorkloadPolicy_MaxTopologyDistance)
	*p = x
	return p
}

func (x ResourcePolicyWorkloadPolicy_MaxTopologyDistance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicyWorkloadPolicy_MaxTopologyDistance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[362].Descriptor()
}

func (ResourcePolicyWorkloadPolicy_MaxTopologyDistance) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[362]
}

func (x ResourcePolicyWorkloadPolicy_MaxTopologyDistance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicyWorkloadPolicy_MaxTopologyDistance.Descriptor instead.
func (ResourcePolicyWorkloadPolicy_MaxTopologyDistance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1422, 0}
}

// Specifies the intent of the instance placement in the MIG.
type ResourcePolicyWorkloadPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicyWorkloadPolicy_UNDEFINED_TYPE ResourcePolicyWorkloadPolicy_Type = 0
	// MIG spreads out the instances as much as possible for high availability.
	ResourcePolicyWorkloadPolicy_HIGH_AVAILABILITY ResourcePolicyWorkloadPolicy_Type = 409487576
	// MIG provisions instances as close to each other as possible for high throughput.
	ResourcePolicyWorkloadPolicy_HIGH_THROUGHPUT ResourcePolicyWorkloadPolicy_Type = 146499815
)

// Enum value maps for ResourcePolicyWorkloadPolicy_Type.
var (
	ResourcePolicyWorkloadPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		409487576: "HIGH_AVAILABILITY",
		146499815: "HIGH_THROUGHPUT",
	}
	ResourcePolicyWorkloadPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE":    0,
		"HIGH_AVAILABILITY": 409487576,
		"HIGH_THROUGHPUT":   146499815,
	}
)

func (x ResourcePolicyWorkloadPolicy_Type) Enum() *ResourcePolicyWorkloadPolicy_Type {
	p := new(ResourcePolicyWorkloadPolicy_Type)
	*p = x
	return p
}

func (x ResourcePolicyWorkloadPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicyWorkloadPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[363].Descriptor()
}

func (ResourcePolicyWorkloadPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[363]
}

func (x ResourcePolicyWorkloadPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicyWorkloadPolicy_Type.Descriptor instead.
func (ResourcePolicyWorkloadPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1422, 1}
}

type ResourceStatusShutdownDetails_StopState int32

const (
	// A value indicating that the enum field is not set.
	ResourceStatusShutdownDetails_UNDEFINED_STOP_STATE ResourceStatusShutdownDetails_StopState = 0
	ResourceStatusShutdownDetails_PENDING_STOP         ResourceStatusShutdownDetails_StopState = 362509770
	ResourceStatusShutdownDetails_STOPPING             ResourceStatusShutdownDetails_StopState = 350791796
)

// Enum value maps for ResourceStatusShutdownDetails_StopState.
var (
	ResourceStatusShutdownDetails_StopState_name = map[int32]string{
		0:         "UNDEFINED_STOP_STATE",
		362509770: "PENDING_STOP",
		350791796: "STOPPING",
	}
	ResourceStatusShutdownDetails_StopState_value = map[string]int32{
		"UNDEFINED_STOP_STATE": 0,
		"PENDING_STOP":         362509770,
		"STOPPING":             350791796,
	}
)

func (x ResourceStatusShutdownDetails_StopState) Enum() *ResourceStatusShutdownDetails_StopState {
	p := new(ResourceStatusShutdownDetails_StopState)
	*p = x
	return p
}

func (x ResourceStatusShutdownDetails_StopState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceStatusShutdownDetails_StopState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[364].Descriptor()
}

func (ResourceStatusShutdownDetails_StopState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[364]
}

func (x ResourceStatusShutdownDetails_StopState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceStatusShutdownDetails_StopState.Descriptor instead.
func (ResourceStatusShutdownDetails_StopState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1427, 0}
}

type ResourceStatusShutdownDetails_TargetState int32

const (
	// A value indicating that the enum field is not set.
	ResourceStatusShutdownDetails_UNDEFINED_TARGET_STATE ResourceStatusShutdownDetails_TargetState = 0
	ResourceStatusShutdownDetails_DELETED                ResourceStatusShutdownDetails_TargetState = 120962041
	ResourceStatusShutdownDetails_STOPPED                ResourceStatusShutdownDetails_TargetState = 444276141
)

// Enum value maps for ResourceStatusShutdownDetails_TargetState.
var (
	ResourceStatusShutdownDetails_TargetState_name = map[int32]string{
		0:         "UNDEFINED_TARGET_STATE",
		120962041: "DELETED",
		444276141: "STOPPED",
	}
	ResourceStatusShutdownDetails_TargetState_value = map[string]int32{
		"UNDEFINED_TARGET_STATE": 0,
		"DELETED":                120962041,
		"STOPPED":                444276141,
	}
)

func (x ResourceStatusShutdownDetails_TargetState) Enum() *ResourceStatusShutdownDetails_TargetState {
	p := new(ResourceStatusShutdownDetails_TargetState)
	*p = x
	return p
}

func (x ResourceStatusShutdownDetails_TargetState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceStatusShutdownDetails_TargetState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[365].Descriptor()
}

func (ResourceStatusShutdownDetails_TargetState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[365]
}

func (x ResourceStatusShutdownDetails_TargetState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceStatusShutdownDetails_TargetState.Descriptor instead.
func (ResourceStatusShutdownDetails_TargetState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1427, 1}
}

// [Output Only] Indicates the origin of the route. Can be IGP (Interior Gateway Protocol), EGP (Exterior Gateway Protocol), or INCOMPLETE.
type Route_NextHopOrigin int32

const (
	// A value indicating that the enum field is not set.
	Route_UNDEFINED_NEXT_HOP_ORIGIN Route_NextHopOrigin = 0
	Route_EGP                       Route_NextHopOrigin = 68590
	Route_IGP                       Route_NextHopOrigin = 72434
	Route_INCOMPLETE                Route_NextHopOrigin = 11941214
)

// Enum value maps for Route_NextHopOrigin.
var (
	Route_NextHopOrigin_name = map[int32]string{
		0:        "UNDEFINED_NEXT_HOP_ORIGIN",
		68590:    "EGP",
		72434:    "IGP",
		11941214: "INCOMPLETE",
	}
	Route_NextHopOrigin_value = map[string]int32{
		"UNDEFINED_NEXT_HOP_ORIGIN": 0,
		"EGP":                       68590,
		"IGP":                       72434,
		"INCOMPLETE":                11941214,
	}
)

func (x Route_NextHopOrigin) Enum() *Route_NextHopOrigin {
	p := new(Route_NextHopOrigin)
	*p = x
	return p
}

func (x Route_NextHopOrigin) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Route_NextHopOrigin) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[366].Descriptor()
}

func (Route_NextHopOrigin) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[366]
}

func (x Route_NextHopOrigin) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Route_NextHopOrigin.Descriptor instead.
func (Route_NextHopOrigin) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1432, 0}
}

// [Output only] The status of the route.
type Route_RouteStatus int32

const (
	// A value indicating that the enum field is not set.
	Route_UNDEFINED_ROUTE_STATUS Route_RouteStatus = 0
	// This route is processed and active.
	Route_ACTIVE Route_RouteStatus = 314733318
	// The route is dropped due to the VPC exceeding the dynamic route limit. For dynamic route limit, please refer to the Learned route example
	Route_DROPPED Route_RouteStatus = 496235424
	// This route is processed but inactive due to failure from the backend. The backend may have rejected the route
	Route_INACTIVE Route_RouteStatus = 270421099
	// This route is being processed internally. The status will change once processed.
	Route_PENDING Route_RouteStatus = 35394935
)

// Enum value maps for Route_RouteStatus.
var (
	Route_RouteStatus_name = map[int32]string{
		0:         "UNDEFINED_ROUTE_STATUS",
		314733318: "ACTIVE",
		496235424: "DROPPED",
		270421099: "INACTIVE",
		35394935:  "PENDING",
	}
	Route_RouteStatus_value = map[string]int32{
		"UNDEFINED_ROUTE_STATUS": 0,
		"ACTIVE":                 314733318,
		"DROPPED":                496235424,
		"INACTIVE":               270421099,
		"PENDING":                35394935,
	}
)

func (x Route_RouteStatus) Enum() *Route_RouteStatus {
	p := new(Route_RouteStatus)
	*p = x
	return p
}

func (x Route_RouteStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Route_RouteStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[367].Descriptor()
}

func (Route_RouteStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[367]
}

func (x Route_RouteStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Route_RouteStatus.Descriptor instead.
func (Route_RouteStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1432, 1}
}

// [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
type Route_RouteType int32

const (
	// A value indicating that the enum field is not set.
	Route_UNDEFINED_ROUTE_TYPE Route_RouteType = 0
	Route_BGP                  Route_RouteType = 65707
	Route_STATIC               Route_RouteType = 308331118
	Route_SUBNET               Route_RouteType = 309278557
	Route_TRANSIT              Route_RouteType = 187793843
)

// Enum value maps for Route_RouteType.
var (
	Route_RouteType_name = map[int32]string{
		0:         "UNDEFINED_ROUTE_TYPE",
		65707:     "BGP",
		308331118: "STATIC",
		309278557: "SUBNET",
		187793843: "TRANSIT",
	}
	Route_RouteType_value = map[string]int32{
		"UNDEFINED_ROUTE_TYPE": 0,
		"BGP":                  65707,
		"STATIC":               308331118,
		"SUBNET":               309278557,
		"TRANSIT":              187793843,
	}
)

func (x Route_RouteType) Enum() *Route_RouteType {
	p := new(Route_RouteType)
	*p = x
	return p
}

func (x Route_RouteType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Route_RouteType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[368].Descriptor()
}

func (Route_RouteType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[368]
}

func (x Route_RouteType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Route_RouteType.Descriptor instead.
func (Route_RouteType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1432, 2}
}

// [Output Only] The type of the AS Path, which can be one of the following values: - 'AS_SET': unordered set of autonomous systems that the route in has traversed - 'AS_SEQUENCE': ordered set of autonomous systems that the route has traversed - 'AS_CONFED_SEQUENCE': ordered set of Member Autonomous Systems in the local confederation that the route has traversed - 'AS_CONFED_SET': unordered set of Member Autonomous Systems in the local confederation that the route has traversed
type RouteAsPath_PathSegmentType int32

const (
	// A value indicating that the enum field is not set.
	RouteAsPath_UNDEFINED_PATH_SEGMENT_TYPE RouteAsPath_PathSegmentType = 0
	RouteAsPath_AS_CONFED_SEQUENCE          RouteAsPath_PathSegmentType = 222152624
	RouteAsPath_AS_CONFED_SET               RouteAsPath_PathSegmentType = 374040307
	RouteAsPath_AS_SEQUENCE                 RouteAsPath_PathSegmentType = 106735918
	RouteAsPath_AS_SET                      RouteAsPath_PathSegmentType = 329846453
)

// Enum value maps for RouteAsPath_PathSegmentType.
var (
	RouteAsPath_PathSegmentType_name = map[int32]string{
		0:         "UNDEFINED_PATH_SEGMENT_TYPE",
		222152624: "AS_CONFED_SEQUENCE",
		374040307: "AS_CONFED_SET",
		106735918: "AS_SEQUENCE",
		329846453: "AS_SET",
	}
	RouteAsPath_PathSegmentType_value = map[string]int32{
		"UNDEFINED_PATH_SEGMENT_TYPE": 0,
		"AS_CONFED_SEQUENCE":          222152624,
		"AS_CONFED_SET":               374040307,
		"AS_SEQUENCE":                 106735918,
		"AS_SET":                      329846453,
	}
)

func (x RouteAsPath_PathSegmentType) Enum() *RouteAsPath_PathSegmentType {
	p := new(RouteAsPath_PathSegmentType)
	*p = x
	return p
}

func (x RouteAsPath_PathSegmentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouteAsPath_PathSegmentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[369].Descriptor()
}

func (RouteAsPath_PathSegmentType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[369]
}

func (x RouteAsPath_PathSegmentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouteAsPath_PathSegmentType.Descriptor instead.
func (RouteAsPath_PathSegmentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1433, 0}
}

type RoutePolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	RoutePolicy_UNDEFINED_TYPE RoutePolicy_Type = 0
	// The Route Policy is an Export Policy.
	RoutePolicy_ROUTE_POLICY_TYPE_EXPORT RoutePolicy_Type = 293086882
	// The Route Policy is an Import Policy.
	RoutePolicy_ROUTE_POLICY_TYPE_IMPORT RoutePolicy_Type = 397444755
)

// Enum value maps for RoutePolicy_Type.
var (
	RoutePolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		293086882: "ROUTE_POLICY_TYPE_EXPORT",
		397444755: "ROUTE_POLICY_TYPE_IMPORT",
	}
	RoutePolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE":           0,
		"ROUTE_POLICY_TYPE_EXPORT": 293086882,
		"ROUTE_POLICY_TYPE_IMPORT": 397444755,
	}
)

func (x RoutePolicy_Type) Enum() *RoutePolicy_Type {
	p := new(RoutePolicy_Type)
	*p = x
	return p
}

func (x RoutePolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RoutePolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[370].Descriptor()
}

func (RoutePolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[370]
}

func (x RoutePolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RoutePolicy_Type.Descriptor instead.
func (RoutePolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1436, 0}
}

// User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
type RouterBgp_AdvertiseMode int32

const (
	// A value indicating that the enum field is not set.
	RouterBgp_UNDEFINED_ADVERTISE_MODE RouterBgp_AdvertiseMode = 0
	RouterBgp_CUSTOM                   RouterBgp_AdvertiseMode = 388595569
	RouterBgp_DEFAULT                  RouterBgp_AdvertiseMode = 115302945
)

// Enum value maps for RouterBgp_AdvertiseMode.
var (
	RouterBgp_AdvertiseMode_name = map[int32]string{
		0:         "UNDEFINED_ADVERTISE_MODE",
		388595569: "CUSTOM",
		115302945: "DEFAULT",
	}
	RouterBgp_AdvertiseMode_value = map[string]int32{
		"UNDEFINED_ADVERTISE_MODE": 0,
		"CUSTOM":                   388595569,
		"DEFAULT":                  115302945,
	}
)

func (x RouterBgp_AdvertiseMode) Enum() *RouterBgp_AdvertiseMode {
	p := new(RouterBgp_AdvertiseMode)
	*p = x
	return p
}

func (x RouterBgp_AdvertiseMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgp_AdvertiseMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[371].Descriptor()
}

func (RouterBgp_AdvertiseMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[371]
}

func (x RouterBgp_AdvertiseMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgp_AdvertiseMode.Descriptor instead.
func (RouterBgp_AdvertiseMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1441, 0}
}

type RouterBgp_AdvertisedGroups int32

const (
	// A value indicating that the enum field is not set.
	RouterBgp_UNDEFINED_ADVERTISED_GROUPS RouterBgp_AdvertisedGroups = 0
	// Advertise all available subnets (including peer VPC subnets).
	RouterBgp_ALL_SUBNETS RouterBgp_AdvertisedGroups = 3622872
)

// Enum value maps for RouterBgp_AdvertisedGroups.
var (
	RouterBgp_AdvertisedGroups_name = map[int32]string{
		0:       "UNDEFINED_ADVERTISED_GROUPS",
		3622872: "ALL_SUBNETS",
	}
	RouterBgp_AdvertisedGroups_value = map[string]int32{
		"UNDEFINED_ADVERTISED_GROUPS": 0,
		"ALL_SUBNETS":                 3622872,
	}
)

func (x RouterBgp_AdvertisedGroups) Enum() *RouterBgp_AdvertisedGroups {
	p := new(RouterBgp_AdvertisedGroups)
	*p = x
	return p
}

func (x RouterBgp_AdvertisedGroups) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgp_AdvertisedGroups) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[372].Descriptor()
}

func (RouterBgp_AdvertisedGroups) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[372]
}

func (x RouterBgp_AdvertisedGroups) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgp_AdvertisedGroups.Descriptor instead.
func (RouterBgp_AdvertisedGroups) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1441, 1}
}

// User-specified flag to indicate which mode to use for advertisement.
type RouterBgpPeer_AdvertiseMode int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_ADVERTISE_MODE RouterBgpPeer_AdvertiseMode = 0
	RouterBgpPeer_CUSTOM                   RouterBgpPeer_AdvertiseMode = 388595569
	RouterBgpPeer_DEFAULT                  RouterBgpPeer_AdvertiseMode = 115302945
)

// Enum value maps for RouterBgpPeer_AdvertiseMode.
var (
	RouterBgpPeer_AdvertiseMode_name = map[int32]string{
		0:         "UNDEFINED_ADVERTISE_MODE",
		388595569: "CUSTOM",
		115302945: "DEFAULT",
	}
	RouterBgpPeer_AdvertiseMode_value = map[string]int32{
		"UNDEFINED_ADVERTISE_MODE": 0,
		"CUSTOM":                   388595569,
		"DEFAULT":                  115302945,
	}
)

func (x RouterBgpPeer_AdvertiseMode) Enum() *RouterBgpPeer_AdvertiseMode {
	p := new(RouterBgpPeer_AdvertiseMode)
	*p = x
	return p
}

func (x RouterBgpPeer_AdvertiseMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_AdvertiseMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[373].Descriptor()
}

func (RouterBgpPeer_AdvertiseMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[373]
}

func (x RouterBgpPeer_AdvertiseMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_AdvertiseMode.Descriptor instead.
func (RouterBgpPeer_AdvertiseMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1442, 0}
}

type RouterBgpPeer_AdvertisedGroups int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_ADVERTISED_GROUPS RouterBgpPeer_AdvertisedGroups = 0
	// Advertise all available subnets (including peer VPC subnets).
	RouterBgpPeer_ALL_SUBNETS RouterBgpPeer_AdvertisedGroups = 3622872
)

// Enum value maps for RouterBgpPeer_AdvertisedGroups.
var (
	RouterBgpPeer_AdvertisedGroups_name = map[int32]string{
		0:       "UNDEFINED_ADVERTISED_GROUPS",
		3622872: "ALL_SUBNETS",
	}
	RouterBgpPeer_AdvertisedGroups_value = map[string]int32{
		"UNDEFINED_ADVERTISED_GROUPS": 0,
		"ALL_SUBNETS":                 3622872,
	}
)

func (x RouterBgpPeer_AdvertisedGroups) Enum() *RouterBgpPeer_AdvertisedGroups {
	p := new(RouterBgpPeer_AdvertisedGroups)
	*p = x
	return p
}

func (x RouterBgpPeer_AdvertisedGroups) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_AdvertisedGroups) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[374].Descriptor()
}

func (RouterBgpPeer_AdvertisedGroups) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[374]
}

func (x RouterBgpPeer_AdvertisedGroups) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_AdvertisedGroups.Descriptor instead.
func (RouterBgpPeer_AdvertisedGroups) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1442, 1}
}

// The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
type RouterBgpPeer_Enable int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_ENABLE RouterBgpPeer_Enable = 0
	RouterBgpPeer_FALSE            RouterBgpPeer_Enable = 66658563
	RouterBgpPeer_TRUE             RouterBgpPeer_Enable = 2583950
)

// Enum value maps for RouterBgpPeer_Enable.
var (
	RouterBgpPeer_Enable_name = map[int32]string{
		0:        "UNDEFINED_ENABLE",
		66658563: "FALSE",
		2583950:  "TRUE",
	}
	RouterBgpPeer_Enable_value = map[string]int32{
		"UNDEFINED_ENABLE": 0,
		"FALSE":            66658563,
		"TRUE":             2583950,
	}
)

func (x RouterBgpPeer_Enable) Enum() *RouterBgpPeer_Enable {
	p := new(RouterBgpPeer_Enable)
	*p = x
	return p
}

func (x RouterBgpPeer_Enable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_Enable) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[375].Descriptor()
}

func (RouterBgpPeer_Enable) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[375]
}

func (x RouterBgpPeer_Enable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_Enable.Descriptor instead.
func (RouterBgpPeer_Enable) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1442, 2}
}

// [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
type RouterBgpPeer_ManagementType int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_MANAGEMENT_TYPE RouterBgpPeer_ManagementType = 0
	// The BGP peer is automatically created for PARTNER type InterconnectAttachment; Google will automatically create/delete this BGP peer when the PARTNER InterconnectAttachment is created/deleted, and Google will update the ipAddress and peerIpAddress when the PARTNER InterconnectAttachment is provisioned. This type of BGP peer cannot be created or deleted, but can be modified for all fields except for name, ipAddress and peerIpAddress.
	RouterBgpPeer_MANAGED_BY_ATTACHMENT RouterBgpPeer_ManagementType = 458926411
	// Default value, the BGP peer is manually created and managed by user.
	RouterBgpPeer_MANAGED_BY_USER RouterBgpPeer_ManagementType = 317294067
)

// Enum value maps for RouterBgpPeer_ManagementType.
var (
	RouterBgpPeer_ManagementType_name = map[int32]string{
		0:         "UNDEFINED_MANAGEMENT_TYPE",
		458926411: "MANAGED_BY_ATTACHMENT",
		317294067: "MANAGED_BY_USER",
	}
	RouterBgpPeer_ManagementType_value = map[string]int32{
		"UNDEFINED_MANAGEMENT_TYPE": 0,
		"MANAGED_BY_ATTACHMENT":     458926411,
		"MANAGED_BY_USER":           317294067,
	}
)

func (x RouterBgpPeer_ManagementType) Enum() *RouterBgpPeer_ManagementType {
	p := new(RouterBgpPeer_ManagementType)
	*p = x
	return p
}

func (x RouterBgpPeer_ManagementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_ManagementType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[376].Descriptor()
}

func (RouterBgpPeer_ManagementType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[376]
}

func (x RouterBgpPeer_ManagementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_ManagementType.Descriptor instead.
func (RouterBgpPeer_ManagementType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1442, 3}
}

// The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
type RouterBgpPeerBfd_SessionInitializationMode int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeerBfd_UNDEFINED_SESSION_INITIALIZATION_MODE RouterBgpPeerBfd_SessionInitializationMode = 0
	RouterBgpPeerBfd_ACTIVE                                RouterBgpPeerBfd_SessionInitializationMode = 314733318
	RouterBgpPeerBfd_DISABLED                              RouterBgpPeerBfd_SessionInitializationMode = 516696700
	RouterBgpPeerBfd_PASSIVE                               RouterBgpPeerBfd_SessionInitializationMode = 462813959
)

// Enum value maps for RouterBgpPeerBfd_SessionInitializationMode.
var (
	RouterBgpPeerBfd_SessionInitializationMode_name = map[int32]string{
		0:         "UNDEFINED_SESSION_INITIALIZATION_MODE",
		314733318: "ACTIVE",
		516696700: "DISABLED",
		462813959: "PASSIVE",
	}
	RouterBgpPeerBfd_SessionInitializationMode_value = map[string]int32{
		"UNDEFINED_SESSION_INITIALIZATION_MODE": 0,
		"ACTIVE":                                314733318,
		"DISABLED":                              516696700,
		"PASSIVE":                               462813959,
	}
)

func (x RouterBgpPeerBfd_SessionInitializationMode) Enum() *RouterBgpPeerBfd_SessionInitializationMode {
	p := new(RouterBgpPeerBfd_SessionInitializationMode)
	*p = x
	return p
}

func (x RouterBgpPeerBfd_SessionInitializationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeerBfd_SessionInitializationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[377].Descriptor()
}

func (RouterBgpPeerBfd_SessionInitializationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[377]
}

func (x RouterBgpPeerBfd_SessionInitializationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeerBfd_SessionInitializationMode.Descriptor instead.
func (RouterBgpPeerBfd_SessionInitializationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1443, 0}
}

// IP version of this interface.
type RouterInterface_IpVersion int32

const (
	// A value indicating that the enum field is not set.
	RouterInterface_UNDEFINED_IP_VERSION RouterInterface_IpVersion = 0
	RouterInterface_IPV4                 RouterInterface_IpVersion = 2254341
	RouterInterface_IPV6                 RouterInterface_IpVersion = 2254343
)

// Enum value maps for RouterInterface_IpVersion.
var (
	RouterInterface_IpVersion_name = map[int32]string{
		0:       "UNDEFINED_IP_VERSION",
		2254341: "IPV4",
		2254343: "IPV6",
	}
	RouterInterface_IpVersion_value = map[string]int32{
		"UNDEFINED_IP_VERSION": 0,
		"IPV4":                 2254341,
		"IPV6":                 2254343,
	}
)

func (x RouterInterface_IpVersion) Enum() *RouterInterface_IpVersion {
	p := new(RouterInterface_IpVersion)
	*p = x
	return p
}

func (x RouterInterface_IpVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterInterface_IpVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[378].Descriptor()
}

func (RouterInterface_IpVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[378]
}

func (x RouterInterface_IpVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterInterface_IpVersion.Descriptor instead.
func (RouterInterface_IpVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1445, 0}
}

// [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
type RouterInterface_ManagementType int32

const (
	// A value indicating that the enum field is not set.
	RouterInterface_UNDEFINED_MANAGEMENT_TYPE RouterInterface_ManagementType = 0
	// The interface is automatically created for PARTNER type InterconnectAttachment, Google will automatically create/update/delete this interface when the PARTNER InterconnectAttachment is created/provisioned/deleted. This type of interface cannot be manually managed by user.
	RouterInterface_MANAGED_BY_ATTACHMENT RouterInterface_ManagementType = 458926411
	// Default value, the interface is manually created and managed by user.
	RouterInterface_MANAGED_BY_USER RouterInterface_ManagementType = 317294067
)

// Enum value maps for RouterInterface_ManagementType.
var (
	RouterInterface_ManagementType_name = map[int32]string{
		0:         "UNDEFINED_MANAGEMENT_TYPE",
		458926411: "MANAGED_BY_ATTACHMENT",
		317294067: "MANAGED_BY_USER",
	}
	RouterInterface_ManagementType_value = map[string]int32{
		"UNDEFINED_MANAGEMENT_TYPE": 0,
		"MANAGED_BY_ATTACHMENT":     458926411,
		"MANAGED_BY_USER":           317294067,
	}
)

func (x RouterInterface_ManagementType) Enum() *RouterInterface_ManagementType {
	p := new(RouterInterface_ManagementType)
	*p = x
	return p
}

func (x RouterInterface_ManagementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterInterface_ManagementType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[379].Descriptor()
}

func (RouterInterface_ManagementType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[379]
}

func (x RouterInterface_ManagementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterInterface_ManagementType.Descriptor instead.
func (RouterInterface_ManagementType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1445, 1}
}

// The network tier to use when automatically reserving NAT IP addresses. Must be one of: PREMIUM, STANDARD. If not specified, then the current project-level default tier is used.
type RouterNat_AutoNetworkTier int32

const (
	// A value indicating that the enum field is not set.
	RouterNat_UNDEFINED_AUTO_NETWORK_TIER RouterNat_AutoNetworkTier = 0
	// Public internet quality with fixed bandwidth.
	RouterNat_FIXED_STANDARD RouterNat_AutoNetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	RouterNat_PREMIUM RouterNat_AutoNetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	RouterNat_STANDARD RouterNat_AutoNetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	RouterNat_STANDARD_OVERRIDES_FIXED_STANDARD RouterNat_AutoNetworkTier = 465847234
)

// Enum value maps for RouterNat_AutoNetworkTier.
var (
	RouterNat_AutoNetworkTier_name = map[int32]string{
		0:         "UNDEFINED_AUTO_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	RouterNat_AutoNetworkTier_value = map[string]int32{
		"UNDEFINED_AUTO_NETWORK_TIER":       0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x RouterNat_AutoNetworkTier) Enum() *RouterNat_AutoNetworkTier {
	p := new(RouterNat_AutoNetworkTier)
	*p = x
	return p
}

func (x RouterNat_AutoNetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNat_AutoNetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[380].Descriptor()
}

func (RouterNat_AutoNetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[380]
}

func (x RouterNat_AutoNetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNat_AutoNetworkTier.Descriptor instead.
func (RouterNat_AutoNetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1448, 0}
}

type RouterNat_EndpointTypes int32

const (
	// A value indicating that the enum field is not set.
	RouterNat_UNDEFINED_ENDPOINT_TYPES RouterNat_EndpointTypes = 0
	// This is used for regional Application Load Balancers (internal and external) and regional proxy Network Load Balancers (internal and external) endpoints.
	RouterNat_ENDPOINT_TYPE_MANAGED_PROXY_LB RouterNat_EndpointTypes = 439196930
	// This is used for Secure Web Gateway endpoints.
	RouterNat_ENDPOINT_TYPE_SWG RouterNat_EndpointTypes = 159344456
	// This is the default.
	RouterNat_ENDPOINT_TYPE_VM RouterNat_EndpointTypes = 57095474
)

// Enum value maps for RouterNat_EndpointTypes.
var (
	RouterNat_EndpointTypes_name = map[int32]string{
		0:         "UNDEFINED_ENDPOINT_TYPES",
		439196930: "ENDPOINT_TYPE_MANAGED_PROXY_LB",
		159344456: "ENDPOINT_TYPE_SWG",
		57095474:  "ENDPOINT_TYPE_VM",
	}
	RouterNat_EndpointTypes_value = map[string]int32{
		"UNDEFINED_ENDPOINT_TYPES":       0,
		"ENDPOINT_TYPE_MANAGED_PROXY_LB": 439196930,
		"ENDPOINT_TYPE_SWG":              159344456,
		"ENDPOINT_TYPE_VM":               57095474,
	}
)

func (x RouterNat_EndpointTypes) Enum() *RouterNat_EndpointTypes {
	p := new(RouterNat_EndpointTypes)
	*p = x
	return p
}

func (x RouterNat_EndpointTypes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNat_EndpointTypes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[381].Descriptor()
}

func (RouterNat_EndpointTypes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[381]
}

func (x RouterNat_EndpointTypes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNat_EndpointTypes.Descriptor instead.
func (RouterNat_EndpointTypes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1448, 1}
}

// Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
type RouterNat_NatIpAllocateOption int32

const (
	// A value indicating that the enum field is not set.
	RouterNat_UNDEFINED_NAT_IP_ALLOCATE_OPTION RouterNat_NatIpAllocateOption = 0
	// Nat IPs are allocated by GCP; customers can not specify any Nat IPs.
	RouterNat_AUTO_ONLY RouterNat_NatIpAllocateOption = 182333500
	// Only use Nat IPs provided by customers. When specified Nat IPs are not enough then the Nat service fails for new VMs.
	RouterNat_MANUAL_ONLY RouterNat_NatIpAllocateOption = 261251205
)

// Enum value maps for RouterNat_NatIpAllocateOption.
var (
	RouterNat_NatIpAllocateOption_name = map[int32]string{
		0:         "UNDEFINED_NAT_IP_ALLOCATE_OPTION",
		182333500: "AUTO_ONLY",
		261251205: "MANUAL_ONLY",
	}
	RouterNat_NatIpAllocateOption_value = map[string]int32{
		"UNDEFINED_NAT_IP_ALLOCATE_OPTION": 0,
		"AUTO_ONLY":                        182333500,
		"MANUAL_ONLY":                      261251205,
	}
)

func (x RouterNat_NatIpAllocateOption) Enum() *RouterNat_NatIpAllocateOption {
	p := new(RouterNat_NatIpAllocateOption)
	*p = x
	return p
}

func (x RouterNat_NatIpAllocateOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNat_NatIpAllocateOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[382].Descriptor()
}

func (RouterNat_NatIpAllocateOption) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[382]
}

func (x RouterNat_NatIpAllocateOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNat_NatIpAllocateOption.Descriptor instead.
func (RouterNat_NatIpAllocateOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1448, 2}
}

// Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES then there should not be any other Router.Nat section in any Router for this network in this region.
type RouterNat_SourceSubnetworkIpRangesToNat int32

const (
	// A value indicating that the enum field is not set.
	RouterNat_UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT RouterNat_SourceSubnetworkIpRangesToNat = 0
	// All the IP ranges in every Subnetwork are allowed to Nat.
	RouterNat_ALL_SUBNETWORKS_ALL_IP_RANGES RouterNat_SourceSubnetworkIpRangesToNat = 179964376
	// All the primary IP ranges in every Subnetwork are allowed to Nat.
	RouterNat_ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES RouterNat_SourceSubnetworkIpRangesToNat = 185573819
	// A list of Subnetworks are allowed to Nat (specified in the field subnetwork below)
	RouterNat_LIST_OF_SUBNETWORKS RouterNat_SourceSubnetworkIpRangesToNat = 517542270
)

// Enum value maps for RouterNat_SourceSubnetworkIpRangesToNat.
var (
	RouterNat_SourceSubnetworkIpRangesToNat_name = map[int32]string{
		0:         "UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT",
		179964376: "ALL_SUBNETWORKS_ALL_IP_RANGES",
		185573819: "ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES",
		517542270: "LIST_OF_SUBNETWORKS",
	}
	RouterNat_SourceSubnetworkIpRangesToNat_value = map[string]int32{
		"UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT": 0,
		"ALL_SUBNETWORKS_ALL_IP_RANGES":                179964376,
		"ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES":        185573819,
		"LIST_OF_SUBNETWORKS":                          517542270,
	}
)

func (x RouterNat_SourceSubnetworkIpRangesToNat) Enum() *RouterNat_SourceSubnetworkIpRangesToNat {
	p := new(RouterNat_SourceSubnetworkIpRangesToNat)
	*p = x
	return p
}

func (x RouterNat_SourceSubnetworkIpRangesToNat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNat_SourceSubnetworkIpRangesToNat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1beta_compute_proto_enumTypes[383].Descriptor()
}

func (RouterNat_SourceSubnetworkIpRangesToNat) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1beta_compute_proto_enumTypes[383]
}

func (x RouterNat_SourceSubnetworkIpRangesToNat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNat_SourceSubnetworkIpRangesToNat.Descriptor instead.
func (RouterNat_SourceSubnetworkIpRangesToNat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1beta_compute_proto_rawDescGZIP(), []int{1448, 3}
}

// Specify the Nat option for NAT64, which can take one of the following values: - ALL_IPV6_SUBNETWORKS: All of the IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_IPV6_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field nat64_subnetwork below) The default is NAT64_OPTION_UNSPECIFIED. 