// Licensed to ClickHouse, Inc. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. ClickHouse, Inc. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by make codegen DO NOT EDIT.
// source: lib/column/codegen/array.tpl

package column

import (
	"database/sql"
    "database/sql/driver"
	"github.com/ClickHouse/ch-go/proto"
	"github.com/google/uuid"
	"github.com/paulmach/orb"
	"github.com/shopspring/decimal"
	"math/big"
	"net"
	"net/netip"
	"time"
	"fmt"
)

// appendRowPlain is a reflection-free realisation of append for plain arrays.
func (col *Array) appendRowPlain(v any) error {
	switch tv := v.(type) {
	{{- range . }}
	case []{{ . }}:
		return appendRowPlain(col, tv)
	case []*{{ . }}:
		return appendNullableRowPlain(col, tv)
	{{- end }}
	default:
	    if valuer, ok := v.(driver.Valuer); ok {
            val, err := valuer.Value()
            if err != nil {
                return &ColumnConverterError{
                    Op:   "AppendRow",
                    To:   "Array",
                    From: fmt.Sprintf("%T", v),
                    Hint: "could not get driver.Valuer value",
                }
            }
            return col.appendRowPlain(val)
        }
		return col.appendRowDefault(v)
	}
}
