// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package api

import (
	"fmt"
	"io"
	"math"
	"sort"

	cid "github.com/ipfs/go-cid"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

func (t *CreateOp) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 7

	if t.Sig == "" {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Sig (string) (string)
	if t.Sig != "" {

		if len("sig") > 1000000 {
			return xerrors.Errorf("Value in field \"sig\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("sig"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("sig")); err != nil {
			return err
		}

		if len(t.Sig) > 1000000 {
			return xerrors.Errorf("Value in field t.Sig was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Sig))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string(t.Sig)); err != nil {
			return err
		}
	}

	// t.Prev (string) (string)
	if len("prev") > 1000000 {
		return xerrors.Errorf("Value in field \"prev\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("prev"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("prev")); err != nil {
		return err
	}

	if t.Prev == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if len(*t.Prev) > 1000000 {
			return xerrors.Errorf("Value in field t.Prev was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Prev))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string(*t.Prev)); err != nil {
			return err
		}
	}

	// t.Type (string) (string)
	if len("type") > 1000000 {
		return xerrors.Errorf("Value in field \"type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("type")); err != nil {
		return err
	}

	if len(t.Type) > 1000000 {
		return xerrors.Errorf("Value in field t.Type was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Type))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Type)); err != nil {
		return err
	}

	// t.Handle (string) (string)
	if len("handle") > 1000000 {
		return xerrors.Errorf("Value in field \"handle\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("handle"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("handle")); err != nil {
		return err
	}

	if len(t.Handle) > 1000000 {
		return xerrors.Errorf("Value in field t.Handle was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Handle))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Handle)); err != nil {
		return err
	}

	// t.Service (string) (string)
	if len("service") > 1000000 {
		return xerrors.Errorf("Value in field \"service\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("service"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("service")); err != nil {
		return err
	}

	if len(t.Service) > 1000000 {
		return xerrors.Errorf("Value in field t.Service was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Service))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Service)); err != nil {
		return err
	}

	// t.SigningKey (string) (string)
	if len("signingKey") > 1000000 {
		return xerrors.Errorf("Value in field \"signingKey\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("signingKey"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("signingKey")); err != nil {
		return err
	}

	if len(t.SigningKey) > 1000000 {
		return xerrors.Errorf("Value in field t.SigningKey was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.SigningKey))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.SigningKey)); err != nil {
		return err
	}

	// t.RecoveryKey (string) (string)
	if len("recoveryKey") > 1000000 {
		return xerrors.Errorf("Value in field \"recoveryKey\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("recoveryKey"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("recoveryKey")); err != nil {
		return err
	}

	if len(t.RecoveryKey) > 1000000 {
		return xerrors.Errorf("Value in field t.RecoveryKey was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.RecoveryKey))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.RecoveryKey)); err != nil {
		return err
	}
	return nil
}

func (t *CreateOp) UnmarshalCBOR(r io.Reader) (err error) {
	*t = CreateOp{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("CreateOp: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Sig (string) (string)
		case "sig":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Sig = string(sval)
			}
			// t.Prev (string) (string)
		case "prev":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.Prev = (*string)(&sval)
				}
			}
			// t.Type (string) (string)
		case "type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Type = string(sval)
			}
			// t.Handle (string) (string)
		case "handle":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Handle = string(sval)
			}
			// t.Service (string) (string)
		case "service":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Service = string(sval)
			}
			// t.SigningKey (string) (string)
		case "signingKey":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.SigningKey = string(sval)
			}
			// t.RecoveryKey (string) (string)
		case "recoveryKey":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.RecoveryKey = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
