// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/assuredworkloads/v1/assuredworkloads.proto

package assuredworkloadspb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AssuredWorkloadsService_CreateWorkload_FullMethodName           = "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/CreateWorkload"
	AssuredWorkloadsService_UpdateWorkload_FullMethodName           = "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/UpdateWorkload"
	AssuredWorkloadsService_RestrictAllowedResources_FullMethodName = "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/RestrictAllowedResources"
	AssuredWorkloadsService_DeleteWorkload_FullMethodName           = "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/DeleteWorkload"
	AssuredWorkloadsService_GetWorkload_FullMethodName              = "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/GetWorkload"
	AssuredWorkloadsService_ListWorkloads_FullMethodName            = "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/ListWorkloads"
	AssuredWorkloadsService_ListViolations_FullMethodName           = "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/ListViolations"
	AssuredWorkloadsService_GetViolation_FullMethodName             = "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/GetViolation"
	AssuredWorkloadsService_AcknowledgeViolation_FullMethodName     = "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/AcknowledgeViolation"
)

// AssuredWorkloadsServiceClient is the client API for AssuredWorkloadsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AssuredWorkloadsServiceClient interface {
	// Creates Assured Workload.
	CreateWorkload(ctx context.Context, in *CreateWorkloadRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing workload.
	// Currently allows updating of workload display_name and labels.
	// For force updates don't set etag field in the Workload.
	// Only one update operation per workload can be in progress.
	UpdateWorkload(ctx context.Context, in *UpdateWorkloadRequest, opts ...grpc.CallOption) (*Workload, error)
	// Restrict the list of resources allowed in the Workload environment.
	// The current list of allowed products can be found at
	// https://cloud.google.com/assured-workloads/docs/supported-products
	// In addition to assuredworkloads.workload.update permission, the user should
	// also have orgpolicy.policy.set permission on the folder resource
	// to use this functionality.
	RestrictAllowedResources(ctx context.Context, in *RestrictAllowedResourcesRequest, opts ...grpc.CallOption) (*RestrictAllowedResourcesResponse, error)
	// Deletes the workload. Make sure that workload's direct children are already
	// in a deleted state, otherwise the request will fail with a
	// FAILED_PRECONDITION error.
	DeleteWorkload(ctx context.Context, in *DeleteWorkloadRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets Assured Workload associated with a CRM Node
	GetWorkload(ctx context.Context, in *GetWorkloadRequest, opts ...grpc.CallOption) (*Workload, error)
	// Lists Assured Workloads under a CRM Node.
	ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error)
	// Lists the Violations in the AssuredWorkload Environment.
	// Callers may also choose to read across multiple Workloads as per
	// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
	// character) as a wildcard character instead of workload-id in the parent.
	// Format `organizations/{org_id}/locations/{location}/workloads/-`
	ListViolations(ctx context.Context, in *ListViolationsRequest, opts ...grpc.CallOption) (*ListViolationsResponse, error)
	// Retrieves Assured Workload Violation based on ID.
	GetViolation(ctx context.Context, in *GetViolationRequest, opts ...grpc.CallOption) (*Violation, error)
	// Acknowledges an existing violation. By acknowledging a violation, users
	// acknowledge the existence of a compliance violation in their workload and
	// decide to ignore it due to a valid business justification. Acknowledgement
	// is a permanent operation and it cannot be reverted.
	AcknowledgeViolation(ctx context.Context, in *AcknowledgeViolationRequest, opts ...grpc.CallOption) (*AcknowledgeViolationResponse, error)
}

type assuredWorkloadsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssuredWorkloadsServiceClient(cc grpc.ClientConnInterface) AssuredWorkloadsServiceClient {
	return &assuredWorkloadsServiceClient{cc}
}

func (c *assuredWorkloadsServiceClient) CreateWorkload(ctx context.Context, in *CreateWorkloadRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_CreateWorkload_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) UpdateWorkload(ctx context.Context, in *UpdateWorkloadRequest, opts ...grpc.CallOption) (*Workload, error) {
	out := new(Workload)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_UpdateWorkload_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) RestrictAllowedResources(ctx context.Context, in *RestrictAllowedResourcesRequest, opts ...grpc.CallOption) (*RestrictAllowedResourcesResponse, error) {
	out := new(RestrictAllowedResourcesResponse)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_RestrictAllowedResources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) DeleteWorkload(ctx context.Context, in *DeleteWorkloadRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_DeleteWorkload_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) GetWorkload(ctx context.Context, in *GetWorkloadRequest, opts ...grpc.CallOption) (*Workload, error) {
	out := new(Workload)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_GetWorkload_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error) {
	out := new(ListWorkloadsResponse)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_ListWorkloads_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) ListViolations(ctx context.Context, in *ListViolationsRequest, opts ...grpc.CallOption) (*ListViolationsResponse, error) {
	out := new(ListViolationsResponse)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_ListViolations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) GetViolation(ctx context.Context, in *GetViolationRequest, opts ...grpc.CallOption) (*Violation, error) {
	out := new(Violation)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_GetViolation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) AcknowledgeViolation(ctx context.Context, in *AcknowledgeViolationRequest, opts ...grpc.CallOption) (*AcknowledgeViolationResponse, error) {
	out := new(AcknowledgeViolationResponse)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_AcknowledgeViolation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssuredWorkloadsServiceServer is the server API for AssuredWorkloadsService service.
// All implementations should embed UnimplementedAssuredWorkloadsServiceServer
// for forward compatibility
type AssuredWorkloadsServiceServer interface {
	// Creates Assured Workload.
	CreateWorkload(context.Context, *CreateWorkloadRequest) (*longrunningpb.Operation, error)
	// Updates an existing workload.
	// Currently allows updating of workload display_name and labels.
	// For force updates don't set etag field in the Workload.
	// Only one update operation per workload can be in progress.
	UpdateWorkload(context.Context, *UpdateWorkloadRequest) (*Workload, error)
	// Restrict the list of resources allowed in the Workload environment.
	// The current list of allowed products can be found at
	// https://cloud.google.com/assured-workloads/docs/supported-products
	// In addition to assuredworkloads.workload.update permission, the user should
	// also have orgpolicy.policy.set permission on the folder resource
	// to use this functionality.
	RestrictAllowedResources(context.Context, *RestrictAllowedResourcesRequest) (*RestrictAllowedResourcesResponse, error)
	// Deletes the workload. Make sure that workload's direct children are already
	// in a deleted state, otherwise the request will fail with a
	// FAILED_PRECONDITION error.
	DeleteWorkload(context.Context, *DeleteWorkloadRequest) (*emptypb.Empty, error)
	// Gets Assured Workload associated with a CRM Node
	GetWorkload(context.Context, *GetWorkloadRequest) (*Workload, error)
	// Lists Assured Workloads under a CRM Node.
	ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error)
	// Lists the Violations in the AssuredWorkload Environment.
	// Callers may also choose to read across multiple Workloads as per
	// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
	// character) as a wildcard character instead of workload-id in the parent.
	// Format `organizations/{org_id}/locations/{location}/workloads/-`
	ListViolations(context.Context, *ListViolationsRequest) (*ListViolationsResponse, error)
	// Retrieves Assured Workload Violation based on ID.
	GetViolation(context.Context, *GetViolationRequest) (*Violation, error)
	// Acknowledges an existing violation. By acknowledging a violation, users
	// acknowledge the existence of a compliance violation in their workload and
	// decide to ignore it due to a valid business justification. Acknowledgement
	// is a permanent operation and it cannot be reverted.
	AcknowledgeViolation(context.Context, *AcknowledgeViolationRequest) (*AcknowledgeViolationResponse, error)
}

// UnimplementedAssuredWorkloadsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAssuredWorkloadsServiceServer struct {
}

func (UnimplementedAssuredWorkloadsServiceServer) CreateWorkload(context.Context, *CreateWorkloadRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkload not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) UpdateWorkload(context.Context, *UpdateWorkloadRequest) (*Workload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkload not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) RestrictAllowedResources(context.Context, *RestrictAllowedResourcesRequest) (*RestrictAllowedResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestrictAllowedResources not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) DeleteWorkload(context.Context, *DeleteWorkloadRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkload not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) GetWorkload(context.Context, *GetWorkloadRequest) (*Workload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkload not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkloads not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) ListViolations(context.Context, *ListViolationsRequest) (*ListViolationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListViolations not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) GetViolation(context.Context, *GetViolationRequest) (*Violation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetViolation not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) AcknowledgeViolation(context.Context, *AcknowledgeViolationRequest) (*AcknowledgeViolationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcknowledgeViolation not implemented")
}

// UnsafeAssuredWorkloadsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AssuredWorkloadsServiceServer will
// result in compilation errors.
type UnsafeAssuredWorkloadsServiceServer interface {
	mustEmbedUnimplementedAssuredWorkloadsServiceServer()
}

func RegisterAssuredWorkloadsServiceServer(s grpc.ServiceRegistrar, srv AssuredWorkloadsServiceServer) {
	s.RegisterService(&AssuredWorkloadsService_ServiceDesc, srv)
}

func _AssuredWorkloadsService_CreateWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).CreateWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_CreateWorkload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).CreateWorkload(ctx, req.(*CreateWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_UpdateWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).UpdateWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_UpdateWorkload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).UpdateWorkload(ctx, req.(*UpdateWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_RestrictAllowedResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestrictAllowedResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).RestrictAllowedResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_RestrictAllowedResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).RestrictAllowedResources(ctx, req.(*RestrictAllowedResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_DeleteWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).DeleteWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_DeleteWorkload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).DeleteWorkload(ctx, req.(*DeleteWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_GetWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).GetWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_GetWorkload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).GetWorkload(ctx, req.(*GetWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_ListWorkloads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkloadsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).ListWorkloads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_ListWorkloads_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).ListWorkloads(ctx, req.(*ListWorkloadsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_ListViolations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListViolationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).ListViolations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_ListViolations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).ListViolations(ctx, req.(*ListViolationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_GetViolation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetViolationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).GetViolation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_GetViolation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).GetViolation(ctx, req.(*GetViolationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_AcknowledgeViolation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeViolationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).AcknowledgeViolation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_AcknowledgeViolation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).AcknowledgeViolation(ctx, req.(*AcknowledgeViolationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AssuredWorkloadsService_ServiceDesc is the grpc.ServiceDesc for AssuredWorkloadsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AssuredWorkloadsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.assuredworkloads.v1.AssuredWorkloadsService",
	HandlerType: (*AssuredWorkloadsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWorkload",
			Handler:    _AssuredWorkloadsService_CreateWorkload_Handler,
		},
		{
			MethodName: "UpdateWorkload",
			Handler:    _AssuredWorkloadsService_UpdateWorkload_Handler,
		},
		{
			MethodName: "RestrictAllowedResources",
			Handler:    _AssuredWorkloadsService_RestrictAllowedResources_Handler,
		},
		{
			MethodName: "DeleteWorkload",
			Handler:    _AssuredWorkloadsService_DeleteWorkload_Handler,
		},
		{
			MethodName: "GetWorkload",
			Handler:    _AssuredWorkloadsService_GetWorkload_Handler,
		},
		{
			MethodName: "ListWorkloads",
			Handler:    _AssuredWorkloadsService_ListWorkloads_Handler,
		},
		{
			MethodName: "ListViolations",
			Handler:    _AssuredWorkloadsService_ListViolations_Handler,
		},
		{
			MethodName: "GetViolation",
			Handler:    _AssuredWorkloadsService_GetViolation_Handler,
		},
		{
			MethodName: "AcknowledgeViolation",
			Handler:    _AssuredWorkloadsService_AcknowledgeViolation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/assuredworkloads/v1/assuredworkloads.proto",
}
