// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/tool.proto

package cxpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Tools_CreateTool_FullMethodName         = "/google.cloud.dialogflow.cx.v3beta1.Tools/CreateTool"
	Tools_ListTools_FullMethodName          = "/google.cloud.dialogflow.cx.v3beta1.Tools/ListTools"
	Tools_ExportTools_FullMethodName        = "/google.cloud.dialogflow.cx.v3beta1.Tools/ExportTools"
	Tools_GetTool_FullMethodName            = "/google.cloud.dialogflow.cx.v3beta1.Tools/GetTool"
	Tools_UpdateTool_FullMethodName         = "/google.cloud.dialogflow.cx.v3beta1.Tools/UpdateTool"
	Tools_DeleteTool_FullMethodName         = "/google.cloud.dialogflow.cx.v3beta1.Tools/DeleteTool"
	Tools_ListToolVersions_FullMethodName   = "/google.cloud.dialogflow.cx.v3beta1.Tools/ListToolVersions"
	Tools_CreateToolVersion_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.Tools/CreateToolVersion"
	Tools_GetToolVersion_FullMethodName     = "/google.cloud.dialogflow.cx.v3beta1.Tools/GetToolVersion"
	Tools_DeleteToolVersion_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.Tools/DeleteToolVersion"
	Tools_RestoreToolVersion_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Tools/RestoreToolVersion"
)

// ToolsClient is the client API for Tools service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ToolsClient interface {
	// Creates a [Tool][google.cloud.dialogflow.cx.v3beta1.Tool] in the specified
	// agent.
	CreateTool(ctx context.Context, in *CreateToolRequest, opts ...grpc.CallOption) (*Tool, error)
	// Returns a list of [Tools][google.cloud.dialogflow.cx.v3beta1.Tool] in the
	// specified agent.
	ListTools(ctx context.Context, in *ListToolsRequest, opts ...grpc.CallOption) (*ListToolsResponse, error)
	// Exports the selected tools.
	ExportTools(ctx context.Context, in *ExportToolsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves the specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	GetTool(ctx context.Context, in *GetToolRequest, opts ...grpc.CallOption) (*Tool, error)
	// Update the specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	UpdateTool(ctx context.Context, in *UpdateToolRequest, opts ...grpc.CallOption) (*Tool, error)
	// Deletes a specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	DeleteTool(ctx context.Context, in *DeleteToolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List versions of the specified
	// [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	ListToolVersions(ctx context.Context, in *ListToolVersionsRequest, opts ...grpc.CallOption) (*ListToolVersionsResponse, error)
	// Creates a version for the specified
	// [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	CreateToolVersion(ctx context.Context, in *CreateToolVersionRequest, opts ...grpc.CallOption) (*ToolVersion, error)
	// Retrieves the specified version of the
	// [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	GetToolVersion(ctx context.Context, in *GetToolVersionRequest, opts ...grpc.CallOption) (*ToolVersion, error)
	// Deletes the specified version of the
	// [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	DeleteToolVersion(ctx context.Context, in *DeleteToolVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Retrieves the specified version of the Tool and stores it as the
	// current tool draft, returning the tool with resources updated.
	RestoreToolVersion(ctx context.Context, in *RestoreToolVersionRequest, opts ...grpc.CallOption) (*RestoreToolVersionResponse, error)
}

type toolsClient struct {
	cc grpc.ClientConnInterface
}

func NewToolsClient(cc grpc.ClientConnInterface) ToolsClient {
	return &toolsClient{cc}
}

func (c *toolsClient) CreateTool(ctx context.Context, in *CreateToolRequest, opts ...grpc.CallOption) (*Tool, error) {
	out := new(Tool)
	err := c.cc.Invoke(ctx, Tools_CreateTool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) ListTools(ctx context.Context, in *ListToolsRequest, opts ...grpc.CallOption) (*ListToolsResponse, error) {
	out := new(ListToolsResponse)
	err := c.cc.Invoke(ctx, Tools_ListTools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) ExportTools(ctx context.Context, in *ExportToolsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Tools_ExportTools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) GetTool(ctx context.Context, in *GetToolRequest, opts ...grpc.CallOption) (*Tool, error) {
	out := new(Tool)
	err := c.cc.Invoke(ctx, Tools_GetTool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) UpdateTool(ctx context.Context, in *UpdateToolRequest, opts ...grpc.CallOption) (*Tool, error) {
	out := new(Tool)
	err := c.cc.Invoke(ctx, Tools_UpdateTool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) DeleteTool(ctx context.Context, in *DeleteToolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Tools_DeleteTool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) ListToolVersions(ctx context.Context, in *ListToolVersionsRequest, opts ...grpc.CallOption) (*ListToolVersionsResponse, error) {
	out := new(ListToolVersionsResponse)
	err := c.cc.Invoke(ctx, Tools_ListToolVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) CreateToolVersion(ctx context.Context, in *CreateToolVersionRequest, opts ...grpc.CallOption) (*ToolVersion, error) {
	out := new(ToolVersion)
	err := c.cc.Invoke(ctx, Tools_CreateToolVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) GetToolVersion(ctx context.Context, in *GetToolVersionRequest, opts ...grpc.CallOption) (*ToolVersion, error) {
	out := new(ToolVersion)
	err := c.cc.Invoke(ctx, Tools_GetToolVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) DeleteToolVersion(ctx context.Context, in *DeleteToolVersionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Tools_DeleteToolVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) RestoreToolVersion(ctx context.Context, in *RestoreToolVersionRequest, opts ...grpc.CallOption) (*RestoreToolVersionResponse, error) {
	out := new(RestoreToolVersionResponse)
	err := c.cc.Invoke(ctx, Tools_RestoreToolVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ToolsServer is the server API for Tools service.
// All implementations should embed UnimplementedToolsServer
// for forward compatibility
type ToolsServer interface {
	// Creates a [Tool][google.cloud.dialogflow.cx.v3beta1.Tool] in the specified
	// agent.
	CreateTool(context.Context, *CreateToolRequest) (*Tool, error)
	// Returns a list of [Tools][google.cloud.dialogflow.cx.v3beta1.Tool] in the
	// specified agent.
	ListTools(context.Context, *ListToolsRequest) (*ListToolsResponse, error)
	// Exports the selected tools.
	ExportTools(context.Context, *ExportToolsRequest) (*longrunningpb.Operation, error)
	// Retrieves the specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	GetTool(context.Context, *GetToolRequest) (*Tool, error)
	// Update the specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	UpdateTool(context.Context, *UpdateToolRequest) (*Tool, error)
	// Deletes a specified [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	DeleteTool(context.Context, *DeleteToolRequest) (*emptypb.Empty, error)
	// List versions of the specified
	// [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	ListToolVersions(context.Context, *ListToolVersionsRequest) (*ListToolVersionsResponse, error)
	// Creates a version for the specified
	// [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	CreateToolVersion(context.Context, *CreateToolVersionRequest) (*ToolVersion, error)
	// Retrieves the specified version of the
	// [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	GetToolVersion(context.Context, *GetToolVersionRequest) (*ToolVersion, error)
	// Deletes the specified version of the
	// [Tool][google.cloud.dialogflow.cx.v3beta1.Tool].
	DeleteToolVersion(context.Context, *DeleteToolVersionRequest) (*emptypb.Empty, error)
	// Retrieves the specified version of the Tool and stores it as the
	// current tool draft, returning the tool with resources updated.
	RestoreToolVersion(context.Context, *RestoreToolVersionRequest) (*RestoreToolVersionResponse, error)
}

// UnimplementedToolsServer should be embedded to have forward compatible implementations.
type UnimplementedToolsServer struct {
}

func (UnimplementedToolsServer) CreateTool(context.Context, *CreateToolRequest) (*Tool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTool not implemented")
}
func (UnimplementedToolsServer) ListTools(context.Context, *ListToolsRequest) (*ListToolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTools not implemented")
}
func (UnimplementedToolsServer) ExportTools(context.Context, *ExportToolsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportTools not implemented")
}
func (UnimplementedToolsServer) GetTool(context.Context, *GetToolRequest) (*Tool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTool not implemented")
}
func (UnimplementedToolsServer) UpdateTool(context.Context, *UpdateToolRequest) (*Tool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTool not implemented")
}
func (UnimplementedToolsServer) DeleteTool(context.Context, *DeleteToolRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTool not implemented")
}
func (UnimplementedToolsServer) ListToolVersions(context.Context, *ListToolVersionsRequest) (*ListToolVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListToolVersions not implemented")
}
func (UnimplementedToolsServer) CreateToolVersion(context.Context, *CreateToolVersionRequest) (*ToolVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateToolVersion not implemented")
}
func (UnimplementedToolsServer) GetToolVersion(context.Context, *GetToolVersionRequest) (*ToolVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetToolVersion not implemented")
}
func (UnimplementedToolsServer) DeleteToolVersion(context.Context, *DeleteToolVersionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteToolVersion not implemented")
}
func (UnimplementedToolsServer) RestoreToolVersion(context.Context, *RestoreToolVersionRequest) (*RestoreToolVersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreToolVersion not implemented")
}

// UnsafeToolsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ToolsServer will
// result in compilation errors.
type UnsafeToolsServer interface {
	mustEmbedUnimplementedToolsServer()
}

func RegisterToolsServer(s grpc.ServiceRegistrar, srv ToolsServer) {
	s.RegisterService(&Tools_ServiceDesc, srv)
}

func _Tools_CreateTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).CreateTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_CreateTool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).CreateTool(ctx, req.(*CreateToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_ListTools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListToolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).ListTools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_ListTools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).ListTools(ctx, req.(*ListToolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_ExportTools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportToolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).ExportTools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_ExportTools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).ExportTools(ctx, req.(*ExportToolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_GetTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).GetTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_GetTool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).GetTool(ctx, req.(*GetToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_UpdateTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).UpdateTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_UpdateTool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).UpdateTool(ctx, req.(*UpdateToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_DeleteTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).DeleteTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_DeleteTool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).DeleteTool(ctx, req.(*DeleteToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_ListToolVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListToolVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).ListToolVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_ListToolVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).ListToolVersions(ctx, req.(*ListToolVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_CreateToolVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateToolVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).CreateToolVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_CreateToolVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).CreateToolVersion(ctx, req.(*CreateToolVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_GetToolVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetToolVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).GetToolVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_GetToolVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).GetToolVersion(ctx, req.(*GetToolVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_DeleteToolVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteToolVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).DeleteToolVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_DeleteToolVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).DeleteToolVersion(ctx, req.(*DeleteToolVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_RestoreToolVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreToolVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).RestoreToolVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_RestoreToolVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).RestoreToolVersion(ctx, req.(*RestoreToolVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Tools_ServiceDesc is the grpc.ServiceDesc for Tools service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Tools_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Tools",
	HandlerType: (*ToolsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTool",
			Handler:    _Tools_CreateTool_Handler,
		},
		{
			MethodName: "ListTools",
			Handler:    _Tools_ListTools_Handler,
		},
		{
			MethodName: "ExportTools",
			Handler:    _Tools_ExportTools_Handler,
		},
		{
			MethodName: "GetTool",
			Handler:    _Tools_GetTool_Handler,
		},
		{
			MethodName: "UpdateTool",
			Handler:    _Tools_UpdateTool_Handler,
		},
		{
			MethodName: "DeleteTool",
			Handler:    _Tools_DeleteTool_Handler,
		},
		{
			MethodName: "ListToolVersions",
			Handler:    _Tools_ListToolVersions_Handler,
		},
		{
			MethodName: "CreateToolVersion",
			Handler:    _Tools_CreateToolVersion_Handler,
		},
		{
			MethodName: "GetToolVersion",
			Handler:    _Tools_GetToolVersion_Handler,
		},
		{
			MethodName: "DeleteToolVersion",
			Handler:    _Tools_DeleteToolVersion_Handler,
		},
		{
			MethodName: "RestoreToolVersion",
			Handler:    _Tools_RestoreToolVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/tool.proto",
}
