// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/iot/v1/device_manager.proto

package iotpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DeviceManager_CreateDeviceRegistry_FullMethodName      = "/google.cloud.iot.v1.DeviceManager/CreateDeviceRegistry"
	DeviceManager_GetDeviceRegistry_FullMethodName         = "/google.cloud.iot.v1.DeviceManager/GetDeviceRegistry"
	DeviceManager_UpdateDeviceRegistry_FullMethodName      = "/google.cloud.iot.v1.DeviceManager/UpdateDeviceRegistry"
	DeviceManager_DeleteDeviceRegistry_FullMethodName      = "/google.cloud.iot.v1.DeviceManager/DeleteDeviceRegistry"
	DeviceManager_ListDeviceRegistries_FullMethodName      = "/google.cloud.iot.v1.DeviceManager/ListDeviceRegistries"
	DeviceManager_CreateDevice_FullMethodName              = "/google.cloud.iot.v1.DeviceManager/CreateDevice"
	DeviceManager_GetDevice_FullMethodName                 = "/google.cloud.iot.v1.DeviceManager/GetDevice"
	DeviceManager_UpdateDevice_FullMethodName              = "/google.cloud.iot.v1.DeviceManager/UpdateDevice"
	DeviceManager_DeleteDevice_FullMethodName              = "/google.cloud.iot.v1.DeviceManager/DeleteDevice"
	DeviceManager_ListDevices_FullMethodName               = "/google.cloud.iot.v1.DeviceManager/ListDevices"
	DeviceManager_ModifyCloudToDeviceConfig_FullMethodName = "/google.cloud.iot.v1.DeviceManager/ModifyCloudToDeviceConfig"
	DeviceManager_ListDeviceConfigVersions_FullMethodName  = "/google.cloud.iot.v1.DeviceManager/ListDeviceConfigVersions"
	DeviceManager_ListDeviceStates_FullMethodName          = "/google.cloud.iot.v1.DeviceManager/ListDeviceStates"
	DeviceManager_SetIamPolicy_FullMethodName              = "/google.cloud.iot.v1.DeviceManager/SetIamPolicy"
	DeviceManager_GetIamPolicy_FullMethodName              = "/google.cloud.iot.v1.DeviceManager/GetIamPolicy"
	DeviceManager_TestIamPermissions_FullMethodName        = "/google.cloud.iot.v1.DeviceManager/TestIamPermissions"
	DeviceManager_SendCommandToDevice_FullMethodName       = "/google.cloud.iot.v1.DeviceManager/SendCommandToDevice"
	DeviceManager_BindDeviceToGateway_FullMethodName       = "/google.cloud.iot.v1.DeviceManager/BindDeviceToGateway"
	DeviceManager_UnbindDeviceFromGateway_FullMethodName   = "/google.cloud.iot.v1.DeviceManager/UnbindDeviceFromGateway"
)

// DeviceManagerClient is the client API for DeviceManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DeviceManagerClient interface {
	// Creates a device registry that contains devices.
	CreateDeviceRegistry(ctx context.Context, in *CreateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Gets a device registry configuration.
	GetDeviceRegistry(ctx context.Context, in *GetDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Updates a device registry configuration.
	UpdateDeviceRegistry(ctx context.Context, in *UpdateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Deletes a device registry configuration.
	DeleteDeviceRegistry(ctx context.Context, in *DeleteDeviceRegistryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists device registries.
	ListDeviceRegistries(ctx context.Context, in *ListDeviceRegistriesRequest, opts ...grpc.CallOption) (*ListDeviceRegistriesResponse, error)
	// Creates a device in a device registry.
	CreateDevice(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Gets details about a device.
	GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Updates a device.
	UpdateDevice(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Deletes a device.
	DeleteDevice(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List devices in a device registry.
	ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error)
	// Modifies the configuration for the device, which is eventually sent from
	// the Cloud IoT Core servers. Returns the modified configuration version and
	// its metadata.
	ModifyCloudToDeviceConfig(ctx context.Context, in *ModifyCloudToDeviceConfigRequest, opts ...grpc.CallOption) (*DeviceConfig, error)
	// Lists the last few versions of the device configuration in descending
	// order (i.e.: newest first).
	ListDeviceConfigVersions(ctx context.Context, in *ListDeviceConfigVersionsRequest, opts ...grpc.CallOption) (*ListDeviceConfigVersionsResponse, error)
	// Lists the last few versions of the device state in descending order (i.e.:
	// newest first).
	ListDeviceStates(ctx context.Context, in *ListDeviceStatesRequest, opts ...grpc.CallOption) (*ListDeviceStatesResponse, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Sends a command to the specified device. In order for a device to be able
	// to receive commands, it must:
	//  1. be connected to Cloud IoT Core using the MQTT protocol, and
	//  2. be subscribed to the group of MQTT topics specified by
	//     /devices/{device-id}/commands/#. This subscription will receive commands
	//     at the top-level topic /devices/{device-id}/commands as well as commands
	//     for subfolders, like /devices/{device-id}/commands/subfolder.
	//     Note that subscribing to specific subfolders is not supported.
	//
	// If the command could not be delivered to the device, this method will
	// return an error; in particular, if the device is not subscribed, this
	// method will return FAILED_PRECONDITION. Otherwise, this method will
	// return OK. If the subscription is QoS 1, at least once delivery will be
	// guaranteed; for QoS 0, no acknowledgment will be expected from the device.
	SendCommandToDevice(ctx context.Context, in *SendCommandToDeviceRequest, opts ...grpc.CallOption) (*SendCommandToDeviceResponse, error)
	// Associates the device with the gateway.
	BindDeviceToGateway(ctx context.Context, in *BindDeviceToGatewayRequest, opts ...grpc.CallOption) (*BindDeviceToGatewayResponse, error)
	// Deletes the association between the device and the gateway.
	UnbindDeviceFromGateway(ctx context.Context, in *UnbindDeviceFromGatewayRequest, opts ...grpc.CallOption) (*UnbindDeviceFromGatewayResponse, error)
}

type deviceManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewDeviceManagerClient(cc grpc.ClientConnInterface) DeviceManagerClient {
	return &deviceManagerClient{cc}
}

func (c *deviceManagerClient) CreateDeviceRegistry(ctx context.Context, in *CreateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := c.cc.Invoke(ctx, DeviceManager_CreateDeviceRegistry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetDeviceRegistry(ctx context.Context, in *GetDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := c.cc.Invoke(ctx, DeviceManager_GetDeviceRegistry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UpdateDeviceRegistry(ctx context.Context, in *UpdateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := c.cc.Invoke(ctx, DeviceManager_UpdateDeviceRegistry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) DeleteDeviceRegistry(ctx context.Context, in *DeleteDeviceRegistryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DeviceManager_DeleteDeviceRegistry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceRegistries(ctx context.Context, in *ListDeviceRegistriesRequest, opts ...grpc.CallOption) (*ListDeviceRegistriesResponse, error) {
	out := new(ListDeviceRegistriesResponse)
	err := c.cc.Invoke(ctx, DeviceManager_ListDeviceRegistries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) CreateDevice(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, DeviceManager_CreateDevice_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, DeviceManager_GetDevice_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UpdateDevice(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, DeviceManager_UpdateDevice_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) DeleteDevice(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DeviceManager_DeleteDevice_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error) {
	out := new(ListDevicesResponse)
	err := c.cc.Invoke(ctx, DeviceManager_ListDevices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ModifyCloudToDeviceConfig(ctx context.Context, in *ModifyCloudToDeviceConfigRequest, opts ...grpc.CallOption) (*DeviceConfig, error) {
	out := new(DeviceConfig)
	err := c.cc.Invoke(ctx, DeviceManager_ModifyCloudToDeviceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceConfigVersions(ctx context.Context, in *ListDeviceConfigVersionsRequest, opts ...grpc.CallOption) (*ListDeviceConfigVersionsResponse, error) {
	out := new(ListDeviceConfigVersionsResponse)
	err := c.cc.Invoke(ctx, DeviceManager_ListDeviceConfigVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceStates(ctx context.Context, in *ListDeviceStatesRequest, opts ...grpc.CallOption) (*ListDeviceStatesResponse, error) {
	out := new(ListDeviceStatesResponse)
	err := c.cc.Invoke(ctx, DeviceManager_ListDeviceStates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DeviceManager_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DeviceManager_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, DeviceManager_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) SendCommandToDevice(ctx context.Context, in *SendCommandToDeviceRequest, opts ...grpc.CallOption) (*SendCommandToDeviceResponse, error) {
	out := new(SendCommandToDeviceResponse)
	err := c.cc.Invoke(ctx, DeviceManager_SendCommandToDevice_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) BindDeviceToGateway(ctx context.Context, in *BindDeviceToGatewayRequest, opts ...grpc.CallOption) (*BindDeviceToGatewayResponse, error) {
	out := new(BindDeviceToGatewayResponse)
	err := c.cc.Invoke(ctx, DeviceManager_BindDeviceToGateway_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UnbindDeviceFromGateway(ctx context.Context, in *UnbindDeviceFromGatewayRequest, opts ...grpc.CallOption) (*UnbindDeviceFromGatewayResponse, error) {
	out := new(UnbindDeviceFromGatewayResponse)
	err := c.cc.Invoke(ctx, DeviceManager_UnbindDeviceFromGateway_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DeviceManagerServer is the server API for DeviceManager service.
// All implementations should embed UnimplementedDeviceManagerServer
// for forward compatibility
type DeviceManagerServer interface {
	// Creates a device registry that contains devices.
	CreateDeviceRegistry(context.Context, *CreateDeviceRegistryRequest) (*DeviceRegistry, error)
	// Gets a device registry configuration.
	GetDeviceRegistry(context.Context, *GetDeviceRegistryRequest) (*DeviceRegistry, error)
	// Updates a device registry configuration.
	UpdateDeviceRegistry(context.Context, *UpdateDeviceRegistryRequest) (*DeviceRegistry, error)
	// Deletes a device registry configuration.
	DeleteDeviceRegistry(context.Context, *DeleteDeviceRegistryRequest) (*emptypb.Empty, error)
	// Lists device registries.
	ListDeviceRegistries(context.Context, *ListDeviceRegistriesRequest) (*ListDeviceRegistriesResponse, error)
	// Creates a device in a device registry.
	CreateDevice(context.Context, *CreateDeviceRequest) (*Device, error)
	// Gets details about a device.
	GetDevice(context.Context, *GetDeviceRequest) (*Device, error)
	// Updates a device.
	UpdateDevice(context.Context, *UpdateDeviceRequest) (*Device, error)
	// Deletes a device.
	DeleteDevice(context.Context, *DeleteDeviceRequest) (*emptypb.Empty, error)
	// List devices in a device registry.
	ListDevices(context.Context, *ListDevicesRequest) (*ListDevicesResponse, error)
	// Modifies the configuration for the device, which is eventually sent from
	// the Cloud IoT Core servers. Returns the modified configuration version and
	// its metadata.
	ModifyCloudToDeviceConfig(context.Context, *ModifyCloudToDeviceConfigRequest) (*DeviceConfig, error)
	// Lists the last few versions of the device configuration in descending
	// order (i.e.: newest first).
	ListDeviceConfigVersions(context.Context, *ListDeviceConfigVersionsRequest) (*ListDeviceConfigVersionsResponse, error)
	// Lists the last few versions of the device state in descending order (i.e.:
	// newest first).
	ListDeviceStates(context.Context, *ListDeviceStatesRequest) (*ListDeviceStatesResponse, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Sends a command to the specified device. In order for a device to be able
	// to receive commands, it must:
	//  1. be connected to Cloud IoT Core using the MQTT protocol, and
	//  2. be subscribed to the group of MQTT topics specified by
	//     /devices/{device-id}/commands/#. This subscription will receive commands
	//     at the top-level topic /devices/{device-id}/commands as well as commands
	//     for subfolders, like /devices/{device-id}/commands/subfolder.
	//     Note that subscribing to specific subfolders is not supported.
	//
	// If the command could not be delivered to the device, this method will
	// return an error; in particular, if the device is not subscribed, this
	// method will return FAILED_PRECONDITION. Otherwise, this method will
	// return OK. If the subscription is QoS 1, at least once delivery will be
	// guaranteed; for QoS 0, no acknowledgment will be expected from the device.
	SendCommandToDevice(context.Context, *SendCommandToDeviceRequest) (*SendCommandToDeviceResponse, error)
	// Associates the device with the gateway.
	BindDeviceToGateway(context.Context, *BindDeviceToGatewayRequest) (*BindDeviceToGatewayResponse, error)
	// Deletes the association between the device and the gateway.
	UnbindDeviceFromGateway(context.Context, *UnbindDeviceFromGatewayRequest) (*UnbindDeviceFromGatewayResponse, error)
}

// UnimplementedDeviceManagerServer should be embedded to have forward compatible implementations.
type UnimplementedDeviceManagerServer struct {
}

func (UnimplementedDeviceManagerServer) CreateDeviceRegistry(context.Context, *CreateDeviceRegistryRequest) (*DeviceRegistry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeviceRegistry not implemented")
}
func (UnimplementedDeviceManagerServer) GetDeviceRegistry(context.Context, *GetDeviceRegistryRequest) (*DeviceRegistry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeviceRegistry not implemented")
}
func (UnimplementedDeviceManagerServer) UpdateDeviceRegistry(context.Context, *UpdateDeviceRegistryRequest) (*DeviceRegistry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeviceRegistry not implemented")
}
func (UnimplementedDeviceManagerServer) DeleteDeviceRegistry(context.Context, *DeleteDeviceRegistryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeviceRegistry not implemented")
}
func (UnimplementedDeviceManagerServer) ListDeviceRegistries(context.Context, *ListDeviceRegistriesRequest) (*ListDeviceRegistriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceRegistries not implemented")
}
func (UnimplementedDeviceManagerServer) CreateDevice(context.Context, *CreateDeviceRequest) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDevice not implemented")
}
func (UnimplementedDeviceManagerServer) GetDevice(context.Context, *GetDeviceRequest) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDevice not implemented")
}
func (UnimplementedDeviceManagerServer) UpdateDevice(context.Context, *UpdateDeviceRequest) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDevice not implemented")
}
func (UnimplementedDeviceManagerServer) DeleteDevice(context.Context, *DeleteDeviceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDevice not implemented")
}
func (UnimplementedDeviceManagerServer) ListDevices(context.Context, *ListDevicesRequest) (*ListDevicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDevices not implemented")
}
func (UnimplementedDeviceManagerServer) ModifyCloudToDeviceConfig(context.Context, *ModifyCloudToDeviceConfigRequest) (*DeviceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyCloudToDeviceConfig not implemented")
}
func (UnimplementedDeviceManagerServer) ListDeviceConfigVersions(context.Context, *ListDeviceConfigVersionsRequest) (*ListDeviceConfigVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceConfigVersions not implemented")
}
func (UnimplementedDeviceManagerServer) ListDeviceStates(context.Context, *ListDeviceStatesRequest) (*ListDeviceStatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceStates not implemented")
}
func (UnimplementedDeviceManagerServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedDeviceManagerServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedDeviceManagerServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedDeviceManagerServer) SendCommandToDevice(context.Context, *SendCommandToDeviceRequest) (*SendCommandToDeviceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendCommandToDevice not implemented")
}
func (UnimplementedDeviceManagerServer) BindDeviceToGateway(context.Context, *BindDeviceToGatewayRequest) (*BindDeviceToGatewayResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BindDeviceToGateway not implemented")
}
func (UnimplementedDeviceManagerServer) UnbindDeviceFromGateway(context.Context, *UnbindDeviceFromGatewayRequest) (*UnbindDeviceFromGatewayResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnbindDeviceFromGateway not implemented")
}

// UnsafeDeviceManagerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DeviceManagerServer will
// result in compilation errors.
type UnsafeDeviceManagerServer interface {
	mustEmbedUnimplementedDeviceManagerServer()
}

func RegisterDeviceManagerServer(s grpc.ServiceRegistrar, srv DeviceManagerServer) {
	s.RegisterService(&DeviceManager_ServiceDesc, srv)
}

func _DeviceManager_CreateDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).CreateDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_CreateDeviceRegistry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).CreateDeviceRegistry(ctx, req.(*CreateDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_GetDeviceRegistry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetDeviceRegistry(ctx, req.(*GetDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UpdateDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UpdateDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_UpdateDeviceRegistry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UpdateDeviceRegistry(ctx, req.(*UpdateDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_DeleteDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).DeleteDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_DeleteDeviceRegistry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).DeleteDeviceRegistry(ctx, req.(*DeleteDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceRegistries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceRegistriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceRegistries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_ListDeviceRegistries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceRegistries(ctx, req.(*ListDeviceRegistriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_CreateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).CreateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_CreateDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).CreateDevice(ctx, req.(*CreateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_GetDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetDevice(ctx, req.(*GetDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UpdateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UpdateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_UpdateDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UpdateDevice(ctx, req.(*UpdateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_DeleteDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).DeleteDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_DeleteDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).DeleteDevice(ctx, req.(*DeleteDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_ListDevices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDevices(ctx, req.(*ListDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ModifyCloudToDeviceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyCloudToDeviceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ModifyCloudToDeviceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_ModifyCloudToDeviceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ModifyCloudToDeviceConfig(ctx, req.(*ModifyCloudToDeviceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceConfigVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceConfigVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceConfigVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_ListDeviceConfigVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceConfigVersions(ctx, req.(*ListDeviceConfigVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceStates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceStatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceStates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_ListDeviceStates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceStates(ctx, req.(*ListDeviceStatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_SendCommandToDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendCommandToDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).SendCommandToDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_SendCommandToDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).SendCommandToDevice(ctx, req.(*SendCommandToDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_BindDeviceToGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BindDeviceToGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).BindDeviceToGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_BindDeviceToGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).BindDeviceToGateway(ctx, req.(*BindDeviceToGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UnbindDeviceFromGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnbindDeviceFromGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UnbindDeviceFromGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeviceManager_UnbindDeviceFromGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UnbindDeviceFromGateway(ctx, req.(*UnbindDeviceFromGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DeviceManager_ServiceDesc is the grpc.ServiceDesc for DeviceManager service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DeviceManager_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.iot.v1.DeviceManager",
	HandlerType: (*DeviceManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDeviceRegistry",
			Handler:    _DeviceManager_CreateDeviceRegistry_Handler,
		},
		{
			MethodName: "GetDeviceRegistry",
			Handler:    _DeviceManager_GetDeviceRegistry_Handler,
		},
		{
			MethodName: "UpdateDeviceRegistry",
			Handler:    _DeviceManager_UpdateDeviceRegistry_Handler,
		},
		{
			MethodName: "DeleteDeviceRegistry",
			Handler:    _DeviceManager_DeleteDeviceRegistry_Handler,
		},
		{
			MethodName: "ListDeviceRegistries",
			Handler:    _DeviceManager_ListDeviceRegistries_Handler,
		},
		{
			MethodName: "CreateDevice",
			Handler:    _DeviceManager_CreateDevice_Handler,
		},
		{
			MethodName: "GetDevice",
			Handler:    _DeviceManager_GetDevice_Handler,
		},
		{
			MethodName: "UpdateDevice",
			Handler:    _DeviceManager_UpdateDevice_Handler,
		},
		{
			MethodName: "DeleteDevice",
			Handler:    _DeviceManager_DeleteDevice_Handler,
		},
		{
			MethodName: "ListDevices",
			Handler:    _DeviceManager_ListDevices_Handler,
		},
		{
			MethodName: "ModifyCloudToDeviceConfig",
			Handler:    _DeviceManager_ModifyCloudToDeviceConfig_Handler,
		},
		{
			MethodName: "ListDeviceConfigVersions",
			Handler:    _DeviceManager_ListDeviceConfigVersions_Handler,
		},
		{
			MethodName: "ListDeviceStates",
			Handler:    _DeviceManager_ListDeviceStates_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DeviceManager_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DeviceManager_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DeviceManager_TestIamPermissions_Handler,
		},
		{
			MethodName: "SendCommandToDevice",
			Handler:    _DeviceManager_SendCommandToDevice_Handler,
		},
		{
			MethodName: "BindDeviceToGateway",
			Handler:    _DeviceManager_BindDeviceToGateway_Handler,
		},
		{
			MethodName: "UnbindDeviceFromGateway",
			Handler:    _DeviceManager_UnbindDeviceFromGateway_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/iot/v1/device_manager.proto",
}
