// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/analytics/admin/v1alpha/audience.proto

package adminpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies how to evaluate users for joining an Audience.
type AudienceFilterScope int32

const (
	// Scope is not specified.
	AudienceFilterScope_AUDIENCE_FILTER_SCOPE_UNSPECIFIED AudienceFilterScope = 0
	// User joins the Audience if the filter condition is met within one
	// event.
	AudienceFilterScope_AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT AudienceFilterScope = 1
	// User joins the Audience if the filter condition is met within one
	// session.
	AudienceFilterScope_AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION AudienceFilterScope = 2
	// User joins the Audience if the filter condition is met by any event
	// across any session.
	AudienceFilterScope_AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS AudienceFilterScope = 3
)

// Enum value maps for AudienceFilterScope.
var (
	AudienceFilterScope_name = map[int32]string{
		0: "AUDIENCE_FILTER_SCOPE_UNSPECIFIED",
		1: "AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT",
		2: "AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION",
		3: "AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS",
	}
	AudienceFilterScope_value = map[string]int32{
		"AUDIENCE_FILTER_SCOPE_UNSPECIFIED":         0,
		"AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT":   1,
		"AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION": 2,
		"AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS": 3,
	}
)

func (x AudienceFilterScope) Enum() *AudienceFilterScope {
	p := new(AudienceFilterScope)
	*p = x
	return p
}

func (x AudienceFilterScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudienceFilterScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_audience_proto_enumTypes[0].Descriptor()
}

func (AudienceFilterScope) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_audience_proto_enumTypes[0]
}

func (x AudienceFilterScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudienceFilterScope.Descriptor instead.
func (AudienceFilterScope) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{0}
}

// The match type for the string filter.
type AudienceDimensionOrMetricFilter_StringFilter_MatchType int32

const (
	// Unspecified
	AudienceDimensionOrMetricFilter_StringFilter_MATCH_TYPE_UNSPECIFIED AudienceDimensionOrMetricFilter_StringFilter_MatchType = 0
	// Exact match of the string value.
	AudienceDimensionOrMetricFilter_StringFilter_EXACT AudienceDimensionOrMetricFilter_StringFilter_MatchType = 1
	// Begins with the string value.
	AudienceDimensionOrMetricFilter_StringFilter_BEGINS_WITH AudienceDimensionOrMetricFilter_StringFilter_MatchType = 2
	// Ends with the string value.
	AudienceDimensionOrMetricFilter_StringFilter_ENDS_WITH AudienceDimensionOrMetricFilter_StringFilter_MatchType = 3
	// Contains the string value.
	AudienceDimensionOrMetricFilter_StringFilter_CONTAINS AudienceDimensionOrMetricFilter_StringFilter_MatchType = 4
	// Full regular expression matches with the string value.
	AudienceDimensionOrMetricFilter_StringFilter_FULL_REGEXP AudienceDimensionOrMetricFilter_StringFilter_MatchType = 5
)

// Enum value maps for AudienceDimensionOrMetricFilter_StringFilter_MatchType.
var (
	AudienceDimensionOrMetricFilter_StringFilter_MatchType_name = map[int32]string{
		0: "MATCH_TYPE_UNSPECIFIED",
		1: "EXACT",
		2: "BEGINS_WITH",
		3: "ENDS_WITH",
		4: "CONTAINS",
		5: "FULL_REGEXP",
	}
	AudienceDimensionOrMetricFilter_StringFilter_MatchType_value = map[string]int32{
		"MATCH_TYPE_UNSPECIFIED": 0,
		"EXACT":                  1,
		"BEGINS_WITH":            2,
		"ENDS_WITH":              3,
		"CONTAINS":               4,
		"FULL_REGEXP":            5,
	}
)

func (x AudienceDimensionOrMetricFilter_StringFilter_MatchType) Enum() *AudienceDimensionOrMetricFilter_StringFilter_MatchType {
	p := new(AudienceDimensionOrMetricFilter_StringFilter_MatchType)
	*p = x
	return p
}

func (x AudienceDimensionOrMetricFilter_StringFilter_MatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudienceDimensionOrMetricFilter_StringFilter_MatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_audience_proto_enumTypes[1].Descriptor()
}

func (AudienceDimensionOrMetricFilter_StringFilter_MatchType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_audience_proto_enumTypes[1]
}

func (x AudienceDimensionOrMetricFilter_StringFilter_MatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudienceDimensionOrMetricFilter_StringFilter_MatchType.Descriptor instead.
func (AudienceDimensionOrMetricFilter_StringFilter_MatchType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{0, 0, 0}
}

// The operation applied to a numeric filter.
type AudienceDimensionOrMetricFilter_NumericFilter_Operation int32

const (
	// Unspecified.
	AudienceDimensionOrMetricFilter_NumericFilter_OPERATION_UNSPECIFIED AudienceDimensionOrMetricFilter_NumericFilter_Operation = 0
	// Equal.
	AudienceDimensionOrMetricFilter_NumericFilter_EQUAL AudienceDimensionOrMetricFilter_NumericFilter_Operation = 1
	// Less than.
	AudienceDimensionOrMetricFilter_NumericFilter_LESS_THAN AudienceDimensionOrMetricFilter_NumericFilter_Operation = 2
	// Greater than.
	AudienceDimensionOrMetricFilter_NumericFilter_GREATER_THAN AudienceDimensionOrMetricFilter_NumericFilter_Operation = 4
)

// Enum value maps for AudienceDimensionOrMetricFilter_NumericFilter_Operation.
var (
	AudienceDimensionOrMetricFilter_NumericFilter_Operation_name = map[int32]string{
		0: "OPERATION_UNSPECIFIED",
		1: "EQUAL",
		2: "LESS_THAN",
		4: "GREATER_THAN",
	}
	AudienceDimensionOrMetricFilter_NumericFilter_Operation_value = map[string]int32{
		"OPERATION_UNSPECIFIED": 0,
		"EQUAL":                 1,
		"LESS_THAN":             2,
		"GREATER_THAN":          4,
	}
)

func (x AudienceDimensionOrMetricFilter_NumericFilter_Operation) Enum() *AudienceDimensionOrMetricFilter_NumericFilter_Operation {
	p := new(AudienceDimensionOrMetricFilter_NumericFilter_Operation)
	*p = x
	return p
}

func (x AudienceDimensionOrMetricFilter_NumericFilter_Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudienceDimensionOrMetricFilter_NumericFilter_Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_audience_proto_enumTypes[2].Descriptor()
}

func (AudienceDimensionOrMetricFilter_NumericFilter_Operation) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_audience_proto_enumTypes[2]
}

func (x AudienceDimensionOrMetricFilter_NumericFilter_Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudienceDimensionOrMetricFilter_NumericFilter_Operation.Descriptor instead.
func (AudienceDimensionOrMetricFilter_NumericFilter_Operation) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{0, 3, 0}
}

// Specifies whether this is an include or exclude filter clause.
type AudienceFilterClause_AudienceClauseType int32

const (
	// Unspecified clause type.
	AudienceFilterClause_AUDIENCE_CLAUSE_TYPE_UNSPECIFIED AudienceFilterClause_AudienceClauseType = 0
	// Users will be included in the Audience if the filter clause is met.
	AudienceFilterClause_INCLUDE AudienceFilterClause_AudienceClauseType = 1
	// Users will be excluded from the Audience if the filter clause is met.
	AudienceFilterClause_EXCLUDE AudienceFilterClause_AudienceClauseType = 2
)

// Enum value maps for AudienceFilterClause_AudienceClauseType.
var (
	AudienceFilterClause_AudienceClauseType_name = map[int32]string{
		0: "AUDIENCE_CLAUSE_TYPE_UNSPECIFIED",
		1: "INCLUDE",
		2: "EXCLUDE",
	}
	AudienceFilterClause_AudienceClauseType_value = map[string]int32{
		"AUDIENCE_CLAUSE_TYPE_UNSPECIFIED": 0,
		"INCLUDE":                          1,
		"EXCLUDE":                          2,
	}
)

func (x AudienceFilterClause_AudienceClauseType) Enum() *AudienceFilterClause_AudienceClauseType {
	p := new(AudienceFilterClause_AudienceClauseType)
	*p = x
	return p
}

func (x AudienceFilterClause_AudienceClauseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudienceFilterClause_AudienceClauseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_audience_proto_enumTypes[3].Descriptor()
}

func (AudienceFilterClause_AudienceClauseType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_audience_proto_enumTypes[3]
}

func (x AudienceFilterClause_AudienceClauseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudienceFilterClause_AudienceClauseType.Descriptor instead.
func (AudienceFilterClause_AudienceClauseType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{6, 0}
}

// Determines when to log the event.
type AudienceEventTrigger_LogCondition int32

const (
	// Log condition is not specified.
	AudienceEventTrigger_LOG_CONDITION_UNSPECIFIED AudienceEventTrigger_LogCondition = 0
	// The event should be logged only when a user is joined.
	AudienceEventTrigger_AUDIENCE_JOINED AudienceEventTrigger_LogCondition = 1
	// The event should be logged whenever the Audience condition is met, even
	// if the user is already a member of the Audience.
	AudienceEventTrigger_AUDIENCE_MEMBERSHIP_RENEWED AudienceEventTrigger_LogCondition = 2
)

// Enum value maps for AudienceEventTrigger_LogCondition.
var (
	AudienceEventTrigger_LogCondition_name = map[int32]string{
		0: "LOG_CONDITION_UNSPECIFIED",
		1: "AUDIENCE_JOINED",
		2: "AUDIENCE_MEMBERSHIP_RENEWED",
	}
	AudienceEventTrigger_LogCondition_value = map[string]int32{
		"LOG_CONDITION_UNSPECIFIED":   0,
		"AUDIENCE_JOINED":             1,
		"AUDIENCE_MEMBERSHIP_RENEWED": 2,
	}
)

func (x AudienceEventTrigger_LogCondition) Enum() *AudienceEventTrigger_LogCondition {
	p := new(AudienceEventTrigger_LogCondition)
	*p = x
	return p
}

func (x AudienceEventTrigger_LogCondition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudienceEventTrigger_LogCondition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_audience_proto_enumTypes[4].Descriptor()
}

func (AudienceEventTrigger_LogCondition) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_audience_proto_enumTypes[4]
}

func (x AudienceEventTrigger_LogCondition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudienceEventTrigger_LogCondition.Descriptor instead.
func (AudienceEventTrigger_LogCondition) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{7, 0}
}

// Specifies how long an exclusion lasts for users that meet the exclusion
// filter.
type Audience_AudienceExclusionDurationMode int32

const (
	// Not specified.
	Audience_AUDIENCE_EXCLUSION_DURATION_MODE_UNSPECIFIED Audience_AudienceExclusionDurationMode = 0
	// Exclude users from the Audience during periods when they meet the
	// filter clause.
	Audience_EXCLUDE_TEMPORARILY Audience_AudienceExclusionDurationMode = 1
	// Exclude users from the Audience if they've ever met the filter clause.
	Audience_EXCLUDE_PERMANENTLY Audience_AudienceExclusionDurationMode = 2
)

// Enum value maps for Audience_AudienceExclusionDurationMode.
var (
	Audience_AudienceExclusionDurationMode_name = map[int32]string{
		0: "AUDIENCE_EXCLUSION_DURATION_MODE_UNSPECIFIED",
		1: "EXCLUDE_TEMPORARILY",
		2: "EXCLUDE_PERMANENTLY",
	}
	Audience_AudienceExclusionDurationMode_value = map[string]int32{
		"AUDIENCE_EXCLUSION_DURATION_MODE_UNSPECIFIED": 0,
		"EXCLUDE_TEMPORARILY":                          1,
		"EXCLUDE_PERMANENTLY":                          2,
	}
)

func (x Audience_AudienceExclusionDurationMode) Enum() *Audience_AudienceExclusionDurationMode {
	p := new(Audience_AudienceExclusionDurationMode)
	*p = x
	return p
}

func (x Audience_AudienceExclusionDurationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Audience_AudienceExclusionDurationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_audience_proto_enumTypes[5].Descriptor()
}

func (Audience_AudienceExclusionDurationMode) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_audience_proto_enumTypes[5]
}

func (x Audience_AudienceExclusionDurationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Audience_AudienceExclusionDurationMode.Descriptor instead.
func (Audience_AudienceExclusionDurationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{8, 0}
}

// A specific filter for a single dimension or metric.
type AudienceDimensionOrMetricFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of the above filters.
	//
	// Types that are assignable to OneFilter:
	//
	//	*AudienceDimensionOrMetricFilter_StringFilter_
	//	*AudienceDimensionOrMetricFilter_InListFilter_
	//	*AudienceDimensionOrMetricFilter_NumericFilter_
	//	*AudienceDimensionOrMetricFilter_BetweenFilter_
	OneFilter isAudienceDimensionOrMetricFilter_OneFilter `protobuf_oneof:"one_filter"`
	// Required. Immutable. The dimension name or metric name to filter. If the
	// field name refers to a custom dimension or metric, a scope prefix will be
	// added to the front of the custom dimensions or metric name. For more on
	// scope prefixes or custom dimensions/metrics, reference the [Google
	// Analytics Data API documentation]
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#custom_dimensions).
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// Optional. Indicates whether this filter needs dynamic evaluation or not. If
	// set to true, users join the Audience if they ever met the condition (static
	// evaluation). If unset or set to false, user evaluation for an Audience is
	// dynamic; users are added to an Audience when they meet the conditions and
	// then removed when they no longer meet them.
	//
	// This can only be set when Audience scope is ACROSS_ALL_SESSIONS.
	AtAnyPointInTime bool `protobuf:"varint,6,opt,name=at_any_point_in_time,json=atAnyPointInTime,proto3" json:"at_any_point_in_time,omitempty"`
	// Optional. If set, specifies the time window for which to evaluate data in
	// number of days. If not set, then audience data is evaluated against
	// lifetime data (For example, infinite time window).
	//
	// For example, if set to 1 day, only the current day's data is evaluated. The
	// reference point is the current day when at_any_point_in_time is unset or
	// false.
	//
	// It can only be set when Audience scope is ACROSS_ALL_SESSIONS and cannot be
	// greater than 60 days.
	InAnyNDayPeriod int32 `protobuf:"varint,7,opt,name=in_any_n_day_period,json=inAnyNDayPeriod,proto3" json:"in_any_n_day_period,omitempty"`
}

func (x *AudienceDimensionOrMetricFilter) Reset() {
	*x = AudienceDimensionOrMetricFilter{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceDimensionOrMetricFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceDimensionOrMetricFilter) ProtoMessage() {}

func (x *AudienceDimensionOrMetricFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceDimensionOrMetricFilter.ProtoReflect.Descriptor instead.
func (*AudienceDimensionOrMetricFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{0}
}

func (m *AudienceDimensionOrMetricFilter) GetOneFilter() isAudienceDimensionOrMetricFilter_OneFilter {
	if m != nil {
		return m.OneFilter
	}
	return nil
}

func (x *AudienceDimensionOrMetricFilter) GetStringFilter() *AudienceDimensionOrMetricFilter_StringFilter {
	if x, ok := x.GetOneFilter().(*AudienceDimensionOrMetricFilter_StringFilter_); ok {
		return x.StringFilter
	}
	return nil
}

func (x *AudienceDimensionOrMetricFilter) GetInListFilter() *AudienceDimensionOrMetricFilter_InListFilter {
	if x, ok := x.GetOneFilter().(*AudienceDimensionOrMetricFilter_InListFilter_); ok {
		return x.InListFilter
	}
	return nil
}

func (x *AudienceDimensionOrMetricFilter) GetNumericFilter() *AudienceDimensionOrMetricFilter_NumericFilter {
	if x, ok := x.GetOneFilter().(*AudienceDimensionOrMetricFilter_NumericFilter_); ok {
		return x.NumericFilter
	}
	return nil
}

func (x *AudienceDimensionOrMetricFilter) GetBetweenFilter() *AudienceDimensionOrMetricFilter_BetweenFilter {
	if x, ok := x.GetOneFilter().(*AudienceDimensionOrMetricFilter_BetweenFilter_); ok {
		return x.BetweenFilter
	}
	return nil
}

func (x *AudienceDimensionOrMetricFilter) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (x *AudienceDimensionOrMetricFilter) GetAtAnyPointInTime() bool {
	if x != nil {
		return x.AtAnyPointInTime
	}
	return false
}

func (x *AudienceDimensionOrMetricFilter) GetInAnyNDayPeriod() int32 {
	if x != nil {
		return x.InAnyNDayPeriod
	}
	return 0
}

type isAudienceDimensionOrMetricFilter_OneFilter interface {
	isAudienceDimensionOrMetricFilter_OneFilter()
}

type AudienceDimensionOrMetricFilter_StringFilter_ struct {
	// A filter for a string-type dimension that matches a particular pattern.
	StringFilter *AudienceDimensionOrMetricFilter_StringFilter `protobuf:"bytes,2,opt,name=string_filter,json=stringFilter,proto3,oneof"`
}

type AudienceDimensionOrMetricFilter_InListFilter_ struct {
	// A filter for a string dimension that matches a particular list of
	// options.
	InListFilter *AudienceDimensionOrMetricFilter_InListFilter `protobuf:"bytes,3,opt,name=in_list_filter,json=inListFilter,proto3,oneof"`
}

type AudienceDimensionOrMetricFilter_NumericFilter_ struct {
	// A filter for numeric or date values on a dimension or metric.
	NumericFilter *AudienceDimensionOrMetricFilter_NumericFilter `protobuf:"bytes,4,opt,name=numeric_filter,json=numericFilter,proto3,oneof"`
}

type AudienceDimensionOrMetricFilter_BetweenFilter_ struct {
	// A filter for numeric or date values between certain values on a dimension
	// or metric.
	BetweenFilter *AudienceDimensionOrMetricFilter_BetweenFilter `protobuf:"bytes,5,opt,name=between_filter,json=betweenFilter,proto3,oneof"`
}

func (*AudienceDimensionOrMetricFilter_StringFilter_) isAudienceDimensionOrMetricFilter_OneFilter() {}

func (*AudienceDimensionOrMetricFilter_InListFilter_) isAudienceDimensionOrMetricFilter_OneFilter() {}

func (*AudienceDimensionOrMetricFilter_NumericFilter_) isAudienceDimensionOrMetricFilter_OneFilter() {
}

func (*AudienceDimensionOrMetricFilter_BetweenFilter_) isAudienceDimensionOrMetricFilter_OneFilter() {
}

// A filter that matches events of a single event name. If an event parameter
// is specified, only the subset of events that match both the single event name
// and the parameter filter expressions match this event filter.
type AudienceEventFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The name of the event to match against.
	EventName string `protobuf:"bytes,1,opt,name=event_name,json=eventName,proto3" json:"event_name,omitempty"`
	// Optional. If specified, this filter matches events that match both the
	// single event name and the parameter filter expressions. AudienceEventFilter
	// inside the parameter filter expression cannot be set (For example, nested
	// event filters are not supported). This should be a single and_group of
	// dimension_or_metric_filter or not_expression; ANDs of ORs are not
	// supported. Also, if it includes a filter for "eventCount", only that one
	// will be considered; all the other filters will be ignored.
	EventParameterFilterExpression *AudienceFilterExpression `protobuf:"bytes,2,opt,name=event_parameter_filter_expression,json=eventParameterFilterExpression,proto3" json:"event_parameter_filter_expression,omitempty"`
}

func (x *AudienceEventFilter) Reset() {
	*x = AudienceEventFilter{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceEventFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceEventFilter) ProtoMessage() {}

func (x *AudienceEventFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceEventFilter.ProtoReflect.Descriptor instead.
func (*AudienceEventFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{1}
}

func (x *AudienceEventFilter) GetEventName() string {
	if x != nil {
		return x.EventName
	}
	return ""
}

func (x *AudienceEventFilter) GetEventParameterFilterExpression() *AudienceFilterExpression {
	if x != nil {
		return x.EventParameterFilterExpression
	}
	return nil
}

// A logical expression of Audience dimension, metric, or event filters.
type AudienceFilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The expression applied to a filter.
	//
	// Types that are assignable to Expr:
	//
	//	*AudienceFilterExpression_AndGroup
	//	*AudienceFilterExpression_OrGroup
	//	*AudienceFilterExpression_NotExpression
	//	*AudienceFilterExpression_DimensionOrMetricFilter
	//	*AudienceFilterExpression_EventFilter
	Expr isAudienceFilterExpression_Expr `protobuf_oneof:"expr"`
}

func (x *AudienceFilterExpression) Reset() {
	*x = AudienceFilterExpression{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceFilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceFilterExpression) ProtoMessage() {}

func (x *AudienceFilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceFilterExpression.ProtoReflect.Descriptor instead.
func (*AudienceFilterExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{2}
}

func (m *AudienceFilterExpression) GetExpr() isAudienceFilterExpression_Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (x *AudienceFilterExpression) GetAndGroup() *AudienceFilterExpressionList {
	if x, ok := x.GetExpr().(*AudienceFilterExpression_AndGroup); ok {
		return x.AndGroup
	}
	return nil
}

func (x *AudienceFilterExpression) GetOrGroup() *AudienceFilterExpressionList {
	if x, ok := x.GetExpr().(*AudienceFilterExpression_OrGroup); ok {
		return x.OrGroup
	}
	return nil
}

func (x *AudienceFilterExpression) GetNotExpression() *AudienceFilterExpression {
	if x, ok := x.GetExpr().(*AudienceFilterExpression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (x *AudienceFilterExpression) GetDimensionOrMetricFilter() *AudienceDimensionOrMetricFilter {
	if x, ok := x.GetExpr().(*AudienceFilterExpression_DimensionOrMetricFilter); ok {
		return x.DimensionOrMetricFilter
	}
	return nil
}

func (x *AudienceFilterExpression) GetEventFilter() *AudienceEventFilter {
	if x, ok := x.GetExpr().(*AudienceFilterExpression_EventFilter); ok {
		return x.EventFilter
	}
	return nil
}

type isAudienceFilterExpression_Expr interface {
	isAudienceFilterExpression_Expr()
}

type AudienceFilterExpression_AndGroup struct {
	// A list of expressions to be AND’ed together. It can only contain
	// AudienceFilterExpressions with or_group. This must be set for the top
	// level AudienceFilterExpression.
	AndGroup *AudienceFilterExpressionList `protobuf:"bytes,1,opt,name=and_group,json=andGroup,proto3,oneof"`
}

type AudienceFilterExpression_OrGroup struct {
	// A list of expressions to OR’ed together. It cannot contain
	// AudienceFilterExpressions with and_group or or_group.
	OrGroup *AudienceFilterExpressionList `protobuf:"bytes,2,opt,name=or_group,json=orGroup,proto3,oneof"`
}

type AudienceFilterExpression_NotExpression struct {
	// A filter expression to be NOT'ed (For example, inverted, complemented).
	// It can only include a dimension_or_metric_filter. This cannot be set on
	// the top level AudienceFilterExpression.
	NotExpression *AudienceFilterExpression `protobuf:"bytes,3,opt,name=not_expression,json=notExpression,proto3,oneof"`
}

type AudienceFilterExpression_DimensionOrMetricFilter struct {
	// A filter on a single dimension or metric. This cannot be set on the top
	// level AudienceFilterExpression.
	DimensionOrMetricFilter *AudienceDimensionOrMetricFilter `protobuf:"bytes,4,opt,name=dimension_or_metric_filter,json=dimensionOrMetricFilter,proto3,oneof"`
}

type AudienceFilterExpression_EventFilter struct {
	// Creates a filter that matches a specific event. This cannot be set on the
	// top level AudienceFilterExpression.
	EventFilter *AudienceEventFilter `protobuf:"bytes,5,opt,name=event_filter,json=eventFilter,proto3,oneof"`
}

func (*AudienceFilterExpression_AndGroup) isAudienceFilterExpression_Expr() {}

func (*AudienceFilterExpression_OrGroup) isAudienceFilterExpression_Expr() {}

func (*AudienceFilterExpression_NotExpression) isAudienceFilterExpression_Expr() {}

func (*AudienceFilterExpression_DimensionOrMetricFilter) isAudienceFilterExpression_Expr() {}

func (*AudienceFilterExpression_EventFilter) isAudienceFilterExpression_Expr() {}

// A list of Audience filter expressions.
type AudienceFilterExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Audience filter expressions.
	FilterExpressions []*AudienceFilterExpression `protobuf:"bytes,1,rep,name=filter_expressions,json=filterExpressions,proto3" json:"filter_expressions,omitempty"`
}

func (x *AudienceFilterExpressionList) Reset() {
	*x = AudienceFilterExpressionList{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceFilterExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceFilterExpressionList) ProtoMessage() {}

func (x *AudienceFilterExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceFilterExpressionList.ProtoReflect.Descriptor instead.
func (*AudienceFilterExpressionList) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{3}
}

func (x *AudienceFilterExpressionList) GetFilterExpressions() []*AudienceFilterExpression {
	if x != nil {
		return x.FilterExpressions
	}
	return nil
}

// Defines a simple filter that a user must satisfy to be a member of the
// Audience.
type AudienceSimpleFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. Specifies the scope for this filter.
	Scope AudienceFilterScope `protobuf:"varint,1,opt,name=scope,proto3,enum=google.analytics.admin.v1alpha.AudienceFilterScope" json:"scope,omitempty"`
	// Required. Immutable. A logical expression of Audience dimension, metric, or
	// event filters.
	FilterExpression *AudienceFilterExpression `protobuf:"bytes,2,opt,name=filter_expression,json=filterExpression,proto3" json:"filter_expression,omitempty"`
}

func (x *AudienceSimpleFilter) Reset() {
	*x = AudienceSimpleFilter{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceSimpleFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceSimpleFilter) ProtoMessage() {}

func (x *AudienceSimpleFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceSimpleFilter.ProtoReflect.Descriptor instead.
func (*AudienceSimpleFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{4}
}

func (x *AudienceSimpleFilter) GetScope() AudienceFilterScope {
	if x != nil {
		return x.Scope
	}
	return AudienceFilterScope_AUDIENCE_FILTER_SCOPE_UNSPECIFIED
}

func (x *AudienceSimpleFilter) GetFilterExpression() *AudienceFilterExpression {
	if x != nil {
		return x.FilterExpression
	}
	return nil
}

// Defines filters that must occur in a specific order for the user to be a
// member of the Audience.
type AudienceSequenceFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. Specifies the scope for this filter.
	Scope AudienceFilterScope `protobuf:"varint,1,opt,name=scope,proto3,enum=google.analytics.admin.v1alpha.AudienceFilterScope" json:"scope,omitempty"`
	// Optional. Defines the time period in which the whole sequence must occur.
	SequenceMaximumDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=sequence_maximum_duration,json=sequenceMaximumDuration,proto3" json:"sequence_maximum_duration,omitempty"`
	// Required. An ordered sequence of steps. A user must complete each step in
	// order to join the sequence filter.
	SequenceSteps []*AudienceSequenceFilter_AudienceSequenceStep `protobuf:"bytes,3,rep,name=sequence_steps,json=sequenceSteps,proto3" json:"sequence_steps,omitempty"`
}

func (x *AudienceSequenceFilter) Reset() {
	*x = AudienceSequenceFilter{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceSequenceFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceSequenceFilter) ProtoMessage() {}

func (x *AudienceSequenceFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceSequenceFilter.ProtoReflect.Descriptor instead.
func (*AudienceSequenceFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{5}
}

func (x *AudienceSequenceFilter) GetScope() AudienceFilterScope {
	if x != nil {
		return x.Scope
	}
	return AudienceFilterScope_AUDIENCE_FILTER_SCOPE_UNSPECIFIED
}

func (x *AudienceSequenceFilter) GetSequenceMaximumDuration() *durationpb.Duration {
	if x != nil {
		return x.SequenceMaximumDuration
	}
	return nil
}

func (x *AudienceSequenceFilter) GetSequenceSteps() []*AudienceSequenceFilter_AudienceSequenceStep {
	if x != nil {
		return x.SequenceSteps
	}
	return nil
}

// A clause for defining either a simple or sequence filter. A filter can be
// inclusive (For example, users satisfying the filter clause are included in
// the Audience) or exclusive (For example, users satisfying the filter clause
// are excluded from the Audience).
type AudienceFilterClause struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Filter:
	//
	//	*AudienceFilterClause_SimpleFilter
	//	*AudienceFilterClause_SequenceFilter
	Filter isAudienceFilterClause_Filter `protobuf_oneof:"filter"`
	// Required. Specifies whether this is an include or exclude filter clause.
	ClauseType AudienceFilterClause_AudienceClauseType `protobuf:"varint,1,opt,name=clause_type,json=clauseType,proto3,enum=google.analytics.admin.v1alpha.AudienceFilterClause_AudienceClauseType" json:"clause_type,omitempty"`
}

func (x *AudienceFilterClause) Reset() {
	*x = AudienceFilterClause{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceFilterClause) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceFilterClause) ProtoMessage() {}

func (x *AudienceFilterClause) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceFilterClause.ProtoReflect.Descriptor instead.
func (*AudienceFilterClause) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{6}
}

func (m *AudienceFilterClause) GetFilter() isAudienceFilterClause_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (x *AudienceFilterClause) GetSimpleFilter() *AudienceSimpleFilter {
	if x, ok := x.GetFilter().(*AudienceFilterClause_SimpleFilter); ok {
		return x.SimpleFilter
	}
	return nil
}

func (x *AudienceFilterClause) GetSequenceFilter() *AudienceSequenceFilter {
	if x, ok := x.GetFilter().(*AudienceFilterClause_SequenceFilter); ok {
		return x.SequenceFilter
	}
	return nil
}

func (x *AudienceFilterClause) GetClauseType() AudienceFilterClause_AudienceClauseType {
	if x != nil {
		return x.ClauseType
	}
	return AudienceFilterClause_AUDIENCE_CLAUSE_TYPE_UNSPECIFIED
}

type isAudienceFilterClause_Filter interface {
	isAudienceFilterClause_Filter()
}

type AudienceFilterClause_SimpleFilter struct {
	// A simple filter that a user must satisfy to be a member of the Audience.
	SimpleFilter *AudienceSimpleFilter `protobuf:"bytes,2,opt,name=simple_filter,json=simpleFilter,proto3,oneof"`
}

type AudienceFilterClause_SequenceFilter struct {
	// Filters that must occur in a specific order for the user to be a member
	// of the Audience.
	SequenceFilter *AudienceSequenceFilter `protobuf:"bytes,3,opt,name=sequence_filter,json=sequenceFilter,proto3,oneof"`
}

func (*AudienceFilterClause_SimpleFilter) isAudienceFilterClause_Filter() {}

func (*AudienceFilterClause_SequenceFilter) isAudienceFilterClause_Filter() {}

// Specifies an event to log when a user joins the Audience.
type AudienceEventTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The event name that will be logged.
	EventName string `protobuf:"bytes,1,opt,name=event_name,json=eventName,proto3" json:"event_name,omitempty"`
	// Required. When to log the event.
	LogCondition AudienceEventTrigger_LogCondition `protobuf:"varint,2,opt,name=log_condition,json=logCondition,proto3,enum=google.analytics.admin.v1alpha.AudienceEventTrigger_LogCondition" json:"log_condition,omitempty"`
}

func (x *AudienceEventTrigger) Reset() {
	*x = AudienceEventTrigger{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceEventTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceEventTrigger) ProtoMessage() {}

func (x *AudienceEventTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceEventTrigger.ProtoReflect.Descriptor instead.
func (*AudienceEventTrigger) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{7}
}

func (x *AudienceEventTrigger) GetEventName() string {
	if x != nil {
		return x.EventName
	}
	return ""
}

func (x *AudienceEventTrigger) GetLogCondition() AudienceEventTrigger_LogCondition {
	if x != nil {
		return x.LogCondition
	}
	return AudienceEventTrigger_LOG_CONDITION_UNSPECIFIED
}

// A resource message representing an Audience.
type Audience struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this Audience resource.
	// Format: properties/{propertyId}/audiences/{audienceId}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the Audience.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The description of the Audience.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Immutable. The duration a user should stay in an Audience. It
	// cannot be set to more than 540 days.
	MembershipDurationDays int32 `protobuf:"varint,4,opt,name=membership_duration_days,json=membershipDurationDays,proto3" json:"membership_duration_days,omitempty"`
	// Output only. It is automatically set by GA to false if this is an NPA
	// Audience and is excluded from ads personalization.
	AdsPersonalizationEnabled bool `protobuf:"varint,5,opt,name=ads_personalization_enabled,json=adsPersonalizationEnabled,proto3" json:"ads_personalization_enabled,omitempty"`
	// Optional. Specifies an event to log when a user joins the Audience. If not
	// set, no event is logged when a user joins the Audience.
	EventTrigger *AudienceEventTrigger `protobuf:"bytes,6,opt,name=event_trigger,json=eventTrigger,proto3" json:"event_trigger,omitempty"`
	// Immutable. Specifies how long an exclusion lasts for users that meet the
	// exclusion filter. It is applied to all EXCLUDE filter clauses and is
	// ignored when there is no EXCLUDE filter clause in the Audience.
	ExclusionDurationMode Audience_AudienceExclusionDurationMode `protobuf:"varint,7,opt,name=exclusion_duration_mode,json=exclusionDurationMode,proto3,enum=google.analytics.admin.v1alpha.Audience_AudienceExclusionDurationMode" json:"exclusion_duration_mode,omitempty"`
	// Required. Immutable. Unordered list. Filter clauses that define the
	// Audience. All clauses will be AND’ed together.
	FilterClauses []*AudienceFilterClause `protobuf:"bytes,8,rep,name=filter_clauses,json=filterClauses,proto3" json:"filter_clauses,omitempty"`
	// Output only. Time when the Audience was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *Audience) Reset() {
	*x = Audience{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Audience) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Audience) ProtoMessage() {}

func (x *Audience) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Audience.ProtoReflect.Descriptor instead.
func (*Audience) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{8}
}

func (x *Audience) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Audience) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Audience) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Audience) GetMembershipDurationDays() int32 {
	if x != nil {
		return x.MembershipDurationDays
	}
	return 0
}

func (x *Audience) GetAdsPersonalizationEnabled() bool {
	if x != nil {
		return x.AdsPersonalizationEnabled
	}
	return false
}

func (x *Audience) GetEventTrigger() *AudienceEventTrigger {
	if x != nil {
		return x.EventTrigger
	}
	return nil
}

func (x *Audience) GetExclusionDurationMode() Audience_AudienceExclusionDurationMode {
	if x != nil {
		return x.ExclusionDurationMode
	}
	return Audience_AUDIENCE_EXCLUSION_DURATION_MODE_UNSPECIFIED
}

func (x *Audience) GetFilterClauses() []*AudienceFilterClause {
	if x != nil {
		return x.FilterClauses
	}
	return nil
}

func (x *Audience) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// A filter for a string-type dimension that matches a particular pattern.
type AudienceDimensionOrMetricFilter_StringFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The match type for the string filter.
	MatchType AudienceDimensionOrMetricFilter_StringFilter_MatchType `protobuf:"varint,1,opt,name=match_type,json=matchType,proto3,enum=google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter_StringFilter_MatchType" json:"match_type,omitempty"`
	// Required. The string value to be matched against.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Optional. If true, the match is case-sensitive. If false, the match is
	// case-insensitive.
	CaseSensitive bool `protobuf:"varint,3,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *AudienceDimensionOrMetricFilter_StringFilter) Reset() {
	*x = AudienceDimensionOrMetricFilter_StringFilter{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceDimensionOrMetricFilter_StringFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceDimensionOrMetricFilter_StringFilter) ProtoMessage() {}

func (x *AudienceDimensionOrMetricFilter_StringFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceDimensionOrMetricFilter_StringFilter.ProtoReflect.Descriptor instead.
func (*AudienceDimensionOrMetricFilter_StringFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AudienceDimensionOrMetricFilter_StringFilter) GetMatchType() AudienceDimensionOrMetricFilter_StringFilter_MatchType {
	if x != nil {
		return x.MatchType
	}
	return AudienceDimensionOrMetricFilter_StringFilter_MATCH_TYPE_UNSPECIFIED
}

func (x *AudienceDimensionOrMetricFilter_StringFilter) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *AudienceDimensionOrMetricFilter_StringFilter) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// A filter for a string dimension that matches a particular list of options.
type AudienceDimensionOrMetricFilter_InListFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of possible string values to match against. Must be
	// non-empty.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	// Optional. If true, the match is case-sensitive. If false, the match is
	// case-insensitive.
	CaseSensitive bool `protobuf:"varint,2,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *AudienceDimensionOrMetricFilter_InListFilter) Reset() {
	*x = AudienceDimensionOrMetricFilter_InListFilter{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceDimensionOrMetricFilter_InListFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceDimensionOrMetricFilter_InListFilter) ProtoMessage() {}

func (x *AudienceDimensionOrMetricFilter_InListFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceDimensionOrMetricFilter_InListFilter.ProtoReflect.Descriptor instead.
func (*AudienceDimensionOrMetricFilter_InListFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AudienceDimensionOrMetricFilter_InListFilter) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *AudienceDimensionOrMetricFilter_InListFilter) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// To represent a number.
type AudienceDimensionOrMetricFilter_NumericValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of a numeric value.
	//
	// Types that are assignable to OneValue:
	//
	//	*AudienceDimensionOrMetricFilter_NumericValue_Int64Value
	//	*AudienceDimensionOrMetricFilter_NumericValue_DoubleValue
	OneValue isAudienceDimensionOrMetricFilter_NumericValue_OneValue `protobuf_oneof:"one_value"`
}

func (x *AudienceDimensionOrMetricFilter_NumericValue) Reset() {
	*x = AudienceDimensionOrMetricFilter_NumericValue{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceDimensionOrMetricFilter_NumericValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceDimensionOrMetricFilter_NumericValue) ProtoMessage() {}

func (x *AudienceDimensionOrMetricFilter_NumericValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceDimensionOrMetricFilter_NumericValue.ProtoReflect.Descriptor instead.
func (*AudienceDimensionOrMetricFilter_NumericValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{0, 2}
}

func (m *AudienceDimensionOrMetricFilter_NumericValue) GetOneValue() isAudienceDimensionOrMetricFilter_NumericValue_OneValue {
	if m != nil {
		return m.OneValue
	}
	return nil
}

func (x *AudienceDimensionOrMetricFilter_NumericValue) GetInt64Value() int64 {
	if x, ok := x.GetOneValue().(*AudienceDimensionOrMetricFilter_NumericValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *AudienceDimensionOrMetricFilter_NumericValue) GetDoubleValue() float64 {
	if x, ok := x.GetOneValue().(*AudienceDimensionOrMetricFilter_NumericValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

type isAudienceDimensionOrMetricFilter_NumericValue_OneValue interface {
	isAudienceDimensionOrMetricFilter_NumericValue_OneValue()
}

type AudienceDimensionOrMetricFilter_NumericValue_Int64Value struct {
	// Integer value.
	Int64Value int64 `protobuf:"varint,1,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type AudienceDimensionOrMetricFilter_NumericValue_DoubleValue struct {
	// Double value.
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

func (*AudienceDimensionOrMetricFilter_NumericValue_Int64Value) isAudienceDimensionOrMetricFilter_NumericValue_OneValue() {
}

func (*AudienceDimensionOrMetricFilter_NumericValue_DoubleValue) isAudienceDimensionOrMetricFilter_NumericValue_OneValue() {
}

// A filter for numeric or date values on a dimension or metric.
type AudienceDimensionOrMetricFilter_NumericFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The operation applied to a numeric filter.
	Operation AudienceDimensionOrMetricFilter_NumericFilter_Operation `protobuf:"varint,1,opt,name=operation,proto3,enum=google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter_NumericFilter_Operation" json:"operation,omitempty"`
	// Required. The numeric or date value to match against.
	Value *AudienceDimensionOrMetricFilter_NumericValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AudienceDimensionOrMetricFilter_NumericFilter) Reset() {
	*x = AudienceDimensionOrMetricFilter_NumericFilter{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceDimensionOrMetricFilter_NumericFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceDimensionOrMetricFilter_NumericFilter) ProtoMessage() {}

func (x *AudienceDimensionOrMetricFilter_NumericFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceDimensionOrMetricFilter_NumericFilter.ProtoReflect.Descriptor instead.
func (*AudienceDimensionOrMetricFilter_NumericFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{0, 3}
}

func (x *AudienceDimensionOrMetricFilter_NumericFilter) GetOperation() AudienceDimensionOrMetricFilter_NumericFilter_Operation {
	if x != nil {
		return x.Operation
	}
	return AudienceDimensionOrMetricFilter_NumericFilter_OPERATION_UNSPECIFIED
}

func (x *AudienceDimensionOrMetricFilter_NumericFilter) GetValue() *AudienceDimensionOrMetricFilter_NumericValue {
	if x != nil {
		return x.Value
	}
	return nil
}

// A filter for numeric or date values between certain values on a dimension
// or metric.
type AudienceDimensionOrMetricFilter_BetweenFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Begins with this number, inclusive.
	FromValue *AudienceDimensionOrMetricFilter_NumericValue `protobuf:"bytes,1,opt,name=from_value,json=fromValue,proto3" json:"from_value,omitempty"`
	// Required. Ends with this number, inclusive.
	ToValue *AudienceDimensionOrMetricFilter_NumericValue `protobuf:"bytes,2,opt,name=to_value,json=toValue,proto3" json:"to_value,omitempty"`
}

func (x *AudienceDimensionOrMetricFilter_BetweenFilter) Reset() {
	*x = AudienceDimensionOrMetricFilter_BetweenFilter{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceDimensionOrMetricFilter_BetweenFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceDimensionOrMetricFilter_BetweenFilter) ProtoMessage() {}

func (x *AudienceDimensionOrMetricFilter_BetweenFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceDimensionOrMetricFilter_BetweenFilter.ProtoReflect.Descriptor instead.
func (*AudienceDimensionOrMetricFilter_BetweenFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{0, 4}
}

func (x *AudienceDimensionOrMetricFilter_BetweenFilter) GetFromValue() *AudienceDimensionOrMetricFilter_NumericValue {
	if x != nil {
		return x.FromValue
	}
	return nil
}

func (x *AudienceDimensionOrMetricFilter_BetweenFilter) GetToValue() *AudienceDimensionOrMetricFilter_NumericValue {
	if x != nil {
		return x.ToValue
	}
	return nil
}

// A condition that must occur in the specified step order for this user
// to match the sequence.
type AudienceSequenceFilter_AudienceSequenceStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. Specifies the scope for this step.
	Scope AudienceFilterScope `protobuf:"varint,1,opt,name=scope,proto3,enum=google.analytics.admin.v1alpha.AudienceFilterScope" json:"scope,omitempty"`
	// Optional. If true, the event satisfying this step must be the very next
	// event after the event satisfying the last step. If unset or false, this
	// step indirectly follows the prior step; for example, there may be
	// events between the prior step and this step. It is ignored for the
	// first step.
	ImmediatelyFollows bool `protobuf:"varint,2,opt,name=immediately_follows,json=immediatelyFollows,proto3" json:"immediately_follows,omitempty"`
	// Optional. When set, this step must be satisfied within the
	// constraint_duration of the previous step (For example,  t[i] - t[i-1] <=
	// constraint_duration). If not set, there is no duration requirement (the
	// duration is effectively unlimited). It is ignored for the first step.
	ConstraintDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=constraint_duration,json=constraintDuration,proto3" json:"constraint_duration,omitempty"`
	// Required. Immutable. A logical expression of Audience dimension, metric,
	// or event filters in each step.
	FilterExpression *AudienceFilterExpression `protobuf:"bytes,4,opt,name=filter_expression,json=filterExpression,proto3" json:"filter_expression,omitempty"`
}

func (x *AudienceSequenceFilter_AudienceSequenceStep) Reset() {
	*x = AudienceSequenceFilter_AudienceSequenceStep{}
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudienceSequenceFilter_AudienceSequenceStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudienceSequenceFilter_AudienceSequenceStep) ProtoMessage() {}

func (x *AudienceSequenceFilter_AudienceSequenceStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_audience_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudienceSequenceFilter_AudienceSequenceStep.ProtoReflect.Descriptor instead.
func (*AudienceSequenceFilter_AudienceSequenceStep) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP(), []int{5, 0}
}

func (x *AudienceSequenceFilter_AudienceSequenceStep) GetScope() AudienceFilterScope {
	if x != nil {
		return x.Scope
	}
	return AudienceFilterScope_AUDIENCE_FILTER_SCOPE_UNSPECIFIED
}

func (x *AudienceSequenceFilter_AudienceSequenceStep) GetImmediatelyFollows() bool {
	if x != nil {
		return x.ImmediatelyFollows
	}
	return false
}

func (x *AudienceSequenceFilter_AudienceSequenceStep) GetConstraintDuration() *durationpb.Duration {
	if x != nil {
		return x.ConstraintDuration
	}
	return nil
}

func (x *AudienceSequenceFilter_AudienceSequenceStep) GetFilterExpression() *AudienceFilterExpression {
	if x != nil {
		return x.FilterExpression
	}
	return nil
}

var File_google_analytics_admin_v1alpha_audience_proto protoreflect.FileDescriptor

var file_google_analytics_admin_v1alpha_audience_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdb, 0x0d, 0x0a,
	0x1f, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x4f, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x73, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x74, 0x0a, 0x0e, 0x69, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x4f, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x49,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x69,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x76, 0x0a, 0x0e, 0x6e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x76, 0x0a, 0x0e, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x42, 0x65, 0x74,
	0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x62, 0x65,
	0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0a, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x33, 0x0a, 0x14, 0x61, 0x74, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x61, 0x74, 0x41, 0x6e, 0x79, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x49, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x13, 0x69, 0x6e, 0x5f, 0x61, 0x6e,
	0x79, 0x5f, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x41, 0x6e, 0x79,
	0x4e, 0x44, 0x61, 0x79, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x1a, 0xc4, 0x02, 0x0a, 0x0c, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x7a, 0x0a, 0x0a, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x4f, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x63, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22, 0x71,
	0x0a, 0x09, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d,
	0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x58, 0x41, 0x43, 0x54,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x53, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x4e, 0x44, 0x53, 0x5f, 0x57, 0x49, 0x54, 0x48,
	0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x53, 0x10, 0x04,
	0x12, 0x0f, 0x0a, 0x0b, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x52, 0x45, 0x47, 0x45, 0x58, 0x50, 0x10,
	0x05, 0x1a, 0x57, 0x0a, 0x0c, 0x49, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1b, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x2a,
	0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x63, 0x61, 0x73,
	0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x1a, 0x63, 0x0a, 0x0c, 0x4e, 0x75,
	0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e,
	0x74, 0x36, 0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a,
	0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x6e, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a,
	0xc8, 0x02, 0x0a, 0x0d, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x7a, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f,
	0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x75,
	0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x52, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x45, 0x53,
	0x53, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x04, 0x1a, 0xef, 0x01, 0x0a, 0x0d, 0x42,
	0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x70, 0x0a, 0x0a,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x72, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x6c,
	0x0a, 0x08, 0x74, 0x6f, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x74, 0x6f, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0c, 0x0a, 0x0a,
	0x6f, 0x6e, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xc7, 0x01, 0x0a, 0x13, 0x41,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x25, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x09,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x88, 0x01, 0x0a, 0x21, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x1e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x04, 0x0a, 0x18, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x5b, 0x0a, 0x09, 0x61, 0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x08, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x59,
	0x0a, 0x08, 0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x07, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x61, 0x0a, 0x0e, 0x6e, 0x6f, 0x74,
	0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6e,
	0x6f, 0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x7e, 0x0a, 0x1a,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x17, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x58, 0x0a, 0x0c,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x06, 0x0a, 0x04, 0x65, 0x78, 0x70, 0x72, 0x22, 0x87,
	0x01, 0x0a, 0x1c, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x67, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd8, 0x01, 0x0a, 0x14, 0x41, 0x75, 0x64,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x51, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x53, 0x63, 0x6f, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x05, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x6d, 0x0a, 0x11, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41,
	0x05, 0x52, 0x10, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0xa2, 0x05, 0x0a, 0x16, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x51,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x12, 0x5a, 0x0a, 0x19, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x61,
	0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x61,
	0x78, 0x69, 0x6d, 0x75, 0x6d, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x77, 0x0a,
	0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x53,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x41, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x74,
	0x65, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x53, 0x74, 0x65, 0x70, 0x73, 0x1a, 0xdf, 0x02, 0x0a, 0x14, 0x41, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x65, 0x70, 0x12,
	0x51, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x63,
	0x6f, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x12, 0x34, 0x0a, 0x13, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c,
	0x79, 0x5f, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c,
	0x79, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x12, 0x4f, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x11, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x06,
	0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x10, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa5, 0x03, 0x0a, 0x14, 0x41, 0x75, 0x64,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73,
	0x65, 0x12, 0x5b, 0x0a, 0x0d, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x53, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x0c, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x61,
	0x0a, 0x0f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48,
	0x00, 0x52, 0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x6d, 0x0a, 0x0b, 0x63, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x2e, 0x41, 0x75, 0x64,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x54, 0x0a, 0x12, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x75,
	0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x41, 0x55, 0x44, 0x49, 0x45, 0x4e,
	0x43, 0x45, 0x5f, 0x43, 0x4c, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58, 0x43,
	0x4c, 0x55, 0x44, 0x45, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x22, 0x8c, 0x02, 0x0a, 0x14, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6b, 0x0a,
	0x0d, 0x6c, 0x6f, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x67, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x6f,
	0x67, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0x0a, 0x0c, 0x4c, 0x6f,
	0x67, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x4c, 0x4f,
	0x47, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x55, 0x44,
	0x49, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x4a, 0x4f, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1f,
	0x0a, 0x1b, 0x41, 0x55, 0x44, 0x49, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x4d, 0x45, 0x4d, 0x42, 0x45,
	0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x52, 0x45, 0x4e, 0x45, 0x57, 0x45, 0x44, 0x10, 0x02, 0x22,
	0xe8, 0x06, 0x0a, 0x08, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x18, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x16,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x12, 0x43, 0x0a, 0x1b, 0x61, 0x64, 0x73, 0x5f, 0x70, 0x65,
	0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x19, 0x61, 0x64, 0x73, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x5e, 0x0a, 0x0d, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x83, 0x01, 0x0a, 0x17,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x15, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x66, 0x0a, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x61, 0x75,
	0x73, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x42,
	0x09, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x06, 0x52, 0x0d, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x1d,
	0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x30, 0x0a,
	0x2c, 0x41, 0x55, 0x44, 0x49, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x55, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x17, 0x0a, 0x13, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f,
	0x52, 0x41, 0x52, 0x49, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x58, 0x43, 0x4c,
	0x55, 0x44, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x4c, 0x59, 0x10,
	0x02, 0x3a, 0x57, 0xea, 0x41, 0x54, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x7d, 0x2a, 0xc7, 0x01, 0x0a, 0x13, 0x41,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x55, 0x44, 0x49, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x46,
	0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2b, 0x0a, 0x27, 0x41, 0x55, 0x44,
	0x49, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x43, 0x4f,
	0x50, 0x45, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x2d, 0x0a, 0x29, 0x41, 0x55, 0x44, 0x49, 0x45, 0x4e,
	0x43, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f,
	0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x2d, 0x0a, 0x29, 0x41, 0x55, 0x44, 0x49, 0x45, 0x4e, 0x43,
	0x45, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x41,
	0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x53, 0x10, 0x03, 0x42, 0x75, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0d, 0x41, 0x75, 0x64, 0x69,
	0x65, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x70, 0x62, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_admin_v1alpha_audience_proto_rawDescOnce sync.Once
	file_google_analytics_admin_v1alpha_audience_proto_rawDescData = file_google_analytics_admin_v1alpha_audience_proto_rawDesc
)

func file_google_analytics_admin_v1alpha_audience_proto_rawDescGZIP() []byte {
	file_google_analytics_admin_v1alpha_audience_proto_rawDescOnce.Do(func() {
		file_google_analytics_admin_v1alpha_audience_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_admin_v1alpha_audience_proto_rawDescData)
	})
	return file_google_analytics_admin_v1alpha_audience_proto_rawDescData
}

var file_google_analytics_admin_v1alpha_audience_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_analytics_admin_v1alpha_audience_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_analytics_admin_v1alpha_audience_proto_goTypes = []any{
	(AudienceFilterScope)(0),                                     // 0: google.analytics.admin.v1alpha.AudienceFilterScope
	(AudienceDimensionOrMetricFilter_StringFilter_MatchType)(0),  // 1: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.StringFilter.MatchType
	(AudienceDimensionOrMetricFilter_NumericFilter_Operation)(0), // 2: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericFilter.Operation
	(AudienceFilterClause_AudienceClauseType)(0),                 // 3: google.analytics.admin.v1alpha.AudienceFilterClause.AudienceClauseType
	(AudienceEventTrigger_LogCondition)(0),                       // 4: google.analytics.admin.v1alpha.AudienceEventTrigger.LogCondition
	(Audience_AudienceExclusionDurationMode)(0),                  // 5: google.analytics.admin.v1alpha.Audience.AudienceExclusionDurationMode
	(*AudienceDimensionOrMetricFilter)(nil),                      // 6: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter
	(*AudienceEventFilter)(nil),                                  // 7: google.analytics.admin.v1alpha.AudienceEventFilter
	(*AudienceFilterExpression)(nil),                             // 8: google.analytics.admin.v1alpha.AudienceFilterExpression
	(*AudienceFilterExpressionList)(nil),                         // 9: google.analytics.admin.v1alpha.AudienceFilterExpressionList
	(*AudienceSimpleFilter)(nil),                                 // 10: google.analytics.admin.v1alpha.AudienceSimpleFilter
	(*AudienceSequenceFilter)(nil),                               // 11: google.analytics.admin.v1alpha.AudienceSequenceFilter
	(*AudienceFilterClause)(nil),                                 // 12: google.analytics.admin.v1alpha.AudienceFilterClause
	(*AudienceEventTrigger)(nil),                                 // 13: google.analytics.admin.v1alpha.AudienceEventTrigger
	(*Audience)(nil),                                             // 14: google.analytics.admin.v1alpha.Audience
	(*AudienceDimensionOrMetricFilter_StringFilter)(nil),         // 15: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.StringFilter
	(*AudienceDimensionOrMetricFilter_InListFilter)(nil),         // 16: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.InListFilter
	(*AudienceDimensionOrMetricFilter_NumericValue)(nil),         // 17: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericValue
	(*AudienceDimensionOrMetricFilter_NumericFilter)(nil),        // 18: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericFilter
	(*AudienceDimensionOrMetricFilter_BetweenFilter)(nil),        // 19: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.BetweenFilter
	(*AudienceSequenceFilter_AudienceSequenceStep)(nil),          // 20: google.analytics.admin.v1alpha.AudienceSequenceFilter.AudienceSequenceStep
	(*durationpb.Duration)(nil),                                  // 21: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                                // 22: google.protobuf.Timestamp
}
var file_google_analytics_admin_v1alpha_audience_proto_depIdxs = []int32{
	15, // 0: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.string_filter:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.StringFilter
	16, // 1: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.in_list_filter:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.InListFilter
	18, // 2: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.numeric_filter:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericFilter
	19, // 3: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.between_filter:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.BetweenFilter
	8,  // 4: google.analytics.admin.v1alpha.AudienceEventFilter.event_parameter_filter_expression:type_name -> google.analytics.admin.v1alpha.AudienceFilterExpression
	9,  // 5: google.analytics.admin.v1alpha.AudienceFilterExpression.and_group:type_name -> google.analytics.admin.v1alpha.AudienceFilterExpressionList
	9,  // 6: google.analytics.admin.v1alpha.AudienceFilterExpression.or_group:type_name -> google.analytics.admin.v1alpha.AudienceFilterExpressionList
	8,  // 7: google.analytics.admin.v1alpha.AudienceFilterExpression.not_expression:type_name -> google.analytics.admin.v1alpha.AudienceFilterExpression
	6,  // 8: google.analytics.admin.v1alpha.AudienceFilterExpression.dimension_or_metric_filter:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter
	7,  // 9: google.analytics.admin.v1alpha.AudienceFilterExpression.event_filter:type_name -> google.analytics.admin.v1alpha.AudienceEventFilter
	8,  // 10: google.analytics.admin.v1alpha.AudienceFilterExpressionList.filter_expressions:type_name -> google.analytics.admin.v1alpha.AudienceFilterExpression
	0,  // 11: google.analytics.admin.v1alpha.AudienceSimpleFilter.scope:type_name -> google.analytics.admin.v1alpha.AudienceFilterScope
	8,  // 12: google.analytics.admin.v1alpha.AudienceSimpleFilter.filter_expression:type_name -> google.analytics.admin.v1alpha.AudienceFilterExpression
	0,  // 13: google.analytics.admin.v1alpha.AudienceSequenceFilter.scope:type_name -> google.analytics.admin.v1alpha.AudienceFilterScope
	21, // 14: google.analytics.admin.v1alpha.AudienceSequenceFilter.sequence_maximum_duration:type_name -> google.protobuf.Duration
	20, // 15: google.analytics.admin.v1alpha.AudienceSequenceFilter.sequence_steps:type_name -> google.analytics.admin.v1alpha.AudienceSequenceFilter.AudienceSequenceStep
	10, // 16: google.analytics.admin.v1alpha.AudienceFilterClause.simple_filter:type_name -> google.analytics.admin.v1alpha.AudienceSimpleFilter
	11, // 17: google.analytics.admin.v1alpha.AudienceFilterClause.sequence_filter:type_name -> google.analytics.admin.v1alpha.AudienceSequenceFilter
	3,  // 18: google.analytics.admin.v1alpha.AudienceFilterClause.clause_type:type_name -> google.analytics.admin.v1alpha.AudienceFilterClause.AudienceClauseType
	4,  // 19: google.analytics.admin.v1alpha.AudienceEventTrigger.log_condition:type_name -> google.analytics.admin.v1alpha.AudienceEventTrigger.LogCondition
	13, // 20: google.analytics.admin.v1alpha.Audience.event_trigger:type_name -> google.analytics.admin.v1alpha.AudienceEventTrigger
	5,  // 21: google.analytics.admin.v1alpha.Audience.exclusion_duration_mode:type_name -> google.analytics.admin.v1alpha.Audience.AudienceExclusionDurationMode
	12, // 22: google.analytics.admin.v1alpha.Audience.filter_clauses:type_name -> google.analytics.admin.v1alpha.AudienceFilterClause
	22, // 23: google.analytics.admin.v1alpha.Audience.create_time:type_name -> google.protobuf.Timestamp
	1,  // 24: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.StringFilter.match_type:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.StringFilter.MatchType
	2,  // 25: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericFilter.operation:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericFilter.Operation
	17, // 26: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericFilter.value:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericValue
	17, // 27: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.BetweenFilter.from_value:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericValue
	17, // 28: google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.BetweenFilter.to_value:type_name -> google.analytics.admin.v1alpha.AudienceDimensionOrMetricFilter.NumericValue
	0,  // 29: google.analytics.admin.v1alpha.AudienceSequenceFilter.AudienceSequenceStep.scope:type_name -> google.analytics.admin.v1alpha.AudienceFilterScope
	21, // 30: google.analytics.admin.v1alpha.AudienceSequenceFilter.AudienceSequenceStep.constraint_duration:type_name -> google.protobuf.Duration
	8,  // 31: google.analytics.admin.v1alpha.AudienceSequenceFilter.AudienceSequenceStep.filter_expression:type_name -> google.analytics.admin.v1alpha.AudienceFilterExpression
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_analytics_admin_v1alpha_audience_proto_init() }
func file_google_analytics_admin_v1alpha_audience_proto_init() {
	if File_google_analytics_admin_v1alpha_audience_proto != nil {
		return
	}
	file_google_analytics_admin_v1alpha_audience_proto_msgTypes[0].OneofWrappers = []any{
		(*AudienceDimensionOrMetricFilter_StringFilter_)(nil),
		(*AudienceDimensionOrMetricFilter_InListFilter_)(nil),
		(*AudienceDimensionOrMetricFilter_NumericFilter_)(nil),
		(*AudienceDimensionOrMetricFilter_BetweenFilter_)(nil),
	}
	file_google_analytics_admin_v1alpha_audience_proto_msgTypes[2].OneofWrappers = []any{
		(*AudienceFilterExpression_AndGroup)(nil),
		(*AudienceFilterExpression_OrGroup)(nil),
		(*AudienceFilterExpression_NotExpression)(nil),
		(*AudienceFilterExpression_DimensionOrMetricFilter)(nil),
		(*AudienceFilterExpression_EventFilter)(nil),
	}
	file_google_analytics_admin_v1alpha_audience_proto_msgTypes[6].OneofWrappers = []any{
		(*AudienceFilterClause_SimpleFilter)(nil),
		(*AudienceFilterClause_SequenceFilter)(nil),
	}
	file_google_analytics_admin_v1alpha_audience_proto_msgTypes[11].OneofWrappers = []any{
		(*AudienceDimensionOrMetricFilter_NumericValue_Int64Value)(nil),
		(*AudienceDimensionOrMetricFilter_NumericValue_DoubleValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_admin_v1alpha_audience_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_analytics_admin_v1alpha_audience_proto_goTypes,
		DependencyIndexes: file_google_analytics_admin_v1alpha_audience_proto_depIdxs,
		EnumInfos:         file_google_analytics_admin_v1alpha_audience_proto_enumTypes,
		MessageInfos:      file_google_analytics_admin_v1alpha_audience_proto_msgTypes,
	}.Build()
	File_google_analytics_admin_v1alpha_audience_proto = out.File
	file_google_analytics_admin_v1alpha_audience_proto_rawDesc = nil
	file_google_analytics_admin_v1alpha_audience_proto_goTypes = nil
	file_google_analytics_admin_v1alpha_audience_proto_depIdxs = nil
}
