// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateDevicePool = "CreateDevicePool"

// CreateDevicePoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateDevicePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDevicePool for more information on using the CreateDevicePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDevicePoolRequest method.
//	req, resp := client.CreateDevicePoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool
func (c *DeviceFarm) CreateDevicePoolRequest(input *CreateDevicePoolInput) (req *request.Request, output *CreateDevicePoolOutput) {
	op := &request.Operation{
		Name:       opCreateDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDevicePoolInput{}
	}

	output = &CreateDevicePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDevicePool API operation for AWS Device Farm.
//
// Creates a device pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateDevicePool for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool
func (c *DeviceFarm) CreateDevicePool(input *CreateDevicePoolInput) (*CreateDevicePoolOutput, error) {
	req, out := c.CreateDevicePoolRequest(input)
	return out, req.Send()
}

// CreateDevicePoolWithContext is the same as CreateDevicePool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDevicePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) CreateDevicePoolWithContext(ctx aws.Context, input *CreateDevicePoolInput, opts ...request.Option) (*CreateDevicePoolOutput, error) {
	req, out := c.CreateDevicePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceProfile = "CreateInstanceProfile"

// CreateInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceProfile for more information on using the CreateInstanceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInstanceProfileRequest method.
//	req, resp := client.CreateInstanceProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfile
func (c *DeviceFarm) CreateInstanceProfileRequest(input *CreateInstanceProfileInput) (req *request.Request, output *CreateInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceProfileInput{}
	}

	output = &CreateInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceProfile API operation for AWS Device Farm.
//
// Creates a profile that can be applied to one or more private fleet device
// instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateInstanceProfile for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfile
func (c *DeviceFarm) CreateInstanceProfile(input *CreateInstanceProfileInput) (*CreateInstanceProfileOutput, error) {
	req, out := c.CreateInstanceProfileRequest(input)
	return out, req.Send()
}

// CreateInstanceProfileWithContext is the same as CreateInstanceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) CreateInstanceProfileWithContext(ctx aws.Context, input *CreateInstanceProfileInput, opts ...request.Option) (*CreateInstanceProfileOutput, error) {
	req, out := c.CreateInstanceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkProfile = "CreateNetworkProfile"

// CreateNetworkProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkProfile for more information on using the CreateNetworkProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkProfileRequest method.
//	req, resp := client.CreateNetworkProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateNetworkProfile
func (c *DeviceFarm) CreateNetworkProfileRequest(input *CreateNetworkProfileInput) (req *request.Request, output *CreateNetworkProfileOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkProfileInput{}
	}

	output = &CreateNetworkProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkProfile API operation for AWS Device Farm.
//
// Creates a network profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateNetworkProfile for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateNetworkProfile
func (c *DeviceFarm) CreateNetworkProfile(input *CreateNetworkProfileInput) (*CreateNetworkProfileOutput, error) {
	req, out := c.CreateNetworkProfileRequest(input)
	return out, req.Send()
}

// CreateNetworkProfileWithContext is the same as CreateNetworkProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) CreateNetworkProfileWithContext(ctx aws.Context, input *CreateNetworkProfileInput, opts ...request.Option) (*CreateNetworkProfileOutput, error) {
	req, out := c.CreateNetworkProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProjectRequest method.
//	req, resp := client.CreateProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject
func (c *DeviceFarm) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for AWS Device Farm.
//
// Creates a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
//   - TagOperationException
//     The operation was not successful. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject
func (c *DeviceFarm) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRemoteAccessSession = "CreateRemoteAccessSession"

// CreateRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateRemoteAccessSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRemoteAccessSession for more information on using the CreateRemoteAccessSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRemoteAccessSessionRequest method.
//	req, resp := client.CreateRemoteAccessSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession
func (c *DeviceFarm) CreateRemoteAccessSessionRequest(input *CreateRemoteAccessSessionInput) (req *request.Request, output *CreateRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opCreateRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRemoteAccessSessionInput{}
	}

	output = &CreateRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRemoteAccessSession API operation for AWS Device Farm.
//
// Specifies and starts a remote access session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateRemoteAccessSession for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession
func (c *DeviceFarm) CreateRemoteAccessSession(input *CreateRemoteAccessSessionInput) (*CreateRemoteAccessSessionOutput, error) {
	req, out := c.CreateRemoteAccessSessionRequest(input)
	return out, req.Send()
}

// CreateRemoteAccessSessionWithContext is the same as CreateRemoteAccessSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRemoteAccessSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) CreateRemoteAccessSessionWithContext(ctx aws.Context, input *CreateRemoteAccessSessionInput, opts ...request.Option) (*CreateRemoteAccessSessionOutput, error) {
	req, out := c.CreateRemoteAccessSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTestGridProject = "CreateTestGridProject"

// CreateTestGridProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateTestGridProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTestGridProject for more information on using the CreateTestGridProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTestGridProjectRequest method.
//	req, resp := client.CreateTestGridProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridProject
func (c *DeviceFarm) CreateTestGridProjectRequest(input *CreateTestGridProjectInput) (req *request.Request, output *CreateTestGridProjectOutput) {
	op := &request.Operation{
		Name:       opCreateTestGridProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTestGridProjectInput{}
	}

	output = &CreateTestGridProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTestGridProject API operation for AWS Device Farm.
//
// Creates a Selenium testing project. Projects are used to track TestGridSession
// instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateTestGridProject for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridProject
func (c *DeviceFarm) CreateTestGridProject(input *CreateTestGridProjectInput) (*CreateTestGridProjectOutput, error) {
	req, out := c.CreateTestGridProjectRequest(input)
	return out, req.Send()
}

// CreateTestGridProjectWithContext is the same as CreateTestGridProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTestGridProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) CreateTestGridProjectWithContext(ctx aws.Context, input *CreateTestGridProjectInput, opts ...request.Option) (*CreateTestGridProjectOutput, error) {
	req, out := c.CreateTestGridProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTestGridUrl = "CreateTestGridUrl"

// CreateTestGridUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreateTestGridUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTestGridUrl for more information on using the CreateTestGridUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTestGridUrlRequest method.
//	req, resp := client.CreateTestGridUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridUrl
func (c *DeviceFarm) CreateTestGridUrlRequest(input *CreateTestGridUrlInput) (req *request.Request, output *CreateTestGridUrlOutput) {
	op := &request.Operation{
		Name:       opCreateTestGridUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTestGridUrlInput{}
	}

	output = &CreateTestGridUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTestGridUrl API operation for AWS Device Farm.
//
// Creates a signed, short-term URL that can be passed to a Selenium RemoteWebDriver
// constructor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateTestGridUrl for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridUrl
func (c *DeviceFarm) CreateTestGridUrl(input *CreateTestGridUrlInput) (*CreateTestGridUrlOutput, error) {
	req, out := c.CreateTestGridUrlRequest(input)
	return out, req.Send()
}

// CreateTestGridUrlWithContext is the same as CreateTestGridUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTestGridUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) CreateTestGridUrlWithContext(ctx aws.Context, input *CreateTestGridUrlInput, opts ...request.Option) (*CreateTestGridUrlOutput, error) {
	req, out := c.CreateTestGridUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUpload = "CreateUpload"

// CreateUploadRequest generates a "aws/request.Request" representing the
// client's request for the CreateUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUpload for more information on using the CreateUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUploadRequest method.
//	req, resp := client.CreateUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload
func (c *DeviceFarm) CreateUploadRequest(input *CreateUploadInput) (req *request.Request, output *CreateUploadOutput) {
	op := &request.Operation{
		Name:       opCreateUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUploadInput{}
	}

	output = &CreateUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUpload API operation for AWS Device Farm.
//
// Uploads an app or test scripts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateUpload for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload
func (c *DeviceFarm) CreateUpload(input *CreateUploadInput) (*CreateUploadOutput, error) {
	req, out := c.CreateUploadRequest(input)
	return out, req.Send()
}

// CreateUploadWithContext is the same as CreateUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) CreateUploadWithContext(ctx aws.Context, input *CreateUploadInput, opts ...request.Option) (*CreateUploadOutput, error) {
	req, out := c.CreateUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVPCEConfiguration = "CreateVPCEConfiguration"

// CreateVPCEConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateVPCEConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVPCEConfiguration for more information on using the CreateVPCEConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVPCEConfigurationRequest method.
//	req, resp := client.CreateVPCEConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateVPCEConfiguration
func (c *DeviceFarm) CreateVPCEConfigurationRequest(input *CreateVPCEConfigurationInput) (req *request.Request, output *CreateVPCEConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateVPCEConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVPCEConfigurationInput{}
	}

	output = &CreateVPCEConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVPCEConfiguration API operation for AWS Device Farm.
//
// Creates a configuration record in Device Farm for your Amazon Virtual Private
// Cloud (VPC) endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateVPCEConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateVPCEConfiguration
func (c *DeviceFarm) CreateVPCEConfiguration(input *CreateVPCEConfigurationInput) (*CreateVPCEConfigurationOutput, error) {
	req, out := c.CreateVPCEConfigurationRequest(input)
	return out, req.Send()
}

// CreateVPCEConfigurationWithContext is the same as CreateVPCEConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVPCEConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) CreateVPCEConfigurationWithContext(ctx aws.Context, input *CreateVPCEConfigurationInput, opts ...request.Option) (*CreateVPCEConfigurationOutput, error) {
	req, out := c.CreateVPCEConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDevicePool = "DeleteDevicePool"

// DeleteDevicePoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDevicePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDevicePool for more information on using the DeleteDevicePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDevicePoolRequest method.
//	req, resp := client.DeleteDevicePoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool
func (c *DeviceFarm) DeleteDevicePoolRequest(input *DeleteDevicePoolInput) (req *request.Request, output *DeleteDevicePoolOutput) {
	op := &request.Operation{
		Name:       opDeleteDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDevicePoolInput{}
	}

	output = &DeleteDevicePoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDevicePool API operation for AWS Device Farm.
//
// Deletes a device pool given the pool ARN. Does not allow deletion of curated
// pools owned by the system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteDevicePool for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool
func (c *DeviceFarm) DeleteDevicePool(input *DeleteDevicePoolInput) (*DeleteDevicePoolOutput, error) {
	req, out := c.DeleteDevicePoolRequest(input)
	return out, req.Send()
}

// DeleteDevicePoolWithContext is the same as DeleteDevicePool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDevicePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) DeleteDevicePoolWithContext(ctx aws.Context, input *DeleteDevicePoolInput, opts ...request.Option) (*DeleteDevicePoolOutput, error) {
	req, out := c.DeleteDevicePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceProfile = "DeleteInstanceProfile"

// DeleteInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceProfile for more information on using the DeleteInstanceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInstanceProfileRequest method.
//	req, resp := client.DeleteInstanceProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteInstanceProfile
func (c *DeviceFarm) DeleteInstanceProfileRequest(input *DeleteInstanceProfileInput) (req *request.Request, output *DeleteInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceProfileInput{}
	}

	output = &DeleteInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInstanceProfile API operation for AWS Device Farm.
//
// Deletes a profile that can be applied to one or more private device instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteInstanceProfile for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteInstanceProfile
func (c *DeviceFarm) DeleteInstanceProfile(input *DeleteInstanceProfileInput) (*DeleteInstanceProfileOutput, error) {
	req, out := c.DeleteInstanceProfileRequest(input)
	return out, req.Send()
}

// DeleteInstanceProfileWithContext is the same as DeleteInstanceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) DeleteInstanceProfileWithContext(ctx aws.Context, input *DeleteInstanceProfileInput, opts ...request.Option) (*DeleteInstanceProfileOutput, error) {
	req, out := c.DeleteInstanceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkProfile = "DeleteNetworkProfile"

// DeleteNetworkProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkProfile for more information on using the DeleteNetworkProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkProfileRequest method.
//	req, resp := client.DeleteNetworkProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteNetworkProfile
func (c *DeviceFarm) DeleteNetworkProfileRequest(input *DeleteNetworkProfileInput) (req *request.Request, output *DeleteNetworkProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkProfileInput{}
	}

	output = &DeleteNetworkProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkProfile API operation for AWS Device Farm.
//
// Deletes a network profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteNetworkProfile for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteNetworkProfile
func (c *DeviceFarm) DeleteNetworkProfile(input *DeleteNetworkProfileInput) (*DeleteNetworkProfileOutput, error) {
	req, out := c.DeleteNetworkProfileRequest(input)
	return out, req.Send()
}

// DeleteNetworkProfileWithContext is the same as DeleteNetworkProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) DeleteNetworkProfileWithContext(ctx aws.Context, input *DeleteNetworkProfileInput, opts ...request.Option) (*DeleteNetworkProfileOutput, error) {
	req, out := c.DeleteNetworkProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProjectRequest method.
//	req, resp := client.DeleteProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject
func (c *DeviceFarm) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProject API operation for AWS Device Farm.
//
// Deletes an AWS Device Farm project, given the project ARN.
//
// Deleting this resource does not stop an in-progress run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject
func (c *DeviceFarm) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRemoteAccessSession = "DeleteRemoteAccessSession"

// DeleteRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRemoteAccessSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRemoteAccessSession for more information on using the DeleteRemoteAccessSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRemoteAccessSessionRequest method.
//	req, resp := client.DeleteRemoteAccessSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession
func (c *DeviceFarm) DeleteRemoteAccessSessionRequest(input *DeleteRemoteAccessSessionInput) (req *request.Request, output *DeleteRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opDeleteRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRemoteAccessSessionInput{}
	}

	output = &DeleteRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRemoteAccessSession API operation for AWS Device Farm.
//
// Deletes a completed remote access session and its results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteRemoteAccessSession for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession
func (c *DeviceFarm) DeleteRemoteAccessSession(input *DeleteRemoteAccessSessionInput) (*DeleteRemoteAccessSessionOutput, error) {
	req, out := c.DeleteRemoteAccessSessionRequest(input)
	return out, req.Send()
}

// DeleteRemoteAccessSessionWithContext is the same as DeleteRemoteAccessSession with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRemoteAccessSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) DeleteRemoteAccessSessionWithContext(ctx aws.Context, input *DeleteRemoteAccessSessionInput, opts ...request.Option) (*DeleteRemoteAccessSessionOutput, error) {
	req, out := c.DeleteRemoteAccessSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRun = "DeleteRun"

// DeleteRunRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRun for more information on using the DeleteRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRunRequest method.
//	req, resp := client.DeleteRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun
func (c *DeviceFarm) DeleteRunRequest(input *DeleteRunInput) (req *request.Request, output *DeleteRunOutput) {
	op := &request.Operation{
		Name:       opDeleteRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRunInput{}
	}

	output = &DeleteRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRun API operation for AWS Device Farm.
//
// Deletes the run, given the run ARN.
//
// Deleting this resource does not stop an in-progress run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteRun for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun
func (c *DeviceFarm) DeleteRun(input *DeleteRunInput) (*DeleteRunOutput, error) {
	req, out := c.DeleteRunRequest(input)
	return out, req.Send()
}

// DeleteRunWithContext is the same as DeleteRun with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) DeleteRunWithContext(ctx aws.Context, input *DeleteRunInput, opts ...request.Option) (*DeleteRunOutput, error) {
	req, out := c.DeleteRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTestGridProject = "DeleteTestGridProject"

// DeleteTestGridProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTestGridProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTestGridProject for more information on using the DeleteTestGridProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTestGridProjectRequest method.
//	req, resp := client.DeleteTestGridProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteTestGridProject
func (c *DeviceFarm) DeleteTestGridProjectRequest(input *DeleteTestGridProjectInput) (req *request.Request, output *DeleteTestGridProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteTestGridProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTestGridProjectInput{}
	}

	output = &DeleteTestGridProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTestGridProject API operation for AWS Device Farm.
//
// Deletes a Selenium testing project and all content generated under it.
//
// You cannot undo this operation.
//
// You cannot delete a project if it has active sessions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteTestGridProject for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - CannotDeleteException
//     The requested object could not be deleted.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteTestGridProject
func (c *DeviceFarm) DeleteTestGridProject(input *DeleteTestGridProjectInput) (*DeleteTestGridProjectOutput, error) {
	req, out := c.DeleteTestGridProjectRequest(input)
	return out, req.Send()
}

// DeleteTestGridProjectWithContext is the same as DeleteTestGridProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTestGridProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) DeleteTestGridProjectWithContext(ctx aws.Context, input *DeleteTestGridProjectInput, opts ...request.Option) (*DeleteTestGridProjectOutput, error) {
	req, out := c.DeleteTestGridProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUpload = "DeleteUpload"

// DeleteUploadRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUpload for more information on using the DeleteUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUploadRequest method.
//	req, resp := client.DeleteUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload
func (c *DeviceFarm) DeleteUploadRequest(input *DeleteUploadInput) (req *request.Request, output *DeleteUploadOutput) {
	op := &request.Operation{
		Name:       opDeleteUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUploadInput{}
	}

	output = &DeleteUploadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUpload API operation for AWS Device Farm.
//
// Deletes an upload given the upload ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteUpload for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload
func (c *DeviceFarm) DeleteUpload(input *DeleteUploadInput) (*DeleteUploadOutput, error) {
	req, out := c.DeleteUploadRequest(input)
	return out, req.Send()
}

// DeleteUploadWithContext is the same as DeleteUpload with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) DeleteUploadWithContext(ctx aws.Context, input *DeleteUploadInput, opts ...request.Option) (*DeleteUploadOutput, error) {
	req, out := c.DeleteUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVPCEConfiguration = "DeleteVPCEConfiguration"

// DeleteVPCEConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVPCEConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVPCEConfiguration for more information on using the DeleteVPCEConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVPCEConfigurationRequest method.
//	req, resp := client.DeleteVPCEConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfiguration
func (c *DeviceFarm) DeleteVPCEConfigurationRequest(input *DeleteVPCEConfigurationInput) (req *request.Request, output *DeleteVPCEConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteVPCEConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVPCEConfigurationInput{}
	}

	output = &DeleteVPCEConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVPCEConfiguration API operation for AWS Device Farm.
//
// Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteVPCEConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
//   - InvalidOperationException
//     There was an error with the update request, or you do not have sufficient
//     permissions to update this VPC endpoint configuration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfiguration
func (c *DeviceFarm) DeleteVPCEConfiguration(input *DeleteVPCEConfigurationInput) (*DeleteVPCEConfigurationOutput, error) {
	req, out := c.DeleteVPCEConfigurationRequest(input)
	return out, req.Send()
}

// DeleteVPCEConfigurationWithContext is the same as DeleteVPCEConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVPCEConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) DeleteVPCEConfigurationWithContext(ctx aws.Context, input *DeleteVPCEConfigurationInput, opts ...request.Option) (*DeleteVPCEConfigurationOutput, error) {
	req, out := c.DeleteVPCEConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSettings for more information on using the GetAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountSettingsRequest method.
//	req, resp := client.GetAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings
func (c *DeviceFarm) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for AWS Device Farm.
//
// Returns the number of unmetered iOS or unmetered Android devices that have
// been purchased by the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings
func (c *DeviceFarm) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	return out, req.Send()
}

// GetAccountSettingsWithContext is the same as GetAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetAccountSettingsWithContext(ctx aws.Context, input *GetAccountSettingsInput, opts ...request.Option) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevice for more information on using the GetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeviceRequest method.
//	req, resp := client.GetDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice
func (c *DeviceFarm) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	output = &GetDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevice API operation for AWS Device Farm.
//
// Gets information about a unique device type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetDevice for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice
func (c *DeviceFarm) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	return out, req.Send()
}

// GetDeviceWithContext is the same as GetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetDeviceWithContext(ctx aws.Context, input *GetDeviceInput, opts ...request.Option) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceInstance = "GetDeviceInstance"

// GetDeviceInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceInstance for more information on using the GetDeviceInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeviceInstanceRequest method.
//	req, resp := client.GetDeviceInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDeviceInstance
func (c *DeviceFarm) GetDeviceInstanceRequest(input *GetDeviceInstanceInput) (req *request.Request, output *GetDeviceInstanceOutput) {
	op := &request.Operation{
		Name:       opGetDeviceInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceInstanceInput{}
	}

	output = &GetDeviceInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceInstance API operation for AWS Device Farm.
//
// Returns information about a device instance that belongs to a private device
// fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetDeviceInstance for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDeviceInstance
func (c *DeviceFarm) GetDeviceInstance(input *GetDeviceInstanceInput) (*GetDeviceInstanceOutput, error) {
	req, out := c.GetDeviceInstanceRequest(input)
	return out, req.Send()
}

// GetDeviceInstanceWithContext is the same as GetDeviceInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetDeviceInstanceWithContext(ctx aws.Context, input *GetDeviceInstanceInput, opts ...request.Option) (*GetDeviceInstanceOutput, error) {
	req, out := c.GetDeviceInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevicePool = "GetDevicePool"

// GetDevicePoolRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevicePool for more information on using the GetDevicePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDevicePoolRequest method.
//	req, resp := client.GetDevicePoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool
func (c *DeviceFarm) GetDevicePoolRequest(input *GetDevicePoolInput) (req *request.Request, output *GetDevicePoolOutput) {
	op := &request.Operation{
		Name:       opGetDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDevicePoolInput{}
	}

	output = &GetDevicePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevicePool API operation for AWS Device Farm.
//
// Gets information about a device pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetDevicePool for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool
func (c *DeviceFarm) GetDevicePool(input *GetDevicePoolInput) (*GetDevicePoolOutput, error) {
	req, out := c.GetDevicePoolRequest(input)
	return out, req.Send()
}

// GetDevicePoolWithContext is the same as GetDevicePool with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevicePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetDevicePoolWithContext(ctx aws.Context, input *GetDevicePoolInput, opts ...request.Option) (*GetDevicePoolOutput, error) {
	req, out := c.GetDevicePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevicePoolCompatibility = "GetDevicePoolCompatibility"

// GetDevicePoolCompatibilityRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicePoolCompatibility operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevicePoolCompatibility for more information on using the GetDevicePoolCompatibility
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDevicePoolCompatibilityRequest method.
//	req, resp := client.GetDevicePoolCompatibilityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility
func (c *DeviceFarm) GetDevicePoolCompatibilityRequest(input *GetDevicePoolCompatibilityInput) (req *request.Request, output *GetDevicePoolCompatibilityOutput) {
	op := &request.Operation{
		Name:       opGetDevicePoolCompatibility,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDevicePoolCompatibilityInput{}
	}

	output = &GetDevicePoolCompatibilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevicePoolCompatibility API operation for AWS Device Farm.
//
// Gets information about compatibility with a device pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetDevicePoolCompatibility for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility
func (c *DeviceFarm) GetDevicePoolCompatibility(input *GetDevicePoolCompatibilityInput) (*GetDevicePoolCompatibilityOutput, error) {
	req, out := c.GetDevicePoolCompatibilityRequest(input)
	return out, req.Send()
}

// GetDevicePoolCompatibilityWithContext is the same as GetDevicePoolCompatibility with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevicePoolCompatibility for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetDevicePoolCompatibilityWithContext(ctx aws.Context, input *GetDevicePoolCompatibilityInput, opts ...request.Option) (*GetDevicePoolCompatibilityOutput, error) {
	req, out := c.GetDevicePoolCompatibilityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceProfile = "GetInstanceProfile"

// GetInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceProfile for more information on using the GetInstanceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInstanceProfileRequest method.
//	req, resp := client.GetInstanceProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetInstanceProfile
func (c *DeviceFarm) GetInstanceProfileRequest(input *GetInstanceProfileInput) (req *request.Request, output *GetInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opGetInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceProfileInput{}
	}

	output = &GetInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceProfile API operation for AWS Device Farm.
//
// Returns information about the specified instance profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetInstanceProfile for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetInstanceProfile
func (c *DeviceFarm) GetInstanceProfile(input *GetInstanceProfileInput) (*GetInstanceProfileOutput, error) {
	req, out := c.GetInstanceProfileRequest(input)
	return out, req.Send()
}

// GetInstanceProfileWithContext is the same as GetInstanceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetInstanceProfileWithContext(ctx aws.Context, input *GetInstanceProfileInput, opts ...request.Option) (*GetInstanceProfileOutput, error) {
	req, out := c.GetInstanceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJob = "GetJob"

// GetJobRequest generates a "aws/request.Request" representing the
// client's request for the GetJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJob for more information on using the GetJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetJobRequest method.
//	req, resp := client.GetJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob
func (c *DeviceFarm) GetJobRequest(input *GetJobInput) (req *request.Request, output *GetJobOutput) {
	op := &request.Operation{
		Name:       opGetJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobInput{}
	}

	output = &GetJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJob API operation for AWS Device Farm.
//
// Gets information about a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetJob for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob
func (c *DeviceFarm) GetJob(input *GetJobInput) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	return out, req.Send()
}

// GetJobWithContext is the same as GetJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetJobWithContext(ctx aws.Context, input *GetJobInput, opts ...request.Option) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNetworkProfile = "GetNetworkProfile"

// GetNetworkProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetNetworkProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNetworkProfile for more information on using the GetNetworkProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetNetworkProfileRequest method.
//	req, resp := client.GetNetworkProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetNetworkProfile
func (c *DeviceFarm) GetNetworkProfileRequest(input *GetNetworkProfileInput) (req *request.Request, output *GetNetworkProfileOutput) {
	op := &request.Operation{
		Name:       opGetNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNetworkProfileInput{}
	}

	output = &GetNetworkProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNetworkProfile API operation for AWS Device Farm.
//
// Returns information about a network profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetNetworkProfile for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetNetworkProfile
func (c *DeviceFarm) GetNetworkProfile(input *GetNetworkProfileInput) (*GetNetworkProfileOutput, error) {
	req, out := c.GetNetworkProfileRequest(input)
	return out, req.Send()
}

// GetNetworkProfileWithContext is the same as GetNetworkProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetNetworkProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetNetworkProfileWithContext(ctx aws.Context, input *GetNetworkProfileInput, opts ...request.Option) (*GetNetworkProfileOutput, error) {
	req, out := c.GetNetworkProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOfferingStatus = "GetOfferingStatus"

// GetOfferingStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetOfferingStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOfferingStatus for more information on using the GetOfferingStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOfferingStatusRequest method.
//	req, resp := client.GetOfferingStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus
func (c *DeviceFarm) GetOfferingStatusRequest(input *GetOfferingStatusInput) (req *request.Request, output *GetOfferingStatusOutput) {
	op := &request.Operation{
		Name:       opGetOfferingStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetOfferingStatusInput{}
	}

	output = &GetOfferingStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOfferingStatus API operation for AWS Device Farm.
//
// Gets the current status and future status of all offerings purchased by an
// AWS account. The response indicates how many offerings are currently available
// and the offerings that will be available in the next period. The API returns
// a NotEligible error if the user is not permitted to invoke the operation.
// If you must be able to invoke this operation, contact aws-devicefarm-support@amazon.com
// (mailto:aws-devicefarm-support@amazon.com).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetOfferingStatus for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - NotEligibleException
//     Exception gets thrown when a user is not eligible to perform the specified
//     transaction.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus
func (c *DeviceFarm) GetOfferingStatus(input *GetOfferingStatusInput) (*GetOfferingStatusOutput, error) {
	req, out := c.GetOfferingStatusRequest(input)
	return out, req.Send()
}

// GetOfferingStatusWithContext is the same as GetOfferingStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetOfferingStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetOfferingStatusWithContext(ctx aws.Context, input *GetOfferingStatusInput, opts ...request.Option) (*GetOfferingStatusOutput, error) {
	req, out := c.GetOfferingStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetOfferingStatusPages iterates over the pages of a GetOfferingStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetOfferingStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetOfferingStatus operation.
//	pageNum := 0
//	err := client.GetOfferingStatusPages(params,
//	    func(page *devicefarm.GetOfferingStatusOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) GetOfferingStatusPages(input *GetOfferingStatusInput, fn func(*GetOfferingStatusOutput, bool) bool) error {
	return c.GetOfferingStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetOfferingStatusPagesWithContext same as GetOfferingStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetOfferingStatusPagesWithContext(ctx aws.Context, input *GetOfferingStatusInput, fn func(*GetOfferingStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetOfferingStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetOfferingStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetOfferingStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetProject = "GetProject"

// GetProjectRequest generates a "aws/request.Request" representing the
// client's request for the GetProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProject for more information on using the GetProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProjectRequest method.
//	req, resp := client.GetProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject
func (c *DeviceFarm) GetProjectRequest(input *GetProjectInput) (req *request.Request, output *GetProjectOutput) {
	op := &request.Operation{
		Name:       opGetProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProjectInput{}
	}

	output = &GetProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProject API operation for AWS Device Farm.
//
// Gets information about a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetProject for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject
func (c *DeviceFarm) GetProject(input *GetProjectInput) (*GetProjectOutput, error) {
	req, out := c.GetProjectRequest(input)
	return out, req.Send()
}

// GetProjectWithContext is the same as GetProject with the addition of
// the ability to pass a context and additional request options.
//
// See GetProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetProjectWithContext(ctx aws.Context, input *GetProjectInput, opts ...request.Option) (*GetProjectOutput, error) {
	req, out := c.GetProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRemoteAccessSession = "GetRemoteAccessSession"

// GetRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetRemoteAccessSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRemoteAccessSession for more information on using the GetRemoteAccessSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRemoteAccessSessionRequest method.
//	req, resp := client.GetRemoteAccessSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession
func (c *DeviceFarm) GetRemoteAccessSessionRequest(input *GetRemoteAccessSessionInput) (req *request.Request, output *GetRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opGetRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRemoteAccessSessionInput{}
	}

	output = &GetRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRemoteAccessSession API operation for AWS Device Farm.
//
// Returns a link to a currently running remote access session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetRemoteAccessSession for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession
func (c *DeviceFarm) GetRemoteAccessSession(input *GetRemoteAccessSessionInput) (*GetRemoteAccessSessionOutput, error) {
	req, out := c.GetRemoteAccessSessionRequest(input)
	return out, req.Send()
}

// GetRemoteAccessSessionWithContext is the same as GetRemoteAccessSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetRemoteAccessSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetRemoteAccessSessionWithContext(ctx aws.Context, input *GetRemoteAccessSessionInput, opts ...request.Option) (*GetRemoteAccessSessionOutput, error) {
	req, out := c.GetRemoteAccessSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRun = "GetRun"

// GetRunRequest generates a "aws/request.Request" representing the
// client's request for the GetRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRun for more information on using the GetRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRunRequest method.
//	req, resp := client.GetRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun
func (c *DeviceFarm) GetRunRequest(input *GetRunInput) (req *request.Request, output *GetRunOutput) {
	op := &request.Operation{
		Name:       opGetRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRunInput{}
	}

	output = &GetRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRun API operation for AWS Device Farm.
//
// Gets information about a run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetRun for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun
func (c *DeviceFarm) GetRun(input *GetRunInput) (*GetRunOutput, error) {
	req, out := c.GetRunRequest(input)
	return out, req.Send()
}

// GetRunWithContext is the same as GetRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetRunWithContext(ctx aws.Context, input *GetRunInput, opts ...request.Option) (*GetRunOutput, error) {
	req, out := c.GetRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSuite = "GetSuite"

// GetSuiteRequest generates a "aws/request.Request" representing the
// client's request for the GetSuite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSuite for more information on using the GetSuite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSuiteRequest method.
//	req, resp := client.GetSuiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite
func (c *DeviceFarm) GetSuiteRequest(input *GetSuiteInput) (req *request.Request, output *GetSuiteOutput) {
	op := &request.Operation{
		Name:       opGetSuite,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSuiteInput{}
	}

	output = &GetSuiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSuite API operation for AWS Device Farm.
//
// Gets information about a suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetSuite for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite
func (c *DeviceFarm) GetSuite(input *GetSuiteInput) (*GetSuiteOutput, error) {
	req, out := c.GetSuiteRequest(input)
	return out, req.Send()
}

// GetSuiteWithContext is the same as GetSuite with the addition of
// the ability to pass a context and additional request options.
//
// See GetSuite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetSuiteWithContext(ctx aws.Context, input *GetSuiteInput, opts ...request.Option) (*GetSuiteOutput, error) {
	req, out := c.GetSuiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTest = "GetTest"

// GetTestRequest generates a "aws/request.Request" representing the
// client's request for the GetTest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTest for more information on using the GetTest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTestRequest method.
//	req, resp := client.GetTestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest
func (c *DeviceFarm) GetTestRequest(input *GetTestInput) (req *request.Request, output *GetTestOutput) {
	op := &request.Operation{
		Name:       opGetTest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTestInput{}
	}

	output = &GetTestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTest API operation for AWS Device Farm.
//
// Gets information about a test.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetTest for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest
func (c *DeviceFarm) GetTest(input *GetTestInput) (*GetTestOutput, error) {
	req, out := c.GetTestRequest(input)
	return out, req.Send()
}

// GetTestWithContext is the same as GetTest with the addition of
// the ability to pass a context and additional request options.
//
// See GetTest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetTestWithContext(ctx aws.Context, input *GetTestInput, opts ...request.Option) (*GetTestOutput, error) {
	req, out := c.GetTestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTestGridProject = "GetTestGridProject"

// GetTestGridProjectRequest generates a "aws/request.Request" representing the
// client's request for the GetTestGridProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTestGridProject for more information on using the GetTestGridProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTestGridProjectRequest method.
//	req, resp := client.GetTestGridProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridProject
func (c *DeviceFarm) GetTestGridProjectRequest(input *GetTestGridProjectInput) (req *request.Request, output *GetTestGridProjectOutput) {
	op := &request.Operation{
		Name:       opGetTestGridProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTestGridProjectInput{}
	}

	output = &GetTestGridProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTestGridProject API operation for AWS Device Farm.
//
// Retrieves information about a Selenium testing project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetTestGridProject for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridProject
func (c *DeviceFarm) GetTestGridProject(input *GetTestGridProjectInput) (*GetTestGridProjectOutput, error) {
	req, out := c.GetTestGridProjectRequest(input)
	return out, req.Send()
}

// GetTestGridProjectWithContext is the same as GetTestGridProject with the addition of
// the ability to pass a context and additional request options.
//
// See GetTestGridProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetTestGridProjectWithContext(ctx aws.Context, input *GetTestGridProjectInput, opts ...request.Option) (*GetTestGridProjectOutput, error) {
	req, out := c.GetTestGridProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTestGridSession = "GetTestGridSession"

// GetTestGridSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetTestGridSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTestGridSession for more information on using the GetTestGridSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTestGridSessionRequest method.
//	req, resp := client.GetTestGridSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridSession
func (c *DeviceFarm) GetTestGridSessionRequest(input *GetTestGridSessionInput) (req *request.Request, output *GetTestGridSessionOutput) {
	op := &request.Operation{
		Name:       opGetTestGridSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTestGridSessionInput{}
	}

	output = &GetTestGridSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTestGridSession API operation for AWS Device Farm.
//
// A session is an instance of a browser created through a RemoteWebDriver with
// the URL from CreateTestGridUrlResult$url. You can use the following to look
// up sessions:
//
//   - The session ARN (GetTestGridSessionRequest$sessionArn).
//
//   - The project ARN and a session ID (GetTestGridSessionRequest$projectArn
//     and GetTestGridSessionRequest$sessionId).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetTestGridSession for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridSession
func (c *DeviceFarm) GetTestGridSession(input *GetTestGridSessionInput) (*GetTestGridSessionOutput, error) {
	req, out := c.GetTestGridSessionRequest(input)
	return out, req.Send()
}

// GetTestGridSessionWithContext is the same as GetTestGridSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetTestGridSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetTestGridSessionWithContext(ctx aws.Context, input *GetTestGridSessionInput, opts ...request.Option) (*GetTestGridSessionOutput, error) {
	req, out := c.GetTestGridSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUpload = "GetUpload"

// GetUploadRequest generates a "aws/request.Request" representing the
// client's request for the GetUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUpload for more information on using the GetUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUploadRequest method.
//	req, resp := client.GetUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload
func (c *DeviceFarm) GetUploadRequest(input *GetUploadInput) (req *request.Request, output *GetUploadOutput) {
	op := &request.Operation{
		Name:       opGetUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUploadInput{}
	}

	output = &GetUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpload API operation for AWS Device Farm.
//
// Gets information about an upload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetUpload for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload
func (c *DeviceFarm) GetUpload(input *GetUploadInput) (*GetUploadOutput, error) {
	req, out := c.GetUploadRequest(input)
	return out, req.Send()
}

// GetUploadWithContext is the same as GetUpload with the addition of
// the ability to pass a context and additional request options.
//
// See GetUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetUploadWithContext(ctx aws.Context, input *GetUploadInput, opts ...request.Option) (*GetUploadOutput, error) {
	req, out := c.GetUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVPCEConfiguration = "GetVPCEConfiguration"

// GetVPCEConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetVPCEConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVPCEConfiguration for more information on using the GetVPCEConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVPCEConfigurationRequest method.
//	req, resp := client.GetVPCEConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetVPCEConfiguration
func (c *DeviceFarm) GetVPCEConfigurationRequest(input *GetVPCEConfigurationInput) (req *request.Request, output *GetVPCEConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetVPCEConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVPCEConfigurationInput{}
	}

	output = &GetVPCEConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVPCEConfiguration API operation for AWS Device Farm.
//
// Returns information about the configuration settings for your Amazon Virtual
// Private Cloud (VPC) endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetVPCEConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetVPCEConfiguration
func (c *DeviceFarm) GetVPCEConfiguration(input *GetVPCEConfigurationInput) (*GetVPCEConfigurationOutput, error) {
	req, out := c.GetVPCEConfigurationRequest(input)
	return out, req.Send()
}

// GetVPCEConfigurationWithContext is the same as GetVPCEConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetVPCEConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) GetVPCEConfigurationWithContext(ctx aws.Context, input *GetVPCEConfigurationInput, opts ...request.Option) (*GetVPCEConfigurationOutput, error) {
	req, out := c.GetVPCEConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInstallToRemoteAccessSession = "InstallToRemoteAccessSession"

// InstallToRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the InstallToRemoteAccessSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InstallToRemoteAccessSession for more information on using the InstallToRemoteAccessSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InstallToRemoteAccessSessionRequest method.
//	req, resp := client.InstallToRemoteAccessSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession
func (c *DeviceFarm) InstallToRemoteAccessSessionRequest(input *InstallToRemoteAccessSessionInput) (req *request.Request, output *InstallToRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opInstallToRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InstallToRemoteAccessSessionInput{}
	}

	output = &InstallToRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InstallToRemoteAccessSession API operation for AWS Device Farm.
//
// Installs an application to the device in a remote access session. For Android
// applications, the file must be in .apk format. For iOS applications, the
// file must be in .ipa format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation InstallToRemoteAccessSession for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession
func (c *DeviceFarm) InstallToRemoteAccessSession(input *InstallToRemoteAccessSessionInput) (*InstallToRemoteAccessSessionOutput, error) {
	req, out := c.InstallToRemoteAccessSessionRequest(input)
	return out, req.Send()
}

// InstallToRemoteAccessSessionWithContext is the same as InstallToRemoteAccessSession with the addition of
// the ability to pass a context and additional request options.
//
// See InstallToRemoteAccessSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) InstallToRemoteAccessSessionWithContext(ctx aws.Context, input *InstallToRemoteAccessSessionInput, opts ...request.Option) (*InstallToRemoteAccessSessionOutput, error) {
	req, out := c.InstallToRemoteAccessSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListArtifacts = "ListArtifacts"

// ListArtifactsRequest generates a "aws/request.Request" representing the
// client's request for the ListArtifacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListArtifacts for more information on using the ListArtifacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListArtifactsRequest method.
//	req, resp := client.ListArtifactsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts
func (c *DeviceFarm) ListArtifactsRequest(input *ListArtifactsInput) (req *request.Request, output *ListArtifactsOutput) {
	op := &request.Operation{
		Name:       opListArtifacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArtifactsInput{}
	}

	output = &ListArtifactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListArtifacts API operation for AWS Device Farm.
//
// Gets information about artifacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListArtifacts for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts
func (c *DeviceFarm) ListArtifacts(input *ListArtifactsInput) (*ListArtifactsOutput, error) {
	req, out := c.ListArtifactsRequest(input)
	return out, req.Send()
}

// ListArtifactsWithContext is the same as ListArtifacts with the addition of
// the ability to pass a context and additional request options.
//
// See ListArtifacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListArtifactsWithContext(ctx aws.Context, input *ListArtifactsInput, opts ...request.Option) (*ListArtifactsOutput, error) {
	req, out := c.ListArtifactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListArtifactsPages iterates over the pages of a ListArtifacts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListArtifacts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListArtifacts operation.
//	pageNum := 0
//	err := client.ListArtifactsPages(params,
//	    func(page *devicefarm.ListArtifactsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListArtifactsPages(input *ListArtifactsInput, fn func(*ListArtifactsOutput, bool) bool) error {
	return c.ListArtifactsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListArtifactsPagesWithContext same as ListArtifactsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListArtifactsPagesWithContext(ctx aws.Context, input *ListArtifactsInput, fn func(*ListArtifactsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListArtifactsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListArtifactsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListArtifactsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeviceInstances = "ListDeviceInstances"

// ListDeviceInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceInstances for more information on using the ListDeviceInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeviceInstancesRequest method.
//	req, resp := client.ListDeviceInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances
func (c *DeviceFarm) ListDeviceInstancesRequest(input *ListDeviceInstancesInput) (req *request.Request, output *ListDeviceInstancesOutput) {
	op := &request.Operation{
		Name:       opListDeviceInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDeviceInstancesInput{}
	}

	output = &ListDeviceInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceInstances API operation for AWS Device Farm.
//
// Returns information about the private device instances associated with one
// or more AWS accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListDeviceInstances for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances
func (c *DeviceFarm) ListDeviceInstances(input *ListDeviceInstancesInput) (*ListDeviceInstancesOutput, error) {
	req, out := c.ListDeviceInstancesRequest(input)
	return out, req.Send()
}

// ListDeviceInstancesWithContext is the same as ListDeviceInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListDeviceInstancesWithContext(ctx aws.Context, input *ListDeviceInstancesInput, opts ...request.Option) (*ListDeviceInstancesOutput, error) {
	req, out := c.ListDeviceInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDevicePools = "ListDevicePools"

// ListDevicePoolsRequest generates a "aws/request.Request" representing the
// client's request for the ListDevicePools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevicePools for more information on using the ListDevicePools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDevicePoolsRequest method.
//	req, resp := client.ListDevicePoolsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools
func (c *DeviceFarm) ListDevicePoolsRequest(input *ListDevicePoolsInput) (req *request.Request, output *ListDevicePoolsOutput) {
	op := &request.Operation{
		Name:       opListDevicePools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicePoolsInput{}
	}

	output = &ListDevicePoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevicePools API operation for AWS Device Farm.
//
// Gets information about device pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListDevicePools for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools
func (c *DeviceFarm) ListDevicePools(input *ListDevicePoolsInput) (*ListDevicePoolsOutput, error) {
	req, out := c.ListDevicePoolsRequest(input)
	return out, req.Send()
}

// ListDevicePoolsWithContext is the same as ListDevicePools with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevicePools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListDevicePoolsWithContext(ctx aws.Context, input *ListDevicePoolsInput, opts ...request.Option) (*ListDevicePoolsOutput, error) {
	req, out := c.ListDevicePoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevicePoolsPages iterates over the pages of a ListDevicePools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevicePools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDevicePools operation.
//	pageNum := 0
//	err := client.ListDevicePoolsPages(params,
//	    func(page *devicefarm.ListDevicePoolsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListDevicePoolsPages(input *ListDevicePoolsInput, fn func(*ListDevicePoolsOutput, bool) bool) error {
	return c.ListDevicePoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevicePoolsPagesWithContext same as ListDevicePoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListDevicePoolsPagesWithContext(ctx aws.Context, input *ListDevicePoolsInput, fn func(*ListDevicePoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevicePoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevicePoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevicePoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevices for more information on using the ListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDevicesRequest method.
//	req, resp := client.ListDevicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices
func (c *DeviceFarm) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevices API operation for AWS Device Farm.
//
// Gets information about unique device types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListDevices for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices
func (c *DeviceFarm) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	return out, req.Send()
}

// ListDevicesWithContext is the same as ListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListDevicesWithContext(ctx aws.Context, input *ListDevicesInput, opts ...request.Option) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevicesPages iterates over the pages of a ListDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDevices operation.
//	pageNum := 0
//	err := client.ListDevicesPages(params,
//	    func(page *devicefarm.ListDevicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListDevicesPages(input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool) error {
	return c.ListDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevicesPagesWithContext same as ListDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListDevicesPagesWithContext(ctx aws.Context, input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstanceProfiles = "ListInstanceProfiles"

// ListInstanceProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstanceProfiles for more information on using the ListInstanceProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInstanceProfilesRequest method.
//	req, resp := client.ListInstanceProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles
func (c *DeviceFarm) ListInstanceProfilesRequest(input *ListInstanceProfilesInput) (req *request.Request, output *ListInstanceProfilesOutput) {
	op := &request.Operation{
		Name:       opListInstanceProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListInstanceProfilesInput{}
	}

	output = &ListInstanceProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceProfiles API operation for AWS Device Farm.
//
// Returns information about all the instance profiles in an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListInstanceProfiles for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles
func (c *DeviceFarm) ListInstanceProfiles(input *ListInstanceProfilesInput) (*ListInstanceProfilesOutput, error) {
	req, out := c.ListInstanceProfilesRequest(input)
	return out, req.Send()
}

// ListInstanceProfilesWithContext is the same as ListInstanceProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstanceProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListInstanceProfilesWithContext(ctx aws.Context, input *ListInstanceProfilesInput, opts ...request.Option) (*ListInstanceProfilesOutput, error) {
	req, out := c.ListInstanceProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJobsRequest method.
//	req, resp := client.ListJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs
func (c *DeviceFarm) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS Device Farm.
//
// Gets information about jobs for a given test run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs
func (c *DeviceFarm) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJobs operation.
//	pageNum := 0
//	err := client.ListJobsPages(params,
//	    func(page *devicefarm.ListJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNetworkProfiles = "ListNetworkProfiles"

// ListNetworkProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListNetworkProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNetworkProfiles for more information on using the ListNetworkProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNetworkProfilesRequest method.
//	req, resp := client.ListNetworkProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListNetworkProfiles
func (c *DeviceFarm) ListNetworkProfilesRequest(input *ListNetworkProfilesInput) (req *request.Request, output *ListNetworkProfilesOutput) {
	op := &request.Operation{
		Name:       opListNetworkProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListNetworkProfilesInput{}
	}

	output = &ListNetworkProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNetworkProfiles API operation for AWS Device Farm.
//
// Returns the list of available network profiles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListNetworkProfiles for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListNetworkProfiles
func (c *DeviceFarm) ListNetworkProfiles(input *ListNetworkProfilesInput) (*ListNetworkProfilesOutput, error) {
	req, out := c.ListNetworkProfilesRequest(input)
	return out, req.Send()
}

// ListNetworkProfilesWithContext is the same as ListNetworkProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListNetworkProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListNetworkProfilesWithContext(ctx aws.Context, input *ListNetworkProfilesInput, opts ...request.Option) (*ListNetworkProfilesOutput, error) {
	req, out := c.ListNetworkProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOfferingPromotions = "ListOfferingPromotions"

// ListOfferingPromotionsRequest generates a "aws/request.Request" representing the
// client's request for the ListOfferingPromotions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOfferingPromotions for more information on using the ListOfferingPromotions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOfferingPromotionsRequest method.
//	req, resp := client.ListOfferingPromotionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions
func (c *DeviceFarm) ListOfferingPromotionsRequest(input *ListOfferingPromotionsInput) (req *request.Request, output *ListOfferingPromotionsOutput) {
	op := &request.Operation{
		Name:       opListOfferingPromotions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListOfferingPromotionsInput{}
	}

	output = &ListOfferingPromotionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOfferingPromotions API operation for AWS Device Farm.
//
// Returns a list of offering promotions. Each offering promotion record contains
// the ID and description of the promotion. The API returns a NotEligible error
// if the caller is not permitted to invoke the operation. Contact aws-devicefarm-support@amazon.com
// (mailto:aws-devicefarm-support@amazon.com) if you must be able to invoke
// this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListOfferingPromotions for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - NotEligibleException
//     Exception gets thrown when a user is not eligible to perform the specified
//     transaction.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions
func (c *DeviceFarm) ListOfferingPromotions(input *ListOfferingPromotionsInput) (*ListOfferingPromotionsOutput, error) {
	req, out := c.ListOfferingPromotionsRequest(input)
	return out, req.Send()
}

// ListOfferingPromotionsWithContext is the same as ListOfferingPromotions with the addition of
// the ability to pass a context and additional request options.
//
// See ListOfferingPromotions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListOfferingPromotionsWithContext(ctx aws.Context, input *ListOfferingPromotionsInput, opts ...request.Option) (*ListOfferingPromotionsOutput, error) {
	req, out := c.ListOfferingPromotionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOfferingTransactions = "ListOfferingTransactions"

// ListOfferingTransactionsRequest generates a "aws/request.Request" representing the
// client's request for the ListOfferingTransactions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOfferingTransactions for more information on using the ListOfferingTransactions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOfferingTransactionsRequest method.
//	req, resp := client.ListOfferingTransactionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions
func (c *DeviceFarm) ListOfferingTransactionsRequest(input *ListOfferingTransactionsInput) (req *request.Request, output *ListOfferingTransactionsOutput) {
	op := &request.Operation{
		Name:       opListOfferingTransactions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOfferingTransactionsInput{}
	}

	output = &ListOfferingTransactionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOfferingTransactions API operation for AWS Device Farm.
//
// Returns a list of all historical purchases, renewals, and system renewal
// transactions for an AWS account. The list is paginated and ordered by a descending
// timestamp (most recent transactions are first). The API returns a NotEligible
// error if the user is not permitted to invoke the operation. If you must be
// able to invoke this operation, contact aws-devicefarm-support@amazon.com
// (mailto:aws-devicefarm-support@amazon.com).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListOfferingTransactions for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - NotEligibleException
//     Exception gets thrown when a user is not eligible to perform the specified
//     transaction.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions
func (c *DeviceFarm) ListOfferingTransactions(input *ListOfferingTransactionsInput) (*ListOfferingTransactionsOutput, error) {
	req, out := c.ListOfferingTransactionsRequest(input)
	return out, req.Send()
}

// ListOfferingTransactionsWithContext is the same as ListOfferingTransactions with the addition of
// the ability to pass a context and additional request options.
//
// See ListOfferingTransactions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListOfferingTransactionsWithContext(ctx aws.Context, input *ListOfferingTransactionsInput, opts ...request.Option) (*ListOfferingTransactionsOutput, error) {
	req, out := c.ListOfferingTransactionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOfferingTransactionsPages iterates over the pages of a ListOfferingTransactions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOfferingTransactions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOfferingTransactions operation.
//	pageNum := 0
//	err := client.ListOfferingTransactionsPages(params,
//	    func(page *devicefarm.ListOfferingTransactionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListOfferingTransactionsPages(input *ListOfferingTransactionsInput, fn func(*ListOfferingTransactionsOutput, bool) bool) error {
	return c.ListOfferingTransactionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOfferingTransactionsPagesWithContext same as ListOfferingTransactionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListOfferingTransactionsPagesWithContext(ctx aws.Context, input *ListOfferingTransactionsInput, fn func(*ListOfferingTransactionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOfferingTransactionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOfferingTransactionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOfferingTransactionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOfferings = "ListOfferings"

// ListOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the ListOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOfferings for more information on using the ListOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOfferingsRequest method.
//	req, resp := client.ListOfferingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings
func (c *DeviceFarm) ListOfferingsRequest(input *ListOfferingsInput) (req *request.Request, output *ListOfferingsOutput) {
	op := &request.Operation{
		Name:       opListOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOfferingsInput{}
	}

	output = &ListOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOfferings API operation for AWS Device Farm.
//
// Returns a list of products or offerings that the user can manage through
// the API. Each offering record indicates the recurring price per unit and
// the frequency for that offering. The API returns a NotEligible error if the
// user is not permitted to invoke the operation. If you must be able to invoke
// this operation, contact aws-devicefarm-support@amazon.com (mailto:aws-devicefarm-support@amazon.com).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListOfferings for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - NotEligibleException
//     Exception gets thrown when a user is not eligible to perform the specified
//     transaction.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings
func (c *DeviceFarm) ListOfferings(input *ListOfferingsInput) (*ListOfferingsOutput, error) {
	req, out := c.ListOfferingsRequest(input)
	return out, req.Send()
}

// ListOfferingsWithContext is the same as ListOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See ListOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListOfferingsWithContext(ctx aws.Context, input *ListOfferingsInput, opts ...request.Option) (*ListOfferingsOutput, error) {
	req, out := c.ListOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOfferingsPages iterates over the pages of a ListOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOfferings operation.
//	pageNum := 0
//	err := client.ListOfferingsPages(params,
//	    func(page *devicefarm.ListOfferingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListOfferingsPages(input *ListOfferingsInput, fn func(*ListOfferingsOutput, bool) bool) error {
	return c.ListOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOfferingsPagesWithContext same as ListOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListOfferingsPagesWithContext(ctx aws.Context, input *ListOfferingsInput, fn func(*ListOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProjectsRequest method.
//	req, resp := client.ListProjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects
func (c *DeviceFarm) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS Device Farm.
//
// Gets information about projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects
func (c *DeviceFarm) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProjects operation.
//	pageNum := 0
//	err := client.ListProjectsPages(params,
//	    func(page *devicefarm.ListProjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRemoteAccessSessions = "ListRemoteAccessSessions"

// ListRemoteAccessSessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListRemoteAccessSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRemoteAccessSessions for more information on using the ListRemoteAccessSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRemoteAccessSessionsRequest method.
//	req, resp := client.ListRemoteAccessSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions
func (c *DeviceFarm) ListRemoteAccessSessionsRequest(input *ListRemoteAccessSessionsInput) (req *request.Request, output *ListRemoteAccessSessionsOutput) {
	op := &request.Operation{
		Name:       opListRemoteAccessSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRemoteAccessSessionsInput{}
	}

	output = &ListRemoteAccessSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRemoteAccessSessions API operation for AWS Device Farm.
//
// Returns a list of all currently running remote access sessions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListRemoteAccessSessions for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions
func (c *DeviceFarm) ListRemoteAccessSessions(input *ListRemoteAccessSessionsInput) (*ListRemoteAccessSessionsOutput, error) {
	req, out := c.ListRemoteAccessSessionsRequest(input)
	return out, req.Send()
}

// ListRemoteAccessSessionsWithContext is the same as ListRemoteAccessSessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListRemoteAccessSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListRemoteAccessSessionsWithContext(ctx aws.Context, input *ListRemoteAccessSessionsInput, opts ...request.Option) (*ListRemoteAccessSessionsOutput, error) {
	req, out := c.ListRemoteAccessSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRuns = "ListRuns"

// ListRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuns for more information on using the ListRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRunsRequest method.
//	req, resp := client.ListRunsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns
func (c *DeviceFarm) ListRunsRequest(input *ListRunsInput) (req *request.Request, output *ListRunsOutput) {
	op := &request.Operation{
		Name:       opListRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRunsInput{}
	}

	output = &ListRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuns API operation for AWS Device Farm.
//
// Gets information about runs, given an AWS Device Farm project ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListRuns for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns
func (c *DeviceFarm) ListRuns(input *ListRunsInput) (*ListRunsOutput, error) {
	req, out := c.ListRunsRequest(input)
	return out, req.Send()
}

// ListRunsWithContext is the same as ListRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListRunsWithContext(ctx aws.Context, input *ListRunsInput, opts ...request.Option) (*ListRunsOutput, error) {
	req, out := c.ListRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRunsPages iterates over the pages of a ListRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRuns operation.
//	pageNum := 0
//	err := client.ListRunsPages(params,
//	    func(page *devicefarm.ListRunsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListRunsPages(input *ListRunsInput, fn func(*ListRunsOutput, bool) bool) error {
	return c.ListRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRunsPagesWithContext same as ListRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListRunsPagesWithContext(ctx aws.Context, input *ListRunsInput, fn func(*ListRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSamples = "ListSamples"

// ListSamplesRequest generates a "aws/request.Request" representing the
// client's request for the ListSamples operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSamples for more information on using the ListSamples
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSamplesRequest method.
//	req, resp := client.ListSamplesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples
func (c *DeviceFarm) ListSamplesRequest(input *ListSamplesInput) (req *request.Request, output *ListSamplesOutput) {
	op := &request.Operation{
		Name:       opListSamples,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSamplesInput{}
	}

	output = &ListSamplesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSamples API operation for AWS Device Farm.
//
// Gets information about samples, given an AWS Device Farm job ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListSamples for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples
func (c *DeviceFarm) ListSamples(input *ListSamplesInput) (*ListSamplesOutput, error) {
	req, out := c.ListSamplesRequest(input)
	return out, req.Send()
}

// ListSamplesWithContext is the same as ListSamples with the addition of
// the ability to pass a context and additional request options.
//
// See ListSamples for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListSamplesWithContext(ctx aws.Context, input *ListSamplesInput, opts ...request.Option) (*ListSamplesOutput, error) {
	req, out := c.ListSamplesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSamplesPages iterates over the pages of a ListSamples operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSamples method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSamples operation.
//	pageNum := 0
//	err := client.ListSamplesPages(params,
//	    func(page *devicefarm.ListSamplesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListSamplesPages(input *ListSamplesInput, fn func(*ListSamplesOutput, bool) bool) error {
	return c.ListSamplesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSamplesPagesWithContext same as ListSamplesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListSamplesPagesWithContext(ctx aws.Context, input *ListSamplesInput, fn func(*ListSamplesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSamplesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSamplesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSamplesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSuites = "ListSuites"

// ListSuitesRequest generates a "aws/request.Request" representing the
// client's request for the ListSuites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSuites for more information on using the ListSuites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSuitesRequest method.
//	req, resp := client.ListSuitesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites
func (c *DeviceFarm) ListSuitesRequest(input *ListSuitesInput) (req *request.Request, output *ListSuitesOutput) {
	op := &request.Operation{
		Name:       opListSuites,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSuitesInput{}
	}

	output = &ListSuitesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSuites API operation for AWS Device Farm.
//
// Gets information about test suites for a given job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListSuites for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites
func (c *DeviceFarm) ListSuites(input *ListSuitesInput) (*ListSuitesOutput, error) {
	req, out := c.ListSuitesRequest(input)
	return out, req.Send()
}

// ListSuitesWithContext is the same as ListSuites with the addition of
// the ability to pass a context and additional request options.
//
// See ListSuites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListSuitesWithContext(ctx aws.Context, input *ListSuitesInput, opts ...request.Option) (*ListSuitesOutput, error) {
	req, out := c.ListSuitesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSuitesPages iterates over the pages of a ListSuites operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSuites method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSuites operation.
//	pageNum := 0
//	err := client.ListSuitesPages(params,
//	    func(page *devicefarm.ListSuitesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListSuitesPages(input *ListSuitesInput, fn func(*ListSuitesOutput, bool) bool) error {
	return c.ListSuitesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSuitesPagesWithContext same as ListSuitesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListSuitesPagesWithContext(ctx aws.Context, input *ListSuitesInput, fn func(*ListSuitesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSuitesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSuitesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSuitesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTagsForResource
func (c *DeviceFarm) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Device Farm.
//
// List the tags for an AWS Device Farm resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - TagOperationException
//     The operation was not successful. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTagsForResource
func (c *DeviceFarm) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTestGridProjects = "ListTestGridProjects"

// ListTestGridProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestGridProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestGridProjects for more information on using the ListTestGridProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestGridProjectsRequest method.
//	req, resp := client.ListTestGridProjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridProjects
func (c *DeviceFarm) ListTestGridProjectsRequest(input *ListTestGridProjectsInput) (req *request.Request, output *ListTestGridProjectsOutput) {
	op := &request.Operation{
		Name:       opListTestGridProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResult",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestGridProjectsInput{}
	}

	output = &ListTestGridProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestGridProjects API operation for AWS Device Farm.
//
// Gets a list of all Selenium testing projects in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListTestGridProjects for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridProjects
func (c *DeviceFarm) ListTestGridProjects(input *ListTestGridProjectsInput) (*ListTestGridProjectsOutput, error) {
	req, out := c.ListTestGridProjectsRequest(input)
	return out, req.Send()
}

// ListTestGridProjectsWithContext is the same as ListTestGridProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestGridProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestGridProjectsWithContext(ctx aws.Context, input *ListTestGridProjectsInput, opts ...request.Option) (*ListTestGridProjectsOutput, error) {
	req, out := c.ListTestGridProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestGridProjectsPages iterates over the pages of a ListTestGridProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestGridProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestGridProjects operation.
//	pageNum := 0
//	err := client.ListTestGridProjectsPages(params,
//	    func(page *devicefarm.ListTestGridProjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListTestGridProjectsPages(input *ListTestGridProjectsInput, fn func(*ListTestGridProjectsOutput, bool) bool) error {
	return c.ListTestGridProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestGridProjectsPagesWithContext same as ListTestGridProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestGridProjectsPagesWithContext(ctx aws.Context, input *ListTestGridProjectsInput, fn func(*ListTestGridProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestGridProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestGridProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestGridProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestGridSessionActions = "ListTestGridSessionActions"

// ListTestGridSessionActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestGridSessionActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestGridSessionActions for more information on using the ListTestGridSessionActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestGridSessionActionsRequest method.
//	req, resp := client.ListTestGridSessionActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionActions
func (c *DeviceFarm) ListTestGridSessionActionsRequest(input *ListTestGridSessionActionsInput) (req *request.Request, output *ListTestGridSessionActionsOutput) {
	op := &request.Operation{
		Name:       opListTestGridSessionActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResult",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestGridSessionActionsInput{}
	}

	output = &ListTestGridSessionActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestGridSessionActions API operation for AWS Device Farm.
//
// Returns a list of the actions taken in a TestGridSession.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListTestGridSessionActions for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionActions
func (c *DeviceFarm) ListTestGridSessionActions(input *ListTestGridSessionActionsInput) (*ListTestGridSessionActionsOutput, error) {
	req, out := c.ListTestGridSessionActionsRequest(input)
	return out, req.Send()
}

// ListTestGridSessionActionsWithContext is the same as ListTestGridSessionActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestGridSessionActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestGridSessionActionsWithContext(ctx aws.Context, input *ListTestGridSessionActionsInput, opts ...request.Option) (*ListTestGridSessionActionsOutput, error) {
	req, out := c.ListTestGridSessionActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestGridSessionActionsPages iterates over the pages of a ListTestGridSessionActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestGridSessionActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestGridSessionActions operation.
//	pageNum := 0
//	err := client.ListTestGridSessionActionsPages(params,
//	    func(page *devicefarm.ListTestGridSessionActionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListTestGridSessionActionsPages(input *ListTestGridSessionActionsInput, fn func(*ListTestGridSessionActionsOutput, bool) bool) error {
	return c.ListTestGridSessionActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestGridSessionActionsPagesWithContext same as ListTestGridSessionActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestGridSessionActionsPagesWithContext(ctx aws.Context, input *ListTestGridSessionActionsInput, fn func(*ListTestGridSessionActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestGridSessionActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestGridSessionActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestGridSessionActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestGridSessionArtifacts = "ListTestGridSessionArtifacts"

// ListTestGridSessionArtifactsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestGridSessionArtifacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestGridSessionArtifacts for more information on using the ListTestGridSessionArtifacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestGridSessionArtifactsRequest method.
//	req, resp := client.ListTestGridSessionArtifactsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionArtifacts
func (c *DeviceFarm) ListTestGridSessionArtifactsRequest(input *ListTestGridSessionArtifactsInput) (req *request.Request, output *ListTestGridSessionArtifactsOutput) {
	op := &request.Operation{
		Name:       opListTestGridSessionArtifacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResult",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestGridSessionArtifactsInput{}
	}

	output = &ListTestGridSessionArtifactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestGridSessionArtifacts API operation for AWS Device Farm.
//
// Retrieves a list of artifacts created during the session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListTestGridSessionArtifacts for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionArtifacts
func (c *DeviceFarm) ListTestGridSessionArtifacts(input *ListTestGridSessionArtifactsInput) (*ListTestGridSessionArtifactsOutput, error) {
	req, out := c.ListTestGridSessionArtifactsRequest(input)
	return out, req.Send()
}

// ListTestGridSessionArtifactsWithContext is the same as ListTestGridSessionArtifacts with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestGridSessionArtifacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestGridSessionArtifactsWithContext(ctx aws.Context, input *ListTestGridSessionArtifactsInput, opts ...request.Option) (*ListTestGridSessionArtifactsOutput, error) {
	req, out := c.ListTestGridSessionArtifactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestGridSessionArtifactsPages iterates over the pages of a ListTestGridSessionArtifacts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestGridSessionArtifacts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestGridSessionArtifacts operation.
//	pageNum := 0
//	err := client.ListTestGridSessionArtifactsPages(params,
//	    func(page *devicefarm.ListTestGridSessionArtifactsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListTestGridSessionArtifactsPages(input *ListTestGridSessionArtifactsInput, fn func(*ListTestGridSessionArtifactsOutput, bool) bool) error {
	return c.ListTestGridSessionArtifactsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestGridSessionArtifactsPagesWithContext same as ListTestGridSessionArtifactsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestGridSessionArtifactsPagesWithContext(ctx aws.Context, input *ListTestGridSessionArtifactsInput, fn func(*ListTestGridSessionArtifactsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestGridSessionArtifactsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestGridSessionArtifactsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestGridSessionArtifactsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestGridSessions = "ListTestGridSessions"

// ListTestGridSessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestGridSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestGridSessions for more information on using the ListTestGridSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestGridSessionsRequest method.
//	req, resp := client.ListTestGridSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessions
func (c *DeviceFarm) ListTestGridSessionsRequest(input *ListTestGridSessionsInput) (req *request.Request, output *ListTestGridSessionsOutput) {
	op := &request.Operation{
		Name:       opListTestGridSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResult",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestGridSessionsInput{}
	}

	output = &ListTestGridSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestGridSessions API operation for AWS Device Farm.
//
// Retrieves a list of sessions for a TestGridProject.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListTestGridSessions for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessions
func (c *DeviceFarm) ListTestGridSessions(input *ListTestGridSessionsInput) (*ListTestGridSessionsOutput, error) {
	req, out := c.ListTestGridSessionsRequest(input)
	return out, req.Send()
}

// ListTestGridSessionsWithContext is the same as ListTestGridSessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestGridSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestGridSessionsWithContext(ctx aws.Context, input *ListTestGridSessionsInput, opts ...request.Option) (*ListTestGridSessionsOutput, error) {
	req, out := c.ListTestGridSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestGridSessionsPages iterates over the pages of a ListTestGridSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestGridSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestGridSessions operation.
//	pageNum := 0
//	err := client.ListTestGridSessionsPages(params,
//	    func(page *devicefarm.ListTestGridSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListTestGridSessionsPages(input *ListTestGridSessionsInput, fn func(*ListTestGridSessionsOutput, bool) bool) error {
	return c.ListTestGridSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestGridSessionsPagesWithContext same as ListTestGridSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestGridSessionsPagesWithContext(ctx aws.Context, input *ListTestGridSessionsInput, fn func(*ListTestGridSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestGridSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestGridSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestGridSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTests = "ListTests"

// ListTestsRequest generates a "aws/request.Request" representing the
// client's request for the ListTests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTests for more information on using the ListTests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestsRequest method.
//	req, resp := client.ListTestsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests
func (c *DeviceFarm) ListTestsRequest(input *ListTestsInput) (req *request.Request, output *ListTestsOutput) {
	op := &request.Operation{
		Name:       opListTests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestsInput{}
	}

	output = &ListTestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTests API operation for AWS Device Farm.
//
// Gets information about tests in a given test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListTests for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests
func (c *DeviceFarm) ListTests(input *ListTestsInput) (*ListTestsOutput, error) {
	req, out := c.ListTestsRequest(input)
	return out, req.Send()
}

// ListTestsWithContext is the same as ListTests with the addition of
// the ability to pass a context and additional request options.
//
// See ListTests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestsWithContext(ctx aws.Context, input *ListTestsInput, opts ...request.Option) (*ListTestsOutput, error) {
	req, out := c.ListTestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestsPages iterates over the pages of a ListTests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTests operation.
//	pageNum := 0
//	err := client.ListTestsPages(params,
//	    func(page *devicefarm.ListTestsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListTestsPages(input *ListTestsInput, fn func(*ListTestsOutput, bool) bool) error {
	return c.ListTestsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestsPagesWithContext same as ListTestsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListTestsPagesWithContext(ctx aws.Context, input *ListTestsInput, fn func(*ListTestsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUniqueProblems = "ListUniqueProblems"

// ListUniqueProblemsRequest generates a "aws/request.Request" representing the
// client's request for the ListUniqueProblems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUniqueProblems for more information on using the ListUniqueProblems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUniqueProblemsRequest method.
//	req, resp := client.ListUniqueProblemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems
func (c *DeviceFarm) ListUniqueProblemsRequest(input *ListUniqueProblemsInput) (req *request.Request, output *ListUniqueProblemsOutput) {
	op := &request.Operation{
		Name:       opListUniqueProblems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUniqueProblemsInput{}
	}

	output = &ListUniqueProblemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUniqueProblems API operation for AWS Device Farm.
//
// Gets information about unique problems, such as exceptions or crashes.
//
// Unique problems are defined as a single instance of an error across a run,
// job, or suite. For example, if a call in your application consistently raises
// an exception (OutOfBoundsException in MyActivity.java:386), ListUniqueProblems
// returns a single entry instead of many individual entries for that exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListUniqueProblems for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems
func (c *DeviceFarm) ListUniqueProblems(input *ListUniqueProblemsInput) (*ListUniqueProblemsOutput, error) {
	req, out := c.ListUniqueProblemsRequest(input)
	return out, req.Send()
}

// ListUniqueProblemsWithContext is the same as ListUniqueProblems with the addition of
// the ability to pass a context and additional request options.
//
// See ListUniqueProblems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListUniqueProblemsWithContext(ctx aws.Context, input *ListUniqueProblemsInput, opts ...request.Option) (*ListUniqueProblemsOutput, error) {
	req, out := c.ListUniqueProblemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUniqueProblemsPages iterates over the pages of a ListUniqueProblems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUniqueProblems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUniqueProblems operation.
//	pageNum := 0
//	err := client.ListUniqueProblemsPages(params,
//	    func(page *devicefarm.ListUniqueProblemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListUniqueProblemsPages(input *ListUniqueProblemsInput, fn func(*ListUniqueProblemsOutput, bool) bool) error {
	return c.ListUniqueProblemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUniqueProblemsPagesWithContext same as ListUniqueProblemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListUniqueProblemsPagesWithContext(ctx aws.Context, input *ListUniqueProblemsInput, fn func(*ListUniqueProblemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUniqueProblemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUniqueProblemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUniqueProblemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUploads = "ListUploads"

// ListUploadsRequest generates a "aws/request.Request" representing the
// client's request for the ListUploads operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUploads for more information on using the ListUploads
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUploadsRequest method.
//	req, resp := client.ListUploadsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads
func (c *DeviceFarm) ListUploadsRequest(input *ListUploadsInput) (req *request.Request, output *ListUploadsOutput) {
	op := &request.Operation{
		Name:       opListUploads,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUploadsInput{}
	}

	output = &ListUploadsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUploads API operation for AWS Device Farm.
//
// Gets information about uploads, given an AWS Device Farm project ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListUploads for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads
func (c *DeviceFarm) ListUploads(input *ListUploadsInput) (*ListUploadsOutput, error) {
	req, out := c.ListUploadsRequest(input)
	return out, req.Send()
}

// ListUploadsWithContext is the same as ListUploads with the addition of
// the ability to pass a context and additional request options.
//
// See ListUploads for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListUploadsWithContext(ctx aws.Context, input *ListUploadsInput, opts ...request.Option) (*ListUploadsOutput, error) {
	req, out := c.ListUploadsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUploadsPages iterates over the pages of a ListUploads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUploads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUploads operation.
//	pageNum := 0
//	err := client.ListUploadsPages(params,
//	    func(page *devicefarm.ListUploadsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DeviceFarm) ListUploadsPages(input *ListUploadsInput, fn func(*ListUploadsOutput, bool) bool) error {
	return c.ListUploadsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUploadsPagesWithContext same as ListUploadsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListUploadsPagesWithContext(ctx aws.Context, input *ListUploadsInput, fn func(*ListUploadsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUploadsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUploadsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUploadsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVPCEConfigurations = "ListVPCEConfigurations"

// ListVPCEConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListVPCEConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVPCEConfigurations for more information on using the ListVPCEConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVPCEConfigurationsRequest method.
//	req, resp := client.ListVPCEConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListVPCEConfigurations
func (c *DeviceFarm) ListVPCEConfigurationsRequest(input *ListVPCEConfigurationsInput) (req *request.Request, output *ListVPCEConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListVPCEConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVPCEConfigurationsInput{}
	}

	output = &ListVPCEConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVPCEConfigurations API operation for AWS Device Farm.
//
// Returns information about all Amazon Virtual Private Cloud (VPC) endpoint
// configurations in the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListVPCEConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListVPCEConfigurations
func (c *DeviceFarm) ListVPCEConfigurations(input *ListVPCEConfigurationsInput) (*ListVPCEConfigurationsOutput, error) {
	req, out := c.ListVPCEConfigurationsRequest(input)
	return out, req.Send()
}

// ListVPCEConfigurationsWithContext is the same as ListVPCEConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListVPCEConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ListVPCEConfigurationsWithContext(ctx aws.Context, input *ListVPCEConfigurationsInput, opts ...request.Option) (*ListVPCEConfigurationsOutput, error) {
	req, out := c.ListVPCEConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseOffering = "PurchaseOffering"

// PurchaseOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseOffering for more information on using the PurchaseOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PurchaseOfferingRequest method.
//	req, resp := client.PurchaseOfferingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering
func (c *DeviceFarm) PurchaseOfferingRequest(input *PurchaseOfferingInput) (req *request.Request, output *PurchaseOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseOfferingInput{}
	}

	output = &PurchaseOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseOffering API operation for AWS Device Farm.
//
// Immediately purchases offerings for an AWS account. Offerings renew with
// the latest total purchased quantity for an offering, unless the renewal was
// overridden. The API returns a NotEligible error if the user is not permitted
// to invoke the operation. If you must be able to invoke this operation, contact
// aws-devicefarm-support@amazon.com (mailto:aws-devicefarm-support@amazon.com).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation PurchaseOffering for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - NotEligibleException
//     Exception gets thrown when a user is not eligible to perform the specified
//     transaction.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering
func (c *DeviceFarm) PurchaseOffering(input *PurchaseOfferingInput) (*PurchaseOfferingOutput, error) {
	req, out := c.PurchaseOfferingRequest(input)
	return out, req.Send()
}

// PurchaseOfferingWithContext is the same as PurchaseOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) PurchaseOfferingWithContext(ctx aws.Context, input *PurchaseOfferingInput, opts ...request.Option) (*PurchaseOfferingOutput, error) {
	req, out := c.PurchaseOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRenewOffering = "RenewOffering"

// RenewOfferingRequest generates a "aws/request.Request" representing the
// client's request for the RenewOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RenewOffering for more information on using the RenewOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RenewOfferingRequest method.
//	req, resp := client.RenewOfferingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering
func (c *DeviceFarm) RenewOfferingRequest(input *RenewOfferingInput) (req *request.Request, output *RenewOfferingOutput) {
	op := &request.Operation{
		Name:       opRenewOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenewOfferingInput{}
	}

	output = &RenewOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RenewOffering API operation for AWS Device Farm.
//
// Explicitly sets the quantity of devices to renew for an offering, starting
// from the effectiveDate of the next period. The API returns a NotEligible
// error if the user is not permitted to invoke the operation. If you must be
// able to invoke this operation, contact aws-devicefarm-support@amazon.com
// (mailto:aws-devicefarm-support@amazon.com).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation RenewOffering for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - NotEligibleException
//     Exception gets thrown when a user is not eligible to perform the specified
//     transaction.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering
func (c *DeviceFarm) RenewOffering(input *RenewOfferingInput) (*RenewOfferingOutput, error) {
	req, out := c.RenewOfferingRequest(input)
	return out, req.Send()
}

// RenewOfferingWithContext is the same as RenewOffering with the addition of
// the ability to pass a context and additional request options.
//
// See RenewOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) RenewOfferingWithContext(ctx aws.Context, input *RenewOfferingInput, opts ...request.Option) (*RenewOfferingOutput, error) {
	req, out := c.RenewOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opScheduleRun = "ScheduleRun"

// ScheduleRunRequest generates a "aws/request.Request" representing the
// client's request for the ScheduleRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ScheduleRun for more information on using the ScheduleRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ScheduleRunRequest method.
//	req, resp := client.ScheduleRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun
func (c *DeviceFarm) ScheduleRunRequest(input *ScheduleRunInput) (req *request.Request, output *ScheduleRunOutput) {
	op := &request.Operation{
		Name:       opScheduleRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScheduleRunInput{}
	}

	output = &ScheduleRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ScheduleRun API operation for AWS Device Farm.
//
// Schedules a run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ScheduleRun for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - IdempotencyException
//     An entity with the same name already exists.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun
func (c *DeviceFarm) ScheduleRun(input *ScheduleRunInput) (*ScheduleRunOutput, error) {
	req, out := c.ScheduleRunRequest(input)
	return out, req.Send()
}

// ScheduleRunWithContext is the same as ScheduleRun with the addition of
// the ability to pass a context and additional request options.
//
// See ScheduleRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) ScheduleRunWithContext(ctx aws.Context, input *ScheduleRunInput, opts ...request.Option) (*ScheduleRunOutput, error) {
	req, out := c.ScheduleRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopJob = "StopJob"

// StopJobRequest generates a "aws/request.Request" representing the
// client's request for the StopJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopJob for more information on using the StopJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopJobRequest method.
//	req, resp := client.StopJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJob
func (c *DeviceFarm) StopJobRequest(input *StopJobInput) (req *request.Request, output *StopJobOutput) {
	op := &request.Operation{
		Name:       opStopJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopJobInput{}
	}

	output = &StopJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopJob API operation for AWS Device Farm.
//
// Initiates a stop request for the current job. AWS Device Farm immediately
// stops the job on the device where tests have not started. You are not billed
// for this device. On the device where tests have started, setup suite and
// teardown suite tests run to completion on the device. You are billed for
// setup, teardown, and any tests that were in progress or already completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation StopJob for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJob
func (c *DeviceFarm) StopJob(input *StopJobInput) (*StopJobOutput, error) {
	req, out := c.StopJobRequest(input)
	return out, req.Send()
}

// StopJobWithContext is the same as StopJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) StopJobWithContext(ctx aws.Context, input *StopJobInput, opts ...request.Option) (*StopJobOutput, error) {
	req, out := c.StopJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopRemoteAccessSession = "StopRemoteAccessSession"

// StopRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the StopRemoteAccessSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopRemoteAccessSession for more information on using the StopRemoteAccessSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopRemoteAccessSessionRequest method.
//	req, resp := client.StopRemoteAccessSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession
func (c *DeviceFarm) StopRemoteAccessSessionRequest(input *StopRemoteAccessSessionInput) (req *request.Request, output *StopRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opStopRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopRemoteAccessSessionInput{}
	}

	output = &StopRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopRemoteAccessSession API operation for AWS Device Farm.
//
// Ends a specified remote access session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation StopRemoteAccessSession for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession
func (c *DeviceFarm) StopRemoteAccessSession(input *StopRemoteAccessSessionInput) (*StopRemoteAccessSessionOutput, error) {
	req, out := c.StopRemoteAccessSessionRequest(input)
	return out, req.Send()
}

// StopRemoteAccessSessionWithContext is the same as StopRemoteAccessSession with the addition of
// the ability to pass a context and additional request options.
//
// See StopRemoteAccessSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) StopRemoteAccessSessionWithContext(ctx aws.Context, input *StopRemoteAccessSessionInput, opts ...request.Option) (*StopRemoteAccessSessionOutput, error) {
	req, out := c.StopRemoteAccessSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopRun = "StopRun"

// StopRunRequest generates a "aws/request.Request" representing the
// client's request for the StopRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopRun for more information on using the StopRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopRunRequest method.
//	req, resp := client.StopRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun
func (c *DeviceFarm) StopRunRequest(input *StopRunInput) (req *request.Request, output *StopRunOutput) {
	op := &request.Operation{
		Name:       opStopRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopRunInput{}
	}

	output = &StopRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopRun API operation for AWS Device Farm.
//
// Initiates a stop request for the current test run. AWS Device Farm immediately
// stops the run on devices where tests have not started. You are not billed
// for these devices. On devices where tests have started executing, setup suite
// and teardown suite tests run to completion on those devices. You are billed
// for setup, teardown, and any tests that were in progress or already completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation StopRun for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun
func (c *DeviceFarm) StopRun(input *StopRunInput) (*StopRunOutput, error) {
	req, out := c.StopRunRequest(input)
	return out, req.Send()
}

// StopRunWithContext is the same as StopRun with the addition of
// the ability to pass a context and additional request options.
//
// See StopRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) StopRunWithContext(ctx aws.Context, input *StopRunInput, opts ...request.Option) (*StopRunOutput, error) {
	req, out := c.StopRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/TagResource
func (c *DeviceFarm) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Device Farm.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource are not specified in the request parameters,
// they are not changed. When a resource is deleted, the tags associated with
// that resource are also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - TagOperationException
//     The operation was not successful. Try again.
//
//   - TooManyTagsException
//     The list of tags on the repository is over the limit. The maximum number
//     of tags that can be applied to a repository is 50.
//
//   - TagPolicyException
//     The request doesn't comply with the AWS Identity and Access Management (IAM)
//     tag policy. Correct your request and then retry it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/TagResource
func (c *DeviceFarm) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UntagResource
func (c *DeviceFarm) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Device Farm.
//
// Deletes the specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - TagOperationException
//     The operation was not successful. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UntagResource
func (c *DeviceFarm) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeviceInstance = "UpdateDeviceInstance"

// UpdateDeviceInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeviceInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeviceInstance for more information on using the UpdateDeviceInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDeviceInstanceRequest method.
//	req, resp := client.UpdateDeviceInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDeviceInstance
func (c *DeviceFarm) UpdateDeviceInstanceRequest(input *UpdateDeviceInstanceInput) (req *request.Request, output *UpdateDeviceInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateDeviceInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceInstanceInput{}
	}

	output = &UpdateDeviceInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDeviceInstance API operation for AWS Device Farm.
//
// Updates information about a private device instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateDeviceInstance for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDeviceInstance
func (c *DeviceFarm) UpdateDeviceInstance(input *UpdateDeviceInstanceInput) (*UpdateDeviceInstanceOutput, error) {
	req, out := c.UpdateDeviceInstanceRequest(input)
	return out, req.Send()
}

// UpdateDeviceInstanceWithContext is the same as UpdateDeviceInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeviceInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) UpdateDeviceInstanceWithContext(ctx aws.Context, input *UpdateDeviceInstanceInput, opts ...request.Option) (*UpdateDeviceInstanceOutput, error) {
	req, out := c.UpdateDeviceInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDevicePool = "UpdateDevicePool"

// UpdateDevicePoolRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDevicePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDevicePool for more information on using the UpdateDevicePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDevicePoolRequest method.
//	req, resp := client.UpdateDevicePoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool
func (c *DeviceFarm) UpdateDevicePoolRequest(input *UpdateDevicePoolInput) (req *request.Request, output *UpdateDevicePoolOutput) {
	op := &request.Operation{
		Name:       opUpdateDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDevicePoolInput{}
	}

	output = &UpdateDevicePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDevicePool API operation for AWS Device Farm.
//
// Modifies the name, description, and rules in a device pool given the attributes
// and the pool ARN. Rule updates are all-or-nothing, meaning they can only
// be updated as a whole (or not at all).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateDevicePool for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool
func (c *DeviceFarm) UpdateDevicePool(input *UpdateDevicePoolInput) (*UpdateDevicePoolOutput, error) {
	req, out := c.UpdateDevicePoolRequest(input)
	return out, req.Send()
}

// UpdateDevicePoolWithContext is the same as UpdateDevicePool with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDevicePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) UpdateDevicePoolWithContext(ctx aws.Context, input *UpdateDevicePoolInput, opts ...request.Option) (*UpdateDevicePoolOutput, error) {
	req, out := c.UpdateDevicePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstanceProfile = "UpdateInstanceProfile"

// UpdateInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstanceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstanceProfile for more information on using the UpdateInstanceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInstanceProfileRequest method.
//	req, resp := client.UpdateInstanceProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfile
func (c *DeviceFarm) UpdateInstanceProfileRequest(input *UpdateInstanceProfileInput) (req *request.Request, output *UpdateInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceProfileInput{}
	}

	output = &UpdateInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInstanceProfile API operation for AWS Device Farm.
//
// Updates information about an existing private device instance profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateInstanceProfile for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfile
func (c *DeviceFarm) UpdateInstanceProfile(input *UpdateInstanceProfileInput) (*UpdateInstanceProfileOutput, error) {
	req, out := c.UpdateInstanceProfileRequest(input)
	return out, req.Send()
}

// UpdateInstanceProfileWithContext is the same as UpdateInstanceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstanceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) UpdateInstanceProfileWithContext(ctx aws.Context, input *UpdateInstanceProfileInput, opts ...request.Option) (*UpdateInstanceProfileOutput, error) {
	req, out := c.UpdateInstanceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNetworkProfile = "UpdateNetworkProfile"

// UpdateNetworkProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNetworkProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNetworkProfile for more information on using the UpdateNetworkProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateNetworkProfileRequest method.
//	req, resp := client.UpdateNetworkProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateNetworkProfile
func (c *DeviceFarm) UpdateNetworkProfileRequest(input *UpdateNetworkProfileInput) (req *request.Request, output *UpdateNetworkProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNetworkProfileInput{}
	}

	output = &UpdateNetworkProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNetworkProfile API operation for AWS Device Farm.
//
// Updates the network profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateNetworkProfile for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateNetworkProfile
func (c *DeviceFarm) UpdateNetworkProfile(input *UpdateNetworkProfileInput) (*UpdateNetworkProfileOutput, error) {
	req, out := c.UpdateNetworkProfileRequest(input)
	return out, req.Send()
}

// UpdateNetworkProfileWithContext is the same as UpdateNetworkProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNetworkProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) UpdateNetworkProfileWithContext(ctx aws.Context, input *UpdateNetworkProfileInput, opts ...request.Option) (*UpdateNetworkProfileOutput, error) {
	req, out := c.UpdateNetworkProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProjectRequest method.
//	req, resp := client.UpdateProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject
func (c *DeviceFarm) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for AWS Device Farm.
//
// Modifies the specified project name, given the project ARN and a new name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateProject for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject
func (c *DeviceFarm) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTestGridProject = "UpdateTestGridProject"

// UpdateTestGridProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTestGridProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTestGridProject for more information on using the UpdateTestGridProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTestGridProjectRequest method.
//	req, resp := client.UpdateTestGridProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateTestGridProject
func (c *DeviceFarm) UpdateTestGridProjectRequest(input *UpdateTestGridProjectInput) (req *request.Request, output *UpdateTestGridProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateTestGridProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTestGridProjectInput{}
	}

	output = &UpdateTestGridProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTestGridProject API operation for AWS Device Farm.
//
// Change details of a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateTestGridProject for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - InternalServiceException
//     An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
//     (mailto:aws-devicefarm-support@amazon.com) if you see this error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateTestGridProject
func (c *DeviceFarm) UpdateTestGridProject(input *UpdateTestGridProjectInput) (*UpdateTestGridProjectOutput, error) {
	req, out := c.UpdateTestGridProjectRequest(input)
	return out, req.Send()
}

// UpdateTestGridProjectWithContext is the same as UpdateTestGridProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTestGridProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) UpdateTestGridProjectWithContext(ctx aws.Context, input *UpdateTestGridProjectInput, opts ...request.Option) (*UpdateTestGridProjectOutput, error) {
	req, out := c.UpdateTestGridProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUpload = "UpdateUpload"

// UpdateUploadRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUpload for more information on using the UpdateUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUploadRequest method.
//	req, resp := client.UpdateUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateUpload
func (c *DeviceFarm) UpdateUploadRequest(input *UpdateUploadInput) (req *request.Request, output *UpdateUploadOutput) {
	op := &request.Operation{
		Name:       opUpdateUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUploadInput{}
	}

	output = &UpdateUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUpload API operation for AWS Device Farm.
//
// Updates an uploaded test spec.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateUpload for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - LimitExceededException
//     A limit was exceeded.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateUpload
func (c *DeviceFarm) UpdateUpload(input *UpdateUploadInput) (*UpdateUploadOutput, error) {
	req, out := c.UpdateUploadRequest(input)
	return out, req.Send()
}

// UpdateUploadWithContext is the same as UpdateUpload with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) UpdateUploadWithContext(ctx aws.Context, input *UpdateUploadInput, opts ...request.Option) (*UpdateUploadOutput, error) {
	req, out := c.UpdateUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVPCEConfiguration = "UpdateVPCEConfiguration"

// UpdateVPCEConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVPCEConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVPCEConfiguration for more information on using the UpdateVPCEConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVPCEConfigurationRequest method.
//	req, resp := client.UpdateVPCEConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateVPCEConfiguration
func (c *DeviceFarm) UpdateVPCEConfigurationRequest(input *UpdateVPCEConfigurationInput) (req *request.Request, output *UpdateVPCEConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateVPCEConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVPCEConfigurationInput{}
	}

	output = &UpdateVPCEConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVPCEConfiguration API operation for AWS Device Farm.
//
// Updates information about an Amazon Virtual Private Cloud (VPC) endpoint
// configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateVPCEConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ArgumentException
//     An invalid argument was specified.
//
//   - NotFoundException
//     The specified entity was not found.
//
//   - ServiceAccountException
//     There was a problem with the service account.
//
//   - InvalidOperationException
//     There was an error with the update request, or you do not have sufficient
//     permissions to update this VPC endpoint configuration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateVPCEConfiguration
func (c *DeviceFarm) UpdateVPCEConfiguration(input *UpdateVPCEConfigurationInput) (*UpdateVPCEConfigurationOutput, error) {
	req, out := c.UpdateVPCEConfigurationRequest(input)
	return out, req.Send()
}

// UpdateVPCEConfigurationWithContext is the same as UpdateVPCEConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVPCEConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DeviceFarm) UpdateVPCEConfigurationWithContext(ctx aws.Context, input *UpdateVPCEConfigurationInput, opts ...request.Option) (*UpdateVPCEConfigurationOutput, error) {
	req, out := c.UpdateVPCEConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A container for account-level settings in AWS Device Farm.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// The AWS account number specified in the AccountSettings container.
	AwsAccountNumber *string `locationName:"awsAccountNumber" min:"2" type:"string"`

	// The default number of minutes (at the account level) a test run executes
	// before it times out. The default value is 150 minutes.
	DefaultJobTimeoutMinutes *int64 `locationName:"defaultJobTimeoutMinutes" type:"integer"`

	// The maximum number of minutes a test run executes before it times out.
	MaxJobTimeoutMinutes *int64 `locationName:"maxJobTimeoutMinutes" type:"integer"`

	// The maximum number of device slots that the AWS account can purchase. Each
	// maximum is expressed as an offering-id:number pair, where the offering-id
	// represents one of the IDs returned by the ListOfferings command.
	MaxSlots map[string]*int64 `locationName:"maxSlots" type:"map"`

	// When set to true, for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see Do you
	// modify my app? (https://aws.amazon.com/device-farm/faq/) in the AWS Device
	// Farm FAQs.
	SkipAppResign *bool `locationName:"skipAppResign" type:"boolean"`

	// Information about an AWS account's usage of free trial device minutes.
	TrialMinutes *TrialMinutes `locationName:"trialMinutes" type:"structure"`

	// Returns the unmetered devices you have purchased or want to purchase.
	UnmeteredDevices map[string]*int64 `locationName:"unmeteredDevices" type:"map"`

	// Returns the unmetered remote access devices you have purchased or want to
	// purchase.
	UnmeteredRemoteAccessDevices map[string]*int64 `locationName:"unmeteredRemoteAccessDevices" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetAwsAccountNumber sets the AwsAccountNumber field's value.
func (s *AccountSettings) SetAwsAccountNumber(v string) *AccountSettings {
	s.AwsAccountNumber = &v
	return s
}

// SetDefaultJobTimeoutMinutes sets the DefaultJobTimeoutMinutes field's value.
func (s *AccountSettings) SetDefaultJobTimeoutMinutes(v int64) *AccountSettings {
	s.DefaultJobTimeoutMinutes = &v
	return s
}

// SetMaxJobTimeoutMinutes sets the MaxJobTimeoutMinutes field's value.
func (s *AccountSettings) SetMaxJobTimeoutMinutes(v int64) *AccountSettings {
	s.MaxJobTimeoutMinutes = &v
	return s
}

// SetMaxSlots sets the MaxSlots field's value.
func (s *AccountSettings) SetMaxSlots(v map[string]*int64) *AccountSettings {
	s.MaxSlots = v
	return s
}

// SetSkipAppResign sets the SkipAppResign field's value.
func (s *AccountSettings) SetSkipAppResign(v bool) *AccountSettings {
	s.SkipAppResign = &v
	return s
}

// SetTrialMinutes sets the TrialMinutes field's value.
func (s *AccountSettings) SetTrialMinutes(v *TrialMinutes) *AccountSettings {
	s.TrialMinutes = v
	return s
}

// SetUnmeteredDevices sets the UnmeteredDevices field's value.
func (s *AccountSettings) SetUnmeteredDevices(v map[string]*int64) *AccountSettings {
	s.UnmeteredDevices = v
	return s
}

// SetUnmeteredRemoteAccessDevices sets the UnmeteredRemoteAccessDevices field's value.
func (s *AccountSettings) SetUnmeteredRemoteAccessDevices(v map[string]*int64) *AccountSettings {
	s.UnmeteredRemoteAccessDevices = v
	return s
}

// An invalid argument was specified.
type ArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Any additional information about the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArgumentException) GoString() string {
	return s.String()
}

func newErrorArgumentException(v protocol.ResponseMetadata) error {
	return &ArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ArgumentException) Code() string {
	return "ArgumentException"
}

// Message returns the exception's message.
func (s *ArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ArgumentException) OrigErr() error {
	return nil
}

func (s *ArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the output of a test. Examples of artifacts include logs and screenshots.
type Artifact struct {
	_ struct{} `type:"structure"`

	// The artifact's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The artifact's file extension.
	Extension *string `locationName:"extension" type:"string"`

	// The artifact's name.
	Name *string `locationName:"name" type:"string"`

	// The artifact's type.
	//
	// Allowed values include the following:
	//
	//    * UNKNOWN
	//
	//    * SCREENSHOT
	//
	//    * DEVICE_LOG
	//
	//    * MESSAGE_LOG
	//
	//    * VIDEO_LOG
	//
	//    * RESULT_LOG
	//
	//    * SERVICE_LOG
	//
	//    * WEBKIT_LOG
	//
	//    * INSTRUMENTATION_OUTPUT
	//
	//    * EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android
	//    fuzz test.
	//
	//    * CALABASH_JSON_OUTPUT
	//
	//    * CALABASH_PRETTY_OUTPUT
	//
	//    * CALABASH_STANDARD_OUTPUT
	//
	//    * CALABASH_JAVA_XML_OUTPUT
	//
	//    * AUTOMATION_OUTPUT
	//
	//    * APPIUM_SERVER_OUTPUT
	//
	//    * APPIUM_JAVA_OUTPUT
	//
	//    * APPIUM_JAVA_XML_OUTPUT
	//
	//    * APPIUM_PYTHON_OUTPUT
	//
	//    * APPIUM_PYTHON_XML_OUTPUT
	//
	//    * EXPLORER_EVENT_LOG
	//
	//    * EXPLORER_SUMMARY_LOG
	//
	//    * APPLICATION_CRASH_REPORT
	//
	//    * XCTEST_LOG
	//
	//    * VIDEO
	//
	//    * CUSTOMER_ARTIFACT
	//
	//    * CUSTOMER_ARTIFACT_LOG
	//
	//    * TESTSPEC_OUTPUT
	Type *string `locationName:"type" type:"string" enum:"ArtifactType"`

	// The presigned Amazon S3 URL that can be used with a GET request to download
	// the artifact's file.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Artifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Artifact) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Artifact) SetArn(v string) *Artifact {
	s.Arn = &v
	return s
}

// SetExtension sets the Extension field's value.
func (s *Artifact) SetExtension(v string) *Artifact {
	s.Extension = &v
	return s
}

// SetName sets the Name field's value.
func (s *Artifact) SetName(v string) *Artifact {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Artifact) SetType(v string) *Artifact {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Artifact) SetUrl(v string) *Artifact {
	s.Url = &v
	return s
}

// Represents the amount of CPU that an app is using on a physical device. Does
// not represent system-wide CPU usage.
type CPU struct {
	_ struct{} `type:"structure"`

	// The CPU's architecture (for example, x86 or ARM).
	Architecture *string `locationName:"architecture" type:"string"`

	// The clock speed of the device's CPU, expressed in hertz (Hz). For example,
	// a 1.2 GHz CPU is expressed as 1200000000.
	Clock *float64 `locationName:"clock" type:"double"`

	// The CPU's frequency.
	Frequency *string `locationName:"frequency" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CPU) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CPU) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *CPU) SetArchitecture(v string) *CPU {
	s.Architecture = &v
	return s
}

// SetClock sets the Clock field's value.
func (s *CPU) SetClock(v float64) *CPU {
	s.Clock = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *CPU) SetFrequency(v string) *CPU {
	s.Frequency = &v
	return s
}

// The requested object could not be deleted.
type CannotDeleteException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CannotDeleteException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CannotDeleteException) GoString() string {
	return s.String()
}

func newErrorCannotDeleteException(v protocol.ResponseMetadata) error {
	return &CannotDeleteException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CannotDeleteException) Code() string {
	return "CannotDeleteException"
}

// Message returns the exception's message.
func (s *CannotDeleteException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CannotDeleteException) OrigErr() error {
	return nil
}

func (s *CannotDeleteException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CannotDeleteException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CannotDeleteException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents entity counters.
type Counters struct {
	_ struct{} `type:"structure"`

	// The number of errored entities.
	Errored *int64 `locationName:"errored" type:"integer"`

	// The number of failed entities.
	Failed *int64 `locationName:"failed" type:"integer"`

	// The number of passed entities.
	Passed *int64 `locationName:"passed" type:"integer"`

	// The number of skipped entities.
	Skipped *int64 `locationName:"skipped" type:"integer"`

	// The number of stopped entities.
	Stopped *int64 `locationName:"stopped" type:"integer"`

	// The total number of entities.
	Total *int64 `locationName:"total" type:"integer"`

	// The number of warned entities.
	Warned *int64 `locationName:"warned" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Counters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Counters) GoString() string {
	return s.String()
}

// SetErrored sets the Errored field's value.
func (s *Counters) SetErrored(v int64) *Counters {
	s.Errored = &v
	return s
}

// SetFailed sets the Failed field's value.
func (s *Counters) SetFailed(v int64) *Counters {
	s.Failed = &v
	return s
}

// SetPassed sets the Passed field's value.
func (s *Counters) SetPassed(v int64) *Counters {
	s.Passed = &v
	return s
}

// SetSkipped sets the Skipped field's value.
func (s *Counters) SetSkipped(v int64) *Counters {
	s.Skipped = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Counters) SetStopped(v int64) *Counters {
	s.Stopped = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *Counters) SetTotal(v int64) *Counters {
	s.Total = &v
	return s
}

// SetWarned sets the Warned field's value.
func (s *Counters) SetWarned(v int64) *Counters {
	s.Warned = &v
	return s
}

// Represents a request to the create device pool operation.
type CreateDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// The device pool's description.
	Description *string `locationName:"description" type:"string"`

	// The number of devices that Device Farm can add to your device pool. Device
	// Farm adds devices that are available and meet the criteria that you assign
	// for the rules parameter. Depending on how many devices meet these constraints,
	// your device pool might contain fewer devices than the value for this parameter.
	//
	// By specifying the maximum number of devices, you can control the costs that
	// you incur by running tests.
	MaxDevices *int64 `locationName:"maxDevices" type:"integer"`

	// The device pool's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the project for the device pool.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// The device pool's rules.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDevicePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDevicePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDevicePoolInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDevicePoolInput) SetDescription(v string) *CreateDevicePoolInput {
	s.Description = &v
	return s
}

// SetMaxDevices sets the MaxDevices field's value.
func (s *CreateDevicePoolInput) SetMaxDevices(v int64) *CreateDevicePoolInput {
	s.MaxDevices = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDevicePoolInput) SetName(v string) *CreateDevicePoolInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateDevicePoolInput) SetProjectArn(v string) *CreateDevicePoolInput {
	s.ProjectArn = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateDevicePoolInput) SetRules(v []*Rule) *CreateDevicePoolInput {
	s.Rules = v
	return s
}

// Represents the result of a create device pool request.
type CreateDevicePoolOutput struct {
	_ struct{} `type:"structure"`

	// The newly created device pool.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDevicePoolOutput) GoString() string {
	return s.String()
}

// SetDevicePool sets the DevicePool field's value.
func (s *CreateDevicePoolOutput) SetDevicePool(v *DevicePool) *CreateDevicePoolOutput {
	s.DevicePool = v
	return s
}

type CreateInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The description of your instance profile.
	Description *string `locationName:"description" type:"string"`

	// An array of strings that specifies the list of app packages that should not
	// be cleaned up from the device after a test run.
	//
	// The list of packages is considered only if you set packageCleanup to true.
	ExcludeAppPackagesFromCleanup []*string `locationName:"excludeAppPackagesFromCleanup" type:"list"`

	// The name of your instance profile.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// When set to true, Device Farm removes app packages after a test run. The
	// default value is false for private devices.
	PackageCleanup *bool `locationName:"packageCleanup" type:"boolean"`

	// When set to true, Device Farm reboots the instance after a test run. The
	// default value is true.
	RebootAfterUse *bool `locationName:"rebootAfterUse" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceProfileInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateInstanceProfileInput) SetDescription(v string) *CreateInstanceProfileInput {
	s.Description = &v
	return s
}

// SetExcludeAppPackagesFromCleanup sets the ExcludeAppPackagesFromCleanup field's value.
func (s *CreateInstanceProfileInput) SetExcludeAppPackagesFromCleanup(v []*string) *CreateInstanceProfileInput {
	s.ExcludeAppPackagesFromCleanup = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInstanceProfileInput) SetName(v string) *CreateInstanceProfileInput {
	s.Name = &v
	return s
}

// SetPackageCleanup sets the PackageCleanup field's value.
func (s *CreateInstanceProfileInput) SetPackageCleanup(v bool) *CreateInstanceProfileInput {
	s.PackageCleanup = &v
	return s
}

// SetRebootAfterUse sets the RebootAfterUse field's value.
func (s *CreateInstanceProfileInput) SetRebootAfterUse(v bool) *CreateInstanceProfileInput {
	s.RebootAfterUse = &v
	return s
}

type CreateInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your instance profile.
	InstanceProfile *InstanceProfile `locationName:"instanceProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceProfileOutput) GoString() string {
	return s.String()
}

// SetInstanceProfile sets the InstanceProfile field's value.
func (s *CreateInstanceProfileOutput) SetInstanceProfile(v *InstanceProfile) *CreateInstanceProfileOutput {
	s.InstanceProfile = v
	return s
}

type CreateNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The description of the network profile.
	Description *string `locationName:"description" type:"string"`

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	DownlinkBandwidthBits *int64 `locationName:"downlinkBandwidthBits" type:"long"`

	// Delay time for all packets to destination in milliseconds as an integer from
	// 0 to 2000.
	DownlinkDelayMs *int64 `locationName:"downlinkDelayMs" type:"long"`

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	DownlinkJitterMs *int64 `locationName:"downlinkJitterMs" type:"long"`

	// Proportion of received packets that fail to arrive from 0 to 100 percent.
	DownlinkLossPercent *int64 `locationName:"downlinkLossPercent" type:"integer"`

	// The name for the new network profile.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the project for which you want to create
	// a network profile.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// The type of network profile to create. Valid values are listed here.
	Type *string `locationName:"type" type:"string" enum:"NetworkProfileType"`

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	UplinkBandwidthBits *int64 `locationName:"uplinkBandwidthBits" type:"long"`

	// Delay time for all packets to destination in milliseconds as an integer from
	// 0 to 2000.
	UplinkDelayMs *int64 `locationName:"uplinkDelayMs" type:"long"`

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	UplinkJitterMs *int64 `locationName:"uplinkJitterMs" type:"long"`

	// Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
	UplinkLossPercent *int64 `locationName:"uplinkLossPercent" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkProfileInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateNetworkProfileInput) SetDescription(v string) *CreateNetworkProfileInput {
	s.Description = &v
	return s
}

// SetDownlinkBandwidthBits sets the DownlinkBandwidthBits field's value.
func (s *CreateNetworkProfileInput) SetDownlinkBandwidthBits(v int64) *CreateNetworkProfileInput {
	s.DownlinkBandwidthBits = &v
	return s
}

// SetDownlinkDelayMs sets the DownlinkDelayMs field's value.
func (s *CreateNetworkProfileInput) SetDownlinkDelayMs(v int64) *CreateNetworkProfileInput {
	s.DownlinkDelayMs = &v
	return s
}

// SetDownlinkJitterMs sets the DownlinkJitterMs field's value.
func (s *CreateNetworkProfileInput) SetDownlinkJitterMs(v int64) *CreateNetworkProfileInput {
	s.DownlinkJitterMs = &v
	return s
}

// SetDownlinkLossPercent sets the DownlinkLossPercent field's value.
func (s *CreateNetworkProfileInput) SetDownlinkLossPercent(v int64) *CreateNetworkProfileInput {
	s.DownlinkLossPercent = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateNetworkProfileInput) SetName(v string) *CreateNetworkProfileInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateNetworkProfileInput) SetProjectArn(v string) *CreateNetworkProfileInput {
	s.ProjectArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateNetworkProfileInput) SetType(v string) *CreateNetworkProfileInput {
	s.Type = &v
	return s
}

// SetUplinkBandwidthBits sets the UplinkBandwidthBits field's value.
func (s *CreateNetworkProfileInput) SetUplinkBandwidthBits(v int64) *CreateNetworkProfileInput {
	s.UplinkBandwidthBits = &v
	return s
}

// SetUplinkDelayMs sets the UplinkDelayMs field's value.
func (s *CreateNetworkProfileInput) SetUplinkDelayMs(v int64) *CreateNetworkProfileInput {
	s.UplinkDelayMs = &v
	return s
}

// SetUplinkJitterMs sets the UplinkJitterMs field's value.
func (s *CreateNetworkProfileInput) SetUplinkJitterMs(v int64) *CreateNetworkProfileInput {
	s.UplinkJitterMs = &v
	return s
}

// SetUplinkLossPercent sets the UplinkLossPercent field's value.
func (s *CreateNetworkProfileInput) SetUplinkLossPercent(v int64) *CreateNetworkProfileInput {
	s.UplinkLossPercent = &v
	return s
}

type CreateNetworkProfileOutput struct {
	_ struct{} `type:"structure"`

	// The network profile that is returned by the create network profile request.
	NetworkProfile *NetworkProfile `locationName:"networkProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkProfileOutput) GoString() string {
	return s.String()
}

// SetNetworkProfile sets the NetworkProfile field's value.
func (s *CreateNetworkProfileOutput) SetNetworkProfile(v *NetworkProfile) *CreateNetworkProfileOutput {
	s.NetworkProfile = v
	return s
}

// Represents a request to the create project operation.
type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// Sets the execution timeout value (in minutes) for a project. All test runs
	// in this project use the specified execution timeout value unless overridden
	// when scheduling a run.
	DefaultJobTimeoutMinutes *int64 `locationName:"defaultJobTimeoutMinutes" type:"integer"`

	// The project's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultJobTimeoutMinutes sets the DefaultJobTimeoutMinutes field's value.
func (s *CreateProjectInput) SetDefaultJobTimeoutMinutes(v int64) *CreateProjectInput {
	s.DefaultJobTimeoutMinutes = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

// Represents the result of a create project request.
type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The newly created project.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *CreateProjectOutput) SetProject(v *Project) *CreateProjectOutput {
	s.Project = v
	return s
}

// Configuration settings for a remote access session, including billing method.
type CreateRemoteAccessSessionConfiguration struct {
	_ struct{} `type:"structure"`

	// The billing method for the remote access session.
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`

	// An array of ARNs included in the VPC endpoint configuration.
	VpceConfigurationArns []*string `locationName:"vpceConfigurationArns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRemoteAccessSessionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRemoteAccessSessionConfiguration) GoString() string {
	return s.String()
}

// SetBillingMethod sets the BillingMethod field's value.
func (s *CreateRemoteAccessSessionConfiguration) SetBillingMethod(v string) *CreateRemoteAccessSessionConfiguration {
	s.BillingMethod = &v
	return s
}

// SetVpceConfigurationArns sets the VpceConfigurationArns field's value.
func (s *CreateRemoteAccessSessionConfiguration) SetVpceConfigurationArns(v []*string) *CreateRemoteAccessSessionConfiguration {
	s.VpceConfigurationArns = v
	return s
}

// Creates and submits a request to start a remote access session.
type CreateRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the client. If you want access to multiple devices
	// on the same client, you should pass the same clientId value in each call
	// to CreateRemoteAccessSession. This identifier is required only if remoteDebugEnabled
	// is set to true.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	ClientId *string `locationName:"clientId" type:"string"`

	// The configuration information for the remote access session request.
	Configuration *CreateRemoteAccessSessionConfiguration `locationName:"configuration" type:"structure"`

	// The ARN of the device for which you want to create a remote access session.
	//
	// DeviceArn is a required field
	DeviceArn *string `locationName:"deviceArn" min:"32" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the device instance for which you want
	// to create a remote access session.
	InstanceArn *string `locationName:"instanceArn" min:"32" type:"string"`

	// The interaction mode of the remote access session. Valid values are:
	//
	//    * INTERACTIVE: You can interact with the iOS device by viewing, touching,
	//    and rotating the screen. You cannot run XCUITest framework-based tests
	//    in this mode.
	//
	//    * NO_VIDEO: You are connected to the device, but cannot interact with
	//    it or view the screen. This mode has the fastest test execution speed.
	//    You can run XCUITest framework-based tests in this mode.
	//
	//    * VIDEO_ONLY: You can view the screen, but cannot touch or rotate it.
	//    You can run XCUITest framework-based tests and watch the screen in this
	//    mode.
	InteractionMode *string `locationName:"interactionMode" type:"string" enum:"InteractionMode"`

	// The name of the remote access session to create.
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (ARN) of the project for which you want to create
	// a remote access session.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// Set to true if you want to access devices remotely for debugging in your
	// remote access session.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	RemoteDebugEnabled *bool `locationName:"remoteDebugEnabled" type:"boolean"`

	// The Amazon Resource Name (ARN) for the app to be recorded in the remote access
	// session.
	RemoteRecordAppArn *string `locationName:"remoteRecordAppArn" min:"32" type:"string"`

	// Set to true to enable remote recording for the remote access session.
	RemoteRecordEnabled *bool `locationName:"remoteRecordEnabled" type:"boolean"`

	// When set to true, for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information on how Device Farm modifies your uploads during tests,
	// see Do you modify my app? (https://aws.amazon.com/device-farm/faq/)
	SkipAppResign *bool `locationName:"skipAppResign" type:"boolean"`

	// Ignored. The public key of the ssh key pair you want to use for connecting
	// to remote devices in your remote debugging session. This key is required
	// only if remoteDebugEnabled is set to true.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRemoteAccessSessionInput"}
	if s.DeviceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceArn"))
	}
	if s.DeviceArn != nil && len(*s.DeviceArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceArn", 32))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 32))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.RemoteRecordAppArn != nil && len(*s.RemoteRecordAppArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RemoteRecordAppArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *CreateRemoteAccessSessionInput) SetClientId(v string) *CreateRemoteAccessSessionInput {
	s.ClientId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateRemoteAccessSessionInput) SetConfiguration(v *CreateRemoteAccessSessionConfiguration) *CreateRemoteAccessSessionInput {
	s.Configuration = v
	return s
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *CreateRemoteAccessSessionInput) SetDeviceArn(v string) *CreateRemoteAccessSessionInput {
	s.DeviceArn = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreateRemoteAccessSessionInput) SetInstanceArn(v string) *CreateRemoteAccessSessionInput {
	s.InstanceArn = &v
	return s
}

// SetInteractionMode sets the InteractionMode field's value.
func (s *CreateRemoteAccessSessionInput) SetInteractionMode(v string) *CreateRemoteAccessSessionInput {
	s.InteractionMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRemoteAccessSessionInput) SetName(v string) *CreateRemoteAccessSessionInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateRemoteAccessSessionInput) SetProjectArn(v string) *CreateRemoteAccessSessionInput {
	s.ProjectArn = &v
	return s
}

// SetRemoteDebugEnabled sets the RemoteDebugEnabled field's value.
func (s *CreateRemoteAccessSessionInput) SetRemoteDebugEnabled(v bool) *CreateRemoteAccessSessionInput {
	s.RemoteDebugEnabled = &v
	return s
}

// SetRemoteRecordAppArn sets the RemoteRecordAppArn field's value.
func (s *CreateRemoteAccessSessionInput) SetRemoteRecordAppArn(v string) *CreateRemoteAccessSessionInput {
	s.RemoteRecordAppArn = &v
	return s
}

// SetRemoteRecordEnabled sets the RemoteRecordEnabled field's value.
func (s *CreateRemoteAccessSessionInput) SetRemoteRecordEnabled(v bool) *CreateRemoteAccessSessionInput {
	s.RemoteRecordEnabled = &v
	return s
}

// SetSkipAppResign sets the SkipAppResign field's value.
func (s *CreateRemoteAccessSessionInput) SetSkipAppResign(v bool) *CreateRemoteAccessSessionInput {
	s.SkipAppResign = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *CreateRemoteAccessSessionInput) SetSshPublicKey(v string) *CreateRemoteAccessSessionInput {
	s.SshPublicKey = &v
	return s
}

// Represents the server response from a request to create a remote access session.
type CreateRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`

	// A container that describes the remote access session when the request to
	// create a remote access session is sent.
	RemoteAccessSession *RemoteAccessSession `locationName:"remoteAccessSession" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// SetRemoteAccessSession sets the RemoteAccessSession field's value.
func (s *CreateRemoteAccessSessionOutput) SetRemoteAccessSession(v *RemoteAccessSession) *CreateRemoteAccessSessionOutput {
	s.RemoteAccessSession = v
	return s
}

type CreateTestGridProjectInput struct {
	_ struct{} `type:"structure"`

	// Human-readable description of the project.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Human-readable name of the Selenium testing project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The VPC security groups and subnets that are attached to a project.
	VpcConfig *TestGridVpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestGridProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestGridProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTestGridProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTestGridProjectInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateTestGridProjectInput) SetDescription(v string) *CreateTestGridProjectInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTestGridProjectInput) SetName(v string) *CreateTestGridProjectInput {
	s.Name = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateTestGridProjectInput) SetVpcConfig(v *TestGridVpcConfig) *CreateTestGridProjectInput {
	s.VpcConfig = v
	return s
}

type CreateTestGridProjectOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the Selenium testing project that was created.
	TestGridProject *TestGridProject `locationName:"testGridProject" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestGridProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestGridProjectOutput) GoString() string {
	return s.String()
}

// SetTestGridProject sets the TestGridProject field's value.
func (s *CreateTestGridProjectOutput) SetTestGridProject(v *TestGridProject) *CreateTestGridProjectOutput {
	s.TestGridProject = v
	return s
}

type CreateTestGridUrlInput struct {
	_ struct{} `type:"structure"`

	// Lifetime, in seconds, of the URL.
	//
	// ExpiresInSeconds is a required field
	ExpiresInSeconds *int64 `locationName:"expiresInSeconds" min:"60" type:"integer" required:"true"`

	// ARN (from CreateTestGridProject or ListTestGridProjects) to associate with
	// the short-term URL.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestGridUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestGridUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTestGridUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTestGridUrlInput"}
	if s.ExpiresInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpiresInSeconds"))
	}
	if s.ExpiresInSeconds != nil && *s.ExpiresInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("ExpiresInSeconds", 60))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpiresInSeconds sets the ExpiresInSeconds field's value.
func (s *CreateTestGridUrlInput) SetExpiresInSeconds(v int64) *CreateTestGridUrlInput {
	s.ExpiresInSeconds = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateTestGridUrlInput) SetProjectArn(v string) *CreateTestGridUrlInput {
	s.ProjectArn = &v
	return s
}

type CreateTestGridUrlOutput struct {
	_ struct{} `type:"structure"`

	// The number of seconds the URL from CreateTestGridUrlResult$url stays active.
	Expires *time.Time `locationName:"expires" type:"timestamp"`

	// A signed URL, expiring in CreateTestGridUrlRequest$expiresInSeconds seconds,
	// to be passed to a RemoteWebDriver.
	//
	// Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateTestGridUrlOutput's
	// String and GoString methods.
	Url *string `locationName:"url" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestGridUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestGridUrlOutput) GoString() string {
	return s.String()
}

// SetExpires sets the Expires field's value.
func (s *CreateTestGridUrlOutput) SetExpires(v time.Time) *CreateTestGridUrlOutput {
	s.Expires = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *CreateTestGridUrlOutput) SetUrl(v string) *CreateTestGridUrlOutput {
	s.Url = &v
	return s
}

// Represents a request to the create upload operation.
type CreateUploadInput struct {
	_ struct{} `type:"structure"`

	// The upload's content type (for example, application/octet-stream).
	ContentType *string `locationName:"contentType" type:"string"`

	// The upload's file name. The name should not contain any forward slashes (/).
	// If you are uploading an iOS app, the file name must end with the .ipa extension.
	// If you are uploading an Android app, the file name must end with the .apk
	// extension. For all others, the file name must end with the .zip file extension.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the project for the upload.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// The upload's upload type.
	//
	// Must be one of the following values:
	//
	//    * ANDROID_APP
	//
	//    * IOS_APP
	//
	//    * WEB_APP
	//
	//    * EXTERNAL_DATA
	//
	//    * APPIUM_JAVA_JUNIT_TEST_PACKAGE
	//
	//    * APPIUM_JAVA_TESTNG_TEST_PACKAGE
	//
	//    * APPIUM_PYTHON_TEST_PACKAGE
	//
	//    * APPIUM_NODE_TEST_PACKAGE
	//
	//    * APPIUM_RUBY_TEST_PACKAGE
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE
	//
	//    * APPIUM_WEB_PYTHON_TEST_PACKAGE
	//
	//    * APPIUM_WEB_NODE_TEST_PACKAGE
	//
	//    * APPIUM_WEB_RUBY_TEST_PACKAGE
	//
	//    * CALABASH_TEST_PACKAGE
	//
	//    * INSTRUMENTATION_TEST_PACKAGE
	//
	//    * UIAUTOMATION_TEST_PACKAGE
	//
	//    * UIAUTOMATOR_TEST_PACKAGE
	//
	//    * XCTEST_TEST_PACKAGE
	//
	//    * XCTEST_UI_TEST_PACKAGE
	//
	//    * APPIUM_JAVA_JUNIT_TEST_SPEC
	//
	//    * APPIUM_JAVA_TESTNG_TEST_SPEC
	//
	//    * APPIUM_PYTHON_TEST_SPEC
	//
	//    * APPIUM_NODE_TEST_SPEC
	//
	//    * APPIUM_RUBY_TEST_SPEC
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC
	//
	//    * APPIUM_WEB_PYTHON_TEST_SPEC
	//
	//    * APPIUM_WEB_NODE_TEST_SPEC
	//
	//    * APPIUM_WEB_RUBY_TEST_SPEC
	//
	//    * INSTRUMENTATION_TEST_SPEC
	//
	//    * XCTEST_UI_TEST_SPEC
	//
	// If you call CreateUpload with WEB_APP specified, AWS Device Farm throws an
	// ArgumentException error.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"UploadType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUploadInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *CreateUploadInput) SetContentType(v string) *CreateUploadInput {
	s.ContentType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateUploadInput) SetName(v string) *CreateUploadInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateUploadInput) SetProjectArn(v string) *CreateUploadInput {
	s.ProjectArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateUploadInput) SetType(v string) *CreateUploadInput {
	s.Type = &v
	return s
}

// Represents the result of a create upload request.
type CreateUploadOutput struct {
	_ struct{} `type:"structure"`

	// The newly created upload.
	Upload *Upload `locationName:"upload" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadOutput) GoString() string {
	return s.String()
}

// SetUpload sets the Upload field's value.
func (s *CreateUploadOutput) SetUpload(v *Upload) *CreateUploadOutput {
	s.Upload = v
	return s
}

type CreateVPCEConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The DNS name of the service running in your VPC that you want Device Farm
	// to test.
	//
	// ServiceDnsName is a required field
	ServiceDnsName *string `locationName:"serviceDnsName" type:"string" required:"true"`

	// An optional description that provides details about your VPC endpoint configuration.
	VpceConfigurationDescription *string `locationName:"vpceConfigurationDescription" type:"string"`

	// The friendly name you give to your VPC endpoint configuration, to manage
	// your configurations more easily.
	//
	// VpceConfigurationName is a required field
	VpceConfigurationName *string `locationName:"vpceConfigurationName" type:"string" required:"true"`

	// The name of the VPC endpoint service running in your AWS account that you
	// want Device Farm to test.
	//
	// VpceServiceName is a required field
	VpceServiceName *string `locationName:"vpceServiceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVPCEConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVPCEConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVPCEConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVPCEConfigurationInput"}
	if s.ServiceDnsName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceDnsName"))
	}
	if s.VpceConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("VpceConfigurationName"))
	}
	if s.VpceServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VpceServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceDnsName sets the ServiceDnsName field's value.
func (s *CreateVPCEConfigurationInput) SetServiceDnsName(v string) *CreateVPCEConfigurationInput {
	s.ServiceDnsName = &v
	return s
}

// SetVpceConfigurationDescription sets the VpceConfigurationDescription field's value.
func (s *CreateVPCEConfigurationInput) SetVpceConfigurationDescription(v string) *CreateVPCEConfigurationInput {
	s.VpceConfigurationDescription = &v
	return s
}

// SetVpceConfigurationName sets the VpceConfigurationName field's value.
func (s *CreateVPCEConfigurationInput) SetVpceConfigurationName(v string) *CreateVPCEConfigurationInput {
	s.VpceConfigurationName = &v
	return s
}

// SetVpceServiceName sets the VpceServiceName field's value.
func (s *CreateVPCEConfigurationInput) SetVpceServiceName(v string) *CreateVPCEConfigurationInput {
	s.VpceServiceName = &v
	return s
}

type CreateVPCEConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your VPC endpoint configuration.
	VpceConfiguration *VPCEConfiguration `locationName:"vpceConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVPCEConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVPCEConfigurationOutput) GoString() string {
	return s.String()
}

// SetVpceConfiguration sets the VpceConfiguration field's value.
func (s *CreateVPCEConfigurationOutput) SetVpceConfiguration(v *VPCEConfiguration) *CreateVPCEConfigurationOutput {
	s.VpceConfiguration = v
	return s
}

// A JSON object that specifies the paths where the artifacts generated by the
// customer's tests, on the device or in the test environment, are pulled from.
//
// Specify deviceHostPaths and optionally specify either iosPaths or androidPaths.
//
// For web app tests, you can specify both iosPaths and androidPaths.
type CustomerArtifactPaths struct {
	_ struct{} `type:"structure"`

	// Comma-separated list of paths on the Android device where the artifacts generated
	// by the customer's tests are pulled from.
	AndroidPaths []*string `locationName:"androidPaths" type:"list"`

	// Comma-separated list of paths in the test execution environment where the
	// artifacts generated by the customer's tests are pulled from.
	DeviceHostPaths []*string `locationName:"deviceHostPaths" type:"list"`

	// Comma-separated list of paths on the iOS device where the artifacts generated
	// by the customer's tests are pulled from.
	IosPaths []*string `locationName:"iosPaths" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerArtifactPaths) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerArtifactPaths) GoString() string {
	return s.String()
}

// SetAndroidPaths sets the AndroidPaths field's value.
func (s *CustomerArtifactPaths) SetAndroidPaths(v []*string) *CustomerArtifactPaths {
	s.AndroidPaths = v
	return s
}

// SetDeviceHostPaths sets the DeviceHostPaths field's value.
func (s *CustomerArtifactPaths) SetDeviceHostPaths(v []*string) *CustomerArtifactPaths {
	s.DeviceHostPaths = v
	return s
}

// SetIosPaths sets the IosPaths field's value.
func (s *CustomerArtifactPaths) SetIosPaths(v []*string) *CustomerArtifactPaths {
	s.IosPaths = v
	return s
}

// Represents a request to the delete device pool operation.
type DeleteDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm device pool
	// to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDevicePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDevicePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDevicePoolInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteDevicePoolInput) SetArn(v string) *DeleteDevicePoolInput {
	s.Arn = &v
	return s
}

// Represents the result of a delete device pool request.
type DeleteDevicePoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDevicePoolOutput) GoString() string {
	return s.String()
}

type DeleteInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile you are requesting
	// to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceProfileInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteInstanceProfileInput) SetArn(v string) *DeleteInstanceProfileInput {
	s.Arn = &v
	return s
}

type DeleteInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceProfileOutput) GoString() string {
	return s.String()
}

type DeleteNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the network profile to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNetworkProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNetworkProfileInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteNetworkProfileInput) SetArn(v string) *DeleteNetworkProfileInput {
	s.Arn = &v
	return s
}

type DeleteNetworkProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkProfileOutput) GoString() string {
	return s.String()
}

// Represents a request to the delete project operation.
type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm project to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteProjectInput) SetArn(v string) *DeleteProjectInput {
	s.Arn = &v
	return s
}

// Represents the result of a delete project request.
type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

// Represents the request to delete the specified remote access session.
type DeleteRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the session for which you want to delete
	// remote access.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRemoteAccessSessionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteRemoteAccessSessionInput) SetArn(v string) *DeleteRemoteAccessSessionInput {
	s.Arn = &v
	return s
}

// The response from the server when a request is made to delete the remote
// access session.
type DeleteRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// Represents a request to the delete run operation.
type DeleteRunInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the run to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRunInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteRunInput) SetArn(v string) *DeleteRunInput {
	s.Arn = &v
	return s
}

// Represents the result of a delete run request.
type DeleteRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRunOutput) GoString() string {
	return s.String()
}

type DeleteTestGridProjectInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the project to delete, from CreateTestGridProject or ListTestGridProjects.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestGridProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestGridProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTestGridProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTestGridProjectInput"}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectArn sets the ProjectArn field's value.
func (s *DeleteTestGridProjectInput) SetProjectArn(v string) *DeleteTestGridProjectInput {
	s.ProjectArn = &v
	return s
}

type DeleteTestGridProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestGridProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestGridProjectOutput) GoString() string {
	return s.String()
}

// Represents a request to the delete upload operation.
type DeleteUploadInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm upload to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUploadInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteUploadInput) SetArn(v string) *DeleteUploadInput {
	s.Arn = &v
	return s
}

// Represents the result of a delete upload request.
type DeleteUploadOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUploadOutput) GoString() string {
	return s.String()
}

type DeleteVPCEConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the VPC endpoint configuration you want
	// to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVPCEConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVPCEConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVPCEConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVPCEConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteVPCEConfigurationInput) SetArn(v string) *DeleteVPCEConfigurationInput {
	s.Arn = &v
	return s
}

type DeleteVPCEConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVPCEConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVPCEConfigurationOutput) GoString() string {
	return s.String()
}

// Represents a device type that an app is tested against.
type Device struct {
	_ struct{} `type:"structure"`

	// The device's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// Indicates how likely a device is available for a test run. Currently available
	// in the ListDevices and GetDevice API methods.
	Availability *string `locationName:"availability" type:"string" enum:"DeviceAvailability"`

	// The device's carrier.
	Carrier *string `locationName:"carrier" type:"string"`

	// Information about the device's CPU.
	Cpu *CPU `locationName:"cpu" type:"structure"`

	// The name of the fleet to which this device belongs.
	FleetName *string `locationName:"fleetName" type:"string"`

	// The type of fleet to which this device belongs. Possible values are PRIVATE
	// and PUBLIC.
	FleetType *string `locationName:"fleetType" type:"string"`

	// The device's form factor.
	//
	// Allowed values include:
	//
	//    * PHONE
	//
	//    * TABLET
	FormFactor *string `locationName:"formFactor" type:"string" enum:"DeviceFormFactor"`

	// The device's heap size, expressed in bytes.
	HeapSize *int64 `locationName:"heapSize" type:"long"`

	// The device's image name.
	Image *string `locationName:"image" type:"string"`

	// The instances that belong to this device.
	Instances []*DeviceInstance `locationName:"instances" type:"list"`

	// The device's manufacturer name.
	Manufacturer *string `locationName:"manufacturer" type:"string"`

	// The device's total memory size, expressed in bytes.
	Memory *int64 `locationName:"memory" type:"long"`

	// The device's model name.
	Model *string `locationName:"model" type:"string"`

	// The device's model ID.
	ModelId *string `locationName:"modelId" type:"string"`

	// The device's display name.
	Name *string `locationName:"name" type:"string"`

	// The device's operating system type.
	Os *string `locationName:"os" type:"string"`

	// The device's platform.
	//
	// Allowed values include:
	//
	//    * ANDROID
	//
	//    * IOS
	Platform *string `locationName:"platform" type:"string" enum:"DevicePlatform"`

	// The device's radio.
	Radio *string `locationName:"radio" type:"string"`

	// Specifies whether remote access has been enabled for the specified device.
	RemoteAccessEnabled *bool `locationName:"remoteAccessEnabled" type:"boolean"`

	// This flag is set to true if remote debugging is enabled for the device.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	RemoteDebugEnabled *bool `locationName:"remoteDebugEnabled" type:"boolean"`

	// The resolution of the device.
	Resolution *Resolution `locationName:"resolution" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Device) SetArn(v string) *Device {
	s.Arn = &v
	return s
}

// SetAvailability sets the Availability field's value.
func (s *Device) SetAvailability(v string) *Device {
	s.Availability = &v
	return s
}

// SetCarrier sets the Carrier field's value.
func (s *Device) SetCarrier(v string) *Device {
	s.Carrier = &v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *Device) SetCpu(v *CPU) *Device {
	s.Cpu = v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *Device) SetFleetName(v string) *Device {
	s.FleetName = &v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *Device) SetFleetType(v string) *Device {
	s.FleetType = &v
	return s
}

// SetFormFactor sets the FormFactor field's value.
func (s *Device) SetFormFactor(v string) *Device {
	s.FormFactor = &v
	return s
}

// SetHeapSize sets the HeapSize field's value.
func (s *Device) SetHeapSize(v int64) *Device {
	s.HeapSize = &v
	return s
}

// SetImage sets the Image field's value.
func (s *Device) SetImage(v string) *Device {
	s.Image = &v
	return s
}

// SetInstances sets the Instances field's value.
func (s *Device) SetInstances(v []*DeviceInstance) *Device {
	s.Instances = v
	return s
}

// SetManufacturer sets the Manufacturer field's value.
func (s *Device) SetManufacturer(v string) *Device {
	s.Manufacturer = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *Device) SetMemory(v int64) *Device {
	s.Memory = &v
	return s
}

// SetModel sets the Model field's value.
func (s *Device) SetModel(v string) *Device {
	s.Model = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *Device) SetModelId(v string) *Device {
	s.ModelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Device) SetName(v string) *Device {
	s.Name = &v
	return s
}

// SetOs sets the Os field's value.
func (s *Device) SetOs(v string) *Device {
	s.Os = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Device) SetPlatform(v string) *Device {
	s.Platform = &v
	return s
}

// SetRadio sets the Radio field's value.
func (s *Device) SetRadio(v string) *Device {
	s.Radio = &v
	return s
}

// SetRemoteAccessEnabled sets the RemoteAccessEnabled field's value.
func (s *Device) SetRemoteAccessEnabled(v bool) *Device {
	s.RemoteAccessEnabled = &v
	return s
}

// SetRemoteDebugEnabled sets the RemoteDebugEnabled field's value.
func (s *Device) SetRemoteDebugEnabled(v bool) *Device {
	s.RemoteDebugEnabled = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *Device) SetResolution(v *Resolution) *Device {
	s.Resolution = v
	return s
}

// Represents a device filter used to select a set of devices to be included
// in a test run. This data structure is passed in as the deviceSelectionConfiguration
// parameter to ScheduleRun. For an example of the JSON request syntax, see
// ScheduleRun.
//
// It is also passed in as the filters parameter to ListDevices. For an example
// of the JSON request syntax, see ListDevices.
type DeviceFilter struct {
	_ struct{} `type:"structure"`

	// The aspect of a device such as platform or model used as the selection criteria
	// in a device filter.
	//
	// The supported operators for each attribute are provided in the following
	// list.
	//
	// ARN
	//
	// The Amazon Resource Name (ARN) of the device (for example, arn:aws:devicefarm:us-west-2::device:12345Example).
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// PLATFORM
	//
	// The device platform. Valid values are ANDROID or IOS.
	//
	// Supported operators: EQUALS
	//
	// OS_VERSION
	//
	// The operating system version (for example, 10.3.2).
	//
	// Supported operators: EQUALS, GREATER_THAN, GREATER_THAN_OR_EQUALS, IN, LESS_THAN,
	// LESS_THAN_OR_EQUALS, NOT_IN
	//
	// MODEL
	//
	// The device model (for example, iPad 5th Gen).
	//
	// Supported operators: CONTAINS, EQUALS, IN, NOT_IN
	//
	// AVAILABILITY
	//
	// The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE,
	// BUSY, or TEMPORARY_NOT_AVAILABLE.
	//
	// Supported operators: EQUALS
	//
	// FORM_FACTOR
	//
	// The device form factor. Valid values are PHONE or TABLET.
	//
	// Supported operators: EQUALS
	//
	// MANUFACTURER
	//
	// The device manufacturer (for example, Apple).
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// REMOTE_ACCESS_ENABLED
	//
	// Whether the device is enabled for remote access. Valid values are TRUE or
	// FALSE.
	//
	// Supported operators: EQUALS
	//
	// REMOTE_DEBUG_ENABLED
	//
	// Whether the device is enabled for remote debugging. Valid values are TRUE
	// or FALSE.
	//
	// Supported operators: EQUALS
	//
	// Because remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html),
	// this filter is ignored.
	//
	// INSTANCE_ARN
	//
	// The Amazon Resource Name (ARN) of the device instance.
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// INSTANCE_LABELS
	//
	// The label of the device instance.
	//
	// Supported operators: CONTAINS
	//
	// FLEET_TYPE
	//
	// The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	// Supported operators: EQUALS
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"DeviceFilterAttribute"`

	// Specifies how Device Farm compares the filter's attribute to the value. See
	// the attribute descriptions.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"RuleOperator"`

	// An array of one or more filter values used in a device filter.
	//
	// Operator Values
	//
	//    * The IN and NOT_IN operators can take a values array that has more than
	//    one element.
	//
	//    * The other operators require an array with a single element.
	//
	// Attribute Values
	//
	//    * The PLATFORM attribute can be set to ANDROID or IOS.
	//
	//    * The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE,
	//    BUSY, or TEMPORARY_NOT_AVAILABLE.
	//
	//    * The FORM_FACTOR attribute can be set to PHONE or TABLET.
	//
	//    * The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeviceFilter"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *DeviceFilter) SetAttribute(v string) *DeviceFilter {
	s.Attribute = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *DeviceFilter) SetOperator(v string) *DeviceFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DeviceFilter) SetValues(v []*string) *DeviceFilter {
	s.Values = v
	return s
}

// Represents the device instance.
type DeviceInstance struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the device instance.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The ARN of the device.
	DeviceArn *string `locationName:"deviceArn" min:"32" type:"string"`

	// A object that contains information about the instance profile.
	InstanceProfile *InstanceProfile `locationName:"instanceProfile" type:"structure"`

	// An array of strings that describe the device instance.
	Labels []*string `locationName:"labels" type:"list"`

	// The status of the device instance. Valid values are listed here.
	Status *string `locationName:"status" type:"string" enum:"InstanceStatus"`

	// Unique device identifier for the device instance.
	Udid *string `locationName:"udid" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceInstance) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeviceInstance) SetArn(v string) *DeviceInstance {
	s.Arn = &v
	return s
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *DeviceInstance) SetDeviceArn(v string) *DeviceInstance {
	s.DeviceArn = &v
	return s
}

// SetInstanceProfile sets the InstanceProfile field's value.
func (s *DeviceInstance) SetInstanceProfile(v *InstanceProfile) *DeviceInstance {
	s.InstanceProfile = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *DeviceInstance) SetLabels(v []*string) *DeviceInstance {
	s.Labels = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeviceInstance) SetStatus(v string) *DeviceInstance {
	s.Status = &v
	return s
}

// SetUdid sets the Udid field's value.
func (s *DeviceInstance) SetUdid(v string) *DeviceInstance {
	s.Udid = &v
	return s
}

// Represents the total (metered or unmetered) minutes used by the resource
// to run tests. Contains the sum of minutes consumed by all children.
type DeviceMinutes struct {
	_ struct{} `type:"structure"`

	// When specified, represents only the sum of metered minutes used by the resource
	// to run tests.
	Metered *float64 `locationName:"metered" type:"double"`

	// When specified, represents the total minutes used by the resource to run
	// tests.
	Total *float64 `locationName:"total" type:"double"`

	// When specified, represents only the sum of unmetered minutes used by the
	// resource to run tests.
	Unmetered *float64 `locationName:"unmetered" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceMinutes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceMinutes) GoString() string {
	return s.String()
}

// SetMetered sets the Metered field's value.
func (s *DeviceMinutes) SetMetered(v float64) *DeviceMinutes {
	s.Metered = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *DeviceMinutes) SetTotal(v float64) *DeviceMinutes {
	s.Total = &v
	return s
}

// SetUnmetered sets the Unmetered field's value.
func (s *DeviceMinutes) SetUnmetered(v float64) *DeviceMinutes {
	s.Unmetered = &v
	return s
}

// Represents a collection of device types.
type DevicePool struct {
	_ struct{} `type:"structure"`

	// The device pool's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The device pool's description.
	Description *string `locationName:"description" type:"string"`

	// The number of devices that Device Farm can add to your device pool. Device
	// Farm adds devices that are available and meet the criteria that you assign
	// for the rules parameter. Depending on how many devices meet these constraints,
	// your device pool might contain fewer devices than the value for this parameter.
	//
	// By specifying the maximum number of devices, you can control the costs that
	// you incur by running tests.
	MaxDevices *int64 `locationName:"maxDevices" type:"integer"`

	// The device pool's name.
	Name *string `locationName:"name" type:"string"`

	// Information about the device pool's rules.
	Rules []*Rule `locationName:"rules" type:"list"`

	// The device pool's type.
	//
	// Allowed values include:
	//
	//    * CURATED: A device pool that is created and managed by AWS Device Farm.
	//
	//    * PRIVATE: A device pool that is created and managed by the device pool
	//    developer.
	Type *string `locationName:"type" type:"string" enum:"DevicePoolType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DevicePool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DevicePool) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DevicePool) SetArn(v string) *DevicePool {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DevicePool) SetDescription(v string) *DevicePool {
	s.Description = &v
	return s
}

// SetMaxDevices sets the MaxDevices field's value.
func (s *DevicePool) SetMaxDevices(v int64) *DevicePool {
	s.MaxDevices = &v
	return s
}

// SetName sets the Name field's value.
func (s *DevicePool) SetName(v string) *DevicePool {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *DevicePool) SetRules(v []*Rule) *DevicePool {
	s.Rules = v
	return s
}

// SetType sets the Type field's value.
func (s *DevicePool) SetType(v string) *DevicePool {
	s.Type = &v
	return s
}

// Represents a device pool compatibility result.
type DevicePoolCompatibilityResult struct {
	_ struct{} `type:"structure"`

	// Whether the result was compatible with the device pool.
	Compatible *bool `locationName:"compatible" type:"boolean"`

	// The device (phone or tablet) to return information about.
	Device *Device `locationName:"device" type:"structure"`

	// Information about the compatibility.
	IncompatibilityMessages []*IncompatibilityMessage `locationName:"incompatibilityMessages" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DevicePoolCompatibilityResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DevicePoolCompatibilityResult) GoString() string {
	return s.String()
}

// SetCompatible sets the Compatible field's value.
func (s *DevicePoolCompatibilityResult) SetCompatible(v bool) *DevicePoolCompatibilityResult {
	s.Compatible = &v
	return s
}

// SetDevice sets the Device field's value.
func (s *DevicePoolCompatibilityResult) SetDevice(v *Device) *DevicePoolCompatibilityResult {
	s.Device = v
	return s
}

// SetIncompatibilityMessages sets the IncompatibilityMessages field's value.
func (s *DevicePoolCompatibilityResult) SetIncompatibilityMessages(v []*IncompatibilityMessage) *DevicePoolCompatibilityResult {
	s.IncompatibilityMessages = v
	return s
}

// Represents the device filters used in a test run and the maximum number of
// devices to be included in the run. It is passed in as the deviceSelectionConfiguration
// request parameter in ScheduleRun.
type DeviceSelectionConfiguration struct {
	_ struct{} `type:"structure"`

	// Used to dynamically select a set of devices for a test run. A filter is made
	// up of an attribute, an operator, and one or more values.
	//
	//    * Attribute The aspect of a device such as platform or model used as the
	//    selection criteria in a device filter. Allowed values include: ARN: The
	//    Amazon Resource Name (ARN) of the device (for example, arn:aws:devicefarm:us-west-2::device:12345Example).
	//    PLATFORM: The device platform. Valid values are ANDROID or IOS. OS_VERSION:
	//    The operating system version (for example, 10.3.2). MODEL: The device
	//    model (for example, iPad 5th Gen). AVAILABILITY: The current availability
	//    of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
	//    TEMPORARY_NOT_AVAILABLE. FORM_FACTOR: The device form factor. Valid values
	//    are PHONE or TABLET. MANUFACTURER: The device manufacturer (for example,
	//    Apple). REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote
	//    access. Valid values are TRUE or FALSE. REMOTE_DEBUG_ENABLED: Whether
	//    the device is enabled for remote debugging. Valid values are TRUE or FALSE.
	//    Because remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html),
	//    this filter is ignored. INSTANCE_ARN: The Amazon Resource Name (ARN) of
	//    the device instance. INSTANCE_LABELS: The label of the device instance.
	//    FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	//    * Operator The filter operator. The EQUALS operator is available for every
	//    attribute except INSTANCE_LABELS. The CONTAINS operator is available for
	//    the INSTANCE_LABELS and MODEL attributes. The IN and NOT_IN operators
	//    are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN
	//    attributes. The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS
	//    operators are also available for the OS_VERSION attribute.
	//
	//    * Values An array of one or more filter values. Operator Values The IN
	//    and NOT_IN operators can take a values array that has more than one element.
	//    The other operators require an array with a single element. Attribute
	//    Values The PLATFORM attribute can be set to ANDROID or IOS. The AVAILABILITY
	//    attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
	//    The FORM_FACTOR attribute can be set to PHONE or TABLET. The FLEET_TYPE
	//    attribute can be set to PUBLIC or PRIVATE.
	//
	// Filters is a required field
	Filters []*DeviceFilter `locationName:"filters" type:"list" required:"true"`

	// The maximum number of devices to be included in a test run.
	//
	// MaxDevices is a required field
	MaxDevices *int64 `locationName:"maxDevices" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSelectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSelectionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceSelectionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeviceSelectionConfiguration"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.MaxDevices == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxDevices"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DeviceSelectionConfiguration) SetFilters(v []*DeviceFilter) *DeviceSelectionConfiguration {
	s.Filters = v
	return s
}

// SetMaxDevices sets the MaxDevices field's value.
func (s *DeviceSelectionConfiguration) SetMaxDevices(v int64) *DeviceSelectionConfiguration {
	s.MaxDevices = &v
	return s
}

// Contains the run results requested by the device selection configuration
// and how many devices were returned. For an example of the JSON response syntax,
// see ScheduleRun.
type DeviceSelectionResult struct {
	_ struct{} `type:"structure"`

	// The filters in a device selection result.
	Filters []*DeviceFilter `locationName:"filters" type:"list"`

	// The number of devices that matched the device filter selection criteria.
	MatchedDevicesCount *int64 `locationName:"matchedDevicesCount" type:"integer"`

	// The maximum number of devices to be selected by a device filter and included
	// in a test run.
	MaxDevices *int64 `locationName:"maxDevices" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSelectionResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSelectionResult) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *DeviceSelectionResult) SetFilters(v []*DeviceFilter) *DeviceSelectionResult {
	s.Filters = v
	return s
}

// SetMatchedDevicesCount sets the MatchedDevicesCount field's value.
func (s *DeviceSelectionResult) SetMatchedDevicesCount(v int64) *DeviceSelectionResult {
	s.MatchedDevicesCount = &v
	return s
}

// SetMaxDevices sets the MaxDevices field's value.
func (s *DeviceSelectionResult) SetMaxDevices(v int64) *DeviceSelectionResult {
	s.MaxDevices = &v
	return s
}

// Represents configuration information about a test run, such as the execution
// timeout (in minutes).
type ExecutionConfiguration struct {
	_ struct{} `type:"structure"`

	// True if account cleanup is enabled at the beginning of the test. Otherwise,
	// false.
	AccountsCleanup *bool `locationName:"accountsCleanup" type:"boolean"`

	// True if app package cleanup is enabled at the beginning of the test. Otherwise,
	// false.
	AppPackagesCleanup *bool `locationName:"appPackagesCleanup" type:"boolean"`

	// The number of minutes a test run executes before it times out.
	JobTimeoutMinutes *int64 `locationName:"jobTimeoutMinutes" type:"integer"`

	// When set to true, for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see Do you
	// modify my app? (https://aws.amazon.com/device-farm/faq/) in the AWS Device
	// Farm FAQs.
	SkipAppResign *bool `locationName:"skipAppResign" type:"boolean"`

	// Set to true to enable video capture. Otherwise, set to false. The default
	// is true.
	VideoCapture *bool `locationName:"videoCapture" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionConfiguration) GoString() string {
	return s.String()
}

// SetAccountsCleanup sets the AccountsCleanup field's value.
func (s *ExecutionConfiguration) SetAccountsCleanup(v bool) *ExecutionConfiguration {
	s.AccountsCleanup = &v
	return s
}

// SetAppPackagesCleanup sets the AppPackagesCleanup field's value.
func (s *ExecutionConfiguration) SetAppPackagesCleanup(v bool) *ExecutionConfiguration {
	s.AppPackagesCleanup = &v
	return s
}

// SetJobTimeoutMinutes sets the JobTimeoutMinutes field's value.
func (s *ExecutionConfiguration) SetJobTimeoutMinutes(v int64) *ExecutionConfiguration {
	s.JobTimeoutMinutes = &v
	return s
}

// SetSkipAppResign sets the SkipAppResign field's value.
func (s *ExecutionConfiguration) SetSkipAppResign(v bool) *ExecutionConfiguration {
	s.SkipAppResign = &v
	return s
}

// SetVideoCapture sets the VideoCapture field's value.
func (s *ExecutionConfiguration) SetVideoCapture(v bool) *ExecutionConfiguration {
	s.VideoCapture = &v
	return s
}

// Represents the request sent to retrieve the account settings.
type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

// Represents the account settings return values from the GetAccountSettings
// request.
type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The account settings.
	AccountSettings *AccountSettings `locationName:"accountSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *GetAccountSettingsOutput) SetAccountSettings(v *AccountSettings) *GetAccountSettingsOutput {
	s.AccountSettings = v
	return s
}

// Represents a request to the get device request.
type GetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device type's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetDeviceInput) SetArn(v string) *GetDeviceInput {
	s.Arn = &v
	return s
}

type GetDeviceInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance you're requesting information
	// about.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceInstanceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetDeviceInstanceInput) SetArn(v string) *GetDeviceInstanceInput {
	s.Arn = &v
	return s
}

type GetDeviceInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your device instance.
	DeviceInstance *DeviceInstance `locationName:"deviceInstance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInstanceOutput) GoString() string {
	return s.String()
}

// SetDeviceInstance sets the DeviceInstance field's value.
func (s *GetDeviceInstanceOutput) SetDeviceInstance(v *DeviceInstance) *GetDeviceInstanceOutput {
	s.DeviceInstance = v
	return s
}

// Represents the result of a get device request.
type GetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the requested device.
	Device *Device `locationName:"device" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *GetDeviceOutput) SetDevice(v *Device) *GetDeviceOutput {
	s.Device = v
	return s
}

// Represents a request to the get device pool compatibility operation.
type GetDevicePoolCompatibilityInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the app that is associated with the specified device pool.
	AppArn *string `locationName:"appArn" min:"32" type:"string"`

	// An object that contains information about the settings for a run.
	Configuration *ScheduleRunConfiguration `locationName:"configuration" type:"structure"`

	// The device pool's ARN.
	//
	// DevicePoolArn is a required field
	DevicePoolArn *string `locationName:"devicePoolArn" min:"32" type:"string" required:"true"`

	// Information about the uploaded test to be run against the device pool.
	Test *ScheduleRunTest `locationName:"test" type:"structure"`

	// The test type for the specified device pool.
	//
	// Allowed values include the following:
	//
	//    * BUILTIN_FUZZ.
	//
	//    * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android
	//    app, interacting with it and capturing screenshots at the same time.
	//
	//    * APPIUM_JAVA_JUNIT.
	//
	//    * APPIUM_JAVA_TESTNG.
	//
	//    * APPIUM_PYTHON.
	//
	//    * APPIUM_NODE.
	//
	//    * APPIUM_RUBY.
	//
	//    * APPIUM_WEB_JAVA_JUNIT.
	//
	//    * APPIUM_WEB_JAVA_TESTNG.
	//
	//    * APPIUM_WEB_PYTHON.
	//
	//    * APPIUM_WEB_NODE.
	//
	//    * APPIUM_WEB_RUBY.
	//
	//    * CALABASH.
	//
	//    * INSTRUMENTATION.
	//
	//    * UIAUTOMATION.
	//
	//    * UIAUTOMATOR.
	//
	//    * XCTEST.
	//
	//    * XCTEST_UI.
	TestType *string `locationName:"testType" type:"string" enum:"TestType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePoolCompatibilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePoolCompatibilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicePoolCompatibilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicePoolCompatibilityInput"}
	if s.AppArn != nil && len(*s.AppArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("AppArn", 32))
	}
	if s.DevicePoolArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DevicePoolArn"))
	}
	if s.DevicePoolArn != nil && len(*s.DevicePoolArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("DevicePoolArn", 32))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Test != nil {
		if err := s.Test.Validate(); err != nil {
			invalidParams.AddNested("Test", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *GetDevicePoolCompatibilityInput) SetAppArn(v string) *GetDevicePoolCompatibilityInput {
	s.AppArn = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetDevicePoolCompatibilityInput) SetConfiguration(v *ScheduleRunConfiguration) *GetDevicePoolCompatibilityInput {
	s.Configuration = v
	return s
}

// SetDevicePoolArn sets the DevicePoolArn field's value.
func (s *GetDevicePoolCompatibilityInput) SetDevicePoolArn(v string) *GetDevicePoolCompatibilityInput {
	s.DevicePoolArn = &v
	return s
}

// SetTest sets the Test field's value.
func (s *GetDevicePoolCompatibilityInput) SetTest(v *ScheduleRunTest) *GetDevicePoolCompatibilityInput {
	s.Test = v
	return s
}

// SetTestType sets the TestType field's value.
func (s *GetDevicePoolCompatibilityInput) SetTestType(v string) *GetDevicePoolCompatibilityInput {
	s.TestType = &v
	return s
}

// Represents the result of describe device pool compatibility request.
type GetDevicePoolCompatibilityOutput struct {
	_ struct{} `type:"structure"`

	// Information about compatible devices.
	CompatibleDevices []*DevicePoolCompatibilityResult `locationName:"compatibleDevices" type:"list"`

	// Information about incompatible devices.
	IncompatibleDevices []*DevicePoolCompatibilityResult `locationName:"incompatibleDevices" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePoolCompatibilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePoolCompatibilityOutput) GoString() string {
	return s.String()
}

// SetCompatibleDevices sets the CompatibleDevices field's value.
func (s *GetDevicePoolCompatibilityOutput) SetCompatibleDevices(v []*DevicePoolCompatibilityResult) *GetDevicePoolCompatibilityOutput {
	s.CompatibleDevices = v
	return s
}

// SetIncompatibleDevices sets the IncompatibleDevices field's value.
func (s *GetDevicePoolCompatibilityOutput) SetIncompatibleDevices(v []*DevicePoolCompatibilityResult) *GetDevicePoolCompatibilityOutput {
	s.IncompatibleDevices = v
	return s
}

// Represents a request to the get device pool operation.
type GetDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// The device pool's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicePoolInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetDevicePoolInput) SetArn(v string) *GetDevicePoolInput {
	s.Arn = &v
	return s
}

// Represents the result of a get device pool request.
type GetDevicePoolOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the requested device pool.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicePoolOutput) GoString() string {
	return s.String()
}

// SetDevicePool sets the DevicePool field's value.
func (s *GetDevicePoolOutput) SetDevicePool(v *DevicePool) *GetDevicePoolOutput {
	s.DevicePool = v
	return s
}

type GetInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an instance profile.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceProfileInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetInstanceProfileInput) SetArn(v string) *GetInstanceProfileInput {
	s.Arn = &v
	return s
}

type GetInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about an instance profile.
	InstanceProfile *InstanceProfile `locationName:"instanceProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceProfileOutput) GoString() string {
	return s.String()
}

// SetInstanceProfile sets the InstanceProfile field's value.
func (s *GetInstanceProfileOutput) SetInstanceProfile(v *InstanceProfile) *GetInstanceProfileOutput {
	s.InstanceProfile = v
	return s
}

// Represents a request to the get job operation.
type GetJobInput struct {
	_ struct{} `type:"structure"`

	// The job's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetJobInput) SetArn(v string) *GetJobInput {
	s.Arn = &v
	return s
}

// Represents the result of a get job request.
type GetJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the requested job.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *GetJobOutput) SetJob(v *Job) *GetJobOutput {
	s.Job = v
	return s
}

type GetNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the network profile to return information about.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNetworkProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNetworkProfileInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetNetworkProfileInput) SetArn(v string) *GetNetworkProfileInput {
	s.Arn = &v
	return s
}

type GetNetworkProfileOutput struct {
	_ struct{} `type:"structure"`

	// The network profile.
	NetworkProfile *NetworkProfile `locationName:"networkProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkProfileOutput) GoString() string {
	return s.String()
}

// SetNetworkProfile sets the NetworkProfile field's value.
func (s *GetNetworkProfileOutput) SetNetworkProfile(v *NetworkProfile) *GetNetworkProfileOutput {
	s.NetworkProfile = v
	return s
}

// Represents the request to retrieve the offering status for the specified
// customer or account.
type GetOfferingStatusInput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOfferingStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOfferingStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOfferingStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOfferingStatusInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetOfferingStatusInput) SetNextToken(v string) *GetOfferingStatusInput {
	s.NextToken = &v
	return s
}

// Returns the status result for a device offering.
type GetOfferingStatusOutput struct {
	_ struct{} `type:"structure"`

	// When specified, gets the offering status for the current period.
	Current map[string]*OfferingStatus `locationName:"current" type:"map"`

	// When specified, gets the offering status for the next period.
	NextPeriod map[string]*OfferingStatus `locationName:"nextPeriod" type:"map"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOfferingStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOfferingStatusOutput) GoString() string {
	return s.String()
}

// SetCurrent sets the Current field's value.
func (s *GetOfferingStatusOutput) SetCurrent(v map[string]*OfferingStatus) *GetOfferingStatusOutput {
	s.Current = v
	return s
}

// SetNextPeriod sets the NextPeriod field's value.
func (s *GetOfferingStatusOutput) SetNextPeriod(v map[string]*OfferingStatus) *GetOfferingStatusOutput {
	s.NextPeriod = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOfferingStatusOutput) SetNextToken(v string) *GetOfferingStatusOutput {
	s.NextToken = &v
	return s
}

// Represents a request to the get project operation.
type GetProjectInput struct {
	_ struct{} `type:"structure"`

	// The project's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProjectInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetProjectInput) SetArn(v string) *GetProjectInput {
	s.Arn = &v
	return s
}

// Represents the result of a get project request.
type GetProjectOutput struct {
	_ struct{} `type:"structure"`

	// The project to get information about.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *GetProjectOutput) SetProject(v *Project) *GetProjectOutput {
	s.Project = v
	return s
}

// Represents the request to get information about the specified remote access
// session.
type GetRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the remote access session about which you
	// want to get session information.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRemoteAccessSessionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetRemoteAccessSessionInput) SetArn(v string) *GetRemoteAccessSessionInput {
	s.Arn = &v
	return s
}

// Represents the response from the server that lists detailed information about
// the remote access session.
type GetRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`

	// A container that lists detailed information about the remote access session.
	RemoteAccessSession *RemoteAccessSession `locationName:"remoteAccessSession" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// SetRemoteAccessSession sets the RemoteAccessSession field's value.
func (s *GetRemoteAccessSessionOutput) SetRemoteAccessSession(v *RemoteAccessSession) *GetRemoteAccessSessionOutput {
	s.RemoteAccessSession = v
	return s
}

// Represents a request to the get run operation.
type GetRunInput struct {
	_ struct{} `type:"structure"`

	// The run's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRunInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetRunInput) SetArn(v string) *GetRunInput {
	s.Arn = &v
	return s
}

// Represents the result of a get run request.
type GetRunOutput struct {
	_ struct{} `type:"structure"`

	// The run to get results from.
	Run *Run `locationName:"run" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRunOutput) GoString() string {
	return s.String()
}

// SetRun sets the Run field's value.
func (s *GetRunOutput) SetRun(v *Run) *GetRunOutput {
	s.Run = v
	return s
}

// Represents a request to the get suite operation.
type GetSuiteInput struct {
	_ struct{} `type:"structure"`

	// The suite's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSuiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSuiteInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetSuiteInput) SetArn(v string) *GetSuiteInput {
	s.Arn = &v
	return s
}

// Represents the result of a get suite request.
type GetSuiteOutput struct {
	_ struct{} `type:"structure"`

	// A collection of one or more tests.
	Suite *Suite `locationName:"suite" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteOutput) GoString() string {
	return s.String()
}

// SetSuite sets the Suite field's value.
func (s *GetSuiteOutput) SetSuite(v *Suite) *GetSuiteOutput {
	s.Suite = v
	return s
}

type GetTestGridProjectInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Selenium testing project, from either CreateTestGridProject
	// or ListTestGridProjects.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestGridProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestGridProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestGridProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTestGridProjectInput"}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectArn sets the ProjectArn field's value.
func (s *GetTestGridProjectInput) SetProjectArn(v string) *GetTestGridProjectInput {
	s.ProjectArn = &v
	return s
}

type GetTestGridProjectOutput struct {
	_ struct{} `type:"structure"`

	// A TestGridProject.
	TestGridProject *TestGridProject `locationName:"testGridProject" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestGridProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestGridProjectOutput) GoString() string {
	return s.String()
}

// SetTestGridProject sets the TestGridProject field's value.
func (s *GetTestGridProjectOutput) SetTestGridProject(v *TestGridProject) *GetTestGridProjectOutput {
	s.TestGridProject = v
	return s
}

type GetTestGridSessionInput struct {
	_ struct{} `type:"structure"`

	// The ARN for the project that this session belongs to. See CreateTestGridProject
	// and ListTestGridProjects.
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string"`

	// An ARN that uniquely identifies a TestGridSession.
	SessionArn *string `locationName:"sessionArn" min:"32" type:"string"`

	// An ID associated with this session.
	SessionId *string `locationName:"sessionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestGridSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestGridSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestGridSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTestGridSessionInput"}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.SessionArn != nil && len(*s.SessionArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("SessionArn", 32))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectArn sets the ProjectArn field's value.
func (s *GetTestGridSessionInput) SetProjectArn(v string) *GetTestGridSessionInput {
	s.ProjectArn = &v
	return s
}

// SetSessionArn sets the SessionArn field's value.
func (s *GetTestGridSessionInput) SetSessionArn(v string) *GetTestGridSessionInput {
	s.SessionArn = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetTestGridSessionInput) SetSessionId(v string) *GetTestGridSessionInput {
	s.SessionId = &v
	return s
}

type GetTestGridSessionOutput struct {
	_ struct{} `type:"structure"`

	// The TestGridSession that was requested.
	TestGridSession *TestGridSession `locationName:"testGridSession" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestGridSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestGridSessionOutput) GoString() string {
	return s.String()
}

// SetTestGridSession sets the TestGridSession field's value.
func (s *GetTestGridSessionOutput) SetTestGridSession(v *TestGridSession) *GetTestGridSessionOutput {
	s.TestGridSession = v
	return s
}

// Represents a request to the get test operation.
type GetTestInput struct {
	_ struct{} `type:"structure"`

	// The test's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTestInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetTestInput) SetArn(v string) *GetTestInput {
	s.Arn = &v
	return s
}

// Represents the result of a get test request.
type GetTestOutput struct {
	_ struct{} `type:"structure"`

	// A test condition that is evaluated.
	Test *Test `locationName:"test" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestOutput) GoString() string {
	return s.String()
}

// SetTest sets the Test field's value.
func (s *GetTestOutput) SetTest(v *Test) *GetTestOutput {
	s.Test = v
	return s
}

// Represents a request to the get upload operation.
type GetUploadInput struct {
	_ struct{} `type:"structure"`

	// The upload's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUploadInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetUploadInput) SetArn(v string) *GetUploadInput {
	s.Arn = &v
	return s
}

// Represents the result of a get upload request.
type GetUploadOutput struct {
	_ struct{} `type:"structure"`

	// An app or a set of one or more tests to upload or that have been uploaded.
	Upload *Upload `locationName:"upload" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUploadOutput) GoString() string {
	return s.String()
}

// SetUpload sets the Upload field's value.
func (s *GetUploadOutput) SetUpload(v *Upload) *GetUploadOutput {
	s.Upload = v
	return s
}

type GetVPCEConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the VPC endpoint configuration you want
	// to describe.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVPCEConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVPCEConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVPCEConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVPCEConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetVPCEConfigurationInput) SetArn(v string) *GetVPCEConfigurationInput {
	s.Arn = &v
	return s
}

type GetVPCEConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your VPC endpoint configuration.
	VpceConfiguration *VPCEConfiguration `locationName:"vpceConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVPCEConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVPCEConfigurationOutput) GoString() string {
	return s.String()
}

// SetVpceConfiguration sets the VpceConfiguration field's value.
func (s *GetVPCEConfigurationOutput) SetVpceConfiguration(v *VPCEConfiguration) *GetVPCEConfigurationOutput {
	s.VpceConfiguration = v
	return s
}

// An entity with the same name already exists.
type IdempotencyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Any additional information about the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotencyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotencyException) GoString() string {
	return s.String()
}

func newErrorIdempotencyException(v protocol.ResponseMetadata) error {
	return &IdempotencyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IdempotencyException) Code() string {
	return "IdempotencyException"
}

// Message returns the exception's message.
func (s *IdempotencyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IdempotencyException) OrigErr() error {
	return nil
}

func (s *IdempotencyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IdempotencyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IdempotencyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about incompatibility.
type IncompatibilityMessage struct {
	_ struct{} `type:"structure"`

	// A message about the incompatibility.
	Message *string `locationName:"message" type:"string"`

	// The type of incompatibility.
	//
	// Allowed values include:
	//
	//    * ARN
	//
	//    * FORM_FACTOR (for example, phone or tablet)
	//
	//    * MANUFACTURER
	//
	//    * PLATFORM (for example, Android or iOS)
	//
	//    * REMOTE_ACCESS_ENABLED
	//
	//    * APPIUM_VERSION
	Type *string `locationName:"type" type:"string" enum:"DeviceAttribute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncompatibilityMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncompatibilityMessage) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *IncompatibilityMessage) SetMessage(v string) *IncompatibilityMessage {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *IncompatibilityMessage) SetType(v string) *IncompatibilityMessage {
	s.Type = &v
	return s
}

// Represents the request to install an Android application (in .apk format)
// or an iOS application (in .ipa format) as part of a remote access session.
type InstallToRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the app about which you are requesting information.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" min:"32" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the remote access session about which you
	// are requesting information.
	//
	// RemoteAccessSessionArn is a required field
	RemoteAccessSessionArn *string `locationName:"remoteAccessSessionArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstallToRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstallToRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstallToRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstallToRemoteAccessSessionInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppArn != nil && len(*s.AppArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("AppArn", 32))
	}
	if s.RemoteAccessSessionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteAccessSessionArn"))
	}
	if s.RemoteAccessSessionArn != nil && len(*s.RemoteAccessSessionArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RemoteAccessSessionArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *InstallToRemoteAccessSessionInput) SetAppArn(v string) *InstallToRemoteAccessSessionInput {
	s.AppArn = &v
	return s
}

// SetRemoteAccessSessionArn sets the RemoteAccessSessionArn field's value.
func (s *InstallToRemoteAccessSessionInput) SetRemoteAccessSessionArn(v string) *InstallToRemoteAccessSessionInput {
	s.RemoteAccessSessionArn = &v
	return s
}

// Represents the response from the server after AWS Device Farm makes a request
// to install to a remote access session.
type InstallToRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`

	// An app to upload or that has been uploaded.
	AppUpload *Upload `locationName:"appUpload" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstallToRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstallToRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// SetAppUpload sets the AppUpload field's value.
func (s *InstallToRemoteAccessSessionOutput) SetAppUpload(v *Upload) *InstallToRemoteAccessSessionOutput {
	s.AppUpload = v
	return s
}

// Represents the instance profile.
type InstanceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The description of the instance profile.
	Description *string `locationName:"description" type:"string"`

	// An array of strings containing the list of app packages that should not be
	// cleaned up from the device after a test run completes.
	//
	// The list of packages is considered only if you set packageCleanup to true.
	ExcludeAppPackagesFromCleanup []*string `locationName:"excludeAppPackagesFromCleanup" type:"list"`

	// The name of the instance profile.
	Name *string `locationName:"name" type:"string"`

	// When set to true, Device Farm removes app packages after a test run. The
	// default value is false for private devices.
	PackageCleanup *bool `locationName:"packageCleanup" type:"boolean"`

	// When set to true, Device Farm reboots the instance after a test run. The
	// default value is true.
	RebootAfterUse *bool `locationName:"rebootAfterUse" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceProfile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InstanceProfile) SetArn(v string) *InstanceProfile {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *InstanceProfile) SetDescription(v string) *InstanceProfile {
	s.Description = &v
	return s
}

// SetExcludeAppPackagesFromCleanup sets the ExcludeAppPackagesFromCleanup field's value.
func (s *InstanceProfile) SetExcludeAppPackagesFromCleanup(v []*string) *InstanceProfile {
	s.ExcludeAppPackagesFromCleanup = v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceProfile) SetName(v string) *InstanceProfile {
	s.Name = &v
	return s
}

// SetPackageCleanup sets the PackageCleanup field's value.
func (s *InstanceProfile) SetPackageCleanup(v bool) *InstanceProfile {
	s.PackageCleanup = &v
	return s
}

// SetRebootAfterUse sets the RebootAfterUse field's value.
func (s *InstanceProfile) SetRebootAfterUse(v bool) *InstanceProfile {
	s.RebootAfterUse = &v
	return s
}

// An internal exception was raised in the service. Contact aws-devicefarm-support@amazon.com
// (mailto:aws-devicefarm-support@amazon.com) if you see this error.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was an error with the update request, or you do not have sufficient
// permissions to update this VPC endpoint configuration.
type InvalidOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOperationException) GoString() string {
	return s.String()
}

func newErrorInvalidOperationException(v protocol.ResponseMetadata) error {
	return &InvalidOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidOperationException) Code() string {
	return "InvalidOperationException"
}

// Message returns the exception's message.
func (s *InvalidOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidOperationException) OrigErr() error {
	return nil
}

func (s *InvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a device.
type Job struct {
	_ struct{} `type:"structure"`

	// The job's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The job's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the job was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The device (phone or tablet).
	Device *Device `locationName:"device" type:"structure"`

	// Represents the total (metered or unmetered) minutes used by the job.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// The ARN of the instance.
	InstanceArn *string `locationName:"instanceArn" min:"32" type:"string"`

	// A message about the job's result.
	Message *string `locationName:"message" type:"string"`

	// The job's name.
	Name *string `locationName:"name" type:"string"`

	// The job's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The job's start time.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The job's status.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PENDING_CONCURRENCY
	//
	//    * PENDING_DEVICE
	//
	//    * PROCESSING
	//
	//    * SCHEDULING
	//
	//    * PREPARING
	//
	//    * RUNNING
	//
	//    * COMPLETED
	//
	//    * STOPPING
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The job's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`

	// The job's type.
	//
	// Allowed values include the following:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android
	//    app, interacting with it and capturing screenshots at the same time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	Type *string `locationName:"type" type:"string" enum:"TestType"`

	// This value is set to true if video capture is enabled. Otherwise, it is set
	// to false.
	VideoCapture *bool `locationName:"videoCapture" type:"boolean"`

	// The endpoint for streaming device video.
	VideoEndpoint *string `locationName:"videoEndpoint" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Job) SetArn(v string) *Job {
	s.Arn = &v
	return s
}

// SetCounters sets the Counters field's value.
func (s *Job) SetCounters(v *Counters) *Job {
	s.Counters = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Job) SetCreated(v time.Time) *Job {
	s.Created = &v
	return s
}

// SetDevice sets the Device field's value.
func (s *Job) SetDevice(v *Device) *Job {
	s.Device = v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *Job) SetDeviceMinutes(v *DeviceMinutes) *Job {
	s.DeviceMinutes = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *Job) SetInstanceArn(v string) *Job {
	s.InstanceArn = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Job) SetMessage(v string) *Job {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *Job) SetName(v string) *Job {
	s.Name = &v
	return s
}

// SetResult sets the Result field's value.
func (s *Job) SetResult(v string) *Job {
	s.Result = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *Job) SetStarted(v time.Time) *Job {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Job) SetStatus(v string) *Job {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Job) SetStopped(v time.Time) *Job {
	s.Stopped = &v
	return s
}

// SetType sets the Type field's value.
func (s *Job) SetType(v string) *Job {
	s.Type = &v
	return s
}

// SetVideoCapture sets the VideoCapture field's value.
func (s *Job) SetVideoCapture(v bool) *Job {
	s.VideoCapture = &v
	return s
}

// SetVideoEndpoint sets the VideoEndpoint field's value.
func (s *Job) SetVideoEndpoint(v string) *Job {
	s.VideoEndpoint = &v
	return s
}

// A limit was exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Any additional information about the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a request to the list artifacts operation.
type ListArtifactsInput struct {
	_ struct{} `type:"structure"`

	// The run, job, suite, or test ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The artifacts' type.
	//
	// Allowed values include:
	//
	//    * FILE
	//
	//    * LOG
	//
	//    * SCREENSHOT
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ArtifactCategory"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArtifactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArtifactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListArtifactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListArtifactsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListArtifactsInput) SetArn(v string) *ListArtifactsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArtifactsInput) SetNextToken(v string) *ListArtifactsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListArtifactsInput) SetType(v string) *ListArtifactsInput {
	s.Type = &v
	return s
}

// Represents the result of a list artifacts operation.
type ListArtifactsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the artifacts.
	Artifacts []*Artifact `locationName:"artifacts" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArtifactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArtifactsOutput) GoString() string {
	return s.String()
}

// SetArtifacts sets the Artifacts field's value.
func (s *ListArtifactsOutput) SetArtifacts(v []*Artifact) *ListArtifactsOutput {
	s.Artifacts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArtifactsOutput) SetNextToken(v string) *ListArtifactsOutput {
	s.NextToken = &v
	return s
}

type ListDeviceInstancesInput struct {
	_ struct{} `type:"structure"`

	// An integer that specifies the maximum number of items you want to return
	// in the API response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeviceInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeviceInstancesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceInstancesInput) SetMaxResults(v int64) *ListDeviceInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceInstancesInput) SetNextToken(v string) *ListDeviceInstancesInput {
	s.NextToken = &v
	return s
}

type ListDeviceInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your device instances.
	DeviceInstances []*DeviceInstance `locationName:"deviceInstances" type:"list"`

	// An identifier that can be used in the next call to this operation to return
	// the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceInstancesOutput) GoString() string {
	return s.String()
}

// SetDeviceInstances sets the DeviceInstances field's value.
func (s *ListDeviceInstancesOutput) SetDeviceInstances(v []*DeviceInstance) *ListDeviceInstancesOutput {
	s.DeviceInstances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceInstancesOutput) SetNextToken(v string) *ListDeviceInstancesOutput {
	s.NextToken = &v
	return s
}

// Represents the result of a list device pools request.
type ListDevicePoolsInput struct {
	_ struct{} `type:"structure"`

	// The project ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The device pools' type.
	//
	// Allowed values include:
	//
	//    * CURATED: A device pool that is created and managed by AWS Device Farm.
	//
	//    * PRIVATE: A device pool that is created and managed by the device pool
	//    developer.
	Type *string `locationName:"type" type:"string" enum:"DevicePoolType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicePoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicePoolsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListDevicePoolsInput) SetArn(v string) *ListDevicePoolsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicePoolsInput) SetNextToken(v string) *ListDevicePoolsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListDevicePoolsInput) SetType(v string) *ListDevicePoolsInput {
	s.Type = &v
	return s
}

// Represents the result of a list device pools request.
type ListDevicePoolsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the device pools.
	DevicePools []*DevicePool `locationName:"devicePools" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicePoolsOutput) GoString() string {
	return s.String()
}

// SetDevicePools sets the DevicePools field's value.
func (s *ListDevicePoolsOutput) SetDevicePools(v []*DevicePool) *ListDevicePoolsOutput {
	s.DevicePools = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicePoolsOutput) SetNextToken(v string) *ListDevicePoolsOutput {
	s.NextToken = &v
	return s
}

// Represents the result of a list devices request.
type ListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// Used to select a set of devices. A filter is made up of an attribute, an
	// operator, and one or more values.
	//
	//    * Attribute: The aspect of a device such as platform or model used as
	//    the selection criteria in a device filter. Allowed values include: ARN:
	//    The Amazon Resource Name (ARN) of the device (for example, arn:aws:devicefarm:us-west-2::device:12345Example).
	//    PLATFORM: The device platform. Valid values are ANDROID or IOS. OS_VERSION:
	//    The operating system version (for example, 10.3.2). MODEL: The device
	//    model (for example, iPad 5th Gen). AVAILABILITY: The current availability
	//    of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
	//    TEMPORARY_NOT_AVAILABLE. FORM_FACTOR: The device form factor. Valid values
	//    are PHONE or TABLET. MANUFACTURER: The device manufacturer (for example,
	//    Apple). REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote
	//    access. Valid values are TRUE or FALSE. REMOTE_DEBUG_ENABLED: Whether
	//    the device is enabled for remote debugging. Valid values are TRUE or FALSE.
	//    Because remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html),
	//    this attribute is ignored. INSTANCE_ARN: The Amazon Resource Name (ARN)
	//    of the device instance. INSTANCE_LABELS: The label of the device instance.
	//    FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	//    * Operator: The filter operator. The EQUALS operator is available for
	//    every attribute except INSTANCE_LABELS. The CONTAINS operator is available
	//    for the INSTANCE_LABELS and MODEL attributes. The IN and NOT_IN operators
	//    are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN
	//    attributes. The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS
	//    operators are also available for the OS_VERSION attribute.
	//
	//    * Values: An array of one or more filter values. The IN and NOT_IN operators
	//    take a values array that has one or more elements. The other operators
	//    require an array with a single element. In a request, the AVAILABILITY
	//    attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY,
	//    or TEMPORARY_NOT_AVAILABLE.
	Filters []*DeviceFilter `locationName:"filters" type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListDevicesInput) SetArn(v string) *ListDevicesInput {
	s.Arn = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListDevicesInput) SetFilters(v []*DeviceFilter) *ListDevicesInput {
	s.Filters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesInput) SetNextToken(v string) *ListDevicesInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list devices operation.
type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the devices.
	Devices []*Device `locationName:"devices" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *ListDevicesOutput) SetDevices(v []*Device) *ListDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesOutput) SetNextToken(v string) *ListDevicesOutput {
	s.NextToken = &v
	return s
}

type ListInstanceProfilesInput struct {
	_ struct{} `type:"structure"`

	// An integer that specifies the maximum number of items you want to return
	// in the API response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstanceProfilesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInstanceProfilesInput) SetMaxResults(v int64) *ListInstanceProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstanceProfilesInput) SetNextToken(v string) *ListInstanceProfilesInput {
	s.NextToken = &v
	return s
}

type ListInstanceProfilesOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your instance profiles.
	InstanceProfiles []*InstanceProfile `locationName:"instanceProfiles" type:"list"`

	// An identifier that can be used in the next call to this operation to return
	// the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstanceProfilesOutput) GoString() string {
	return s.String()
}

// SetInstanceProfiles sets the InstanceProfiles field's value.
func (s *ListInstanceProfilesOutput) SetInstanceProfiles(v []*InstanceProfile) *ListInstanceProfilesOutput {
	s.InstanceProfiles = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstanceProfilesOutput) SetNextToken(v string) *ListInstanceProfilesOutput {
	s.NextToken = &v
	return s
}

// Represents a request to the list jobs operation.
type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// The run's Amazon Resource Name (ARN).
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListJobsInput) SetArn(v string) *ListJobsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list jobs request.
type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the jobs.
	Jobs []*Job `locationName:"jobs" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsOutput) SetJobs(v []*Job) *ListJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

type ListNetworkProfilesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project for which you want to list
	// network profiles.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The type of network profile to return information about. Valid values are
	// listed here.
	Type *string `locationName:"type" type:"string" enum:"NetworkProfileType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNetworkProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNetworkProfilesInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListNetworkProfilesInput) SetArn(v string) *ListNetworkProfilesInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNetworkProfilesInput) SetNextToken(v string) *ListNetworkProfilesInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListNetworkProfilesInput) SetType(v string) *ListNetworkProfilesInput {
	s.Type = &v
	return s
}

type ListNetworkProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the available network profiles.
	NetworkProfiles []*NetworkProfile `locationName:"networkProfiles" type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNetworkProfilesOutput) GoString() string {
	return s.String()
}

// SetNetworkProfiles sets the NetworkProfiles field's value.
func (s *ListNetworkProfilesOutput) SetNetworkProfiles(v []*NetworkProfile) *ListNetworkProfilesOutput {
	s.NetworkProfiles = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNetworkProfilesOutput) SetNextToken(v string) *ListNetworkProfilesOutput {
	s.NextToken = &v
	return s
}

type ListOfferingPromotionsInput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingPromotionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingPromotionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOfferingPromotionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOfferingPromotionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingPromotionsInput) SetNextToken(v string) *ListOfferingPromotionsInput {
	s.NextToken = &v
	return s
}

type ListOfferingPromotionsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier to be used in the next call to this operation, to return the
	// next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the offering promotions.
	OfferingPromotions []*OfferingPromotion `locationName:"offeringPromotions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingPromotionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingPromotionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingPromotionsOutput) SetNextToken(v string) *ListOfferingPromotionsOutput {
	s.NextToken = &v
	return s
}

// SetOfferingPromotions sets the OfferingPromotions field's value.
func (s *ListOfferingPromotionsOutput) SetOfferingPromotions(v []*OfferingPromotion) *ListOfferingPromotionsOutput {
	s.OfferingPromotions = v
	return s
}

// Represents the request to list the offering transaction history.
type ListOfferingTransactionsInput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingTransactionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingTransactionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOfferingTransactionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOfferingTransactionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingTransactionsInput) SetNextToken(v string) *ListOfferingTransactionsInput {
	s.NextToken = &v
	return s
}

// Returns the transaction log of the specified offerings.
type ListOfferingTransactionsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The audit log of subscriptions you have purchased and modified through AWS
	// Device Farm.
	OfferingTransactions []*OfferingTransaction `locationName:"offeringTransactions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingTransactionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingTransactionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingTransactionsOutput) SetNextToken(v string) *ListOfferingTransactionsOutput {
	s.NextToken = &v
	return s
}

// SetOfferingTransactions sets the OfferingTransactions field's value.
func (s *ListOfferingTransactionsOutput) SetOfferingTransactions(v []*OfferingTransaction) *ListOfferingTransactionsOutput {
	s.OfferingTransactions = v
	return s
}

// Represents the request to list all offerings.
type ListOfferingsInput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOfferingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOfferingsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingsInput) SetNextToken(v string) *ListOfferingsInput {
	s.NextToken = &v
	return s
}

// Represents the return values of the list of offerings.
type ListOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// A value that represents the list offering results.
	Offerings []*Offering `locationName:"offerings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingsOutput) SetNextToken(v string) *ListOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetOfferings sets the Offerings field's value.
func (s *ListOfferingsOutput) SetOfferings(v []*Offering) *ListOfferingsOutput {
	s.Offerings = v
	return s
}

// Represents a request to the list projects operation.
type ListProjectsInput struct {
	_ struct{} `type:"structure"`

	// Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device
	// Farm returns a list of all projects for the AWS account. You can also specify
	// a project ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListProjectsInput) SetArn(v string) *ListProjectsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list projects request.
type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the projects.
	Projects []*Project `locationName:"projects" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*Project) *ListProjectsOutput {
	s.Projects = v
	return s
}

// Represents the request to return information about the remote access session.
type ListRemoteAccessSessionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project about which you are requesting
	// information.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRemoteAccessSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRemoteAccessSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRemoteAccessSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRemoteAccessSessionsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListRemoteAccessSessionsInput) SetArn(v string) *ListRemoteAccessSessionsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRemoteAccessSessionsInput) SetNextToken(v string) *ListRemoteAccessSessionsInput {
	s.NextToken = &v
	return s
}

// Represents the response from the server after AWS Device Farm makes a request
// to return information about the remote access session.
type ListRemoteAccessSessionsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// A container that represents the metadata from the service about each remote
	// access session you are requesting.
	RemoteAccessSessions []*RemoteAccessSession `locationName:"remoteAccessSessions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRemoteAccessSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRemoteAccessSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRemoteAccessSessionsOutput) SetNextToken(v string) *ListRemoteAccessSessionsOutput {
	s.NextToken = &v
	return s
}

// SetRemoteAccessSessions sets the RemoteAccessSessions field's value.
func (s *ListRemoteAccessSessionsOutput) SetRemoteAccessSessions(v []*RemoteAccessSession) *ListRemoteAccessSessionsOutput {
	s.RemoteAccessSessions = v
	return s
}

// Represents a request to the list runs operation.
type ListRunsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project for which you want to list
	// runs.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRunsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListRunsInput) SetArn(v string) *ListRunsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRunsInput) SetNextToken(v string) *ListRunsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list runs request.
type ListRunsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the runs.
	Runs []*Run `locationName:"runs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRunsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRunsOutput) SetNextToken(v string) *ListRunsOutput {
	s.NextToken = &v
	return s
}

// SetRuns sets the Runs field's value.
func (s *ListRunsOutput) SetRuns(v []*Run) *ListRunsOutput {
	s.Runs = v
	return s
}

// Represents a request to the list samples operation.
type ListSamplesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the job used to list samples.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSamplesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSamplesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSamplesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSamplesInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListSamplesInput) SetArn(v string) *ListSamplesInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSamplesInput) SetNextToken(v string) *ListSamplesInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list samples request.
type ListSamplesOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the samples.
	Samples []*Sample `locationName:"samples" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSamplesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSamplesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSamplesOutput) SetNextToken(v string) *ListSamplesOutput {
	s.NextToken = &v
	return s
}

// SetSamples sets the Samples field's value.
func (s *ListSamplesOutput) SetSamples(v []*Sample) *ListSamplesOutput {
	s.Samples = v
	return s
}

// Represents a request to the list suites operation.
type ListSuitesInput struct {
	_ struct{} `type:"structure"`

	// The job's Amazon Resource Name (ARN).
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuitesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSuitesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSuitesInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListSuitesInput) SetArn(v string) *ListSuitesInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuitesInput) SetNextToken(v string) *ListSuitesInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list suites request.
type ListSuitesOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the suites.
	Suites []*Suite `locationName:"suites" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuitesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuitesOutput) SetNextToken(v string) *ListSuitesOutput {
	s.NextToken = &v
	return s
}

// SetSuites sets the Suites field's value.
func (s *ListSuitesOutput) SetSuites(v []*Suite) *ListSuitesOutput {
	s.Suites = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource or resources for which to
	// list tags. You can associate tags with the following Device Farm resources:
	// PROJECT, RUN, NETWORK_PROFILE, INSTANCE_PROFILE, DEVICE_INSTANCE, SESSION,
	// DEVICE_POOL, DEVICE, and VPCE_CONFIGURATION.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags to add to the resource. A tag is an array of key-value pairs. Tag
	// keys can have a maximum character length of 128 characters. Tag values can
	// have a maximum length of 256 characters.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTestGridProjectsInput struct {
	_ struct{} `type:"structure"`

	// Return no more than this number of results.
	MaxResult *int64 `locationName:"maxResult" min:"1" type:"integer"`

	// From a response, used to continue a paginated listing.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestGridProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestGridProjectsInput"}
	if s.MaxResult != nil && *s.MaxResult < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResult", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResult sets the MaxResult field's value.
func (s *ListTestGridProjectsInput) SetMaxResult(v int64) *ListTestGridProjectsInput {
	s.MaxResult = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestGridProjectsInput) SetNextToken(v string) *ListTestGridProjectsInput {
	s.NextToken = &v
	return s
}

type ListTestGridProjectsOutput struct {
	_ struct{} `type:"structure"`

	// Used for pagination. Pass into ListTestGridProjects to get more results in
	// a paginated request.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The list of TestGridProjects, based on a ListTestGridProjectsRequest.
	TestGridProjects []*TestGridProject `locationName:"testGridProjects" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestGridProjectsOutput) SetNextToken(v string) *ListTestGridProjectsOutput {
	s.NextToken = &v
	return s
}

// SetTestGridProjects sets the TestGridProjects field's value.
func (s *ListTestGridProjectsOutput) SetTestGridProjects(v []*TestGridProject) *ListTestGridProjectsOutput {
	s.TestGridProjects = v
	return s
}

type ListTestGridSessionActionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of sessions to return per response.
	MaxResult *int64 `locationName:"maxResult" min:"1" type:"integer"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The ARN of the session to retrieve.
	//
	// SessionArn is a required field
	SessionArn *string `locationName:"sessionArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestGridSessionActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestGridSessionActionsInput"}
	if s.MaxResult != nil && *s.MaxResult < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResult", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}
	if s.SessionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionArn"))
	}
	if s.SessionArn != nil && len(*s.SessionArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("SessionArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResult sets the MaxResult field's value.
func (s *ListTestGridSessionActionsInput) SetMaxResult(v int64) *ListTestGridSessionActionsInput {
	s.MaxResult = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestGridSessionActionsInput) SetNextToken(v string) *ListTestGridSessionActionsInput {
	s.NextToken = &v
	return s
}

// SetSessionArn sets the SessionArn field's value.
func (s *ListTestGridSessionActionsInput) SetSessionArn(v string) *ListTestGridSessionActionsInput {
	s.SessionArn = &v
	return s
}

type ListTestGridSessionActionsOutput struct {
	_ struct{} `type:"structure"`

	// The action taken by the session.
	Actions []*TestGridSessionAction `locationName:"actions" type:"list"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionActionsOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *ListTestGridSessionActionsOutput) SetActions(v []*TestGridSessionAction) *ListTestGridSessionActionsOutput {
	s.Actions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestGridSessionActionsOutput) SetNextToken(v string) *ListTestGridSessionActionsOutput {
	s.NextToken = &v
	return s
}

type ListTestGridSessionArtifactsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned by a request.
	MaxResult *int64 `locationName:"maxResult" min:"1" type:"integer"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The ARN of a TestGridSession.
	//
	// SessionArn is a required field
	SessionArn *string `locationName:"sessionArn" min:"32" type:"string" required:"true"`

	// Limit results to a specified type of artifact.
	Type *string `locationName:"type" type:"string" enum:"TestGridSessionArtifactCategory"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionArtifactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionArtifactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestGridSessionArtifactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestGridSessionArtifactsInput"}
	if s.MaxResult != nil && *s.MaxResult < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResult", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}
	if s.SessionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionArn"))
	}
	if s.SessionArn != nil && len(*s.SessionArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("SessionArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResult sets the MaxResult field's value.
func (s *ListTestGridSessionArtifactsInput) SetMaxResult(v int64) *ListTestGridSessionArtifactsInput {
	s.MaxResult = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestGridSessionArtifactsInput) SetNextToken(v string) *ListTestGridSessionArtifactsInput {
	s.NextToken = &v
	return s
}

// SetSessionArn sets the SessionArn field's value.
func (s *ListTestGridSessionArtifactsInput) SetSessionArn(v string) *ListTestGridSessionArtifactsInput {
	s.SessionArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListTestGridSessionArtifactsInput) SetType(v string) *ListTestGridSessionArtifactsInput {
	s.Type = &v
	return s
}

type ListTestGridSessionArtifactsOutput struct {
	_ struct{} `type:"structure"`

	// A list of test grid session artifacts for a TestGridSession.
	Artifacts []*TestGridSessionArtifact `locationName:"artifacts" type:"list"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionArtifactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionArtifactsOutput) GoString() string {
	return s.String()
}

// SetArtifacts sets the Artifacts field's value.
func (s *ListTestGridSessionArtifactsOutput) SetArtifacts(v []*TestGridSessionArtifact) *ListTestGridSessionArtifactsOutput {
	s.Artifacts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestGridSessionArtifactsOutput) SetNextToken(v string) *ListTestGridSessionArtifactsOutput {
	s.NextToken = &v
	return s
}

type ListTestGridSessionsInput struct {
	_ struct{} `type:"structure"`

	// Return only sessions created after this time.
	CreationTimeAfter *time.Time `locationName:"creationTimeAfter" type:"timestamp"`

	// Return only sessions created before this time.
	CreationTimeBefore *time.Time `locationName:"creationTimeBefore" type:"timestamp"`

	// Return only sessions that ended after this time.
	EndTimeAfter *time.Time `locationName:"endTimeAfter" type:"timestamp"`

	// Return only sessions that ended before this time.
	EndTimeBefore *time.Time `locationName:"endTimeBefore" type:"timestamp"`

	// Return only this many results at a time.
	MaxResult *int64 `locationName:"maxResult" min:"1" type:"integer"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// ARN of a TestGridProject.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// Return only sessions in this state.
	Status *string `locationName:"status" type:"string" enum:"TestGridSessionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestGridSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestGridSessionsInput"}
	if s.MaxResult != nil && *s.MaxResult < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResult", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListTestGridSessionsInput) SetCreationTimeAfter(v time.Time) *ListTestGridSessionsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListTestGridSessionsInput) SetCreationTimeBefore(v time.Time) *ListTestGridSessionsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetEndTimeAfter sets the EndTimeAfter field's value.
func (s *ListTestGridSessionsInput) SetEndTimeAfter(v time.Time) *ListTestGridSessionsInput {
	s.EndTimeAfter = &v
	return s
}

// SetEndTimeBefore sets the EndTimeBefore field's value.
func (s *ListTestGridSessionsInput) SetEndTimeBefore(v time.Time) *ListTestGridSessionsInput {
	s.EndTimeBefore = &v
	return s
}

// SetMaxResult sets the MaxResult field's value.
func (s *ListTestGridSessionsInput) SetMaxResult(v int64) *ListTestGridSessionsInput {
	s.MaxResult = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestGridSessionsInput) SetNextToken(v string) *ListTestGridSessionsInput {
	s.NextToken = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *ListTestGridSessionsInput) SetProjectArn(v string) *ListTestGridSessionsInput {
	s.ProjectArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTestGridSessionsInput) SetStatus(v string) *ListTestGridSessionsInput {
	s.Status = &v
	return s
}

type ListTestGridSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The sessions that match the criteria in a ListTestGridSessionsRequest.
	TestGridSessions []*TestGridSession `locationName:"testGridSessions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestGridSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestGridSessionsOutput) SetNextToken(v string) *ListTestGridSessionsOutput {
	s.NextToken = &v
	return s
}

// SetTestGridSessions sets the TestGridSessions field's value.
func (s *ListTestGridSessionsOutput) SetTestGridSessions(v []*TestGridSession) *ListTestGridSessionsOutput {
	s.TestGridSessions = v
	return s
}

// Represents a request to the list tests operation.
type ListTestsInput struct {
	_ struct{} `type:"structure"`

	// The test suite's Amazon Resource Name (ARN).
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTestsInput) SetArn(v string) *ListTestsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestsInput) SetNextToken(v string) *ListTestsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list tests request.
type ListTestsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the tests.
	Tests []*Test `locationName:"tests" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestsOutput) SetNextToken(v string) *ListTestsOutput {
	s.NextToken = &v
	return s
}

// SetTests sets the Tests field's value.
func (s *ListTestsOutput) SetTests(v []*Test) *ListTestsOutput {
	s.Tests = v
	return s
}

// Represents a request to the list unique problems operation.
type ListUniqueProblemsInput struct {
	_ struct{} `type:"structure"`

	// The unique problems' ARNs.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUniqueProblemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUniqueProblemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUniqueProblemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUniqueProblemsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListUniqueProblemsInput) SetArn(v string) *ListUniqueProblemsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUniqueProblemsInput) SetNextToken(v string) *ListUniqueProblemsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list unique problems request.
type ListUniqueProblemsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the unique problems.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	UniqueProblems map[string][]*UniqueProblem `locationName:"uniqueProblems" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUniqueProblemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUniqueProblemsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUniqueProblemsOutput) SetNextToken(v string) *ListUniqueProblemsOutput {
	s.NextToken = &v
	return s
}

// SetUniqueProblems sets the UniqueProblems field's value.
func (s *ListUniqueProblemsOutput) SetUniqueProblems(v map[string][]*UniqueProblem) *ListUniqueProblemsOutput {
	s.UniqueProblems = v
	return s
}

// Represents a request to the list uploads operation.
type ListUploadsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project for which you want to list
	// uploads.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The type of upload.
	//
	// Must be one of the following values:
	//
	//    * ANDROID_APP
	//
	//    * IOS_APP
	//
	//    * WEB_APP
	//
	//    * EXTERNAL_DATA
	//
	//    * APPIUM_JAVA_JUNIT_TEST_PACKAGE
	//
	//    * APPIUM_JAVA_TESTNG_TEST_PACKAGE
	//
	//    * APPIUM_PYTHON_TEST_PACKAGE
	//
	//    * APPIUM_NODE_TEST_PACKAGE
	//
	//    * APPIUM_RUBY_TEST_PACKAGE
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE
	//
	//    * APPIUM_WEB_PYTHON_TEST_PACKAGE
	//
	//    * APPIUM_WEB_NODE_TEST_PACKAGE
	//
	//    * APPIUM_WEB_RUBY_TEST_PACKAGE
	//
	//    * CALABASH_TEST_PACKAGE
	//
	//    * INSTRUMENTATION_TEST_PACKAGE
	//
	//    * UIAUTOMATION_TEST_PACKAGE
	//
	//    * UIAUTOMATOR_TEST_PACKAGE
	//
	//    * XCTEST_TEST_PACKAGE
	//
	//    * XCTEST_UI_TEST_PACKAGE
	//
	//    * APPIUM_JAVA_JUNIT_TEST_SPEC
	//
	//    * APPIUM_JAVA_TESTNG_TEST_SPEC
	//
	//    * APPIUM_PYTHON_TEST_SPEC
	//
	//    * APPIUM_NODE_TEST_SPEC
	//
	//    * APPIUM_RUBY_TEST_SPEC
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC
	//
	//    * APPIUM_WEB_PYTHON_TEST_SPEC
	//
	//    * APPIUM_WEB_NODE_TEST_SPEC
	//
	//    * APPIUM_WEB_RUBY_TEST_SPEC
	//
	//    * INSTRUMENTATION_TEST_SPEC
	//
	//    * XCTEST_UI_TEST_SPEC
	Type *string `locationName:"type" type:"string" enum:"UploadType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUploadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUploadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUploadsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListUploadsInput) SetArn(v string) *ListUploadsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUploadsInput) SetNextToken(v string) *ListUploadsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListUploadsInput) SetType(v string) *ListUploadsInput {
	s.Type = &v
	return s
}

// Represents the result of a list uploads request.
type ListUploadsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the uploads.
	Uploads []*Upload `locationName:"uploads" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUploadsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUploadsOutput) SetNextToken(v string) *ListUploadsOutput {
	s.NextToken = &v
	return s
}

// SetUploads sets the Uploads field's value.
func (s *ListUploadsOutput) SetUploads(v []*Upload) *ListUploadsOutput {
	s.Uploads = v
	return s
}

type ListVPCEConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// An integer that specifies the maximum number of items you want to return
	// in the API response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVPCEConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVPCEConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVPCEConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVPCEConfigurationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVPCEConfigurationsInput) SetMaxResults(v int64) *ListVPCEConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVPCEConfigurationsInput) SetNextToken(v string) *ListVPCEConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListVPCEConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// An array of VPCEConfiguration objects that contain information about your
	// VPC endpoint configuration.
	VpceConfigurations []*VPCEConfiguration `locationName:"vpceConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVPCEConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVPCEConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVPCEConfigurationsOutput) SetNextToken(v string) *ListVPCEConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetVpceConfigurations sets the VpceConfigurations field's value.
func (s *ListVPCEConfigurationsOutput) SetVpceConfigurations(v []*VPCEConfiguration) *ListVPCEConfigurationsOutput {
	s.VpceConfigurations = v
	return s
}

// Represents a latitude and longitude pair, expressed in geographic coordinate
// system degrees (for example, 47.6204, -122.3491).
//
// Elevation is currently not supported.
type Location struct {
	_ struct{} `type:"structure"`

	// The latitude.
	//
	// Latitude is a required field
	Latitude *float64 `locationName:"latitude" type:"double" required:"true"`

	// The longitude.
	//
	// Longitude is a required field
	Longitude *float64 `locationName:"longitude" type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Location"}
	if s.Latitude == nil {
		invalidParams.Add(request.NewErrParamRequired("Latitude"))
	}
	if s.Longitude == nil {
		invalidParams.Add(request.NewErrParamRequired("Longitude"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatitude sets the Latitude field's value.
func (s *Location) SetLatitude(v float64) *Location {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *Location) SetLongitude(v float64) *Location {
	s.Longitude = &v
	return s
}

// A number that represents the monetary amount for an offering or transaction.
type MonetaryAmount struct {
	_ struct{} `type:"structure"`

	// The numerical amount of an offering or transaction.
	Amount *float64 `locationName:"amount" type:"double"`

	// The currency code of a monetary amount. For example, USD means U.S. dollars.
	CurrencyCode *string `locationName:"currencyCode" type:"string" enum:"CurrencyCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonetaryAmount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonetaryAmount) GoString() string {
	return s.String()
}

// SetAmount sets the Amount field's value.
func (s *MonetaryAmount) SetAmount(v float64) *MonetaryAmount {
	s.Amount = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *MonetaryAmount) SetCurrencyCode(v string) *MonetaryAmount {
	s.CurrencyCode = &v
	return s
}

// An array of settings that describes characteristics of a network profile.
type NetworkProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the network profile.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The description of the network profile.
	Description *string `locationName:"description" type:"string"`

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	DownlinkBandwidthBits *int64 `locationName:"downlinkBandwidthBits" type:"long"`

	// Delay time for all packets to destination in milliseconds as an integer from
	// 0 to 2000.
	DownlinkDelayMs *int64 `locationName:"downlinkDelayMs" type:"long"`

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	DownlinkJitterMs *int64 `locationName:"downlinkJitterMs" type:"long"`

	// Proportion of received packets that fail to arrive from 0 to 100 percent.
	DownlinkLossPercent *int64 `locationName:"downlinkLossPercent" type:"integer"`

	// The name of the network profile.
	Name *string `locationName:"name" type:"string"`

	// The type of network profile. Valid values are listed here.
	Type *string `locationName:"type" type:"string" enum:"NetworkProfileType"`

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	UplinkBandwidthBits *int64 `locationName:"uplinkBandwidthBits" type:"long"`

	// Delay time for all packets to destination in milliseconds as an integer from
	// 0 to 2000.
	UplinkDelayMs *int64 `locationName:"uplinkDelayMs" type:"long"`

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	UplinkJitterMs *int64 `locationName:"uplinkJitterMs" type:"long"`

	// Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
	UplinkLossPercent *int64 `locationName:"uplinkLossPercent" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkProfile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *NetworkProfile) SetArn(v string) *NetworkProfile {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NetworkProfile) SetDescription(v string) *NetworkProfile {
	s.Description = &v
	return s
}

// SetDownlinkBandwidthBits sets the DownlinkBandwidthBits field's value.
func (s *NetworkProfile) SetDownlinkBandwidthBits(v int64) *NetworkProfile {
	s.DownlinkBandwidthBits = &v
	return s
}

// SetDownlinkDelayMs sets the DownlinkDelayMs field's value.
func (s *NetworkProfile) SetDownlinkDelayMs(v int64) *NetworkProfile {
	s.DownlinkDelayMs = &v
	return s
}

// SetDownlinkJitterMs sets the DownlinkJitterMs field's value.
func (s *NetworkProfile) SetDownlinkJitterMs(v int64) *NetworkProfile {
	s.DownlinkJitterMs = &v
	return s
}

// SetDownlinkLossPercent sets the DownlinkLossPercent field's value.
func (s *NetworkProfile) SetDownlinkLossPercent(v int64) *NetworkProfile {
	s.DownlinkLossPercent = &v
	return s
}

// SetName sets the Name field's value.
func (s *NetworkProfile) SetName(v string) *NetworkProfile {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *NetworkProfile) SetType(v string) *NetworkProfile {
	s.Type = &v
	return s
}

// SetUplinkBandwidthBits sets the UplinkBandwidthBits field's value.
func (s *NetworkProfile) SetUplinkBandwidthBits(v int64) *NetworkProfile {
	s.UplinkBandwidthBits = &v
	return s
}

// SetUplinkDelayMs sets the UplinkDelayMs field's value.
func (s *NetworkProfile) SetUplinkDelayMs(v int64) *NetworkProfile {
	s.UplinkDelayMs = &v
	return s
}

// SetUplinkJitterMs sets the UplinkJitterMs field's value.
func (s *NetworkProfile) SetUplinkJitterMs(v int64) *NetworkProfile {
	s.UplinkJitterMs = &v
	return s
}

// SetUplinkLossPercent sets the UplinkLossPercent field's value.
func (s *NetworkProfile) SetUplinkLossPercent(v int64) *NetworkProfile {
	s.UplinkLossPercent = &v
	return s
}

// Exception gets thrown when a user is not eligible to perform the specified
// transaction.
type NotEligibleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The HTTP response code of a Not Eligible exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotEligibleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotEligibleException) GoString() string {
	return s.String()
}

func newErrorNotEligibleException(v protocol.ResponseMetadata) error {
	return &NotEligibleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotEligibleException) Code() string {
	return "NotEligibleException"
}

// Message returns the exception's message.
func (s *NotEligibleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotEligibleException) OrigErr() error {
	return nil
}

func (s *NotEligibleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotEligibleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotEligibleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified entity was not found.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Any additional information about the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the metadata of a device offering.
type Offering struct {
	_ struct{} `type:"structure"`

	// A string that describes the offering.
	Description *string `locationName:"description" type:"string"`

	// The ID that corresponds to a device offering.
	Id *string `locationName:"id" min:"32" type:"string"`

	// The platform of the device (for example, ANDROID or IOS).
	Platform *string `locationName:"platform" type:"string" enum:"DevicePlatform"`

	// Specifies whether there are recurring charges for the offering.
	RecurringCharges []*RecurringCharge `locationName:"recurringCharges" type:"list"`

	// The type of offering (for example, RECURRING) for a device.
	Type *string `locationName:"type" type:"string" enum:"OfferingType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Offering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Offering) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Offering) SetDescription(v string) *Offering {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Offering) SetId(v string) *Offering {
	s.Id = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Offering) SetPlatform(v string) *Offering {
	s.Platform = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *Offering) SetRecurringCharges(v []*RecurringCharge) *Offering {
	s.RecurringCharges = v
	return s
}

// SetType sets the Type field's value.
func (s *Offering) SetType(v string) *Offering {
	s.Type = &v
	return s
}

// Represents information about an offering promotion.
type OfferingPromotion struct {
	_ struct{} `type:"structure"`

	// A string that describes the offering promotion.
	Description *string `locationName:"description" type:"string"`

	// The ID of the offering promotion.
	Id *string `locationName:"id" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferingPromotion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferingPromotion) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *OfferingPromotion) SetDescription(v string) *OfferingPromotion {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *OfferingPromotion) SetId(v string) *OfferingPromotion {
	s.Id = &v
	return s
}

// The status of the offering.
type OfferingStatus struct {
	_ struct{} `type:"structure"`

	// The date on which the offering is effective.
	EffectiveOn *time.Time `locationName:"effectiveOn" type:"timestamp"`

	// Represents the metadata of an offering status.
	Offering *Offering `locationName:"offering" type:"structure"`

	// The number of available devices in the offering.
	Quantity *int64 `locationName:"quantity" type:"integer"`

	// The type specified for the offering status.
	Type *string `locationName:"type" type:"string" enum:"OfferingTransactionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferingStatus) GoString() string {
	return s.String()
}

// SetEffectiveOn sets the EffectiveOn field's value.
func (s *OfferingStatus) SetEffectiveOn(v time.Time) *OfferingStatus {
	s.EffectiveOn = &v
	return s
}

// SetOffering sets the Offering field's value.
func (s *OfferingStatus) SetOffering(v *Offering) *OfferingStatus {
	s.Offering = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OfferingStatus) SetQuantity(v int64) *OfferingStatus {
	s.Quantity = &v
	return s
}

// SetType sets the Type field's value.
func (s *OfferingStatus) SetType(v string) *OfferingStatus {
	s.Type = &v
	return s
}

// Represents the metadata of an offering transaction.
type OfferingTransaction struct {
	_ struct{} `type:"structure"`

	// The cost of an offering transaction.
	Cost *MonetaryAmount `locationName:"cost" type:"structure"`

	// The date on which an offering transaction was created.
	CreatedOn *time.Time `locationName:"createdOn" type:"timestamp"`

	// The ID that corresponds to a device offering promotion.
	OfferingPromotionId *string `locationName:"offeringPromotionId" min:"4" type:"string"`

	// The status of an offering transaction.
	OfferingStatus *OfferingStatus `locationName:"offeringStatus" type:"structure"`

	// The transaction ID of the offering transaction.
	TransactionId *string `locationName:"transactionId" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferingTransaction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferingTransaction) GoString() string {
	return s.String()
}

// SetCost sets the Cost field's value.
func (s *OfferingTransaction) SetCost(v *MonetaryAmount) *OfferingTransaction {
	s.Cost = v
	return s
}

// SetCreatedOn sets the CreatedOn field's value.
func (s *OfferingTransaction) SetCreatedOn(v time.Time) *OfferingTransaction {
	s.CreatedOn = &v
	return s
}

// SetOfferingPromotionId sets the OfferingPromotionId field's value.
func (s *OfferingTransaction) SetOfferingPromotionId(v string) *OfferingTransaction {
	s.OfferingPromotionId = &v
	return s
}

// SetOfferingStatus sets the OfferingStatus field's value.
func (s *OfferingTransaction) SetOfferingStatus(v *OfferingStatus) *OfferingTransaction {
	s.OfferingStatus = v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *OfferingTransaction) SetTransactionId(v string) *OfferingTransaction {
	s.TransactionId = &v
	return s
}

// Represents a specific warning or failure.
type Problem struct {
	_ struct{} `type:"structure"`

	// Information about the associated device.
	Device *Device `locationName:"device" type:"structure"`

	// Information about the associated job.
	Job *ProblemDetail `locationName:"job" type:"structure"`

	// A message about the problem's result.
	Message *string `locationName:"message" type:"string"`

	// The problem's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// Information about the associated run.
	Run *ProblemDetail `locationName:"run" type:"structure"`

	// Information about the associated suite.
	Suite *ProblemDetail `locationName:"suite" type:"structure"`

	// Information about the associated test.
	Test *ProblemDetail `locationName:"test" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Problem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Problem) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *Problem) SetDevice(v *Device) *Problem {
	s.Device = v
	return s
}

// SetJob sets the Job field's value.
func (s *Problem) SetJob(v *ProblemDetail) *Problem {
	s.Job = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Problem) SetMessage(v string) *Problem {
	s.Message = &v
	return s
}

// SetResult sets the Result field's value.
func (s *Problem) SetResult(v string) *Problem {
	s.Result = &v
	return s
}

// SetRun sets the Run field's value.
func (s *Problem) SetRun(v *ProblemDetail) *Problem {
	s.Run = v
	return s
}

// SetSuite sets the Suite field's value.
func (s *Problem) SetSuite(v *ProblemDetail) *Problem {
	s.Suite = v
	return s
}

// SetTest sets the Test field's value.
func (s *Problem) SetTest(v *ProblemDetail) *Problem {
	s.Test = v
	return s
}

// Information about a problem detail.
type ProblemDetail struct {
	_ struct{} `type:"structure"`

	// The problem detail's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The problem detail's name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProblemDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProblemDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ProblemDetail) SetArn(v string) *ProblemDetail {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProblemDetail) SetName(v string) *ProblemDetail {
	s.Name = &v
	return s
}

// Represents an operating-system neutral workspace for running and managing
// tests.
type Project struct {
	_ struct{} `type:"structure"`

	// The project's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// When the project was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The default number of minutes (at the project level) a test run executes
	// before it times out. The default value is 150 minutes.
	DefaultJobTimeoutMinutes *int64 `locationName:"defaultJobTimeoutMinutes" type:"integer"`

	// The project's name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Project) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Project) SetArn(v string) *Project {
	s.Arn = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *Project) SetCreated(v time.Time) *Project {
	s.Created = &v
	return s
}

// SetDefaultJobTimeoutMinutes sets the DefaultJobTimeoutMinutes field's value.
func (s *Project) SetDefaultJobTimeoutMinutes(v int64) *Project {
	s.DefaultJobTimeoutMinutes = &v
	return s
}

// SetName sets the Name field's value.
func (s *Project) SetName(v string) *Project {
	s.Name = &v
	return s
}

// Represents a request for a purchase offering.
type PurchaseOfferingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the offering.
	//
	// OfferingId is a required field
	OfferingId *string `locationName:"offeringId" min:"32" type:"string" required:"true"`

	// The ID of the offering promotion to be applied to the purchase.
	OfferingPromotionId *string `locationName:"offeringPromotionId" min:"4" type:"string"`

	// The number of device slots to purchase in an offering request.
	//
	// Quantity is a required field
	Quantity *int64 `locationName:"quantity" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseOfferingInput"}
	if s.OfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("OfferingId"))
	}
	if s.OfferingId != nil && len(*s.OfferingId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingId", 32))
	}
	if s.OfferingPromotionId != nil && len(*s.OfferingPromotionId) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingPromotionId", 4))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOfferingId sets the OfferingId field's value.
func (s *PurchaseOfferingInput) SetOfferingId(v string) *PurchaseOfferingInput {
	s.OfferingId = &v
	return s
}

// SetOfferingPromotionId sets the OfferingPromotionId field's value.
func (s *PurchaseOfferingInput) SetOfferingPromotionId(v string) *PurchaseOfferingInput {
	s.OfferingPromotionId = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *PurchaseOfferingInput) SetQuantity(v int64) *PurchaseOfferingInput {
	s.Quantity = &v
	return s
}

// The result of the purchase offering (for example, success or failure).
type PurchaseOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Represents the offering transaction for the purchase result.
	OfferingTransaction *OfferingTransaction `locationName:"offeringTransaction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseOfferingOutput) GoString() string {
	return s.String()
}

// SetOfferingTransaction sets the OfferingTransaction field's value.
func (s *PurchaseOfferingOutput) SetOfferingTransaction(v *OfferingTransaction) *PurchaseOfferingOutput {
	s.OfferingTransaction = v
	return s
}

// Represents the set of radios and their states on a device. Examples of radios
// include Wi-Fi, GPS, Bluetooth, and NFC.
type Radios struct {
	_ struct{} `type:"structure"`

	// True if Bluetooth is enabled at the beginning of the test. Otherwise, false.
	Bluetooth *bool `locationName:"bluetooth" type:"boolean"`

	// True if GPS is enabled at the beginning of the test. Otherwise, false.
	Gps *bool `locationName:"gps" type:"boolean"`

	// True if NFC is enabled at the beginning of the test. Otherwise, false.
	Nfc *bool `locationName:"nfc" type:"boolean"`

	// True if Wi-Fi is enabled at the beginning of the test. Otherwise, false.
	Wifi *bool `locationName:"wifi" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Radios) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Radios) GoString() string {
	return s.String()
}

// SetBluetooth sets the Bluetooth field's value.
func (s *Radios) SetBluetooth(v bool) *Radios {
	s.Bluetooth = &v
	return s
}

// SetGps sets the Gps field's value.
func (s *Radios) SetGps(v bool) *Radios {
	s.Gps = &v
	return s
}

// SetNfc sets the Nfc field's value.
func (s *Radios) SetNfc(v bool) *Radios {
	s.Nfc = &v
	return s
}

// SetWifi sets the Wifi field's value.
func (s *Radios) SetWifi(v bool) *Radios {
	s.Wifi = &v
	return s
}

// Specifies whether charges for devices are recurring.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The cost of the recurring charge.
	Cost *MonetaryAmount `locationName:"cost" type:"structure"`

	// The frequency in which charges recur.
	Frequency *string `locationName:"frequency" type:"string" enum:"RecurringChargeFrequency"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetCost sets the Cost field's value.
func (s *RecurringCharge) SetCost(v *MonetaryAmount) *RecurringCharge {
	s.Cost = v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *RecurringCharge) SetFrequency(v string) *RecurringCharge {
	s.Frequency = &v
	return s
}

// Represents information about the remote access session.
type RemoteAccessSession struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the remote access session.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The billing method of the remote access session. Possible values include
	// METERED or UNMETERED. For more information about metered devices, see AWS
	// Device Farm terminology (https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology).
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`

	// Unique identifier of your client for the remote access session. Only returned
	// if remote debugging is enabled for the remote access session.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	ClientId *string `locationName:"clientId" type:"string"`

	// The date and time the remote access session was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The device (phone or tablet) used in the remote access session.
	Device *Device `locationName:"device" type:"structure"`

	// The number of minutes a device is used in a remote access session (including
	// setup and teardown minutes).
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// Unique device identifier for the remote device. Only returned if remote debugging
	// is enabled for the remote access session.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	DeviceUdid *string `locationName:"deviceUdid" type:"string"`

	// The endpoint for the remote access sesssion.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// IP address of the EC2 host where you need to connect to remotely debug devices.
	// Only returned if remote debugging is enabled for the remote access session.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	HostAddress *string `locationName:"hostAddress" type:"string"`

	// The ARN of the instance.
	InstanceArn *string `locationName:"instanceArn" min:"32" type:"string"`

	// The interaction mode of the remote access session. Valid values are:
	//
	//    * INTERACTIVE: You can interact with the iOS device by viewing, touching,
	//    and rotating the screen. You cannot run XCUITest framework-based tests
	//    in this mode.
	//
	//    * NO_VIDEO: You are connected to the device, but cannot interact with
	//    it or view the screen. This mode has the fastest test execution speed.
	//    You can run XCUITest framework-based tests in this mode.
	//
	//    * VIDEO_ONLY: You can view the screen, but cannot touch or rotate it.
	//    You can run XCUITest framework-based tests and watch the screen in this
	//    mode.
	InteractionMode *string `locationName:"interactionMode" type:"string" enum:"InteractionMode"`

	// A message about the remote access session.
	Message *string `locationName:"message" type:"string"`

	// The name of the remote access session.
	Name *string `locationName:"name" type:"string"`

	// This flag is set to true if remote debugging is enabled for the remote access
	// session.
	//
	// Remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
	RemoteDebugEnabled *bool `locationName:"remoteDebugEnabled" type:"boolean"`

	// The ARN for the app to be recorded in the remote access session.
	RemoteRecordAppArn *string `locationName:"remoteRecordAppArn" min:"32" type:"string"`

	// This flag is set to true if remote recording is enabled for the remote access
	// session.
	RemoteRecordEnabled *bool `locationName:"remoteRecordEnabled" type:"boolean"`

	// The result of the remote access session. Can be any of the following:
	//
	//    * PENDING.
	//
	//    * PASSED.
	//
	//    * WARNED.
	//
	//    * FAILED.
	//
	//    * SKIPPED.
	//
	//    * ERRORED.
	//
	//    * STOPPED.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// When set to true, for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see Do you
	// modify my app? (https://aws.amazon.com/device-farm/faq/) in the AWS Device
	// Farm FAQs.
	SkipAppResign *bool `locationName:"skipAppResign" type:"boolean"`

	// The date and time the remote access session was started.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The status of the remote access session. Can be any of the following:
	//
	//    * PENDING.
	//
	//    * PENDING_CONCURRENCY.
	//
	//    * PENDING_DEVICE.
	//
	//    * PROCESSING.
	//
	//    * SCHEDULING.
	//
	//    * PREPARING.
	//
	//    * RUNNING.
	//
	//    * COMPLETED.
	//
	//    * STOPPING.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The date and time the remote access session was stopped.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoteAccessSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoteAccessSession) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RemoteAccessSession) SetArn(v string) *RemoteAccessSession {
	s.Arn = &v
	return s
}

// SetBillingMethod sets the BillingMethod field's value.
func (s *RemoteAccessSession) SetBillingMethod(v string) *RemoteAccessSession {
	s.BillingMethod = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *RemoteAccessSession) SetClientId(v string) *RemoteAccessSession {
	s.ClientId = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *RemoteAccessSession) SetCreated(v time.Time) *RemoteAccessSession {
	s.Created = &v
	return s
}

// SetDevice sets the Device field's value.
func (s *RemoteAccessSession) SetDevice(v *Device) *RemoteAccessSession {
	s.Device = v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *RemoteAccessSession) SetDeviceMinutes(v *DeviceMinutes) *RemoteAccessSession {
	s.DeviceMinutes = v
	return s
}

// SetDeviceUdid sets the DeviceUdid field's value.
func (s *RemoteAccessSession) SetDeviceUdid(v string) *RemoteAccessSession {
	s.DeviceUdid = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *RemoteAccessSession) SetEndpoint(v string) *RemoteAccessSession {
	s.Endpoint = &v
	return s
}

// SetHostAddress sets the HostAddress field's value.
func (s *RemoteAccessSession) SetHostAddress(v string) *RemoteAccessSession {
	s.HostAddress = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *RemoteAccessSession) SetInstanceArn(v string) *RemoteAccessSession {
	s.InstanceArn = &v
	return s
}

// SetInteractionMode sets the InteractionMode field's value.
func (s *RemoteAccessSession) SetInteractionMode(v string) *RemoteAccessSession {
	s.InteractionMode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *RemoteAccessSession) SetMessage(v string) *RemoteAccessSession {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *RemoteAccessSession) SetName(v string) *RemoteAccessSession {
	s.Name = &v
	return s
}

// SetRemoteDebugEnabled sets the RemoteDebugEnabled field's value.
func (s *RemoteAccessSession) SetRemoteDebugEnabled(v bool) *RemoteAccessSession {
	s.RemoteDebugEnabled = &v
	return s
}

// SetRemoteRecordAppArn sets the RemoteRecordAppArn field's value.
func (s *RemoteAccessSession) SetRemoteRecordAppArn(v string) *RemoteAccessSession {
	s.RemoteRecordAppArn = &v
	return s
}

// SetRemoteRecordEnabled sets the RemoteRecordEnabled field's value.
func (s *RemoteAccessSession) SetRemoteRecordEnabled(v bool) *RemoteAccessSession {
	s.RemoteRecordEnabled = &v
	return s
}

// SetResult sets the Result field's value.
func (s *RemoteAccessSession) SetResult(v string) *RemoteAccessSession {
	s.Result = &v
	return s
}

// SetSkipAppResign sets the SkipAppResign field's value.
func (s *RemoteAccessSession) SetSkipAppResign(v bool) *RemoteAccessSession {
	s.SkipAppResign = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *RemoteAccessSession) SetStarted(v time.Time) *RemoteAccessSession {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RemoteAccessSession) SetStatus(v string) *RemoteAccessSession {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *RemoteAccessSession) SetStopped(v time.Time) *RemoteAccessSession {
	s.Stopped = &v
	return s
}

// A request that represents an offering renewal.
type RenewOfferingInput struct {
	_ struct{} `type:"structure"`

	// The ID of a request to renew an offering.
	//
	// OfferingId is a required field
	OfferingId *string `locationName:"offeringId" min:"32" type:"string" required:"true"`

	// The quantity requested in an offering renewal.
	//
	// Quantity is a required field
	Quantity *int64 `locationName:"quantity" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenewOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenewOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenewOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RenewOfferingInput"}
	if s.OfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("OfferingId"))
	}
	if s.OfferingId != nil && len(*s.OfferingId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingId", 32))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOfferingId sets the OfferingId field's value.
func (s *RenewOfferingInput) SetOfferingId(v string) *RenewOfferingInput {
	s.OfferingId = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *RenewOfferingInput) SetQuantity(v int64) *RenewOfferingInput {
	s.Quantity = &v
	return s
}

// The result of a renewal offering.
type RenewOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Represents the status of the offering transaction for the renewal.
	OfferingTransaction *OfferingTransaction `locationName:"offeringTransaction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenewOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenewOfferingOutput) GoString() string {
	return s.String()
}

// SetOfferingTransaction sets the OfferingTransaction field's value.
func (s *RenewOfferingOutput) SetOfferingTransaction(v *OfferingTransaction) *RenewOfferingOutput {
	s.OfferingTransaction = v
	return s
}

// Represents the screen resolution of a device in height and width, expressed
// in pixels.
type Resolution struct {
	_ struct{} `type:"structure"`

	// The screen resolution's height, expressed in pixels.
	Height *int64 `locationName:"height" type:"integer"`

	// The screen resolution's width, expressed in pixels.
	Width *int64 `locationName:"width" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resolution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resolution) GoString() string {
	return s.String()
}

// SetHeight sets the Height field's value.
func (s *Resolution) SetHeight(v int64) *Resolution {
	s.Height = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *Resolution) SetWidth(v int64) *Resolution {
	s.Width = &v
	return s
}

// Represents a condition for a device pool.
type Rule struct {
	_ struct{} `type:"structure"`

	// The rule's stringified attribute. For example, specify the value as "\"abc\"".
	//
	// The supported operators for each attribute are provided in the following
	// list.
	//
	// APPIUM_VERSION
	//
	// The Appium version for the test.
	//
	// Supported operators: CONTAINS
	//
	// ARN
	//
	// The Amazon Resource Name (ARN) of the device (for example, arn:aws:devicefarm:us-west-2::device:12345Example.
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// AVAILABILITY
	//
	// The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE,
	// BUSY, or TEMPORARY_NOT_AVAILABLE.
	//
	// Supported operators: EQUALS
	//
	// FLEET_TYPE
	//
	// The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	// Supported operators: EQUALS
	//
	// FORM_FACTOR
	//
	// The device form factor. Valid values are PHONE or TABLET.
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// INSTANCE_ARN
	//
	// The Amazon Resource Name (ARN) of the device instance.
	//
	// Supported operators: IN, NOT_IN
	//
	// INSTANCE_LABELS
	//
	// The label of the device instance.
	//
	// Supported operators: CONTAINS
	//
	// MANUFACTURER
	//
	// The device manufacturer (for example, Apple).
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// MODEL
	//
	// The device model, such as Apple iPad Air 2 or Google Pixel.
	//
	// Supported operators: CONTAINS, EQUALS, IN, NOT_IN
	//
	// OS_VERSION
	//
	// The operating system version (for example, 10.3.2).
	//
	// Supported operators: EQUALS, GREATER_THAN, GREATER_THAN_OR_EQUALS, IN, LESS_THAN,
	// LESS_THAN_OR_EQUALS, NOT_IN
	//
	// PLATFORM
	//
	// The device platform. Valid values are ANDROID or IOS.
	//
	// Supported operators: EQUALS, IN, NOT_IN
	//
	// REMOTE_ACCESS_ENABLED
	//
	// Whether the device is enabled for remote access. Valid values are TRUE or
	// FALSE.
	//
	// Supported operators: EQUALS
	//
	// REMOTE_DEBUG_ENABLED
	//
	// Whether the device is enabled for remote debugging. Valid values are TRUE
	// or FALSE.
	//
	// Supported operators: EQUALS
	//
	// Because remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html),
	// this filter is ignored.
	Attribute *string `locationName:"attribute" type:"string" enum:"DeviceAttribute"`

	// Specifies how Device Farm compares the rule's attribute to the value. For
	// the operators that are supported by each attribute, see the attribute descriptions.
	Operator *string `locationName:"operator" type:"string" enum:"RuleOperator"`

	// The rule's value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *Rule) SetAttribute(v string) *Rule {
	s.Attribute = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *Rule) SetOperator(v string) *Rule {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Rule) SetValue(v string) *Rule {
	s.Value = &v
	return s
}

// Represents a test run on a set of devices with a given app package, test
// parameters, and so on.
type Run struct {
	_ struct{} `type:"structure"`

	// An app to upload or that has been uploaded.
	AppUpload *string `locationName:"appUpload" min:"32" type:"string"`

	// The run's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// Specifies the billing method for a test run: metered or unmetered. If the
	// parameter is not specified, the default value is metered.
	//
	// If you have unmetered device slots, you must set this to unmetered to use
	// them. Otherwise, the run is counted toward metered device minutes.
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`

	// The total number of completed jobs.
	CompletedJobs *int64 `locationName:"completedJobs" type:"integer"`

	// The run's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the run was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// Output CustomerArtifactPaths object for the test run.
	CustomerArtifactPaths *CustomerArtifactPaths `locationName:"customerArtifactPaths" type:"structure"`

	// Represents the total (metered or unmetered) minutes used by the test run.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// The ARN of the device pool for the run.
	DevicePoolArn *string `locationName:"devicePoolArn" min:"32" type:"string"`

	// The results of a device filter used to select the devices for a test run.
	DeviceSelectionResult *DeviceSelectionResult `locationName:"deviceSelectionResult" type:"structure"`

	// For fuzz tests, this is the number of events, between 1 and 10000, that the
	// UI fuzz test should perform.
	EventCount *int64 `locationName:"eventCount" type:"integer"`

	// The number of minutes the job executes before it times out.
	JobTimeoutMinutes *int64 `locationName:"jobTimeoutMinutes" type:"integer"`

	// Information about the locale that is used for the run.
	Locale *string `locationName:"locale" type:"string"`

	// Information about the location that is used for the run.
	Location *Location `locationName:"location" type:"structure"`

	// A message about the run's result.
	Message *string `locationName:"message" type:"string"`

	// The run's name.
	Name *string `locationName:"name" type:"string"`

	// The network profile being used for a test run.
	NetworkProfile *NetworkProfile `locationName:"networkProfile" type:"structure"`

	// Read-only URL for an object in an S3 bucket where you can get the parsing
	// results of the test package. If the test package doesn't parse, the reason
	// why it doesn't parse appears in the file that this URL points to.
	ParsingResultUrl *string `locationName:"parsingResultUrl" type:"string"`

	// The run's platform.
	//
	// Allowed values include:
	//
	//    * ANDROID
	//
	//    * IOS
	Platform *string `locationName:"platform" type:"string" enum:"DevicePlatform"`

	// Information about the radio states for the run.
	Radios *Radios `locationName:"radios" type:"structure"`

	// The run's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// Supporting field for the result field. Set only if result is SKIPPED. PARSING_FAILED
	// if the result is skipped because of test package parsing failure.
	ResultCode *string `locationName:"resultCode" type:"string" enum:"ExecutionResultCode"`

	// For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using
	// the same seed value between tests ensures identical event sequences.
	Seed *int64 `locationName:"seed" type:"integer"`

	// When set to true, for private devices, Device Farm does not sign your app
	// again. For public devices, Device Farm always signs your apps again.
	//
	// For more information about how Device Farm re-signs your apps, see Do you
	// modify my app? (https://aws.amazon.com/device-farm/faq/) in the AWS Device
	// Farm FAQs.
	SkipAppResign *bool `locationName:"skipAppResign" type:"boolean"`

	// The run's start time.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The run's status.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PENDING_CONCURRENCY
	//
	//    * PENDING_DEVICE
	//
	//    * PROCESSING
	//
	//    * SCHEDULING
	//
	//    * PREPARING
	//
	//    * RUNNING
	//
	//    * COMPLETED
	//
	//    * STOPPING
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The run's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`

	// The ARN of the YAML-formatted test specification for the run.
	TestSpecArn *string `locationName:"testSpecArn" min:"32" type:"string"`

	// The total number of jobs for the run.
	TotalJobs *int64 `locationName:"totalJobs" type:"integer"`

	// The run's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER For Android, an app explorer that traverses an Android
	//    app, interacting with it and capturing screenshots at the same time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	Type *string `locationName:"type" type:"string" enum:"TestType"`

	// The Device Farm console URL for the recording of the run.
	WebUrl *string `locationName:"webUrl" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Run) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Run) GoString() string {
	return s.String()
}

// SetAppUpload sets the AppUpload field's value.
func (s *Run) SetAppUpload(v string) *Run {
	s.AppUpload = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Run) SetArn(v string) *Run {
	s.Arn = &v
	return s
}

// SetBillingMethod sets the BillingMethod field's value.
func (s *Run) SetBillingMethod(v string) *Run {
	s.BillingMethod = &v
	return s
}

// SetCompletedJobs sets the CompletedJobs field's value.
func (s *Run) SetCompletedJobs(v int64) *Run {
	s.CompletedJobs = &v
	return s
}

// SetCounters sets the Counters field's value.
func (s *Run) SetCounters(v *Counters) *Run {
	s.Counters = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Run) SetCreated(v time.Time) *Run {
	s.Created = &v
	return s
}

// SetCustomerArtifactPaths sets the CustomerArtifactPaths field's value.
func (s *Run) SetCustomerArtifactPaths(v *CustomerArtifactPaths) *Run {
	s.CustomerArtifactPaths = v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *Run) SetDeviceMinutes(v *DeviceMinutes) *Run {
	s.DeviceMinutes = v
	return s
}

// SetDevicePoolArn sets the DevicePoolArn field's value.
func (s *Run) SetDevicePoolArn(v string) *Run {
	s.DevicePoolArn = &v
	return s
}

// SetDeviceSelectionResult sets the DeviceSelectionResult field's value.
func (s *Run) SetDeviceSelectionResult(v *DeviceSelectionResult) *Run {
	s.DeviceSelectionResult = v
	return s
}

// SetEventCount sets the EventCount field's value.
func (s *Run) SetEventCount(v int64) *Run {
	s.EventCount = &v
	return s
}

// SetJobTimeoutMinutes sets the JobTimeoutMinutes field's value.
func (s *Run) SetJobTimeoutMinutes(v int64) *Run {
	s.JobTimeoutMinutes = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *Run) SetLocale(v string) *Run {
	s.Locale = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Run) SetLocation(v *Location) *Run {
	s.Location = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Run) SetMessage(v string) *Run {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *Run) SetName(v string) *Run {
	s.Name = &v
	return s
}

// SetNetworkProfile sets the NetworkProfile field's value.
func (s *Run) SetNetworkProfile(v *NetworkProfile) *Run {
	s.NetworkProfile = v
	return s
}

// SetParsingResultUrl sets the ParsingResultUrl field's value.
func (s *Run) SetParsingResultUrl(v string) *Run {
	s.ParsingResultUrl = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Run) SetPlatform(v string) *Run {
	s.Platform = &v
	return s
}

// SetRadios sets the Radios field's value.
func (s *Run) SetRadios(v *Radios) *Run {
	s.Radios = v
	return s
}

// SetResult sets the Result field's value.
func (s *Run) SetResult(v string) *Run {
	s.Result = &v
	return s
}

// SetResultCode sets the ResultCode field's value.
func (s *Run) SetResultCode(v string) *Run {
	s.ResultCode = &v
	return s
}

// SetSeed sets the Seed field's value.
func (s *Run) SetSeed(v int64) *Run {
	s.Seed = &v
	return s
}

// SetSkipAppResign sets the SkipAppResign field's value.
func (s *Run) SetSkipAppResign(v bool) *Run {
	s.SkipAppResign = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *Run) SetStarted(v time.Time) *Run {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Run) SetStatus(v string) *Run {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Run) SetStopped(v time.Time) *Run {
	s.Stopped = &v
	return s
}

// SetTestSpecArn sets the TestSpecArn field's value.
func (s *Run) SetTestSpecArn(v string) *Run {
	s.TestSpecArn = &v
	return s
}

// SetTotalJobs sets the TotalJobs field's value.
func (s *Run) SetTotalJobs(v int64) *Run {
	s.TotalJobs = &v
	return s
}

// SetType sets the Type field's value.
func (s *Run) SetType(v string) *Run {
	s.Type = &v
	return s
}

// SetWebUrl sets the WebUrl field's value.
func (s *Run) SetWebUrl(v string) *Run {
	s.WebUrl = &v
	return s
}

// Represents a sample of performance data.
type Sample struct {
	_ struct{} `type:"structure"`

	// The sample's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The sample's type.
	//
	// Must be one of the following values:
	//
	//    * CPU: A CPU sample type. This is expressed as the app processing CPU
	//    time (including child processes) as reported by process, as a percentage.
	//
	//    * MEMORY: A memory usage sample type. This is expressed as the total proportional
	//    set size of an app process, in kilobytes.
	//
	//    * NATIVE_AVG_DRAWTIME
	//
	//    * NATIVE_FPS
	//
	//    * NATIVE_FRAMES
	//
	//    * NATIVE_MAX_DRAWTIME
	//
	//    * NATIVE_MIN_DRAWTIME
	//
	//    * OPENGL_AVG_DRAWTIME
	//
	//    * OPENGL_FPS
	//
	//    * OPENGL_FRAMES
	//
	//    * OPENGL_MAX_DRAWTIME
	//
	//    * OPENGL_MIN_DRAWTIME
	//
	//    * RX
	//
	//    * RX_RATE: The total number of bytes per second (TCP and UDP) that are
	//    sent, by app process.
	//
	//    * THREADS: A threads sample type. This is expressed as the total number
	//    of threads per app process.
	//
	//    * TX
	//
	//    * TX_RATE: The total number of bytes per second (TCP and UDP) that are
	//    received, by app process.
	Type *string `locationName:"type" type:"string" enum:"SampleType"`

	// The presigned Amazon S3 URL that can be used with a GET request to download
	// the sample's file.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sample) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sample) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Sample) SetArn(v string) *Sample {
	s.Arn = &v
	return s
}

// SetType sets the Type field's value.
func (s *Sample) SetType(v string) *Sample {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Sample) SetUrl(v string) *Sample {
	s.Url = &v
	return s
}

// Represents the settings for a run. Includes things like location, radio states,
// auxiliary apps, and network profiles.
type ScheduleRunConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of upload ARNs for app packages to be installed with your app.
	AuxiliaryApps []*string `locationName:"auxiliaryApps" type:"list"`

	// Specifies the billing method for a test run: metered or unmetered. If the
	// parameter is not specified, the default value is metered.
	//
	// If you have purchased unmetered device slots, you must set this parameter
	// to unmetered to make use of them. Otherwise, your run counts against your
	// metered time.
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`

	// Input CustomerArtifactPaths object for the scheduled run configuration.
	CustomerArtifactPaths *CustomerArtifactPaths `locationName:"customerArtifactPaths" type:"structure"`

	// The ARN of the extra data for the run. The extra data is a .zip file that
	// AWS Device Farm extracts to external data for Android or the app's sandbox
	// for iOS.
	ExtraDataPackageArn *string `locationName:"extraDataPackageArn" min:"32" type:"string"`

	// Information about the locale that is used for the run.
	Locale *string `locationName:"locale" type:"string"`

	// Information about the location that is used for the run.
	Location *Location `locationName:"location" type:"structure"`

	// Reserved for internal use.
	NetworkProfileArn *string `locationName:"networkProfileArn" min:"32" type:"string"`

	// Information about the radio states for the run.
	Radios *Radios `locationName:"radios" type:"structure"`

	// An array of ARNs for your VPC endpoint configurations.
	VpceConfigurationArns []*string `locationName:"vpceConfigurationArns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleRunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleRunConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleRunConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleRunConfiguration"}
	if s.ExtraDataPackageArn != nil && len(*s.ExtraDataPackageArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ExtraDataPackageArn", 32))
	}
	if s.NetworkProfileArn != nil && len(*s.NetworkProfileArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkProfileArn", 32))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuxiliaryApps sets the AuxiliaryApps field's value.
func (s *ScheduleRunConfiguration) SetAuxiliaryApps(v []*string) *ScheduleRunConfiguration {
	s.AuxiliaryApps = v
	return s
}

// SetBillingMethod sets the BillingMethod field's value.
func (s *ScheduleRunConfiguration) SetBillingMethod(v string) *ScheduleRunConfiguration {
	s.BillingMethod = &v
	return s
}

// SetCustomerArtifactPaths sets the CustomerArtifactPaths field's value.
func (s *ScheduleRunConfiguration) SetCustomerArtifactPaths(v *CustomerArtifactPaths) *ScheduleRunConfiguration {
	s.CustomerArtifactPaths = v
	return s
}

// SetExtraDataPackageArn sets the ExtraDataPackageArn field's value.
func (s *ScheduleRunConfiguration) SetExtraDataPackageArn(v string) *ScheduleRunConfiguration {
	s.ExtraDataPackageArn = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *ScheduleRunConfiguration) SetLocale(v string) *ScheduleRunConfiguration {
	s.Locale = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *ScheduleRunConfiguration) SetLocation(v *Location) *ScheduleRunConfiguration {
	s.Location = v
	return s
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *ScheduleRunConfiguration) SetNetworkProfileArn(v string) *ScheduleRunConfiguration {
	s.NetworkProfileArn = &v
	return s
}

// SetRadios sets the Radios field's value.
func (s *ScheduleRunConfiguration) SetRadios(v *Radios) *ScheduleRunConfiguration {
	s.Radios = v
	return s
}

// SetVpceConfigurationArns sets the VpceConfigurationArns field's value.
func (s *ScheduleRunConfiguration) SetVpceConfigurationArns(v []*string) *ScheduleRunConfiguration {
	s.VpceConfigurationArns = v
	return s
}

// Represents a request to the schedule run operation.
type ScheduleRunInput struct {
	_ struct{} `type:"structure"`

	// The ARN of an application package to run tests against, created with CreateUpload.
	// See ListUploads.
	AppArn *string `locationName:"appArn" min:"32" type:"string"`

	// Information about the settings for the run to be scheduled.
	Configuration *ScheduleRunConfiguration `locationName:"configuration" type:"structure"`

	// The ARN of the device pool for the run to be scheduled.
	DevicePoolArn *string `locationName:"devicePoolArn" min:"32" type:"string"`

	// The filter criteria used to dynamically select a set of devices for a test
	// run and the maximum number of devices to be included in the run.
	//
	// Either devicePoolArn or deviceSelectionConfiguration is required in a request.
	DeviceSelectionConfiguration *DeviceSelectionConfiguration `locationName:"deviceSelectionConfiguration" type:"structure"`

	// Specifies configuration information about a test run, such as the execution
	// timeout (in minutes).
	ExecutionConfiguration *ExecutionConfiguration `locationName:"executionConfiguration" type:"structure"`

	// The name for the run to be scheduled.
	Name *string `locationName:"name" type:"string"`

	// The ARN of the project for the run to be scheduled.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// Information about the test for the run to be scheduled.
	//
	// Test is a required field
	Test *ScheduleRunTest `locationName:"test" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleRunInput"}
	if s.AppArn != nil && len(*s.AppArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("AppArn", 32))
	}
	if s.DevicePoolArn != nil && len(*s.DevicePoolArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("DevicePoolArn", 32))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.Test == nil {
		invalidParams.Add(request.NewErrParamRequired("Test"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.DeviceSelectionConfiguration != nil {
		if err := s.DeviceSelectionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DeviceSelectionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Test != nil {
		if err := s.Test.Validate(); err != nil {
			invalidParams.AddNested("Test", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ScheduleRunInput) SetAppArn(v string) *ScheduleRunInput {
	s.AppArn = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *ScheduleRunInput) SetConfiguration(v *ScheduleRunConfiguration) *ScheduleRunInput {
	s.Configuration = v
	return s
}

// SetDevicePoolArn sets the DevicePoolArn field's value.
func (s *ScheduleRunInput) SetDevicePoolArn(v string) *ScheduleRunInput {
	s.DevicePoolArn = &v
	return s
}

// SetDeviceSelectionConfiguration sets the DeviceSelectionConfiguration field's value.
func (s *ScheduleRunInput) SetDeviceSelectionConfiguration(v *DeviceSelectionConfiguration) *ScheduleRunInput {
	s.DeviceSelectionConfiguration = v
	return s
}

// SetExecutionConfiguration sets the ExecutionConfiguration field's value.
func (s *ScheduleRunInput) SetExecutionConfiguration(v *ExecutionConfiguration) *ScheduleRunInput {
	s.ExecutionConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *ScheduleRunInput) SetName(v string) *ScheduleRunInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *ScheduleRunInput) SetProjectArn(v string) *ScheduleRunInput {
	s.ProjectArn = &v
	return s
}

// SetTest sets the Test field's value.
func (s *ScheduleRunInput) SetTest(v *ScheduleRunTest) *ScheduleRunInput {
	s.Test = v
	return s
}

// Represents the result of a schedule run request.
type ScheduleRunOutput struct {
	_ struct{} `type:"structure"`

	// Information about the scheduled run.
	Run *Run `locationName:"run" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleRunOutput) GoString() string {
	return s.String()
}

// SetRun sets the Run field's value.
func (s *ScheduleRunOutput) SetRun(v *Run) *ScheduleRunOutput {
	s.Run = v
	return s
}

// Represents test settings. This data structure is passed in as the test parameter
// to ScheduleRun. For an example of the JSON request syntax, see ScheduleRun.
type ScheduleRunTest struct {
	_ struct{} `type:"structure"`

	// The test's filter.
	Filter *string `locationName:"filter" type:"string"`

	// The test's parameters, such as test framework parameters and fixture settings.
	// Parameters are represented by name-value pairs of strings.
	//
	// For all tests:
	//
	//    * app_performance_monitoring: Performance monitoring is enabled by default.
	//    Set this parameter to false to disable it.
	//
	// For Calabash tests:
	//
	//    * profile: A cucumber profile (for example, my_profile_name).
	//
	//    * tags: You can limit execution to features or scenarios that have (or
	//    don't have) certain tags (for example, @smoke or @smoke,~@wip).
	//
	// For Appium tests (all types):
	//
	//    * appium_version: The Appium version. Currently supported values are 1.6.5
	//    (and later), latest, and default. latest runs the latest Appium version
	//    supported by Device Farm (1.9.1). For default, Device Farm selects a compatible
	//    version of Appium for the device. The current behavior is to run 1.7.2
	//    on Android devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.
	//    This behavior is subject to change.
	//
	// For fuzz tests (Android only):
	//
	//    * event_count: The number of events, between 1 and 10000, that the UI
	//    fuzz test should perform.
	//
	//    * throttle: The time, in ms, between 0 and 1000, that the UI fuzz test
	//    should wait between events.
	//
	//    * seed: A seed to use for randomizing the UI fuzz test. Using the same
	//    seed value between tests ensures identical event sequences.
	//
	// For Explorer tests:
	//
	//    * username: A user name to use if the Explorer encounters a login form.
	//    If not supplied, no user name is inserted.
	//
	//    * password: A password to use if the Explorer encounters a login form.
	//    If not supplied, no password is inserted.
	//
	// For Instrumentation:
	//
	//    * filter: A test filter string. Examples: Running a single test case:
	//    com.android.abc.Test1 Running a single test: com.android.abc.Test1#smoke
	//    Running multiple tests: com.android.abc.Test1,com.android.abc.Test2
	//
	// For XCTest and XCTestUI:
	//
	//    * filter: A test filter string. Examples: Running a single test class:
	//    LoginTests Running a multiple test classes: LoginTests,SmokeTests Running
	//    a single test: LoginTests/testValid Running multiple tests: LoginTests/testValid,LoginTests/testInvalid
	//
	// For UIAutomator:
	//
	//    * filter: A test filter string. Examples: Running a single test case:
	//    com.android.abc.Test1 Running a single test: com.android.abc.Test1#smoke
	//    Running multiple tests: com.android.abc.Test1,com.android.abc.Test2
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The ARN of the uploaded test to be run.
	TestPackageArn *string `locationName:"testPackageArn" min:"32" type:"string"`

	// The ARN of the YAML-formatted test specification.
	TestSpecArn *string `locationName:"testSpecArn" min:"32" type:"string"`

	// The test's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android
	//    app, interacting with it and capturing screenshots at the same time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"TestType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleRunTest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleRunTest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleRunTest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleRunTest"}
	if s.TestPackageArn != nil && len(*s.TestPackageArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("TestPackageArn", 32))
	}
	if s.TestSpecArn != nil && len(*s.TestSpecArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("TestSpecArn", 32))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ScheduleRunTest) SetFilter(v string) *ScheduleRunTest {
	s.Filter = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ScheduleRunTest) SetParameters(v map[string]*string) *ScheduleRunTest {
	s.Parameters = v
	return s
}

// SetTestPackageArn sets the TestPackageArn field's value.
func (s *ScheduleRunTest) SetTestPackageArn(v string) *ScheduleRunTest {
	s.TestPackageArn = &v
	return s
}

// SetTestSpecArn sets the TestSpecArn field's value.
func (s *ScheduleRunTest) SetTestSpecArn(v string) *ScheduleRunTest {
	s.TestSpecArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *ScheduleRunTest) SetType(v string) *ScheduleRunTest {
	s.Type = &v
	return s
}

// There was a problem with the service account.
type ServiceAccountException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Any additional information about the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceAccountException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceAccountException) GoString() string {
	return s.String()
}

func newErrorServiceAccountException(v protocol.ResponseMetadata) error {
	return &ServiceAccountException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceAccountException) Code() string {
	return "ServiceAccountException"
}

// Message returns the exception's message.
func (s *ServiceAccountException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceAccountException) OrigErr() error {
	return nil
}

func (s *ServiceAccountException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceAccountException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceAccountException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StopJobInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm job to stop.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *StopJobInput) SetArn(v string) *StopJobInput {
	s.Arn = &v
	return s
}

type StopJobOutput struct {
	_ struct{} `type:"structure"`

	// The job that was stopped.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *StopJobOutput) SetJob(v *Job) *StopJobOutput {
	s.Job = v
	return s
}

// Represents the request to stop the remote access session.
type StopRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the remote access session to stop.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopRemoteAccessSessionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *StopRemoteAccessSessionInput) SetArn(v string) *StopRemoteAccessSessionInput {
	s.Arn = &v
	return s
}

// Represents the response from the server that describes the remote access
// session when AWS Device Farm stops the session.
type StopRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`

	// A container that represents the metadata from the service about the remote
	// access session you are stopping.
	RemoteAccessSession *RemoteAccessSession `locationName:"remoteAccessSession" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// SetRemoteAccessSession sets the RemoteAccessSession field's value.
func (s *StopRemoteAccessSessionOutput) SetRemoteAccessSession(v *RemoteAccessSession) *StopRemoteAccessSessionOutput {
	s.RemoteAccessSession = v
	return s
}

// Represents the request to stop a specific run.
type StopRunInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm run to stop.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopRunInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *StopRunInput) SetArn(v string) *StopRunInput {
	s.Arn = &v
	return s
}

// Represents the results of your stop run attempt.
type StopRunOutput struct {
	_ struct{} `type:"structure"`

	// The run that was stopped.
	Run *Run `locationName:"run" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRunOutput) GoString() string {
	return s.String()
}

// SetRun sets the Run field's value.
func (s *StopRunOutput) SetRun(v *Run) *StopRunOutput {
	s.Run = v
	return s
}

// Represents a collection of one or more tests.
type Suite struct {
	_ struct{} `type:"structure"`

	// The suite's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The suite's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the suite was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// Represents the total (metered or unmetered) minutes used by the test suite.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// A message about the suite's result.
	Message *string `locationName:"message" type:"string"`

	// The suite's name.
	Name *string `locationName:"name" type:"string"`

	// The suite's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The suite's start time.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The suite's status.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PENDING_CONCURRENCY
	//
	//    * PENDING_DEVICE
	//
	//    * PROCESSING
	//
	//    * SCHEDULING
	//
	//    * PREPARING
	//
	//    * RUNNING
	//
	//    * COMPLETED
	//
	//    * STOPPING
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The suite's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`

	// The suite's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER Only available for Android; an app explorer that traverses
	//    an Android app, interacting with it and capturing screenshots at the same
	//    time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	Type *string `locationName:"type" type:"string" enum:"TestType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Suite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Suite) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Suite) SetArn(v string) *Suite {
	s.Arn = &v
	return s
}

// SetCounters sets the Counters field's value.
func (s *Suite) SetCounters(v *Counters) *Suite {
	s.Counters = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Suite) SetCreated(v time.Time) *Suite {
	s.Created = &v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *Suite) SetDeviceMinutes(v *DeviceMinutes) *Suite {
	s.DeviceMinutes = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Suite) SetMessage(v string) *Suite {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *Suite) SetName(v string) *Suite {
	s.Name = &v
	return s
}

// SetResult sets the Result field's value.
func (s *Suite) SetResult(v string) *Suite {
	s.Result = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *Suite) SetStarted(v time.Time) *Suite {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Suite) SetStatus(v string) *Suite {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Suite) SetStopped(v time.Time) *Suite {
	s.Stopped = &v
	return s
}

// SetType sets the Type field's value.
func (s *Suite) SetType(v string) *Suite {
	s.Type = &v
	return s
}

// The metadata that you apply to a resource to help you categorize and organize
// it. Each tag consists of a key and an optional value, both of which you define.
// Tag keys can have a maximum character length of 128 characters. Tag values
// can have a maximum length of 256 characters.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that makes up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that makes up a tag. A value acts as
	// a descriptor in a tag category (key).
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The operation was not successful. Try again.
type TagOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	ResourceName *string `locationName:"resourceName" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagOperationException) GoString() string {
	return s.String()
}

func newErrorTagOperationException(v protocol.ResponseMetadata) error {
	return &TagOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagOperationException) Code() string {
	return "TagOperationException"
}

// Message returns the exception's message.
func (s *TagOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagOperationException) OrigErr() error {
	return nil
}

func (s *TagOperationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request doesn't comply with the AWS Identity and Access Management (IAM)
// tag policy. Correct your request and then retry it.
type TagPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	ResourceName *string `locationName:"resourceName" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagPolicyException) GoString() string {
	return s.String()
}

func newErrorTagPolicyException(v protocol.ResponseMetadata) error {
	return &TagPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagPolicyException) Code() string {
	return "TagPolicyException"
}

// Message returns the exception's message.
func (s *TagPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagPolicyException) OrigErr() error {
	return nil
}

func (s *TagPolicyException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource or resources to which to add
	// tags. You can associate tags with the following Device Farm resources: PROJECT,
	// RUN, NETWORK_PROFILE, INSTANCE_PROFILE, DEVICE_INSTANCE, SESSION, DEVICE_POOL,
	// DEVICE, and VPCE_CONFIGURATION.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"32" type:"string" required:"true"`

	// The tags to add to the resource. A tag is an array of key-value pairs. Tag
	// keys can have a maximum character length of 128 characters. Tag values can
	// have a maximum length of 256 characters.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 32))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Represents a condition that is evaluated.
type Test struct {
	_ struct{} `type:"structure"`

	// The test's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The test's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the test was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// Represents the total (metered or unmetered) minutes used by the test.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// A message about the test's result.
	Message *string `locationName:"message" type:"string"`

	// The test's name.
	Name *string `locationName:"name" type:"string"`

	// The test's result.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PASSED
	//
	//    * WARNED
	//
	//    * FAILED
	//
	//    * SKIPPED
	//
	//    * ERRORED
	//
	//    * STOPPED
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The test's start time.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// The test's status.
	//
	// Allowed values include:
	//
	//    * PENDING
	//
	//    * PENDING_CONCURRENCY
	//
	//    * PENDING_DEVICE
	//
	//    * PROCESSING
	//
	//    * SCHEDULING
	//
	//    * PREPARING
	//
	//    * RUNNING
	//
	//    * COMPLETED
	//
	//    * STOPPING
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The test's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp"`

	// The test's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ
	//
	//    * BUILTIN_EXPLORER For Android, an app explorer that traverses an Android
	//    app, interacting with it and capturing screenshots at the same time.
	//
	//    * APPIUM_JAVA_JUNIT
	//
	//    * APPIUM_JAVA_TESTNG
	//
	//    * APPIUM_PYTHON
	//
	//    * APPIUM_NODE
	//
	//    * APPIUM_RUBY
	//
	//    * APPIUM_WEB_JAVA_JUNIT
	//
	//    * APPIUM_WEB_JAVA_TESTNG
	//
	//    * APPIUM_WEB_PYTHON
	//
	//    * APPIUM_WEB_NODE
	//
	//    * APPIUM_WEB_RUBY
	//
	//    * CALABASH
	//
	//    * INSTRUMENTATION
	//
	//    * UIAUTOMATION
	//
	//    * UIAUTOMATOR
	//
	//    * XCTEST
	//
	//    * XCTEST_UI
	Type *string `locationName:"type" type:"string" enum:"TestType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Test) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Test) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Test) SetArn(v string) *Test {
	s.Arn = &v
	return s
}

// SetCounters sets the Counters field's value.
func (s *Test) SetCounters(v *Counters) *Test {
	s.Counters = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Test) SetCreated(v time.Time) *Test {
	s.Created = &v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *Test) SetDeviceMinutes(v *DeviceMinutes) *Test {
	s.DeviceMinutes = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Test) SetMessage(v string) *Test {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *Test) SetName(v string) *Test {
	s.Name = &v
	return s
}

// SetResult sets the Result field's value.
func (s *Test) SetResult(v string) *Test {
	s.Result = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *Test) SetStarted(v time.Time) *Test {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Test) SetStatus(v string) *Test {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Test) SetStopped(v time.Time) *Test {
	s.Stopped = &v
	return s
}

// SetType sets the Type field's value.
func (s *Test) SetType(v string) *Test {
	s.Type = &v
	return s
}

// A Selenium testing project. Projects are used to collect and collate sessions.
type TestGridProject struct {
	_ struct{} `type:"structure"`

	// The ARN for the project.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// When the project was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// A human-readable description for the project.
	Description *string `locationName:"description" type:"string"`

	// A human-readable name for the project.
	Name *string `locationName:"name" type:"string"`

	// The VPC security groups and subnets that are attached to a project.
	VpcConfig *TestGridVpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridProject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridProject) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TestGridProject) SetArn(v string) *TestGridProject {
	s.Arn = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *TestGridProject) SetCreated(v time.Time) *TestGridProject {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TestGridProject) SetDescription(v string) *TestGridProject {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *TestGridProject) SetName(v string) *TestGridProject {
	s.Name = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *TestGridProject) SetVpcConfig(v *TestGridVpcConfig) *TestGridProject {
	s.VpcConfig = v
	return s
}

// A TestGridSession is a single instance of a browser launched from the URL
// provided by a call to CreateTestGridUrl.
type TestGridSession struct {
	_ struct{} `type:"structure"`

	// The ARN of the session.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The number of billed minutes that were used for this session.
	BillingMinutes *float64 `locationName:"billingMinutes" type:"double"`

	// The time that the session was started.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// The time the session ended.
	Ended *time.Time `locationName:"ended" type:"timestamp"`

	// A JSON object of options and parameters passed to the Selenium WebDriver.
	SeleniumProperties *string `locationName:"seleniumProperties" type:"string"`

	// The state of the session.
	Status *string `locationName:"status" type:"string" enum:"TestGridSessionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridSession) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TestGridSession) SetArn(v string) *TestGridSession {
	s.Arn = &v
	return s
}

// SetBillingMinutes sets the BillingMinutes field's value.
func (s *TestGridSession) SetBillingMinutes(v float64) *TestGridSession {
	s.BillingMinutes = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *TestGridSession) SetCreated(v time.Time) *TestGridSession {
	s.Created = &v
	return s
}

// SetEnded sets the Ended field's value.
func (s *TestGridSession) SetEnded(v time.Time) *TestGridSession {
	s.Ended = &v
	return s
}

// SetSeleniumProperties sets the SeleniumProperties field's value.
func (s *TestGridSession) SetSeleniumProperties(v string) *TestGridSession {
	s.SeleniumProperties = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestGridSession) SetStatus(v string) *TestGridSession {
	s.Status = &v
	return s
}

// An action taken by a TestGridSession browser instance.
type TestGridSessionAction struct {
	_ struct{} `type:"structure"`

	// The action taken by the session.
	Action *string `locationName:"action" type:"string"`

	// The time, in milliseconds, that the action took to complete in the browser.
	Duration *int64 `locationName:"duration" type:"long"`

	// HTTP method that the browser used to make the request.
	RequestMethod *string `locationName:"requestMethod" type:"string"`

	// The time that the session invoked the action.
	Started *time.Time `locationName:"started" type:"timestamp"`

	// HTTP status code returned to the browser when the action was taken.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridSessionAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridSessionAction) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *TestGridSessionAction) SetAction(v string) *TestGridSessionAction {
	s.Action = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *TestGridSessionAction) SetDuration(v int64) *TestGridSessionAction {
	s.Duration = &v
	return s
}

// SetRequestMethod sets the RequestMethod field's value.
func (s *TestGridSessionAction) SetRequestMethod(v string) *TestGridSessionAction {
	s.RequestMethod = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *TestGridSessionAction) SetStarted(v time.Time) *TestGridSessionAction {
	s.Started = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *TestGridSessionAction) SetStatusCode(v string) *TestGridSessionAction {
	s.StatusCode = &v
	return s
}

// Artifacts are video and other files that are produced in the process of running
// a browser in an automated context.
//
// Video elements might be broken up into multiple artifacts as they grow in
// size during creation.
type TestGridSessionArtifact struct {
	_ struct{} `type:"structure"`

	// The file name of the artifact.
	Filename *string `locationName:"filename" type:"string"`

	// The kind of artifact.
	Type *string `locationName:"type" type:"string" enum:"TestGridSessionArtifactType"`

	// A semi-stable URL to the content of the object.
	//
	// Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TestGridSessionArtifact's
	// String and GoString methods.
	Url *string `locationName:"url" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridSessionArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridSessionArtifact) GoString() string {
	return s.String()
}

// SetFilename sets the Filename field's value.
func (s *TestGridSessionArtifact) SetFilename(v string) *TestGridSessionArtifact {
	s.Filename = &v
	return s
}

// SetType sets the Type field's value.
func (s *TestGridSessionArtifact) SetType(v string) *TestGridSessionArtifact {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *TestGridSessionArtifact) SetUrl(v string) *TestGridSessionArtifact {
	s.Url = &v
	return s
}

// The VPC security groups and subnets that are attached to a project.
type TestGridVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of VPC security group IDs in your Amazon VPC.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list" required:"true"`

	// A list of VPC subnet IDs in your Amazon VPC.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" min:"1" type:"list" required:"true"`

	// The ID of the Amazon VPC.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestGridVpcConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestGridVpcConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestGridVpcConfig"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *TestGridVpcConfig) SetSecurityGroupIds(v []*string) *TestGridVpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *TestGridVpcConfig) SetSubnetIds(v []*string) *TestGridVpcConfig {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *TestGridVpcConfig) SetVpcId(v string) *TestGridVpcConfig {
	s.VpcId = &v
	return s
}

// The list of tags on the repository is over the limit. The maximum number
// of tags that can be applied to a repository is 50.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	ResourceName *string `locationName:"resourceName" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents information about free trial device minutes for an AWS account.
type TrialMinutes struct {
	_ struct{} `type:"structure"`

	// The number of free trial minutes remaining in the account.
	Remaining *float64 `locationName:"remaining" type:"double"`

	// The total number of free trial minutes that the account started with.
	Total *float64 `locationName:"total" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrialMinutes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrialMinutes) GoString() string {
	return s.String()
}

// SetRemaining sets the Remaining field's value.
func (s *TrialMinutes) SetRemaining(v float64) *TrialMinutes {
	s.Remaining = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *TrialMinutes) SetTotal(v float64) *TrialMinutes {
	s.Total = &v
	return s
}

// A collection of one or more problems, grouped by their result.
type UniqueProblem struct {
	_ struct{} `type:"structure"`

	// A message about the unique problems' result.
	Message *string `locationName:"message" type:"string"`

	// Information about the problems.
	Problems []*Problem `locationName:"problems" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UniqueProblem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UniqueProblem) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *UniqueProblem) SetMessage(v string) *UniqueProblem {
	s.Message = &v
	return s
}

// SetProblems sets the Problems field's value.
func (s *UniqueProblem) SetProblems(v []*Problem) *UniqueProblem {
	s.Problems = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource or resources from which to
	// delete tags. You can associate tags with the following Device Farm resources:
	// PROJECT, RUN, NETWORK_PROFILE, INSTANCE_PROFILE, DEVICE_INSTANCE, SESSION,
	// DEVICE_POOL, DEVICE, and VPCE_CONFIGURATION.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"32" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 32))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDeviceInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the device instance.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An array of strings that you want to associate with the device instance.
	Labels []*string `locationName:"labels" type:"list"`

	// The ARN of the profile that you want to associate with the device instance.
	ProfileArn *string `locationName:"profileArn" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceInstanceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.ProfileArn != nil && len(*s.ProfileArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateDeviceInstanceInput) SetArn(v string) *UpdateDeviceInstanceInput {
	s.Arn = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *UpdateDeviceInstanceInput) SetLabels(v []*string) *UpdateDeviceInstanceInput {
	s.Labels = v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *UpdateDeviceInstanceInput) SetProfileArn(v string) *UpdateDeviceInstanceInput {
	s.ProfileArn = &v
	return s
}

type UpdateDeviceInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your device instance.
	DeviceInstance *DeviceInstance `locationName:"deviceInstance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceInstanceOutput) GoString() string {
	return s.String()
}

// SetDeviceInstance sets the DeviceInstance field's value.
func (s *UpdateDeviceInstanceOutput) SetDeviceInstance(v *DeviceInstance) *UpdateDeviceInstanceOutput {
	s.DeviceInstance = v
	return s
}

// Represents a request to the update device pool operation.
type UpdateDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Device Farm device pool to update.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// Sets whether the maxDevices parameter applies to your device pool. If you
	// set this parameter to true, the maxDevices parameter does not apply, and
	// Device Farm does not limit the number of devices that it adds to your device
	// pool. In this case, Device Farm adds all available devices that meet the
	// criteria specified in the rules parameter.
	//
	// If you use this parameter in your request, you cannot use the maxDevices
	// parameter in the same request.
	ClearMaxDevices *bool `locationName:"clearMaxDevices" type:"boolean"`

	// A description of the device pool to update.
	Description *string `locationName:"description" type:"string"`

	// The number of devices that Device Farm can add to your device pool. Device
	// Farm adds devices that are available and that meet the criteria that you
	// assign for the rules parameter. Depending on how many devices meet these
	// constraints, your device pool might contain fewer devices than the value
	// for this parameter.
	//
	// By specifying the maximum number of devices, you can control the costs that
	// you incur by running tests.
	//
	// If you use this parameter in your request, you cannot use the clearMaxDevices
	// parameter in the same request.
	MaxDevices *int64 `locationName:"maxDevices" type:"integer"`

	// A string that represents the name of the device pool to update.
	Name *string `locationName:"name" type:"string"`

	// Represents the rules to modify for the device pool. Updating rules is optional.
	// If you update rules for your request, the update replaces the existing rules.
	Rules []*Rule `locationName:"rules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDevicePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDevicePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDevicePoolInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateDevicePoolInput) SetArn(v string) *UpdateDevicePoolInput {
	s.Arn = &v
	return s
}

// SetClearMaxDevices sets the ClearMaxDevices field's value.
func (s *UpdateDevicePoolInput) SetClearMaxDevices(v bool) *UpdateDevicePoolInput {
	s.ClearMaxDevices = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDevicePoolInput) SetDescription(v string) *UpdateDevicePoolInput {
	s.Description = &v
	return s
}

// SetMaxDevices sets the MaxDevices field's value.
func (s *UpdateDevicePoolInput) SetMaxDevices(v int64) *UpdateDevicePoolInput {
	s.MaxDevices = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDevicePoolInput) SetName(v string) *UpdateDevicePoolInput {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateDevicePoolInput) SetRules(v []*Rule) *UpdateDevicePoolInput {
	s.Rules = v
	return s
}

// Represents the result of an update device pool request.
type UpdateDevicePoolOutput struct {
	_ struct{} `type:"structure"`

	// The device pool you just updated.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDevicePoolOutput) GoString() string {
	return s.String()
}

// SetDevicePool sets the DevicePool field's value.
func (s *UpdateDevicePoolOutput) SetDevicePool(v *DevicePool) *UpdateDevicePoolOutput {
	s.DevicePool = v
	return s
}

type UpdateInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance profile.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// The updated description for your instance profile.
	Description *string `locationName:"description" type:"string"`

	// An array of strings that specifies the list of app packages that should not
	// be cleaned up from the device after a test run is over.
	//
	// The list of packages is only considered if you set packageCleanup to true.
	ExcludeAppPackagesFromCleanup []*string `locationName:"excludeAppPackagesFromCleanup" type:"list"`

	// The updated name for your instance profile.
	Name *string `locationName:"name" type:"string"`

	// The updated choice for whether you want to specify package cleanup. The default
	// value is false for private devices.
	PackageCleanup *bool `locationName:"packageCleanup" type:"boolean"`

	// The updated choice for whether you want to reboot the device after use. The
	// default value is true.
	RebootAfterUse *bool `locationName:"rebootAfterUse" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInstanceProfileInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateInstanceProfileInput) SetArn(v string) *UpdateInstanceProfileInput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateInstanceProfileInput) SetDescription(v string) *UpdateInstanceProfileInput {
	s.Description = &v
	return s
}

// SetExcludeAppPackagesFromCleanup sets the ExcludeAppPackagesFromCleanup field's value.
func (s *UpdateInstanceProfileInput) SetExcludeAppPackagesFromCleanup(v []*string) *UpdateInstanceProfileInput {
	s.ExcludeAppPackagesFromCleanup = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateInstanceProfileInput) SetName(v string) *UpdateInstanceProfileInput {
	s.Name = &v
	return s
}

// SetPackageCleanup sets the PackageCleanup field's value.
func (s *UpdateInstanceProfileInput) SetPackageCleanup(v bool) *UpdateInstanceProfileInput {
	s.PackageCleanup = &v
	return s
}

// SetRebootAfterUse sets the RebootAfterUse field's value.
func (s *UpdateInstanceProfileInput) SetRebootAfterUse(v bool) *UpdateInstanceProfileInput {
	s.RebootAfterUse = &v
	return s
}

type UpdateInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your instance profile.
	InstanceProfile *InstanceProfile `locationName:"instanceProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceProfileOutput) GoString() string {
	return s.String()
}

// SetInstanceProfile sets the InstanceProfile field's value.
func (s *UpdateInstanceProfileOutput) SetInstanceProfile(v *InstanceProfile) *UpdateInstanceProfileOutput {
	s.InstanceProfile = v
	return s
}

type UpdateNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project for which you want to update
	// network profile settings.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// The description of the network profile about which you are returning information.
	Description *string `locationName:"description" type:"string"`

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	DownlinkBandwidthBits *int64 `locationName:"downlinkBandwidthBits" type:"long"`

	// Delay time for all packets to destination in milliseconds as an integer from
	// 0 to 2000.
	DownlinkDelayMs *int64 `locationName:"downlinkDelayMs" type:"long"`

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	DownlinkJitterMs *int64 `locationName:"downlinkJitterMs" type:"long"`

	// Proportion of received packets that fail to arrive from 0 to 100 percent.
	DownlinkLossPercent *int64 `locationName:"downlinkLossPercent" type:"integer"`

	// The name of the network profile about which you are returning information.
	Name *string `locationName:"name" type:"string"`

	// The type of network profile to return information about. Valid values are
	// listed here.
	Type *string `locationName:"type" type:"string" enum:"NetworkProfileType"`

	// The data throughput rate in bits per second, as an integer from 0 to 104857600.
	UplinkBandwidthBits *int64 `locationName:"uplinkBandwidthBits" type:"long"`

	// Delay time for all packets to destination in milliseconds as an integer from
	// 0 to 2000.
	UplinkDelayMs *int64 `locationName:"uplinkDelayMs" type:"long"`

	// Time variation in the delay of received packets in milliseconds as an integer
	// from 0 to 2000.
	UplinkJitterMs *int64 `locationName:"uplinkJitterMs" type:"long"`

	// Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
	UplinkLossPercent *int64 `locationName:"uplinkLossPercent" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNetworkProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNetworkProfileInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateNetworkProfileInput) SetArn(v string) *UpdateNetworkProfileInput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateNetworkProfileInput) SetDescription(v string) *UpdateNetworkProfileInput {
	s.Description = &v
	return s
}

// SetDownlinkBandwidthBits sets the DownlinkBandwidthBits field's value.
func (s *UpdateNetworkProfileInput) SetDownlinkBandwidthBits(v int64) *UpdateNetworkProfileInput {
	s.DownlinkBandwidthBits = &v
	return s
}

// SetDownlinkDelayMs sets the DownlinkDelayMs field's value.
func (s *UpdateNetworkProfileInput) SetDownlinkDelayMs(v int64) *UpdateNetworkProfileInput {
	s.DownlinkDelayMs = &v
	return s
}

// SetDownlinkJitterMs sets the DownlinkJitterMs field's value.
func (s *UpdateNetworkProfileInput) SetDownlinkJitterMs(v int64) *UpdateNetworkProfileInput {
	s.DownlinkJitterMs = &v
	return s
}

// SetDownlinkLossPercent sets the DownlinkLossPercent field's value.
func (s *UpdateNetworkProfileInput) SetDownlinkLossPercent(v int64) *UpdateNetworkProfileInput {
	s.DownlinkLossPercent = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateNetworkProfileInput) SetName(v string) *UpdateNetworkProfileInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateNetworkProfileInput) SetType(v string) *UpdateNetworkProfileInput {
	s.Type = &v
	return s
}

// SetUplinkBandwidthBits sets the UplinkBandwidthBits field's value.
func (s *UpdateNetworkProfileInput) SetUplinkBandwidthBits(v int64) *UpdateNetworkProfileInput {
	s.UplinkBandwidthBits = &v
	return s
}

// SetUplinkDelayMs sets the UplinkDelayMs field's value.
func (s *UpdateNetworkProfileInput) SetUplinkDelayMs(v int64) *UpdateNetworkProfileInput {
	s.UplinkDelayMs = &v
	return s
}

// SetUplinkJitterMs sets the UplinkJitterMs field's value.
func (s *UpdateNetworkProfileInput) SetUplinkJitterMs(v int64) *UpdateNetworkProfileInput {
	s.UplinkJitterMs = &v
	return s
}

// SetUplinkLossPercent sets the UplinkLossPercent field's value.
func (s *UpdateNetworkProfileInput) SetUplinkLossPercent(v int64) *UpdateNetworkProfileInput {
	s.UplinkLossPercent = &v
	return s
}

type UpdateNetworkProfileOutput struct {
	_ struct{} `type:"structure"`

	// A list of the available network profiles.
	NetworkProfile *NetworkProfile `locationName:"networkProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkProfileOutput) GoString() string {
	return s.String()
}

// SetNetworkProfile sets the NetworkProfile field's value.
func (s *UpdateNetworkProfileOutput) SetNetworkProfile(v *NetworkProfile) *UpdateNetworkProfileOutput {
	s.NetworkProfile = v
	return s
}

// Represents a request to the update project operation.
type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project whose name to update.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// The number of minutes a test run in the project executes before it times
	// out.
	DefaultJobTimeoutMinutes *int64 `locationName:"defaultJobTimeoutMinutes" type:"integer"`

	// A string that represents the new name of the project that you are updating.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateProjectInput) SetArn(v string) *UpdateProjectInput {
	s.Arn = &v
	return s
}

// SetDefaultJobTimeoutMinutes sets the DefaultJobTimeoutMinutes field's value.
func (s *UpdateProjectInput) SetDefaultJobTimeoutMinutes(v int64) *UpdateProjectInput {
	s.DefaultJobTimeoutMinutes = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProjectInput) SetName(v string) *UpdateProjectInput {
	s.Name = &v
	return s
}

// Represents the result of an update project request.
type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The project to update.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *UpdateProjectOutput) SetProject(v *Project) *UpdateProjectOutput {
	s.Project = v
	return s
}

type UpdateTestGridProjectInput struct {
	_ struct{} `type:"structure"`

	// Human-readable description for the project.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Human-readable name for the project.
	Name *string `locationName:"name" min:"1" type:"string"`

	// ARN of the project to update.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// The VPC security groups and subnets that are attached to a project.
	VpcConfig *TestGridVpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestGridProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestGridProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTestGridProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTestGridProjectInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateTestGridProjectInput) SetDescription(v string) *UpdateTestGridProjectInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTestGridProjectInput) SetName(v string) *UpdateTestGridProjectInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *UpdateTestGridProjectInput) SetProjectArn(v string) *UpdateTestGridProjectInput {
	s.ProjectArn = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *UpdateTestGridProjectInput) SetVpcConfig(v *TestGridVpcConfig) *UpdateTestGridProjectInput {
	s.VpcConfig = v
	return s
}

type UpdateTestGridProjectOutput struct {
	_ struct{} `type:"structure"`

	// The project, including updated information.
	TestGridProject *TestGridProject `locationName:"testGridProject" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestGridProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTestGridProjectOutput) GoString() string {
	return s.String()
}

// SetTestGridProject sets the TestGridProject field's value.
func (s *UpdateTestGridProjectOutput) SetTestGridProject(v *TestGridProject) *UpdateTestGridProjectOutput {
	s.TestGridProject = v
	return s
}

type UpdateUploadInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the uploaded test spec.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// The upload's content type (for example, application/x-yaml).
	ContentType *string `locationName:"contentType" type:"string"`

	// Set to true if the YAML file has changed and must be updated. Otherwise,
	// set to false.
	EditContent *bool `locationName:"editContent" type:"boolean"`

	// The upload's test spec file name. The name must not contain any forward slashes
	// (/). The test spec file name must end with the .yaml or .yml file extension.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUploadInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateUploadInput) SetArn(v string) *UpdateUploadInput {
	s.Arn = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *UpdateUploadInput) SetContentType(v string) *UpdateUploadInput {
	s.ContentType = &v
	return s
}

// SetEditContent sets the EditContent field's value.
func (s *UpdateUploadInput) SetEditContent(v bool) *UpdateUploadInput {
	s.EditContent = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateUploadInput) SetName(v string) *UpdateUploadInput {
	s.Name = &v
	return s
}

type UpdateUploadOutput struct {
	_ struct{} `type:"structure"`

	// A test spec uploaded to Device Farm.
	Upload *Upload `locationName:"upload" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUploadOutput) GoString() string {
	return s.String()
}

// SetUpload sets the Upload field's value.
func (s *UpdateUploadOutput) SetUpload(v *Upload) *UpdateUploadOutput {
	s.Upload = v
	return s
}

type UpdateVPCEConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the VPC endpoint configuration you want
	// to update.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// The DNS (domain) name used to connect to your private service in your VPC.
	// The DNS name must not already be in use on the internet.
	ServiceDnsName *string `locationName:"serviceDnsName" type:"string"`

	// An optional description that provides details about your VPC endpoint configuration.
	VpceConfigurationDescription *string `locationName:"vpceConfigurationDescription" type:"string"`

	// The friendly name you give to your VPC endpoint configuration to manage your
	// configurations more easily.
	VpceConfigurationName *string `locationName:"vpceConfigurationName" type:"string"`

	// The name of the VPC endpoint service running in your AWS account that you
	// want Device Farm to test.
	VpceServiceName *string `locationName:"vpceServiceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVPCEConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVPCEConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVPCEConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVPCEConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateVPCEConfigurationInput) SetArn(v string) *UpdateVPCEConfigurationInput {
	s.Arn = &v
	return s
}

// SetServiceDnsName sets the ServiceDnsName field's value.
func (s *UpdateVPCEConfigurationInput) SetServiceDnsName(v string) *UpdateVPCEConfigurationInput {
	s.ServiceDnsName = &v
	return s
}

// SetVpceConfigurationDescription sets the VpceConfigurationDescription field's value.
func (s *UpdateVPCEConfigurationInput) SetVpceConfigurationDescription(v string) *UpdateVPCEConfigurationInput {
	s.VpceConfigurationDescription = &v
	return s
}

// SetVpceConfigurationName sets the VpceConfigurationName field's value.
func (s *UpdateVPCEConfigurationInput) SetVpceConfigurationName(v string) *UpdateVPCEConfigurationInput {
	s.VpceConfigurationName = &v
	return s
}

// SetVpceServiceName sets the VpceServiceName field's value.
func (s *UpdateVPCEConfigurationInput) SetVpceServiceName(v string) *UpdateVPCEConfigurationInput {
	s.VpceServiceName = &v
	return s
}

type UpdateVPCEConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about your VPC endpoint configuration.
	VpceConfiguration *VPCEConfiguration `locationName:"vpceConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVPCEConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVPCEConfigurationOutput) GoString() string {
	return s.String()
}

// SetVpceConfiguration sets the VpceConfiguration field's value.
func (s *UpdateVPCEConfigurationOutput) SetVpceConfiguration(v *VPCEConfiguration) *UpdateVPCEConfigurationOutput {
	s.VpceConfiguration = v
	return s
}

// An app or a set of one or more tests to upload or that have been uploaded.
type Upload struct {
	_ struct{} `type:"structure"`

	// The upload's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The upload's category. Allowed values include:
	//
	//    * CURATED: An upload managed by AWS Device Farm.
	//
	//    * PRIVATE: An upload managed by the AWS Device Farm customer.
	Category *string `locationName:"category" type:"string" enum:"UploadCategory"`

	// The upload's content type (for example, application/octet-stream).
	ContentType *string `locationName:"contentType" type:"string"`

	// When the upload was created.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// A message about the upload's result.
	Message *string `locationName:"message" type:"string"`

	// The upload's metadata. For example, for Android, this contains information
	// that is parsed from the manifest and is displayed in the AWS Device Farm
	// console after the associated app is uploaded.
	Metadata *string `locationName:"metadata" type:"string"`

	// The upload's file name.
	Name *string `locationName:"name" type:"string"`

	// The upload's status.
	//
	// Must be one of the following values:
	//
	//    * FAILED
	//
	//    * INITIALIZED
	//
	//    * PROCESSING
	//
	//    * SUCCEEDED
	Status *string `locationName:"status" type:"string" enum:"UploadStatus"`

	// The upload's type.
	//
	// Must be one of the following values:
	//
	//    * ANDROID_APP
	//
	//    * IOS_APP
	//
	//    * WEB_APP
	//
	//    * EXTERNAL_DATA
	//
	//    * APPIUM_JAVA_JUNIT_TEST_PACKAGE
	//
	//    * APPIUM_JAVA_TESTNG_TEST_PACKAGE
	//
	//    * APPIUM_PYTHON_TEST_PACKAGE
	//
	//    * APPIUM_NODE_TEST_PACKAGE
	//
	//    * APPIUM_RUBY_TEST_PACKAGE
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE
	//
	//    * APPIUM_WEB_PYTHON_TEST_PACKAGE
	//
	//    * APPIUM_WEB_NODE_TEST_PACKAGE
	//
	//    * APPIUM_WEB_RUBY_TEST_PACKAGE
	//
	//    * CALABASH_TEST_PACKAGE
	//
	//    * INSTRUMENTATION_TEST_PACKAGE
	//
	//    * UIAUTOMATION_TEST_PACKAGE
	//
	//    * UIAUTOMATOR_TEST_PACKAGE
	//
	//    * XCTEST_TEST_PACKAGE
	//
	//    * XCTEST_UI_TEST_PACKAGE
	//
	//    * APPIUM_JAVA_JUNIT_TEST_SPEC
	//
	//    * APPIUM_JAVA_TESTNG_TEST_SPEC
	//
	//    * APPIUM_PYTHON_TEST_SPEC
	//
	//    * APPIUM_NODE_TEST_SPEC
	//
	//    * APPIUM_RUBY_TEST_SPEC
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC
	//
	//    * APPIUM_WEB_PYTHON_TEST_SPEC
	//
	//    * APPIUM_WEB_NODE_TEST_SPEC
	//
	//    * APPIUM_WEB_RUBY_TEST_SPEC
	//
	//    * INSTRUMENTATION_TEST_SPEC
	//
	//    * XCTEST_UI_TEST_SPEC
	Type *string `locationName:"type" type:"string" enum:"UploadType"`

	// The presigned Amazon S3 URL that was used to store a file using a PUT request.
	//
	// Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Upload's
	// String and GoString methods.
	Url *string `locationName:"url" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Upload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Upload) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Upload) SetArn(v string) *Upload {
	s.Arn = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *Upload) SetCategory(v string) *Upload {
	s.Category = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Upload) SetContentType(v string) *Upload {
	s.ContentType = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *Upload) SetCreated(v time.Time) *Upload {
	s.Created = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Upload) SetMessage(v string) *Upload {
	s.Message = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *Upload) SetMetadata(v string) *Upload {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *Upload) SetName(v string) *Upload {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Upload) SetStatus(v string) *Upload {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Upload) SetType(v string) *Upload {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Upload) SetUrl(v string) *Upload {
	s.Url = &v
	return s
}

// Represents an Amazon Virtual Private Cloud (VPC) endpoint configuration.
type VPCEConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the VPC endpoint configuration.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The DNS name that maps to the private IP address of the service you want
	// to access.
	ServiceDnsName *string `locationName:"serviceDnsName" type:"string"`

	// An optional description that provides details about your VPC endpoint configuration.
	VpceConfigurationDescription *string `locationName:"vpceConfigurationDescription" type:"string"`

	// The friendly name you give to your VPC endpoint configuration to manage your
	// configurations more easily.
	VpceConfigurationName *string `locationName:"vpceConfigurationName" type:"string"`

	// The name of the VPC endpoint service running in your AWS account that you
	// want Device Farm to test.
	VpceServiceName *string `locationName:"vpceServiceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCEConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VPCEConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VPCEConfiguration) SetArn(v string) *VPCEConfiguration {
	s.Arn = &v
	return s
}

// SetServiceDnsName sets the ServiceDnsName field's value.
func (s *VPCEConfiguration) SetServiceDnsName(v string) *VPCEConfiguration {
	s.ServiceDnsName = &v
	return s
}

// SetVpceConfigurationDescription sets the VpceConfigurationDescription field's value.
func (s *VPCEConfiguration) SetVpceConfigurationDescription(v string) *VPCEConfiguration {
	s.VpceConfigurationDescription = &v
	return s
}

// SetVpceConfigurationName sets the VpceConfigurationName field's value.
func (s *VPCEConfiguration) SetVpceConfigurationName(v string) *VPCEConfiguration {
	s.VpceConfigurationName = &v
	return s
}

// SetVpceServiceName sets the VpceServiceName field's value.
func (s *VPCEConfiguration) SetVpceServiceName(v string) *VPCEConfiguration {
	s.VpceServiceName = &v
	return s
}

const (
	// ArtifactCategoryScreenshot is a ArtifactCategory enum value
	ArtifactCategoryScreenshot = "SCREENSHOT"

	// ArtifactCategoryFile is a ArtifactCategory enum value
	ArtifactCategoryFile = "FILE"

	// ArtifactCategoryLog is a ArtifactCategory enum value
	ArtifactCategoryLog = "LOG"
)

// ArtifactCategory_Values returns all elements of the ArtifactCategory enum
func ArtifactCategory_Values() []string {
	return []string{
		ArtifactCategoryScreenshot,
		ArtifactCategoryFile,
		ArtifactCategoryLog,
	}
}

const (
	// ArtifactTypeUnknown is a ArtifactType enum value
	ArtifactTypeUnknown = "UNKNOWN"

	// ArtifactTypeScreenshot is a ArtifactType enum value
	ArtifactTypeScreenshot = "SCREENSHOT"

	// ArtifactTypeDeviceLog is a ArtifactType enum value
	ArtifactTypeDeviceLog = "DEVICE_LOG"

	// ArtifactTypeMessageLog is a ArtifactType enum value
	ArtifactTypeMessageLog = "MESSAGE_LOG"

	// ArtifactTypeVideoLog is a ArtifactType enum value
	ArtifactTypeVideoLog = "VIDEO_LOG"

	// ArtifactTypeResultLog is a ArtifactType enum value
	ArtifactTypeResultLog = "RESULT_LOG"

	// ArtifactTypeServiceLog is a ArtifactType enum value
	ArtifactTypeServiceLog = "SERVICE_LOG"

	// ArtifactTypeWebkitLog is a ArtifactType enum value
	ArtifactTypeWebkitLog = "WEBKIT_LOG"

	// ArtifactTypeInstrumentationOutput is a ArtifactType enum value
	ArtifactTypeInstrumentationOutput = "INSTRUMENTATION_OUTPUT"

	// ArtifactTypeExerciserMonkeyOutput is a ArtifactType enum value
	ArtifactTypeExerciserMonkeyOutput = "EXERCISER_MONKEY_OUTPUT"

	// ArtifactTypeCalabashJsonOutput is a ArtifactType enum value
	ArtifactTypeCalabashJsonOutput = "CALABASH_JSON_OUTPUT"

	// ArtifactTypeCalabashPrettyOutput is a ArtifactType enum value
	ArtifactTypeCalabashPrettyOutput = "CALABASH_PRETTY_OUTPUT"

	// ArtifactTypeCalabashStandardOutput is a ArtifactType enum value
	ArtifactTypeCalabashStandardOutput = "CALABASH_STANDARD_OUTPUT"

	// ArtifactTypeCalabashJavaXmlOutput is a ArtifactType enum value
	ArtifactTypeCalabashJavaXmlOutput = "CALABASH_JAVA_XML_OUTPUT"

	// ArtifactTypeAutomationOutput is a ArtifactType enum value
	ArtifactTypeAutomationOutput = "AUTOMATION_OUTPUT"

	// ArtifactTypeAppiumServerOutput is a ArtifactType enum value
	ArtifactTypeAppiumServerOutput = "APPIUM_SERVER_OUTPUT"

	// ArtifactTypeAppiumJavaOutput is a ArtifactType enum value
	ArtifactTypeAppiumJavaOutput = "APPIUM_JAVA_OUTPUT"

	// ArtifactTypeAppiumJavaXmlOutput is a ArtifactType enum value
	ArtifactTypeAppiumJavaXmlOutput = "APPIUM_JAVA_XML_OUTPUT"

	// ArtifactTypeAppiumPythonOutput is a ArtifactType enum value
	ArtifactTypeAppiumPythonOutput = "APPIUM_PYTHON_OUTPUT"

	// ArtifactTypeAppiumPythonXmlOutput is a ArtifactType enum value
	ArtifactTypeAppiumPythonXmlOutput = "APPIUM_PYTHON_XML_OUTPUT"

	// ArtifactTypeExplorerEventLog is a ArtifactType enum value
	ArtifactTypeExplorerEventLog = "EXPLORER_EVENT_LOG"

	// ArtifactTypeExplorerSummaryLog is a ArtifactType enum value
	ArtifactTypeExplorerSummaryLog = "EXPLORER_SUMMARY_LOG"

	// ArtifactTypeApplicationCrashReport is a ArtifactType enum value
	ArtifactTypeApplicationCrashReport = "APPLICATION_CRASH_REPORT"

	// ArtifactTypeXctestLog is a ArtifactType enum value
	ArtifactTypeXctestLog = "XCTEST_LOG"

	// ArtifactTypeVideo is a ArtifactType enum value
	ArtifactTypeVideo = "VIDEO"

	// ArtifactTypeCustomerArtifact is a ArtifactType enum value
	ArtifactTypeCustomerArtifact = "CUSTOMER_ARTIFACT"

	// ArtifactTypeCustomerArtifactLog is a ArtifactType enum value
	ArtifactTypeCustomerArtifactLog = "CUSTOMER_ARTIFACT_LOG"

	// ArtifactTypeTestspecOutput is a ArtifactType enum value
	ArtifactTypeTestspecOutput = "TESTSPEC_OUTPUT"
)

// ArtifactType_Values returns all elements of the ArtifactType enum
func ArtifactType_Values() []string {
	return []string{
		ArtifactTypeUnknown,
		ArtifactTypeScreenshot,
		ArtifactTypeDeviceLog,
		ArtifactTypeMessageLog,
		ArtifactTypeVideoLog,
		ArtifactTypeResultLog,
		ArtifactTypeServiceLog,
		ArtifactTypeWebkitLog,
		ArtifactTypeInstrumentationOutput,
		ArtifactTypeExerciserMonkeyOutput,
		ArtifactTypeCalabashJsonOutput,
		ArtifactTypeCalabashPrettyOutput,
		ArtifactTypeCalabashStandardOutput,
		ArtifactTypeCalabashJavaXmlOutput,
		ArtifactTypeAutomationOutput,
		ArtifactTypeAppiumServerOutput,
		ArtifactTypeAppiumJavaOutput,
		ArtifactTypeAppiumJavaXmlOutput,
		ArtifactTypeAppiumPythonOutput,
		ArtifactTypeAppiumPythonXmlOutput,
		ArtifactTypeExplorerEventLog,
		ArtifactTypeExplorerSummaryLog,
		ArtifactTypeApplicationCrashReport,
		ArtifactTypeXctestLog,
		ArtifactTypeVideo,
		ArtifactTypeCustomerArtifact,
		ArtifactTypeCustomerArtifactLog,
		ArtifactTypeTestspecOutput,
	}
}

const (
	// BillingMethodMetered is a BillingMethod enum value
	BillingMethodMetered = "METERED"

	// BillingMethodUnmetered is a BillingMethod enum value
	BillingMethodUnmetered = "UNMETERED"
)

// BillingMethod_Values returns all elements of the BillingMethod enum
func BillingMethod_Values() []string {
	return []string{
		BillingMethodMetered,
		BillingMethodUnmetered,
	}
}

const (
	// CurrencyCodeUsd is a CurrencyCode enum value
	CurrencyCodeUsd = "USD"
)

// CurrencyCode_Values returns all elements of the CurrencyCode enum
func CurrencyCode_Values() []string {
	return []string{
		CurrencyCodeUsd,
	}
}

const (
	// DeviceAttributeArn is a DeviceAttribute enum value
	DeviceAttributeArn = "ARN"

	// DeviceAttributePlatform is a DeviceAttribute enum value
	DeviceAttributePlatform = "PLATFORM"

	// DeviceAttributeFormFactor is a DeviceAttribute enum value
	DeviceAttributeFormFactor = "FORM_FACTOR"

	// DeviceAttributeManufacturer is a DeviceAttribute enum value
	DeviceAttributeManufacturer = "MANUFACTURER"

	// DeviceAttributeRemoteAccessEnabled is a DeviceAttribute enum value
	DeviceAttributeRemoteAccessEnabled = "REMOTE_ACCESS_ENABLED"

	// DeviceAttributeRemoteDebugEnabled is a DeviceAttribute enum value
	DeviceAttributeRemoteDebugEnabled = "REMOTE_DEBUG_ENABLED"

	// DeviceAttributeAppiumVersion is a DeviceAttribute enum value
	DeviceAttributeAppiumVersion = "APPIUM_VERSION"

	// DeviceAttributeInstanceArn is a DeviceAttribute enum value
	DeviceAttributeInstanceArn = "INSTANCE_ARN"

	// DeviceAttributeInstanceLabels is a DeviceAttribute enum value
	DeviceAttributeInstanceLabels = "INSTANCE_LABELS"

	// DeviceAttributeFleetType is a DeviceAttribute enum value
	DeviceAttributeFleetType = "FLEET_TYPE"

	// DeviceAttributeOsVersion is a DeviceAttribute enum value
	DeviceAttributeOsVersion = "OS_VERSION"

	// DeviceAttributeModel is a DeviceAttribute enum value
	DeviceAttributeModel = "MODEL"

	// DeviceAttributeAvailability is a DeviceAttribute enum value
	DeviceAttributeAvailability = "AVAILABILITY"
)

// DeviceAttribute_Values returns all elements of the DeviceAttribute enum
func DeviceAttribute_Values() []string {
	return []string{
		DeviceAttributeArn,
		DeviceAttributePlatform,
		DeviceAttributeFormFactor,
		DeviceAttributeManufacturer,
		DeviceAttributeRemoteAccessEnabled,
		DeviceAttributeRemoteDebugEnabled,
		DeviceAttributeAppiumVersion,
		DeviceAttributeInstanceArn,
		DeviceAttributeInstanceLabels,
		DeviceAttributeFleetType,
		DeviceAttributeOsVersion,
		DeviceAttributeModel,
		DeviceAttributeAvailability,
	}
}

const (
	// DeviceAvailabilityTemporaryNotAvailable is a DeviceAvailability enum value
	DeviceAvailabilityTemporaryNotAvailable = "TEMPORARY_NOT_AVAILABLE"

	// DeviceAvailabilityBusy is a DeviceAvailability enum value
	DeviceAvailabilityBusy = "BUSY"

	// DeviceAvailabilityAvailable is a DeviceAvailability enum value
	DeviceAvailabilityAvailable = "AVAILABLE"

	// DeviceAvailabilityHighlyAvailable is a DeviceAvailability enum value
	DeviceAvailabilityHighlyAvailable = "HIGHLY_AVAILABLE"
)

// DeviceAvailability_Values returns all elements of the DeviceAvailability enum
func DeviceAvailability_Values() []string {
	return []string{
		DeviceAvailabilityTemporaryNotAvailable,
		DeviceAvailabilityBusy,
		DeviceAvailabilityAvailable,
		DeviceAvailabilityHighlyAvailable,
	}
}

const (
	// DeviceFilterAttributeArn is a DeviceFilterAttribute enum value
	DeviceFilterAttributeArn = "ARN"

	// DeviceFilterAttributePlatform is a DeviceFilterAttribute enum value
	DeviceFilterAttributePlatform = "PLATFORM"

	// DeviceFilterAttributeOsVersion is a DeviceFilterAttribute enum value
	DeviceFilterAttributeOsVersion = "OS_VERSION"

	// DeviceFilterAttributeModel is a DeviceFilterAttribute enum value
	DeviceFilterAttributeModel = "MODEL"

	// DeviceFilterAttributeAvailability is a DeviceFilterAttribute enum value
	DeviceFilterAttributeAvailability = "AVAILABILITY"

	// DeviceFilterAttributeFormFactor is a DeviceFilterAttribute enum value
	DeviceFilterAttributeFormFactor = "FORM_FACTOR"

	// DeviceFilterAttributeManufacturer is a DeviceFilterAttribute enum value
	DeviceFilterAttributeManufacturer = "MANUFACTURER"

	// DeviceFilterAttributeRemoteAccessEnabled is a DeviceFilterAttribute enum value
	DeviceFilterAttributeRemoteAccessEnabled = "REMOTE_ACCESS_ENABLED"

	// DeviceFilterAttributeRemoteDebugEnabled is a DeviceFilterAttribute enum value
	DeviceFilterAttributeRemoteDebugEnabled = "REMOTE_DEBUG_ENABLED"

	// DeviceFilterAttributeInstanceArn is a DeviceFilterAttribute enum value
	DeviceFilterAttributeInstanceArn = "INSTANCE_ARN"

	// DeviceFilterAttributeInstanceLabels is a DeviceFilterAttribute enum value
	DeviceFilterAttributeInstanceLabels = "INSTANCE_LABELS"

	// DeviceFilterAttributeFleetType is a DeviceFilterAttribute enum value
	DeviceFilterAttributeFleetType = "FLEET_TYPE"
)

// DeviceFilterAttribute_Values returns all elements of the DeviceFilterAttribute enum
func DeviceFilterAttribute_Values() []string {
	return []string{
		DeviceFilterAttributeArn,
		DeviceFilterAttributePlatform,
		DeviceFilterAttributeOsVersion,
		DeviceFilterAttributeModel,
		DeviceFilterAttributeAvailability,
		DeviceFilterAttributeFormFactor,
		DeviceFilterAttributeManufacturer,
		DeviceFilterAttributeRemoteAccessEnabled,
		DeviceFilterAttributeRemoteDebugEnabled,
		DeviceFilterAttributeInstanceArn,
		DeviceFilterAttributeInstanceLabels,
		DeviceFilterAttributeFleetType,
	}
}

const (
	// DeviceFormFactorPhone is a DeviceFormFactor enum value
	DeviceFormFactorPhone = "PHONE"

	// DeviceFormFactorTablet is a DeviceFormFactor enum value
	DeviceFormFactorTablet = "TABLET"
)

// DeviceFormFactor_Values returns all elements of the DeviceFormFactor enum
func DeviceFormFactor_Values() []string {
	return []string{
		DeviceFormFactorPhone,
		DeviceFormFactorTablet,
	}
}

const (
	// DevicePlatformAndroid is a DevicePlatform enum value
	DevicePlatformAndroid = "ANDROID"

	// DevicePlatformIos is a DevicePlatform enum value
	DevicePlatformIos = "IOS"
)

// DevicePlatform_Values returns all elements of the DevicePlatform enum
func DevicePlatform_Values() []string {
	return []string{
		DevicePlatformAndroid,
		DevicePlatformIos,
	}
}

const (
	// DevicePoolTypeCurated is a DevicePoolType enum value
	DevicePoolTypeCurated = "CURATED"

	// DevicePoolTypePrivate is a DevicePoolType enum value
	DevicePoolTypePrivate = "PRIVATE"
)

// DevicePoolType_Values returns all elements of the DevicePoolType enum
func DevicePoolType_Values() []string {
	return []string{
		DevicePoolTypeCurated,
		DevicePoolTypePrivate,
	}
}

const (
	// ExecutionResultPending is a ExecutionResult enum value
	ExecutionResultPending = "PENDING"

	// ExecutionResultPassed is a ExecutionResult enum value
	ExecutionResultPassed = "PASSED"

	// ExecutionResultWarned is a ExecutionResult enum value
	ExecutionResultWarned = "WARNED"

	// ExecutionResultFailed is a ExecutionResult enum value
	ExecutionResultFailed = "FAILED"

	// ExecutionResultSkipped is a ExecutionResult enum value
	ExecutionResultSkipped = "SKIPPED"

	// ExecutionResultErrored is a ExecutionResult enum value
	ExecutionResultErrored = "ERRORED"

	// ExecutionResultStopped is a ExecutionResult enum value
	ExecutionResultStopped = "STOPPED"
)

// ExecutionResult_Values returns all elements of the ExecutionResult enum
func ExecutionResult_Values() []string {
	return []string{
		ExecutionResultPending,
		ExecutionResultPassed,
		ExecutionResultWarned,
		ExecutionResultFailed,
		ExecutionResultSkipped,
		ExecutionResultErrored,
		ExecutionResultStopped,
	}
}

const (
	// ExecutionResultCodeParsingFailed is a ExecutionResultCode enum value
	ExecutionResultCodeParsingFailed = "PARSING_FAILED"

	// ExecutionResultCodeVpcEndpointSetupFailed is a ExecutionResultCode enum value
	ExecutionResultCodeVpcEndpointSetupFailed = "VPC_ENDPOINT_SETUP_FAILED"
)

// ExecutionResultCode_Values returns all elements of the ExecutionResultCode enum
func ExecutionResultCode_Values() []string {
	return []string{
		ExecutionResultCodeParsingFailed,
		ExecutionResultCodeVpcEndpointSetupFailed,
	}
}

const (
	// ExecutionStatusPending is a ExecutionStatus enum value
	ExecutionStatusPending = "PENDING"

	// ExecutionStatusPendingConcurrency is a ExecutionStatus enum value
	ExecutionStatusPendingConcurrency = "PENDING_CONCURRENCY"

	// ExecutionStatusPendingDevice is a ExecutionStatus enum value
	ExecutionStatusPendingDevice = "PENDING_DEVICE"

	// ExecutionStatusProcessing is a ExecutionStatus enum value
	ExecutionStatusProcessing = "PROCESSING"

	// ExecutionStatusScheduling is a ExecutionStatus enum value
	ExecutionStatusScheduling = "SCHEDULING"

	// ExecutionStatusPreparing is a ExecutionStatus enum value
	ExecutionStatusPreparing = "PREPARING"

	// ExecutionStatusRunning is a ExecutionStatus enum value
	ExecutionStatusRunning = "RUNNING"

	// ExecutionStatusCompleted is a ExecutionStatus enum value
	ExecutionStatusCompleted = "COMPLETED"

	// ExecutionStatusStopping is a ExecutionStatus enum value
	ExecutionStatusStopping = "STOPPING"
)

// ExecutionStatus_Values returns all elements of the ExecutionStatus enum
func ExecutionStatus_Values() []string {
	return []string{
		ExecutionStatusPending,
		ExecutionStatusPendingConcurrency,
		ExecutionStatusPendingDevice,
		ExecutionStatusProcessing,
		ExecutionStatusScheduling,
		ExecutionStatusPreparing,
		ExecutionStatusRunning,
		ExecutionStatusCompleted,
		ExecutionStatusStopping,
	}
}

const (
	// InstanceStatusInUse is a InstanceStatus enum value
	InstanceStatusInUse = "IN_USE"

	// InstanceStatusPreparing is a InstanceStatus enum value
	InstanceStatusPreparing = "PREPARING"

	// InstanceStatusAvailable is a InstanceStatus enum value
	InstanceStatusAvailable = "AVAILABLE"

	// InstanceStatusNotAvailable is a InstanceStatus enum value
	InstanceStatusNotAvailable = "NOT_AVAILABLE"
)

// InstanceStatus_Values returns all elements of the InstanceStatus enum
func InstanceStatus_Values() []string {
	return []string{
		InstanceStatusInUse,
		InstanceStatusPreparing,
		InstanceStatusAvailable,
		InstanceStatusNotAvailable,
	}
}

const (
	// InteractionModeInteractive is a InteractionMode enum value
	InteractionModeInteractive = "INTERACTIVE"

	// InteractionModeNoVideo is a InteractionMode enum value
	InteractionModeNoVideo = "NO_VIDEO"

	// InteractionModeVideoOnly is a InteractionMode enum value
	InteractionModeVideoOnly = "VIDEO_ONLY"
)

// InteractionMode_Values returns all elements of the InteractionMode enum
func InteractionMode_Values() []string {
	return []string{
		InteractionModeInteractive,
		InteractionModeNoVideo,
		InteractionModeVideoOnly,
	}
}

const (
	// NetworkProfileTypeCurated is a NetworkProfileType enum value
	NetworkProfileTypeCurated = "CURATED"

	// NetworkProfileTypePrivate is a NetworkProfileType enum value
	NetworkProfileTypePrivate = "PRIVATE"
)

// NetworkProfileType_Values returns all elements of the NetworkProfileType enum
func NetworkProfileType_Values() []string {
	return []string{
		NetworkProfileTypeCurated,
		NetworkProfileTypePrivate,
	}
}

const (
	// OfferingTransactionTypePurchase is a OfferingTransactionType enum value
	OfferingTransactionTypePurchase = "PURCHASE"

	// OfferingTransactionTypeRenew is a OfferingTransactionType enum value
	OfferingTransactionTypeRenew = "RENEW"

	// OfferingTransactionTypeSystem is a OfferingTransactionType enum value
	OfferingTransactionTypeSystem = "SYSTEM"
)

// OfferingTransactionType_Values returns all elements of the OfferingTransactionType enum
func OfferingTransactionType_Values() []string {
	return []string{
		OfferingTransactionTypePurchase,
		OfferingTransactionTypeRenew,
		OfferingTransactionTypeSystem,
	}
}

const (
	// OfferingTypeRecurring is a OfferingType enum value
	OfferingTypeRecurring = "RECURRING"
)

// OfferingType_Values returns all elements of the OfferingType enum
func OfferingType_Values() []string {
	return []string{
		OfferingTypeRecurring,
	}
}

const (
	// RecurringChargeFrequencyMonthly is a RecurringChargeFrequency enum value
	RecurringChargeFrequencyMonthly = "MONTHLY"
)

// RecurringChargeFrequency_Values returns all elements of the RecurringChargeFrequency enum
func RecurringChargeFrequency_Values() []string {
	return []string{
		RecurringChargeFrequencyMonthly,
	}
}

const (
	// RuleOperatorEquals is a RuleOperator enum value
	RuleOperatorEquals = "EQUALS"

	// RuleOperatorLessThan is a RuleOperator enum value
	RuleOperatorLessThan = "LESS_THAN"

	// RuleOperatorLessThanOrEquals is a RuleOperator enum value
	RuleOperatorLessThanOrEquals = "LESS_THAN_OR_EQUALS"

	// RuleOperatorGreaterThan is a RuleOperator enum value
	RuleOperatorGreaterThan = "GREATER_THAN"

	// RuleOperatorGreaterThanOrEquals is a RuleOperator enum value
	RuleOperatorGreaterThanOrEquals = "GREATER_THAN_OR_EQUALS"

	// RuleOperatorIn is a RuleOperator enum value
	RuleOperatorIn = "IN"

	// RuleOperatorNotIn is a RuleOperator enum value
	RuleOperatorNotIn = "NOT_IN"

	// RuleOperatorContains is a RuleOperator enum value
	RuleOperatorContains = "CONTAINS"
)

// RuleOperator_Values returns all elements of the RuleOperator enum
func RuleOperator_Values() []string {
	return []string{
		RuleOperatorEquals,
		RuleOperatorLessThan,
		RuleOperatorLessThanOrEquals,
		RuleOperatorGreaterThan,
		RuleOperatorGreaterThanOrEquals,
		RuleOperatorIn,
		RuleOperatorNotIn,
		RuleOperatorContains,
	}
}

const (
	// SampleTypeCpu is a SampleType enum value
	SampleTypeCpu = "CPU"

	// SampleTypeMemory is a SampleType enum value
	SampleTypeMemory = "MEMORY"

	// SampleTypeThreads is a SampleType enum value
	SampleTypeThreads = "THREADS"

	// SampleTypeRxRate is a SampleType enum value
	SampleTypeRxRate = "RX_RATE"

	// SampleTypeTxRate is a SampleType enum value
	SampleTypeTxRate = "TX_RATE"

	// SampleTypeRx is a SampleType enum value
	SampleTypeRx = "RX"

	// SampleTypeTx is a SampleType enum value
	SampleTypeTx = "TX"

	// SampleTypeNativeFrames is a SampleType enum value
	SampleTypeNativeFrames = "NATIVE_FRAMES"

	// SampleTypeNativeFps is a SampleType enum value
	SampleTypeNativeFps = "NATIVE_FPS"

	// SampleTypeNativeMinDrawtime is a SampleType enum value
	SampleTypeNativeMinDrawtime = "NATIVE_MIN_DRAWTIME"

	// SampleTypeNativeAvgDrawtime is a SampleType enum value
	SampleTypeNativeAvgDrawtime = "NATIVE_AVG_DRAWTIME"

	// SampleTypeNativeMaxDrawtime is a SampleType enum value
	SampleTypeNativeMaxDrawtime = "NATIVE_MAX_DRAWTIME"

	// SampleTypeOpenglFrames is a SampleType enum value
	SampleTypeOpenglFrames = "OPENGL_FRAMES"

	// SampleTypeOpenglFps is a SampleType enum value
	SampleTypeOpenglFps = "OPENGL_FPS"

	// SampleTypeOpenglMinDrawtime is a SampleType enum value
	SampleTypeOpenglMinDrawtime = "OPENGL_MIN_DRAWTIME"

	// SampleTypeOpenglAvgDrawtime is a SampleType enum value
	SampleTypeOpenglAvgDrawtime = "OPENGL_AVG_DRAWTIME"

	// SampleTypeOpenglMaxDrawtime is a SampleType enum value
	SampleTypeOpenglMaxDrawtime = "OPENGL_MAX_DRAWTIME"
)

// SampleType_Values returns all elements of the SampleType enum
func SampleType_Values() []string {
	return []string{
		SampleTypeCpu,
		SampleTypeMemory,
		SampleTypeThreads,
		SampleTypeRxRate,
		SampleTypeTxRate,
		SampleTypeRx,
		SampleTypeTx,
		SampleTypeNativeFrames,
		SampleTypeNativeFps,
		SampleTypeNativeMinDrawtime,
		SampleTypeNativeAvgDrawtime,
		SampleTypeNativeMaxDrawtime,
		SampleTypeOpenglFrames,
		SampleTypeOpenglFps,
		SampleTypeOpenglMinDrawtime,
		SampleTypeOpenglAvgDrawtime,
		SampleTypeOpenglMaxDrawtime,
	}
}

const (
	// TestGridSessionArtifactCategoryVideo is a TestGridSessionArtifactCategory enum value
	TestGridSessionArtifactCategoryVideo = "VIDEO"

	// TestGridSessionArtifactCategoryLog is a TestGridSessionArtifactCategory enum value
	TestGridSessionArtifactCategoryLog = "LOG"
)

// TestGridSessionArtifactCategory_Values returns all elements of the TestGridSessionArtifactCategory enum
func TestGridSessionArtifactCategory_Values() []string {
	return []string{
		TestGridSessionArtifactCategoryVideo,
		TestGridSessionArtifactCategoryLog,
	}
}

const (
	// TestGridSessionArtifactTypeUnknown is a TestGridSessionArtifactType enum value
	TestGridSessionArtifactTypeUnknown = "UNKNOWN"

	// TestGridSessionArtifactTypeVideo is a TestGridSessionArtifactType enum value
	TestGridSessionArtifactTypeVideo = "VIDEO"

	// TestGridSessionArtifactTypeSeleniumLog is a TestGridSessionArtifactType enum value
	TestGridSessionArtifactTypeSeleniumLog = "SELENIUM_LOG"
)

// TestGridSessionArtifactType_Values returns all elements of the TestGridSessionArtifactType enum
func TestGridSessionArtifactType_Values() []string {
	return []string{
		TestGridSessionArtifactTypeUnknown,
		TestGridSessionArtifactTypeVideo,
		TestGridSessionArtifactTypeSeleniumLog,
	}
}

const (
	// TestGridSessionStatusActive is a TestGridSessionStatus enum value
	TestGridSessionStatusActive = "ACTIVE"

	// TestGridSessionStatusClosed is a TestGridSessionStatus enum value
	TestGridSessionStatusClosed = "CLOSED"

	// TestGridSessionStatusErrored is a TestGridSessionStatus enum value
	TestGridSessionStatusErrored = "ERRORED"
)

// TestGridSessionStatus_Values returns all elements of the TestGridSessionStatus enum
func TestGridSessionStatus_Values() []string {
	return []string{
		TestGridSessionStatusActive,
		TestGridSessionStatusClosed,
		TestGridSessionStatusErrored,
	}
}

const (
	// TestTypeBuiltinFuzz is a TestType enum value
	TestTypeBuiltinFuzz = "BUILTIN_FUZZ"

	// TestTypeBuiltinExplorer is a TestType enum value
	TestTypeBuiltinExplorer = "BUILTIN_EXPLORER"

	// TestTypeWebPerformanceProfile is a TestType enum value
	TestTypeWebPerformanceProfile = "WEB_PERFORMANCE_PROFILE"

	// TestTypeAppiumJavaJunit is a TestType enum value
	TestTypeAppiumJavaJunit = "APPIUM_JAVA_JUNIT"

	// TestTypeAppiumJavaTestng is a TestType enum value
	TestTypeAppiumJavaTestng = "APPIUM_JAVA_TESTNG"

	// TestTypeAppiumPython is a TestType enum value
	TestTypeAppiumPython = "APPIUM_PYTHON"

	// TestTypeAppiumNode is a TestType enum value
	TestTypeAppiumNode = "APPIUM_NODE"

	// TestTypeAppiumRuby is a TestType enum value
	TestTypeAppiumRuby = "APPIUM_RUBY"

	// TestTypeAppiumWebJavaJunit is a TestType enum value
	TestTypeAppiumWebJavaJunit = "APPIUM_WEB_JAVA_JUNIT"

	// TestTypeAppiumWebJavaTestng is a TestType enum value
	TestTypeAppiumWebJavaTestng = "APPIUM_WEB_JAVA_TESTNG"

	// TestTypeAppiumWebPython is a TestType enum value
	TestTypeAppiumWebPython = "APPIUM_WEB_PYTHON"

	// TestTypeAppiumWebNode is a TestType enum value
	TestTypeAppiumWebNode = "APPIUM_WEB_NODE"

	// TestTypeAppiumWebRuby is a TestType enum value
	TestTypeAppiumWebRuby = "APPIUM_WEB_RUBY"

	// TestTypeCalabash is a TestType enum value
	TestTypeCalabash = "CALABASH"

	// TestTypeInstrumentation is a TestType enum value
	TestTypeInstrumentation = "INSTRUMENTATION"

	// TestTypeUiautomation is a TestType enum value
	TestTypeUiautomation = "UIAUTOMATION"

	// TestTypeUiautomator is a TestType enum value
	TestTypeUiautomator = "UIAUTOMATOR"

	// TestTypeXctest is a TestType enum value
	TestTypeXctest = "XCTEST"

	// TestTypeXctestUi is a TestType enum value
	TestTypeXctestUi = "XCTEST_UI"

	// TestTypeRemoteAccessRecord is a TestType enum value
	TestTypeRemoteAccessRecord = "REMOTE_ACCESS_RECORD"

	// TestTypeRemoteAccessReplay is a TestType enum value
	TestTypeRemoteAccessReplay = "REMOTE_ACCESS_REPLAY"
)

// TestType_Values returns all elements of the TestType enum
func TestType_Values() []string {
	return []string{
		TestTypeBuiltinFuzz,
		TestTypeBuiltinExplorer,
		TestTypeWebPerformanceProfile,
		TestTypeAppiumJavaJunit,
		TestTypeAppiumJavaTestng,
		TestTypeAppiumPython,
		TestTypeAppiumNode,
		TestTypeAppiumRuby,
		TestTypeAppiumWebJavaJunit,
		TestTypeAppiumWebJavaTestng,
		TestTypeAppiumWebPython,
		TestTypeAppiumWebNode,
		TestTypeAppiumWebRuby,
		TestTypeCalabash,
		TestTypeInstrumentation,
		TestTypeUiautomation,
		TestTypeUiautomator,
		TestTypeXctest,
		TestTypeXctestUi,
		TestTypeRemoteAccessRecord,
		TestTypeRemoteAccessReplay,
	}
}

const (
	// UploadCategoryCurated is a UploadCategory enum value
	UploadCategoryCurated = "CURATED"

	// UploadCategoryPrivate is a UploadCategory enum value
	UploadCategoryPrivate = "PRIVATE"
)

// UploadCategory_Values returns all elements of the UploadCategory enum
func UploadCategory_Values() []string {
	return []string{
		UploadCategoryCurated,
		UploadCategoryPrivate,
	}
}

const (
	// UploadStatusInitialized is a UploadStatus enum value
	UploadStatusInitialized = "INITIALIZED"

	// UploadStatusProcessing is a UploadStatus enum value
	UploadStatusProcessing = "PROCESSING"

	// UploadStatusSucceeded is a UploadStatus enum value
	UploadStatusSucceeded = "SUCCEEDED"

	// UploadStatusFailed is a UploadStatus enum value
	UploadStatusFailed = "FAILED"
)

// UploadStatus_Values returns all elements of the UploadStatus enum
func UploadStatus_Values() []string {
	return []string{
		UploadStatusInitialized,
		UploadStatusProcessing,
		UploadStatusSucceeded,
		UploadStatusFailed,
	}
}

const (
	// UploadTypeAndroidApp is a UploadType enum value
	UploadTypeAndroidApp = "ANDROID_APP"

	// UploadTypeIosApp is a UploadType enum value
	UploadTypeIosApp = "IOS_APP"

	// UploadTypeWebApp is a UploadType enum value
	UploadTypeWebApp = "WEB_APP"

	// UploadTypeExternalData is a UploadType enum value
	UploadTypeExternalData = "EXTERNAL_DATA"

	// UploadTypeAppiumJavaJunitTestPackage is a UploadType enum value
	UploadTypeAppiumJavaJunitTestPackage = "APPIUM_JAVA_JUNIT_TEST_PACKAGE"

	// UploadTypeAppiumJavaTestngTestPackage is a UploadType enum value
	UploadTypeAppiumJavaTestngTestPackage = "APPIUM_JAVA_TESTNG_TEST_PACKAGE"

	// UploadTypeAppiumPythonTestPackage is a UploadType enum value
	UploadTypeAppiumPythonTestPackage = "APPIUM_PYTHON_TEST_PACKAGE"

	// UploadTypeAppiumNodeTestPackage is a UploadType enum value
	UploadTypeAppiumNodeTestPackage = "APPIUM_NODE_TEST_PACKAGE"

	// UploadTypeAppiumRubyTestPackage is a UploadType enum value
	UploadTypeAppiumRubyTestPackage = "APPIUM_RUBY_TEST_PACKAGE"

	// UploadTypeAppiumWebJavaJunitTestPackage is a UploadType enum value
	UploadTypeAppiumWebJavaJunitTestPackage = "APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE"

	// UploadTypeAppiumWebJavaTestngTestPackage is a UploadType enum value
	UploadTypeAppiumWebJavaTestngTestPackage = "APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE"

	// UploadTypeAppiumWebPythonTestPackage is a UploadType enum value
	UploadTypeAppiumWebPythonTestPackage = "APPIUM_WEB_PYTHON_TEST_PACKAGE"

	// UploadTypeAppiumWebNodeTestPackage is a UploadType enum value
	UploadTypeAppiumWebNodeTestPackage = "APPIUM_WEB_NODE_TEST_PACKAGE"

	// UploadTypeAppiumWebRubyTestPackage is a UploadType enum value
	UploadTypeAppiumWebRubyTestPackage = "APPIUM_WEB_RUBY_TEST_PACKAGE"

	// UploadTypeCalabashTestPackage is a UploadType enum value
	UploadTypeCalabashTestPackage = "CALABASH_TEST_PACKAGE"

	// UploadTypeInstrumentationTestPackage is a UploadType enum value
	UploadTypeInstrumentationTestPackage = "INSTRUMENTATION_TEST_PACKAGE"

	// UploadTypeUiautomationTestPackage is a UploadType enum value
	UploadTypeUiautomationTestPackage = "UIAUTOMATION_TEST_PACKAGE"

	// UploadTypeUiautomatorTestPackage is a UploadType enum value
	UploadTypeUiautomatorTestPackage = "UIAUTOMATOR_TEST_PACKAGE"

	// UploadTypeXctestTestPackage is a UploadType enum value
	UploadTypeXctestTestPackage = "XCTEST_TEST_PACKAGE"

	// UploadTypeXctestUiTestPackage is a UploadType enum value
	UploadTypeXctestUiTestPackage = "XCTEST_UI_TEST_PACKAGE"

	// UploadTypeAppiumJavaJunitTestSpec is a UploadType enum value
	UploadTypeAppiumJavaJunitTestSpec = "APPIUM_JAVA_JUNIT_TEST_SPEC"

	// UploadTypeAppiumJavaTestngTestSpec is a UploadType enum value
	UploadTypeAppiumJavaTestngTestSpec = "APPIUM_JAVA_TESTNG_TEST_SPEC"

	// UploadTypeAppiumPythonTestSpec is a UploadType enum value
	UploadTypeAppiumPythonTestSpec = "APPIUM_PYTHON_TEST_SPEC"

	// UploadTypeAppiumNodeTestSpec is a UploadType enum value
	UploadTypeAppiumNodeTestSpec = "APPIUM_NODE_TEST_SPEC"

	// UploadTypeAppiumRubyTestSpec is a UploadType enum value
	UploadTypeAppiumRubyTestSpec = "APPIUM_RUBY_TEST_SPEC"

	// UploadTypeAppiumWebJavaJunitTestSpec is a UploadType enum value
	UploadTypeAppiumWebJavaJunitTestSpec = "APPIUM_WEB_JAVA_JUNIT_TEST_SPEC"

	// UploadTypeAppiumWebJavaTestngTestSpec is a UploadType enum value
	UploadTypeAppiumWebJavaTestngTestSpec = "APPIUM_WEB_JAVA_TESTNG_TEST_SPEC"

	// UploadTypeAppiumWebPythonTestSpec is a UploadType enum value
	UploadTypeAppiumWebPythonTestSpec = "APPIUM_WEB_PYTHON_TEST_SPEC"

	// UploadTypeAppiumWebNodeTestSpec is a UploadType enum value
	UploadTypeAppiumWebNodeTestSpec = "APPIUM_WEB_NODE_TEST_SPEC"

	// UploadTypeAppiumWebRubyTestSpec is a UploadType enum value
	UploadTypeAppiumWebRubyTestSpec = "APPIUM_WEB_RUBY_TEST_SPEC"

	// UploadTypeInstrumentationTestSpec is a UploadType enum value
	UploadTypeInstrumentationTestSpec = "INSTRUMENTATION_TEST_SPEC"

	// UploadTypeXctestUiTestSpec is a UploadType enum value
	UploadTypeXctestUiTestSpec = "XCTEST_UI_TEST_SPEC"
)

// UploadType_Values returns all elements of the UploadType enum
func UploadType_Values() []string {
	return []string{
		UploadTypeAndroidApp,
		UploadTypeIosApp,
		UploadTypeWebApp,
		UploadTypeExternalData,
		UploadTypeAppiumJavaJunitTestPackage,
		UploadTypeAppiumJavaTestngTestPackage,
		UploadTypeAppiumPythonTestPackage,
		UploadTypeAppiumNodeTestPackage,
		UploadTypeAppiumRubyTestPackage,
		UploadTypeAppiumWebJavaJunitTestPackage,
		UploadTypeAppiumWebJavaTestngTestPackage,
		UploadTypeAppiumWebPythonTestPackage,
		UploadTypeAppiumWebNodeTestPackage,
		UploadTypeAppiumWebRubyTestPackage,
		UploadTypeCalabashTestPackage,
		UploadTypeInstrumentationTestPackage,
		UploadTypeUiautomationTestPackage,
		UploadTypeUiautomatorTestPackage,
		UploadTypeXctestTestPackage,
		UploadTypeXctestUiTestPackage,
		UploadTypeAppiumJavaJunitTestSpec,
		UploadTypeAppiumJavaTestngTestSpec,
		UploadTypeAppiumPythonTestSpec,
		UploadTypeAppiumNodeTestSpec,
		UploadTypeAppiumRubyTestSpec,
		UploadTypeAppiumWebJavaJunitTestSpec,
		UploadTypeAppiumWebJavaTestngTestSpec,
		UploadTypeAppiumWebPythonTestSpec,
		UploadTypeAppiumWebNodeTestSpec,
		UploadTypeAppiumWebRubyTestSpec,
		UploadTypeInstrumentationTestSpec,
		UploadTypeXctestUiTestSpec,
	}
}
