// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchevidently

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchEvaluateFeature = "BatchEvaluateFeature"

// BatchEvaluateFeatureRequest generates a "aws/request.Request" representing the
// client's request for the BatchEvaluateFeature operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchEvaluateFeature for more information on using the BatchEvaluateFeature
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchEvaluateFeatureRequest method.
//	req, resp := client.BatchEvaluateFeatureRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/BatchEvaluateFeature
func (c *CloudWatchEvidently) BatchEvaluateFeatureRequest(input *BatchEvaluateFeatureInput) (req *request.Request, output *BatchEvaluateFeatureOutput) {
	op := &request.Operation{
		Name:       opBatchEvaluateFeature,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/evaluations",
	}

	if input == nil {
		input = &BatchEvaluateFeatureInput{}
	}

	output = &BatchEvaluateFeatureOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("dataplane.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchEvaluateFeature API operation for Amazon CloudWatch Evidently.
//
// This operation assigns feature variation to user sessions. For each user
// session, you pass in an entityID that represents the user. Evidently then
// checks the evaluation rules and assigns the variation.
//
// The first rules that are evaluated are the override rules. If the user's
// entityID matches an override rule, the user is served the variation specified
// by that rule.
//
// Next, if there is a launch of the feature, the user might be assigned to
// a variation in the launch. The chance of this depends on the percentage of
// users that are allocated to that launch. If the user is enrolled in the launch,
// the variation they are served depends on the allocation of the various feature
// variations used for the launch.
//
// If the user is not assigned to a launch, and there is an ongoing experiment
// for this feature, the user might be assigned to a variation in the experiment.
// The chance of this depends on the percentage of users that are allocated
// to that experiment. If the user is enrolled in the experiment, the variation
// they are served depends on the allocation of the various feature variations
// used for the experiment.
//
// If the user is not assigned to a launch or experiment, they are served the
// default variation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation BatchEvaluateFeature for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/BatchEvaluateFeature
func (c *CloudWatchEvidently) BatchEvaluateFeature(input *BatchEvaluateFeatureInput) (*BatchEvaluateFeatureOutput, error) {
	req, out := c.BatchEvaluateFeatureRequest(input)
	return out, req.Send()
}

// BatchEvaluateFeatureWithContext is the same as BatchEvaluateFeature with the addition of
// the ability to pass a context and additional request options.
//
// See BatchEvaluateFeature for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) BatchEvaluateFeatureWithContext(ctx aws.Context, input *BatchEvaluateFeatureInput, opts ...request.Option) (*BatchEvaluateFeatureOutput, error) {
	req, out := c.BatchEvaluateFeatureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExperiment = "CreateExperiment"

// CreateExperimentRequest generates a "aws/request.Request" representing the
// client's request for the CreateExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExperiment for more information on using the CreateExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateExperimentRequest method.
//	req, resp := client.CreateExperimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateExperiment
func (c *CloudWatchEvidently) CreateExperimentRequest(input *CreateExperimentInput) (req *request.Request, output *CreateExperimentOutput) {
	op := &request.Operation{
		Name:       opCreateExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/experiments",
	}

	if input == nil {
		input = &CreateExperimentInput{}
	}

	output = &CreateExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExperiment API operation for Amazon CloudWatch Evidently.
//
// Creates an Evidently experiment. Before you create an experiment, you must
// create the feature to use for the experiment.
//
// An experiment helps you make feature design decisions based on evidence and
// data. An experiment can test as many as five variations at once. Evidently
// collects experiment data and analyzes it by statistical methods, and provides
// clear recommendations about which variations perform better.
//
// You can optionally specify a segment to have the experiment consider only
// certain audience types in the experiment, such as using only user sessions
// from a certain location or who use a certain internet browser.
//
// Don't use this operation to update an existing experiment. Instead, use UpdateExperiment
// (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateExperiment.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation CreateExperiment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateExperiment
func (c *CloudWatchEvidently) CreateExperiment(input *CreateExperimentInput) (*CreateExperimentOutput, error) {
	req, out := c.CreateExperimentRequest(input)
	return out, req.Send()
}

// CreateExperimentWithContext is the same as CreateExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) CreateExperimentWithContext(ctx aws.Context, input *CreateExperimentInput, opts ...request.Option) (*CreateExperimentOutput, error) {
	req, out := c.CreateExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFeature = "CreateFeature"

// CreateFeatureRequest generates a "aws/request.Request" representing the
// client's request for the CreateFeature operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFeature for more information on using the CreateFeature
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFeatureRequest method.
//	req, resp := client.CreateFeatureRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateFeature
func (c *CloudWatchEvidently) CreateFeatureRequest(input *CreateFeatureInput) (req *request.Request, output *CreateFeatureOutput) {
	op := &request.Operation{
		Name:       opCreateFeature,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/features",
	}

	if input == nil {
		input = &CreateFeatureInput{}
	}

	output = &CreateFeatureOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFeature API operation for Amazon CloudWatch Evidently.
//
// Creates an Evidently feature that you want to launch or test. You can define
// up to five variations of a feature, and use these variations in your launches
// and experiments. A feature must be created in a project. For information
// about creating a project, see CreateProject (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html).
//
// Don't use this operation to update an existing feature. Instead, use UpdateFeature
// (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateFeature.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation CreateFeature for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateFeature
func (c *CloudWatchEvidently) CreateFeature(input *CreateFeatureInput) (*CreateFeatureOutput, error) {
	req, out := c.CreateFeatureRequest(input)
	return out, req.Send()
}

// CreateFeatureWithContext is the same as CreateFeature with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFeature for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) CreateFeatureWithContext(ctx aws.Context, input *CreateFeatureInput, opts ...request.Option) (*CreateFeatureOutput, error) {
	req, out := c.CreateFeatureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLaunch = "CreateLaunch"

// CreateLaunchRequest generates a "aws/request.Request" representing the
// client's request for the CreateLaunch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLaunch for more information on using the CreateLaunch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLaunchRequest method.
//	req, resp := client.CreateLaunchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateLaunch
func (c *CloudWatchEvidently) CreateLaunchRequest(input *CreateLaunchInput) (req *request.Request, output *CreateLaunchOutput) {
	op := &request.Operation{
		Name:       opCreateLaunch,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/launches",
	}

	if input == nil {
		input = &CreateLaunchInput{}
	}

	output = &CreateLaunchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLaunch API operation for Amazon CloudWatch Evidently.
//
// Creates a launch of a given feature. Before you create a launch, you must
// create the feature to use for the launch.
//
// You can use a launch to safely validate new features by serving them to a
// specified percentage of your users while you roll out the feature. You can
// monitor the performance of the new feature to help you decide when to ramp
// up traffic to more users. This helps you reduce risk and identify unintended
// consequences before you fully launch the feature.
//
// Don't use this operation to update an existing launch. Instead, use UpdateLaunch
// (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateLaunch.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation CreateLaunch for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateLaunch
func (c *CloudWatchEvidently) CreateLaunch(input *CreateLaunchInput) (*CreateLaunchOutput, error) {
	req, out := c.CreateLaunchRequest(input)
	return out, req.Send()
}

// CreateLaunchWithContext is the same as CreateLaunch with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLaunch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) CreateLaunchWithContext(ctx aws.Context, input *CreateLaunchInput, opts ...request.Option) (*CreateLaunchOutput, error) {
	req, out := c.CreateLaunchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProjectRequest method.
//	req, resp := client.CreateProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateProject
func (c *CloudWatchEvidently) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/projects",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for Amazon CloudWatch Evidently.
//
// Creates a project, which is the logical object in Evidently that can contain
// features, launches, and experiments. Use projects to group similar features
// together.
//
// To update an existing project, use UpdateProject (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProject.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateProject
func (c *CloudWatchEvidently) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSegment = "CreateSegment"

// CreateSegmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSegment for more information on using the CreateSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSegmentRequest method.
//	req, resp := client.CreateSegmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateSegment
func (c *CloudWatchEvidently) CreateSegmentRequest(input *CreateSegmentInput) (req *request.Request, output *CreateSegmentOutput) {
	op := &request.Operation{
		Name:       opCreateSegment,
		HTTPMethod: "POST",
		HTTPPath:   "/segments",
	}

	if input == nil {
		input = &CreateSegmentInput{}
	}

	output = &CreateSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSegment API operation for Amazon CloudWatch Evidently.
//
// Use this operation to define a segment of your audience. A segment is a portion
// of your audience that share one or more characteristics. Examples could be
// Chrome browser users, users in Europe, or Firefox browser users in Europe
// who also fit other criteria that your application collects, such as age.
//
// Using a segment in an experiment limits that experiment to evaluate only
// the users who match the segment criteria. Using one or more segments in a
// launch allow you to define different traffic splits for the different audience
// segments.
//
//	<p>For more information about segment pattern syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments-syntax.html">
//	Segment rule pattern syntax</a>.</p> <p>The pattern that you define for
//	a segment is matched against the value of <code>evaluationContext</code>,
//	which is passed into Evidently in the <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature</a>
//	operation, when Evidently assigns a feature variation to a user.</p>
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation CreateSegment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateSegment
func (c *CloudWatchEvidently) CreateSegment(input *CreateSegmentInput) (*CreateSegmentOutput, error) {
	req, out := c.CreateSegmentRequest(input)
	return out, req.Send()
}

// CreateSegmentWithContext is the same as CreateSegment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) CreateSegmentWithContext(ctx aws.Context, input *CreateSegmentInput, opts ...request.Option) (*CreateSegmentOutput, error) {
	req, out := c.CreateSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExperiment = "DeleteExperiment"

// DeleteExperimentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExperiment for more information on using the DeleteExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteExperimentRequest method.
//	req, resp := client.DeleteExperimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteExperiment
func (c *CloudWatchEvidently) DeleteExperimentRequest(input *DeleteExperimentInput) (req *request.Request, output *DeleteExperimentOutput) {
	op := &request.Operation{
		Name:       opDeleteExperiment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{project}/experiments/{experiment}",
	}

	if input == nil {
		input = &DeleteExperimentInput{}
	}

	output = &DeleteExperimentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteExperiment API operation for Amazon CloudWatch Evidently.
//
// Deletes an Evidently experiment. The feature used for the experiment is not
// deleted.
//
// To stop an experiment without deleting it, use StopExperiment (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopExperiment.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation DeleteExperiment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceUnavailableException
//     The service was unavailable. Retry the request.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteExperiment
func (c *CloudWatchEvidently) DeleteExperiment(input *DeleteExperimentInput) (*DeleteExperimentOutput, error) {
	req, out := c.DeleteExperimentRequest(input)
	return out, req.Send()
}

// DeleteExperimentWithContext is the same as DeleteExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) DeleteExperimentWithContext(ctx aws.Context, input *DeleteExperimentInput, opts ...request.Option) (*DeleteExperimentOutput, error) {
	req, out := c.DeleteExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFeature = "DeleteFeature"

// DeleteFeatureRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFeature operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFeature for more information on using the DeleteFeature
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFeatureRequest method.
//	req, resp := client.DeleteFeatureRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteFeature
func (c *CloudWatchEvidently) DeleteFeatureRequest(input *DeleteFeatureInput) (req *request.Request, output *DeleteFeatureOutput) {
	op := &request.Operation{
		Name:       opDeleteFeature,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{project}/features/{feature}",
	}

	if input == nil {
		input = &DeleteFeatureInput{}
	}

	output = &DeleteFeatureOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFeature API operation for Amazon CloudWatch Evidently.
//
// Deletes an Evidently feature.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation DeleteFeature for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteFeature
func (c *CloudWatchEvidently) DeleteFeature(input *DeleteFeatureInput) (*DeleteFeatureOutput, error) {
	req, out := c.DeleteFeatureRequest(input)
	return out, req.Send()
}

// DeleteFeatureWithContext is the same as DeleteFeature with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFeature for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) DeleteFeatureWithContext(ctx aws.Context, input *DeleteFeatureInput, opts ...request.Option) (*DeleteFeatureOutput, error) {
	req, out := c.DeleteFeatureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunch = "DeleteLaunch"

// DeleteLaunchRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunch for more information on using the DeleteLaunch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLaunchRequest method.
//	req, resp := client.DeleteLaunchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteLaunch
func (c *CloudWatchEvidently) DeleteLaunchRequest(input *DeleteLaunchInput) (req *request.Request, output *DeleteLaunchOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunch,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{project}/launches/{launch}",
	}

	if input == nil {
		input = &DeleteLaunchInput{}
	}

	output = &DeleteLaunchOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLaunch API operation for Amazon CloudWatch Evidently.
//
// Deletes an Evidently launch. The feature used for the launch is not deleted.
//
// To stop a launch without deleting it, use StopLaunch (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopLaunch.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation DeleteLaunch for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteLaunch
func (c *CloudWatchEvidently) DeleteLaunch(input *DeleteLaunchInput) (*DeleteLaunchOutput, error) {
	req, out := c.DeleteLaunchRequest(input)
	return out, req.Send()
}

// DeleteLaunchWithContext is the same as DeleteLaunch with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) DeleteLaunchWithContext(ctx aws.Context, input *DeleteLaunchInput, opts ...request.Option) (*DeleteLaunchOutput, error) {
	req, out := c.DeleteLaunchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProjectRequest method.
//	req, resp := client.DeleteProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteProject
func (c *CloudWatchEvidently) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{project}",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProject API operation for Amazon CloudWatch Evidently.
//
// Deletes an Evidently project. Before you can delete a project, you must delete
// all the features that the project contains. To delete a feature, use DeleteFeature
// (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteFeature.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteProject
func (c *CloudWatchEvidently) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSegment = "DeleteSegment"

// DeleteSegmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSegment for more information on using the DeleteSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSegmentRequest method.
//	req, resp := client.DeleteSegmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteSegment
func (c *CloudWatchEvidently) DeleteSegmentRequest(input *DeleteSegmentInput) (req *request.Request, output *DeleteSegmentOutput) {
	op := &request.Operation{
		Name:       opDeleteSegment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/segments/{segment}",
	}

	if input == nil {
		input = &DeleteSegmentInput{}
	}

	output = &DeleteSegmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSegment API operation for Amazon CloudWatch Evidently.
//
// Deletes a segment. You can't delete a segment that is being used in a launch
// or experiment, even if that launch or experiment is not currently running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation DeleteSegment for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteSegment
func (c *CloudWatchEvidently) DeleteSegment(input *DeleteSegmentInput) (*DeleteSegmentOutput, error) {
	req, out := c.DeleteSegmentRequest(input)
	return out, req.Send()
}

// DeleteSegmentWithContext is the same as DeleteSegment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) DeleteSegmentWithContext(ctx aws.Context, input *DeleteSegmentInput, opts ...request.Option) (*DeleteSegmentOutput, error) {
	req, out := c.DeleteSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEvaluateFeature = "EvaluateFeature"

// EvaluateFeatureRequest generates a "aws/request.Request" representing the
// client's request for the EvaluateFeature operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EvaluateFeature for more information on using the EvaluateFeature
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EvaluateFeatureRequest method.
//	req, resp := client.EvaluateFeatureRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/EvaluateFeature
func (c *CloudWatchEvidently) EvaluateFeatureRequest(input *EvaluateFeatureInput) (req *request.Request, output *EvaluateFeatureOutput) {
	op := &request.Operation{
		Name:       opEvaluateFeature,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/evaluations/{feature}",
	}

	if input == nil {
		input = &EvaluateFeatureInput{}
	}

	output = &EvaluateFeatureOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("dataplane.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// EvaluateFeature API operation for Amazon CloudWatch Evidently.
//
// This operation assigns a feature variation to one given user session. You
// pass in an entityID that represents the user. Evidently then checks the evaluation
// rules and assigns the variation.
//
// The first rules that are evaluated are the override rules. If the user's
// entityID matches an override rule, the user is served the variation specified
// by that rule.
//
//	<p>If there is a current launch with this feature that uses segment overrides,
//	and if the user session's <code>evaluationContext</code> matches a segment
//	rule defined in a segment override, the configuration in the segment overrides
//	is used. For more information about segments, see <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateSegment.html">CreateSegment</a>
//	and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html">Use
//	segments to focus your audience</a>.</p> <p>If there is a launch with
//	no segment overrides, the user might be assigned to a variation in the
//	launch. The chance of this depends on the percentage of users that are
//	allocated to that launch. If the user is enrolled in the launch, the variation
//	they are served depends on the allocation of the various feature variations
//	used for the launch.</p> <p>If the user is not assigned to a launch, and
//	there is an ongoing experiment for this feature, the user might be assigned
//	to a variation in the experiment. The chance of this depends on the percentage
//	of users that are allocated to that experiment.</p> <p>If the experiment
//	uses a segment, then only user sessions with <code>evaluationContext</code>
//	values that match the segment rule are used in the experiment.</p> <p>If
//	the user is enrolled in the experiment, the variation they are served
//	depends on the allocation of the various feature variations used for the
//	experiment. </p> <p>If the user is not assigned to a launch or experiment,
//	they are served the default variation.</p>
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation EvaluateFeature for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/EvaluateFeature
func (c *CloudWatchEvidently) EvaluateFeature(input *EvaluateFeatureInput) (*EvaluateFeatureOutput, error) {
	req, out := c.EvaluateFeatureRequest(input)
	return out, req.Send()
}

// EvaluateFeatureWithContext is the same as EvaluateFeature with the addition of
// the ability to pass a context and additional request options.
//
// See EvaluateFeature for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) EvaluateFeatureWithContext(ctx aws.Context, input *EvaluateFeatureInput, opts ...request.Option) (*EvaluateFeatureOutput, error) {
	req, out := c.EvaluateFeatureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExperiment = "GetExperiment"

// GetExperimentRequest generates a "aws/request.Request" representing the
// client's request for the GetExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExperiment for more information on using the GetExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExperimentRequest method.
//	req, resp := client.GetExperimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetExperiment
func (c *CloudWatchEvidently) GetExperimentRequest(input *GetExperimentInput) (req *request.Request, output *GetExperimentOutput) {
	op := &request.Operation{
		Name:       opGetExperiment,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{project}/experiments/{experiment}",
	}

	if input == nil {
		input = &GetExperimentInput{}
	}

	output = &GetExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExperiment API operation for Amazon CloudWatch Evidently.
//
// Returns the details about one experiment. You must already know the experiment
// name. To retrieve a list of experiments in your account, use ListExperiments
// (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListExperiments.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation GetExperiment for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetExperiment
func (c *CloudWatchEvidently) GetExperiment(input *GetExperimentInput) (*GetExperimentOutput, error) {
	req, out := c.GetExperimentRequest(input)
	return out, req.Send()
}

// GetExperimentWithContext is the same as GetExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See GetExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) GetExperimentWithContext(ctx aws.Context, input *GetExperimentInput, opts ...request.Option) (*GetExperimentOutput, error) {
	req, out := c.GetExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExperimentResults = "GetExperimentResults"

// GetExperimentResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetExperimentResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExperimentResults for more information on using the GetExperimentResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExperimentResultsRequest method.
//	req, resp := client.GetExperimentResultsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetExperimentResults
func (c *CloudWatchEvidently) GetExperimentResultsRequest(input *GetExperimentResultsInput) (req *request.Request, output *GetExperimentResultsOutput) {
	op := &request.Operation{
		Name:       opGetExperimentResults,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/experiments/{experiment}/results",
	}

	if input == nil {
		input = &GetExperimentResultsInput{}
	}

	output = &GetExperimentResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExperimentResults API operation for Amazon CloudWatch Evidently.
//
// Retrieves the results of a running or completed experiment. No results are
// available until there have been 100 events for each variation and at least
// 10 minutes have passed since the start of the experiment.
//
// Experiment results are available up to 63 days after the start of the experiment.
// They are not available after that because of CloudWatch data retention policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation GetExperimentResults for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetExperimentResults
func (c *CloudWatchEvidently) GetExperimentResults(input *GetExperimentResultsInput) (*GetExperimentResultsOutput, error) {
	req, out := c.GetExperimentResultsRequest(input)
	return out, req.Send()
}

// GetExperimentResultsWithContext is the same as GetExperimentResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetExperimentResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) GetExperimentResultsWithContext(ctx aws.Context, input *GetExperimentResultsInput, opts ...request.Option) (*GetExperimentResultsOutput, error) {
	req, out := c.GetExperimentResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFeature = "GetFeature"

// GetFeatureRequest generates a "aws/request.Request" representing the
// client's request for the GetFeature operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFeature for more information on using the GetFeature
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFeatureRequest method.
//	req, resp := client.GetFeatureRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetFeature
func (c *CloudWatchEvidently) GetFeatureRequest(input *GetFeatureInput) (req *request.Request, output *GetFeatureOutput) {
	op := &request.Operation{
		Name:       opGetFeature,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{project}/features/{feature}",
	}

	if input == nil {
		input = &GetFeatureInput{}
	}

	output = &GetFeatureOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFeature API operation for Amazon CloudWatch Evidently.
//
// Returns the details about one feature. You must already know the feature
// name. To retrieve a list of features in your account, use ListFeatures (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListFeatures.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation GetFeature for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetFeature
func (c *CloudWatchEvidently) GetFeature(input *GetFeatureInput) (*GetFeatureOutput, error) {
	req, out := c.GetFeatureRequest(input)
	return out, req.Send()
}

// GetFeatureWithContext is the same as GetFeature with the addition of
// the ability to pass a context and additional request options.
//
// See GetFeature for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) GetFeatureWithContext(ctx aws.Context, input *GetFeatureInput, opts ...request.Option) (*GetFeatureOutput, error) {
	req, out := c.GetFeatureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLaunch = "GetLaunch"

// GetLaunchRequest generates a "aws/request.Request" representing the
// client's request for the GetLaunch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLaunch for more information on using the GetLaunch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLaunchRequest method.
//	req, resp := client.GetLaunchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetLaunch
func (c *CloudWatchEvidently) GetLaunchRequest(input *GetLaunchInput) (req *request.Request, output *GetLaunchOutput) {
	op := &request.Operation{
		Name:       opGetLaunch,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{project}/launches/{launch}",
	}

	if input == nil {
		input = &GetLaunchInput{}
	}

	output = &GetLaunchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLaunch API operation for Amazon CloudWatch Evidently.
//
// Returns the details about one launch. You must already know the launch name.
// To retrieve a list of launches in your account, use ListLaunches (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListLaunches.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation GetLaunch for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetLaunch
func (c *CloudWatchEvidently) GetLaunch(input *GetLaunchInput) (*GetLaunchOutput, error) {
	req, out := c.GetLaunchRequest(input)
	return out, req.Send()
}

// GetLaunchWithContext is the same as GetLaunch with the addition of
// the ability to pass a context and additional request options.
//
// See GetLaunch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) GetLaunchWithContext(ctx aws.Context, input *GetLaunchInput, opts ...request.Option) (*GetLaunchOutput, error) {
	req, out := c.GetLaunchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProject = "GetProject"

// GetProjectRequest generates a "aws/request.Request" representing the
// client's request for the GetProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProject for more information on using the GetProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProjectRequest method.
//	req, resp := client.GetProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetProject
func (c *CloudWatchEvidently) GetProjectRequest(input *GetProjectInput) (req *request.Request, output *GetProjectOutput) {
	op := &request.Operation{
		Name:       opGetProject,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{project}",
	}

	if input == nil {
		input = &GetProjectInput{}
	}

	output = &GetProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProject API operation for Amazon CloudWatch Evidently.
//
// Returns the details about one launch. You must already know the project name.
// To retrieve a list of projects in your account, use ListProjects (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListProjects.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation GetProject for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetProject
func (c *CloudWatchEvidently) GetProject(input *GetProjectInput) (*GetProjectOutput, error) {
	req, out := c.GetProjectRequest(input)
	return out, req.Send()
}

// GetProjectWithContext is the same as GetProject with the addition of
// the ability to pass a context and additional request options.
//
// See GetProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) GetProjectWithContext(ctx aws.Context, input *GetProjectInput, opts ...request.Option) (*GetProjectOutput, error) {
	req, out := c.GetProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegment = "GetSegment"

// GetSegmentRequest generates a "aws/request.Request" representing the
// client's request for the GetSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegment for more information on using the GetSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSegmentRequest method.
//	req, resp := client.GetSegmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetSegment
func (c *CloudWatchEvidently) GetSegmentRequest(input *GetSegmentInput) (req *request.Request, output *GetSegmentOutput) {
	op := &request.Operation{
		Name:       opGetSegment,
		HTTPMethod: "GET",
		HTTPPath:   "/segments/{segment}",
	}

	if input == nil {
		input = &GetSegmentInput{}
	}

	output = &GetSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegment API operation for Amazon CloudWatch Evidently.
//
// Returns information about the specified segment. Specify the segment you
// want to view by specifying its ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation GetSegment for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetSegment
func (c *CloudWatchEvidently) GetSegment(input *GetSegmentInput) (*GetSegmentOutput, error) {
	req, out := c.GetSegmentRequest(input)
	return out, req.Send()
}

// GetSegmentWithContext is the same as GetSegment with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) GetSegmentWithContext(ctx aws.Context, input *GetSegmentInput, opts ...request.Option) (*GetSegmentOutput, error) {
	req, out := c.GetSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListExperiments = "ListExperiments"

// ListExperimentsRequest generates a "aws/request.Request" representing the
// client's request for the ListExperiments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExperiments for more information on using the ListExperiments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExperimentsRequest method.
//	req, resp := client.ListExperimentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListExperiments
func (c *CloudWatchEvidently) ListExperimentsRequest(input *ListExperimentsInput) (req *request.Request, output *ListExperimentsOutput) {
	op := &request.Operation{
		Name:       opListExperiments,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{project}/experiments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExperimentsInput{}
	}

	output = &ListExperimentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExperiments API operation for Amazon CloudWatch Evidently.
//
// Returns configuration details about all the experiments in the specified
// project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation ListExperiments for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListExperiments
func (c *CloudWatchEvidently) ListExperiments(input *ListExperimentsInput) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	return out, req.Send()
}

// ListExperimentsWithContext is the same as ListExperiments with the addition of
// the ability to pass a context and additional request options.
//
// See ListExperiments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListExperimentsWithContext(ctx aws.Context, input *ListExperimentsInput, opts ...request.Option) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExperimentsPages iterates over the pages of a ListExperiments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExperiments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExperiments operation.
//	pageNum := 0
//	err := client.ListExperimentsPages(params,
//	    func(page *cloudwatchevidently.ListExperimentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatchEvidently) ListExperimentsPages(input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool) error {
	return c.ListExperimentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExperimentsPagesWithContext same as ListExperimentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListExperimentsPagesWithContext(ctx aws.Context, input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExperimentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExperimentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExperimentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFeatures = "ListFeatures"

// ListFeaturesRequest generates a "aws/request.Request" representing the
// client's request for the ListFeatures operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFeatures for more information on using the ListFeatures
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFeaturesRequest method.
//	req, resp := client.ListFeaturesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListFeatures
func (c *CloudWatchEvidently) ListFeaturesRequest(input *ListFeaturesInput) (req *request.Request, output *ListFeaturesOutput) {
	op := &request.Operation{
		Name:       opListFeatures,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{project}/features",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFeaturesInput{}
	}

	output = &ListFeaturesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFeatures API operation for Amazon CloudWatch Evidently.
//
// Returns configuration details about all the features in the specified project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation ListFeatures for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListFeatures
func (c *CloudWatchEvidently) ListFeatures(input *ListFeaturesInput) (*ListFeaturesOutput, error) {
	req, out := c.ListFeaturesRequest(input)
	return out, req.Send()
}

// ListFeaturesWithContext is the same as ListFeatures with the addition of
// the ability to pass a context and additional request options.
//
// See ListFeatures for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListFeaturesWithContext(ctx aws.Context, input *ListFeaturesInput, opts ...request.Option) (*ListFeaturesOutput, error) {
	req, out := c.ListFeaturesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFeaturesPages iterates over the pages of a ListFeatures operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFeatures method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFeatures operation.
//	pageNum := 0
//	err := client.ListFeaturesPages(params,
//	    func(page *cloudwatchevidently.ListFeaturesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatchEvidently) ListFeaturesPages(input *ListFeaturesInput, fn func(*ListFeaturesOutput, bool) bool) error {
	return c.ListFeaturesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFeaturesPagesWithContext same as ListFeaturesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListFeaturesPagesWithContext(ctx aws.Context, input *ListFeaturesInput, fn func(*ListFeaturesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFeaturesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFeaturesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFeaturesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLaunches = "ListLaunches"

// ListLaunchesRequest generates a "aws/request.Request" representing the
// client's request for the ListLaunches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLaunches for more information on using the ListLaunches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLaunchesRequest method.
//	req, resp := client.ListLaunchesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListLaunches
func (c *CloudWatchEvidently) ListLaunchesRequest(input *ListLaunchesInput) (req *request.Request, output *ListLaunchesOutput) {
	op := &request.Operation{
		Name:       opListLaunches,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{project}/launches",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLaunchesInput{}
	}

	output = &ListLaunchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLaunches API operation for Amazon CloudWatch Evidently.
//
// Returns configuration details about all the launches in the specified project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation ListLaunches for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListLaunches
func (c *CloudWatchEvidently) ListLaunches(input *ListLaunchesInput) (*ListLaunchesOutput, error) {
	req, out := c.ListLaunchesRequest(input)
	return out, req.Send()
}

// ListLaunchesWithContext is the same as ListLaunches with the addition of
// the ability to pass a context and additional request options.
//
// See ListLaunches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListLaunchesWithContext(ctx aws.Context, input *ListLaunchesInput, opts ...request.Option) (*ListLaunchesOutput, error) {
	req, out := c.ListLaunchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLaunchesPages iterates over the pages of a ListLaunches operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLaunches method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLaunches operation.
//	pageNum := 0
//	err := client.ListLaunchesPages(params,
//	    func(page *cloudwatchevidently.ListLaunchesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatchEvidently) ListLaunchesPages(input *ListLaunchesInput, fn func(*ListLaunchesOutput, bool) bool) error {
	return c.ListLaunchesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLaunchesPagesWithContext same as ListLaunchesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListLaunchesPagesWithContext(ctx aws.Context, input *ListLaunchesInput, fn func(*ListLaunchesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLaunchesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLaunchesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLaunchesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProjectsRequest method.
//	req, resp := client.ListProjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListProjects
func (c *CloudWatchEvidently) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "GET",
		HTTPPath:   "/projects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for Amazon CloudWatch Evidently.
//
// Returns configuration details about all the projects in the current Region
// in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListProjects
func (c *CloudWatchEvidently) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProjects operation.
//	pageNum := 0
//	err := client.ListProjectsPages(params,
//	    func(page *cloudwatchevidently.ListProjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatchEvidently) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSegmentReferences = "ListSegmentReferences"

// ListSegmentReferencesRequest generates a "aws/request.Request" representing the
// client's request for the ListSegmentReferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSegmentReferences for more information on using the ListSegmentReferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSegmentReferencesRequest method.
//	req, resp := client.ListSegmentReferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListSegmentReferences
func (c *CloudWatchEvidently) ListSegmentReferencesRequest(input *ListSegmentReferencesInput) (req *request.Request, output *ListSegmentReferencesOutput) {
	op := &request.Operation{
		Name:       opListSegmentReferences,
		HTTPMethod: "GET",
		HTTPPath:   "/segments/{segment}/references",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSegmentReferencesInput{}
	}

	output = &ListSegmentReferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSegmentReferences API operation for Amazon CloudWatch Evidently.
//
// Use this operation to find which experiments or launches are using a specified
// segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation ListSegmentReferences for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListSegmentReferences
func (c *CloudWatchEvidently) ListSegmentReferences(input *ListSegmentReferencesInput) (*ListSegmentReferencesOutput, error) {
	req, out := c.ListSegmentReferencesRequest(input)
	return out, req.Send()
}

// ListSegmentReferencesWithContext is the same as ListSegmentReferences with the addition of
// the ability to pass a context and additional request options.
//
// See ListSegmentReferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListSegmentReferencesWithContext(ctx aws.Context, input *ListSegmentReferencesInput, opts ...request.Option) (*ListSegmentReferencesOutput, error) {
	req, out := c.ListSegmentReferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSegmentReferencesPages iterates over the pages of a ListSegmentReferences operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSegmentReferences method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSegmentReferences operation.
//	pageNum := 0
//	err := client.ListSegmentReferencesPages(params,
//	    func(page *cloudwatchevidently.ListSegmentReferencesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatchEvidently) ListSegmentReferencesPages(input *ListSegmentReferencesInput, fn func(*ListSegmentReferencesOutput, bool) bool) error {
	return c.ListSegmentReferencesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSegmentReferencesPagesWithContext same as ListSegmentReferencesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListSegmentReferencesPagesWithContext(ctx aws.Context, input *ListSegmentReferencesInput, fn func(*ListSegmentReferencesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSegmentReferencesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSegmentReferencesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSegmentReferencesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSegments = "ListSegments"

// ListSegmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListSegments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSegments for more information on using the ListSegments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSegmentsRequest method.
//	req, resp := client.ListSegmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListSegments
func (c *CloudWatchEvidently) ListSegmentsRequest(input *ListSegmentsInput) (req *request.Request, output *ListSegmentsOutput) {
	op := &request.Operation{
		Name:       opListSegments,
		HTTPMethod: "GET",
		HTTPPath:   "/segments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSegmentsInput{}
	}

	output = &ListSegmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSegments API operation for Amazon CloudWatch Evidently.
//
// Returns a list of audience segments that you have created in your account
// in this Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation ListSegments for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListSegments
func (c *CloudWatchEvidently) ListSegments(input *ListSegmentsInput) (*ListSegmentsOutput, error) {
	req, out := c.ListSegmentsRequest(input)
	return out, req.Send()
}

// ListSegmentsWithContext is the same as ListSegments with the addition of
// the ability to pass a context and additional request options.
//
// See ListSegments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListSegmentsWithContext(ctx aws.Context, input *ListSegmentsInput, opts ...request.Option) (*ListSegmentsOutput, error) {
	req, out := c.ListSegmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSegmentsPages iterates over the pages of a ListSegments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSegments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSegments operation.
//	pageNum := 0
//	err := client.ListSegmentsPages(params,
//	    func(page *cloudwatchevidently.ListSegmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatchEvidently) ListSegmentsPages(input *ListSegmentsInput, fn func(*ListSegmentsOutput, bool) bool) error {
	return c.ListSegmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSegmentsPagesWithContext same as ListSegmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListSegmentsPagesWithContext(ctx aws.Context, input *ListSegmentsInput, fn func(*ListSegmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSegmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSegmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSegmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListTagsForResource
func (c *CloudWatchEvidently) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudWatch Evidently.
//
// Displays the tags associated with an Evidently resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListTagsForResource
func (c *CloudWatchEvidently) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutProjectEvents = "PutProjectEvents"

// PutProjectEventsRequest generates a "aws/request.Request" representing the
// client's request for the PutProjectEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutProjectEvents for more information on using the PutProjectEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutProjectEventsRequest method.
//	req, resp := client.PutProjectEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/PutProjectEvents
func (c *CloudWatchEvidently) PutProjectEventsRequest(input *PutProjectEventsInput) (req *request.Request, output *PutProjectEventsOutput) {
	op := &request.Operation{
		Name:       opPutProjectEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/events/projects/{project}",
	}

	if input == nil {
		input = &PutProjectEventsInput{}
	}

	output = &PutProjectEventsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("dataplane.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutProjectEvents API operation for Amazon CloudWatch Evidently.
//
// Sends performance events to Evidently. These events can be used to evaluate
// a launch or an experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation PutProjectEvents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/PutProjectEvents
func (c *CloudWatchEvidently) PutProjectEvents(input *PutProjectEventsInput) (*PutProjectEventsOutput, error) {
	req, out := c.PutProjectEventsRequest(input)
	return out, req.Send()
}

// PutProjectEventsWithContext is the same as PutProjectEvents with the addition of
// the ability to pass a context and additional request options.
//
// See PutProjectEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) PutProjectEventsWithContext(ctx aws.Context, input *PutProjectEventsInput, opts ...request.Option) (*PutProjectEventsOutput, error) {
	req, out := c.PutProjectEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExperiment = "StartExperiment"

// StartExperimentRequest generates a "aws/request.Request" representing the
// client's request for the StartExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExperiment for more information on using the StartExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartExperimentRequest method.
//	req, resp := client.StartExperimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StartExperiment
func (c *CloudWatchEvidently) StartExperimentRequest(input *StartExperimentInput) (req *request.Request, output *StartExperimentOutput) {
	op := &request.Operation{
		Name:       opStartExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/experiments/{experiment}/start",
	}

	if input == nil {
		input = &StartExperimentInput{}
	}

	output = &StartExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExperiment API operation for Amazon CloudWatch Evidently.
//
// Starts an existing experiment. To create an experiment, use CreateExperiment
// (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateExperiment.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation StartExperiment for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StartExperiment
func (c *CloudWatchEvidently) StartExperiment(input *StartExperimentInput) (*StartExperimentOutput, error) {
	req, out := c.StartExperimentRequest(input)
	return out, req.Send()
}

// StartExperimentWithContext is the same as StartExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See StartExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) StartExperimentWithContext(ctx aws.Context, input *StartExperimentInput, opts ...request.Option) (*StartExperimentOutput, error) {
	req, out := c.StartExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartLaunch = "StartLaunch"

// StartLaunchRequest generates a "aws/request.Request" representing the
// client's request for the StartLaunch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartLaunch for more information on using the StartLaunch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartLaunchRequest method.
//	req, resp := client.StartLaunchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StartLaunch
func (c *CloudWatchEvidently) StartLaunchRequest(input *StartLaunchInput) (req *request.Request, output *StartLaunchOutput) {
	op := &request.Operation{
		Name:       opStartLaunch,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/launches/{launch}/start",
	}

	if input == nil {
		input = &StartLaunchInput{}
	}

	output = &StartLaunchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartLaunch API operation for Amazon CloudWatch Evidently.
//
// Starts an existing launch. To create a launch, use CreateLaunch (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateLaunch.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation StartLaunch for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StartLaunch
func (c *CloudWatchEvidently) StartLaunch(input *StartLaunchInput) (*StartLaunchOutput, error) {
	req, out := c.StartLaunchRequest(input)
	return out, req.Send()
}

// StartLaunchWithContext is the same as StartLaunch with the addition of
// the ability to pass a context and additional request options.
//
// See StartLaunch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) StartLaunchWithContext(ctx aws.Context, input *StartLaunchInput, opts ...request.Option) (*StartLaunchOutput, error) {
	req, out := c.StartLaunchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopExperiment = "StopExperiment"

// StopExperimentRequest generates a "aws/request.Request" representing the
// client's request for the StopExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopExperiment for more information on using the StopExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopExperimentRequest method.
//	req, resp := client.StopExperimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StopExperiment
func (c *CloudWatchEvidently) StopExperimentRequest(input *StopExperimentInput) (req *request.Request, output *StopExperimentOutput) {
	op := &request.Operation{
		Name:       opStopExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/experiments/{experiment}/cancel",
	}

	if input == nil {
		input = &StopExperimentInput{}
	}

	output = &StopExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopExperiment API operation for Amazon CloudWatch Evidently.
//
// Stops an experiment that is currently running. If you stop an experiment,
// you can't resume it or restart it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation StopExperiment for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StopExperiment
func (c *CloudWatchEvidently) StopExperiment(input *StopExperimentInput) (*StopExperimentOutput, error) {
	req, out := c.StopExperimentRequest(input)
	return out, req.Send()
}

// StopExperimentWithContext is the same as StopExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See StopExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) StopExperimentWithContext(ctx aws.Context, input *StopExperimentInput, opts ...request.Option) (*StopExperimentOutput, error) {
	req, out := c.StopExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopLaunch = "StopLaunch"

// StopLaunchRequest generates a "aws/request.Request" representing the
// client's request for the StopLaunch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopLaunch for more information on using the StopLaunch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopLaunchRequest method.
//	req, resp := client.StopLaunchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StopLaunch
func (c *CloudWatchEvidently) StopLaunchRequest(input *StopLaunchInput) (req *request.Request, output *StopLaunchOutput) {
	op := &request.Operation{
		Name:       opStopLaunch,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{project}/launches/{launch}/cancel",
	}

	if input == nil {
		input = &StopLaunchInput{}
	}

	output = &StopLaunchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopLaunch API operation for Amazon CloudWatch Evidently.
//
// Stops a launch that is currently running. After you stop a launch, you will
// not be able to resume it or restart it. Also, it will not be evaluated as
// a rule for traffic allocation, and the traffic that was allocated to the
// launch will instead be available to the feature's experiment, if there is
// one. Otherwise, all traffic will be served the default variation after the
// launch is stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation StopLaunch for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StopLaunch
func (c *CloudWatchEvidently) StopLaunch(input *StopLaunchInput) (*StopLaunchOutput, error) {
	req, out := c.StopLaunchRequest(input)
	return out, req.Send()
}

// StopLaunchWithContext is the same as StopLaunch with the addition of
// the ability to pass a context and additional request options.
//
// See StopLaunch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) StopLaunchWithContext(ctx aws.Context, input *StopLaunchInput, opts ...request.Option) (*StopLaunchOutput, error) {
	req, out := c.StopLaunchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/TagResource
func (c *CloudWatchEvidently) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CloudWatch Evidently.
//
// Assigns one or more tags (key-value pairs) to the specified CloudWatch Evidently
// resource. Projects, features, launches, and experiments can be tagged.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions by granting a user permission to access or
// change only resources with certain tag values.
//
// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
// strictly as strings of characters.
//
// You can use the TagResource action with a resource that already has tags.
// If you specify a new tag key for the resource, this tag is appended to the
// list of tags associated with the alarm. If you specify a tag key that is
// already associated with the resource, the new tag value that you specify
// replaces the previous value for that tag.
//
// You can associate as many as 50 tags with a resource.
//
// For more information, see Tagging Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/TagResource
func (c *CloudWatchEvidently) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestSegmentPattern = "TestSegmentPattern"

// TestSegmentPatternRequest generates a "aws/request.Request" representing the
// client's request for the TestSegmentPattern operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestSegmentPattern for more information on using the TestSegmentPattern
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TestSegmentPatternRequest method.
//	req, resp := client.TestSegmentPatternRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/TestSegmentPattern
func (c *CloudWatchEvidently) TestSegmentPatternRequest(input *TestSegmentPatternInput) (req *request.Request, output *TestSegmentPatternOutput) {
	op := &request.Operation{
		Name:       opTestSegmentPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/test-segment-pattern",
	}

	if input == nil {
		input = &TestSegmentPatternInput{}
	}

	output = &TestSegmentPatternOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestSegmentPattern API operation for Amazon CloudWatch Evidently.
//
// Use this operation to test a rules pattern that you plan to use to create
// an audience segment. For more information about segments, see CreateSegment
// (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateSegment.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation TestSegmentPattern for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/TestSegmentPattern
func (c *CloudWatchEvidently) TestSegmentPattern(input *TestSegmentPatternInput) (*TestSegmentPatternOutput, error) {
	req, out := c.TestSegmentPatternRequest(input)
	return out, req.Send()
}

// TestSegmentPatternWithContext is the same as TestSegmentPattern with the addition of
// the ability to pass a context and additional request options.
//
// See TestSegmentPattern for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) TestSegmentPatternWithContext(ctx aws.Context, input *TestSegmentPatternInput, opts ...request.Option) (*TestSegmentPatternOutput, error) {
	req, out := c.TestSegmentPatternRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UntagResource
func (c *CloudWatchEvidently) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CloudWatch Evidently.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UntagResource
func (c *CloudWatchEvidently) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExperiment = "UpdateExperiment"

// UpdateExperimentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExperiment for more information on using the UpdateExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateExperimentRequest method.
//	req, resp := client.UpdateExperimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateExperiment
func (c *CloudWatchEvidently) UpdateExperimentRequest(input *UpdateExperimentInput) (req *request.Request, output *UpdateExperimentOutput) {
	op := &request.Operation{
		Name:       opUpdateExperiment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/projects/{project}/experiments/{experiment}",
	}

	if input == nil {
		input = &UpdateExperimentInput{}
	}

	output = &UpdateExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExperiment API operation for Amazon CloudWatch Evidently.
//
// Updates an Evidently experiment.
//
// Don't use this operation to update an experiment's tag. Instead, use TagResource
// (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation UpdateExperiment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateExperiment
func (c *CloudWatchEvidently) UpdateExperiment(input *UpdateExperimentInput) (*UpdateExperimentOutput, error) {
	req, out := c.UpdateExperimentRequest(input)
	return out, req.Send()
}

// UpdateExperimentWithContext is the same as UpdateExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) UpdateExperimentWithContext(ctx aws.Context, input *UpdateExperimentInput, opts ...request.Option) (*UpdateExperimentOutput, error) {
	req, out := c.UpdateExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFeature = "UpdateFeature"

// UpdateFeatureRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFeature operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFeature for more information on using the UpdateFeature
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFeatureRequest method.
//	req, resp := client.UpdateFeatureRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateFeature
func (c *CloudWatchEvidently) UpdateFeatureRequest(input *UpdateFeatureInput) (req *request.Request, output *UpdateFeatureOutput) {
	op := &request.Operation{
		Name:       opUpdateFeature,
		HTTPMethod: "PATCH",
		HTTPPath:   "/projects/{project}/features/{feature}",
	}

	if input == nil {
		input = &UpdateFeatureInput{}
	}

	output = &UpdateFeatureOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFeature API operation for Amazon CloudWatch Evidently.
//
// Updates an existing feature.
//
// You can't use this operation to update the tags of an existing feature. Instead,
// use TagResource (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation UpdateFeature for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateFeature
func (c *CloudWatchEvidently) UpdateFeature(input *UpdateFeatureInput) (*UpdateFeatureOutput, error) {
	req, out := c.UpdateFeatureRequest(input)
	return out, req.Send()
}

// UpdateFeatureWithContext is the same as UpdateFeature with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFeature for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) UpdateFeatureWithContext(ctx aws.Context, input *UpdateFeatureInput, opts ...request.Option) (*UpdateFeatureOutput, error) {
	req, out := c.UpdateFeatureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLaunch = "UpdateLaunch"

// UpdateLaunchRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLaunch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLaunch for more information on using the UpdateLaunch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLaunchRequest method.
//	req, resp := client.UpdateLaunchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateLaunch
func (c *CloudWatchEvidently) UpdateLaunchRequest(input *UpdateLaunchInput) (req *request.Request, output *UpdateLaunchOutput) {
	op := &request.Operation{
		Name:       opUpdateLaunch,
		HTTPMethod: "PATCH",
		HTTPPath:   "/projects/{project}/launches/{launch}",
	}

	if input == nil {
		input = &UpdateLaunchInput{}
	}

	output = &UpdateLaunchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLaunch API operation for Amazon CloudWatch Evidently.
//
// Updates a launch of a given feature.
//
// Don't use this operation to update the tags of an existing launch. Instead,
// use TagResource (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation UpdateLaunch for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateLaunch
func (c *CloudWatchEvidently) UpdateLaunch(input *UpdateLaunchInput) (*UpdateLaunchOutput, error) {
	req, out := c.UpdateLaunchRequest(input)
	return out, req.Send()
}

// UpdateLaunchWithContext is the same as UpdateLaunch with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLaunch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) UpdateLaunchWithContext(ctx aws.Context, input *UpdateLaunchInput, opts ...request.Option) (*UpdateLaunchOutput, error) {
	req, out := c.UpdateLaunchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProjectRequest method.
//	req, resp := client.UpdateProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateProject
func (c *CloudWatchEvidently) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "PATCH",
		HTTPPath:   "/projects/{project}",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for Amazon CloudWatch Evidently.
//
// Updates the description of an existing project.
//
// To create a new project, use CreateProject (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html).
//
// Don't use this operation to update the data storage options of a project.
// Instead, use UpdateProjectDataDelivery (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProjectDataDelivery.html).
//
// Don't use this operation to update the tags of a project. Instead, use TagResource
// (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation UpdateProject for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateProject
func (c *CloudWatchEvidently) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProjectDataDelivery = "UpdateProjectDataDelivery"

// UpdateProjectDataDeliveryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProjectDataDelivery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProjectDataDelivery for more information on using the UpdateProjectDataDelivery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProjectDataDeliveryRequest method.
//	req, resp := client.UpdateProjectDataDeliveryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateProjectDataDelivery
func (c *CloudWatchEvidently) UpdateProjectDataDeliveryRequest(input *UpdateProjectDataDeliveryInput) (req *request.Request, output *UpdateProjectDataDeliveryOutput) {
	op := &request.Operation{
		Name:       opUpdateProjectDataDelivery,
		HTTPMethod: "PATCH",
		HTTPPath:   "/projects/{project}/data-delivery",
	}

	if input == nil {
		input = &UpdateProjectDataDeliveryInput{}
	}

	output = &UpdateProjectDataDeliveryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProjectDataDelivery API operation for Amazon CloudWatch Evidently.
//
// Updates the data storage options for this project. If you store evaluation
// events, you an keep them and analyze them on your own. If you choose not
// to store evaluation events, Evidently deletes them after using them to produce
// metrics and other experiment results that you can view.
//
// You can't specify both cloudWatchLogs and s3Destination in the same operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Evidently's
// API operation UpdateProjectDataDelivery for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateProjectDataDelivery
func (c *CloudWatchEvidently) UpdateProjectDataDelivery(input *UpdateProjectDataDeliveryInput) (*UpdateProjectDataDeliveryOutput, error) {
	req, out := c.UpdateProjectDataDeliveryRequest(input)
	return out, req.Send()
}

// UpdateProjectDataDeliveryWithContext is the same as UpdateProjectDataDelivery with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProjectDataDelivery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvidently) UpdateProjectDataDeliveryWithContext(ctx aws.Context, input *UpdateProjectDataDeliveryInput, opts ...request.Option) (*UpdateProjectDataDeliveryOutput, error) {
	req, out := c.UpdateProjectDataDeliveryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient permissions to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchEvaluateFeatureInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the project that contains the feature being evaluated.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// An array of structures, where each structure assigns a feature variation
	// to one user session.
	//
	// Requests is a required field
	Requests []*EvaluationRequest `locationName:"requests" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateFeatureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateFeatureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchEvaluateFeatureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchEvaluateFeatureInput"}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.Requests == nil {
		invalidParams.Add(request.NewErrParamRequired("Requests"))
	}
	if s.Requests != nil && len(s.Requests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Requests", 1))
	}
	if s.Requests != nil {
		for i, v := range s.Requests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Requests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProject sets the Project field's value.
func (s *BatchEvaluateFeatureInput) SetProject(v string) *BatchEvaluateFeatureInput {
	s.Project = &v
	return s
}

// SetRequests sets the Requests field's value.
func (s *BatchEvaluateFeatureInput) SetRequests(v []*EvaluationRequest) *BatchEvaluateFeatureInput {
	s.Requests = v
	return s
}

type BatchEvaluateFeatureOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures, where each structure displays the results of one
	// feature evaluation assignment to one user session.
	Results []*EvaluationResult `locationName:"results" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateFeatureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEvaluateFeatureOutput) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *BatchEvaluateFeatureOutput) SetResults(v []*EvaluationResult) *BatchEvaluateFeatureOutput {
	s.Results = v
	return s
}

// A structure containing the CloudWatch Logs log group where the project stores
// evaluation events.
type CloudWatchLogsDestination struct {
	_ struct{} `type:"structure"`

	// The name of the log group where the project stores evaluation events.
	LogGroup *string `locationName:"logGroup" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestination) GoString() string {
	return s.String()
}

// SetLogGroup sets the LogGroup field's value.
func (s *CloudWatchLogsDestination) SetLogGroup(v string) *CloudWatchLogsDestination {
	s.LogGroup = &v
	return s
}

// A structure containing the CloudWatch Logs log group where the project stores
// evaluation events.
type CloudWatchLogsDestinationConfig struct {
	_ struct{} `type:"structure"`

	// The name of the log group where the project stores evaluation events.
	LogGroup *string `locationName:"logGroup" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestinationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestinationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogsDestinationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogsDestinationConfig"}
	if s.LogGroup != nil && len(*s.LogGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogGroup sets the LogGroup field's value.
func (s *CloudWatchLogsDestinationConfig) SetLogGroup(v string) *CloudWatchLogsDestinationConfig {
	s.LogGroup = &v
	return s
}

// A resource was in an inconsistent state during an update or a deletion.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that caused the exception.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource that is associated with the error.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateExperimentInput struct {
	_ struct{} `type:"structure"`

	// An optional description of the experiment.
	Description *string `locationName:"description" type:"string"`

	// An array of structures that defines the metrics used for the experiment,
	// and whether a higher or lower value for each metric is the goal.
	//
	// MetricGoals is a required field
	MetricGoals []*MetricGoalConfig `locationName:"metricGoals" min:"1" type:"list" required:"true"`

	// A name for the new experiment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A structure that contains the configuration of which variation to use as
	// the "control" version. tThe "control" version is used for comparison with
	// other variations. This structure also specifies how much experiment traffic
	// is allocated to each variation.
	OnlineAbConfig *OnlineAbConfig `locationName:"onlineAbConfig" type:"structure"`

	// The name or ARN of the project that you want to create the new experiment
	// in.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// When Evidently assigns a particular user session to an experiment, it must
	// use a randomization ID to determine which variation the user session is served.
	// This randomization ID is a combination of the entity ID and randomizationSalt.
	// If you omit randomizationSalt, Evidently uses the experiment name as the
	// randomizationSalt.
	RandomizationSalt *string `locationName:"randomizationSalt" type:"string"`

	// The portion of the available audience that you want to allocate to this experiment,
	// in thousandths of a percent. The available audience is the total audience
	// minus the audience that you have allocated to overrides or current launches
	// of this feature.
	//
	// This is represented in thousandths of a percent. For example, specify 10,000
	// to allocate 10% of the available audience.
	SamplingRate *int64 `locationName:"samplingRate" type:"long"`

	// Specifies an audience segment to use in the experiment. When a segment is
	// used in an experiment, only user sessions that match the segment pattern
	// are used in the experiment.
	Segment *string `locationName:"segment" type:"string"`

	// Assigns one or more tags (key-value pairs) to the experiment.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
	// strictly as strings of characters.
	//
	//    <p>You can associate as many as 50 tags with an experiment.</p> <p>For
	//    more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
	//    Amazon Web Services resources</a>.</p>
	Tags map[string]*string `locationName:"tags" type:"map"`

	// An array of structures that describe the configuration of each feature variation
	// used in the experiment.
	//
	// Treatments is a required field
	Treatments []*TreatmentConfig `locationName:"treatments" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExperimentInput"}
	if s.MetricGoals == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricGoals"))
	}
	if s.MetricGoals != nil && len(s.MetricGoals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricGoals", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.Treatments == nil {
		invalidParams.Add(request.NewErrParamRequired("Treatments"))
	}
	if s.MetricGoals != nil {
		for i, v := range s.MetricGoals {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricGoals", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OnlineAbConfig != nil {
		if err := s.OnlineAbConfig.Validate(); err != nil {
			invalidParams.AddNested("OnlineAbConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Treatments != nil {
		for i, v := range s.Treatments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Treatments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateExperimentInput) SetDescription(v string) *CreateExperimentInput {
	s.Description = &v
	return s
}

// SetMetricGoals sets the MetricGoals field's value.
func (s *CreateExperimentInput) SetMetricGoals(v []*MetricGoalConfig) *CreateExperimentInput {
	s.MetricGoals = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateExperimentInput) SetName(v string) *CreateExperimentInput {
	s.Name = &v
	return s
}

// SetOnlineAbConfig sets the OnlineAbConfig field's value.
func (s *CreateExperimentInput) SetOnlineAbConfig(v *OnlineAbConfig) *CreateExperimentInput {
	s.OnlineAbConfig = v
	return s
}

// SetProject sets the Project field's value.
func (s *CreateExperimentInput) SetProject(v string) *CreateExperimentInput {
	s.Project = &v
	return s
}

// SetRandomizationSalt sets the RandomizationSalt field's value.
func (s *CreateExperimentInput) SetRandomizationSalt(v string) *CreateExperimentInput {
	s.RandomizationSalt = &v
	return s
}

// SetSamplingRate sets the SamplingRate field's value.
func (s *CreateExperimentInput) SetSamplingRate(v int64) *CreateExperimentInput {
	s.SamplingRate = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *CreateExperimentInput) SetSegment(v string) *CreateExperimentInput {
	s.Segment = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateExperimentInput) SetTags(v map[string]*string) *CreateExperimentInput {
	s.Tags = v
	return s
}

// SetTreatments sets the Treatments field's value.
func (s *CreateExperimentInput) SetTreatments(v []*TreatmentConfig) *CreateExperimentInput {
	s.Treatments = v
	return s
}

type CreateExperimentOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the configuration details of the experiment that you
	// created.
	//
	// Experiment is a required field
	Experiment *Experiment `locationName:"experiment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExperimentOutput) GoString() string {
	return s.String()
}

// SetExperiment sets the Experiment field's value.
func (s *CreateExperimentOutput) SetExperiment(v *Experiment) *CreateExperimentOutput {
	s.Experiment = v
	return s
}

type CreateFeatureInput struct {
	_ struct{} `type:"structure"`

	// The name of the variation to use as the default variation. The default variation
	// is served to users who are not allocated to any ongoing launches or experiments
	// of this feature.
	//
	// This variation must also be listed in the variations structure.
	//
	// If you omit defaultVariation, the first variation listed in the variations
	// structure is used as the default variation.
	DefaultVariation *string `locationName:"defaultVariation" min:"1" type:"string"`

	// An optional description of the feature.
	Description *string `locationName:"description" type:"string"`

	// Specify users that should always be served a specific variation of a feature.
	// Each user is specified by a key-value pair . For each key, specify a user
	// by entering their user ID, account ID, or some other identifier. For the
	// value, specify the name of the variation that they are to be served.
	EntityOverrides map[string]*string `locationName:"entityOverrides" type:"map"`

	// Specify ALL_RULES to activate the traffic allocation specified by any ongoing
	// launches or experiments. Specify DEFAULT_VARIATION to serve the default variation
	// to all users instead.
	EvaluationStrategy *string `locationName:"evaluationStrategy" type:"string" enum:"FeatureEvaluationStrategy"`

	// The name for the new feature.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that is to contain the new feature.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// Assigns one or more tags (key-value pairs) to the feature.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
	// strictly as strings of characters.
	//
	//    <p>You can associate as many as 50 tags with a feature.</p> <p>For more
	//    information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
	//    Amazon Web Services resources</a>.</p>
	Tags map[string]*string `locationName:"tags" type:"map"`

	// An array of structures that contain the configuration of the feature's different
	// variations.
	//
	// Variations is a required field
	Variations []*VariationConfig `locationName:"variations" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFeatureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFeatureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFeatureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFeatureInput"}
	if s.DefaultVariation != nil && len(*s.DefaultVariation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultVariation", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.Variations == nil {
		invalidParams.Add(request.NewErrParamRequired("Variations"))
	}
	if s.Variations != nil && len(s.Variations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Variations", 1))
	}
	if s.Variations != nil {
		for i, v := range s.Variations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultVariation sets the DefaultVariation field's value.
func (s *CreateFeatureInput) SetDefaultVariation(v string) *CreateFeatureInput {
	s.DefaultVariation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFeatureInput) SetDescription(v string) *CreateFeatureInput {
	s.Description = &v
	return s
}

// SetEntityOverrides sets the EntityOverrides field's value.
func (s *CreateFeatureInput) SetEntityOverrides(v map[string]*string) *CreateFeatureInput {
	s.EntityOverrides = v
	return s
}

// SetEvaluationStrategy sets the EvaluationStrategy field's value.
func (s *CreateFeatureInput) SetEvaluationStrategy(v string) *CreateFeatureInput {
	s.EvaluationStrategy = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFeatureInput) SetName(v string) *CreateFeatureInput {
	s.Name = &v
	return s
}

// SetProject sets the Project field's value.
func (s *CreateFeatureInput) SetProject(v string) *CreateFeatureInput {
	s.Project = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFeatureInput) SetTags(v map[string]*string) *CreateFeatureInput {
	s.Tags = v
	return s
}

// SetVariations sets the Variations field's value.
func (s *CreateFeatureInput) SetVariations(v []*VariationConfig) *CreateFeatureInput {
	s.Variations = v
	return s
}

type CreateFeatureOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the new feature.
	Feature *Feature `locationName:"feature" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFeatureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFeatureOutput) GoString() string {
	return s.String()
}

// SetFeature sets the Feature field's value.
func (s *CreateFeatureOutput) SetFeature(v *Feature) *CreateFeatureOutput {
	s.Feature = v
	return s
}

type CreateLaunchInput struct {
	_ struct{} `type:"structure"`

	// An optional description for the launch.
	Description *string `locationName:"description" type:"string"`

	// An array of structures that contains the feature and variations that are
	// to be used for the launch.
	//
	// Groups is a required field
	Groups []*LaunchGroupConfig `locationName:"groups" min:"1" type:"list" required:"true"`

	// An array of structures that define the metrics that will be used to monitor
	// the launch performance.
	MetricMonitors []*MetricMonitorConfig `locationName:"metricMonitors" type:"list"`

	// The name for the new launch.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that you want to create the launch in.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// When Evidently assigns a particular user session to a launch, it must use
	// a randomization ID to determine which variation the user session is served.
	// This randomization ID is a combination of the entity ID and randomizationSalt.
	// If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
	RandomizationSalt *string `locationName:"randomizationSalt" type:"string"`

	// An array of structures that define the traffic allocation percentages among
	// the feature variations during each step of the launch.
	ScheduledSplitsConfig *ScheduledSplitsLaunchConfig `locationName:"scheduledSplitsConfig" type:"structure"`

	// Assigns one or more tags (key-value pairs) to the launch.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
	// strictly as strings of characters.
	//
	//    <p>You can associate as many as 50 tags with a launch.</p> <p>For more
	//    information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
	//    Amazon Web Services resources</a>.</p>
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLaunchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLaunchInput"}
	if s.Groups == nil {
		invalidParams.Add(request.NewErrParamRequired("Groups"))
	}
	if s.Groups != nil && len(s.Groups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Groups", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.Groups != nil {
		for i, v := range s.Groups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Groups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MetricMonitors != nil {
		for i, v := range s.MetricMonitors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricMonitors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScheduledSplitsConfig != nil {
		if err := s.ScheduledSplitsConfig.Validate(); err != nil {
			invalidParams.AddNested("ScheduledSplitsConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateLaunchInput) SetDescription(v string) *CreateLaunchInput {
	s.Description = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *CreateLaunchInput) SetGroups(v []*LaunchGroupConfig) *CreateLaunchInput {
	s.Groups = v
	return s
}

// SetMetricMonitors sets the MetricMonitors field's value.
func (s *CreateLaunchInput) SetMetricMonitors(v []*MetricMonitorConfig) *CreateLaunchInput {
	s.MetricMonitors = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLaunchInput) SetName(v string) *CreateLaunchInput {
	s.Name = &v
	return s
}

// SetProject sets the Project field's value.
func (s *CreateLaunchInput) SetProject(v string) *CreateLaunchInput {
	s.Project = &v
	return s
}

// SetRandomizationSalt sets the RandomizationSalt field's value.
func (s *CreateLaunchInput) SetRandomizationSalt(v string) *CreateLaunchInput {
	s.RandomizationSalt = &v
	return s
}

// SetScheduledSplitsConfig sets the ScheduledSplitsConfig field's value.
func (s *CreateLaunchInput) SetScheduledSplitsConfig(v *ScheduledSplitsLaunchConfig) *CreateLaunchInput {
	s.ScheduledSplitsConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLaunchInput) SetTags(v map[string]*string) *CreateLaunchInput {
	s.Tags = v
	return s
}

type CreateLaunchOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the configuration of the launch that was created.
	//
	// Launch is a required field
	Launch *Launch `locationName:"launch" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchOutput) GoString() string {
	return s.String()
}

// SetLaunch sets the Launch field's value.
func (s *CreateLaunchOutput) SetLaunch(v *Launch) *CreateLaunchOutput {
	s.Launch = v
	return s
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about where Evidently is to store evaluation
	// events for longer term storage, if you choose to do so. If you choose not
	// to store these events, Evidently deletes them after using them to produce
	// metrics and other experiment results that you can view.
	DataDelivery *ProjectDataDeliveryConfig `locationName:"dataDelivery" type:"structure"`

	// An optional description of the project.
	Description *string `locationName:"description" type:"string"`

	// The name for the project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Assigns one or more tags (key-value pairs) to the project.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
	// strictly as strings of characters.
	//
	//    <p>You can associate as many as 50 tags with a project.</p> <p>For more
	//    information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
	//    Amazon Web Services resources</a>.</p>
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.DataDelivery != nil {
		if err := s.DataDelivery.Validate(); err != nil {
			invalidParams.AddNested("DataDelivery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataDelivery sets the DataDelivery field's value.
func (s *CreateProjectInput) SetDataDelivery(v *ProjectDataDeliveryConfig) *CreateProjectInput {
	s.DataDelivery = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateProjectInput) SetDescription(v string) *CreateProjectInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProjectInput) SetTags(v map[string]*string) *CreateProjectInput {
	s.Tags = v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the created project.
	//
	// Project is a required field
	Project *Project `locationName:"project" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *CreateProjectOutput) SetProject(v *Project) *CreateProjectOutput {
	s.Project = v
	return s
}

type CreateSegmentInput struct {
	_ struct{} `type:"structure"`

	// An optional description for this segment.
	Description *string `locationName:"description" type:"string"`

	// A name for the segment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The pattern to use for the segment. For more information about pattern syntax,
	// see Segment rule pattern syntax (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments-syntax.html).
	//
	// Pattern is a required field
	Pattern *string `locationName:"pattern" min:"1" type:"string" required:"true"`

	// Assigns one or more tags (key-value pairs) to the segment.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
	// strictly as strings of characters.
	//
	//    <p>You can associate as many as 50 tags with a segment.</p> <p>For more
	//    information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
	//    Amazon Web Services resources</a>.</p>
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSegmentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Pattern == nil {
		invalidParams.Add(request.NewErrParamRequired("Pattern"))
	}
	if s.Pattern != nil && len(*s.Pattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Pattern", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSegmentInput) SetDescription(v string) *CreateSegmentInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSegmentInput) SetName(v string) *CreateSegmentInput {
	s.Name = &v
	return s
}

// SetPattern sets the Pattern field's value.
func (s *CreateSegmentInput) SetPattern(v string) *CreateSegmentInput {
	s.Pattern = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSegmentInput) SetTags(v map[string]*string) *CreateSegmentInput {
	s.Tags = v
	return s
}

type CreateSegmentOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the complete information about the segment that
	// was just created.
	//
	// Segment is a required field
	Segment *Segment `locationName:"segment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSegmentOutput) GoString() string {
	return s.String()
}

// SetSegment sets the Segment field's value.
func (s *CreateSegmentOutput) SetSegment(v *Segment) *CreateSegmentOutput {
	s.Segment = v
	return s
}

type DeleteExperimentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the experiment to delete.
	//
	// Experiment is a required field
	Experiment *string `location:"uri" locationName:"experiment" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the experiment to delete.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExperimentInput"}
	if s.Experiment == nil {
		invalidParams.Add(request.NewErrParamRequired("Experiment"))
	}
	if s.Experiment != nil && len(*s.Experiment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Experiment", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExperiment sets the Experiment field's value.
func (s *DeleteExperimentInput) SetExperiment(v string) *DeleteExperimentInput {
	s.Experiment = &v
	return s
}

// SetProject sets the Project field's value.
func (s *DeleteExperimentInput) SetProject(v string) *DeleteExperimentInput {
	s.Project = &v
	return s
}

type DeleteExperimentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExperimentOutput) GoString() string {
	return s.String()
}

type DeleteFeatureInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the feature to delete.
	//
	// Feature is a required field
	Feature *string `location:"uri" locationName:"feature" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the feature to delete.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFeatureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFeatureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFeatureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFeatureInput"}
	if s.Feature == nil {
		invalidParams.Add(request.NewErrParamRequired("Feature"))
	}
	if s.Feature != nil && len(*s.Feature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Feature", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeature sets the Feature field's value.
func (s *DeleteFeatureInput) SetFeature(v string) *DeleteFeatureInput {
	s.Feature = &v
	return s
}

// SetProject sets the Project field's value.
func (s *DeleteFeatureInput) SetProject(v string) *DeleteFeatureInput {
	s.Project = &v
	return s
}

type DeleteFeatureOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFeatureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFeatureOutput) GoString() string {
	return s.String()
}

type DeleteLaunchInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the launch to delete.
	//
	// Launch is a required field
	Launch *string `location:"uri" locationName:"launch" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the launch to delete.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLaunchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLaunchInput"}
	if s.Launch == nil {
		invalidParams.Add(request.NewErrParamRequired("Launch"))
	}
	if s.Launch != nil && len(*s.Launch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Launch", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunch sets the Launch field's value.
func (s *DeleteLaunchInput) SetLaunch(v string) *DeleteLaunchInput {
	s.Launch = &v
	return s
}

// SetProject sets the Project field's value.
func (s *DeleteLaunchInput) SetProject(v string) *DeleteLaunchInput {
	s.Project = &v
	return s
}

type DeleteLaunchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchOutput) GoString() string {
	return s.String()
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name or ARN of the project to delete.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProject sets the Project field's value.
func (s *DeleteProjectInput) SetProject(v string) *DeleteProjectInput {
	s.Project = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

type DeleteSegmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies the segment to delete.
	//
	// Segment is a required field
	Segment *string `location:"uri" locationName:"segment" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSegmentInput"}
	if s.Segment == nil {
		invalidParams.Add(request.NewErrParamRequired("Segment"))
	}
	if s.Segment != nil && len(*s.Segment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Segment", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSegment sets the Segment field's value.
func (s *DeleteSegmentInput) SetSegment(v string) *DeleteSegmentInput {
	s.Segment = &v
	return s
}

type DeleteSegmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSegmentOutput) GoString() string {
	return s.String()
}

type EvaluateFeatureInput struct {
	_ struct{} `type:"structure"`

	// An internal ID that represents a unique user of the application. This entityID
	// is checked against any override rules assigned for this feature.
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" min:"1" type:"string" required:"true"`

	// A JSON object of attributes that you can optionally pass in as part of the
	// evaluation event sent to Evidently from the user session. Evidently can use
	// this value to match user sessions with defined audience segments. For more
	// information, see Use segments to focus your audience (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html).
	//
	//    <p>If you include this parameter, the value must be a JSON object. A JSON
	//    array is not supported.</p>
	EvaluationContext *string `locationName:"evaluationContext" type:"string"`

	// The name of the feature being evaluated.
	//
	// Feature is a required field
	Feature *string `location:"uri" locationName:"feature" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains this feature.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateFeatureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateFeatureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluateFeatureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluateFeatureInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.Feature == nil {
		invalidParams.Add(request.NewErrParamRequired("Feature"))
	}
	if s.Feature != nil && len(*s.Feature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Feature", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *EvaluateFeatureInput) SetEntityId(v string) *EvaluateFeatureInput {
	s.EntityId = &v
	return s
}

// SetEvaluationContext sets the EvaluationContext field's value.
func (s *EvaluateFeatureInput) SetEvaluationContext(v string) *EvaluateFeatureInput {
	s.EvaluationContext = &v
	return s
}

// SetFeature sets the Feature field's value.
func (s *EvaluateFeatureInput) SetFeature(v string) *EvaluateFeatureInput {
	s.Feature = &v
	return s
}

// SetProject sets the Project field's value.
func (s *EvaluateFeatureInput) SetProject(v string) *EvaluateFeatureInput {
	s.Project = &v
	return s
}

type EvaluateFeatureOutput struct {
	_ struct{} `type:"structure"`

	// If this user was assigned to a launch or experiment, this field lists the
	// launch or experiment name.
	Details *string `locationName:"details" type:"string"`

	// Specifies the reason that the user session was assigned this variation. Possible
	// values include DEFAULT, meaning the user was served the default variation;
	// LAUNCH_RULE_MATCH, if the user session was enrolled in a launch; EXPERIMENT_RULE_MATCH,
	// if the user session was enrolled in an experiment; or ENTITY_OVERRIDES_MATCH,
	// if the user's entityId matches an override rule.
	Reason *string `locationName:"reason" type:"string"`

	// The value assigned to this variation to differentiate it from the other variations
	// of this feature.
	Value *VariableValue `locationName:"value" type:"structure"`

	// The name of the variation that was served to the user session.
	Variation *string `locationName:"variation" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateFeatureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateFeatureOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *EvaluateFeatureOutput) SetDetails(v string) *EvaluateFeatureOutput {
	s.Details = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *EvaluateFeatureOutput) SetReason(v string) *EvaluateFeatureOutput {
	s.Reason = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EvaluateFeatureOutput) SetValue(v *VariableValue) *EvaluateFeatureOutput {
	s.Value = v
	return s
}

// SetVariation sets the Variation field's value.
func (s *EvaluateFeatureOutput) SetVariation(v string) *EvaluateFeatureOutput {
	s.Variation = &v
	return s
}

// This structure assigns a feature variation to one user session.
type EvaluationRequest struct {
	_ struct{} `type:"structure"`

	// An internal ID that represents a unique user session of the application.
	// This entityID is checked against any override rules assigned for this feature.
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" min:"1" type:"string" required:"true"`

	// A JSON block of attributes that you can optionally pass in. This JSON block
	// is included in the evaluation events sent to Evidently from the user session.
	EvaluationContext *string `locationName:"evaluationContext" type:"string"`

	// The name of the feature being evaluated.
	//
	// Feature is a required field
	Feature *string `locationName:"feature" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluationRequest"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.Feature == nil {
		invalidParams.Add(request.NewErrParamRequired("Feature"))
	}
	if s.Feature != nil && len(*s.Feature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Feature", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *EvaluationRequest) SetEntityId(v string) *EvaluationRequest {
	s.EntityId = &v
	return s
}

// SetEvaluationContext sets the EvaluationContext field's value.
func (s *EvaluationRequest) SetEvaluationContext(v string) *EvaluationRequest {
	s.EvaluationContext = &v
	return s
}

// SetFeature sets the Feature field's value.
func (s *EvaluationRequest) SetFeature(v string) *EvaluationRequest {
	s.Feature = &v
	return s
}

// This structure displays the results of one feature evaluation assignment
// to one user session.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// If this user was assigned to a launch or experiment, this field lists the
	// launch or experiment name.
	Details *string `locationName:"details" type:"string"`

	// An internal ID that represents a unique user session of the application.
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" min:"1" type:"string" required:"true"`

	// The name of the feature being evaluated.
	//
	// Feature is a required field
	Feature *string `locationName:"feature" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the feature being evaluated.
	Project *string `locationName:"project" type:"string"`

	// Specifies the reason that the user session was assigned this variation. Possible
	// values include DEFAULT, meaning the user was served the default variation;
	// LAUNCH_RULE_MATCH, if the user session was enrolled in a launch; or EXPERIMENT_RULE_MATCH,
	// if the user session was enrolled in an experiment.
	Reason *string `locationName:"reason" type:"string"`

	// The value assigned to this variation to differentiate it from the other variations
	// of this feature.
	Value *VariableValue `locationName:"value" type:"structure"`

	// The name of the variation that was served to the user session.
	Variation *string `locationName:"variation" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResult) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *EvaluationResult) SetDetails(v string) *EvaluationResult {
	s.Details = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *EvaluationResult) SetEntityId(v string) *EvaluationResult {
	s.EntityId = &v
	return s
}

// SetFeature sets the Feature field's value.
func (s *EvaluationResult) SetFeature(v string) *EvaluationResult {
	s.Feature = &v
	return s
}

// SetProject sets the Project field's value.
func (s *EvaluationResult) SetProject(v string) *EvaluationResult {
	s.Project = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *EvaluationResult) SetReason(v string) *EvaluationResult {
	s.Reason = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EvaluationResult) SetValue(v *VariableValue) *EvaluationResult {
	s.Value = v
	return s
}

// SetVariation sets the Variation field's value.
func (s *EvaluationResult) SetVariation(v string) *EvaluationResult {
	s.Variation = &v
	return s
}

// A structure that contains the information about an evaluation rule for this
// feature, if it is used in a launch or experiment.
type EvaluationRule struct {
	_ struct{} `type:"structure"`

	// The name of the experiment or launch.
	Name *string `locationName:"name" type:"string"`

	// This value is aws.evidently.splits if this is an evaluation rule for a launch,
	// and it is aws.evidently.onlineab if this is an evaluation rule for an experiment.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationRule) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EvaluationRule) SetName(v string) *EvaluationRule {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *EvaluationRule) SetType(v string) *EvaluationRule {
	s.Type = &v
	return s
}

// A structure that contains the information about one evaluation event or custom
// event sent to Evidently. This is a JSON payload. If this event specifies
// a pre-defined event type, the payload must follow the defined event schema.
type Event struct {
	_ struct{} `type:"structure"`

	// The event data.
	//
	// Data is a required field
	Data *string `locationName:"data" type:"string" required:"true"`

	// The timestamp of the event.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`

	// aws.evidently.evaluation specifies an evaluation event, which determines
	// which feature variation that a user sees. aws.evidently.custom specifies
	// a custom event, which generates metrics from user actions such as clicks
	// and checkouts.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EventType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Event) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Event"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *Event) SetData(v string) *Event {
	s.Data = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Event) SetTimestamp(v time.Time) *Event {
	s.Timestamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *Event) SetType(v string) *Event {
	s.Type = &v
	return s
}

// A structure containing the configuration details of an experiment.
type Experiment struct {
	_ struct{} `type:"structure"`

	// The ARN of the experiment.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time that the experiment is first created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp" required:"true"`

	// A description of the experiment.
	Description *string `locationName:"description" type:"string"`

	// A structure that contains the date and time that the experiment started and
	// ended.
	Execution *ExperimentExecution `locationName:"execution" type:"structure"`

	// The date and time that the experiment was most recently updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" required:"true"`

	// An array of structures that defines the metrics used for the experiment,
	// and whether a higher or lower value for each metric is the goal.
	MetricGoals []*MetricGoal `locationName:"metricGoals" min:"1" type:"list"`

	// The name of the experiment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A structure that contains the configuration of which variation to use as
	// the "control" version. The "control" version is used for comparison with
	// other variations. This structure also specifies how much experiment traffic
	// is allocated to each variation.
	OnlineAbDefinition *OnlineAbDefinition `locationName:"onlineAbDefinition" type:"structure"`

	// The name or ARN of the project that contains this experiment.
	Project *string `locationName:"project" type:"string"`

	// This value is used when Evidently assigns a particular user session to the
	// experiment. It helps create a randomization ID to determine which variation
	// the user session is served. This randomization ID is a combination of the
	// entity ID and randomizationSalt.
	RandomizationSalt *string `locationName:"randomizationSalt" type:"string"`

	// In thousandths of a percent, the amount of the available audience that is
	// allocated to this experiment. The available audience is the total audience
	// minus the audience that you have allocated to overrides or current launches
	// of this feature.
	//
	// This is represented in thousandths of a percent, so a value of 10,000 is
	// 10% of the available audience.
	SamplingRate *int64 `locationName:"samplingRate" type:"long"`

	// A structure that contains the time and date that Evidently completed the
	// analysis of the experiment.
	Schedule *ExperimentSchedule `locationName:"schedule" type:"structure"`

	// The audience segment being used for the experiment, if a segment is being
	// used.
	Segment *string `locationName:"segment" type:"string"`

	// The current state of the experiment.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ExperimentStatus"`

	// If the experiment was stopped, this is the string that was entered by the
	// person who stopped the experiment, to explain why it was stopped.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The list of tag keys and values associated with this experiment.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// An array of structures that describe the configuration of each feature variation
	// used in the experiment.
	Treatments []*Treatment `locationName:"treatments" min:"2" type:"list"`

	// The type of this experiment. Currently, this value must be aws.experiment.onlineab.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ExperimentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Experiment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Experiment) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Experiment) SetArn(v string) *Experiment {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Experiment) SetCreatedTime(v time.Time) *Experiment {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Experiment) SetDescription(v string) *Experiment {
	s.Description = &v
	return s
}

// SetExecution sets the Execution field's value.
func (s *Experiment) SetExecution(v *ExperimentExecution) *Experiment {
	s.Execution = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Experiment) SetLastUpdatedTime(v time.Time) *Experiment {
	s.LastUpdatedTime = &v
	return s
}

// SetMetricGoals sets the MetricGoals field's value.
func (s *Experiment) SetMetricGoals(v []*MetricGoal) *Experiment {
	s.MetricGoals = v
	return s
}

// SetName sets the Name field's value.
func (s *Experiment) SetName(v string) *Experiment {
	s.Name = &v
	return s
}

// SetOnlineAbDefinition sets the OnlineAbDefinition field's value.
func (s *Experiment) SetOnlineAbDefinition(v *OnlineAbDefinition) *Experiment {
	s.OnlineAbDefinition = v
	return s
}

// SetProject sets the Project field's value.
func (s *Experiment) SetProject(v string) *Experiment {
	s.Project = &v
	return s
}

// SetRandomizationSalt sets the RandomizationSalt field's value.
func (s *Experiment) SetRandomizationSalt(v string) *Experiment {
	s.RandomizationSalt = &v
	return s
}

// SetSamplingRate sets the SamplingRate field's value.
func (s *Experiment) SetSamplingRate(v int64) *Experiment {
	s.SamplingRate = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *Experiment) SetSchedule(v *ExperimentSchedule) *Experiment {
	s.Schedule = v
	return s
}

// SetSegment sets the Segment field's value.
func (s *Experiment) SetSegment(v string) *Experiment {
	s.Segment = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Experiment) SetStatus(v string) *Experiment {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *Experiment) SetStatusReason(v string) *Experiment {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Experiment) SetTags(v map[string]*string) *Experiment {
	s.Tags = v
	return s
}

// SetTreatments sets the Treatments field's value.
func (s *Experiment) SetTreatments(v []*Treatment) *Experiment {
	s.Treatments = v
	return s
}

// SetType sets the Type field's value.
func (s *Experiment) SetType(v string) *Experiment {
	s.Type = &v
	return s
}

// This structure contains the date and time that the experiment started and
// ended.
type ExperimentExecution struct {
	_ struct{} `type:"structure"`

	// The date and time that the experiment ended.
	EndedTime *time.Time `locationName:"endedTime" type:"timestamp"`

	// The date and time that the experiment started.
	StartedTime *time.Time `locationName:"startedTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentExecution) GoString() string {
	return s.String()
}

// SetEndedTime sets the EndedTime field's value.
func (s *ExperimentExecution) SetEndedTime(v time.Time) *ExperimentExecution {
	s.EndedTime = &v
	return s
}

// SetStartedTime sets the StartedTime field's value.
func (s *ExperimentExecution) SetStartedTime(v time.Time) *ExperimentExecution {
	s.StartedTime = &v
	return s
}

// A structure that contains results of an experiment.
type ExperimentReport struct {
	_ struct{} `type:"structure"`

	// The content of the report.
	Content *string `locationName:"content" type:"string"`

	// The name of the metric that is analyzed in this experiment report.
	MetricName *string `locationName:"metricName" min:"1" type:"string"`

	// The type of analysis used for this report.
	ReportName *string `locationName:"reportName" type:"string" enum:"ExperimentReportName"`

	// The name of the variation that this report pertains to.
	TreatmentName *string `locationName:"treatmentName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentReport) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *ExperimentReport) SetContent(v string) *ExperimentReport {
	s.Content = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ExperimentReport) SetMetricName(v string) *ExperimentReport {
	s.MetricName = &v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *ExperimentReport) SetReportName(v string) *ExperimentReport {
	s.ReportName = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *ExperimentReport) SetTreatmentName(v string) *ExperimentReport {
	s.TreatmentName = &v
	return s
}

// A structure that contains experiment results for one metric that is monitored
// in the experiment.
type ExperimentResultsData struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	MetricName *string `locationName:"metricName" min:"1" type:"string"`

	// The experiment statistic that these results pertain to.
	ResultStat *string `locationName:"resultStat" type:"string" enum:"ExperimentResultResponseType"`

	// The treatment, or variation, that returned the values in this structure.
	TreatmentName *string `locationName:"treatmentName" min:"1" type:"string"`

	// The values for the metricName that were recorded in the experiment.
	Values []*float64 `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentResultsData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentResultsData) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *ExperimentResultsData) SetMetricName(v string) *ExperimentResultsData {
	s.MetricName = &v
	return s
}

// SetResultStat sets the ResultStat field's value.
func (s *ExperimentResultsData) SetResultStat(v string) *ExperimentResultsData {
	s.ResultStat = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *ExperimentResultsData) SetTreatmentName(v string) *ExperimentResultsData {
	s.TreatmentName = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExperimentResultsData) SetValues(v []*float64) *ExperimentResultsData {
	s.Values = v
	return s
}

// This structure contains the time and date that Evidently completed the analysis
// of the experiment.
type ExperimentSchedule struct {
	_ struct{} `type:"structure"`

	// The time and date that Evidently completed the analysis of the experiment.
	AnalysisCompleteTime *time.Time `locationName:"analysisCompleteTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExperimentSchedule) GoString() string {
	return s.String()
}

// SetAnalysisCompleteTime sets the AnalysisCompleteTime field's value.
func (s *ExperimentSchedule) SetAnalysisCompleteTime(v time.Time) *ExperimentSchedule {
	s.AnalysisCompleteTime = &v
	return s
}

// This structure contains information about one Evidently feature in your account.
type Feature struct {
	_ struct{} `type:"structure"`

	// The ARN of the feature.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time that the feature is created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp" required:"true"`

	// The name of the variation that is used as the default variation. The default
	// variation is served to users who are not allocated to any ongoing launches
	// or experiments of this feature.
	//
	// This variation must also be listed in the variations structure.
	//
	// If you omit defaultVariation, the first variation listed in the variations
	// structure is used as the default variation.
	DefaultVariation *string `locationName:"defaultVariation" min:"1" type:"string"`

	// The description of the feature.
	Description *string `locationName:"description" type:"string"`

	// A set of key-value pairs that specify users who should always be served a
	// specific variation of a feature. Each key specifies a user using their user
	// ID, account ID, or some other identifier. The value specifies the name of
	// the variation that the user is to be served.
	//
	// For the override to be successful, the value of the key must match the entityId
	// used in the EvaluateFeature (https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html)
	// operation.
	EntityOverrides map[string]*string `locationName:"entityOverrides" type:"map"`

	// An array of structures that define the evaluation rules for the feature.
	EvaluationRules []*EvaluationRule `locationName:"evaluationRules" type:"list"`

	// If this value is ALL_RULES, the traffic allocation specified by any ongoing
	// launches or experiments is being used. If this is DEFAULT_VARIATION, the
	// default variation is being served to all users.
	//
	// EvaluationStrategy is a required field
	EvaluationStrategy *string `locationName:"evaluationStrategy" type:"string" required:"true" enum:"FeatureEvaluationStrategy"`

	// The date and time that the feature was most recently updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" required:"true"`

	// The name of the feature.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the feature.
	Project *string `locationName:"project" type:"string"`

	// The current state of the feature.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FeatureStatus"`

	// The list of tag keys and values associated with this feature.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Defines the type of value used to define the different feature variations.
	// For more information, see Variation types (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-variationtypes.html)
	//
	// ValueType is a required field
	ValueType *string `locationName:"valueType" type:"string" required:"true" enum:"VariationValueType"`

	// An array of structures that contain the configuration of the feature's different
	// variations.
	//
	// Variations is a required field
	Variations []*Variation `locationName:"variations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Feature) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Feature) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Feature) SetArn(v string) *Feature {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Feature) SetCreatedTime(v time.Time) *Feature {
	s.CreatedTime = &v
	return s
}

// SetDefaultVariation sets the DefaultVariation field's value.
func (s *Feature) SetDefaultVariation(v string) *Feature {
	s.DefaultVariation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Feature) SetDescription(v string) *Feature {
	s.Description = &v
	return s
}

// SetEntityOverrides sets the EntityOverrides field's value.
func (s *Feature) SetEntityOverrides(v map[string]*string) *Feature {
	s.EntityOverrides = v
	return s
}

// SetEvaluationRules sets the EvaluationRules field's value.
func (s *Feature) SetEvaluationRules(v []*EvaluationRule) *Feature {
	s.EvaluationRules = v
	return s
}

// SetEvaluationStrategy sets the EvaluationStrategy field's value.
func (s *Feature) SetEvaluationStrategy(v string) *Feature {
	s.EvaluationStrategy = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Feature) SetLastUpdatedTime(v time.Time) *Feature {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Feature) SetName(v string) *Feature {
	s.Name = &v
	return s
}

// SetProject sets the Project field's value.
func (s *Feature) SetProject(v string) *Feature {
	s.Project = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Feature) SetStatus(v string) *Feature {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Feature) SetTags(v map[string]*string) *Feature {
	s.Tags = v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *Feature) SetValueType(v string) *Feature {
	s.ValueType = &v
	return s
}

// SetVariations sets the Variations field's value.
func (s *Feature) SetVariations(v []*Variation) *Feature {
	s.Variations = v
	return s
}

// This structure contains information about one Evidently feature in your account.
type FeatureSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the feature.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time that the feature is created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp" required:"true"`

	// The name of the variation that is used as the default variation. The default
	// variation is served to users who are not allocated to any ongoing launches
	// or experiments of this feature.
	DefaultVariation *string `locationName:"defaultVariation" min:"1" type:"string"`

	// An array of structures that define
	EvaluationRules []*EvaluationRule `locationName:"evaluationRules" type:"list"`

	// If this value is ALL_RULES, the traffic allocation specified by any ongoing
	// launches or experiments is being used. If this is DEFAULT_VARIATION, the
	// default variation is being served to all users.
	//
	// EvaluationStrategy is a required field
	EvaluationStrategy *string `locationName:"evaluationStrategy" type:"string" required:"true" enum:"FeatureEvaluationStrategy"`

	// The date and time that the feature was most recently updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" required:"true"`

	// The name of the feature.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the feature.
	Project *string `locationName:"project" type:"string"`

	// The current state of the feature.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FeatureStatus"`

	// The list of tag keys and values associated with this feature.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FeatureSummary) SetArn(v string) *FeatureSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *FeatureSummary) SetCreatedTime(v time.Time) *FeatureSummary {
	s.CreatedTime = &v
	return s
}

// SetDefaultVariation sets the DefaultVariation field's value.
func (s *FeatureSummary) SetDefaultVariation(v string) *FeatureSummary {
	s.DefaultVariation = &v
	return s
}

// SetEvaluationRules sets the EvaluationRules field's value.
func (s *FeatureSummary) SetEvaluationRules(v []*EvaluationRule) *FeatureSummary {
	s.EvaluationRules = v
	return s
}

// SetEvaluationStrategy sets the EvaluationStrategy field's value.
func (s *FeatureSummary) SetEvaluationStrategy(v string) *FeatureSummary {
	s.EvaluationStrategy = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *FeatureSummary) SetLastUpdatedTime(v time.Time) *FeatureSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FeatureSummary) SetName(v string) *FeatureSummary {
	s.Name = &v
	return s
}

// SetProject sets the Project field's value.
func (s *FeatureSummary) SetProject(v string) *FeatureSummary {
	s.Project = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FeatureSummary) SetStatus(v string) *FeatureSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *FeatureSummary) SetTags(v map[string]*string) *FeatureSummary {
	s.Tags = v
	return s
}

type GetExperimentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the experiment that you want to see the details of.
	//
	// Experiment is a required field
	Experiment *string `location:"uri" locationName:"experiment" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the experiment.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExperimentInput"}
	if s.Experiment == nil {
		invalidParams.Add(request.NewErrParamRequired("Experiment"))
	}
	if s.Experiment != nil && len(*s.Experiment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Experiment", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExperiment sets the Experiment field's value.
func (s *GetExperimentInput) SetExperiment(v string) *GetExperimentInput {
	s.Experiment = &v
	return s
}

// SetProject sets the Project field's value.
func (s *GetExperimentInput) SetProject(v string) *GetExperimentInput {
	s.Project = &v
	return s
}

type GetExperimentOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the configuration details of the experiment.
	Experiment *Experiment `locationName:"experiment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentOutput) GoString() string {
	return s.String()
}

// SetExperiment sets the Experiment field's value.
func (s *GetExperimentOutput) SetExperiment(v *Experiment) *GetExperimentOutput {
	s.Experiment = v
	return s
}

type GetExperimentResultsInput struct {
	_ struct{} `type:"structure"`

	// The statistic used to calculate experiment results. Currently the only valid
	// value is mean, which uses the mean of the collected values as the statistic.
	BaseStat *string `locationName:"baseStat" type:"string" enum:"ExperimentBaseStat"`

	// The date and time that the experiment ended, if it is completed. This must
	// be no longer than 30 days after the experiment start time.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The name of the experiment to retrieve the results of.
	//
	// Experiment is a required field
	Experiment *string `location:"uri" locationName:"experiment" min:"1" type:"string" required:"true"`

	// The names of the experiment metrics that you want to see the results of.
	//
	// MetricNames is a required field
	MetricNames []*string `locationName:"metricNames" min:"1" type:"list" required:"true"`

	// In seconds, the amount of time to aggregate results together.
	Period *int64 `locationName:"period" min:"300" type:"long"`

	// The name or ARN of the project that contains the experiment that you want
	// to see the results of.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// The names of the report types that you want to see. Currently, BayesianInference
	// is the only valid value.
	ReportNames []*string `locationName:"reportNames" type:"list" enum:"ExperimentReportName"`

	// The statistics that you want to see in the returned results.
	//
	//    * PValue specifies to use p-values for the results. A p-value is used
	//    in hypothesis testing to measure how often you are willing to make a mistake
	//    in rejecting the null hypothesis. A general practice is to reject the
	//    null hypothesis and declare that the results are statistically significant
	//    when the p-value is less than 0.05.
	//
	//    * ConfidenceInterval specifies a confidence interval for the results.
	//    The confidence interval represents the range of values for the chosen
	//    metric that is likely to contain the true difference between the baseStat
	//    of a variation and the baseline. Evidently returns the 95% confidence
	//    interval.
	//
	//    * TreatmentEffect is the difference in the statistic specified by the
	//    baseStat parameter between each variation and the default variation.
	//
	//    * BaseStat returns the statistical values collected for the metric for
	//    each variation. The statistic uses the same statistic specified in the
	//    baseStat parameter. Therefore, if baseStat is mean, this returns the mean
	//    of the values collected for each variation.
	ResultStats []*string `locationName:"resultStats" type:"list" enum:"ExperimentResultRequestType"`

	// The date and time that the experiment started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The names of the experiment treatments that you want to see the results for.
	//
	// TreatmentNames is a required field
	TreatmentNames []*string `locationName:"treatmentNames" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExperimentResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExperimentResultsInput"}
	if s.Experiment == nil {
		invalidParams.Add(request.NewErrParamRequired("Experiment"))
	}
	if s.Experiment != nil && len(*s.Experiment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Experiment", 1))
	}
	if s.MetricNames == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricNames"))
	}
	if s.MetricNames != nil && len(s.MetricNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricNames", 1))
	}
	if s.Period != nil && *s.Period < 300 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 300))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.TreatmentNames == nil {
		invalidParams.Add(request.NewErrParamRequired("TreatmentNames"))
	}
	if s.TreatmentNames != nil && len(s.TreatmentNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TreatmentNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseStat sets the BaseStat field's value.
func (s *GetExperimentResultsInput) SetBaseStat(v string) *GetExperimentResultsInput {
	s.BaseStat = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetExperimentResultsInput) SetEndTime(v time.Time) *GetExperimentResultsInput {
	s.EndTime = &v
	return s
}

// SetExperiment sets the Experiment field's value.
func (s *GetExperimentResultsInput) SetExperiment(v string) *GetExperimentResultsInput {
	s.Experiment = &v
	return s
}

// SetMetricNames sets the MetricNames field's value.
func (s *GetExperimentResultsInput) SetMetricNames(v []*string) *GetExperimentResultsInput {
	s.MetricNames = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetExperimentResultsInput) SetPeriod(v int64) *GetExperimentResultsInput {
	s.Period = &v
	return s
}

// SetProject sets the Project field's value.
func (s *GetExperimentResultsInput) SetProject(v string) *GetExperimentResultsInput {
	s.Project = &v
	return s
}

// SetReportNames sets the ReportNames field's value.
func (s *GetExperimentResultsInput) SetReportNames(v []*string) *GetExperimentResultsInput {
	s.ReportNames = v
	return s
}

// SetResultStats sets the ResultStats field's value.
func (s *GetExperimentResultsInput) SetResultStats(v []*string) *GetExperimentResultsInput {
	s.ResultStats = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetExperimentResultsInput) SetStartTime(v time.Time) *GetExperimentResultsInput {
	s.StartTime = &v
	return s
}

// SetTreatmentNames sets the TreatmentNames field's value.
func (s *GetExperimentResultsInput) SetTreatmentNames(v []*string) *GetExperimentResultsInput {
	s.TreatmentNames = v
	return s
}

type GetExperimentResultsOutput struct {
	_ struct{} `type:"structure"`

	// If the experiment doesn't yet have enough events to provide valid results,
	// this field is returned with the message Not enough events to generate results.
	// If there are enough events to provide valid results, this field is not returned.
	Details *string `locationName:"details" type:"string"`

	// An array of structures that include the reports that you requested.
	Reports []*ExperimentReport `locationName:"reports" type:"list"`

	// An array of structures that include experiment results including metric names
	// and values.
	ResultsData []*ExperimentResultsData `locationName:"resultsData" type:"list"`

	// The timestamps of each result returned.
	Timestamps []*time.Time `locationName:"timestamps" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExperimentResultsOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *GetExperimentResultsOutput) SetDetails(v string) *GetExperimentResultsOutput {
	s.Details = &v
	return s
}

// SetReports sets the Reports field's value.
func (s *GetExperimentResultsOutput) SetReports(v []*ExperimentReport) *GetExperimentResultsOutput {
	s.Reports = v
	return s
}

// SetResultsData sets the ResultsData field's value.
func (s *GetExperimentResultsOutput) SetResultsData(v []*ExperimentResultsData) *GetExperimentResultsOutput {
	s.ResultsData = v
	return s
}

// SetTimestamps sets the Timestamps field's value.
func (s *GetExperimentResultsOutput) SetTimestamps(v []*time.Time) *GetExperimentResultsOutput {
	s.Timestamps = v
	return s
}

type GetFeatureInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the feature that you want to retrieve information for.
	//
	// Feature is a required field
	Feature *string `location:"uri" locationName:"feature" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the feature.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFeatureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFeatureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFeatureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFeatureInput"}
	if s.Feature == nil {
		invalidParams.Add(request.NewErrParamRequired("Feature"))
	}
	if s.Feature != nil && len(*s.Feature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Feature", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeature sets the Feature field's value.
func (s *GetFeatureInput) SetFeature(v string) *GetFeatureInput {
	s.Feature = &v
	return s
}

// SetProject sets the Project field's value.
func (s *GetFeatureInput) SetProject(v string) *GetFeatureInput {
	s.Project = &v
	return s
}

type GetFeatureOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the configuration details of the feature.
	//
	// Feature is a required field
	Feature *Feature `locationName:"feature" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFeatureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFeatureOutput) GoString() string {
	return s.String()
}

// SetFeature sets the Feature field's value.
func (s *GetFeatureOutput) SetFeature(v *Feature) *GetFeatureOutput {
	s.Feature = v
	return s
}

type GetLaunchInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the launch that you want to see the details of.
	//
	// Launch is a required field
	Launch *string `location:"uri" locationName:"launch" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the launch.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLaunchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLaunchInput"}
	if s.Launch == nil {
		invalidParams.Add(request.NewErrParamRequired("Launch"))
	}
	if s.Launch != nil && len(*s.Launch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Launch", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunch sets the Launch field's value.
func (s *GetLaunchInput) SetLaunch(v string) *GetLaunchInput {
	s.Launch = &v
	return s
}

// SetProject sets the Project field's value.
func (s *GetLaunchInput) SetProject(v string) *GetLaunchInput {
	s.Project = &v
	return s
}

type GetLaunchOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the configuration details of the launch.
	Launch *Launch `locationName:"launch" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchOutput) GoString() string {
	return s.String()
}

// SetLaunch sets the Launch field's value.
func (s *GetLaunchOutput) SetLaunch(v *Launch) *GetLaunchOutput {
	s.Launch = v
	return s
}

type GetProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name or ARN of the project that you want to see the details of.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProjectInput"}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProject sets the Project field's value.
func (s *GetProjectInput) SetProject(v string) *GetProjectInput {
	s.Project = &v
	return s
}

type GetProjectOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the configuration details of the project.
	//
	// Project is a required field
	Project *Project `locationName:"project" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *GetProjectOutput) SetProject(v *Project) *GetProjectOutput {
	s.Project = v
	return s
}

type GetSegmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the segment to return information for.
	//
	// Segment is a required field
	Segment *string `location:"uri" locationName:"segment" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentInput"}
	if s.Segment == nil {
		invalidParams.Add(request.NewErrParamRequired("Segment"))
	}
	if s.Segment != nil && len(*s.Segment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Segment", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSegment sets the Segment field's value.
func (s *GetSegmentInput) SetSegment(v string) *GetSegmentInput {
	s.Segment = &v
	return s
}

type GetSegmentOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the complete information about the segment.
	//
	// Segment is a required field
	Segment *Segment `locationName:"segment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSegmentOutput) GoString() string {
	return s.String()
}

// SetSegment sets the Segment field's value.
func (s *GetSegmentOutput) SetSegment(v *Segment) *GetSegmentOutput {
	s.Segment = v
	return s
}

// Unexpected error while processing the request. Retry the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This structure contains the configuration details of one Evidently launch.
type Launch struct {
	_ struct{} `type:"structure"`

	// The ARN of the launch.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time that the launch is created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp" required:"true"`

	// The description of the launch.
	Description *string `locationName:"description" type:"string"`

	// A structure that contains information about the start and end times of the
	// launch.
	Execution *LaunchExecution `locationName:"execution" type:"structure"`

	// An array of structures that define the feature variations that are being
	// used in the launch.
	Groups []*LaunchGroup `locationName:"groups" type:"list"`

	// The date and time that the launch was most recently updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" required:"true"`

	// An array of structures that define the metrics that are being used to monitor
	// the launch performance.
	MetricMonitors []*MetricMonitor `locationName:"metricMonitors" type:"list"`

	// The name of the launch.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the launch.
	Project *string `locationName:"project" type:"string"`

	// This value is used when Evidently assigns a particular user session to the
	// launch, to help create a randomization ID to determine which variation the
	// user session is served. This randomization ID is a combination of the entity
	// ID and randomizationSalt.
	RandomizationSalt *string `locationName:"randomizationSalt" type:"string"`

	// An array of structures that define the traffic allocation percentages among
	// the feature variations during each step of the launch.
	ScheduledSplitsDefinition *ScheduledSplitsLaunchDefinition `locationName:"scheduledSplitsDefinition" type:"structure"`

	// The current state of the launch.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"LaunchStatus"`

	// If the launch was stopped, this is the string that was entered by the person
	// who stopped the launch, to explain why it was stopped.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The list of tag keys and values associated with this launch.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of launch.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"LaunchType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Launch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Launch) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Launch) SetArn(v string) *Launch {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Launch) SetCreatedTime(v time.Time) *Launch {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Launch) SetDescription(v string) *Launch {
	s.Description = &v
	return s
}

// SetExecution sets the Execution field's value.
func (s *Launch) SetExecution(v *LaunchExecution) *Launch {
	s.Execution = v
	return s
}

// SetGroups sets the Groups field's value.
func (s *Launch) SetGroups(v []*LaunchGroup) *Launch {
	s.Groups = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Launch) SetLastUpdatedTime(v time.Time) *Launch {
	s.LastUpdatedTime = &v
	return s
}

// SetMetricMonitors sets the MetricMonitors field's value.
func (s *Launch) SetMetricMonitors(v []*MetricMonitor) *Launch {
	s.MetricMonitors = v
	return s
}

// SetName sets the Name field's value.
func (s *Launch) SetName(v string) *Launch {
	s.Name = &v
	return s
}

// SetProject sets the Project field's value.
func (s *Launch) SetProject(v string) *Launch {
	s.Project = &v
	return s
}

// SetRandomizationSalt sets the RandomizationSalt field's value.
func (s *Launch) SetRandomizationSalt(v string) *Launch {
	s.RandomizationSalt = &v
	return s
}

// SetScheduledSplitsDefinition sets the ScheduledSplitsDefinition field's value.
func (s *Launch) SetScheduledSplitsDefinition(v *ScheduledSplitsLaunchDefinition) *Launch {
	s.ScheduledSplitsDefinition = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Launch) SetStatus(v string) *Launch {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *Launch) SetStatusReason(v string) *Launch {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Launch) SetTags(v map[string]*string) *Launch {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Launch) SetType(v string) *Launch {
	s.Type = &v
	return s
}

// This structure contains information about the start and end times of the
// launch.
type LaunchExecution struct {
	_ struct{} `type:"structure"`

	// The date and time that the launch ended.
	EndedTime *time.Time `locationName:"endedTime" type:"timestamp"`

	// The date and time that the launch started.
	StartedTime *time.Time `locationName:"startedTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchExecution) GoString() string {
	return s.String()
}

// SetEndedTime sets the EndedTime field's value.
func (s *LaunchExecution) SetEndedTime(v time.Time) *LaunchExecution {
	s.EndedTime = &v
	return s
}

// SetStartedTime sets the StartedTime field's value.
func (s *LaunchExecution) SetStartedTime(v time.Time) *LaunchExecution {
	s.StartedTime = &v
	return s
}

// A structure that defines one launch group in a launch. A launch group is
// a variation of the feature that you are including in the launch.
type LaunchGroup struct {
	_ struct{} `type:"structure"`

	// A description of the launch group.
	Description *string `locationName:"description" type:"string"`

	// The feature variation for this launch group. This is a key-value pair.
	//
	// FeatureVariations is a required field
	FeatureVariations map[string]*string `locationName:"featureVariations" type:"map" required:"true"`

	// The name of the launch group.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchGroup) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *LaunchGroup) SetDescription(v string) *LaunchGroup {
	s.Description = &v
	return s
}

// SetFeatureVariations sets the FeatureVariations field's value.
func (s *LaunchGroup) SetFeatureVariations(v map[string]*string) *LaunchGroup {
	s.FeatureVariations = v
	return s
}

// SetName sets the Name field's value.
func (s *LaunchGroup) SetName(v string) *LaunchGroup {
	s.Name = &v
	return s
}

// A structure that defines one launch group in a launch. A launch group is
// a variation of the feature that you are including in the launch.
type LaunchGroupConfig struct {
	_ struct{} `type:"structure"`

	// A description of the launch group.
	Description *string `locationName:"description" type:"string"`

	// The feature that this launch is using.
	//
	// Feature is a required field
	Feature *string `locationName:"feature" min:"1" type:"string" required:"true"`

	// A name for this launch group.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The feature variation to use for this launch group.
	//
	// Variation is a required field
	Variation *string `locationName:"variation" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchGroupConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchGroupConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchGroupConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LaunchGroupConfig"}
	if s.Feature == nil {
		invalidParams.Add(request.NewErrParamRequired("Feature"))
	}
	if s.Feature != nil && len(*s.Feature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Feature", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Variation == nil {
		invalidParams.Add(request.NewErrParamRequired("Variation"))
	}
	if s.Variation != nil && len(*s.Variation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Variation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *LaunchGroupConfig) SetDescription(v string) *LaunchGroupConfig {
	s.Description = &v
	return s
}

// SetFeature sets the Feature field's value.
func (s *LaunchGroupConfig) SetFeature(v string) *LaunchGroupConfig {
	s.Feature = &v
	return s
}

// SetName sets the Name field's value.
func (s *LaunchGroupConfig) SetName(v string) *LaunchGroupConfig {
	s.Name = &v
	return s
}

// SetVariation sets the Variation field's value.
func (s *LaunchGroupConfig) SetVariation(v string) *LaunchGroupConfig {
	s.Variation = &v
	return s
}

type ListExperimentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use when requesting the next set of results. You received this
	// token from a previous ListExperiments operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name or ARN of the project to return the experiment list from.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// Use this optional parameter to limit the returned results to only the experiments
	// with the status that you specify here.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"ExperimentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExperimentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExperimentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExperimentsInput) SetMaxResults(v int64) *ListExperimentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentsInput) SetNextToken(v string) *ListExperimentsInput {
	s.NextToken = &v
	return s
}

// SetProject sets the Project field's value.
func (s *ListExperimentsInput) SetProject(v string) *ListExperimentsInput {
	s.Project = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListExperimentsInput) SetStatus(v string) *ListExperimentsInput {
	s.Status = &v
	return s
}

type ListExperimentsOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain the configuration details of the experiments
	// in the specified project.
	Experiments []*Experiment `locationName:"experiments" type:"list"`

	// The token to use in a subsequent ListExperiments operation to return the
	// next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExperimentsOutput) GoString() string {
	return s.String()
}

// SetExperiments sets the Experiments field's value.
func (s *ListExperimentsOutput) SetExperiments(v []*Experiment) *ListExperimentsOutput {
	s.Experiments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExperimentsOutput) SetNextToken(v string) *ListExperimentsOutput {
	s.NextToken = &v
	return s
}

type ListFeaturesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use when requesting the next set of results. You received this
	// token from a previous ListFeatures operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name or ARN of the project to return the feature list from.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFeaturesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFeaturesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFeaturesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFeaturesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFeaturesInput) SetMaxResults(v int64) *ListFeaturesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFeaturesInput) SetNextToken(v string) *ListFeaturesInput {
	s.NextToken = &v
	return s
}

// SetProject sets the Project field's value.
func (s *ListFeaturesInput) SetProject(v string) *ListFeaturesInput {
	s.Project = &v
	return s
}

type ListFeaturesOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain the configuration details of the features
	// in the specified project.
	Features []*FeatureSummary `locationName:"features" type:"list"`

	// The token to use in a subsequent ListFeatures operation to return the next
	// set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFeaturesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFeaturesOutput) GoString() string {
	return s.String()
}

// SetFeatures sets the Features field's value.
func (s *ListFeaturesOutput) SetFeatures(v []*FeatureSummary) *ListFeaturesOutput {
	s.Features = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFeaturesOutput) SetNextToken(v string) *ListFeaturesOutput {
	s.NextToken = &v
	return s
}

type ListLaunchesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use when requesting the next set of results. You received this
	// token from a previous ListLaunches operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name or ARN of the project to return the launch list from.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// Use this optional parameter to limit the returned results to only the launches
	// with the status that you specify here.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"LaunchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLaunchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLaunchesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLaunchesInput) SetMaxResults(v int64) *ListLaunchesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLaunchesInput) SetNextToken(v string) *ListLaunchesInput {
	s.NextToken = &v
	return s
}

// SetProject sets the Project field's value.
func (s *ListLaunchesInput) SetProject(v string) *ListLaunchesInput {
	s.Project = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListLaunchesInput) SetStatus(v string) *ListLaunchesInput {
	s.Status = &v
	return s
}

type ListLaunchesOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain the configuration details of the launches
	// in the specified project.
	Launches []*Launch `locationName:"launches" type:"list"`

	// The token to use in a subsequent ListLaunches operation to return the next
	// set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLaunchesOutput) GoString() string {
	return s.String()
}

// SetLaunches sets the Launches field's value.
func (s *ListLaunchesOutput) SetLaunches(v []*Launch) *ListLaunchesOutput {
	s.Launches = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLaunchesOutput) SetNextToken(v string) *ListLaunchesOutput {
	s.NextToken = &v
	return s
}

type ListProjectsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use when requesting the next set of results. You received this
	// token from a previous ListProjects operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use in a subsequent ListProjects operation to return the next
	// set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of structures that contain the configuration details of the projects
	// in the Region.
	Projects []*ProjectSummary `locationName:"projects" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*ProjectSummary) *ListProjectsOutput {
	s.Projects = v
	return s
}

type ListSegmentReferencesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response. If you omit this,
	// the default of 50 is used.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use when requesting the next set of results. You received this
	// token from a previous ListSegmentReferences operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ARN of the segment that you want to view information for.
	//
	// Segment is a required field
	Segment *string `location:"uri" locationName:"segment" type:"string" required:"true"`

	// Specifies whether to return information about launches or experiments that
	// use this segment.
	//
	// Type is a required field
	Type *string `location:"querystring" locationName:"type" type:"string" required:"true" enum:"SegmentReferenceResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSegmentReferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSegmentReferencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSegmentReferencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSegmentReferencesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Segment == nil {
		invalidParams.Add(request.NewErrParamRequired("Segment"))
	}
	if s.Segment != nil && len(*s.Segment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Segment", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSegmentReferencesInput) SetMaxResults(v int64) *ListSegmentReferencesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSegmentReferencesInput) SetNextToken(v string) *ListSegmentReferencesInput {
	s.NextToken = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *ListSegmentReferencesInput) SetSegment(v string) *ListSegmentReferencesInput {
	s.Segment = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListSegmentReferencesInput) SetType(v string) *ListSegmentReferencesInput {
	s.Type = &v
	return s
}

type ListSegmentReferencesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use in a subsequent ListSegmentReferences operation to return
	// the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of structures, where each structure contains information about one
	// experiment or launch that uses this segment.
	ReferencedBy []*RefResource `locationName:"referencedBy" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSegmentReferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSegmentReferencesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSegmentReferencesOutput) SetNextToken(v string) *ListSegmentReferencesOutput {
	s.NextToken = &v
	return s
}

// SetReferencedBy sets the ReferencedBy field's value.
func (s *ListSegmentReferencesOutput) SetReferencedBy(v []*RefResource) *ListSegmentReferencesOutput {
	s.ReferencedBy = v
	return s
}

type ListSegmentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response. If you omit this,
	// the default of 50 is used.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use when requesting the next set of results. You received this
	// token from a previous ListSegments operation.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSegmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSegmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSegmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSegmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSegmentsInput) SetMaxResults(v int64) *ListSegmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSegmentsInput) SetNextToken(v string) *ListSegmentsInput {
	s.NextToken = &v
	return s
}

type ListSegmentsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use in a subsequent ListSegments operation to return the next
	// set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of structures that contain information about the segments in this
	// Region.
	Segments []*Segment `locationName:"segments" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSegmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSegmentsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSegmentsOutput) SetNextToken(v string) *ListSegmentsOutput {
	s.NextToken = &v
	return s
}

// SetSegments sets the Segments field's value.
func (s *ListSegmentsOutput) SetSegments(v []*Segment) *ListSegmentsOutput {
	s.Segments = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource that you want to see the tags of.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tag keys and values associated with the resource you specified.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// This structure defines a metric that is being used to evaluate the variations
// during a launch or experiment.
type MetricDefinition struct {
	_ struct{} `type:"structure"`

	// The entity, such as a user or session, that does an action that causes a
	// metric value to be recorded.
	EntityIdKey *string `locationName:"entityIdKey" min:"1" type:"string"`

	// The EventBridge event pattern that defines how the metric is recorded.
	//
	// For more information about EventBridge event patterns, see Amazon EventBridge
	// event patterns (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html).
	EventPattern *string `locationName:"eventPattern" type:"string"`

	// The name of the metric.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The label for the units that the metric is measuring.
	UnitLabel *string `locationName:"unitLabel" min:"1" type:"string"`

	// The value that is tracked to produce the metric.
	ValueKey *string `locationName:"valueKey" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDefinition) GoString() string {
	return s.String()
}

// SetEntityIdKey sets the EntityIdKey field's value.
func (s *MetricDefinition) SetEntityIdKey(v string) *MetricDefinition {
	s.EntityIdKey = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *MetricDefinition) SetEventPattern(v string) *MetricDefinition {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *MetricDefinition) SetName(v string) *MetricDefinition {
	s.Name = &v
	return s
}

// SetUnitLabel sets the UnitLabel field's value.
func (s *MetricDefinition) SetUnitLabel(v string) *MetricDefinition {
	s.UnitLabel = &v
	return s
}

// SetValueKey sets the ValueKey field's value.
func (s *MetricDefinition) SetValueKey(v string) *MetricDefinition {
	s.ValueKey = &v
	return s
}

// This structure defines a metric that you want to use to evaluate the variations
// during a launch or experiment.
type MetricDefinitionConfig struct {
	_ struct{} `type:"structure"`

	// The entity, such as a user or session, that does an action that causes a
	// metric value to be recorded. An example is userDetails.userID.
	//
	// EntityIdKey is a required field
	EntityIdKey *string `locationName:"entityIdKey" min:"1" type:"string" required:"true"`

	// The EventBridge event pattern that defines how the metric is recorded.
	//
	// For more information about EventBridge event patterns, see Amazon EventBridge
	// event patterns (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html).
	EventPattern *string `locationName:"eventPattern" type:"string"`

	// A name for the metric.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A label for the units that the metric is measuring.
	UnitLabel *string `locationName:"unitLabel" min:"1" type:"string"`

	// The value that is tracked to produce the metric.
	//
	// ValueKey is a required field
	ValueKey *string `locationName:"valueKey" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDefinitionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDefinitionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDefinitionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDefinitionConfig"}
	if s.EntityIdKey == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityIdKey"))
	}
	if s.EntityIdKey != nil && len(*s.EntityIdKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityIdKey", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UnitLabel != nil && len(*s.UnitLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UnitLabel", 1))
	}
	if s.ValueKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ValueKey"))
	}
	if s.ValueKey != nil && len(*s.ValueKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityIdKey sets the EntityIdKey field's value.
func (s *MetricDefinitionConfig) SetEntityIdKey(v string) *MetricDefinitionConfig {
	s.EntityIdKey = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *MetricDefinitionConfig) SetEventPattern(v string) *MetricDefinitionConfig {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *MetricDefinitionConfig) SetName(v string) *MetricDefinitionConfig {
	s.Name = &v
	return s
}

// SetUnitLabel sets the UnitLabel field's value.
func (s *MetricDefinitionConfig) SetUnitLabel(v string) *MetricDefinitionConfig {
	s.UnitLabel = &v
	return s
}

// SetValueKey sets the ValueKey field's value.
func (s *MetricDefinitionConfig) SetValueKey(v string) *MetricDefinitionConfig {
	s.ValueKey = &v
	return s
}

// A structure that tells Evidently whether higher or lower values are desired
// for a metric that is used in an experiment.
type MetricGoal struct {
	_ struct{} `type:"structure"`

	// INCREASE means that a variation with a higher number for this metric is performing
	// better.
	//
	// DECREASE means that a variation with a lower number for this metric is performing
	// better.
	DesiredChange *string `locationName:"desiredChange" type:"string" enum:"ChangeDirectionEnum"`

	// A structure that contains details about the metric.
	//
	// MetricDefinition is a required field
	MetricDefinition *MetricDefinition `locationName:"metricDefinition" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricGoal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricGoal) GoString() string {
	return s.String()
}

// SetDesiredChange sets the DesiredChange field's value.
func (s *MetricGoal) SetDesiredChange(v string) *MetricGoal {
	s.DesiredChange = &v
	return s
}

// SetMetricDefinition sets the MetricDefinition field's value.
func (s *MetricGoal) SetMetricDefinition(v *MetricDefinition) *MetricGoal {
	s.MetricDefinition = v
	return s
}

// Use this structure to tell Evidently whether higher or lower values are desired
// for a metric that is used in an experiment.
type MetricGoalConfig struct {
	_ struct{} `type:"structure"`

	// INCREASE means that a variation with a higher number for this metric is performing
	// better.
	//
	// DECREASE means that a variation with a lower number for this metric is performing
	// better.
	DesiredChange *string `locationName:"desiredChange" type:"string" enum:"ChangeDirectionEnum"`

	// A structure that contains details about the metric.
	//
	// MetricDefinition is a required field
	MetricDefinition *MetricDefinitionConfig `locationName:"metricDefinition" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricGoalConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricGoalConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricGoalConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricGoalConfig"}
	if s.MetricDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricDefinition"))
	}
	if s.MetricDefinition != nil {
		if err := s.MetricDefinition.Validate(); err != nil {
			invalidParams.AddNested("MetricDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredChange sets the DesiredChange field's value.
func (s *MetricGoalConfig) SetDesiredChange(v string) *MetricGoalConfig {
	s.DesiredChange = &v
	return s
}

// SetMetricDefinition sets the MetricDefinition field's value.
func (s *MetricGoalConfig) SetMetricDefinition(v *MetricDefinitionConfig) *MetricGoalConfig {
	s.MetricDefinition = v
	return s
}

// A structure that defines a metric to be used to monitor performance of the
// variations during a launch.
type MetricMonitor struct {
	_ struct{} `type:"structure"`

	// A structure that defines the metric.
	//
	// MetricDefinition is a required field
	MetricDefinition *MetricDefinition `locationName:"metricDefinition" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricMonitor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricMonitor) GoString() string {
	return s.String()
}

// SetMetricDefinition sets the MetricDefinition field's value.
func (s *MetricMonitor) SetMetricDefinition(v *MetricDefinition) *MetricMonitor {
	s.MetricDefinition = v
	return s
}

// A structure that defines a metric to be used to monitor performance of the
// variations during a launch.
type MetricMonitorConfig struct {
	_ struct{} `type:"structure"`

	// A structure that defines the metric.
	//
	// MetricDefinition is a required field
	MetricDefinition *MetricDefinitionConfig `locationName:"metricDefinition" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricMonitorConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricMonitorConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricMonitorConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricMonitorConfig"}
	if s.MetricDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricDefinition"))
	}
	if s.MetricDefinition != nil {
		if err := s.MetricDefinition.Validate(); err != nil {
			invalidParams.AddNested("MetricDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricDefinition sets the MetricDefinition field's value.
func (s *MetricMonitorConfig) SetMetricDefinition(v *MetricDefinitionConfig) *MetricMonitorConfig {
	s.MetricDefinition = v
	return s
}

// A structure that contains the configuration of which variation to use as
// the "control" version. The "control" version is used for comparison with
// other variations. This structure also specifies how much experiment traffic
// is allocated to each variation.
type OnlineAbConfig struct {
	_ struct{} `type:"structure"`

	// The name of the variation that is to be the default variation that the other
	// variations are compared to.
	ControlTreatmentName *string `locationName:"controlTreatmentName" min:"1" type:"string"`

	// A set of key-value pairs. The keys are variation names, and the values are
	// the portion of experiment traffic to be assigned to that variation. Specify
	// the traffic portion in thousandths of a percent, so 20,000 for a variation
	// would allocate 20% of the experiment traffic to that variation.
	TreatmentWeights map[string]*int64 `locationName:"treatmentWeights" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OnlineAbConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OnlineAbConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnlineAbConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OnlineAbConfig"}
	if s.ControlTreatmentName != nil && len(*s.ControlTreatmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlTreatmentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlTreatmentName sets the ControlTreatmentName field's value.
func (s *OnlineAbConfig) SetControlTreatmentName(v string) *OnlineAbConfig {
	s.ControlTreatmentName = &v
	return s
}

// SetTreatmentWeights sets the TreatmentWeights field's value.
func (s *OnlineAbConfig) SetTreatmentWeights(v map[string]*int64) *OnlineAbConfig {
	s.TreatmentWeights = v
	return s
}

// A structure that contains the configuration of which variation to use as
// the "control" version. The "control" version is used for comparison with
// other variations. This structure also specifies how much experiment traffic
// is allocated to each variation.
type OnlineAbDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the variation that is the default variation that the other variations
	// are compared to.
	ControlTreatmentName *string `locationName:"controlTreatmentName" min:"1" type:"string"`

	// A set of key-value pairs. The keys are variation names, and the values are
	// the portion of experiment traffic to be assigned to that variation. The traffic
	// portion is specified in thousandths of a percent, so 20,000 for a variation
	// would allocate 20% of the experiment traffic to that variation.
	TreatmentWeights map[string]*int64 `locationName:"treatmentWeights" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OnlineAbDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OnlineAbDefinition) GoString() string {
	return s.String()
}

// SetControlTreatmentName sets the ControlTreatmentName field's value.
func (s *OnlineAbDefinition) SetControlTreatmentName(v string) *OnlineAbDefinition {
	s.ControlTreatmentName = &v
	return s
}

// SetTreatmentWeights sets the TreatmentWeights field's value.
func (s *OnlineAbDefinition) SetTreatmentWeights(v map[string]*int64) *OnlineAbDefinition {
	s.TreatmentWeights = v
	return s
}

// This structure defines a project, which is the logical object in Evidently
// that can contain features, launches, and experiments. Use projects to group
// similar features together.
type Project struct {
	_ struct{} `type:"structure"`

	// The number of ongoing experiments currently in the project.
	ActiveExperimentCount *int64 `locationName:"activeExperimentCount" type:"long"`

	// The number of ongoing launches currently in the project.
	ActiveLaunchCount *int64 `locationName:"activeLaunchCount" type:"long"`

	// The name or ARN of the project.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time that the project is created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp" required:"true"`

	// A structure that contains information about where Evidently is to store evaluation
	// events for longer term storage.
	DataDelivery *ProjectDataDelivery `locationName:"dataDelivery" type:"structure"`

	// The user-entered description of the project.
	Description *string `locationName:"description" type:"string"`

	// The number of experiments currently in the project. This includes all experiments
	// that have been created and not deleted, whether they are ongoing or not.
	ExperimentCount *int64 `locationName:"experimentCount" type:"long"`

	// The number of features currently in the project.
	FeatureCount *int64 `locationName:"featureCount" type:"long"`

	// The date and time that the project was most recently updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" required:"true"`

	// The number of launches currently in the project. This includes all launches
	// that have been created and not deleted, whether they are ongoing or not.
	LaunchCount *int64 `locationName:"launchCount" type:"long"`

	// The name of the project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current state of the project.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ProjectStatus"`

	// The list of tag keys and values associated with this project.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Project) GoString() string {
	return s.String()
}

// SetActiveExperimentCount sets the ActiveExperimentCount field's value.
func (s *Project) SetActiveExperimentCount(v int64) *Project {
	s.ActiveExperimentCount = &v
	return s
}

// SetActiveLaunchCount sets the ActiveLaunchCount field's value.
func (s *Project) SetActiveLaunchCount(v int64) *Project {
	s.ActiveLaunchCount = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Project) SetArn(v string) *Project {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Project) SetCreatedTime(v time.Time) *Project {
	s.CreatedTime = &v
	return s
}

// SetDataDelivery sets the DataDelivery field's value.
func (s *Project) SetDataDelivery(v *ProjectDataDelivery) *Project {
	s.DataDelivery = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Project) SetDescription(v string) *Project {
	s.Description = &v
	return s
}

// SetExperimentCount sets the ExperimentCount field's value.
func (s *Project) SetExperimentCount(v int64) *Project {
	s.ExperimentCount = &v
	return s
}

// SetFeatureCount sets the FeatureCount field's value.
func (s *Project) SetFeatureCount(v int64) *Project {
	s.FeatureCount = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Project) SetLastUpdatedTime(v time.Time) *Project {
	s.LastUpdatedTime = &v
	return s
}

// SetLaunchCount sets the LaunchCount field's value.
func (s *Project) SetLaunchCount(v int64) *Project {
	s.LaunchCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *Project) SetName(v string) *Project {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Project) SetStatus(v string) *Project {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Project) SetTags(v map[string]*string) *Project {
	s.Tags = v
	return s
}

// A structure that contains information about where Evidently is to store evaluation
// events for longer term storage.
type ProjectDataDelivery struct {
	_ struct{} `type:"structure"`

	// If the project stores evaluation events in CloudWatch Logs, this structure
	// stores the log group name.
	CloudWatchLogs *CloudWatchLogsDestination `locationName:"cloudWatchLogs" type:"structure"`

	// If the project stores evaluation events in an Amazon S3 bucket, this structure
	// stores the bucket name and bucket prefix.
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDataDelivery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDataDelivery) GoString() string {
	return s.String()
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *ProjectDataDelivery) SetCloudWatchLogs(v *CloudWatchLogsDestination) *ProjectDataDelivery {
	s.CloudWatchLogs = v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *ProjectDataDelivery) SetS3Destination(v *S3Destination) *ProjectDataDelivery {
	s.S3Destination = v
	return s
}

// A structure that contains information about where Evidently is to store evaluation
// events for longer term storage.
type ProjectDataDeliveryConfig struct {
	_ struct{} `type:"structure"`

	// If the project stores evaluation events in CloudWatch Logs, this structure
	// stores the log group name.
	CloudWatchLogs *CloudWatchLogsDestinationConfig `locationName:"cloudWatchLogs" type:"structure"`

	// If the project stores evaluation events in an Amazon S3 bucket, this structure
	// stores the bucket name and bucket prefix.
	S3Destination *S3DestinationConfig `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDataDeliveryConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDataDeliveryConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectDataDeliveryConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectDataDeliveryConfig"}
	if s.CloudWatchLogs != nil {
		if err := s.CloudWatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *ProjectDataDeliveryConfig) SetCloudWatchLogs(v *CloudWatchLogsDestinationConfig) *ProjectDataDeliveryConfig {
	s.CloudWatchLogs = v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *ProjectDataDeliveryConfig) SetS3Destination(v *S3DestinationConfig) *ProjectDataDeliveryConfig {
	s.S3Destination = v
	return s
}

// A structure that contains configuration information about an Evidently project.
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// The number of experiments currently in the project.
	ActiveExperimentCount *int64 `locationName:"activeExperimentCount" type:"long"`

	// The number of ongoing launches currently in the project.
	ActiveLaunchCount *int64 `locationName:"activeLaunchCount" type:"long"`

	// The name or ARN of the project.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time that the project is created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp" required:"true"`

	// The description of the project.
	Description *string `locationName:"description" type:"string"`

	// The number of experiments currently in the project.
	ExperimentCount *int64 `locationName:"experimentCount" type:"long"`

	// The number of features currently in the project.
	FeatureCount *int64 `locationName:"featureCount" type:"long"`

	// The date and time that the project was most recently updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" required:"true"`

	// The number of launches currently in the project, including launches that
	// are ongoing, completed, and not started yet.
	LaunchCount *int64 `locationName:"launchCount" type:"long"`

	// The name of the project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current state of the project.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ProjectStatus"`

	// The list of tag keys and values associated with this project.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectSummary) GoString() string {
	return s.String()
}

// SetActiveExperimentCount sets the ActiveExperimentCount field's value.
func (s *ProjectSummary) SetActiveExperimentCount(v int64) *ProjectSummary {
	s.ActiveExperimentCount = &v
	return s
}

// SetActiveLaunchCount sets the ActiveLaunchCount field's value.
func (s *ProjectSummary) SetActiveLaunchCount(v int64) *ProjectSummary {
	s.ActiveLaunchCount = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ProjectSummary) SetArn(v string) *ProjectSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ProjectSummary) SetCreatedTime(v time.Time) *ProjectSummary {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ProjectSummary) SetDescription(v string) *ProjectSummary {
	s.Description = &v
	return s
}

// SetExperimentCount sets the ExperimentCount field's value.
func (s *ProjectSummary) SetExperimentCount(v int64) *ProjectSummary {
	s.ExperimentCount = &v
	return s
}

// SetFeatureCount sets the FeatureCount field's value.
func (s *ProjectSummary) SetFeatureCount(v int64) *ProjectSummary {
	s.FeatureCount = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ProjectSummary) SetLastUpdatedTime(v time.Time) *ProjectSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetLaunchCount sets the LaunchCount field's value.
func (s *ProjectSummary) SetLaunchCount(v int64) *ProjectSummary {
	s.LaunchCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProjectSummary) SetName(v string) *ProjectSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProjectSummary) SetStatus(v string) *ProjectSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ProjectSummary) SetTags(v map[string]*string) *ProjectSummary {
	s.Tags = v
	return s
}

type PutProjectEventsInput struct {
	_ struct{} `type:"structure"`

	// An array of event structures that contain the performance data that is being
	// sent to Evidently.
	//
	// Events is a required field
	Events []*Event `locationName:"events" type:"list" required:"true"`

	// The name or ARN of the project to write the events to.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProjectEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProjectEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutProjectEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutProjectEventsInput"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.Events != nil {
		for i, v := range s.Events {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *PutProjectEventsInput) SetEvents(v []*Event) *PutProjectEventsInput {
	s.Events = v
	return s
}

// SetProject sets the Project field's value.
func (s *PutProjectEventsInput) SetProject(v string) *PutProjectEventsInput {
	s.Project = &v
	return s
}

type PutProjectEventsOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains Evidently's response to the sent events, including
	// an event ID and error codes, if any.
	EventResults []*PutProjectEventsResultEntry `locationName:"eventResults" type:"list"`

	// The number of events in the operation that could not be used by Evidently.
	FailedEventCount *int64 `locationName:"failedEventCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProjectEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProjectEventsOutput) GoString() string {
	return s.String()
}

// SetEventResults sets the EventResults field's value.
func (s *PutProjectEventsOutput) SetEventResults(v []*PutProjectEventsResultEntry) *PutProjectEventsOutput {
	s.EventResults = v
	return s
}

// SetFailedEventCount sets the FailedEventCount field's value.
func (s *PutProjectEventsOutput) SetFailedEventCount(v int64) *PutProjectEventsOutput {
	s.FailedEventCount = &v
	return s
}

// A structure that contains Evidently's response to the sent events, including
// an event ID and error codes, if any.
type PutProjectEventsResultEntry struct {
	_ struct{} `type:"structure"`

	// If the PutProjectEvents operation has an error, the error code is returned
	// here.
	ErrorCode *string `locationName:"errorCode" min:"1" type:"string"`

	// If the PutProjectEvents operation has an error, the error message is returned
	// here.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`

	// A unique ID assigned to this PutProjectEvents operation.
	EventId *string `locationName:"eventId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProjectEventsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutProjectEventsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutProjectEventsResultEntry) SetErrorCode(v string) *PutProjectEventsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutProjectEventsResultEntry) SetErrorMessage(v string) *PutProjectEventsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *PutProjectEventsResultEntry) SetEventId(v string) *PutProjectEventsResultEntry {
	s.EventId = &v
	return s
}

// A structure that contains information about one experiment or launch that
// uses the specified segment.
type RefResource struct {
	_ struct{} `type:"structure"`

	// The ARN of the experiment or launch.
	Arn *string `locationName:"arn" type:"string"`

	// The day and time that this experiment or launch ended.
	EndTime *string `locationName:"endTime" type:"string"`

	// The day and time that this experiment or launch was most recently updated.
	LastUpdatedOn *string `locationName:"lastUpdatedOn" type:"string"`

	// The name of the experiment or launch.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The day and time that this experiment or launch started.
	StartTime *string `locationName:"startTime" type:"string"`

	// The status of the experiment or launch.
	Status *string `locationName:"status" type:"string"`

	// Specifies whether the resource that this structure contains information about
	// is an experiment or a launch.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefResource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RefResource) SetArn(v string) *RefResource {
	s.Arn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *RefResource) SetEndTime(v string) *RefResource {
	s.EndTime = &v
	return s
}

// SetLastUpdatedOn sets the LastUpdatedOn field's value.
func (s *RefResource) SetLastUpdatedOn(v string) *RefResource {
	s.LastUpdatedOn = &v
	return s
}

// SetName sets the Name field's value.
func (s *RefResource) SetName(v string) *RefResource {
	s.Name = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *RefResource) SetStartTime(v string) *RefResource {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RefResource) SetStatus(v string) *RefResource {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *RefResource) SetType(v string) *RefResource {
	s.Type = &v
	return s
}

// The request references a resource that does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that caused the exception.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource that is associated with the error.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// If the project stores evaluation events in an Amazon S3 bucket, this structure
// stores the bucket name and bucket prefix.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// The name of the bucket in which Evidently stores evaluation events.
	Bucket *string `locationName:"bucket" min:"3" type:"string"`

	// The bucket prefix in which Evidently stores evaluation events.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *S3Destination) SetBucket(v string) *S3Destination {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Destination) SetPrefix(v string) *S3Destination {
	s.Prefix = &v
	return s
}

// If the project stores evaluation events in an Amazon S3 bucket, this structure
// stores the bucket name and bucket prefix.
type S3DestinationConfig struct {
	_ struct{} `type:"structure"`

	// The name of the bucket in which Evidently stores evaluation events.
	Bucket *string `locationName:"bucket" min:"3" type:"string"`

	// The bucket prefix in which Evidently stores evaluation events.
	Prefix *string `locationName:"prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationConfig"}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3DestinationConfig) SetBucket(v string) *S3DestinationConfig {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3DestinationConfig) SetPrefix(v string) *S3DestinationConfig {
	s.Prefix = &v
	return s
}

// This structure defines the traffic allocation percentages among the feature
// variations during one step of a launch, and the start time of that step.
type ScheduledSplit struct {
	_ struct{} `type:"structure"`

	// The traffic allocation percentages among the feature variations during one
	// step of a launch. This is a set of key-value pairs. The keys are variation
	// names. The values represent the percentage of traffic to allocate to that
	// variation during this step.
	//
	// The values is expressed in thousandths of a percent, so assigning a weight
	// of 50000 assigns 50% of traffic to that variation.
	//
	// If the sum of the weights for all the variations in a segment override does
	// not add up to 100,000, then the remaining traffic that matches this segment
	// is not assigned by this segment override, and instead moves on to the next
	// segment override or the default traffic split.
	GroupWeights map[string]*int64 `locationName:"groupWeights" type:"map"`

	// Use this parameter to specify different traffic splits for one or more audience
	// segments. A segment is a portion of your audience that share one or more
	// characteristics. Examples could be Chrome browser users, users in Europe,
	// or Firefox browser users in Europe who also fit other criteria that your
	// application collects, such as age.
	//
	// This parameter is an array of up to six segment override objects. Each of
	// these objects specifies a segment that you have already created, and defines
	// the traffic split for that segment.
	SegmentOverrides []*SegmentOverride `locationName:"segmentOverrides" type:"list"`

	// The date and time that this step of the launch starts.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledSplit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledSplit) GoString() string {
	return s.String()
}

// SetGroupWeights sets the GroupWeights field's value.
func (s *ScheduledSplit) SetGroupWeights(v map[string]*int64) *ScheduledSplit {
	s.GroupWeights = v
	return s
}

// SetSegmentOverrides sets the SegmentOverrides field's value.
func (s *ScheduledSplit) SetSegmentOverrides(v []*SegmentOverride) *ScheduledSplit {
	s.SegmentOverrides = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScheduledSplit) SetStartTime(v time.Time) *ScheduledSplit {
	s.StartTime = &v
	return s
}

// This structure defines the traffic allocation percentages among the feature
// variations during one step of a launch, and the start time of that step.
type ScheduledSplitConfig struct {
	_ struct{} `type:"structure"`

	// The traffic allocation percentages among the feature variations during one
	// step of a launch. This is a set of key-value pairs. The keys are variation
	// names. The values represent the percentage of traffic to allocate to that
	// variation during this step.
	//
	//    <p>The values is expressed in thousandths of a percent, so assigning a
	//    weight of 50000 assigns 50% of traffic to that variation.</p> <p>If the
	//    sum of the weights for all the variations in a segment override does not
	//    add up to 100,000, then the remaining traffic that matches this segment
	//    is not assigned by this segment override, and instead moves on to the
	//    next segment override or the default traffic split.</p>
	//
	// GroupWeights is a required field
	GroupWeights map[string]*int64 `locationName:"groupWeights" type:"map" required:"true"`

	// Use this parameter to specify different traffic splits for one or more audience
	// segments. A segment is a portion of your audience that share one or more
	// characteristics. Examples could be Chrome browser users, users in Europe,
	// or Firefox browser users in Europe who also fit other criteria that your
	// application collects, such as age.
	//
	// This parameter is an array of up to six segment override objects. Each of
	// these objects specifies a segment that you have already created, and defines
	// the traffic split for that segment.
	SegmentOverrides []*SegmentOverride `locationName:"segmentOverrides" type:"list"`

	// The date and time that this step of the launch starts.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledSplitConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledSplitConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledSplitConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduledSplitConfig"}
	if s.GroupWeights == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupWeights"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.SegmentOverrides != nil {
		for i, v := range s.SegmentOverrides {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SegmentOverrides", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupWeights sets the GroupWeights field's value.
func (s *ScheduledSplitConfig) SetGroupWeights(v map[string]*int64) *ScheduledSplitConfig {
	s.GroupWeights = v
	return s
}

// SetSegmentOverrides sets the SegmentOverrides field's value.
func (s *ScheduledSplitConfig) SetSegmentOverrides(v []*SegmentOverride) *ScheduledSplitConfig {
	s.SegmentOverrides = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScheduledSplitConfig) SetStartTime(v time.Time) *ScheduledSplitConfig {
	s.StartTime = &v
	return s
}

// An array of structures that define the traffic allocation percentages among
// the feature variations during each step of a launch. This also defines the
// start time of each step.
type ScheduledSplitsLaunchConfig struct {
	_ struct{} `type:"structure"`

	// An array of structures that define the traffic allocation percentages among
	// the feature variations during each step of the launch. This also defines
	// the start time of each step.
	//
	// Steps is a required field
	Steps []*ScheduledSplitConfig `locationName:"steps" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledSplitsLaunchConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledSplitsLaunchConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledSplitsLaunchConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduledSplitsLaunchConfig"}
	if s.Steps == nil {
		invalidParams.Add(request.NewErrParamRequired("Steps"))
	}
	if s.Steps != nil && len(s.Steps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Steps", 1))
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSteps sets the Steps field's value.
func (s *ScheduledSplitsLaunchConfig) SetSteps(v []*ScheduledSplitConfig) *ScheduledSplitsLaunchConfig {
	s.Steps = v
	return s
}

// An array of structures that define the traffic allocation percentages among
// the feature variations during each step of a launch. This also defines the
// start time of each step.
type ScheduledSplitsLaunchDefinition struct {
	_ struct{} `type:"structure"`

	// An array of structures that define the traffic allocation percentages among
	// the feature variations during each step of the launch. This also defines
	// the start time of each step.
	Steps []*ScheduledSplit `locationName:"steps" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledSplitsLaunchDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledSplitsLaunchDefinition) GoString() string {
	return s.String()
}

// SetSteps sets the Steps field's value.
func (s *ScheduledSplitsLaunchDefinition) SetSteps(v []*ScheduledSplit) *ScheduledSplitsLaunchDefinition {
	s.Steps = v
	return s
}

// This structure contains information about one audience segment. You can use
// segments in your experiments and launches to narrow the user sessions used
// for experiment or launch to only the user sessions that match one or more
// criteria.
type Segment struct {
	_ struct{} `type:"structure"`

	// The ARN of the segment.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time that this segment was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `locationName:"createdTime" type:"timestamp" required:"true"`

	// The customer-created description for this segment.
	Description *string `locationName:"description" type:"string"`

	// The number of experiments that this segment is used in. This count includes
	// all current experiments, not just those that are currently running.
	ExperimentCount *int64 `locationName:"experimentCount" type:"long"`

	// The date and time that this segment was most recently updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp" required:"true"`

	// The number of launches that this segment is used in. This count includes
	// all current launches, not just those that are currently running.
	LaunchCount *int64 `locationName:"launchCount" type:"long"`

	// The name of the segment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Pattern is a required field
	Pattern *string `locationName:"pattern" min:"1" type:"string" required:"true"`

	// The list of tag keys and values associated with this launch.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Segment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Segment) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Segment) SetArn(v string) *Segment {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Segment) SetCreatedTime(v time.Time) *Segment {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Segment) SetDescription(v string) *Segment {
	s.Description = &v
	return s
}

// SetExperimentCount sets the ExperimentCount field's value.
func (s *Segment) SetExperimentCount(v int64) *Segment {
	s.ExperimentCount = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Segment) SetLastUpdatedTime(v time.Time) *Segment {
	s.LastUpdatedTime = &v
	return s
}

// SetLaunchCount sets the LaunchCount field's value.
func (s *Segment) SetLaunchCount(v int64) *Segment {
	s.LaunchCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *Segment) SetName(v string) *Segment {
	s.Name = &v
	return s
}

// SetPattern sets the Pattern field's value.
func (s *Segment) SetPattern(v string) *Segment {
	s.Pattern = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Segment) SetTags(v map[string]*string) *Segment {
	s.Tags = v
	return s
}

// This structure specifies a segment that you have already created, and defines
// the traffic split for that segment to be used in a launch.
type SegmentOverride struct {
	_ struct{} `type:"structure"`

	// A number indicating the order to use to evaluate segment overrides, if there
	// are more than one. Segment overrides with lower numbers are evaluated first.
	//
	// EvaluationOrder is a required field
	EvaluationOrder *int64 `locationName:"evaluationOrder" type:"long" required:"true"`

	// The ARN of the segment to use.
	//
	// Segment is a required field
	Segment *string `locationName:"segment" type:"string" required:"true"`

	// The traffic allocation percentages among the feature variations to assign
	// to this segment. This is a set of key-value pairs. The keys are variation
	// names. The values represent the amount of traffic to allocate to that variation
	// for this segment. This is expressed in thousandths of a percent, so a weight
	// of 50000 represents 50% of traffic.
	//
	// Weights is a required field
	Weights map[string]*int64 `locationName:"weights" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SegmentOverride"}
	if s.EvaluationOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationOrder"))
	}
	if s.Segment == nil {
		invalidParams.Add(request.NewErrParamRequired("Segment"))
	}
	if s.Weights == nil {
		invalidParams.Add(request.NewErrParamRequired("Weights"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluationOrder sets the EvaluationOrder field's value.
func (s *SegmentOverride) SetEvaluationOrder(v int64) *SegmentOverride {
	s.EvaluationOrder = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *SegmentOverride) SetSegment(v string) *SegmentOverride {
	s.Segment = &v
	return s
}

// SetWeights sets the Weights field's value.
func (s *SegmentOverride) SetWeights(v map[string]*int64) *SegmentOverride {
	s.Weights = v
	return s
}

// The request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the service quota that was exceeded.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The ID of the resource that caused the exception.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the resource that is associated with the error.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The ID of the service that is associated with the error.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service was unavailable. Retry the request.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartExperimentInput struct {
	_ struct{} `type:"structure"`

	// The date and time to end the experiment. This must be no more than 30 days
	// after the experiment starts.
	//
	// AnalysisCompleteTime is a required field
	AnalysisCompleteTime *time.Time `locationName:"analysisCompleteTime" type:"timestamp" required:"true"`

	// The name of the experiment to start.
	//
	// Experiment is a required field
	Experiment *string `location:"uri" locationName:"experiment" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the experiment to start.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartExperimentInput"}
	if s.AnalysisCompleteTime == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisCompleteTime"))
	}
	if s.Experiment == nil {
		invalidParams.Add(request.NewErrParamRequired("Experiment"))
	}
	if s.Experiment != nil && len(*s.Experiment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Experiment", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisCompleteTime sets the AnalysisCompleteTime field's value.
func (s *StartExperimentInput) SetAnalysisCompleteTime(v time.Time) *StartExperimentInput {
	s.AnalysisCompleteTime = &v
	return s
}

// SetExperiment sets the Experiment field's value.
func (s *StartExperimentInput) SetExperiment(v string) *StartExperimentInput {
	s.Experiment = &v
	return s
}

// SetProject sets the Project field's value.
func (s *StartExperimentInput) SetProject(v string) *StartExperimentInput {
	s.Project = &v
	return s
}

type StartExperimentOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp that indicates when the experiment started.
	StartedTime *time.Time `locationName:"startedTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExperimentOutput) GoString() string {
	return s.String()
}

// SetStartedTime sets the StartedTime field's value.
func (s *StartExperimentOutput) SetStartedTime(v time.Time) *StartExperimentOutput {
	s.StartedTime = &v
	return s
}

type StartLaunchInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the launch to start.
	//
	// Launch is a required field
	Launch *string `location:"uri" locationName:"launch" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the launch to start.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLaunchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLaunchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartLaunchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartLaunchInput"}
	if s.Launch == nil {
		invalidParams.Add(request.NewErrParamRequired("Launch"))
	}
	if s.Launch != nil && len(*s.Launch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Launch", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunch sets the Launch field's value.
func (s *StartLaunchInput) SetLaunch(v string) *StartLaunchInput {
	s.Launch = &v
	return s
}

// SetProject sets the Project field's value.
func (s *StartLaunchInput) SetProject(v string) *StartLaunchInput {
	s.Project = &v
	return s
}

type StartLaunchOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the launch that was started.
	//
	// Launch is a required field
	Launch *Launch `locationName:"launch" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLaunchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLaunchOutput) GoString() string {
	return s.String()
}

// SetLaunch sets the Launch field's value.
func (s *StartLaunchOutput) SetLaunch(v *Launch) *StartLaunchOutput {
	s.Launch = v
	return s
}

type StopExperimentInput struct {
	_ struct{} `type:"structure"`

	// Specify whether the experiment is to be considered COMPLETED or CANCELLED
	// after it stops.
	DesiredState *string `locationName:"desiredState" type:"string" enum:"ExperimentStopDesiredState"`

	// The name of the experiment to stop.
	//
	// Experiment is a required field
	Experiment *string `location:"uri" locationName:"experiment" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the experiment to stop.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// A string that describes why you are stopping the experiment.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopExperimentInput"}
	if s.Experiment == nil {
		invalidParams.Add(request.NewErrParamRequired("Experiment"))
	}
	if s.Experiment != nil && len(*s.Experiment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Experiment", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredState sets the DesiredState field's value.
func (s *StopExperimentInput) SetDesiredState(v string) *StopExperimentInput {
	s.DesiredState = &v
	return s
}

// SetExperiment sets the Experiment field's value.
func (s *StopExperimentInput) SetExperiment(v string) *StopExperimentInput {
	s.Experiment = &v
	return s
}

// SetProject sets the Project field's value.
func (s *StopExperimentInput) SetProject(v string) *StopExperimentInput {
	s.Project = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *StopExperimentInput) SetReason(v string) *StopExperimentInput {
	s.Reason = &v
	return s
}

type StopExperimentOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the experiment stopped.
	EndedTime *time.Time `locationName:"endedTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopExperimentOutput) GoString() string {
	return s.String()
}

// SetEndedTime sets the EndedTime field's value.
func (s *StopExperimentOutput) SetEndedTime(v time.Time) *StopExperimentOutput {
	s.EndedTime = &v
	return s
}

type StopLaunchInput struct {
	_ struct{} `type:"structure"`

	// Specify whether to consider the launch as COMPLETED or CANCELLED after it
	// stops.
	DesiredState *string `locationName:"desiredState" type:"string" enum:"LaunchStopDesiredState"`

	// The name of the launch to stop.
	//
	// Launch is a required field
	Launch *string `location:"uri" locationName:"launch" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the launch that you want to
	// stop.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// A string that describes why you are stopping the launch.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopLaunchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopLaunchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopLaunchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopLaunchInput"}
	if s.Launch == nil {
		invalidParams.Add(request.NewErrParamRequired("Launch"))
	}
	if s.Launch != nil && len(*s.Launch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Launch", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredState sets the DesiredState field's value.
func (s *StopLaunchInput) SetDesiredState(v string) *StopLaunchInput {
	s.DesiredState = &v
	return s
}

// SetLaunch sets the Launch field's value.
func (s *StopLaunchInput) SetLaunch(v string) *StopLaunchInput {
	s.Launch = &v
	return s
}

// SetProject sets the Project field's value.
func (s *StopLaunchInput) SetProject(v string) *StopLaunchInput {
	s.Project = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *StopLaunchInput) SetReason(v string) *StopLaunchInput {
	s.Reason = &v
	return s
}

type StopLaunchOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the launch stopped.
	EndedTime *time.Time `locationName:"endedTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopLaunchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopLaunchOutput) GoString() string {
	return s.String()
}

// SetEndedTime sets the EndedTime field's value.
func (s *StopLaunchOutput) SetEndedTime(v time.Time) *StopLaunchOutput {
	s.EndedTime = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Evidently resource that you're adding tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of key-value pairs to associate with the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TestSegmentPatternInput struct {
	_ struct{} `type:"structure"`

	// The pattern to test.
	//
	// Pattern is a required field
	Pattern *string `locationName:"pattern" min:"1" type:"string" required:"true"`

	// A sample evaluationContext JSON block to test against the specified pattern.
	//
	// Payload is a required field
	Payload *string `locationName:"payload" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestSegmentPatternInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestSegmentPatternInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestSegmentPatternInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestSegmentPatternInput"}
	if s.Pattern == nil {
		invalidParams.Add(request.NewErrParamRequired("Pattern"))
	}
	if s.Pattern != nil && len(*s.Pattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Pattern", 1))
	}
	if s.Payload == nil {
		invalidParams.Add(request.NewErrParamRequired("Payload"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPattern sets the Pattern field's value.
func (s *TestSegmentPatternInput) SetPattern(v string) *TestSegmentPatternInput {
	s.Pattern = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *TestSegmentPatternInput) SetPayload(v string) *TestSegmentPatternInput {
	s.Payload = &v
	return s
}

type TestSegmentPatternOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the pattern matches the payload.
	//
	// Match is a required field
	Match *bool `locationName:"match" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestSegmentPatternOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestSegmentPatternOutput) GoString() string {
	return s.String()
}

// SetMatch sets the Match field's value.
func (s *TestSegmentPatternOutput) SetMatch(v bool) *TestSegmentPatternOutput {
	s.Match = &v
	return s
}

// The request was denied because of request throttling. Retry the request.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the service quota that was exceeded.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The ID of the service that is associated with the error.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that defines one treatment in an experiment. A treatment is a
// variation of the feature that you are including in the experiment.
type Treatment struct {
	_ struct{} `type:"structure"`

	// The description of the treatment.
	Description *string `locationName:"description" type:"string"`

	// The feature variation used for this treatment. This is a key-value pair.
	// The key is the feature name, and the value is the variation name.
	FeatureVariations map[string]*string `locationName:"featureVariations" type:"map"`

	// The name of this treatment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Treatment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Treatment) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Treatment) SetDescription(v string) *Treatment {
	s.Description = &v
	return s
}

// SetFeatureVariations sets the FeatureVariations field's value.
func (s *Treatment) SetFeatureVariations(v map[string]*string) *Treatment {
	s.FeatureVariations = v
	return s
}

// SetName sets the Name field's value.
func (s *Treatment) SetName(v string) *Treatment {
	s.Name = &v
	return s
}

// A structure that defines one treatment in an experiment. A treatment is a
// variation of the feature that you are including in the experiment.
type TreatmentConfig struct {
	_ struct{} `type:"structure"`

	// A description for this treatment.
	Description *string `locationName:"description" type:"string"`

	// The feature that this experiment is testing.
	//
	// Feature is a required field
	Feature *string `locationName:"feature" min:"1" type:"string" required:"true"`

	// A name for this treatment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the variation to use as this treatment in the experiment.
	//
	// Variation is a required field
	Variation *string `locationName:"variation" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TreatmentConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TreatmentConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TreatmentConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TreatmentConfig"}
	if s.Feature == nil {
		invalidParams.Add(request.NewErrParamRequired("Feature"))
	}
	if s.Feature != nil && len(*s.Feature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Feature", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Variation == nil {
		invalidParams.Add(request.NewErrParamRequired("Variation"))
	}
	if s.Variation != nil && len(*s.Variation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Variation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *TreatmentConfig) SetDescription(v string) *TreatmentConfig {
	s.Description = &v
	return s
}

// SetFeature sets the Feature field's value.
func (s *TreatmentConfig) SetFeature(v string) *TreatmentConfig {
	s.Feature = &v
	return s
}

// SetName sets the Name field's value.
func (s *TreatmentConfig) SetName(v string) *TreatmentConfig {
	s.Name = &v
	return s
}

// SetVariation sets the Variation field's value.
func (s *TreatmentConfig) SetVariation(v string) *TreatmentConfig {
	s.Variation = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the CloudWatch Evidently resource that you're removing tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateExperimentInput struct {
	_ struct{} `type:"structure"`

	// An optional description of the experiment.
	Description *string `locationName:"description" type:"string"`

	// The name of the experiment to update.
	//
	// Experiment is a required field
	Experiment *string `location:"uri" locationName:"experiment" min:"1" type:"string" required:"true"`

	// An array of structures that defines the metrics used for the experiment,
	// and whether a higher or lower value for each metric is the goal.
	MetricGoals []*MetricGoalConfig `locationName:"metricGoals" min:"1" type:"list"`

	// A structure that contains the configuration of which variation o use as the
	// "control" version. The "control" version is used for comparison with other
	// variations. This structure also specifies how much experiment traffic is
	// allocated to each variation.
	OnlineAbConfig *OnlineAbConfig `locationName:"onlineAbConfig" type:"structure"`

	// The name or ARN of the project that contains the experiment that you want
	// to update.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// When Evidently assigns a particular user session to an experiment, it must
	// use a randomization ID to determine which variation the user session is served.
	// This randomization ID is a combination of the entity ID and randomizationSalt.
	// If you omit randomizationSalt, Evidently uses the experiment name as the
	// randomizationSalt.
	RandomizationSalt *string `locationName:"randomizationSalt" type:"string"`

	// Removes a segment from being used in an experiment. You can't use this parameter
	// if the experiment is currently running.
	RemoveSegment *bool `locationName:"removeSegment" type:"boolean"`

	// The portion of the available audience that you want to allocate to this experiment,
	// in thousandths of a percent. The available audience is the total audience
	// minus the audience that you have allocated to overrides or current launches
	// of this feature.
	//
	// This is represented in thousandths of a percent. For example, specify 20,000
	// to allocate 20% of the available audience.
	SamplingRate *int64 `locationName:"samplingRate" type:"long"`

	// Adds an audience segment to an experiment. When a segment is used in an experiment,
	// only user sessions that match the segment pattern are used in the experiment.
	// You can't use this parameter if the experiment is currently running.
	Segment *string `locationName:"segment" type:"string"`

	// An array of structures that define the variations being tested in the experiment.
	Treatments []*TreatmentConfig `locationName:"treatments" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExperimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExperimentInput"}
	if s.Experiment == nil {
		invalidParams.Add(request.NewErrParamRequired("Experiment"))
	}
	if s.Experiment != nil && len(*s.Experiment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Experiment", 1))
	}
	if s.MetricGoals != nil && len(s.MetricGoals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricGoals", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.MetricGoals != nil {
		for i, v := range s.MetricGoals {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricGoals", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OnlineAbConfig != nil {
		if err := s.OnlineAbConfig.Validate(); err != nil {
			invalidParams.AddNested("OnlineAbConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Treatments != nil {
		for i, v := range s.Treatments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Treatments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateExperimentInput) SetDescription(v string) *UpdateExperimentInput {
	s.Description = &v
	return s
}

// SetExperiment sets the Experiment field's value.
func (s *UpdateExperimentInput) SetExperiment(v string) *UpdateExperimentInput {
	s.Experiment = &v
	return s
}

// SetMetricGoals sets the MetricGoals field's value.
func (s *UpdateExperimentInput) SetMetricGoals(v []*MetricGoalConfig) *UpdateExperimentInput {
	s.MetricGoals = v
	return s
}

// SetOnlineAbConfig sets the OnlineAbConfig field's value.
func (s *UpdateExperimentInput) SetOnlineAbConfig(v *OnlineAbConfig) *UpdateExperimentInput {
	s.OnlineAbConfig = v
	return s
}

// SetProject sets the Project field's value.
func (s *UpdateExperimentInput) SetProject(v string) *UpdateExperimentInput {
	s.Project = &v
	return s
}

// SetRandomizationSalt sets the RandomizationSalt field's value.
func (s *UpdateExperimentInput) SetRandomizationSalt(v string) *UpdateExperimentInput {
	s.RandomizationSalt = &v
	return s
}

// SetRemoveSegment sets the RemoveSegment field's value.
func (s *UpdateExperimentInput) SetRemoveSegment(v bool) *UpdateExperimentInput {
	s.RemoveSegment = &v
	return s
}

// SetSamplingRate sets the SamplingRate field's value.
func (s *UpdateExperimentInput) SetSamplingRate(v int64) *UpdateExperimentInput {
	s.SamplingRate = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *UpdateExperimentInput) SetSegment(v string) *UpdateExperimentInput {
	s.Segment = &v
	return s
}

// SetTreatments sets the Treatments field's value.
func (s *UpdateExperimentInput) SetTreatments(v []*TreatmentConfig) *UpdateExperimentInput {
	s.Treatments = v
	return s
}

type UpdateExperimentOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the configuration details of the experiment that was
	// updated.
	//
	// Experiment is a required field
	Experiment *Experiment `locationName:"experiment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateExperimentOutput) GoString() string {
	return s.String()
}

// SetExperiment sets the Experiment field's value.
func (s *UpdateExperimentOutput) SetExperiment(v *Experiment) *UpdateExperimentOutput {
	s.Experiment = v
	return s
}

type UpdateFeatureInput struct {
	_ struct{} `type:"structure"`

	// To update variation configurations for this feature, or add new ones, specify
	// this structure. In this array, include any variations that you want to add
	// or update. If the array includes a variation name that already exists for
	// this feature, it is updated. If it includes a new variation name, it is added
	// as a new variation.
	AddOrUpdateVariations []*VariationConfig `locationName:"addOrUpdateVariations" min:"1" type:"list"`

	// The name of the variation to use as the default variation. The default variation
	// is served to users who are not allocated to any ongoing launches or experiments
	// of this feature.
	DefaultVariation *string `locationName:"defaultVariation" min:"1" type:"string"`

	// An optional description of the feature.
	Description *string `locationName:"description" type:"string"`

	// Specified users that should always be served a specific variation of a feature.
	// Each user is specified by a key-value pair . For each key, specify a user
	// by entering their user ID, account ID, or some other identifier. For the
	// value, specify the name of the variation that they are to be served.
	EntityOverrides map[string]*string `locationName:"entityOverrides" type:"map"`

	// Specify ALL_RULES to activate the traffic allocation specified by any ongoing
	// launches or experiments. Specify DEFAULT_VARIATION to serve the default variation
	// to all users instead.
	EvaluationStrategy *string `locationName:"evaluationStrategy" type:"string" enum:"FeatureEvaluationStrategy"`

	// The name of the feature to be updated.
	//
	// Feature is a required field
	Feature *string `location:"uri" locationName:"feature" min:"1" type:"string" required:"true"`

	// The name or ARN of the project that contains the feature to be updated.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// Removes a variation from the feature. If the variation you specify doesn't
	// exist, then this makes no change and does not report an error.
	//
	// This operation fails if you try to remove a variation that is part of an
	// ongoing launch or experiment.
	RemoveVariations []*string `locationName:"removeVariations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFeatureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFeatureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFeatureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFeatureInput"}
	if s.AddOrUpdateVariations != nil && len(s.AddOrUpdateVariations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddOrUpdateVariations", 1))
	}
	if s.DefaultVariation != nil && len(*s.DefaultVariation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultVariation", 1))
	}
	if s.Feature == nil {
		invalidParams.Add(request.NewErrParamRequired("Feature"))
	}
	if s.Feature != nil && len(*s.Feature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Feature", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.AddOrUpdateVariations != nil {
		for i, v := range s.AddOrUpdateVariations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddOrUpdateVariations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOrUpdateVariations sets the AddOrUpdateVariations field's value.
func (s *UpdateFeatureInput) SetAddOrUpdateVariations(v []*VariationConfig) *UpdateFeatureInput {
	s.AddOrUpdateVariations = v
	return s
}

// SetDefaultVariation sets the DefaultVariation field's value.
func (s *UpdateFeatureInput) SetDefaultVariation(v string) *UpdateFeatureInput {
	s.DefaultVariation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFeatureInput) SetDescription(v string) *UpdateFeatureInput {
	s.Description = &v
	return s
}

// SetEntityOverrides sets the EntityOverrides field's value.
func (s *UpdateFeatureInput) SetEntityOverrides(v map[string]*string) *UpdateFeatureInput {
	s.EntityOverrides = v
	return s
}

// SetEvaluationStrategy sets the EvaluationStrategy field's value.
func (s *UpdateFeatureInput) SetEvaluationStrategy(v string) *UpdateFeatureInput {
	s.EvaluationStrategy = &v
	return s
}

// SetFeature sets the Feature field's value.
func (s *UpdateFeatureInput) SetFeature(v string) *UpdateFeatureInput {
	s.Feature = &v
	return s
}

// SetProject sets the Project field's value.
func (s *UpdateFeatureInput) SetProject(v string) *UpdateFeatureInput {
	s.Project = &v
	return s
}

// SetRemoveVariations sets the RemoveVariations field's value.
func (s *UpdateFeatureInput) SetRemoveVariations(v []*string) *UpdateFeatureInput {
	s.RemoveVariations = v
	return s
}

type UpdateFeatureOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the updated feature.
	//
	// Feature is a required field
	Feature *Feature `locationName:"feature" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFeatureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFeatureOutput) GoString() string {
	return s.String()
}

// SetFeature sets the Feature field's value.
func (s *UpdateFeatureOutput) SetFeature(v *Feature) *UpdateFeatureOutput {
	s.Feature = v
	return s
}

type UpdateLaunchInput struct {
	_ struct{} `type:"structure"`

	// An optional description for the launch.
	Description *string `locationName:"description" type:"string"`

	// An array of structures that contains the feature and variations that are
	// to be used for the launch.
	Groups []*LaunchGroupConfig `locationName:"groups" min:"1" type:"list"`

	// The name of the launch that is to be updated.
	//
	// Launch is a required field
	Launch *string `location:"uri" locationName:"launch" min:"1" type:"string" required:"true"`

	// An array of structures that define the metrics that will be used to monitor
	// the launch performance.
	MetricMonitors []*MetricMonitorConfig `locationName:"metricMonitors" type:"list"`

	// The name or ARN of the project that contains the launch that you want to
	// update.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// When Evidently assigns a particular user session to a launch, it must use
	// a randomization ID to determine which variation the user session is served.
	// This randomization ID is a combination of the entity ID and randomizationSalt.
	// If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
	RandomizationSalt *string `locationName:"randomizationSalt" type:"string"`

	// An array of structures that define the traffic allocation percentages among
	// the feature variations during each step of the launch.
	ScheduledSplitsConfig *ScheduledSplitsLaunchConfig `locationName:"scheduledSplitsConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLaunchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLaunchInput"}
	if s.Groups != nil && len(s.Groups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Groups", 1))
	}
	if s.Launch == nil {
		invalidParams.Add(request.NewErrParamRequired("Launch"))
	}
	if s.Launch != nil && len(*s.Launch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Launch", 1))
	}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.Groups != nil {
		for i, v := range s.Groups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Groups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MetricMonitors != nil {
		for i, v := range s.MetricMonitors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricMonitors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScheduledSplitsConfig != nil {
		if err := s.ScheduledSplitsConfig.Validate(); err != nil {
			invalidParams.AddNested("ScheduledSplitsConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateLaunchInput) SetDescription(v string) *UpdateLaunchInput {
	s.Description = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *UpdateLaunchInput) SetGroups(v []*LaunchGroupConfig) *UpdateLaunchInput {
	s.Groups = v
	return s
}

// SetLaunch sets the Launch field's value.
func (s *UpdateLaunchInput) SetLaunch(v string) *UpdateLaunchInput {
	s.Launch = &v
	return s
}

// SetMetricMonitors sets the MetricMonitors field's value.
func (s *UpdateLaunchInput) SetMetricMonitors(v []*MetricMonitorConfig) *UpdateLaunchInput {
	s.MetricMonitors = v
	return s
}

// SetProject sets the Project field's value.
func (s *UpdateLaunchInput) SetProject(v string) *UpdateLaunchInput {
	s.Project = &v
	return s
}

// SetRandomizationSalt sets the RandomizationSalt field's value.
func (s *UpdateLaunchInput) SetRandomizationSalt(v string) *UpdateLaunchInput {
	s.RandomizationSalt = &v
	return s
}

// SetScheduledSplitsConfig sets the ScheduledSplitsConfig field's value.
func (s *UpdateLaunchInput) SetScheduledSplitsConfig(v *ScheduledSplitsLaunchConfig) *UpdateLaunchInput {
	s.ScheduledSplitsConfig = v
	return s
}

type UpdateLaunchOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the new configuration of the launch that was updated.
	//
	// Launch is a required field
	Launch *Launch `locationName:"launch" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchOutput) GoString() string {
	return s.String()
}

// SetLaunch sets the Launch field's value.
func (s *UpdateLaunchOutput) SetLaunch(v *Launch) *UpdateLaunchOutput {
	s.Launch = v
	return s
}

type UpdateProjectDataDeliveryInput struct {
	_ struct{} `type:"structure"`

	// A structure containing the CloudWatch Logs log group where you want to store
	// evaluation events.
	CloudWatchLogs *CloudWatchLogsDestinationConfig `locationName:"cloudWatchLogs" type:"structure"`

	// The name or ARN of the project that you want to modify the data storage options
	// for.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`

	// A structure containing the S3 bucket name and bucket prefix where you want
	// to store evaluation events.
	S3Destination *S3DestinationConfig `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectDataDeliveryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectDataDeliveryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectDataDeliveryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectDataDeliveryInput"}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}
	if s.CloudWatchLogs != nil {
		if err := s.CloudWatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *UpdateProjectDataDeliveryInput) SetCloudWatchLogs(v *CloudWatchLogsDestinationConfig) *UpdateProjectDataDeliveryInput {
	s.CloudWatchLogs = v
	return s
}

// SetProject sets the Project field's value.
func (s *UpdateProjectDataDeliveryInput) SetProject(v string) *UpdateProjectDataDeliveryInput {
	s.Project = &v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *UpdateProjectDataDeliveryInput) SetS3Destination(v *S3DestinationConfig) *UpdateProjectDataDeliveryInput {
	s.S3Destination = v
	return s
}

type UpdateProjectDataDeliveryOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the project that you updated.
	//
	// Project is a required field
	Project *Project `locationName:"project" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectDataDeliveryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectDataDeliveryOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *UpdateProjectDataDeliveryOutput) SetProject(v *Project) *UpdateProjectDataDeliveryOutput {
	s.Project = v
	return s
}

type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// An optional description of the project.
	Description *string `locationName:"description" type:"string"`

	// The name or ARN of the project to update.
	//
	// Project is a required field
	Project *string `location:"uri" locationName:"project" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.Project == nil {
		invalidParams.Add(request.NewErrParamRequired("Project"))
	}
	if s.Project != nil && len(*s.Project) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Project", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateProjectInput) SetDescription(v string) *UpdateProjectInput {
	s.Description = &v
	return s
}

// SetProject sets the Project field's value.
func (s *UpdateProjectInput) SetProject(v string) *UpdateProjectInput {
	s.Project = &v
	return s
}

type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing information about the updated project.
	//
	// Project is a required field
	Project *Project `locationName:"project" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *UpdateProjectOutput) SetProject(v *Project) *UpdateProjectOutput {
	s.Project = v
	return s
}

// The value of a parameter in the request caused an error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The parameter that caused the exception.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// A reason for the error.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure containing an error name and message.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The error name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// The value assigned to a feature variation. This structure must contain exactly
// one field. It can be boolValue, doubleValue, longValue, or stringValue.
type VariableValue struct {
	_ struct{} `type:"structure"`

	// If this feature uses the Boolean variation type, this field contains the
	// Boolean value of this variation.
	BoolValue *bool `locationName:"boolValue" type:"boolean"`

	// If this feature uses the double integer variation type, this field contains
	// the double integer value of this variation.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// If this feature uses the long variation type, this field contains the long
	// value of this variation.
	LongValue *int64 `locationName:"longValue" type:"long"`

	// If this feature uses the string variation type, this field contains the string
	// value of this variation.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariableValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariableValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VariableValue"}
	if s.LongValue != nil && *s.LongValue < -9.007199254740991e+15 {
		invalidParams.Add(request.NewErrParamMinValue("LongValue", -9.007199254740991e+15))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBoolValue sets the BoolValue field's value.
func (s *VariableValue) SetBoolValue(v bool) *VariableValue {
	s.BoolValue = &v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *VariableValue) SetDoubleValue(v float64) *VariableValue {
	s.DoubleValue = &v
	return s
}

// SetLongValue sets the LongValue field's value.
func (s *VariableValue) SetLongValue(v int64) *VariableValue {
	s.LongValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *VariableValue) SetStringValue(v string) *VariableValue {
	s.StringValue = &v
	return s
}

// This structure contains the name and variation value of one variation of
// a feature.
type Variation struct {
	_ struct{} `type:"structure"`

	// The name of the variation.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The value assigned to this variation.
	Value *VariableValue `locationName:"value" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Variation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Variation) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Variation) SetName(v string) *Variation {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Variation) SetValue(v *VariableValue) *Variation {
	s.Value = v
	return s
}

// This structure contains the name and variation value of one variation of
// a feature.
type VariationConfig struct {
	_ struct{} `type:"structure"`

	// The name of the variation.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The value assigned to this variation.
	//
	// Value is a required field
	Value *VariableValue `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VariationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VariationConfig"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *VariationConfig) SetName(v string) *VariationConfig {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *VariationConfig) SetValue(v *VariableValue) *VariationConfig {
	s.Value = v
	return s
}

const (
	// ChangeDirectionEnumIncrease is a ChangeDirectionEnum enum value
	ChangeDirectionEnumIncrease = "INCREASE"

	// ChangeDirectionEnumDecrease is a ChangeDirectionEnum enum value
	ChangeDirectionEnumDecrease = "DECREASE"
)

// ChangeDirectionEnum_Values returns all elements of the ChangeDirectionEnum enum
func ChangeDirectionEnum_Values() []string {
	return []string{
		ChangeDirectionEnumIncrease,
		ChangeDirectionEnumDecrease,
	}
}

const (
	// EventTypeAwsEvidentlyEvaluation is a EventType enum value
	EventTypeAwsEvidentlyEvaluation = "aws.evidently.evaluation"

	// EventTypeAwsEvidentlyCustom is a EventType enum value
	EventTypeAwsEvidentlyCustom = "aws.evidently.custom"
)

// EventType_Values returns all elements of the EventType enum
func EventType_Values() []string {
	return []string{
		EventTypeAwsEvidentlyEvaluation,
		EventTypeAwsEvidentlyCustom,
	}
}

const (
	// ExperimentBaseStatMean is a ExperimentBaseStat enum value
	ExperimentBaseStatMean = "Mean"
)

// ExperimentBaseStat_Values returns all elements of the ExperimentBaseStat enum
func ExperimentBaseStat_Values() []string {
	return []string{
		ExperimentBaseStatMean,
	}
}

const (
	// ExperimentReportNameBayesianInference is a ExperimentReportName enum value
	ExperimentReportNameBayesianInference = "BayesianInference"
)

// ExperimentReportName_Values returns all elements of the ExperimentReportName enum
func ExperimentReportName_Values() []string {
	return []string{
		ExperimentReportNameBayesianInference,
	}
}

const (
	// ExperimentResultRequestTypeBaseStat is a ExperimentResultRequestType enum value
	ExperimentResultRequestTypeBaseStat = "BaseStat"

	// ExperimentResultRequestTypeTreatmentEffect is a ExperimentResultRequestType enum value
	ExperimentResultRequestTypeTreatmentEffect = "TreatmentEffect"

	// ExperimentResultRequestTypeConfidenceInterval is a ExperimentResultRequestType enum value
	ExperimentResultRequestTypeConfidenceInterval = "ConfidenceInterval"

	// ExperimentResultRequestTypePvalue is a ExperimentResultRequestType enum value
	ExperimentResultRequestTypePvalue = "PValue"
)

// ExperimentResultRequestType_Values returns all elements of the ExperimentResultRequestType enum
func ExperimentResultRequestType_Values() []string {
	return []string{
		ExperimentResultRequestTypeBaseStat,
		ExperimentResultRequestTypeTreatmentEffect,
		ExperimentResultRequestTypeConfidenceInterval,
		ExperimentResultRequestTypePvalue,
	}
}

const (
	// ExperimentResultResponseTypeMean is a ExperimentResultResponseType enum value
	ExperimentResultResponseTypeMean = "Mean"

	// ExperimentResultResponseTypeTreatmentEffect is a ExperimentResultResponseType enum value
	ExperimentResultResponseTypeTreatmentEffect = "TreatmentEffect"

	// ExperimentResultResponseTypeConfidenceIntervalUpperBound is a ExperimentResultResponseType enum value
	ExperimentResultResponseTypeConfidenceIntervalUpperBound = "ConfidenceIntervalUpperBound"

	// ExperimentResultResponseTypeConfidenceIntervalLowerBound is a ExperimentResultResponseType enum value
	ExperimentResultResponseTypeConfidenceIntervalLowerBound = "ConfidenceIntervalLowerBound"

	// ExperimentResultResponseTypePvalue is a ExperimentResultResponseType enum value
	ExperimentResultResponseTypePvalue = "PValue"
)

// ExperimentResultResponseType_Values returns all elements of the ExperimentResultResponseType enum
func ExperimentResultResponseType_Values() []string {
	return []string{
		ExperimentResultResponseTypeMean,
		ExperimentResultResponseTypeTreatmentEffect,
		ExperimentResultResponseTypeConfidenceIntervalUpperBound,
		ExperimentResultResponseTypeConfidenceIntervalLowerBound,
		ExperimentResultResponseTypePvalue,
	}
}

const (
	// ExperimentStatusCreated is a ExperimentStatus enum value
	ExperimentStatusCreated = "CREATED"

	// ExperimentStatusUpdating is a ExperimentStatus enum value
	ExperimentStatusUpdating = "UPDATING"

	// ExperimentStatusRunning is a ExperimentStatus enum value
	ExperimentStatusRunning = "RUNNING"

	// ExperimentStatusCompleted is a ExperimentStatus enum value
	ExperimentStatusCompleted = "COMPLETED"

	// ExperimentStatusCancelled is a ExperimentStatus enum value
	ExperimentStatusCancelled = "CANCELLED"
)

// ExperimentStatus_Values returns all elements of the ExperimentStatus enum
func ExperimentStatus_Values() []string {
	return []string{
		ExperimentStatusCreated,
		ExperimentStatusUpdating,
		ExperimentStatusRunning,
		ExperimentStatusCompleted,
		ExperimentStatusCancelled,
	}
}

const (
	// ExperimentStopDesiredStateCompleted is a ExperimentStopDesiredState enum value
	ExperimentStopDesiredStateCompleted = "COMPLETED"

	// ExperimentStopDesiredStateCancelled is a ExperimentStopDesiredState enum value
	ExperimentStopDesiredStateCancelled = "CANCELLED"
)

// ExperimentStopDesiredState_Values returns all elements of the ExperimentStopDesiredState enum
func ExperimentStopDesiredState_Values() []string {
	return []string{
		ExperimentStopDesiredStateCompleted,
		ExperimentStopDesiredStateCancelled,
	}
}

const (
	// ExperimentTypeAwsEvidentlyOnlineab is a ExperimentType enum value
	ExperimentTypeAwsEvidentlyOnlineab = "aws.evidently.onlineab"
)

// ExperimentType_Values returns all elements of the ExperimentType enum
func ExperimentType_Values() []string {
	return []string{
		ExperimentTypeAwsEvidentlyOnlineab,
	}
}

const (
	// FeatureEvaluationStrategyAllRules is a FeatureEvaluationStrategy enum value
	FeatureEvaluationStrategyAllRules = "ALL_RULES"

	// FeatureEvaluationStrategyDefaultVariation is a FeatureEvaluationStrategy enum value
	FeatureEvaluationStrategyDefaultVariation = "DEFAULT_VARIATION"
)

// FeatureEvaluationStrategy_Values returns all elements of the FeatureEvaluationStrategy enum
func FeatureEvaluationStrategy_Values() []string {
	return []string{
		FeatureEvaluationStrategyAllRules,
		FeatureEvaluationStrategyDefaultVariation,
	}
}

const (
	// FeatureStatusAvailable is a FeatureStatus enum value
	FeatureStatusAvailable = "AVAILABLE"

	// FeatureStatusUpdating is a FeatureStatus enum value
	FeatureStatusUpdating = "UPDATING"
)

// FeatureStatus_Values returns all elements of the FeatureStatus enum
func FeatureStatus_Values() []string {
	return []string{
		FeatureStatusAvailable,
		FeatureStatusUpdating,
	}
}

const (
	// LaunchStatusCreated is a LaunchStatus enum value
	LaunchStatusCreated = "CREATED"

	// LaunchStatusUpdating is a LaunchStatus enum value
	LaunchStatusUpdating = "UPDATING"

	// LaunchStatusRunning is a LaunchStatus enum value
	LaunchStatusRunning = "RUNNING"

	// LaunchStatusCompleted is a LaunchStatus enum value
	LaunchStatusCompleted = "COMPLETED"

	// LaunchStatusCancelled is a LaunchStatus enum value
	LaunchStatusCancelled = "CANCELLED"
)

// LaunchStatus_Values returns all elements of the LaunchStatus enum
func LaunchStatus_Values() []string {
	return []string{
		LaunchStatusCreated,
		LaunchStatusUpdating,
		LaunchStatusRunning,
		LaunchStatusCompleted,
		LaunchStatusCancelled,
	}
}

const (
	// LaunchStopDesiredStateCompleted is a LaunchStopDesiredState enum value
	LaunchStopDesiredStateCompleted = "COMPLETED"

	// LaunchStopDesiredStateCancelled is a LaunchStopDesiredState enum value
	LaunchStopDesiredStateCancelled = "CANCELLED"
)

// LaunchStopDesiredState_Values returns all elements of the LaunchStopDesiredState enum
func LaunchStopDesiredState_Values() []string {
	return []string{
		LaunchStopDesiredStateCompleted,
		LaunchStopDesiredStateCancelled,
	}
}

const (
	// LaunchTypeAwsEvidentlySplits is a LaunchType enum value
	LaunchTypeAwsEvidentlySplits = "aws.evidently.splits"
)

// LaunchType_Values returns all elements of the LaunchType enum
func LaunchType_Values() []string {
	return []string{
		LaunchTypeAwsEvidentlySplits,
	}
}

const (
	// ProjectStatusAvailable is a ProjectStatus enum value
	ProjectStatusAvailable = "AVAILABLE"

	// ProjectStatusUpdating is a ProjectStatus enum value
	ProjectStatusUpdating = "UPDATING"
)

// ProjectStatus_Values returns all elements of the ProjectStatus enum
func ProjectStatus_Values() []string {
	return []string{
		ProjectStatusAvailable,
		ProjectStatusUpdating,
	}
}

const (
	// SegmentReferenceResourceTypeExperiment is a SegmentReferenceResourceType enum value
	SegmentReferenceResourceTypeExperiment = "EXPERIMENT"

	// SegmentReferenceResourceTypeLaunch is a SegmentReferenceResourceType enum value
	SegmentReferenceResourceTypeLaunch = "LAUNCH"
)

// SegmentReferenceResourceType_Values returns all elements of the SegmentReferenceResourceType enum
func SegmentReferenceResourceType_Values() []string {
	return []string{
		SegmentReferenceResourceTypeExperiment,
		SegmentReferenceResourceTypeLaunch,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

const (
	// VariationValueTypeString is a VariationValueType enum value
	VariationValueTypeString = "STRING"

	// VariationValueTypeLong is a VariationValueType enum value
	VariationValueTypeLong = "LONG"

	// VariationValueTypeDouble is a VariationValueType enum value
	VariationValueTypeDouble = "DOUBLE"

	// VariationValueTypeBoolean is a VariationValueType enum value
	VariationValueTypeBoolean = "BOOLEAN"
)

// VariationValueType_Values returns all elements of the VariationValueType enum
func VariationValueType_Values() []string {
	return []string{
		VariationValueTypeString,
		VariationValueTypeLong,
		VariationValueTypeDouble,
		VariationValueTypeBoolean,
	}
}
