/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import java.util.Collections;
import java.util.List;

public class FlattenedWrapperModule<W>
implements Module {
    private final Class<W> wrapperType;

    public FlattenedWrapperModule(Class<W> wrapperType) {
        this.wrapperType = wrapperType;
    }

    protected boolean isWrapperType(ResolvedType type) {
        return type != null && this.wrapperType.isAssignableFrom(type.getErasedType());
    }

    protected boolean hasMemberWrapperType(MemberScope<?, ?> member) {
        ResolvedType declaredType = member.getDeclaredType();
        if (member.isFakeContainerItemScope() && member.getContext().isContainerType(declaredType)) {
            declaredType = member.getContext().getContainerItemType(declaredType);
        }
        return this.isWrapperType(declaredType);
    }

    private List<ResolvedType> resolveWrapperComponentType(MemberScope<?, ?> fieldOrMethod) {
        return this.isWrapperType(fieldOrMethod.getType()) ? Collections.singletonList(fieldOrMethod.getTypeParameterFor(this.wrapperType, 0)) : null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withTargetTypeOverridesResolver(this::resolveWrapperComponentType);
        builder.forMethods().withTargetTypeOverridesResolver(this::resolveWrapperComponentType);
    }
}

