/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.CanonicalExtensionHeadersSerializer;
import com.google.cloud.storage.HttpMethod;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;

public class SignatureInfo {
    public static final char COMPONENT_SEPARATOR = '\n';
    private final HttpMethod httpVerb;
    private final String contentMd5;
    private final String contentType;
    private final long expiration;
    private final Map<String, String> canonicalizedExtensionHeaders;
    private final URI canonicalizedResource;

    private SignatureInfo(Builder builder) {
        this.httpVerb = builder.httpVerb;
        this.contentMd5 = builder.contentMd5;
        this.contentType = builder.contentType;
        this.expiration = builder.expiration;
        this.canonicalizedExtensionHeaders = builder.canonicalizedExtensionHeaders;
        this.canonicalizedResource = builder.canonicalizedResource;
    }

    public String constructUnsignedPayload() {
        StringBuilder payload = new StringBuilder();
        payload.append(this.httpVerb.name()).append('\n');
        if (this.contentMd5 != null) {
            payload.append(this.contentMd5);
        }
        payload.append('\n');
        if (this.contentType != null) {
            payload.append(this.contentType);
        }
        payload.append('\n');
        payload.append(this.expiration).append('\n');
        if (this.canonicalizedExtensionHeaders != null) {
            payload.append((CharSequence)new CanonicalExtensionHeadersSerializer().serialize(this.canonicalizedExtensionHeaders));
        }
        payload.append(this.canonicalizedResource);
        return payload.toString();
    }

    public HttpMethod getHttpVerb() {
        return this.httpVerb;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public Map<String, String> getCanonicalizedExtensionHeaders() {
        return this.canonicalizedExtensionHeaders;
    }

    public URI getCanonicalizedResource() {
        return this.canonicalizedResource;
    }

    public static final class Builder {
        private final HttpMethod httpVerb;
        private String contentMd5;
        private String contentType;
        private final long expiration;
        private Map<String, String> canonicalizedExtensionHeaders;
        private final URI canonicalizedResource;

        public Builder(HttpMethod httpVerb, long expiration, URI canonicalizedResource) {
            this.httpVerb = httpVerb;
            this.expiration = expiration;
            this.canonicalizedResource = canonicalizedResource;
        }

        public Builder(SignatureInfo signatureInfo) {
            this.httpVerb = signatureInfo.httpVerb;
            this.contentMd5 = signatureInfo.contentMd5;
            this.contentType = signatureInfo.contentType;
            this.expiration = signatureInfo.expiration;
            this.canonicalizedExtensionHeaders = signatureInfo.canonicalizedExtensionHeaders;
            this.canonicalizedResource = signatureInfo.canonicalizedResource;
        }

        public Builder setContentMd5(String contentMd5) {
            this.contentMd5 = contentMd5;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setCanonicalizedExtensionHeaders(Map<String, String> canonicalizedExtensionHeaders) {
            this.canonicalizedExtensionHeaders = canonicalizedExtensionHeaders;
            return this;
        }

        public SignatureInfo build() {
            Preconditions.checkArgument((this.httpVerb != null ? 1 : 0) != 0, (Object)"Required HTTP method");
            Preconditions.checkArgument((this.canonicalizedResource != null ? 1 : 0) != 0, (Object)"Required canonicalized resource");
            Preconditions.checkArgument((this.expiration >= 0L ? 1 : 0) != 0, (Object)"Expiration must be greater than or equal to zero");
            return new SignatureInfo(this);
        }
    }
}

