/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.ospf;

import com.ubnt.data.Site;
import com.ubnt.model.api.ospf.OspfNeighborDto;
import com.ubnt.model.api.ospf.OspfRouterDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.ospf.I;
import com.ubnt.service.ospf.OspfRouterDocument;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="OSPF Routing")
@Validated
public class OspfController {
    private final I super;

    public OspfController(I i2) {
        this.super = i2;
    }

    @GetMapping(value={"/api/site/{siteName}/ospf/router"})
    @Operation(summary="Get OSPF Routers", description="Since 8.1")
    public List<OspfRouterDto> getOspfRouters(@PathVariable(value="siteName") Site site) {
        return this.super.Object(site.getId()).stream().map(OspfRouterDto::ofDocument).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/ospf/router"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create OSPF Router", description="Since 8.1")
    public OspfRouterDto createOspfRouter(@PathVariable(value="siteName") Site site, @Valid @RequestBody OspfRouterDto ospfRouterDto) {
        OspfRouterDocument ospfRouterDocument = ospfRouterDto.toDocument(site.getId());
        return OspfRouterDto.ofDocument(this.super.\u00d500000(site.getId(), ospfRouterDocument));
    }

    @PutMapping(value={"/api/site/{siteName}/ospf/router/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update OSPF Router", description="Since 8.1")
    public OspfRouterDto updateOspfRouter(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid OspfRouterDto ospfRouterDto) {
        OspfRouterDocument ospfRouterDocument = ospfRouterDto.toDocument(string, site.getId());
        return OspfRouterDto.ofDocument(this.super.\u00d200000(site.getId(), string, ospfRouterDocument));
    }

    @DeleteMapping(value={"/api/site/{siteName}/ospf/router/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete OSPF Router")
    public void deleteOspfRouter(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        this.super.\u00d400000(site.getId(), string);
    }

    @GetMapping(value={"/api/site/{siteName}/ospf/neighbors"})
    public List<OspfNeighborDto> getOspfNeighbors(@PathVariable(value="siteName") Site site) {
        return this.super.o00000(site.getId());
    }
}

