/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import org.netbeans.api.debugger.jpda.ReturnVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;

public class ReturnVariableImpl
extends AbstractObjectVariable
implements ReturnVariable {
    private String methodName;

    public ReturnVariableImpl(JPDADebuggerImpl debugger, Value returnValue, String parentID, String methodName) {
        super(debugger, returnValue, parentID + ".return " + methodName + "=" + ReturnVariableImpl.getStringValue(returnValue));
        this.methodName = methodName;
    }

    static String getStringValue(Value v) {
        if (v == null) {
            return "null";
        }
        if (v instanceof VoidValue) {
            return "void";
        }
        if (v instanceof PrimitiveValue) {
            return v.toString();
        }
        try {
            return "#" + ObjectReferenceWrapper.uniqueID((ObjectReference)v);
        }
        catch (InternalExceptionWrapper ex) {
            return "#" + ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "#0";
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return "#0";
        }
    }

    public String methodName() {
        return this.methodName;
    }

    @Override
    public ReturnVariableImpl clone() {
        return new ReturnVariableImpl(this.getDebugger(), this.getJDIValue(), this.getID().substring(0, this.getID().length() - ".return".length()), this.methodName);
    }

    @Override
    public String toString() {
        return "ReturnVariable " + this.getValue();
    }
}

