/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.FatalError;
import com.sun.tools.classfile.Field;
import com.sun.tools.classfile.InnerClasses_attribute;
import com.sun.tools.classfile.Method;
import com.sun.tools.javap.AttributeWriter;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.DisassemblerTool;
import com.sun.tools.javap.InstructionDetailWriter;
import com.sun.tools.javap.InternalError;
import com.sun.tools.javap.JavapFileManager;
import com.sun.tools.javap.Messages;
import com.sun.tools.javap.Options;
import com.sun.tools.javap.SourceWriter;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.NoSuchFileException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JavapTask
implements DisassemblerTool.DisassemblerTask,
Messages {
    static final Option[] recognizedOptions = new Option[]{new Option(false, new String[]{"-help", "--help", "-?", "-h"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.help = true;
        }
    }, new Option(false, new String[]{"-version"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.version = true;
        }
    }, new Option(false, new String[]{"-fullversion"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.fullVersion = true;
        }
    }, new Option(false, new String[]{"-v", "-verbose", "-all"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.verbose = true;
            task.options.showDescriptors = true;
            task.options.showFlags = true;
            task.options.showAllAttrs = true;
        }
    }, new Option(false, new String[]{"-l"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.showLineAndLocalVariableTables = true;
        }
    }, new Option(false, new String[]{"-public"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.accessOptions.add(opt);
            task.options.showAccess = 1;
        }
    }, new Option(false, new String[]{"-protected"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.accessOptions.add(opt);
            task.options.showAccess = 4;
        }
    }, new Option(false, new String[]{"-package"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.accessOptions.add(opt);
            task.options.showAccess = 0;
        }
    }, new Option(false, new String[]{"-p", "-private"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            if (!task.options.accessOptions.contains("-p") && !task.options.accessOptions.contains("-private")) {
                task.options.accessOptions.add(opt);
            }
            task.options.showAccess = 2;
        }
    }, new Option(false, new String[]{"-c"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.showDisassembled = true;
        }
    }, new Option(false, new String[]{"-s"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.showDescriptors = true;
        }
    }, new Option(false, new String[]{"-sysinfo"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.sysInfo = true;
        }
    }, new Option(false, new String[]{"-XDdetails"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.details = EnumSet.allOf(InstructionDetailWriter.Kind.class);
        }
    }, new Option(false, new String[]{"-XDdetails:"}){

        @Override
        boolean matches(String opt) {
            int sep = opt.indexOf(":");
            return sep != -1 && super.matches(opt.substring(0, sep + 1));
        }

        @Override
        void process(JavapTask task, String opt, String arg) throws BadArgs {
            int sep = opt.indexOf(":");
            for (String v : opt.substring(sep + 1).split("[,: ]+")) {
                if (this.handleArg(task, v)) continue;
                JavapTask javapTask = task;
                Objects.requireNonNull(javapTask);
                throw javapTask.new BadArgs("err.invalid.arg.for.option", v);
            }
        }

        boolean handleArg(JavapTask task, String arg) {
            if (arg.length() == 0) {
                return true;
            }
            if (arg.equals("all")) {
                task.options.details = EnumSet.allOf(InstructionDetailWriter.Kind.class);
                return true;
            }
            boolean on = true;
            if (arg.startsWith("-")) {
                on = false;
                arg = arg.substring(1);
            }
            for (InstructionDetailWriter.Kind k : InstructionDetailWriter.Kind.values()) {
                if (!arg.equalsIgnoreCase(k.option)) continue;
                if (on) {
                    task.options.details.add(k);
                } else {
                    task.options.details.remove((Object)k);
                }
                return true;
            }
            return false;
        }
    }, new Option(false, new String[]{"-constants"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.showConstants = true;
        }
    }, new Option(false, new String[]{"-XDinner"}){

        @Override
        void process(JavapTask task, String opt, String arg) {
            task.options.showInnerClasses = true;
        }
    }, new Option(false, new String[]{"-XDindent:"}){

        @Override
        boolean matches(String opt) {
            int sep = opt.indexOf(":");
            return sep != -1 && super.matches(opt.substring(0, sep + 1));
        }

        @Override
        void process(JavapTask task, String opt, String arg) throws BadArgs {
            int sep = opt.indexOf(":");
            try {
                int i = Integer.valueOf(opt.substring(sep + 1));
                if (i > 0) {
                    task.options.indentWidth = i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }, new Option(false, new String[]{"-XDtab:"}){

        @Override
        boolean matches(String opt) {
            int sep = opt.indexOf(":");
            return sep != -1 && super.matches(opt.substring(0, sep + 1));
        }

        @Override
        void process(JavapTask task, String opt, String arg) throws BadArgs {
            int sep = opt.indexOf(":");
            try {
                int i = Integer.valueOf(opt.substring(sep + 1));
                if (i > 0) {
                    task.options.tabColumn = i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }, new Option(true, new String[]{"--module", "-m"}){

        @Override
        void process(JavapTask task, String opt, String arg) throws BadArgs {
            task.options.moduleName = arg;
        }
    }, new Option(false, new String[]{"-J"}){

        @Override
        boolean matches(String opt) {
            return opt.startsWith("-J");
        }

        @Override
        void process(JavapTask task, String opt, String arg) throws BadArgs {
            JavapTask javapTask = task;
            Objects.requireNonNull(javapTask);
            throw javapTask.new BadArgs("err.only.for.launcher", new Object[0]);
        }
    }};
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private static final String nl = System.getProperty("line.separator");
    private static final String versionRBName = "com.sun.tools.javap.resources.version";
    private static ResourceBundle versionRB;
    protected Context context = new Context();
    JavaFileManager fileManager;
    JavaFileManager defaultFileManager;
    PrintWriter log;
    DiagnosticListener<? super JavaFileObject> diagnosticListener;
    List<String> classes;
    JavaFileManager.Location moduleLocation;
    Options options;
    Locale task_locale;
    Map<Locale, ResourceBundle> bundles;
    protected Attribute.Factory attributeFactory;
    private static final String progname = "javap";

    public JavapTask() {
        this.context.put(Messages.class, this);
        this.options = Options.instance(this.context);
        this.attributeFactory = new Attribute.Factory();
    }

    public JavapTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener) {
        this();
        this.log = JavapTask.getPrintWriterForWriter(out);
        this.fileManager = fileManager;
        this.diagnosticListener = diagnosticListener;
    }

    public JavapTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes) {
        this(out, fileManager, diagnosticListener);
        this.classes = new ArrayList<String>();
        for (String classname : classes) {
            Objects.requireNonNull(classname);
            this.classes.add(classname);
        }
        try {
            if (options != null) {
                this.handleOptions(options, false);
            }
        }
        catch (BadArgs e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.task_locale = locale;
    }

    public void setLog(Writer log) {
        this.log = JavapTask.getPrintWriterForWriter(log);
    }

    public void setLog(OutputStream s) {
        this.setLog(JavapTask.getPrintWriterForStream(s));
    }

    private static PrintWriter getPrintWriterForStream(OutputStream s) {
        return new PrintWriter(s == null ? System.err : s, true);
    }

    private static PrintWriter getPrintWriterForWriter(Writer w) {
        if (w == null) {
            return JavapTask.getPrintWriterForStream(null);
        }
        if (w instanceof PrintWriter) {
            return (PrintWriter)w;
        }
        return new PrintWriter(w, true);
    }

    public void setDiagnosticListener(DiagnosticListener<? super JavaFileObject> dl) {
        this.diagnosticListener = dl;
    }

    public void setDiagnosticListener(OutputStream s) {
        this.setDiagnosticListener(this.getDiagnosticListenerForStream(s));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForStream(OutputStream s) {
        return this.getDiagnosticListenerForWriter(JavapTask.getPrintWriterForStream(s));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForWriter(Writer w) {
        PrintWriter pw = JavapTask.getPrintWriterForWriter(w);
        return diagnostic -> {
            switch (diagnostic.getKind()) {
                case ERROR: {
                    pw.print(this.getMessage("err.prefix", new Object[0]));
                    break;
                }
                case WARNING: {
                    pw.print(this.getMessage("warn.prefix", new Object[0]));
                    break;
                }
                case NOTE: {
                    pw.print(this.getMessage("note.prefix", new Object[0]));
                }
            }
            pw.print(" ");
            pw.println(diagnostic.getMessage(null));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(String[] args) {
        try {
            int n;
            block30: {
                block26: {
                    int n2;
                    block29: {
                        block27: {
                            int n3;
                            block28: {
                                try {
                                    this.handleOptions(args);
                                    if (this.classes != null && this.classes.size() != 0) break block26;
                                    if (!this.options.help && !this.options.version && !this.options.fullVersion) break block27;
                                    n3 = 0;
                                    if (this.defaultFileManager == null) break block28;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (this.defaultFileManager != null) {
                                            try {
                                                this.defaultFileManager.close();
                                                this.defaultFileManager = null;
                                            }
                                            catch (IOException e) {
                                                throw new InternalError(e, new Object[0]);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (BadArgs e) {
                                        this.reportError(e.key, e.args);
                                        if (e.showUsage) {
                                            this.printLines(this.getMessage("main.usage.summary", progname));
                                        }
                                        int e2 = 2;
                                        return e2;
                                    }
                                    catch (InternalError e) {
                                        Object[] e_args;
                                        if (e.getCause() == null) {
                                            e_args = e.args;
                                        } else {
                                            e_args = new Object[e.args.length + 1];
                                            e_args[0] = e.getCause();
                                            System.arraycopy(e.args, 0, e_args, 1, e.args.length);
                                        }
                                        this.reportError("err.internal.error", e_args);
                                        int n4 = 4;
                                        return n4;
                                    }
                                }
                                try {
                                    this.defaultFileManager.close();
                                    this.defaultFileManager = null;
                                }
                                catch (IOException e) {
                                    throw new InternalError(e, new Object[0]);
                                }
                            }
                            return n3;
                        }
                        n2 = 2;
                        if (this.defaultFileManager == null) break block29;
                        try {
                            this.defaultFileManager.close();
                            this.defaultFileManager = null;
                        }
                        catch (IOException e) {
                            throw new InternalError(e, new Object[0]);
                        }
                    }
                    return n2;
                }
                n = this.run();
                if (this.defaultFileManager == null) break block30;
                try {
                    this.defaultFileManager.close();
                    this.defaultFileManager = null;
                }
                catch (IOException e2) {
                    throw new InternalError(e2, new Object[0]);
                }
            }
            return n;
        }
        finally {
            this.log.flush();
        }
    }

    public void handleOptions(String[] args) throws BadArgs {
        this.handleOptions(Arrays.asList(args), true);
    }

    private void handleOptions(Iterable<String> args, boolean allowClasses) throws BadArgs {
        Iterator<String> iter;
        boolean noArgs;
        if (this.log == null) {
            this.log = JavapTask.getPrintWriterForStream(System.out);
            if (this.diagnosticListener == null) {
                this.diagnosticListener = this.getDiagnosticListenerForStream(System.err);
            }
        } else if (this.diagnosticListener == null) {
            this.diagnosticListener = this.getDiagnosticListenerForWriter(this.log);
        }
        if (this.fileManager == null) {
            this.fileManager = this.getDefaultFileManager(this.diagnosticListener, this.log);
        }
        boolean bl = noArgs = !(iter = args.iterator()).hasNext();
        while (iter.hasNext()) {
            String arg = iter.next();
            if (arg.startsWith("-")) {
                this.handleOption(arg, iter);
                continue;
            }
            if (allowClasses) {
                if (this.classes == null) {
                    this.classes = new ArrayList<String>();
                }
                this.classes.add(arg);
                while (iter.hasNext()) {
                    this.classes.add(iter.next());
                }
                continue;
            }
            throw new BadArgs("err.unknown.option", arg).showUsage(true);
        }
        if (this.options.accessOptions.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (String opt : this.options.accessOptions) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(opt);
            }
            throw new BadArgs("err.incompatible.options", sb);
        }
        if (!(this.classes != null && this.classes.size() != 0 || noArgs || this.options.help || this.options.version || this.options.fullVersion)) {
            throw new BadArgs("err.no.classes.specified", new Object[0]);
        }
        if (noArgs || this.options.help) {
            this.showHelp();
        }
        if (this.options.version || this.options.fullVersion) {
            this.showVersion(this.options.fullVersion);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOption(String name, Iterator<String> rest) throws BadArgs {
        for (Option o : recognizedOptions) {
            if (!o.matches(name)) continue;
            if (o.hasArg) {
                if (!rest.hasNext()) throw new BadArgs("err.missing.arg", name).showUsage(true);
                o.process(this, name, rest.next());
            } else {
                o.process(this, name, null);
            }
            if (!o.ignoreRest()) return;
            while (rest.hasNext()) {
                rest.next();
            }
            return;
        }
        try {
            if (!this.fileManager.handleOption(name, rest)) throw new BadArgs("err.unknown.option", name).showUsage(true);
            return;
        }
        catch (IllegalArgumentException e) {
            throw new BadArgs("err.invalid.use.of.option", name).showUsage(true);
        }
    }

    @Override
    public Boolean call() {
        return this.run() == 0;
    }

    public int run() {
        if (this.classes == null || this.classes.isEmpty()) {
            return 1;
        }
        this.context.put(PrintWriter.class, this.log);
        ClassWriter classWriter = ClassWriter.instance(this.context);
        SourceWriter sourceWriter = SourceWriter.instance(this.context);
        sourceWriter.setFileManager(this.fileManager);
        if (this.options.moduleName != null) {
            try {
                this.moduleLocation = this.findModule(this.options.moduleName);
                if (this.moduleLocation == null) {
                    this.reportError("err.cant.find.module", this.options.moduleName);
                    return 1;
                }
            }
            catch (IOException e) {
                this.reportError("err.cant.find.module.ex", this.options.moduleName, e);
                return 1;
            }
        }
        int result = 0;
        for (String className : this.classes) {
            Object msg;
            try {
                result = this.writeClass(classWriter, className);
            }
            catch (ConstantPoolException e) {
                this.reportError("err.bad.constant.pool", className, e.getLocalizedMessage());
                result = 1;
            }
            catch (EOFException e) {
                this.reportError("err.end.of.file", className);
                result = 1;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                this.reportError("err.file.not.found", e.getLocalizedMessage());
                result = 1;
            }
            catch (IOException e) {
                msg = e.getLocalizedMessage();
                if (msg == null) {
                    msg = e;
                }
                this.reportError("err.ioerror", className, msg);
                result = 1;
            }
            catch (OutOfMemoryError e) {
                this.reportError("err.nomem", new Object[0]);
                result = 1;
            }
            catch (FatalError e) {
                msg = e.getLocalizedMessage();
                if (msg == null) {
                    msg = e;
                }
                this.reportError("err.fatal.err", msg);
                result = 1;
            }
            catch (Throwable t) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                pw.close();
                this.reportError("err.crash", t.toString(), sw.toString());
                result = 4;
            }
        }
        return result;
    }

    protected int writeClass(ClassWriter classWriter, String className) throws IOException, ConstantPoolException {
        JavaFileObject fo = this.open(className);
        if (fo == null) {
            this.reportError("err.class.not.found", className);
            return 1;
        }
        ClassFileInfo cfInfo = this.read(fo);
        if (!className.endsWith(".class")) {
            if (cfInfo.cf.this_class == 0) {
                if (!className.equals("module-info")) {
                    this.reportWarning("warn.unexpected.class", fo.getName(), className);
                }
            } else {
                String cfName = cfInfo.cf.getName();
                if (!cfName.replaceAll("[/$]", ".").equals(className.replaceAll("[/$]", "."))) {
                    this.reportWarning("warn.unexpected.class", fo.getName(), className);
                }
            }
        }
        this.write(cfInfo);
        if (this.options.showInnerClasses) {
            ClassFile cf = cfInfo.cf;
            Attribute a = cf.getAttribute("InnerClasses");
            if (a instanceof InnerClasses_attribute) {
                InnerClasses_attribute inners = (InnerClasses_attribute)a;
                try {
                    int result = 0;
                    for (int i = 0; i < inners.classes.length; ++i) {
                        int outerIndex = inners.classes[i].outer_class_info_index;
                        ConstantPool.CONSTANT_Class_info outerClassInfo = cf.constant_pool.getClassInfo(outerIndex);
                        String outerClassName = outerClassInfo.getName();
                        if (!outerClassName.equals(cf.getName())) continue;
                        int innerIndex = inners.classes[i].inner_class_info_index;
                        ConstantPool.CONSTANT_Class_info innerClassInfo = cf.constant_pool.getClassInfo(innerIndex);
                        String innerClassName = innerClassInfo.getName();
                        classWriter.println("// inner class " + innerClassName.replaceAll("[/$]", "."));
                        classWriter.println();
                        result = this.writeClass(classWriter, innerClassName);
                        if (result == 0) continue;
                        return result;
                    }
                    return result;
                }
                catch (ConstantPoolException e) {
                    this.reportError("err.bad.innerclasses.attribute", className);
                    return 1;
                }
            }
            if (a != null) {
                this.reportError("err.bad.innerclasses.attribute", className);
                return 1;
            }
        }
        return 0;
    }

    protected JavaFileObject open(String className) throws IOException {
        int lastDot;
        JavaFileObject fo = this.getClassFileObject(className);
        if (fo != null) {
            return fo;
        }
        String cn = className;
        while ((lastDot = cn.lastIndexOf(".")) != -1) {
            fo = this.getClassFileObject(cn = cn.substring(0, lastDot) + "$" + cn.substring(lastDot + 1));
            if (fo == null) continue;
            return fo;
        }
        if (!className.endsWith(".class")) {
            return null;
        }
        if (this.fileManager instanceof StandardJavaFileManager) {
            StandardJavaFileManager sfm = (StandardJavaFileManager)this.fileManager;
            try {
                fo = sfm.getJavaFileObjects(className).iterator().next();
                if (fo != null && fo.getLastModified() != 0L) {
                    return fo;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (className.matches("^[A-Za-z]+:.*")) {
            try {
                final URI uri = new URI(className);
                URL url = uri.toURL();
                final URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                return new JavaFileObject(){

                    @Override
                    public JavaFileObject.Kind getKind() {
                        return JavaFileObject.Kind.CLASS;
                    }

                    @Override
                    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public NestingKind getNestingKind() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Modifier getAccessLevel() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public URI toUri() {
                        return uri;
                    }

                    @Override
                    public String getName() {
                        return uri.toString();
                    }

                    @Override
                    public InputStream openInputStream() throws IOException {
                        return conn.getInputStream();
                    }

                    @Override
                    public OutputStream openOutputStream() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Writer openWriter() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public long getLastModified() {
                        return conn.getLastModified();
                    }

                    @Override
                    public boolean delete() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFileInfo read(JavaFileObject fo) throws IOException, ConstantPoolException {
        try (InputStream in = fo.openInputStream();){
            SizeInputStream sizeIn = null;
            MessageDigest md = null;
            if (this.options.sysInfo || this.options.verbose) {
                try {
                    md = MessageDigest.getInstance("SHA-256");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
                in = new DigestInputStream(in, md);
                sizeIn = new SizeInputStream(in);
                in = sizeIn;
            }
            ClassFile cf = ClassFile.read(in, this.attributeFactory);
            byte[] digest = md == null ? null : md.digest();
            int size = sizeIn == null ? -1 : sizeIn.size();
            ClassFileInfo classFileInfo = new ClassFileInfo(fo, cf, digest, size);
            return classFileInfo;
        }
    }

    public void write(ClassFileInfo info) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        if (this.options.sysInfo || this.options.verbose) {
            classWriter.setFile(info.fo.toUri());
            classWriter.setLastModified(info.fo.getLastModified());
            classWriter.setDigest("SHA-256", info.digest);
            classWriter.setFileSize(info.size);
        }
        classWriter.write(info.cf);
    }

    protected void setClassFile(ClassFile classFile) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        classWriter.setClassFile(classFile);
    }

    protected void setMethod(Method enclosingMethod) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        classWriter.setMethod(enclosingMethod);
    }

    protected void write(Attribute value) {
        AttributeWriter attrWriter = AttributeWriter.instance(this.context);
        ClassWriter classWriter = ClassWriter.instance(this.context);
        ClassFile cf = classWriter.getClassFile();
        attrWriter.write((Object)cf, value, cf.constant_pool);
    }

    protected void write(Attributes attrs) {
        AttributeWriter attrWriter = AttributeWriter.instance(this.context);
        ClassWriter classWriter = ClassWriter.instance(this.context);
        ClassFile cf = classWriter.getClassFile();
        attrWriter.write((Object)cf, attrs, cf.constant_pool);
    }

    protected void write(ConstantPool constant_pool) {
        ConstantWriter constantWriter = ConstantWriter.instance(this.context);
        constantWriter.writeConstantPool(constant_pool);
    }

    protected void write(ConstantPool constant_pool, int value) {
        ConstantWriter constantWriter = ConstantWriter.instance(this.context);
        constantWriter.write(value);
    }

    protected void write(ConstantPool.CPInfo value) {
        ConstantWriter constantWriter = ConstantWriter.instance(this.context);
        constantWriter.println(value);
    }

    protected void write(Field value) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        classWriter.writeField(value);
    }

    protected void write(Method value) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        classWriter.writeMethod(value);
    }

    private JavaFileManager getDefaultFileManager(DiagnosticListener<? super JavaFileObject> dl, PrintWriter log) {
        if (this.defaultFileManager == null) {
            this.defaultFileManager = JavapFileManager.create(dl, log);
        }
        return this.defaultFileManager;
    }

    private JavaFileObject getClassFileObject(String className) throws IOException {
        try {
            JavaFileObject fo;
            if (this.moduleLocation != null) {
                fo = this.fileManager.getJavaFileForInput(this.moduleLocation, className, JavaFileObject.Kind.CLASS);
            } else {
                fo = this.fileManager.getJavaFileForInput(StandardLocation.PLATFORM_CLASS_PATH, className, JavaFileObject.Kind.CLASS);
                if (fo == null) {
                    fo = this.fileManager.getJavaFileForInput(StandardLocation.CLASS_PATH, className, JavaFileObject.Kind.CLASS);
                }
            }
            return fo;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private JavaFileManager.Location findModule(String moduleName) throws IOException {
        JavaFileManager.Location[] locns;
        for (JavaFileManager.Location segment : locns = new JavaFileManager.Location[]{StandardLocation.UPGRADE_MODULE_PATH, StandardLocation.SYSTEM_MODULES, StandardLocation.MODULE_PATH}) {
            for (Set<JavaFileManager.Location> set : this.fileManager.listLocationsForModules(segment)) {
                JavaFileManager.Location result = null;
                for (JavaFileManager.Location l : set) {
                    String name = this.fileManager.inferModuleName(l);
                    if (!name.equals(moduleName)) continue;
                    if (result == null) {
                        result = l;
                        continue;
                    }
                    throw new IOException("multiple definitions found for " + moduleName);
                }
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private void showHelp() {
        String[] fmOptions;
        this.printLines(this.getMessage("main.usage", progname));
        for (Option o : recognizedOptions) {
            String name = o.aliases[0].replaceAll("^-+", "").replaceAll("-+", "_");
            if (name.startsWith("X") || name.equals("fullversion")) continue;
            this.printLines(this.getMessage("main.opt." + name, new Object[0]));
        }
        for (String o : fmOptions = new String[]{"--module-path", "--system", "--class-path", "-classpath", "-cp", "-bootclasspath", "--multi-release"}) {
            if (this.fileManager.isSupportedOption(o) == -1) continue;
            String name = o.replaceAll("^-+", "").replaceAll("-+", "_");
            this.printLines(this.getMessage("main.opt." + name, new Object[0]));
        }
        this.printLines(this.getMessage("main.usage.foot", new Object[0]));
    }

    private void showVersion(boolean full) {
        this.printLines(this.version(full ? "full" : "release"));
    }

    private void printLines(String msg) {
        this.log.println(msg.replace("\n", nl));
    }

    private String version(String key) {
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException e) {
                return this.getMessage("version.resource.missing", System.getProperty("java.version"));
            }
        }
        try {
            return versionRB.getString(key);
        }
        catch (MissingResourceException e) {
            return this.getMessage("version.unknown", System.getProperty("java.version"));
        }
    }

    private void reportError(String key, Object ... args) {
        this.diagnosticListener.report(this.createDiagnostic(Diagnostic.Kind.ERROR, key, args));
    }

    private void reportNote(String key, Object ... args) {
        this.diagnosticListener.report(this.createDiagnostic(Diagnostic.Kind.NOTE, key, args));
    }

    private void reportWarning(String key, Object ... args) {
        this.diagnosticListener.report(this.createDiagnostic(Diagnostic.Kind.WARNING, key, args));
    }

    private Diagnostic<JavaFileObject> createDiagnostic(final Diagnostic.Kind kind, final String key, final Object ... args) {
        return new Diagnostic<JavaFileObject>(){

            @Override
            public Diagnostic.Kind getKind() {
                return kind;
            }

            @Override
            public JavaFileObject getSource() {
                return null;
            }

            @Override
            public long getPosition() {
                return -1L;
            }

            @Override
            public long getStartPosition() {
                return -1L;
            }

            @Override
            public long getEndPosition() {
                return -1L;
            }

            @Override
            public long getLineNumber() {
                return -1L;
            }

            @Override
            public long getColumnNumber() {
                return -1L;
            }

            @Override
            public String getCode() {
                return key;
            }

            @Override
            public String getMessage(Locale locale) {
                return JavapTask.this.getMessage(locale, key, args);
            }

            public String toString() {
                return this.getClass().getName() + "[key=" + key + ",args=" + Arrays.asList(args) + "]";
            }
        };
    }

    @Override
    public String getMessage(String key, Object ... args) {
        return this.getMessage(this.task_locale, key, args);
    }

    @Override
    public String getMessage(Locale locale, String key, Object ... args) {
        ResourceBundle b;
        if (this.bundles == null) {
            this.bundles = new HashMap<Locale, ResourceBundle>();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((b = this.bundles.get(locale)) == null) {
            try {
                b = ResourceBundle.getBundle("com.sun.tools.javap.resources.javap", locale);
                this.bundles.put(locale, b);
            }
            catch (MissingResourceException e) {
                throw new InternalError(new Object[]{"Cannot find javap resource bundle for locale " + locale});
            }
        }
        try {
            return MessageFormat.format(b.getString(key), args);
        }
        catch (MissingResourceException e) {
            throw new InternalError(e, key);
        }
    }

    public class BadArgs
    extends Exception {
        static final long serialVersionUID = 8765093759964640721L;
        final String key;
        final Object[] args;
        boolean showUsage;

        BadArgs(String key, Object ... args) {
            super(JavapTask.this.getMessage(key, args));
            this.key = key;
            this.args = args;
        }

        BadArgs showUsage(boolean b) {
            this.showUsage = b;
            return this;
        }
    }

    static abstract class Option {
        final boolean hasArg;
        final String[] aliases;

        Option(boolean hasArg, String ... aliases) {
            this.hasArg = hasArg;
            this.aliases = aliases;
        }

        boolean matches(String opt) {
            for (String a : this.aliases) {
                if (!a.equals(opt)) continue;
                return true;
            }
            return false;
        }

        boolean ignoreRest() {
            return false;
        }

        abstract void process(JavapTask var1, String var2, String var3) throws BadArgs;
    }

    public static class ClassFileInfo {
        public final JavaFileObject fo;
        public final ClassFile cf;
        public final byte[] digest;
        public final int size;

        ClassFileInfo(JavaFileObject fo, ClassFile cf, byte[] digest, int size) {
            this.fo = fo;
            this.cf = cf;
            this.digest = digest;
            this.size = size;
        }
    }

    private static class SizeInputStream
    extends FilterInputStream {
        private int size;

        SizeInputStream(InputStream in) {
            super(in);
        }

        int size() {
            return this.size;
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            int n = super.read(buf, offset, length);
            if (n > 0) {
                this.size += n;
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int b = super.read();
            ++this.size;
            return b;
        }
    }
}

