/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.stringvalidation.EncodableInCharsetValidator;
import org.netbeans.validation.api.builtin.stringvalidation.MayNotContainSpacesValidator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.api.builtin.stringvalidation.ValidHostNameOrIPValidator;
import org.netbeans.validation.localization.LocalizationSupport;

class EmailAddressValidator
extends StringValidator {
    private final Validator<String> hv = new ValidHostNameOrIPValidator(false);
    private final Validator<String> spv = new MayNotContainSpacesValidator();
    private final Validator<String> encv = new EncodableInCharsetValidator("US-ASCII");
    static final Pattern ADDRESS_PATTERN = Pattern.compile("(.*?)<(.*)>$");

    EmailAddressValidator() {
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        String host;
        Matcher m = ADDRESS_PATTERN.matcher(model);
        String address = m.lookingAt() ? (m.groupCount() == 2 ? m.group(2) : m.group(1)) : model;
        String[] nameAndHost = address.split("@");
        if (nameAndHost.length == 0) {
            problems.append(LocalizationSupport.getMessage(EmailAddressValidator.class, "NO_AT_SYMBOL", compName, address));
            return;
        }
        if (nameAndHost.length == 1 && nameAndHost[0].contains("@")) {
            problems.append(LocalizationSupport.getMessage(EmailAddressValidator.class, "EMAIL_MISSING_HOST", compName, nameAndHost[0]));
            return;
        }
        if (nameAndHost.length > 2) {
            problems.append(LocalizationSupport.getMessage(EmailAddressValidator.class, "EMAIL_HAS_>1_@", compName, address));
            return;
        }
        String name = nameAndHost[0];
        if (name.length() == 0) {
            problems.append(LocalizationSupport.getMessage(EmailAddressValidator.class, "EMAIL_MISSING_NAME", compName, name));
            return;
        }
        if (name.length() > 64) {
            problems.append(LocalizationSupport.getMessage(EmailAddressValidator.class, "ADDRESS_MAY_BE_TOO_LONG", compName, name), Severity.WARNING);
        }
        String string = host = nameAndHost.length >= 2 ? nameAndHost[1] : null;
        if (host == null) {
            problems.append(LocalizationSupport.getMessage(EmailAddressValidator.class, "EMAIL_MISSING_HOST", compName, nameAndHost[0]));
            return;
        }
        this.hv.validate(problems, compName, host);
        this.spv.validate(problems, compName, name);
        this.encv.validate(problems, compName, address);
    }
}

