/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public final class SrcFinder {
    private SrcFinder() {
    }

    static Object[] findSource(String aPackage, URL url) {
        Object[] objectArray;
        aPackage = aPackage.replace('.', '/');
        String thePackage = null;
        final String member = url.getRef();
        String clazz = url.getFile();
        String filename = null;
        int pIndex = clazz.toLowerCase().lastIndexOf(aPackage.trim().toLowerCase());
        if (pIndex != -1) {
            thePackage = clazz.substring(pIndex, pIndex + aPackage.trim().length() - 1);
            int ei = (clazz = clazz.substring(pIndex + aPackage.trim().length(), clazz.length() - 5)).indexOf(46);
            filename = ei != -1 ? clazz.substring(0, ei) : clazz;
        }
        String resourceName = thePackage + "/" + filename + ".java";
        FileObject fo = SrcFinder.searchResource(url, resourceName);
        final ElementHandle[] handles = new ElementHandle[1];
        if (fo != null) {
            final String className = clazz;
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ctrl) throws Exception {
                        ctrl.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement classElm = SrcFinder.findClass(ctrl, className);
                        if (classElm != null) {
                            int pi;
                            handles[0] = member == null ? ElementHandle.create((Element)classElm) : ((pi = member.indexOf(40)) == -1 ? SrcFinder.findField(classElm, member) : SrcFinder.findMethod(ctrl, classElm, member));
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Logger.getLogger(SrcFinder.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
        }
        if (handles[0] != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = fo;
            objectArray = objectArray2;
            objectArray2[1] = handles[0];
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private static FileObject searchResource(URL url, String respath) {
        FileObject res = SrcFinder.searchBinaryPath("classpath/boot", respath, url);
        if (res == null) {
            res = SrcFinder.searchBinaryPath("classpath/compile", respath, url);
        }
        if (res == null) {
            res = SrcFinder.searchSourcePath(respath, url);
        }
        return res;
    }

    private static FileObject searchBinaryPath(String classPathID, String respath, URL url) {
        Set cpaths = GlobalPathRegistry.getDefault().getPaths(classPathID);
        for (ClassPath cpath : cpaths) {
            FileObject[] cpRoots = cpath.getRoots();
            for (int i = 0; i < cpRoots.length; ++i) {
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)URLMapper.findURL((FileObject)cpRoots[i], (int)1));
                FileObject[] srcRoots = result.getRoots();
                for (int j = 0; j < srcRoots.length; ++j) {
                    FileObject fo = srcRoots[j].getFileObject(respath);
                    if (fo == null || !SrcFinder.isJavadocAssigned(cpath, url)) continue;
                    return fo;
                }
            }
        }
        return null;
    }

    private static FileObject searchSourcePath(String respath, URL url) {
        Set cpaths = GlobalPathRegistry.getDefault().getPaths("classpath/source");
        for (ClassPath cpath : cpaths) {
            FileObject fo = cpath.findResource(respath);
            if (fo == null || !SrcFinder.isJavadocAssigned(cpath, url)) continue;
            return fo;
        }
        return null;
    }

    private static boolean isJavadocAssigned(ClassPath cpath, URL url) {
        FileObject[] cpRoots = cpath.getRoots();
        String urlPath = url.toExternalForm();
        for (int i = 0; i < cpRoots.length; ++i) {
            JavadocForBinaryQuery.Result result = JavadocForBinaryQuery.findJavadoc((URL)URLMapper.findURL((FileObject)cpRoots[i], (int)1));
            URL[] jdRoots = result.getRoots();
            for (int j = 0; j < jdRoots.length; ++j) {
                String jdRootPath = jdRoots[j].toExternalForm();
                if (urlPath.indexOf(jdRootPath) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static TypeElement findClass(CompilationController ctrl, String className) {
        CompilationUnitTree cunit = ctrl.getCompilationUnit();
        for (Tree tree : cunit.getTypeDecls()) {
            ClassTree classTree = (ClassTree)tree;
            if (!className.equals(classTree.getSimpleName().toString())) continue;
            Trees trees = ctrl.getTrees();
            TypeElement classElm = (TypeElement)trees.getElement(trees.getPath(cunit, classTree));
            return classElm;
        }
        return null;
    }

    private static ElementHandle findField(TypeElement classElm, String name) {
        for (Element element : classElm.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || !name.equals(element.getSimpleName().toString())) continue;
            return ElementHandle.create((Element)element);
        }
        return null;
    }

    private static ElementHandle findMethod(CompilationController ctrl, TypeElement ce, String member) {
        TreeUtilities utils = ctrl.getTreeUtilities();
        int pi = member.indexOf(40);
        String name = member.substring(0, pi);
        StringTokenizer tokenizer = new StringTokenizer(member.substring(pi), " ,()");
        ArrayList<TypeMirror> paramList = new ArrayList<TypeMirror>();
        while (tokenizer.hasMoreTokens()) {
            Object token = tokenizer.nextToken();
            if (((String)token).endsWith("...")) {
                token = ((String)token).substring(0, ((String)token).length() - 3);
                token = (String)token + "[]";
            }
            TypeMirror typeMirror = utils.parseType((String)token, ce);
            paramList.add(typeMirror);
        }
        for (Element element : ce.getEnclosedElements()) {
            if (element.getKind() == ElementKind.METHOD && name.equals(element.getSimpleName().toString()) && SrcFinder.compareTypes(ctrl, paramList, ((ExecutableElement)element).getParameters())) {
                return ElementHandle.create((Element)element);
            }
            if (element.getKind() != ElementKind.CONSTRUCTOR || !name.equals(ce.getSimpleName().toString()) || !SrcFinder.compareTypes(ctrl, paramList, ((ExecutableElement)element).getParameters())) continue;
            return ElementHandle.create((Element)element);
        }
        return null;
    }

    private static boolean compareTypes(CompilationController ctrl, List<TypeMirror> types, List<? extends VariableElement> params) {
        if (types.size() != params.size()) {
            return false;
        }
        Iterator<? extends VariableElement> itParams = params.iterator();
        Iterator<TypeMirror> itTypes = types.iterator();
        while (itParams.hasNext()) {
            Element typeElm;
            Element paramElm;
            VariableElement varEl = itParams.next();
            TypeMirror paramType = varEl.asType();
            TypeMirror type = itTypes.next();
            if (type.getKind() != paramType.getKind()) {
                return false;
            }
            if (!(type.getKind() == TypeKind.DECLARED ? (paramElm = ((DeclaredType)paramType).asElement()) != (typeElm = ((DeclaredType)type).asElement()) : !ctrl.getTypes().isSameType(type, paramType))) continue;
            return false;
        }
        return true;
    }
}

