/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.launch;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.netbeans.modules.java.lsp.server.ui.IOContext;
import org.openide.util.Exceptions;

public final class NbProcessConsole
extends IOContext {
    private static final String STDOUT = "stdout";
    private static final String STDERR = "stderr";
    private final Consumer<ConsoleMessage> messageConsumer;
    private boolean stopped;
    private final PipedOutputStream inputSource = new PipedOutputStream();
    private BufferedWriter inputBuffer;
    private PipedInputStream inputSink;

    NbProcessConsole(Consumer<ConsoleMessage> messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopped = true;
        NbProcessConsole nbProcessConsole = this;
        synchronized (nbProcessConsole) {
            if (this.inputSink != null) {
                try {
                    this.inputSink.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream getStdIn() throws IOException {
        NbProcessConsole nbProcessConsole = this;
        synchronized (nbProcessConsole) {
            if (this.inputSink == null) {
                this.inputSink = new PipedInputStream(this.inputSource){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() throws IOException {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            super.close();
                            NbProcessConsole.this.inputSource.close();
                        }
                    }
                };
            }
        }
        return this.inputSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stdIn(String line) throws IOException {
        NbProcessConsole nbProcessConsole = this;
        synchronized (nbProcessConsole) {
            if (this.inputBuffer == null) {
                this.inputBuffer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.inputSource, StandardCharsets.UTF_8));
            }
        }
        this.inputBuffer.write(line);
        this.inputBuffer.newLine();
        this.inputBuffer.flush();
    }

    @Override
    protected void stdOut(String line) {
        ConsoleMessage msg = new ConsoleMessage(line, STDOUT);
        this.messageConsumer.accept(msg);
    }

    @Override
    public void stdErr(String line) {
        ConsoleMessage msg = new ConsoleMessage(line, STDERR);
        this.messageConsumer.accept(msg);
    }

    @Override
    protected boolean isValid() {
        return !this.stopped;
    }

    public static final class ConsoleMessage {
        public String output;
        public String category;

        public ConsoleMessage(String message, String category) {
            this.output = message;
            this.category = category;
        }
    }
}

