/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.ui.build2.BuildImageAction;
import org.netbeans.modules.docker.ui.node.Bundle;
import org.netbeans.modules.docker.ui.node.DockerInstanceChildFactory;
import org.netbeans.modules.docker.ui.node.RefreshAction;
import org.netbeans.modules.docker.ui.node.RemoveInstanceAction;
import org.netbeans.modules.docker.ui.node.StatefulDockerInstance;
import org.netbeans.modules.docker.ui.pull.PullImageAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class DockerInstanceNode
extends AbstractNode {
    private static final String DOCKER_INSTANCE_ICON = "org/netbeans/modules/docker/ui/resources/docker_instance.png";
    private final StatefulDockerInstance instance;
    private final ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            DockerInstanceNode.this.fireDisplayNameChange(null, null);
        }
    };

    public DockerInstanceNode(StatefulDockerInstance instance, DockerInstanceChildFactory factory) {
        super(Children.create((ChildFactory)factory, (boolean)true), Lookups.fixed((Object[])new Object[]{instance.getInstance(), instance, factory}));
        this.instance = instance;
        this.setIconBaseWithExtension(DOCKER_INSTANCE_ICON);
        this.setShortDescription(instance.getInstance().getUrl());
        instance.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)instance));
        instance.refresh();
    }

    public String getDisplayName() {
        String displayName = this.instance.getInstance().getDisplayName();
        if (this.instance.isAvailable()) {
            return displayName;
        }
        return Bundle.LBL_Offline(displayName);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(PullImageAction.class), null, SystemAction.get(BuildImageAction.class), null, SystemAction.get(RefreshAction.class), null, SystemAction.get(RemoveInstanceAction.class)};
    }
}

