/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteNetworkSourceRequest
extends BmcRequest<Void> {
    private String networkSourceId;
    private String ifMatch;

    public String getNetworkSourceId() {
        return this.networkSourceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().networkSourceId(this.networkSourceId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",networkSourceId=").append(String.valueOf(this.networkSourceId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteNetworkSourceRequest)) {
            return false;
        }
        DeleteNetworkSourceRequest other = (DeleteNetworkSourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.networkSourceId, other.networkSourceId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkSourceId == null ? 43 : this.networkSourceId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteNetworkSourceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String networkSourceId = null;
        private String ifMatch = null;

        public Builder networkSourceId(String networkSourceId) {
            this.networkSourceId = networkSourceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteNetworkSourceRequest o) {
            this.networkSourceId(o.getNetworkSourceId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteNetworkSourceRequest build() {
            DeleteNetworkSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteNetworkSourceRequest buildWithoutInvocationCallback() {
            DeleteNetworkSourceRequest request = new DeleteNetworkSourceRequest();
            request.networkSourceId = this.networkSourceId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

