/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

public final class SyncFutureWaiter
implements Executor {
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();

    @Override
    public synchronized void execute(Runnable command) {
        this.tasks.add(command);
        this.notifyAll();
    }

    public <R> R listenForResult(CompletionStage<R> stage) throws Throwable {
        Waiter<R> waiter = new Waiter<R>();
        waiter.listenForResult(stage);
        return waiter.waitAndWork();
    }

    private class Waiter<R> {
        private boolean complete = false;
        private Throwable failure;
        private R result;

        private Waiter() {
        }

        public void listenForResult(CompletionStage<R> stage) {
            stage.whenComplete((r, t) -> {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                SyncFutureWaiter syncFutureWaiter = SyncFutureWaiter.this;
                synchronized (syncFutureWaiter) {
                    this.complete = true;
                    this.failure = t;
                    this.result = r;
                    SyncFutureWaiter.this.notifyAll();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R waitAndWork() throws InterruptedException, Throwable {
            SyncFutureWaiter syncFutureWaiter = SyncFutureWaiter.this;
            synchronized (syncFutureWaiter) {
                while (!this.complete) {
                    Runnable task = (Runnable)SyncFutureWaiter.this.tasks.poll();
                    if (task == null) {
                        SyncFutureWaiter.this.wait();
                        continue;
                    }
                    task.run();
                }
                if (this.result == null) {
                    throw this.failure;
                }
                return this.result;
            }
        }
    }
}

