/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.svg.toolbar;

import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import org.netbeans.modules.svg.BackgroundMode;
import org.netbeans.modules.svg.SVGViewerElement;
import org.netbeans.modules.svg.toolbar.BackgroundIcon;
import org.netbeans.modules.svg.toolbar.actions.CustomZoomAction;
import org.netbeans.modules.svg.toolbar.actions.ZoomInAction;
import org.netbeans.modules.svg.toolbar.actions.ZoomOutAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class SVGViewerToolbar {
    private final Collection<JButton> toolbarButtons = new ArrayList<JButton>(11);
    private SVGViewerElement svgViewerElement;
    private final DecimalFormat formatter = new DecimalFormat("#.##");
    private CustomZoomAction customZoomAction;

    public JToolBar createToolbar(SVGViewerElement svgViewerElement) {
        this.svgViewerElement = svgViewerElement;
        JToolBar toolBar = new JToolBar();
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setFloatable(false);
        toolBar.setName(NbBundle.getMessage(SVGViewerToolbar.class, (String)"ACSN_Toolbar"));
        toolBar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGViewerToolbar.class, (String)"ACSD_Toolbar"));
        JButton outButton = new JButton((Action)SystemAction.get(ZoomOutAction.class));
        outButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/image/zoomOut.gif", (boolean)false));
        outButton.setToolTipText(NbBundle.getMessage(ZoomOutAction.class, (String)"LBL_ZoomOut"));
        outButton.setMnemonic(NbBundle.getMessage(SVGViewerToolbar.class, (String)"ACS_Out_BTN_Mnem").charAt(0));
        outButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGViewerToolbar.class, (String)"ACSD_Out_BTN"));
        outButton.setText("");
        toolBar.add(outButton);
        this.toolbarButtons.add(outButton);
        JButton inButton = new JButton((Action)SystemAction.get(ZoomInAction.class));
        inButton.setToolTipText(NbBundle.getMessage(ZoomInAction.class, (String)"LBL_ZoomIn"));
        inButton.setMnemonic(NbBundle.getMessage(SVGViewerToolbar.class, (String)"ACS_In_BTN_Mnem").charAt(0));
        inButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGViewerToolbar.class, (String)"ACSD_In_BTN"));
        inButton.setText("");
        toolBar.add(inButton);
        this.toolbarButtons.add(inButton);
        toolBar.addSeparator(new Dimension(11, 0));
        JButton button = this.createZoomButton(1, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.createZoomButton(1, 3);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.createZoomButton(1, 5);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.createZoomButton(1, 7);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.createZoomButton(3, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.createZoomButton(5, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.createZoomButton(7, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.createZoomButton();
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.createCustomBackgroundButton(BackgroundMode.BLACK, Color.BLACK);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.createCustomBackgroundButton(BackgroundMode.WHITE, Color.WHITE);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.createCustomBackgroundButton(BackgroundMode.TRANSPARENT, Color.LIGHT_GRAY);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.createCustomBackgroundButton(BackgroundMode.DARK_TRANSPARENT, Color.DARK_GRAY);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.createCustomBackgroundButton(BackgroundMode.DEFAULT, Color.WHITE);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        toolBar.add(new JLabel(NbBundle.getMessage(SVGViewerToolbar.class, (String)"LBL_ImageDimensions", (Object)svgViewerElement.getImageWidth(), (Object)svgViewerElement.getImageHeight())));
        if (svgViewerElement.getImageSize() != -1L) {
            String label;
            double size;
            toolBar.addSeparator(new Dimension(11, 0));
            double kb = 1024.0;
            double mb = kb * kb;
            if ((double)svgViewerElement.getImageSize() >= mb) {
                size = (double)svgViewerElement.getImageSize() / mb;
                label = "LBL_ImageSizeMb";
            } else if ((double)svgViewerElement.getImageSize() >= kb) {
                size = (double)svgViewerElement.getImageSize() / kb;
                label = "LBL_ImageSizeKb";
            } else {
                size = svgViewerElement.getImageSize();
                label = "LBL_ImageSizeBytes";
            }
            toolBar.add(new JLabel(NbBundle.getMessage(SVGViewerToolbar.class, (String)label, (Object)this.formatter.format(size))));
        }
        for (JButton jb : this.toolbarButtons) {
            jb.setFocusable(false);
        }
        return toolBar;
    }

    private JButton createZoomButton(int xf, int yf) {
        JButton button = new JButton(xf + ":" + yf);
        if (xf < yf) {
            button.setToolTipText(NbBundle.getMessage(ZoomOutAction.class, (String)"LBL_ZoomOut") + " " + xf + " : " + yf);
        } else {
            button.setToolTipText(NbBundle.getMessage(ZoomInAction.class, (String)"LBL_ZoomIn") + " " + xf + " : " + yf);
        }
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGViewerToolbar.class, (String)"ACS_Zoom_BTN"));
        button.addActionListener(evt -> this.svgViewerElement.customZoom(xf, yf));
        return button;
    }

    private JButton createZoomButton() {
        JButton button = new JButton((Action)SystemAction.get(CustomZoomAction.class));
        button.setToolTipText(NbBundle.getMessage(CustomZoomAction.class, (String)"LBL_CustomZoom"));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGViewerToolbar.class, (String)"ACS_Zoom_BTN"));
        return button;
    }

    private JButton createCustomBackgroundButton(BackgroundMode bgMode, Color color) {
        JButton button = new JButton();
        button.setIcon(new BackgroundIcon(bgMode, color));
        button.setToolTipText(NbBundle.getMessage(SVGViewerToolbar.class, (String)"LBL_ChangeBackground", (Object)bgMode.name()));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGViewerToolbar.class, (String)"ACS_Background_BTN"));
        button.addActionListener(evt -> this.svgViewerElement.changeBackground(bgMode));
        return button;
    }
}

