/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.common;

import com.sun.xml.registry.common.JAXRResponseImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;

public class BulkResponseImpl
extends JAXRResponseImpl
implements BulkResponse {
    static final Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.common");
        }
    });
    private ArrayList collection = new ArrayList();
    private ArrayList exceptions;
    private boolean isPartial = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getCollection() throws JAXRException {
        BulkResponseImpl bulkResponseImpl = this;
        synchronized (bulkResponseImpl) {
            while (!this.isAvailable()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (Collection)this.collection.clone();
        }
    }

    public void setCollection(Collection collection) {
        this.collection = new ArrayList(collection);
        if (this.isPartial) {
            this.setStatus(1);
        }
    }

    public void addCollection(Collection bCollection) {
        if (bCollection != null) {
            Iterator iter = bCollection.iterator();
            while (iter.hasNext()) {
                this.collection.add(iter.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getExceptions() throws JAXRException {
        BulkResponseImpl bulkResponseImpl = this;
        synchronized (bulkResponseImpl) {
            while (!this.isAvailable()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.exceptions != null) {
                return (Collection)this.exceptions.clone();
            }
            return null;
        }
    }

    public void addException(Collection bException) {
        if (bException != null && bException.size() > 0) {
            this.setStatus(2);
            this.initExceptions();
            Iterator iter = bException.iterator();
            while (iter.hasNext()) {
                this.exceptions.add(iter.next());
            }
        }
    }

    public void setExceptions(Collection bException) {
        if (bException != null && bException.size() > 0) {
            this.setStatus(2);
            this.initExceptions();
            this.exceptions = null;
            this.exceptions = new ArrayList(bException);
        }
    }

    public void addException(JAXRException except) {
        this.initExceptions();
        this.exceptions.add(except);
        this.setStatus(2);
    }

    public boolean isPartialResponse() throws JAXRException {
        return this.isPartial;
    }

    public void setPartialResponse(boolean isPartial) throws JAXRException {
        if (this.collection.size() > 0) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("BulkResponseImpl:Cannot_set_isPartial_with_collection_already_set."));
        }
        this.isPartial = isPartial;
    }

    public void setPartialResponse(String isPartial) throws JAXRException {
        if (this.collection.size() > 0) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("BulkResponseImpl:Cannot_set_isPartial_with_collection_already_set."));
        }
        this.isPartial = Boolean.valueOf(isPartial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResponse(BulkResponse update) throws JAXRException {
        BulkResponseImpl bulkResponseImpl = this;
        synchronized (bulkResponseImpl) {
            this.setPartialResponse(update.isPartialResponse());
            this.collection = new ArrayList(update.getCollection());
            if (update.getExceptions() != null) {
                this.exceptions = new ArrayList(update.getExceptions());
            }
            this.setStatus(update.getStatus());
            this.notify();
        }
    }

    public static BulkResponse combineBulkResponses(Collection responses) {
        BulkResponseImpl combinedResponse = new BulkResponseImpl();
        combinedResponse.setStatus(0);
        try {
            BulkResponseImpl response2 = null;
            ArrayList information = new ArrayList();
            ArrayList exceptions = new ArrayList();
            boolean isPartial = false;
            for (BulkResponseImpl response2 : responses) {
                information.addAll(response2.getCollection());
                if (response2.getExceptions() != null) {
                    exceptions.addAll(response2.getExceptions());
                }
                if (!response2.isPartialResponse()) continue;
                isPartial = true;
            }
            combinedResponse.setPartialResponse(isPartial);
            if (isPartial) {
                combinedResponse.setStatus(1);
            }
            combinedResponse.setCollection(information);
            if (exceptions.size() > 0) {
                combinedResponse.setExceptions(exceptions);
                combinedResponse.setStatus(2);
            }
        }
        catch (JAXRException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return combinedResponse;
    }

    private void initExceptions() {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
    }
}

