/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.FormLoginConfig;
import org.netbeans.modules.j2ee.dd.api.web.LoginConfig;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;

public class LoginConfigPanel
extends SectionInnerPanel {
    private static final Logger LOG = Logger.getLogger(LoginConfigPanel.class.getName());
    private static String NONE = "NONE";
    private static String BASIC = "BASIC";
    private static String DIGEST = "DIGEST";
    private static String FORM = "FORM";
    private static String CLIENT_CERT = "CLIENT-CERT";
    private WebApp webApp;
    private LoginConfig loginConfig;
    private DDDataObject dObj;
    private JRadioButton basicRB;
    private ButtonGroup buttonGroup1;
    private JRadioButton clientCertRB;
    private JRadioButton digestRB;
    private JButton errorPageBrowseButton;
    private JLabel errorPageLabel;
    private JTextField errorPageTF;
    private JRadioButton formRB;
    private JButton loginPageBrowseButton;
    private JLabel loginPageLabel;
    private JTextField loginPageTF;
    private JRadioButton noneRB;
    private JLabel realmNameLabel;
    private JTextField realmNameTF;

    public LoginConfigPanel(SectionView view, DDDataObject dObj) {
        super(view);
        this.initComponents();
        this.dObj = dObj;
        this.webApp = dObj.getWebApp();
        this.loginConfig = this.webApp.getSingleLoginConfig();
        this.initPanel();
    }

    private void initPanel() {
        if (this.loginConfig == null) {
            this.updateVisualState(NONE);
        } else {
            FormLoginConfig formLoginConfig;
            String authMethod = this.loginConfig.getAuthMethod();
            this.updateVisualState(authMethod);
            if (authMethod.equals(FORM) && (formLoginConfig = this.loginConfig.getFormLoginConfig()) != null) {
                this.loginPageTF.setText(formLoginConfig.getFormLoginPage());
                this.errorPageTF.setText(formLoginConfig.getFormErrorPage());
            }
            if (!authMethod.equals(NONE)) {
                this.realmNameTF.setText(this.loginConfig.getRealmName());
            }
        }
        this.addModifier(this.noneRB);
        this.addModifier(this.digestRB);
        this.addModifier(this.clientCertRB);
        this.addModifier(this.basicRB);
        this.addModifier(this.formRB);
        this.addValidatee(this.realmNameTF);
        this.addValidatee(this.loginPageTF);
        this.addValidatee(this.errorPageTF);
    }

    private void updateVisualState(String state) {
        boolean loginPages = false;
        boolean realm = true;
        if (state.equals(NONE)) {
            this.noneRB.setSelected(true);
            realm = false;
        } else if (state.equals(DIGEST)) {
            this.digestRB.setSelected(true);
        } else if (state.equals(CLIENT_CERT)) {
            this.clientCertRB.setSelected(true);
        } else if (state.equals(BASIC)) {
            this.basicRB.setSelected(true);
        } else if (state.equals(FORM)) {
            this.formRB.setSelected(true);
            loginPages = true;
        } else {
            this.noneRB.setSelected(true);
            realm = false;
        }
        this.realmNameLabel.setEnabled(realm);
        this.realmNameTF.setEnabled(realm);
        this.loginPageLabel.setEnabled(loginPages);
        this.loginPageTF.setEnabled(loginPages);
        this.loginPageBrowseButton.setEnabled(loginPages);
        this.errorPageLabel.setEnabled(loginPages);
        this.errorPageTF.setEnabled(loginPages);
        this.errorPageBrowseButton.setEnabled(loginPages);
    }

    public void linkButtonPressed(Object obj, String id) {
    }

    public JComponent getErrorComponent(String name) {
        return null;
    }

    public void documentChanged(JTextComponent comp, String value) {
    }

    private void setLoginConfig(LoginConfig config) {
        this.webApp.setLoginConfig(config);
        this.loginConfig = config;
    }

    private LoginConfig getLoginConfig() {
        if (this.loginConfig == null) {
            try {
                this.loginConfig = (LoginConfig)this.webApp.createBean("LoginConfig");
                this.webApp.setLoginConfig(this.loginConfig);
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.FINE, "ignored exception", ex);
            }
        }
        return this.loginConfig;
    }

    private FormLoginConfig getFormLoginConfig() {
        LoginConfig loginConfig = this.getLoginConfig();
        FormLoginConfig formLoginConfig = loginConfig.getFormLoginConfig();
        if (formLoginConfig == null) {
            try {
                formLoginConfig = (FormLoginConfig)this.webApp.createBean("FormLoginConfig");
                loginConfig.setFormLoginConfig(formLoginConfig);
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.FINE, "ignored exception", ex);
            }
        }
        return formLoginConfig;
    }

    public void setValue(JComponent source, Object value) {
        if (source instanceof JRadioButton) {
            String authMethod = null;
            authMethod = source == this.noneRB ? NONE : (source == this.digestRB ? DIGEST : (source == this.clientCertRB ? CLIENT_CERT : (source == this.basicRB ? BASIC : (source == this.formRB ? FORM : NONE))));
            this.setLoginConfig(null);
            if (!authMethod.equals(NONE)) {
                LoginConfig loginConfig = this.getLoginConfig();
                loginConfig.setAuthMethod(authMethod);
                if (!authMethod.equals(NONE)) {
                    if (this.realmNameTF.getText().length() > 0) {
                        loginConfig.setRealmName(this.realmNameTF.getText());
                    } else {
                        loginConfig.setRealmName(null);
                    }
                }
                if (authMethod.equals(FORM)) {
                    FormLoginConfig formLoginConfig = this.getFormLoginConfig();
                    formLoginConfig.setFormLoginPage(this.loginPageTF.getText());
                    formLoginConfig.setFormErrorPage(this.errorPageTF.getText());
                }
            }
            this.updateVisualState(authMethod);
        } else if (source == this.realmNameTF) {
            if (((String)value).length() > 0) {
                this.getLoginConfig().setRealmName((String)value);
            } else {
                this.getLoginConfig().setRealmName(null);
            }
        } else if (source == this.loginPageTF) {
            this.getFormLoginConfig().setFormLoginPage((String)value);
        } else if (source == this.errorPageTF) {
            this.getFormLoginConfig().setFormErrorPage((String)value);
        }
    }

    public void rollbackValue(JTextComponent source) {
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.realmNameLabel = new JLabel();
        this.loginPageLabel = new JLabel();
        this.errorPageLabel = new JLabel();
        this.realmNameTF = new JTextField();
        this.loginPageTF = new JTextField();
        this.errorPageTF = new JTextField();
        this.loginPageBrowseButton = new JButton();
        this.errorPageBrowseButton = new JButton();
        this.noneRB = new JRadioButton();
        this.digestRB = new JRadioButton();
        this.clientCertRB = new JRadioButton();
        this.basicRB = new JRadioButton();
        this.formRB = new JRadioButton();
        this.realmNameLabel.setLabelFor(this.realmNameTF);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.realmNameLabel, (String)bundle.getString("LBL_RealmName"));
        this.realmNameLabel.setEnabled(false);
        this.loginPageLabel.setLabelFor(this.loginPageTF);
        Mnemonics.setLocalizedText((JLabel)this.loginPageLabel, (String)bundle.getString("LBL_FormLoginPage"));
        this.loginPageLabel.setEnabled(false);
        this.errorPageLabel.setLabelFor(this.loginPageTF);
        Mnemonics.setLocalizedText((JLabel)this.errorPageLabel, (String)bundle.getString("LBL_FormErrorPage"));
        this.errorPageLabel.setEnabled(false);
        this.realmNameTF.setEnabled(false);
        this.loginPageTF.setEnabled(false);
        this.errorPageTF.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.loginPageBrowseButton, (String)bundle.getString("LBL_browse"));
        this.loginPageBrowseButton.setEnabled(false);
        this.loginPageBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.loginPageBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.errorPageBrowseButton, (String)bundle.getString("LBL_browse"));
        this.errorPageBrowseButton.setEnabled(false);
        this.errorPageBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.errorPageBrowseButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.noneRB);
        this.noneRB.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.noneRB, (String)bundle.getString("LBL_NoneAuthMethod"));
        this.noneRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noneRB.setMargin(new Insets(0, 0, 0, 0));
        this.noneRB.setOpaque(false);
        this.noneRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.noneRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.digestRB);
        Mnemonics.setLocalizedText((AbstractButton)this.digestRB, (String)bundle.getString("LBL_DigestAuthMethod"));
        this.digestRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.digestRB.setMargin(new Insets(0, 0, 0, 0));
        this.digestRB.setOpaque(false);
        this.digestRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.digestRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.clientCertRB);
        Mnemonics.setLocalizedText((AbstractButton)this.clientCertRB, (String)bundle.getString("LBL_ClientCertAuthMethod"));
        this.clientCertRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientCertRB.setMargin(new Insets(0, 0, 0, 0));
        this.clientCertRB.setOpaque(false);
        this.clientCertRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.clientCertRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.basicRB);
        Mnemonics.setLocalizedText((AbstractButton)this.basicRB, (String)bundle.getString("LBL_BasicAuthMethod"));
        this.basicRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.basicRB.setMargin(new Insets(0, 0, 0, 0));
        this.basicRB.setOpaque(false);
        this.basicRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.basicRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.formRB);
        Mnemonics.setLocalizedText((AbstractButton)this.formRB, (String)bundle.getString("LBL_FormAuthMethod"));
        this.formRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.formRB.setMargin(new Insets(0, 0, 0, 0));
        this.formRB.setOpaque(false);
        this.formRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.formRBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noneRB).addComponent(this.digestRB).addComponent(this.clientCertRB).addComponent(this.basicRB).addComponent(this.formRB).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loginPageLabel).addComponent(this.errorPageLabel)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.errorPageTF, -1, 201, Short.MAX_VALUE).addComponent(this.loginPageTF, GroupLayout.Alignment.LEADING, -1, 201, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorPageBrowseButton).addComponent(this.loginPageBrowseButton))).addGroup(layout.createSequentialGroup().addComponent(this.realmNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.realmNameTF, -1, 341, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.noneRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.digestRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clientCertRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.basicRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loginPageBrowseButton).addComponent(this.loginPageLabel).addComponent(this.loginPageTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.errorPageBrowseButton).addComponent(this.errorPageLabel).addComponent(this.errorPageTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.realmNameLabel).addComponent(this.realmNameTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void formRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(FORM);
    }

    private void basicRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(BASIC);
    }

    private void clientCertRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(CLIENT_CERT);
    }

    private void digestRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(DIGEST);
    }

    private void noneRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(NONE);
    }

    private void errorPageBrowseButtonActionPerformed(ActionEvent evt) {
        try {
            String res;
            SourceGroup[] groups = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fo = BrowseFolders.showDialog(groups);
            if (fo != null && !(res = "/" + DDUtils.getResourcePath(groups, fo, '/', true)).equals(this.errorPageTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.errorPageTF.setText(res);
                this.dObj.setChangedFromUI(true);
                this.getFormLoginConfig().setFormErrorPage(res);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "ignored exception", ex);
        }
    }

    private void loginPageBrowseButtonActionPerformed(ActionEvent evt) {
        try {
            String res;
            SourceGroup[] groups = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fo = BrowseFolders.showDialog(groups);
            if (fo != null && !(res = "/" + DDUtils.getResourcePath(groups, fo, '/', true)).equals(this.loginPageTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.loginPageTF.setText(res);
                this.dObj.setChangedFromUI(true);
                this.getFormLoginConfig().setFormLoginPage(res);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "ignored exception", ex);
        }
    }
}

