/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetAlarmHistoryRequest
extends BmcRequest<Void> {
    private String alarmId;
    private String opcRequestId;
    private AlarmHistorytype alarmHistorytype;
    private String page;
    private Integer limit;
    private Date timestampGreaterThanOrEqualTo;
    private Date timestampLessThan;

    public String getAlarmId() {
        return this.alarmId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AlarmHistorytype getAlarmHistorytype() {
        return this.alarmHistorytype;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Date getTimestampGreaterThanOrEqualTo() {
        return this.timestampGreaterThanOrEqualTo;
    }

    public Date getTimestampLessThan() {
        return this.timestampLessThan;
    }

    public Builder toBuilder() {
        return new Builder().alarmId(this.alarmId).opcRequestId(this.opcRequestId).alarmHistorytype(this.alarmHistorytype).page(this.page).limit(this.limit).timestampGreaterThanOrEqualTo(this.timestampGreaterThanOrEqualTo).timestampLessThan(this.timestampLessThan);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",alarmId=").append(String.valueOf(this.alarmId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",alarmHistorytype=").append(String.valueOf((Object)this.alarmHistorytype));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",timestampGreaterThanOrEqualTo=").append(String.valueOf(this.timestampGreaterThanOrEqualTo));
        sb.append(",timestampLessThan=").append(String.valueOf(this.timestampLessThan));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAlarmHistoryRequest)) {
            return false;
        }
        GetAlarmHistoryRequest other = (GetAlarmHistoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.alarmId, other.alarmId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.alarmHistorytype, (Object)other.alarmHistorytype) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.timestampGreaterThanOrEqualTo, other.timestampGreaterThanOrEqualTo) && Objects.equals(this.timestampLessThan, other.timestampLessThan);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.alarmId == null ? 43 : this.alarmId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.alarmHistorytype == null ? 43 : this.alarmHistorytype.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.timestampGreaterThanOrEqualTo == null ? 43 : this.timestampGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timestampLessThan == null ? 43 : this.timestampLessThan.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAlarmHistoryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String alarmId = null;
        private String opcRequestId = null;
        private AlarmHistorytype alarmHistorytype = null;
        private String page = null;
        private Integer limit = null;
        private Date timestampGreaterThanOrEqualTo = null;
        private Date timestampLessThan = null;

        public Builder alarmId(String alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder alarmHistorytype(AlarmHistorytype alarmHistorytype) {
            this.alarmHistorytype = alarmHistorytype;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder timestampGreaterThanOrEqualTo(Date timestampGreaterThanOrEqualTo) {
            this.timestampGreaterThanOrEqualTo = timestampGreaterThanOrEqualTo;
            return this;
        }

        public Builder timestampLessThan(Date timestampLessThan) {
            this.timestampLessThan = timestampLessThan;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAlarmHistoryRequest o) {
            this.alarmId(o.getAlarmId());
            this.opcRequestId(o.getOpcRequestId());
            this.alarmHistorytype(o.getAlarmHistorytype());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.timestampGreaterThanOrEqualTo(o.getTimestampGreaterThanOrEqualTo());
            this.timestampLessThan(o.getTimestampLessThan());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAlarmHistoryRequest build() {
            GetAlarmHistoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAlarmHistoryRequest buildWithoutInvocationCallback() {
            GetAlarmHistoryRequest request = new GetAlarmHistoryRequest();
            request.alarmId = this.alarmId;
            request.opcRequestId = this.opcRequestId;
            request.alarmHistorytype = this.alarmHistorytype;
            request.page = this.page;
            request.limit = this.limit;
            request.timestampGreaterThanOrEqualTo = this.timestampGreaterThanOrEqualTo;
            request.timestampLessThan = this.timestampLessThan;
            return request;
        }
    }

    public static enum AlarmHistorytype implements BmcEnum
    {
        StateHistory("STATE_HISTORY"),
        StateTransitionHistory("STATE_TRANSITION_HISTORY");

        private final String value;
        private static Map<String, AlarmHistorytype> map;

        private AlarmHistorytype(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AlarmHistorytype create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AlarmHistorytype: " + key);
        }

        static {
            map = new HashMap<String, AlarmHistorytype>();
            for (AlarmHistorytype v : AlarmHistorytype.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

