/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAutonomousContainerDatabaseDataguardAssociationRequest
extends BmcRequest<Void> {
    private String autonomousContainerDatabaseId;
    private String autonomousContainerDatabaseDataguardAssociationId;

    public String getAutonomousContainerDatabaseId() {
        return this.autonomousContainerDatabaseId;
    }

    public String getAutonomousContainerDatabaseDataguardAssociationId() {
        return this.autonomousContainerDatabaseDataguardAssociationId;
    }

    public Builder toBuilder() {
        return new Builder().autonomousContainerDatabaseId(this.autonomousContainerDatabaseId).autonomousContainerDatabaseDataguardAssociationId(this.autonomousContainerDatabaseDataguardAssociationId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousContainerDatabaseId=").append(String.valueOf(this.autonomousContainerDatabaseId));
        sb.append(",autonomousContainerDatabaseDataguardAssociationId=").append(String.valueOf(this.autonomousContainerDatabaseDataguardAssociationId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAutonomousContainerDatabaseDataguardAssociationRequest)) {
            return false;
        }
        GetAutonomousContainerDatabaseDataguardAssociationRequest other = (GetAutonomousContainerDatabaseDataguardAssociationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousContainerDatabaseId, other.autonomousContainerDatabaseId) && Objects.equals(this.autonomousContainerDatabaseDataguardAssociationId, other.autonomousContainerDatabaseDataguardAssociationId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousContainerDatabaseId == null ? 43 : this.autonomousContainerDatabaseId.hashCode());
        result = result * 59 + (this.autonomousContainerDatabaseDataguardAssociationId == null ? 43 : this.autonomousContainerDatabaseDataguardAssociationId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAutonomousContainerDatabaseDataguardAssociationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousContainerDatabaseId = null;
        private String autonomousContainerDatabaseDataguardAssociationId = null;

        public Builder autonomousContainerDatabaseId(String autonomousContainerDatabaseId) {
            this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
            return this;
        }

        public Builder autonomousContainerDatabaseDataguardAssociationId(String autonomousContainerDatabaseDataguardAssociationId) {
            this.autonomousContainerDatabaseDataguardAssociationId = autonomousContainerDatabaseDataguardAssociationId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAutonomousContainerDatabaseDataguardAssociationRequest o) {
            this.autonomousContainerDatabaseId(o.getAutonomousContainerDatabaseId());
            this.autonomousContainerDatabaseDataguardAssociationId(o.getAutonomousContainerDatabaseDataguardAssociationId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAutonomousContainerDatabaseDataguardAssociationRequest build() {
            GetAutonomousContainerDatabaseDataguardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAutonomousContainerDatabaseDataguardAssociationRequest buildWithoutInvocationCallback() {
            GetAutonomousContainerDatabaseDataguardAssociationRequest request = new GetAutonomousContainerDatabaseDataguardAssociationRequest();
            request.autonomousContainerDatabaseId = this.autonomousContainerDatabaseId;
            request.autonomousContainerDatabaseDataguardAssociationId = this.autonomousContainerDatabaseDataguardAssociationId;
            return request;
        }
    }
}

